/*
 * Decompiled with CFR 0.152.
 */
package at.orz.hash;

import java.math.BigInteger;

public class EncodeUtils {
    public static final LittleEndianReader LEReader = new LittleEndianReader();
    public static final BigEndianReader BEReader = new BigEndianReader();

    public static int toIntBE(byte[] b, int i) {
        return ((b[i + 0] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + ((b[i + 3] & 0xFF) << 0);
    }

    public static int toIntLE(byte[] b, int i) {
        return ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + ((b[i + 0] & 0xFF) << 0);
    }

    public static long toLongBE(byte[] b, int i) {
        return ((long)b[i + 0] << 56) + ((long)(b[i + 1] & 0xFF) << 48) + ((long)(b[i + 2] & 0xFF) << 40) + ((long)(b[i + 3] & 0xFF) << 32) + ((long)(b[i + 4] & 0xFF) << 24) + (long)((b[i + 5] & 0xFF) << 16) + (long)((b[i + 6] & 0xFF) << 8) + (long)((b[i + 7] & 0xFF) << 0);
    }

    public static long toLongLE(byte[] b, int i) {
        return ((long)b[i + 7] << 56) + ((long)(b[i + 6] & 0xFF) << 48) + ((long)(b[i + 5] & 0xFF) << 40) + ((long)(b[i + 4] & 0xFF) << 32) + ((long)(b[i + 3] & 0xFF) << 24) + (long)((b[i + 2] & 0xFF) << 16) + (long)((b[i + 1] & 0xFF) << 8) + (long)((b[i + 0] & 0xFF) << 0);
    }

    public static byte[] toBytesBE(long v) {
        return new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
    }

    public static byte[] toBytesBE(int v) {
        return new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
    }

    public static long toUnsigned(int value) {
        return 0xFFFFFFFFL & (long)value;
    }

    public static BigInteger toUnsigned(long value) {
        byte[] v = EncodeUtils.toBytesBE(value);
        byte[] vv = new byte[v.length + 1];
        System.arraycopy(v, 0, vv, 1, v.length);
        return new BigInteger(vv);
    }

    public static BigInteger toUnsigned(int[] values) {
        byte[] buffer = new byte[values.length * 4 + 1];
        for (int i = 0; i < values.length; ++i) {
            byte[] ival = EncodeUtils.toBytesBE(values[i]);
            System.arraycopy(ival, 0, buffer, i * 4 + 1, 4);
        }
        return new BigInteger(buffer);
    }

    public static BigInteger toUnsigned(long[] values) {
        byte[] buffer = new byte[values.length * 8 + 1];
        for (int i = 0; i < values.length; ++i) {
            byte[] ival = EncodeUtils.toBytesBE(values[i]);
            System.arraycopy(ival, 0, buffer, i * 8 + 1, 8);
        }
        return new BigInteger(buffer);
    }

    private static class BigEndianReader
    implements EndianReader {
        private BigEndianReader() {
        }

        @Override
        public int toInt(byte[] b, int i) {
            return EncodeUtils.toIntBE(b, i);
        }

        @Override
        public long toLong(byte[] b, int i) {
            return EncodeUtils.toLongBE(b, i);
        }
    }

    private static class LittleEndianReader
    implements EndianReader {
        private LittleEndianReader() {
        }

        @Override
        public int toInt(byte[] b, int i) {
            return EncodeUtils.toIntLE(b, i);
        }

        @Override
        public long toLong(byte[] b, int i) {
            return EncodeUtils.toLongLE(b, i);
        }
    }

    public static interface EndianReader {
        public int toInt(byte[] var1, int var2);

        public long toLong(byte[] var1, int var2);
    }
}

