/*
 * Decompiled with CFR 0.152.
 */
package at.orz.hash;

import at.orz.hash.EncodeUtils;

public class XXHash {
    private static final int PRIME1 = -1640531535;
    private static final int PRIME2 = -2048144777;
    private static final int PRIME3 = -1028477379;
    private static final int PRIME4 = 668265263;
    private static final int PRIME5 = 374761393;

    public static int digestSmall(byte[] data, int seed, boolean bigendian) {
        int i;
        int len;
        EncodeUtils.EndianReader er = bigendian ? EncodeUtils.BEReader : EncodeUtils.LEReader;
        int bEnd = len = data.length;
        int limit = bEnd - 4;
        int idx = seed + -1640531535;
        int crc = 374761393;
        for (i = 0; i < limit; i += 4) {
            crc += er.toInt(data, i) + idx++;
            crc += Integer.rotateLeft(crc, 17) * 668265263;
            crc *= -1640531535;
        }
        while (i < bEnd) {
            crc += (data[i] & 0xFF) + idx++;
            crc *= -1640531535;
            ++i;
        }
        crc += len;
        crc ^= crc >>> 15;
        crc *= -2048144777;
        crc ^= crc >>> 13;
        crc *= -1028477379;
        crc ^= crc >>> 16;
        return crc;
    }

    public static int digestFastEw(byte[] data, int seed, boolean bigendian) {
        return XXHash.digestFast32(data, seed, data.length, bigendian);
    }

    public static int digestFast32(byte[] data, int seed, int len, boolean bigendian) {
        int i;
        if (len < 16) {
            return XXHash.digestSmall(data, seed, bigendian);
        }
        EncodeUtils.EndianReader er = bigendian ? EncodeUtils.BEReader : EncodeUtils.LEReader;
        int bEnd = len;
        int limit = bEnd - 16;
        int v1 = seed + -1640531535;
        int v2 = v1 * -2048144777 + len;
        int v3 = v2 * -1028477379;
        int v4 = v3 * 668265263;
        int crc = 0;
        for (i = 0; i < limit; i += 4) {
            v1 = Integer.rotateLeft(v1, 13) + er.toInt(data, i);
            v2 = Integer.rotateLeft(v2, 11) + er.toInt(data, i += 4);
            v3 = Integer.rotateLeft(v3, 17) + er.toInt(data, i += 4);
            v4 = Integer.rotateLeft(v4, 19) + er.toInt(data, i += 4);
        }
        i = bEnd - 16;
        v1 += Integer.rotateLeft(v1, 17);
        v2 += Integer.rotateLeft(v2, 19);
        v3 += Integer.rotateLeft(v3, 13);
        v4 += Integer.rotateLeft(v4, 11);
        v1 *= -1640531535;
        v2 *= -1640531535;
        v3 *= -1640531535;
        v4 *= -1640531535;
        v1 += er.toInt(data, i);
        v2 += er.toInt(data, i += 4);
        v3 += er.toInt(data, i += 4);
        v4 += er.toInt(data, i += 4);
        v1 *= -2048144777;
        v2 *= -2048144777;
        v3 *= -2048144777;
        v4 *= -2048144777;
        v1 += Integer.rotateLeft(v1, 11);
        v2 += Integer.rotateLeft(v2, 17);
        v3 += Integer.rotateLeft(v3, 19);
        v4 += Integer.rotateLeft(v4, 13);
        crc = (v1 *= -1028477379) + Integer.rotateLeft(v2 *= -1028477379, 3) + Integer.rotateLeft(v3 *= -1028477379, 6) + Integer.rotateLeft(v4 *= -1028477379, 9);
        crc ^= crc >>> 11;
        crc += (668265263 + len) * -1640531535;
        crc ^= crc >>> 15;
        crc *= -2048144777;
        crc ^= crc >>> 13;
        return crc;
    }

    public static int digestStrong32(byte[] data, int seed, boolean bigendian) {
        int i;
        int len = data.length;
        if (len < 16) {
            return XXHash.digestSmall(data, seed, bigendian);
        }
        EncodeUtils.EndianReader er = bigendian ? EncodeUtils.BEReader : EncodeUtils.LEReader;
        int bEnd = len;
        int limit = bEnd - 16;
        int v1 = seed + -1640531535;
        int v2 = v1 * -2048144777 + len;
        int v3 = v2 * -1028477379;
        int v4 = v3 * 668265263;
        int crc = 0;
        for (i = 0; i < limit; i += 4) {
            v1 += Integer.rotateLeft(v1, 13);
            v1 *= -1640531535;
            v1 += er.toInt(data, i);
            v2 += Integer.rotateLeft(v2, 11);
            v2 *= -1640531535;
            v2 += er.toInt(data, i += 4);
            v3 += Integer.rotateLeft(v3, 17);
            v3 *= -1640531535;
            v3 += er.toInt(data, i += 4);
            v4 += Integer.rotateLeft(v4, 19);
            v4 *= -1640531535;
            v4 += er.toInt(data, i += 4);
        }
        i = bEnd - 16;
        v1 += Integer.rotateLeft(v1, 17);
        v2 += Integer.rotateLeft(v2, 19);
        v3 += Integer.rotateLeft(v3, 13);
        v4 += Integer.rotateLeft(v4, 11);
        v1 *= -1640531535;
        v2 *= -1640531535;
        v3 *= -1640531535;
        v4 *= -1640531535;
        v1 += er.toInt(data, i);
        v2 += er.toInt(data, i += 4);
        v3 += er.toInt(data, i += 4);
        v4 += er.toInt(data, i += 4);
        v1 *= -2048144777;
        v2 *= -2048144777;
        v3 *= -2048144777;
        v4 *= -2048144777;
        v1 += Integer.rotateLeft(v1, 11);
        v2 += Integer.rotateLeft(v2, 17);
        v3 += Integer.rotateLeft(v3, 19);
        v4 += Integer.rotateLeft(v4, 13);
        crc = (v1 *= -1028477379) + Integer.rotateLeft(v2 *= -1028477379, 3) + Integer.rotateLeft(v3 *= -1028477379, 6) + Integer.rotateLeft(v4 *= -1028477379, 9);
        crc ^= crc >>> 11;
        crc += (668265263 + len) * -1640531535;
        crc ^= crc >>> 15;
        crc *= -2048144777;
        crc ^= crc >>> 13;
        return crc;
    }

    public static void main(String[] args) {
        System.out.println(-1640531535);
    }
}

