/*
 * Decompiled with CFR 0.152.
 */
package me.aurous.models.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import me.aurous.models.download.DownloadResult;

public class Downloader {
    public Progress download(URL source, File destination, DownloadResult callback) {
        System.out.println(destination.toString());
        Progress progress = new Progress();
        new Thread(() -> {
            long start = System.currentTimeMillis();
            File temp = new File(destination.toString());
            temp.mkdirs();
            temp.delete();
            try {
                progress.start = start;
                HttpURLConnection con = (HttpURLConnection)source.openConnection();
                String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36";
                con.setRequestProperty("User-Agent", USER_AGENT);
                progress.responsecode = con.getResponseCode();
                progress.total = con.getContentLength();
                if (progress.total == 0) {
                    progress.total = 1;
                }
                InputStream in = con.getInputStream();
                FileOutputStream out = new FileOutputStream(temp);
                int r = 0;
                byte[] b = new byte[Short.MAX_VALUE];
                progress.lastRateCheck = System.currentTimeMillis();
                while ((r = in.read(b)) > -1) {
                    out.write(b, 0, r);
                    progress.have = progress.have + r;
                    progress.rateincr = progress.rateincr + r;
                }
                in.close();
                out.close();
                callback.finished(System.currentTimeMillis() - start);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }).start();
        return progress;
    }

    public class Progress {
        private int total = 1;
        private int have = 0;
        private final float progress = 0.0f;
        private int rate = 0;
        private int rateincr = 0;
        private long start = 0L;
        private long lastRateCheck;
        private int responsecode = 0;

        public float getProgress() {
            return (float)this.have / (float)this.total;
        }

        public int getDownloadRate() {
            long now = System.currentTimeMillis();
            long t = now - this.lastRateCheck;
            if (t >= 1000L) {
                float rmod = (float)t / 1000.0f;
                this.rate = (int)((float)this.rateincr / rmod);
                this.lastRateCheck = now;
                this.rateincr = 0;
            }
            return this.rate;
        }

        public int getTotalSize() {
            return this.total;
        }

        public long getDownloadStartSystemTime() {
            return this.start;
        }
    }
}

