/*
 * Decompiled with CFR 0.152.
 */
package me.aurous.updater;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import me.aurous.updater.DynamicUpdater;
import me.aurous.updater.UpdateResult;

public class BlockingChecker {
    static DynamicUpdater.Progress progress;
    public static JFrame update;
    static UpdateResult result;
    static boolean working;

    public static void rebase(String folder, String json) throws IOException, NoSuchAlgorithmException {
        DynamicUpdater updater = new DynamicUpdater();
        updater.addExclude("windows", "linux", "mac", "jre", "Aurous.exe");
        updater.setUpdateDirectory(new File(folder));
        updater.rebase(new File(json));
    }

    public static void check() {
        DynamicUpdater updater = new DynamicUpdater();
        updater.addExclude("windows", "linux", "mac", "jre", "Aurous.exe", "Aurous.jar");
        updater.setUpdateDirectory(new File("./"));
        progress = updater.update("https://aurous.me/updates/", result);
        while (working) {
            try {
                Thread.sleep(32L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BlockingChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        result = new UpdateResult(){
            Runnable repaint;
            int have = 0;
            float total = 1.0f;
            String file = "";

            @Override
            public void finished(long time, boolean updated) {
                System.out.println("Update finished");
                working = false;
            }

            @Override
            public void failed(long time, Exception exception) {
                System.out.println("Update failed!");
                exception.printStackTrace();
                working = false;
            }

            @Override
            public void started() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.setProperty("awt.useSystemAAFontSettings", "on");
                        System.setProperty("swing.aatext", "true");
                        update = new JFrame("Aurous is updating...");
                        try {
                            update.setIconImage(ImageIO.read(BlockingChecker.class.getResourceAsStream("/logo.png")));
                        }
                        catch (IOException ex) {
                            Logger.getLogger(BlockingChecker.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        update.add(new Component(){
                            {
                                repaint = new Runnable(){

                                    @Override
                                    public void run() {
                                        this.repaint();
                                    }
                                };
                                Dimension size = new Dimension(788, 27);
                                this.setSize(size);
                                this.setPreferredSize(size);
                            }

                            @Override
                            public void paint(Graphics g) {
                                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                g.setColor(new Color(31, 32, 46));
                                g.fillRect(0, 0, 800, 100);
                                g.setColor(new Color(80, 80, 85));
                                g.fillRoundRect(4, 24, 788, 8, 8, 8);
                                if (BlockingChecker.progress.current != null) {
                                    g.setColor(Color.WHITE);
                                    g.drawString("Updating: " + file, 10, 18);
                                }
                                int width = (int)(788.0f * ((float)have / total));
                                g.setColor(new Color(190, 190, 190));
                                g.fillRoundRect(4, 24, width, 8, 8, 8);
                                g.setColor(new Color(227, 227, 227));
                                g.fillRoundRect(4, 24, width, 6, 8, 8);
                            }
                        });
                        update.pack();
                        update.setLocationRelativeTo(null);
                        update.setDefaultCloseOperation(3);
                        update.setResizable(false);
                        update.setVisible(true);
                    }
                });
            }

            @Override
            public void fileFinished(String next, int index, int total) {
                this.have = index;
                this.total = total;
                this.file = next;
                if (this.repaint != null) {
                    EventQueue.invokeLater(this.repaint);
                }
                System.out.println("Updated " + index + " / " + total + " next: " + next);
            }
        };
        working = true;
    }
}

