/*
 * Decompiled with CFR 0.152.
 */
package me.aurous.updater;

import at.orz.hash.XXHash;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import me.aurous.local.settings.GSONHelper;
import me.aurous.models.download.DownloadResult;
import me.aurous.models.download.Downloader;
import me.aurous.updater.UpdateResult;

public class DynamicUpdater {
    GSONHelper helper = new GSONHelper();
    ArrayList<File> tracked = new ArrayList();
    ArrayList<String> nowrite = new ArrayList();
    ArrayList<String> exclude = new ArrayList();
    String root = "";
    Progress progress = new Progress();
    Downloader downloader = new Downloader();
    public static final String UPDATE_REMOTE_HASHLIST = "update.json";
    public static final String UPDATE_REMOTE_DIR = "data/";
    final int seed = -559038737;
    final ArrayList<String> needUpdate = new ArrayList();
    final DownloadResult updater = new DownloadResult(){
        int index = 0;

        @Override
        public void finished(long time) {
            if (this.index < DynamicUpdater.this.total) {
                try {
                    String file = DynamicUpdater.this.needUpdate.get(this.index);
                    DynamicUpdater.this.result.fileFinished(file, this.index, DynamicUpdater.this.total);
                    File to = DynamicUpdater.this.nowrite.contains(file) ? new File(DynamicUpdater.this.root + file + ".update") : new File(DynamicUpdater.this.root + file);
                    DynamicUpdater.this.progress.current = DynamicUpdater.this.downloader.download(new URL(DynamicUpdater.this.baseURL + DynamicUpdater.UPDATE_REMOTE_DIR + file.replace("\\", "/")), to, DynamicUpdater.this.updater);
                    DynamicUpdater.this.progress.currentFile = file;
                    DynamicUpdater.this.progress.at = this.index;
                }
                catch (MalformedURLException ex) {
                    DynamicUpdater.this.result.failed(time, ex);
                }
                ++this.index;
            } else {
                DynamicUpdater.this.result.fileFinished("", this.index, DynamicUpdater.this.total);
                DynamicUpdater.this.result.finished(System.currentTimeMillis() - DynamicUpdater.this.startTime, true);
            }
        }

        @Override
        public void failed(long time, IOException exception, int responseCode) {
            DynamicUpdater.this.result.failed(time, exception);
        }
    };
    int total = 0;
    String baseURL;
    UpdateResult result;
    long startTime = 0L;

    public void setUpdateDirectory(File f) {
        this.root = f.toString();
        char c = this.root.charAt(this.root.length() - 1);
        if (c != '/' && c != '\\' && c != File.separatorChar) {
            this.root = this.root + File.separator;
        }
        this.addAll(f);
    }

    private void addAll(File f) {
        if (this.exclude.contains(f.getName())) {
            return;
        }
        for (File file : f.listFiles()) {
            if (file.isDirectory()) {
                this.addAll(file);
                continue;
            }
            if (this.exclude.contains(f.getName())) continue;
            this.tracked.add(file);
        }
    }

    public void reset() {
        this.tracked.clear();
        this.exclude.clear();
    }

    public void addNonWritable(String name) {
        this.nowrite.add(name);
    }

    private UpdateData getCurrentData() throws NoSuchAlgorithmException, IOException {
        UpdateData data = new UpdateData();
        for (File f : this.tracked) {
            data.hashes.put(f.toString().substring(this.root.length()).replace("\\", "/"), this.getHash(f));
        }
        return data;
    }

    void addExclude(String ... excludes) {
        for (String s : excludes) {
            this.exclude.add(s);
        }
    }

    public String getHash(File f) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(f);
        long hash = 0L;
        int r = 0;
        byte[] b = new byte[Short.MAX_VALUE];
        while ((r = in.read(b)) > -1) {
            hash += (long)XXHash.digestFast32(b, -559038737, r, true);
        }
        return Long.toHexString(hash).toUpperCase();
    }

    public void rebase(File hashlist) throws IOException, NoSuchAlgorithmException {
        UpdateData data = this.getCurrentData();
        this.helper.saveClass(new FileOutputStream(hashlist), data, (Type)((Object)UpdateData.class));
    }

    public InputStream getHashlistInputStream() throws MalformedURLException, IOException {
        HttpsURLConnection con = (HttpsURLConnection)new URL(this.baseURL + UPDATE_REMOTE_HASHLIST).openConnection();
        String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36";
        con.setRequestProperty("User-Agent", USER_AGENT);
        return con.getInputStream();
    }

    public Progress update(String baseURL, UpdateResult result) {
        try {
            this.startTime = System.currentTimeMillis();
            this.baseURL = baseURL;
            this.result = result;
            UpdateData remote = (UpdateData)this.helper.loadClass(this.getHashlistInputStream(), (Type)((Object)UpdateData.class));
            UpdateData current = this.getCurrentData();
            this.needUpdate.clear();
            for (String file : remote.hashes.keySet()) {
                if (remote.hashes.get(file).equals(current.hashes.get(file))) continue;
                System.out.println(file + " needs update, " + remote.hashes.get(file) + " != " + current.hashes.get(file));
                if (this.exclude.contains(file.substring(file.lastIndexOf(47) + 1))) continue;
                this.needUpdate.add(file);
            }
            this.progress.count = this.total = this.needUpdate.size();
            if (this.needUpdate.size() > 0) {
                result.started();
                String file = this.needUpdate.get(0);
                File to = this.nowrite.contains(file) ? new File(this.root + file + ".update") : new File(this.root + file);
                this.progress.current = this.downloader.download(new URL(baseURL + UPDATE_REMOTE_DIR + file.replace("\\", "/")), to, this.updater);
            } else {
                result.finished(0L, false);
            }
        }
        catch (IOException ex) {
            result.failed(0L, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            result.failed(0L, ex);
        }
        return this.progress;
    }

    class UpdateData {
        HashMap<String, String> hashes = new HashMap();

        UpdateData() {
        }
    }

    class Progress {
        Downloader.Progress current;
        String currentFile;
        int count = 0;
        int at = 0;

        Progress() {
        }

        public float getProgress() {
            return (float)this.at / (float)this.count;
        }

        public String getCurrentFile() {
            return this.currentFile;
        }

        public Downloader.Progress getCurrentFileProgress() {
            return this.current;
        }
    }
}

