/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d;

import com.eteks.sweethome3d.HomeFrameController;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class HomeFramePane
extends JRootPane
implements View {
    private static final String FRAME_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameX";
    private static final String FRAME_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameY";
    private static final String FRAME_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameWidth";
    private static final String FRAME_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameHeight";
    private static final String FRAME_MAXIMIZED_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameMaximized";
    private static final String SCREEN_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ScreenWidth";
    private static final String SCREEN_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ScreenHeight";
    private final Home home;
    private final HomeApplication application;
    private final ContentManager contentManager;
    private final HomeFrameController controller;
    private static int newHomeCount;
    private int newHomeNumber;

    public HomeFramePane(Home home, HomeApplication homeApplication, ContentManager contentManager, HomeFrameController homeFrameController) {
        this.home = home;
        this.controller = homeFrameController;
        this.application = homeApplication;
        this.contentManager = contentManager;
        if (home.getName() == null) {
            this.newHomeNumber = ++newHomeCount;
        }
        HomeView homeView = this.controller.getHomeController().getView();
        this.setContentPane((JComponent)((Object)homeView));
    }

    public void displayView() {
        JFrame jFrame = new JFrame(){
            {
                this.setRootPane(HomeFramePane.this);
            }
        };
        Image[] imageArray = new Image[]{new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon.png")).getImage(), new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon32x32.png")).getImage()};
        try {
            jFrame.getClass().getMethod("setIconImages", List.class).invoke((Object)jFrame, Arrays.asList(imageArray));
        }
        catch (Exception exception) {
            jFrame.setIconImage(imageArray[0]);
        }
        this.updateFrameTitle(jFrame, this.home, this.application);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.computeFrameBounds(this.home, jFrame);
        this.getToolkit().setDynamicLayout(true);
        HomeView homeView = this.controller.getHomeController().getView();
        if (homeView instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)((Object)homeView);
            this.setJMenuBar(jRootPane.getJMenuBar());
            jRootPane.setJMenuBar(null);
        }
        this.addListeners(this.home, this.application, this.controller.getHomeController(), jFrame);
        jFrame.setVisible(true);
    }

    private void addListeners(final Home home, final HomeApplication homeApplication, final HomeController homeController, final JFrame jFrame) {
        jFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if ((jFrame.getExtendedState() & 6) != 6) {
                    homeController.setVisualProperty(HomeFramePane.FRAME_WIDTH_VISUAL_PROPERTY, jFrame.getWidth());
                    homeController.setVisualProperty(HomeFramePane.FRAME_HEIGHT_VISUAL_PROPERTY, jFrame.getHeight());
                }
                Dimension dimension = HomeFramePane.this.getUserScreenSize();
                homeController.setVisualProperty(HomeFramePane.SCREEN_WIDTH_VISUAL_PROPERTY, dimension.width);
                homeController.setVisualProperty(HomeFramePane.SCREEN_HEIGHT_VISUAL_PROPERTY, dimension.height);
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if ((jFrame.getExtendedState() & 6) != 6) {
                    homeController.setVisualProperty(HomeFramePane.FRAME_X_VISUAL_PROPERTY, jFrame.getX());
                    homeController.setVisualProperty(HomeFramePane.FRAME_Y_VISUAL_PROPERTY, jFrame.getY());
                }
            }
        });
        jFrame.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){
            private Component mostRecentFocusOwner;

            public void windowStateChanged(WindowEvent windowEvent) {
                homeController.setVisualProperty(HomeFramePane.FRAME_MAXIMIZED_VISUAL_PROPERTY, (jFrame.getExtendedState() & 6) == 6);
            }

            public void windowClosing(WindowEvent windowEvent) {
                homeController.close();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                Component component = jFrame.getMostRecentFocusOwner();
                if (!(component instanceof JFrame) && component != null) {
                    this.mostRecentFocusOwner = component;
                }
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (this.mostRecentFocusOwner != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            mostRecentFocusOwner.requestFocusInWindow();
                        }
                    });
                }
            }
        };
        jFrame.addWindowListener(windowAdapter);
        jFrame.addWindowStateListener(windowAdapter);
        homeApplication.getUserPreferences().addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(jFrame, this));
        homeApplication.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getItem() == home && collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    homeApplication.removeHomesListener(this);
                    jFrame.dispose();
                }
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFramePane.this.updateFrameTitle(jFrame, home, homeApplication);
            }
        };
        home.addPropertyChangeListener(Home.Property.NAME, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.MODIFIED, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.RECOVERED, propertyChangeListener);
    }

    private void computeFrameBounds(Home home, final JFrame jFrame) {
        Integer n = (Integer)home.getVisualProperty(FRAME_X_VISUAL_PROPERTY);
        Integer n2 = (Integer)home.getVisualProperty(FRAME_Y_VISUAL_PROPERTY);
        Integer n3 = (Integer)home.getVisualProperty(FRAME_WIDTH_VISUAL_PROPERTY);
        Integer n4 = (Integer)home.getVisualProperty(FRAME_HEIGHT_VISUAL_PROPERTY);
        Boolean bl = (Boolean)home.getVisualProperty(FRAME_MAXIMIZED_VISUAL_PROPERTY);
        Integer n5 = (Integer)home.getVisualProperty(SCREEN_WIDTH_VISUAL_PROPERTY);
        Integer n6 = (Integer)home.getVisualProperty(SCREEN_HEIGHT_VISUAL_PROPERTY);
        Dimension dimension = this.getUserScreenSize();
        if (n != null && n2 != null && n3 != null && n4 != null && n5 != null && n6 != null && n5 >= dimension.width && n6 >= dimension.height) {
            final Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            if (bl != null && bl.booleanValue()) {
                Insets insets = jFrame.getInsets();
                jFrame.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.bottom);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        jFrame.setBounds(rectangle);
                        jFrame.setExtendedState(6);
                    }
                });
            } else {
                jFrame.setBounds(rectangle);
            }
        } else {
            jFrame.setLocationByPlatform(true);
            jFrame.pack();
            jFrame.setSize(Math.min(dimension.width * 4 / 5, jFrame.getWidth()), Math.min(dimension.height * 4 / 5, jFrame.getHeight()));
        }
    }

    private Dimension getUserScreenSize() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        return dimension;
    }

    private void updateFrameTitle(JFrame jFrame, Home home, HomeApplication homeApplication) {
        String string;
        String string2 = home.getName();
        if (string2 == null) {
            string = homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "untitled", new Object[0]);
            if (this.newHomeNumber > 1) {
                string = string + " " + this.newHomeNumber;
            }
        } else {
            string = this.contentManager.getPresentationName(string2, ContentManager.ContentType.SWEET_HOME_3D);
        }
        if (home.isRecovered()) {
            string = string + " " + homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "recovered", new Object[0]);
        }
        String string3 = string;
        if (OperatingSystem.isMacOSX()) {
            Boolean bl = home.isModified() || home.isRecovered();
            this.putClientProperty("windowModified", bl);
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                File file;
                this.putClientProperty("Window.documentModified", bl);
                if (string2 != null && (file = new File(string2)).exists()) {
                    this.putClientProperty("Window.documentFile", file);
                }
            }
        } else {
            string3 = string3 + " - " + homeApplication.getName();
            if (home.isModified() || home.isRecovered()) {
                string3 = "* " + string3;
            }
        }
        jFrame.setTitle(string3);
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<JFrame> frame;
        private WeakReference<HomeFramePane> homeFramePane;

        public LanguageChangeListener(JFrame jFrame, HomeFramePane homeFramePane) {
            this.frame = new WeakReference<JFrame>(jFrame);
            this.homeFramePane = new WeakReference<HomeFramePane>(homeFramePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeFramePane homeFramePane = (HomeFramePane)this.homeFramePane.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (homeFramePane == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                ((JFrame)this.frame.get()).applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                homeFramePane.updateFrameTitle((JFrame)this.frame.get(), homeFramePane.home, homeFramePane.application);
            }
        }
    }
}

