/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;

public class DefaultHomeInputStream
extends FilterInputStream {
    private File tempFile;

    public DefaultHomeInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Home readHome() throws IOException, ClassNotFoundException {
        Object object;
        this.tempFile = OperatingSystem.createTemporaryFile("open", ".sweethome3d");
        DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(this.tempFile);
            object = new byte[8192];
            while ((n = this.in.read((byte[])object)) != -1) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
            }
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        object = null;
        try {
            object = new ZipInputStream(new FileInputStream(this.tempFile));
            ((ZipInputStream)object).getNextEntry();
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            HomeObjectInputStream homeObjectInputStream = new HomeObjectInputStream((InputStream)object);
            Home home = (Home)homeObjectInputStream.readObject();
            return home;
        }
        finally {
            if (object != null) {
                ((ZipInputStream)object).close();
            }
        }
    }

    private class HomeObjectInputStream
    extends ObjectInputStream {
        public HomeObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object object) throws IOException {
            if (object instanceof URLContent) {
                URL uRL = ((URLContent)object).getURL();
                String string = uRL.toString();
                if (string.startsWith("jar:file:temp!/")) {
                    URL uRL2 = new URL("jar:file:" + DefaultHomeInputStream.this.tempFile.toString() + string.substring(string.indexOf(33)));
                    return new HomeURLContent(uRL2);
                }
                return object;
            }
            return object;
        }
    }
}

