/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.IllegalHomonymException;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTexturesCatalog
extends TexturesCatalog {
    private static final String PLUGIN_TEXTURES_CATALOG_FAMILY = "PluginTexturesCatalog";
    private static final String ADDITIONAL_TEXTURES_CATALOG_FAMILY = "AdditionalTexturesCatalog";
    private static final String HOMONYM_TEXTURE_FORMAT = "%s -%d-";
    private static final Map<File, URL> pluginTexturesCatalogUrlUpdates = new HashMap<File, URL>();

    public DefaultTexturesCatalog() {
        this((File)null);
    }

    public DefaultTexturesCatalog(File file) {
        this(null, file);
    }

    public DefaultTexturesCatalog(UserPreferences userPreferences, File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(userPreferences, fileArray);
    }

    public DefaultTexturesCatalog(UserPreferences userPreferences, File[] fileArray) {
        HashMap<TexturesCategory, Map<CatalogTexture, Integer>> hashMap = new HashMap<TexturesCategory, Map<CatalogTexture, Integer>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = DefaultTexturesCatalog.class.getName();
        this.readTexturesCatalog(string, userPreferences, hashMap, arrayList);
        String string2 = string.substring(0, string.lastIndexOf("."));
        this.readTexturesCatalog(string2 + "." + ADDITIONAL_TEXTURES_CATALOG_FAMILY, userPreferences, hashMap, arrayList);
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder());
                for (File file2 : fileArray2) {
                    this.readPluginTexturesCatalog(file2, hashMap, arrayList);
                }
            }
        }
    }

    public DefaultTexturesCatalog(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DefaultTexturesCatalog(URL[] uRLArray, URL uRL) {
        HashMap<TexturesCategory, Map<CatalogTexture, Integer>> hashMap = new HashMap<TexturesCategory, Map<CatalogTexture, Integer>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URL uRL2 : uRLArray) {
            try {
                this.readTextures(ResourceBundle.getBundle(PLUGIN_TEXTURES_CATALOG_FAMILY, Locale.getDefault(), new URLClassLoader(new URL[]{uRL2})), uRL2, uRL, hashMap, arrayList);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void readPluginTexturesCatalog(File file, Map<TexturesCategory, Map<CatalogTexture, Integer>> map, List<String> list) {
        try {
            Object object;
            URL uRL = file.toURI().toURL();
            long l = file.lastModified();
            URL uRL2 = pluginTexturesCatalogUrlUpdates.get(file);
            boolean bl = file.canWrite();
            if (bl && (uRL2 == null || uRL2.openConnection().getLastModified() < l)) {
                object = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(uRL));
                URL uRL3 = ((URLContent)object).getURL();
                pluginTexturesCatalogUrlUpdates.put(file, uRL3);
                uRL = uRL3;
            } else if (uRL2 != null) {
                uRL = uRL2;
            }
            object = ResourceBundle.getBundle(PLUGIN_TEXTURES_CATALOG_FAMILY, Locale.getDefault(), new URLClassLoader(new URL[]{uRL}));
            this.readTextures((ResourceBundle)object, uRL, null, map, list);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readTexturesCatalog(final String string, final UserPreferences userPreferences, Map<TexturesCategory, Map<CatalogTexture, Integer>> map, List<String> list) {
        ResourceBundle resourceBundle;
        if (userPreferences != null) {
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string2) {
                    try {
                        return userPreferences.getLocalizedString(string, string2, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MissingResourceException("Unknown key " + string2, string + "_" + Locale.getDefault(), string2);
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        this.readTextures(resourceBundle, null, null, map, list);
    }

    private void readTextures(ResourceBundle resourceBundle, URL uRL, URL uRL2, Map<TexturesCategory, Map<CatalogTexture, Integer>> map, List<String> list) {
        int n = 1;
        while (true) {
            block6: {
                CatalogTexture catalogTexture;
                String string;
                block5: {
                    String string2 = null;
                    try {
                        string2 = resourceBundle.getString(PropertyKey.NAME.getKey(n));
                    }
                    catch (MissingResourceException missingResourceException) {
                        break;
                    }
                    string = resourceBundle.getString(PropertyKey.CATEGORY.getKey(n));
                    Content content = this.getContent(resourceBundle, PropertyKey.IMAGE.getKey(n), uRL, uRL2);
                    float f = Float.parseFloat(resourceBundle.getString(PropertyKey.WIDTH.getKey(n)));
                    float f2 = Float.parseFloat(resourceBundle.getString(PropertyKey.HEIGHT.getKey(n)));
                    String string3 = this.getOptionalString(resourceBundle, PropertyKey.CREATOR.getKey(n));
                    String string4 = this.getOptionalString(resourceBundle, PropertyKey.ID.getKey(n));
                    catalogTexture = new CatalogTexture(string4, string2, content, f, f2, string3);
                    if (catalogTexture.getId() == null) break block5;
                    if (list.contains(catalogTexture.getId())) break block6;
                    list.add(catalogTexture.getId());
                }
                this.add(new TexturesCategory(string), catalogTexture, map);
            }
            ++n;
        }
    }

    private void add(TexturesCategory texturesCategory, CatalogTexture catalogTexture, Map<TexturesCategory, Map<CatalogTexture, Integer>> map) {
        try {
            this.add(texturesCategory, catalogTexture);
        }
        catch (IllegalHomonymException illegalHomonymException) {
            Integer n;
            Map<CatalogTexture, Integer> map2 = map.get(texturesCategory);
            if (map2 == null) {
                map2 = new HashMap<CatalogTexture, Integer>();
                map.put(texturesCategory, map2);
            }
            if ((n = map2.get(catalogTexture)) == null) {
                n = 1;
            }
            n = n + 1;
            map2.put(catalogTexture, n);
            catalogTexture = new CatalogTexture(String.format(HOMONYM_TEXTURE_FORMAT, catalogTexture.getName(), n), catalogTexture.getImage(), catalogTexture.getWidth(), catalogTexture.getHeight());
            this.add(texturesCategory, catalogTexture, map);
        }
    }

    private Content getContent(ResourceBundle resourceBundle, String string, URL uRL, URL uRL2) {
        String string2 = resourceBundle.getString(string);
        try {
            URL uRL3 = uRL2 != null ? new URL(uRL2, string2) : new URL(string2);
            return new URLContent(uRL3);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                return new ResourceURLContent(DefaultTexturesCatalog.class, string2);
            }
            try {
                return new URLContent(new URL("jar:" + uRL + "!" + string2));
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid URL", malformedURLException2);
            }
        }
    }

    private String getOptionalString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        ID("id"),
        NAME("name"),
        CATEGORY("category"),
        IMAGE("image"),
        WIDTH("width"),
        HEIGHT("height"),
        CREATOR("creator");

        private String keyPrefix;

        private PropertyKey(String string2) {
            this.keyPrefix = string2;
        }

        public String getKey(int n) {
            return this.keyPrefix + "#" + n;
        }
    }
}

