/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultHomeInputStream;
import com.eteks.sweethome3d.io.DefaultHomeOutputStream;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class HomeFileRecorder
implements HomeRecorder {
    private final int compressionLevel;
    private final boolean includeOnlyTemporaryContent;

    public HomeFileRecorder() {
        this(0);
    }

    public HomeFileRecorder(int n) {
        this(n, false);
    }

    public HomeFileRecorder(int n, boolean bl) {
        this.compressionLevel = n;
        this.includeOnlyTemporaryContent = bl;
    }

    public void writeHome(Home home, String string) throws RecorderException {
        FileOutputStream fileOutputStream;
        File file = new File(string);
        if (file.exists() && !file.canWrite()) {
            throw new RecorderException("Can't write over file " + string);
        }
        FilterOutputStream filterOutputStream = null;
        File file2 = null;
        try {
            file2 = OperatingSystem.createTemporaryFile("save", ".sweethome3d");
            filterOutputStream = new DefaultHomeOutputStream(new FileOutputStream(file2), this.compressionLevel, this.includeOnlyTemporaryContent);
            ((DefaultHomeOutputStream)filterOutputStream).writeHome(home);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedRecorderException("Save " + string + " interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't save home " + string, iOException);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close temporary file " + string, iOException);
            }
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file2 != null) {
                file2.delete();
            }
            throw new RecorderException("Can't save file " + string, fileNotFoundException);
        }
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file2);
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't copy file " + file2 + " to " + string);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close file " + string, iOException);
            }
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                    file2.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Home readHome(String string) throws RecorderException {
        FilterInputStream filterInputStream = null;
        try {
            Home home;
            filterInputStream = new DefaultHomeInputStream(new FileInputStream(string));
            Home home2 = home = ((DefaultHomeInputStream)filterInputStream).readHome();
            return home2;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedRecorderException("Read " + string + " interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't read home from " + string, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RecorderException("Missing classes to read home from " + string, classNotFoundException);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close file " + string, iOException);
            }
        }
    }

    public boolean exists(String string) throws RecorderException {
        return new File(string).exists();
    }
}

