/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.sun.j3d.utils.geometry.Box;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePieceOfFurniture3D
extends Object3DBranch {
    private static final TransparencyAttributes DEFAULT_TEXTURED_SHAPE_TRANSPARENCY_ATTRIBUTES = new TransparencyAttributes(1, 0.0f);
    private static final PolygonAttributes DEFAULT_TEXTURED_SHAPE_POLYGON_ATTRIBUTES = new PolygonAttributes(2, 0, 0.0f);
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private final Home home;

    public HomePieceOfFurniture3D(HomePieceOfFurniture homePieceOfFurniture, Home home) {
        this(homePieceOfFurniture, home, false, false);
    }

    public HomePieceOfFurniture3D(HomePieceOfFurniture homePieceOfFurniture, Home home, boolean bl, boolean bl2) {
        this.setUserData(homePieceOfFurniture);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                this.addChild((Node)new HomePieceOfFurniture3D(homePieceOfFurniture2, home, bl, bl2));
            }
        } else {
            this.createPieceOfFurnitureNode(homePieceOfFurniture, bl, bl2);
        }
    }

    private void createPieceOfFurnitureNode(final HomePieceOfFurniture homePieceOfFurniture, final boolean bl, final boolean bl2) {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        this.addChild((Node)transformGroup);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.addChild(this.getModelBox(Color.WHITE));
        this.setModelCapabilities((Node)branchGroup);
        transformGroup.addChild((Node)branchGroup);
        this.updatePieceOfFurnitureTransform();
        Content content = homePieceOfFurniture.getModel();
        ModelManager.getInstance().loadModel(content, bl2, new ModelManager.ModelObserver(){

            public void modelUpdated(BranchGroup branchGroup) {
                float[][] fArray = homePieceOfFurniture.getModelRotation();
                TransformGroup transformGroup = ModelManager.getInstance().getNormalizedTransformGroup((Node)branchGroup, fArray, 1.0f);
                HomePieceOfFurniture3D.this.updatePieceOfFurnitureModelNode((Node)branchGroup, transformGroup, bl, bl2);
            }

            public void modelError(Exception exception) {
                HomePieceOfFurniture3D.this.updatePieceOfFurnitureModelNode(HomePieceOfFurniture3D.this.getModelBox(Color.RED), new TransformGroup(), bl, bl2);
            }
        });
    }

    @Override
    public void update() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            Enumeration enumeration = this.getAllChildren();
            while (enumeration.hasMoreElements()) {
                ((HomePieceOfFurniture3D)((Object)enumeration.nextElement())).update();
            }
        } else {
            this.updatePieceOfFurnitureTransform();
            this.updatePieceOfFurnitureColorAndTexture(false);
            this.updatePieceOfFurnitureVisibility();
            this.updatePieceOfFurnitureModelMirrored();
        }
    }

    private void updatePieceOfFurnitureTransform() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        Transform3D transform3D = new Transform3D();
        float f = homePieceOfFurniture.getWidth();
        if (homePieceOfFurniture.isModelMirrored()) {
            f *= -1.0f;
        }
        transform3D.setScale(new Vector3d((double)f, (double)homePieceOfFurniture.getHeight(), (double)homePieceOfFurniture.getDepth()));
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY((double)(-homePieceOfFurniture.getAngle()));
        transform3D2.mul(transform3D);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3f(homePieceOfFurniture.getX(), homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeight() / 2.0f, homePieceOfFurniture.getY()));
        transform3D3.mul(transform3D2);
        ((TransformGroup)this.getChild(0)).setTransform(transform3D3);
    }

    private void updatePieceOfFurnitureColorAndTexture(boolean bl) {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        Node node = this.getFilledModelNode();
        if (homePieceOfFurniture.getColor() != null) {
            this.setColorAndTexture(node, homePieceOfFurniture.getColor(), null, homePieceOfFurniture.getShininess(), false, null, null, new HashSet<Appearance>());
        } else if (homePieceOfFurniture.getTexture() != null) {
            this.setColorAndTexture(node, null, homePieceOfFurniture.getTexture(), homePieceOfFurniture.getShininess(), bl, new Vector3f(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getHeight(), homePieceOfFurniture.getDepth()), ModelManager.getInstance().getSize(((Group)node).getChild(0)), new HashSet<Appearance>());
        } else {
            this.setColorAndTexture(node, null, null, homePieceOfFurniture.getShininess(), false, null, null, new HashSet<Appearance>());
        }
    }

    private Node getFilledModelNode() {
        TransformGroup transformGroup = (TransformGroup)this.getChild(0);
        BranchGroup branchGroup = (BranchGroup)transformGroup.getChild(0);
        return branchGroup.getChild(0);
    }

    private Node getOutlineModelNode() {
        TransformGroup transformGroup = (TransformGroup)this.getChild(0);
        BranchGroup branchGroup = (BranchGroup)transformGroup.getChild(0);
        if (branchGroup.numChildren() > 1) {
            return branchGroup.getChild(1);
        }
        return null;
    }

    private void updatePieceOfFurnitureVisibility() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        Node node = this.getOutlineModelNode();
        HomeEnvironment.DrawingMode drawingMode = node != null ? this.home.getEnvironment().getDrawingMode() : null;
        this.setVisible(this.getFilledModelNode(), homePieceOfFurniture.isVisible() && (drawingMode == null || drawingMode == HomeEnvironment.DrawingMode.FILL || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE));
        if (node != null) {
            this.setVisible(node, homePieceOfFurniture.isVisible() && (drawingMode == HomeEnvironment.DrawingMode.OUTLINE || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE));
        }
    }

    private void updatePieceOfFurnitureModelMirrored() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        this.setCullFace(this.getFilledModelNode(), homePieceOfFurniture.isModelMirrored() ^ homePieceOfFurniture.isBackFaceShown() ? 2 : 1);
        if (homePieceOfFurniture.isBackFaceShown()) {
            this.setBackFaceNormalFlip(this.getFilledModelNode(), true);
        }
    }

    private void updatePieceOfFurnitureModelNode(Node node, TransformGroup transformGroup, boolean bl, boolean bl2) {
        BranchGroup branchGroup = new BranchGroup();
        transformGroup.addChild(node);
        transformGroup.setCapability(12);
        branchGroup.addChild((Node)transformGroup);
        if (!bl) {
            branchGroup.addChild(this.createOutlineModelNode((Node)transformGroup));
        }
        this.setModelCapabilities((Node)branchGroup);
        TransformGroup transformGroup2 = (TransformGroup)this.getChild(0);
        transformGroup2.removeAllChildren();
        transformGroup2.addChild((Node)branchGroup);
        this.updatePieceOfFurnitureColorAndTexture(bl2);
        this.updatePieceOfFurnitureVisibility();
        this.updatePieceOfFurnitureModelMirrored();
        if (this.home != null && this.getUserData() instanceof Light) {
            this.home.addSelectionListener(new LightSelectionListener(this));
        }
    }

    private Node getModelBox(Color color) {
        Material material = new Material();
        material.setDiffuseColor(new Color3f(color));
        material.setAmbientColor(new Color3f(color.darker()));
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        return new Box(0.5f, 0.5f, 0.5f, appearance);
    }

    private Node createOutlineModelNode(Node node) {
        Node node2 = ModelManager.getInstance().cloneNode(node);
        this.setOutlineAppearance(node2);
        return node2;
    }

    private void setOutlineAppearance(Node node) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setOutlineAppearance((Node)enumeration.nextElement());
            }
        } else if (node instanceof Link) {
            this.setOutlineAppearance((Node)((Link)node).getSharedGroup());
        } else if (node instanceof Shape3D) {
            Appearance appearance = new Appearance();
            ((Shape3D)node).setAppearance(appearance);
            appearance.setCapability(12);
            RenderingAttributes renderingAttributes = new RenderingAttributes();
            renderingAttributes.setCapability(6);
            appearance.setRenderingAttributes(renderingAttributes);
            appearance.setColoringAttributes(Object3DBranch.OUTLINE_COLORING_ATTRIBUTES);
            appearance.setPolygonAttributes(Object3DBranch.OUTLINE_POLYGON_ATTRIBUTES);
            appearance.setLineAttributes(Object3DBranch.OUTLINE_LINE_ATTRIBUTES);
        }
    }

    private void setModelCapabilities(Node node) {
        if (node instanceof Group) {
            node.setCapability(12);
            if (node instanceof TransformGroup) {
                node.setCapability(17);
            }
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setModelCapabilities((Node)enumeration.nextElement());
            }
        } else if (node instanceof Link) {
            node.setCapability(12);
            this.setModelCapabilities((Node)((Link)node).getSharedGroup());
        } else if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            if (appearance != null) {
                this.setAppearanceCapabilities(appearance);
            }
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements()) {
                this.setGeometryCapabilities((Geometry)enumeration.nextElement());
            }
            node.setCapability(14);
            node.setCapability(15);
            node.setCapability(3);
        }
    }

    private void setColorAndTexture(Node node, Integer n, HomeTexture homeTexture, Float f, boolean bl, Vector3f vector3f, Vector3f vector3f2, Set<Appearance> set) {
        Shape3D shape3D;
        String string;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setColorAndTexture((Node)enumeration.nextElement(), n, homeTexture, f, bl, vector3f, vector3f2, set);
            }
        } else if (node instanceof Link) {
            this.setColorAndTexture((Node)((Link)node).getSharedGroup(), n, homeTexture, f, bl, vector3f, vector3f2, set);
        } else if (node instanceof Shape3D && ((string = (String)(shape3D = (Shape3D)node).getUserData()) == null || !string.startsWith("sweethome3d_window_pane"))) {
            Appearance appearance = shape3D.getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if (!set.contains(appearance)) {
                float f2;
                DefaultMaterialAndTexture defaultMaterialAndTexture = (DefaultMaterialAndTexture)appearance.getUserData();
                if (defaultMaterialAndTexture == null) {
                    defaultMaterialAndTexture = new DefaultMaterialAndTexture(appearance);
                    appearance.setUserData((Object)defaultMaterialAndTexture);
                }
                float f3 = f != null ? f.floatValue() : (f2 = appearance.getMaterial() != null ? appearance.getMaterial().getShininess() / 128.0f : 0.0f);
                if (n != null && defaultMaterialAndTexture.getTexture() == null) {
                    appearance.setMaterial(this.getMaterial(n, n, f2));
                    appearance.setTransparencyAttributes(defaultMaterialAndTexture.getTransparencyAttributes());
                    appearance.setPolygonAttributes(defaultMaterialAndTexture.getPolygonAttributes());
                    appearance.setTexCoordGeneration(defaultMaterialAndTexture.getTexCoordGeneration());
                    appearance.setTextureAttributes(defaultMaterialAndTexture.getTextureAttributes());
                    appearance.setTexture(null);
                } else if (n == null && homeTexture != null) {
                    appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f2));
                    TexCoordGeneration texCoordGeneration = new TexCoordGeneration(0, 0, new Vector4f(-vector3f.x / vector3f2.x / homeTexture.getWidth(), 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, vector3f.y / vector3f2.y / homeTexture.getHeight(), vector3f.z / vector3f2.z / homeTexture.getHeight(), 0.0f));
                    appearance.setTexCoordGeneration(texCoordGeneration);
                    appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
                    TextureManager.getInstance().loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                        public void textureUpdated(Texture texture) {
                            if (TextureManager.getInstance().isTextureTransparent(texture)) {
                                shape3D.getAppearance().setTransparencyAttributes(DEFAULT_TEXTURED_SHAPE_TRANSPARENCY_ATTRIBUTES);
                                shape3D.getAppearance().setPolygonAttributes(DEFAULT_TEXTURED_SHAPE_POLYGON_ATTRIBUTES);
                            }
                            shape3D.getAppearance().setTexture(texture);
                        }
                    });
                } else {
                    Material material = defaultMaterialAndTexture.getMaterial();
                    if (material != null && f != null) {
                        material = (Material)material.cloneNodeComponent(true);
                        material.setSpecularColor(new Color3f(f.floatValue(), f.floatValue(), f.floatValue()));
                        material.setShininess(f.floatValue() * 128.0f);
                    }
                    appearance.setMaterial(material);
                    appearance.setTransparencyAttributes(defaultMaterialAndTexture.getTransparencyAttributes());
                    appearance.setPolygonAttributes(defaultMaterialAndTexture.getPolygonAttributes());
                    appearance.setTexCoordGeneration(defaultMaterialAndTexture.getTexCoordGeneration());
                    appearance.setTexture(defaultMaterialAndTexture.getTexture());
                    appearance.setTextureAttributes(defaultMaterialAndTexture.getTextureAttributes());
                }
                set.add(appearance);
            }
        }
    }

    private void setVisible(Node node, boolean bl) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setVisible((Node)enumeration.nextElement(), bl);
            }
        } else if (node instanceof Link) {
            this.setVisible((Node)((Link)node).getSharedGroup(), bl);
        } else if (node instanceof Shape3D) {
            RenderingAttributes renderingAttributes;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if ((renderingAttributes = appearance.getRenderingAttributes()) == null) {
                renderingAttributes = new RenderingAttributes();
                renderingAttributes.setCapability(6);
                appearance.setRenderingAttributes(renderingAttributes);
            }
            String string = (String)shape3D.getUserData();
            if (bl && string != null && this.getUserData() instanceof Light && string.startsWith("sweethome3d_light") && this.home != null && !this.isSelected(this.home.getSelectedItems())) {
                bl = false;
            }
            renderingAttributes.setVisible(bl);
        }
    }

    private boolean isSelected(List<? extends Selectable> list) {
        Object object = this.getUserData();
        for (Selectable selectable : list) {
            if (selectable != object && (!(selectable instanceof HomeFurnitureGroup) || !this.isSelected(((HomeFurnitureGroup)selectable).getFurniture()))) continue;
            return true;
        }
        return false;
    }

    private void setCullFace(Node node, int n) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setCullFace((Node)enumeration.nextElement(), n);
            }
        } else if (node instanceof Link) {
            this.setCullFace((Node)((Link)node).getSharedGroup(), n);
        } else if (node instanceof Shape3D) {
            PolygonAttributes polygonAttributes;
            Appearance appearance = ((Shape3D)node).getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if ((polygonAttributes = appearance.getPolygonAttributes()) == null) {
                polygonAttributes = this.createPolygonAttributesWithChangeCapabilities();
                appearance.setPolygonAttributes(polygonAttributes);
            }
            if (polygonAttributes.getCullFace() != 0) {
                polygonAttributes.setCullFace(n);
            }
        }
    }

    private void setBackFaceNormalFlip(Node node, boolean bl) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setBackFaceNormalFlip((Node)enumeration.nextElement(), bl);
            }
        } else if (node instanceof Link) {
            this.setBackFaceNormalFlip((Node)((Link)node).getSharedGroup(), bl);
        } else if (node instanceof Shape3D) {
            PolygonAttributes polygonAttributes;
            Appearance appearance = ((Shape3D)node).getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if ((polygonAttributes = appearance.getPolygonAttributes()) == null) {
                polygonAttributes = this.createPolygonAttributesWithChangeCapabilities();
                appearance.setPolygonAttributes(polygonAttributes);
            }
            polygonAttributes.setBackFaceNormalFlip(bl);
        }
    }

    private PolygonAttributes createPolygonAttributesWithChangeCapabilities() {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(0);
        polygonAttributes.setCapability(1);
        polygonAttributes.setCapability(7);
        return polygonAttributes;
    }

    private Appearance createAppearanceWithChangeCapabilities() {
        Appearance appearance = new Appearance();
        this.setAppearanceCapabilities(appearance);
        return appearance;
    }

    private void setAppearanceCapabilities(Appearance appearance) {
        appearance.setCapability(0);
        appearance.setCapability(1);
        Material material = appearance.getMaterial();
        if (material != null) {
            material.setCapability(0);
        }
        appearance.setCapability(12);
        appearance.setCapability(13);
        appearance.setCapability(14);
        appearance.setCapability(15);
        appearance.setCapability(4);
        appearance.setCapability(5);
        appearance.setCapability(2);
        appearance.setCapability(3);
        appearance.setCapability(6);
        appearance.setCapability(7);
        appearance.setCapability(10);
        appearance.setCapability(11);
        PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
        if (polygonAttributes != null) {
            polygonAttributes.setCapability(0);
            polygonAttributes.setCapability(1);
            polygonAttributes.setCapability(7);
        }
    }

    private void setGeometryCapabilities(Geometry geometry) {
        if (!geometry.isLive() && geometry instanceof GeometryArray) {
            geometry.setCapability(17);
            geometry.setCapability(8);
            geometry.setCapability(0);
            geometry.setCapability(4);
            geometry.setCapability(6);
            geometry.setCapability(21);
        }
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
    }

    private static class DefaultMaterialAndTexture {
        private final Material material;
        private final TransparencyAttributes transparencyAttributes;
        private final PolygonAttributes polygonAttributes;
        private final TexCoordGeneration texCoordGeneration;
        private final Texture texture;
        private final TextureAttributes textureAttributes;

        public DefaultMaterialAndTexture(Appearance appearance) {
            this.material = appearance.getMaterial();
            this.transparencyAttributes = appearance.getTransparencyAttributes();
            this.polygonAttributes = appearance.getPolygonAttributes();
            this.texCoordGeneration = appearance.getTexCoordGeneration();
            this.texture = appearance.getTexture();
            this.textureAttributes = appearance.getTextureAttributes();
        }

        public Material getMaterial() {
            return this.material;
        }

        public TransparencyAttributes getTransparencyAttributes() {
            return this.transparencyAttributes;
        }

        public PolygonAttributes getPolygonAttributes() {
            return this.polygonAttributes;
        }

        public TexCoordGeneration getTexCoordGeneration() {
            return this.texCoordGeneration;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public TextureAttributes getTextureAttributes() {
            return this.textureAttributes;
        }
    }

    private static class LightSelectionListener
    implements SelectionListener {
        private WeakReference<HomePieceOfFurniture3D> piece;

        public LightSelectionListener(HomePieceOfFurniture3D homePieceOfFurniture3D) {
            this.piece = new WeakReference<HomePieceOfFurniture3D>(homePieceOfFurniture3D);
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            HomePieceOfFurniture3D homePieceOfFurniture3D = (HomePieceOfFurniture3D)((Object)this.piece.get());
            Home home = (Home)selectionEvent.getSource();
            if (homePieceOfFurniture3D == null) {
                home.removeSelectionListener(this);
            } else {
                homePieceOfFurniture3D.updatePieceOfFurnitureVisibility();
            }
        }
    }
}

