/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.DAELoader;
import com.eteks.sweethome3d.j3d.OBJLoader;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.microcrowd.loader.java3d.max3ds.Loader3DS;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelManager {
    public static final String WINDOW_PANE_SHAPE_PREFIX = "sweethome3d_window_pane";
    public static final String MIRROR_SHAPE_PREFIX = "sweethome3d_window_mirror";
    public static final String LIGHT_SHAPE_PREFIX = "sweethome3d_light";
    private static final TransparencyAttributes WINDOW_PANE_TRANSPARENCY_ATTRIBUTES = new TransparencyAttributes(1, 0.5f);
    private static final Material DEFAULT_MATERIAL = new Material();
    private static final float MINIMUM_SIZE = 0.001f;
    private static final String ADDITIONAL_LOADER_CLASSES = "com.eteks.sweethome3d.j3d.additionalLoaderClasses";
    private static ModelManager instance;
    private Map<Content, BranchGroup> loadedModelNodes = new WeakHashMap<Content, BranchGroup>();
    private Map<Content, List<ModelObserver>> loadingModelObservers = new HashMap<Content, List<ModelObserver>>();
    private ExecutorService modelsLoader;
    private Class<Loader>[] additionalLoaderClasses;

    private ModelManager() {
        ArrayList<Class<Loader>> arrayList = new ArrayList<Class<Loader>>();
        String string = System.getProperty(ADDITIONAL_LOADER_CLASSES);
        if (string != null) {
            for (String string2 : string.split("\\s|:")) {
                try {
                    arrayList.add(this.getLoaderClass(string2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Invalid loader class " + string2 + ":\n" + illegalArgumentException.getMessage());
                }
            }
        }
        this.additionalLoaderClasses = arrayList.toArray(new Class[arrayList.size()]);
    }

    private Class<Loader> getLoaderClass(String string) {
        try {
            Class<Loader> clazz = this.getClass().getClassLoader().loadClass(string);
            if (!Loader.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(string + " not a subclass of " + Loader.class.getName());
            }
            if (Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException(string + " not a public static class");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(string + " constructor not accessible");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string + " not a public static class");
        }
    }

    public static ModelManager getInstance() {
        if (instance == null) {
            instance = new ModelManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.modelsLoader != null) {
            this.modelsLoader.shutdownNow();
            this.modelsLoader = null;
        }
        Map<Content, BranchGroup> map = this.loadedModelNodes;
        synchronized (map) {
            this.loadedModelNodes.clear();
        }
    }

    public Vector3f getSize(Node node) {
        BoundingBox boundingBox = this.getBounds(node);
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        return new Vector3f(Math.max(0.001f, (float)(point3d2.x - point3d.x)), Math.max(0.001f, (float)(point3d2.y - point3d.y)), Math.max(0.001f, (float)(point3d2.z - point3d.z)));
    }

    public BoundingBox getBounds(Node node) {
        BoundingBox boundingBox = new BoundingBox(new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
        this.computeBounds(node, boundingBox, new Transform3D());
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        if (point3d.x == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Node has no bounds");
        }
        return boundingBox;
    }

    private void computeBounds(Node node, BoundingBox boundingBox, Transform3D transform3D) {
        if (node instanceof Group) {
            Enumeration enumeration;
            if (node instanceof TransformGroup) {
                transform3D = new Transform3D(transform3D);
                enumeration = new Transform3D();
                ((TransformGroup)node).getTransform((Transform3D)enumeration);
                transform3D.mul((Transform3D)enumeration);
            }
            enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.computeBounds((Node)enumeration.nextElement(), boundingBox, transform3D);
            }
        } else if (node instanceof Link) {
            this.computeBounds((Node)((Link)node).getSharedGroup(), boundingBox, transform3D);
        } else if (node instanceof Shape3D) {
            Bounds bounds = ((Shape3D)node).getBounds();
            bounds.transform(transform3D);
            boundingBox.combine(bounds);
        }
    }

    public TransformGroup getNormalizedTransformGroup(Node node, float[][] fArray, float f) {
        BoundingBox boundingBox = this.getBounds(node);
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setScale(new Vector3d((double)f / Math.max((double)0.001f, point3d2.x - point3d.x), (double)f / Math.max((double)0.001f, point3d2.y - point3d.y), (double)f / Math.max((double)0.001f, point3d2.z - point3d.z)));
        transform3D2.mul(transform3D);
        Transform3D transform3D3 = new Transform3D();
        if (fArray != null) {
            Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
            transform3D3.setRotation(matrix3f);
        }
        transform3D3.mul(transform3D2);
        return new TransformGroup(transform3D3);
    }

    public void loadModel(Content content, ModelObserver modelObserver) {
        this.loadModel(content, false, modelObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModel(final Content content, boolean bl, ModelObserver modelObserver) {
        BranchGroup branchGroup;
        ArrayList<ModelObserver> arrayList = this.loadedModelNodes;
        synchronized (arrayList) {
            branchGroup = this.loadedModelNodes.get(content);
        }
        if (branchGroup != null) {
            modelObserver.modelUpdated((BranchGroup)this.cloneNode((Node)branchGroup));
        } else if (bl) {
            try {
                branchGroup = this.loadModel(content);
                arrayList = this.loadedModelNodes;
                synchronized (arrayList) {
                    this.loadedModelNodes.put(content, branchGroup);
                }
                modelObserver.modelUpdated((BranchGroup)this.cloneNode((Node)branchGroup));
            }
            catch (IOException iOException) {
                modelObserver.modelError(iOException);
            }
        } else {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("Asynchronous call out of Event Dispatch Thread");
            }
            if (this.modelsLoader == null) {
                this.modelsLoader = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            }
            if ((arrayList = this.loadingModelObservers.get(content)) != null) {
                arrayList.add(modelObserver);
            } else {
                arrayList = new ArrayList<ModelObserver>();
                arrayList.add(modelObserver);
                this.loadingModelObservers.put(content, arrayList);
                this.modelsLoader.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            final BranchGroup branchGroup = ModelManager.this.loadModel(content);
                            Map map = ModelManager.this.loadedModelNodes;
                            synchronized (map) {
                                ModelManager.this.loadedModelNodes.put(content, branchGroup);
                            }
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    for (ModelObserver modelObserver : (List)ModelManager.this.loadingModelObservers.remove(content)) {
                                        modelObserver.modelUpdated((BranchGroup)ModelManager.this.cloneNode((Node)branchGroup));
                                    }
                                }
                            });
                        }
                        catch (IOException iOException) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    for (ModelObserver modelObserver : (List)ModelManager.this.loadingModelObservers.remove(content)) {
                                        modelObserver.modelError(iOException);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node cloneNode(Node node) {
        Map<Content, BranchGroup> map = this.loadedModelNodes;
        synchronized (map) {
            return this.cloneNode(node, new HashMap<SharedGroup, SharedGroup>());
        }
    }

    private Node cloneNode(Node node, Map<SharedGroup, SharedGroup> map) {
        if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            Shape3D shape3D2 = (Shape3D)shape3D.cloneNode(false);
            Appearance appearance = shape3D.getAppearance();
            if (appearance != null) {
                Appearance appearance2 = (Appearance)appearance.cloneNodeComponent(true);
                Texture texture = appearance.getTexture();
                if (texture != null) {
                    appearance2.setTexture(texture);
                }
                shape3D2.setAppearance(appearance2);
            }
            return shape3D2;
        }
        if (node instanceof Link) {
            Link link = (Link)node.cloneNode(true);
            SharedGroup sharedGroup = link.getSharedGroup();
            if (sharedGroup != null) {
                SharedGroup sharedGroup2 = map.get(sharedGroup);
                if (sharedGroup2 == null) {
                    sharedGroup2 = (SharedGroup)this.cloneNode((Node)sharedGroup, map);
                    map.put(sharedGroup, sharedGroup2);
                }
                link.setSharedGroup(sharedGroup2);
            }
            return link;
        }
        Node node2 = node.cloneNode(true);
        if (node instanceof Group) {
            Group group = (Group)node;
            Group group2 = (Group)node2;
            int n = group.numChildren();
            for (int i = 0; i < n; ++i) {
                Node node3 = this.cloneNode(group.getChild(i), map);
                group2.addChild(node3);
            }
        }
        return node2;
    }

    public BranchGroup loadModel(Content content) throws IOException {
        Object object;
        URLContent uRLContent = content instanceof URLContent ? (URLContent)content : TemporaryURLContent.copyToTemporaryURLContent(content);
        Loader3DS loader3DS = new Loader3DS(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException {
                Closeable closeable;
                try {
                    closeable = uRL.openStream();
                    if (closeable.read() != 77 && closeable.read() != 77) {
                        throw new IncorrectFormatException("Bad magic number");
                    }
                    closeable.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw fileNotFoundException;
                }
                catch (IOException iOException) {
                    throw new ParsingErrorException("Can't read url " + uRL);
                }
                closeable = System.err;
                try {
                    System.setErr(new PrintStream(new OutputStream(){

                        public void write(int n) throws IOException {
                        }
                    }));
                    Scene scene = super.load(uRL);
                    return scene;
                }
                finally {
                    System.setErr((PrintStream)closeable);
                }
            }
        };
        Loader[] loaderArray = new Loader[]{new OBJLoader(), new DAELoader(), loader3DS, new Lw3dLoader()};
        Loader[] loaderArray2 = new Loader[loaderArray.length + this.additionalLoaderClasses.length];
        System.arraycopy(loaderArray, 0, loaderArray2, 0, loaderArray.length);
        for (int i = 0; i < this.additionalLoaderClasses.length; ++i) {
            try {
                loaderArray2[loaderArray.length + i] = this.additionalLoaderClasses[i].newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new InternalError(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException.getMessage());
            }
        }
        Throwable throwable = null;
        for (Loader loader : loaderArray2) {
            try {
                loader.setFlags(loader.getFlags() & 0xFFFFFFE8);
                Scene scene = loader.load(uRLContent.getURL());
                BranchGroup branchGroup = scene.getSceneGroup();
                if (branchGroup.numChildren() == 0) {
                    throw new IllegalArgumentException("Empty model");
                }
                this.updateShapeNamesAndWindowPanesTransparency(scene);
                this.turnOffLightsShareAndModulateTextures((Node)branchGroup);
                return branchGroup;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throwable = illegalArgumentException;
            }
            catch (IncorrectFormatException incorrectFormatException) {
                throwable = incorrectFormatException;
            }
            catch (ParsingErrorException parsingErrorException) {
                throwable = parsingErrorException;
            }
            catch (IOException iOException) {
                throwable = iOException;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getClass().getName().equals("com.sun.j3d.utils.image.ImageException")) {
                    throwable = runtimeException;
                    continue;
                }
                throw runtimeException;
            }
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof IncorrectFormatException) {
            object = new IOException("Incorrect format");
            ((Throwable)object).initCause(throwable);
            throw object;
        }
        if (throwable instanceof ParsingErrorException) {
            object = new IOException("Parsing error");
            ((Throwable)object).initCause(throwable);
            throw object;
        }
        object = new IOException();
        ((Throwable)object).initCause(throwable);
        throw object;
    }

    private void updateShapeNamesAndWindowPanesTransparency(Scene scene) {
        Hashtable hashtable = scene.getNamedObjects();
        for (Map.Entry entry : hashtable.entrySet()) {
            if (!(entry.getValue() instanceof Shape3D)) continue;
            String string = (String)entry.getKey();
            Shape3D shape3D = (Shape3D)entry.getValue();
            shape3D.setUserData((Object)string);
            if (!string.startsWith(WINDOW_PANE_SHAPE_PREFIX)) continue;
            Appearance appearance = shape3D.getAppearance();
            if (appearance == null) {
                appearance = new Appearance();
                shape3D.setAppearance(appearance);
            }
            if (appearance.getTransparencyAttributes() != null) continue;
            appearance.setTransparencyAttributes(WINDOW_PANE_TRANSPARENCY_ATTRIBUTES);
        }
    }

    private void turnOffLightsShareAndModulateTextures(Node node) {
        Texture texture;
        Appearance appearance;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.turnOffLightsShareAndModulateTextures((Node)enumeration.nextElement());
            }
        } else if (node instanceof Link) {
            this.turnOffLightsShareAndModulateTextures((Node)((Link)node).getSharedGroup());
        } else if (node instanceof Light) {
            ((Light)node).setEnable(false);
        } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
            TextureAttributes textureAttributes;
            Texture texture2 = TextureManager.getInstance().shareTexture(texture);
            if (texture2 != texture) {
                appearance.setTexture(texture2);
            }
            if ((textureAttributes = appearance.getTextureAttributes()) == null) {
                textureAttributes = new TextureAttributes();
                textureAttributes.setTextureMode(2);
                appearance.setTextureAttributes(textureAttributes);
                Material material = appearance.getMaterial();
                if (material == null) {
                    appearance.setMaterial((Material)DEFAULT_MATERIAL.cloneNodeComponent(true));
                } else {
                    Color3f color3f = new Color3f();
                    DEFAULT_MATERIAL.getDiffuseColor(color3f);
                    material.setDiffuseColor(color3f);
                    DEFAULT_MATERIAL.getAmbientColor(color3f);
                    material.setAmbientColor(color3f);
                }
            }
            if (TextureManager.getInstance().isTextureTransparent(texture2) && appearance.getTransparencyAttributes() == null) {
                appearance.setTransparencyAttributes(new TransparencyAttributes(1, 0.0f));
            }
        }
    }

    public Area getAreaOnFloor(Node node) {
        Area area;
        int n = this.getVertexCount(node);
        if (n < 10000) {
            area = new Area();
            this.computeAreaOnFloor(node, area, new Transform3D());
        } else {
            ArrayList<float[]> arrayList = new ArrayList<float[]>(n);
            this.computeVerticesOnFloor(node, arrayList, new Transform3D());
            float[][] fArray = this.getSurroundingPolygon((float[][])arrayList.toArray((T[])new float[arrayList.size()][]));
            GeneralPath generalPath = new GeneralPath(1, fArray.length);
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            for (int i = 0; i < fArray.length; ++i) {
                generalPath.lineTo(fArray[i][0], fArray[i][1]);
            }
            generalPath.closePath();
            area = new Area(generalPath);
        }
        return area;
    }

    private int getVertexCount(Node node) {
        int n;
        block4: {
            RenderingAttributes renderingAttributes;
            block5: {
                block3: {
                    n = 0;
                    if (!(node instanceof Group)) break block3;
                    Enumeration enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        n += this.getVertexCount((Node)enumeration.nextElement());
                    }
                    break block4;
                }
                if (!(node instanceof Link)) break block5;
                n = this.getVertexCount((Node)((Link)node).getSharedGroup());
                break block4;
            }
            if (!(node instanceof Shape3D)) break block4;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes2 = renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            if (renderingAttributes == null || renderingAttributes.getVisible()) {
                int n2 = shape3D.numGeometries();
                for (int i = 0; i < n2; ++i) {
                    Geometry geometry = shape3D.getGeometry(i);
                    if (!(geometry instanceof GeometryArray)) continue;
                    n += ((GeometryArray)geometry).getVertexCount();
                }
            }
        }
        return n;
    }

    private void computeVerticesOnFloor(Node node, List<float[]> list, Transform3D transform3D) {
        block10: {
            TransparencyAttributes transparencyAttributes;
            block11: {
                block9: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block9;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.computeVerticesOnFloor((Node)enumeration.nextElement(), list, transform3D);
                    }
                    break block10;
                }
                if (!(node instanceof Link)) break block11;
                this.computeVerticesOnFloor((Node)((Link)node).getSharedGroup(), list, transform3D);
                break block10;
            }
            if (!(node instanceof Shape3D)) break block10;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes2 = transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            if ((renderingAttributes == null || renderingAttributes.getVisible()) && (transparencyAttributes == null || transparencyAttributes.getTransparency() < 1.0f)) {
                int n = shape3D.numGeometries();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    Geometry geometry = shape3D.getGeometry(i);
                    if (!(geometry instanceof GeometryArray)) continue;
                    GeometryArray geometryArray = (GeometryArray)geometry;
                    int n3 = geometryArray.getVertexCount();
                    Point3f point3f = new Point3f();
                    if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                        int n4;
                        if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                            float[] fArray = geometryArray.getInterleavedVertices();
                            n2 = fArray.length / n3;
                            int n5 = n2 - 3;
                            for (n4 = 0; n4 < n3; ++n4) {
                                point3f.x = fArray[n5];
                                point3f.y = fArray[n5 + 1];
                                point3f.z = fArray[n5 + 2];
                                transform3D.transform(point3f);
                                list.add(new float[]{point3f.x, point3f.z});
                                n5 += n2;
                            }
                            continue;
                        }
                        float[] fArray = geometryArray.getCoordRefFloat();
                        n4 = 0;
                        for (n2 = 0; n2 < n3; ++n2) {
                            point3f.x = fArray[n4];
                            point3f.y = fArray[n4 + 1];
                            point3f.z = fArray[n4 + 2];
                            transform3D.transform(point3f);
                            list.add(new float[]{point3f.x, point3f.z});
                            n4 += 3;
                        }
                        continue;
                    }
                    n2 = 0;
                    for (int j = 0; j < n3; ++j) {
                        geometryArray.getCoordinate(n2, point3f);
                        transform3D.transform(point3f);
                        list.add(new float[]{point3f.x, point3f.z});
                        ++n2;
                    }
                }
            }
        }
    }

    private void computeAreaOnFloor(Node node, Area area, Transform3D transform3D) {
        block5: {
            TransparencyAttributes transparencyAttributes;
            block6: {
                block4: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block4;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.computeAreaOnFloor((Node)enumeration.nextElement(), area, transform3D);
                    }
                    break block5;
                }
                if (!(node instanceof Link)) break block6;
                this.computeAreaOnFloor((Node)((Link)node).getSharedGroup(), area, transform3D);
                break block5;
            }
            if (!(node instanceof Shape3D)) break block5;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes2 = transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            if ((renderingAttributes == null || renderingAttributes.getVisible()) && (transparencyAttributes == null || transparencyAttributes.getTransparency() < 1.0f)) {
                int n = shape3D.numGeometries();
                for (int i = 0; i < n; ++i) {
                    this.computeGeometryAreaOnFloor(shape3D.getGeometry(i), transform3D, area);
                }
            }
        }
    }

    private void computeGeometryAreaOnFloor(Geometry geometry, Transform3D transform3D, Area area) {
        if (geometry instanceof GeometryArray) {
            int n;
            int n2;
            int n3;
            GeometryArray geometryArray = (GeometryArray)geometry;
            int n4 = geometryArray.getVertexCount();
            float[] fArray = new float[n4 * 2];
            Point3f point3f = new Point3f();
            if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                    float[] fArray2 = geometryArray.getInterleavedVertices();
                    n3 = fArray2.length / n4;
                    n2 = 0;
                    n = n3 - 3;
                    while (n2 < fArray.length) {
                        point3f.x = fArray2[n];
                        point3f.y = fArray2[n + 1];
                        point3f.z = fArray2[n + 2];
                        transform3D.transform(point3f);
                        fArray[n2++] = point3f.x;
                        fArray[n2++] = point3f.z;
                        n += n3;
                    }
                } else {
                    float[] fArray3 = geometryArray.getCoordRefFloat();
                    n3 = 0;
                    n2 = 0;
                    while (n3 < fArray.length) {
                        point3f.x = fArray3[n2];
                        point3f.y = fArray3[n2 + 1];
                        point3f.z = fArray3[n2 + 2];
                        transform3D.transform(point3f);
                        fArray[n3++] = point3f.x;
                        fArray[n3++] = point3f.z;
                        n2 += 3;
                    }
                }
            } else {
                int n5 = 0;
                n3 = 0;
                while (n5 < fArray.length) {
                    geometryArray.getCoordinate(n3, point3f);
                    transform3D.transform(point3f);
                    fArray[n5++] = point3f.x;
                    fArray[n5++] = point3f.z;
                    ++n3;
                }
            }
            GeneralPath generalPath = null;
            if (geometryArray instanceof IndexedGeometryArray) {
                if (geometryArray instanceof IndexedTriangleArray) {
                    IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)geometryArray;
                    generalPath = new GeneralPath(1, 1000);
                    n = 0;
                    int n6 = indexedTriangleArray.getIndexCount();
                    for (n2 = 0; n2 < n6; n2 += 3) {
                        this.addIndexedTriangleToPath((IndexedGeometryArray)indexedTriangleArray, n2, n2 + 1, n2 + 2, fArray, generalPath, n++, area);
                    }
                } else if (geometryArray instanceof IndexedQuadArray) {
                    IndexedQuadArray indexedQuadArray = (IndexedQuadArray)geometryArray;
                    generalPath = new GeneralPath(1, 1000);
                    n = 0;
                    int n7 = indexedQuadArray.getIndexCount();
                    for (n2 = 0; n2 < n7; n2 += 4) {
                        this.addIndexedQuadrilateralToPath((IndexedGeometryArray)indexedQuadArray, n2, n2 + 1, n2 + 2, n2 + 3, fArray, generalPath, n++, area);
                    }
                } else if (geometryArray instanceof IndexedGeometryStripArray) {
                    IndexedGeometryStripArray indexedGeometryStripArray = (IndexedGeometryStripArray)geometryArray;
                    int[] nArray = new int[indexedGeometryStripArray.getNumStrips()];
                    indexedGeometryStripArray.getStripIndexCounts(nArray);
                    generalPath = new GeneralPath(1, 1000);
                    n = 0;
                    if (indexedGeometryStripArray instanceof IndexedTriangleStripArray) {
                        int n8 = 0;
                        for (int i = 0; i < nArray.length; ++i) {
                            int n9 = n;
                            int n10 = n + nArray[i] - 2;
                            int n11 = 0;
                            while (n9 < n10) {
                                if (n11 % 2 == 0) {
                                    this.addIndexedTriangleToPath((IndexedGeometryArray)indexedGeometryStripArray, n9, n9 + 1, n9 + 2, fArray, generalPath, n8++, area);
                                } else {
                                    this.addIndexedTriangleToPath((IndexedGeometryArray)indexedGeometryStripArray, n9, n9 + 2, n9 + 1, fArray, generalPath, n8++, area);
                                }
                                ++n9;
                                ++n11;
                            }
                            n += nArray[i];
                        }
                    } else if (indexedGeometryStripArray instanceof IndexedTriangleFanArray) {
                        int n12 = 0;
                        for (int i = 0; i < nArray.length; ++i) {
                            int n13 = n + nArray[i] - 2;
                            for (int j = n; j < n13; ++j) {
                                this.addIndexedTriangleToPath((IndexedGeometryArray)indexedGeometryStripArray, n, j + 1, j + 2, fArray, generalPath, n12++, area);
                            }
                            n += nArray[i];
                        }
                    }
                }
            } else if (geometryArray instanceof TriangleArray) {
                TriangleArray triangleArray = (TriangleArray)geometryArray;
                generalPath = new GeneralPath(1, 1000);
                n = 0;
                for (n2 = 0; n2 < n4; n2 += 3) {
                    this.addTriangleToPath((GeometryArray)triangleArray, n2, n2 + 1, n2 + 2, fArray, generalPath, n++, area);
                }
            } else if (geometryArray instanceof QuadArray) {
                QuadArray quadArray = (QuadArray)geometryArray;
                generalPath = new GeneralPath(1, 1000);
                n = 0;
                for (n2 = 0; n2 < n4; n2 += 4) {
                    this.addQuadrilateralToPath((GeometryArray)quadArray, n2, n2 + 1, n2 + 2, n2 + 3, fArray, generalPath, n++, area);
                }
            } else if (geometryArray instanceof GeometryStripArray) {
                GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
                int[] nArray = new int[geometryStripArray.getNumStrips()];
                geometryStripArray.getStripVertexCounts(nArray);
                generalPath = new GeneralPath(1, 1000);
                n = 0;
                if (geometryStripArray instanceof TriangleStripArray) {
                    int n14 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n15 = n;
                        int n16 = n + nArray[i] - 2;
                        int n17 = 0;
                        while (n15 < n16) {
                            if (n17 % 2 == 0) {
                                this.addTriangleToPath((GeometryArray)geometryStripArray, n15, n15 + 1, n15 + 2, fArray, generalPath, n14++, area);
                            } else {
                                this.addTriangleToPath((GeometryArray)geometryStripArray, n15, n15 + 2, n15 + 1, fArray, generalPath, n14++, area);
                            }
                            ++n15;
                            ++n17;
                        }
                        n += nArray[i];
                    }
                } else if (geometryStripArray instanceof TriangleFanArray) {
                    int n18 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n19 = n + nArray[i] - 2;
                        for (int j = n; j < n19; ++j) {
                            this.addTriangleToPath((GeometryArray)geometryStripArray, n, j + 1, j + 2, fArray, generalPath, n18++, area);
                        }
                        n += nArray[i];
                    }
                }
            }
            if (generalPath != null) {
                area.add(new Area(generalPath));
            }
        }
    }

    private void addIndexedTriangleToPath(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, float[] fArray, GeneralPath generalPath, int n4, Area area) {
        this.addTriangleToPath((GeometryArray)indexedGeometryArray, indexedGeometryArray.getCoordinateIndex(n), indexedGeometryArray.getCoordinateIndex(n2), indexedGeometryArray.getCoordinateIndex(n3), fArray, generalPath, n4, area);
    }

    private void addIndexedQuadrilateralToPath(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int n4, float[] fArray, GeneralPath generalPath, int n5, Area area) {
        this.addQuadrilateralToPath((GeometryArray)indexedGeometryArray, indexedGeometryArray.getCoordinateIndex(n), indexedGeometryArray.getCoordinateIndex(n2), indexedGeometryArray.getCoordinateIndex(n3), indexedGeometryArray.getCoordinateIndex(n4), fArray, generalPath, n5, area);
    }

    private void addTriangleToPath(GeometryArray geometryArray, int n, int n2, int n3, float[] fArray, GeneralPath generalPath, int n4, Area area) {
        float f = fArray[2 * n2];
        float f2 = fArray[2 * n];
        float f3 = fArray[2 * n3 + 1];
        float f4 = fArray[2 * n2 + 1];
        float f5 = fArray[2 * n + 1];
        float f6 = fArray[2 * n3];
        if ((f - f2) * (f3 - f4) - (f4 - f5) * (f6 - f) > 0.0f) {
            if (n4 > 0 && n4 % 1000 == 0) {
                area.add(new Area(generalPath));
                generalPath.reset();
            }
            generalPath.moveTo(f2, f5);
            generalPath.lineTo(f, f4);
            generalPath.lineTo(f6, f3);
            generalPath.closePath();
        }
    }

    private void addQuadrilateralToPath(GeometryArray geometryArray, int n, int n2, int n3, int n4, float[] fArray, GeneralPath generalPath, int n5, Area area) {
        float f = fArray[2 * n2];
        float f2 = fArray[2 * n];
        float f3 = fArray[2 * n3 + 1];
        float f4 = fArray[2 * n2 + 1];
        float f5 = fArray[2 * n + 1];
        float f6 = fArray[2 * n3];
        if ((f - f2) * (f3 - f4) - (f4 - f5) * (f6 - f) > 0.0f) {
            if (n5 > 0 && n5 % 1000 == 0) {
                area.add(new Area(generalPath));
                generalPath.reset();
            }
            generalPath.moveTo(f2, f5);
            generalPath.lineTo(f, f4);
            generalPath.lineTo(f6, f3);
            generalPath.lineTo(fArray[2 * n4], fArray[2 * n4 + 1]);
            generalPath.closePath();
        }
    }

    private float[][] getSurroundingPolygon(float[][] fArray) {
        int n;
        Arrays.sort(fArray, new Comparator<float[]>(){

            @Override
            public int compare(float[] fArray, float[] fArray2) {
                if (fArray[0] == fArray2[0]) {
                    return (int)Math.signum(fArray2[1] - fArray[1]);
                }
                return (int)Math.signum(fArray2[0] - fArray[0]);
            }
        });
        float[][] fArrayArray = new float[fArray.length][];
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        float f = fArray[0][0];
        for (n = 1; n < fArray.length && fArray[n][0] == f; ++n) {
        }
        int n5 = n - 1;
        if (n5 == fArray.length - 1) {
            fArrayArray[++n3] = fArray[n4];
            if (fArray[n5][1] != fArray[n4][1]) {
                fArrayArray[++n3] = fArray[n5];
            }
            fArrayArray[++n3] = fArray[n4];
            float[][] fArrayArray2 = new float[n3 + 1][];
            System.arraycopy(fArrayArray, 0, fArrayArray2, 0, fArrayArray2.length);
        }
        int n6 = fArray.length - 1;
        float f2 = fArray[fArray.length - 1][0];
        for (n = fArray.length - 2; n >= 0 && fArray[n][0] == f2; --n) {
        }
        int n7 = n + 1;
        fArrayArray[++n3] = fArray[n4];
        n = n5;
        while (++n <= n7) {
            if (this.isLeft(fArray[n4], fArray[n7], fArray[n]) >= 0.0f && n < n7) continue;
            while (n3 > 0 && !(this.isLeft(fArrayArray[n3 - 1], fArrayArray[n3], fArray[n]) > 0.0f)) {
                --n3;
            }
            fArrayArray[++n3] = fArray[n];
        }
        if (n6 != n7) {
            fArrayArray[++n3] = fArray[n6];
        }
        n2 = n3;
        n = n7;
        while (--n >= n5) {
            if (this.isLeft(fArray[n6], fArray[n5], fArray[n]) >= 0.0f && n > n5) continue;
            while (n3 > n2 && !(this.isLeft(fArrayArray[n3 - 1], fArrayArray[n3], fArray[n]) > 0.0f)) {
                --n3;
            }
            fArrayArray[++n3] = fArray[n];
        }
        if (n5 != n4) {
            fArrayArray[++n3] = fArray[n4];
        }
        float[][] fArrayArray3 = new float[n3 + 1][];
        System.arraycopy(fArrayArray, 0, fArrayArray3, 0, fArrayArray3.length);
        return fArrayArray3;
    }

    private float isLeft(float[] fArray, float[] fArray2, float[] fArray3) {
        return (fArray2[0] - fArray[0]) * (fArray3[1] - fArray[1]) - (fArray3[0] - fArray[0]) * (fArray2[1] - fArray[1]);
    }

    public static interface ModelObserver {
        public void modelUpdated(BranchGroup var1);

        public void modelError(Exception var1);
    }
}

