/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.vecmath.Color3f;

public abstract class Object3DBranch
extends BranchGroup {
    protected static final ColoringAttributes OUTLINE_COLORING_ATTRIBUTES = new ColoringAttributes(new Color3f(0.16f, 0.16f, 0.16f), 0);
    protected static final PolygonAttributes OUTLINE_POLYGON_ATTRIBUTES = new PolygonAttributes(1, 1, 0.0f);
    protected static final LineAttributes OUTLINE_LINE_ATTRIBUTES = new LineAttributes(0.5f, 0, true);
    protected static final Integer DEFAULT_COLOR = 0xFFFFFF;
    protected static final Integer DEFAULT_AMBIENT_COLOR = 0x333333;
    protected static final Material DEFAULT_MATERIAL = new Material();
    private static final Map<Long, Material> materials = new HashMap<Long, Material>();

    public abstract void update();

    protected Shape getShape(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    protected Material getMaterial(Integer n, Integer n2, float f) {
        if (n != null) {
            Long l = new Long(n + (n2 << 24) + ((char)(f * 128.0f) << 48));
            Material material = materials.get(l);
            if (material == null) {
                Color3f color3f = new Color3f((float)(n2 >>> 16 & 0xFF) / 255.0f, (float)(n2 >>> 8 & 0xFF) / 255.0f, (float)(n2 & 0xFF) / 255.0f);
                Color3f color3f2 = new Color3f((float)(n >>> 16 & 0xFF) / 255.0f, (float)(n >>> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
                material = new Material(color3f, new Color3f(), color3f2, new Color3f(f, f, f), f * 128.0f);
                material.setCapability(0);
                materials.put(l, material);
            }
            return material;
        }
        return this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f);
    }

    static {
        DEFAULT_MATERIAL.setCapability(0);
        DEFAULT_MATERIAL.setShininess(1.0f);
        DEFAULT_MATERIAL.setSpecularColor(0.0f, 0.0f, 0.0f);
    }
}

