/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;

public class Room3D
extends Object3DBranch {
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private static final int FLOOR_PART = 0;
    private static final int CEILING_PART = 1;
    private final Home home;

    public Room3D(Room room, Home home) {
        this(room, home, false, false, false);
    }

    public Room3D(Room room, Home home, boolean bl, boolean bl2, boolean bl3) {
        this.setUserData(room);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        this.addChild(this.createRoomPartShape());
        this.addChild(this.createRoomPartShape());
        this.updateRoomGeometry();
        this.updateRoomAppearance(bl3);
        if (bl || bl2 && !room.isCeilingVisible()) {
            this.removeChild(1);
        }
        if (bl2 && !room.isFloorVisible()) {
            this.removeChild(0);
        }
    }

    private Node createRoomPartShape() {
        Shape3D shape3D = new Shape3D();
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        Appearance appearance = new Appearance();
        shape3D.setAppearance(appearance);
        appearance.setCapability(12);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setCapability(1);
        appearance.setMaterial(DEFAULT_MATERIAL);
        appearance.setCapability(3);
        appearance.setCapability(2);
        appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
        return shape3D;
    }

    public void update() {
        this.updateRoomGeometry();
        this.updateRoomAppearance(false);
    }

    private void updateRoomGeometry() {
        this.updateRoomPartGeometry(0, ((Room)this.getUserData()).getFloorTexture());
        this.updateRoomPartGeometry(1, ((Room)this.getUserData()).getCeilingTexture());
    }

    private void updateRoomPartGeometry(int n, HomeTexture homeTexture) {
        Shape3D shape3D = (Shape3D)this.getChild(n);
        int n2 = shape3D.numGeometries();
        for (Geometry geometry : this.createRoomGeometries(n, homeTexture)) {
            shape3D.addGeometry(geometry);
        }
        for (int i = n2 - 1; i >= 0; --i) {
            shape3D.removeGeometry(i);
        }
    }

    private Geometry[] createRoomGeometries(int n, HomeTexture homeTexture) {
        Room room = (Room)this.getUserData();
        float[][] fArray = room.getPoints();
        if ((n == 0 && room.isFloorVisible() || n == 1 && room.isCeilingVisible()) && fArray.length > 2) {
            TexCoord2f[] texCoord2fArray2;
            Point3f[] point3fArray;
            Object[] objectArray;
            Object object;
            Geometry[] geometryArray;
            List<Object> list = new ArrayList();
            HashMap<Integer, TexCoord2f[]> hashMap = new HashMap<Integer, TexCoord2f[]>();
            List<Room> list2 = this.home.getRooms();
            if (!room.isSingular() || list2.get(list2.size() - 1) != room) {
                geometryArray = new Area(this.getShape(fArray));
                if (list2.contains(room)) {
                    for (int i = list2.size() - 1; i > 0 && list2.get(i) != room; --i) {
                        object = list2.get(i);
                        if ((n != 0 || !((Room)object).isFloorVisible()) && (n != 1 || !((Room)object).isCeilingVisible())) continue;
                        geometryArray.subtract(new Area(this.getShape(((Room)object).getPoints())));
                    }
                }
                ArrayList<float[]> arrayList = new ArrayList<float[]>();
                list = new ArrayList();
                object = null;
                int n2 = 0;
                PathIterator pathIterator = geometryArray.getPathIterator(null);
                while (!pathIterator.isDone()) {
                    objectArray = new float[2];
                    switch (pathIterator.currentSegment((float[])objectArray)) {
                        case 0: 
                        case 1: {
                            if (object == null || objectArray[0] != object[0] || objectArray[1] != object[1]) {
                                arrayList.add((float[])objectArray);
                            }
                            object = objectArray;
                            break;
                        }
                        case 4: {
                            float[][] fArray2;
                            if (((float[])arrayList.get(0))[0] == object[0] && ((float[])arrayList.get(0))[1] == object[1]) {
                                arrayList.remove(arrayList.size() - 1);
                            }
                            if (arrayList.size() > 2 && (point3fArray = new Room(fArray2 = (float[][])arrayList.toArray((T[])new float[arrayList.size()][]))).getArea() > 0.0f) {
                                boolean bl = point3fArray.isClockwise();
                                if (bl) {
                                    if (n != 1) {
                                        fArray2 = this.getReversedArray(fArray2);
                                    }
                                    if ((texCoord2fArray2 = (List)hashMap.get(n2)) == null) {
                                        texCoord2fArray2 = new ArrayList(1);
                                        hashMap.put(n2, texCoord2fArray2);
                                    }
                                    texCoord2fArray2.add(fArray2);
                                } else {
                                    if (n == 1) {
                                        fArray2 = this.getReversedArray(fArray2);
                                    }
                                    list.add(fArray2);
                                    ++n2;
                                }
                            }
                            arrayList.clear();
                            object = null;
                        }
                    }
                    pathIterator.next();
                }
            } else {
                boolean bl = room.isClockwise();
                if (bl && n == 0 || !bl && n == 1) {
                    fArray = this.getReversedArray(fArray);
                }
                list = Arrays.asList(new float[][][]{fArray});
            }
            geometryArray = new Geometry[list.size()];
            for (int i = 0; i < geometryArray.length; ++i) {
                object = (float[][])list.get(i);
                List<float[][]> list3 = (List<float[][]>)hashMap.get(i);
                if (list3 == null) {
                    list3 = Collections.emptyList();
                }
                int n3 = ((Object)object).length;
                objectArray = new int[1 + list3.size()];
                int n4 = 0;
                objectArray[n4++] = ((Object)object).length;
                for (float[][] fArray3 : list3) {
                    n3 += fArray3.length;
                    objectArray[n4++] = fArray3.length;
                }
                point3fArray = new Point3f[n3];
                for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                    float f = n == 0 ? 0.0f : this.getRoomHeightAt((float)object[n4][0], (float)object[n4][1]);
                    point3fArray[n4] = new Point3f((float)object[n4][0], f, (float)object[n4][1]);
                }
                for (TexCoord2f[] texCoord2fArray2 : list3) {
                    int n5 = 0;
                    while (n5 < texCoord2fArray2.length) {
                        float f = n == 0 ? 0.0f : this.getRoomHeightAt((float)texCoord2fArray2[n5][0], (float)texCoord2fArray2[n5][1]);
                        point3fArray[n4] = new Point3f(texCoord2fArray2[n5][0], f, (float)texCoord2fArray2[n5][1]);
                        ++n5;
                        ++n4;
                    }
                }
                GeometryInfo geometryInfo = new GeometryInfo(5);
                geometryInfo.setCoordinates(point3fArray);
                geometryInfo.setStripCounts((int[])objectArray);
                geometryInfo.setContourCounts(new int[]{objectArray.length});
                if (homeTexture != null) {
                    texCoord2fArray2 = new TexCoord2f[n3];
                    for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                        texCoord2fArray2[n4] = new TexCoord2f((float)(object[n4][0] / homeTexture.getWidth()), (float)(n == 0 ? -object[n4][1] / homeTexture.getHeight() : object[n4][1] / homeTexture.getHeight()));
                    }
                    for (float[][] fArray4 : list3) {
                        int n6 = 0;
                        while (n6 < fArray4.length) {
                            texCoord2fArray2[n4] = new TexCoord2f(fArray4[n6][0] / homeTexture.getWidth(), n == 0 ? -fArray4[n6][1] / homeTexture.getHeight() : fArray4[n6][1] / homeTexture.getHeight());
                            ++n6;
                            ++n4;
                        }
                    }
                    geometryInfo.setTextureCoordinateParams(1, 2);
                    geometryInfo.setTextureCoordinates(0, texCoord2fArray2);
                }
                new NormalGenerator(0.0).generateNormals(geometryInfo);
                geometryArray[i] = geometryInfo.getIndexedGeometryArray();
            }
            return geometryArray;
        }
        return new Geometry[0];
    }

    private float[][] getReversedArray(float[][] fArray) {
        List list = Arrays.asList(fArray);
        Collections.reverse(list);
        fArray = (float[][])list.toArray((T[])fArray);
        return fArray;
    }

    private float getRoomHeightAt(float f, float f2) {
        double d = Double.POSITIVE_INFINITY;
        float f3 = this.home.getWallHeight();
        for (Wall wall : this.home.getWalls()) {
            Float f4 = wall.getHeight();
            float[][] fArray = wall.getPoints();
            for (int i = 0; i < fArray.length; ++i) {
                double d2 = Point2D.distanceSq(fArray[i][0], fArray[i][1], f, f2);
                if (!(d2 < d)) continue;
                d = d2;
                f3 = i == 0 || i == 3 ? (f4 != null ? f4.floatValue() : this.home.getWallHeight()) : (wall.isTrapezoidal() ? wall.getHeightAtEnd().floatValue() : (f4 != null ? f4.floatValue() : this.home.getWallHeight()));
            }
        }
        return f3;
    }

    private void updateRoomAppearance(boolean bl) {
        Room room = (Room)this.getUserData();
        this.updateRoomPartAppearance(((Shape3D)this.getChild(0)).getAppearance(), room.getFloorTexture(), bl, room.getFloorColor(), room.getFloorShininess(), room.isFloorVisible());
        this.updateRoomPartAppearance(((Shape3D)this.getChild(1)).getAppearance(), room.getCeilingTexture(), bl, room.getCeilingColor(), room.getCeilingShininess(), room.isCeilingVisible());
    }

    private void updateRoomPartAppearance(final Appearance appearance, HomeTexture homeTexture, boolean bl, Integer n, float f, boolean bl2) {
        TextureManager textureManager;
        if (homeTexture == null) {
            appearance.setMaterial(this.getMaterial(n, n, f));
            appearance.setTexture(null);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f));
            textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                public void textureUpdated(Texture texture) {
                    appearance.setTexture(texture);
                }
            });
        }
        textureManager = appearance.getRenderingAttributes();
        textureManager.setVisible(bl2);
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
    }
}

