/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.tools.URLContent;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;

public class TextureManager {
    private static TextureManager instance;
    private final Texture errorTexture = this.getColoredImageTexture(Color.RED);
    private final Texture waitTexture = this.getColoredImageTexture(Color.WHITE);
    private final Map<Content, TextureKey> contentTextureKeys = new WeakHashMap<Content, TextureKey>();
    private final Map<TextureKey, Texture> textures = new WeakHashMap<TextureKey, Texture>();
    private Map<Content, List<TextureObserver>> loadingTextureObservers = new HashMap<Content, List<TextureObserver>>();
    private ExecutorService texturesLoader;

    private TextureManager() {
    }

    public static TextureManager getInstance() {
        if (instance == null) {
            instance = new TextureManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.texturesLoader != null) {
            this.texturesLoader.shutdownNow();
            this.texturesLoader = null;
        }
        Map<TextureKey, Texture> map = this.textures;
        synchronized (map) {
            this.contentTextureKeys.clear();
            this.textures.clear();
        }
    }

    private Texture getColoredImageTexture(Color color) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(color);
        graphics.drawLine(0, 0, 0, 0);
        graphics.dispose();
        Texture texture = new TextureLoader(bufferedImage).getTexture();
        texture.setCapability(4);
        texture.setCapability(9);
        texture.getImage(0).setCapability(2);
        texture.getImage(0).setCapability(1);
        return texture;
    }

    public void loadTexture(Content content, TextureObserver textureObserver) {
        this.loadTexture(content, false, textureObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTexture(final Content content, boolean bl, TextureObserver textureObserver) {
        Texture texture;
        ArrayList<TextureObserver> arrayList = this.textures;
        synchronized (arrayList) {
            TextureKey textureKey = this.contentTextureKeys.get(content);
            texture = textureKey == null ? this.textures.get(textureKey) : null;
        }
        if (texture == null) {
            if (bl) {
                texture = this.shareTexture(this.loadTexture(content), content);
                textureObserver.textureUpdated(texture);
            } else {
                if (!EventQueue.isDispatchThread()) {
                    throw new IllegalStateException("Asynchronous call out of Event Dispatch Thread");
                }
                textureObserver.textureUpdated(this.waitTexture);
                if (this.texturesLoader == null) {
                    this.texturesLoader = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                }
                if ((arrayList = this.loadingTextureObservers.get(content)) != null) {
                    arrayList.add(textureObserver);
                } else {
                    arrayList = new ArrayList<TextureObserver>();
                    arrayList.add(textureObserver);
                    this.loadingTextureObservers.put(content, arrayList);
                    this.texturesLoader.execute(new Runnable(){

                        public void run() {
                            final Texture texture = TextureManager.this.shareTexture(TextureManager.this.loadTexture(content), content);
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    for (TextureObserver textureObserver : (List)TextureManager.this.loadingTextureObservers.remove(content)) {
                                        textureObserver.textureUpdated(texture);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        } else {
            textureObserver.textureUpdated(texture);
        }
    }

    public Texture loadTexture(Content content) {
        InputStream inputStream;
        BufferedImage bufferedImage = null;
        try {
            inputStream = content.openStream();
            bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            inputStream = this.errorTexture;
        } else {
            inputStream = new TextureLoader(bufferedImage).getTexture();
            if (content instanceof URLContent) {
                inputStream.setUserData(((URLContent)content).getURL());
            }
        }
        return inputStream;
    }

    public Texture shareTexture(Texture texture) {
        return this.shareTexture(texture, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Texture shareTexture(Texture texture, Content content) {
        Texture texture2;
        TextureKey textureKey = new TextureKey(texture);
        Map<TextureKey, Texture> map = this.textures;
        synchronized (map) {
            texture2 = this.textures.get(textureKey);
            if (texture2 == null) {
                texture2 = texture;
                this.setSharedTextureAttributesAndCapabilities(texture2);
                this.textures.put(textureKey, texture2);
            } else {
                for (TextureKey textureKey2 : this.textures.keySet()) {
                    if (textureKey2.getTexture() != texture2) continue;
                    textureKey = textureKey2;
                    break;
                }
            }
            if (content != null) {
                this.contentTextureKeys.put(content, textureKey);
            }
        }
        return texture2;
    }

    private void setSharedTextureAttributesAndCapabilities(Texture texture) {
        texture.setMinFilter(1);
        texture.setMagFilter(1);
        texture.setCapability(9);
        texture.setCapability(4);
        for (ImageComponent imageComponent : texture.getImages()) {
            if (imageComponent.isLive()) continue;
            imageComponent.setCapability(1);
            imageComponent.setCapability(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTextureTransparent(Texture texture) {
        Map<TextureKey, Texture> map = this.textures;
        synchronized (map) {
            for (TextureKey textureKey : this.textures.keySet()) {
                if (textureKey.getTexture() != texture) continue;
                return textureKey.isTransparent();
            }
            return texture.getFormat() == 6;
        }
    }

    private static class TextureKey {
        private Texture texture;
        private WeakReference<int[]> imageBits;
        private int hashCodeCache;
        private boolean hashCodeSet;
        private boolean transparent;

        public TextureKey(Texture texture) {
            this.texture = texture;
        }

        public Texture getTexture() {
            return this.texture;
        }

        private int[] getImagePixels() {
            int[] nArray = null;
            if (this.imageBits != null) {
                nArray = (int[])this.imageBits.get();
            }
            if (nArray == null) {
                BufferedImage bufferedImage = ((ImageComponent2D)this.texture.getImage(0)).getImage();
                if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
                    BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), this.texture.getFormat() == 6 ? 2 : 1);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    graphics2D.dispose();
                    bufferedImage = bufferedImage2;
                }
                nArray = (int[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                this.transparent = bufferedImage.getTransparency() != 1;
                this.imageBits = new WeakReference<int[]>(nArray);
            }
            return nArray;
        }

        public boolean isTransparent() {
            return this.transparent;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TextureKey) {
                TextureKey textureKey = (TextureKey)object;
                if (this.texture == textureKey.texture) {
                    return true;
                }
                if (this.hashCode() == textureKey.hashCode()) {
                    return Arrays.equals(this.getImagePixels(), textureKey.getImagePixels());
                }
            }
            return false;
        }

        public int hashCode() {
            if (!this.hashCodeSet) {
                this.hashCodeCache = Arrays.hashCode(this.getImagePixels());
                this.hashCodeSet = true;
            }
            return this.hashCodeCache;
        }
    }

    public static interface TextureObserver {
        public void textureUpdated(Texture var1);
    }
}

