/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFurnitureGroup
extends HomePieceOfFurniture {
    private static final long serialVersionUID = 1L;
    private static final float[][] IDENTITY = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
    private List<HomePieceOfFurniture> furniture;
    private boolean resizable;
    private boolean deformable;
    private boolean doorOrWindow;
    private float fixedWidth;
    private float fixedDepth;
    private float fixedHeight;
    private BigDecimal price;
    private BigDecimal valueAddedTaxPercentage;
    private BigDecimal valueAddedTax;
    private BigDecimal priceValueAddedTaxIncluded;
    private List<Integer> furnitureDefaultColors;
    private List<HomeTexture> furnitureDefaultTextures;

    public HomeFurnitureGroup(List<HomePieceOfFurniture> list, String string) {
        super(list.get(list.size() - 1));
        this.furniture = Collections.unmodifiableList(list);
        Rectangle2D rectangle2D = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.getFurnitureWithoutGroups(list)) {
            for (float[] object2 : homePieceOfFurniture.getPoints()) {
                if (rectangle2D == null) {
                    rectangle2D = new Rectangle2D.Float(object2[0], object2[1], 0.0f, 0.0f);
                    continue;
                }
                rectangle2D.add(object2[0], object2[1]);
            }
        }
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        boolean bl = true;
        this.resizable = true;
        this.deformable = true;
        this.doorOrWindow = true;
        int n = 0;
        int n2 = 1;
        this.valueAddedTaxPercentage = list.get(0).getValueAddedTaxPercentage();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            f = Math.min(f, homePieceOfFurniture.getElevation());
            f2 = Math.max(f2, homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeight());
            bl &= homePieceOfFurniture.isMovable();
            this.resizable &= homePieceOfFurniture.isResizable();
            this.deformable &= homePieceOfFurniture.isDeformable();
            this.doorOrWindow &= homePieceOfFurniture.isDoorOrWindow();
            n |= homePieceOfFurniture.isVisible();
            n2 &= homePieceOfFurniture.isModelMirrored();
            if (homePieceOfFurniture.getPrice() != null) {
                if (this.price == null) {
                    this.price = homePieceOfFurniture.getPrice();
                    this.priceValueAddedTaxIncluded = homePieceOfFurniture.getPriceValueAddedTaxIncluded();
                } else {
                    this.price = this.price.add(homePieceOfFurniture.getPrice());
                    this.priceValueAddedTaxIncluded = this.priceValueAddedTaxIncluded.add(homePieceOfFurniture.getPriceValueAddedTaxIncluded());
                }
            }
            if (homePieceOfFurniture.getValueAddedTax() != null) {
                this.valueAddedTax = this.valueAddedTax == null ? homePieceOfFurniture.getValueAddedTax() : this.valueAddedTax.add(homePieceOfFurniture.getValueAddedTax());
            }
            if (this.valueAddedTaxPercentage == null || homePieceOfFurniture.getValueAddedTaxPercentage() != null && homePieceOfFurniture.getValueAddedTaxPercentage().equals(this.valueAddedTaxPercentage)) continue;
            this.valueAddedTaxPercentage = null;
        }
        if (this.resizable) {
            super.setWidth((float)rectangle2D.getWidth());
            super.setDepth((float)rectangle2D.getHeight());
            super.setHeight(f2 - f);
        } else {
            this.fixedWidth = (float)rectangle2D.getWidth();
            this.fixedDepth = (float)rectangle2D.getHeight();
            this.fixedHeight = f2 - f;
        }
        this.setName(string);
        this.setNameVisible(false);
        this.setNameXOffset(0.0f);
        this.setNameYOffset(0.0f);
        this.setNameStyle(null);
        this.setDescription(null);
        this.setMovable(bl);
        this.setVisible(n != 0);
        super.setColor(null);
        super.setTexture(null);
        super.setX((float)rectangle2D.getCenterX());
        super.setY((float)rectangle2D.getCenterY());
        super.setElevation(f);
        super.setAngle(0.0f);
        super.setModelMirrored(n2 != 0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.deformable = true;
        objectInputStream.defaultReadObject();
    }

    private List<HomePieceOfFurniture> getFurnitureWithoutGroups(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getFurnitureWithoutGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public List<HomePieceOfFurniture> getFurniture() {
        return this.furniture;
    }

    @Override
    public String getCatalogId() {
        return null;
    }

    @Override
    public boolean isMovable() {
        return super.isMovable();
    }

    @Override
    public void setMovable(boolean bl) {
        super.setMovable(bl);
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setMovable(bl);
        }
    }

    @Override
    public boolean isDoorOrWindow() {
        return this.doorOrWindow;
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isDeformable() {
        return this.deformable;
    }

    @Override
    public float getWidth() {
        if (!this.resizable) {
            return this.fixedWidth;
        }
        return super.getWidth();
    }

    @Override
    public float getDepth() {
        if (!this.resizable) {
            return this.fixedDepth;
        }
        return super.getDepth();
    }

    @Override
    public float getHeight() {
        if (!this.resizable) {
            return this.fixedHeight;
        }
        return super.getHeight();
    }

    @Override
    public Content getIcon() {
        return null;
    }

    @Override
    public Content getPlanIcon() {
        return null;
    }

    @Override
    public Content getModel() {
        return null;
    }

    @Override
    public float[][] getModelRotation() {
        return IDENTITY;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    @Override
    public BigDecimal getValueAddedTaxPercentage() {
        return this.priceValueAddedTaxIncluded;
    }

    @Override
    public BigDecimal getValueAddedTax() {
        return this.valueAddedTax;
    }

    @Override
    public BigDecimal getPriceValueAddedTaxIncluded() {
        return this.priceValueAddedTaxIncluded;
    }

    @Override
    public boolean isBackFaceShown() {
        return false;
    }

    @Override
    public void setColor(Integer n) {
        super.setColor(n);
        if (n != null) {
            this.storeDefaultColorsAndTextures();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setTexture(null);
                homePieceOfFurniture.setColor(n);
            }
        } else if (this.getTexture() == null) {
            this.restoreDefaultColorsAndTextures();
        }
    }

    @Override
    public void setTexture(HomeTexture homeTexture) {
        super.setTexture(homeTexture);
        if (homeTexture != null) {
            this.storeDefaultColorsAndTextures();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setColor(null);
                homePieceOfFurniture.setTexture(homeTexture);
            }
        } else if (this.getColor() == null) {
            this.restoreDefaultColorsAndTextures();
        }
    }

    private void storeDefaultColorsAndTextures() {
        if (this.furnitureDefaultColors == null) {
            Integer[] integerArray = new Integer[this.furniture.size()];
            HomeTexture[] homeTextureArray = new HomeTexture[this.furniture.size()];
            for (int i = 0; i < this.furniture.size(); ++i) {
                integerArray[i] = this.furniture.get(i).getColor();
                homeTextureArray[i] = this.furniture.get(i).getTexture();
            }
            this.furnitureDefaultColors = Arrays.asList(integerArray);
            this.furnitureDefaultTextures = Arrays.asList(homeTextureArray);
        }
    }

    private void restoreDefaultColorsAndTextures() {
        if (this.furnitureDefaultColors != null) {
            for (int i = 0; i < this.furniture.size(); ++i) {
                this.furniture.get(i).setColor(this.furnitureDefaultColors.get(i));
                this.furniture.get(i).setTexture(this.furnitureDefaultTextures.get(i));
            }
            this.furnitureDefaultColors = null;
            this.furnitureDefaultTextures = null;
        }
    }

    @Override
    public void setAngle(float f) {
        if (f != this.getAngle()) {
            float f2 = f - this.getAngle();
            super.setAngle(f);
            double d = Math.cos(f2);
            double d2 = Math.sin(f2);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setAngle(homePieceOfFurniture.getAngle() + f2);
                float f3 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d - (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f4 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                homePieceOfFurniture.setX(f3);
                homePieceOfFurniture.setY(f4);
            }
        }
    }

    @Override
    public void setX(float f) {
        if (f != this.getX()) {
            float f2 = f - this.getX();
            super.setX(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setX(homePieceOfFurniture.getX() + f2);
            }
        }
    }

    @Override
    public void setY(float f) {
        if (f != this.getY()) {
            float f2 = f - this.getY();
            super.setY(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setY(homePieceOfFurniture.getY() + f2);
            }
        }
    }

    @Override
    public void setWidth(float f) {
        if (f != this.getWidth()) {
            float f2 = f / this.getWidth();
            super.setWidth(f);
            float f3 = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                float f4 = homePieceOfFurniture.getAngle() - f3;
                float f5 = homePieceOfFurniture.getWidth();
                float f6 = homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setWidth(f5 + f5 * (f2 - 1.0f) * Math.abs((float)Math.cos(f4)));
                homePieceOfFurniture.setDepth(f6 + f6 * (f2 - 1.0f) * Math.abs((float)Math.sin(f4)));
                double d = Math.cos(f3);
                double d2 = Math.sin(f3);
                float f7 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f8 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f7 = this.getX() + (f7 - this.getX()) * f2;
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f7 - this.getX()) * d - (double)(f8 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f7 - this.getX()) * d2 + (double)(f8 - this.getY()) * d));
            }
        }
    }

    @Override
    public void setDepth(float f) {
        if (f != this.getDepth()) {
            float f2 = f / this.getDepth();
            super.setDepth(f);
            float f3 = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                float f4 = homePieceOfFurniture.getAngle() - f3;
                float f5 = homePieceOfFurniture.getWidth();
                float f6 = homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setWidth(f5 + f5 * (f2 - 1.0f) * Math.abs((float)Math.sin(f4)));
                homePieceOfFurniture.setDepth(f6 + f6 * (f2 - 1.0f) * Math.abs((float)Math.cos(f4)));
                double d = Math.cos(f3);
                double d2 = Math.sin(f3);
                float f7 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f8 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f8 = this.getY() + (f8 - this.getY()) * f2;
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f7 - this.getX()) * d - (double)(f8 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f7 - this.getX()) * d2 + (double)(f8 - this.getY()) * d));
            }
        }
    }

    @Override
    public void setHeight(float f) {
        if (f != this.getHeight()) {
            float f2 = f / this.getHeight();
            super.setHeight(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setHeight(homePieceOfFurniture.getHeight() * f2);
                homePieceOfFurniture.setElevation(this.getElevation() + (homePieceOfFurniture.getElevation() - this.getElevation()) * f2);
            }
        }
    }

    @Override
    public void setElevation(float f) {
        if (f != this.getElevation()) {
            float f2 = f - this.getElevation();
            super.setElevation(f);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setElevation(homePieceOfFurniture.getElevation() + f2);
            }
        }
    }

    @Override
    public void setModelMirrored(boolean bl) {
        if (bl != this.isModelMirrored()) {
            super.setModelMirrored(bl);
            float f = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setModelMirrored(!homePieceOfFurniture.isModelMirrored());
                double d = Math.cos(f);
                double d2 = Math.sin(f);
                float f2 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f3 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f2 = this.getX() - (f2 - this.getX());
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f2 - this.getX()) * d - (double)(f3 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f2 - this.getX()) * d2 + (double)(f3 - this.getY()) * d));
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setVisible(bl);
        }
    }

    @Override
    public HomeFurnitureGroup clone() {
        HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)super.clone();
        homeFurnitureGroup.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homeFurnitureGroup.furniture.add(homePieceOfFurniture.clone());
        }
        homeFurnitureGroup.furniture = Collections.unmodifiableList(homeFurnitureGroup.furniture);
        if (this.furnitureDefaultColors != null) {
            homeFurnitureGroup.furnitureDefaultColors = new ArrayList<Integer>(this.furnitureDefaultColors);
        }
        if (this.furnitureDefaultTextures != null) {
            homeFurnitureGroup.furnitureDefaultTextures = new ArrayList<HomeTexture>(this.furnitureDefaultTextures);
        }
        return homeFurnitureGroup;
    }
}

