/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.IllegalHomonymException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexturesCategory
implements Comparable<TexturesCategory> {
    private final String name;
    private List<CatalogTexture> textures;
    private boolean sorted;
    private static final Collator COMPARATOR = Collator.getInstance();

    public TexturesCategory(String string) {
        this.name = string;
        this.textures = new ArrayList<CatalogTexture>();
    }

    public String getName() {
        return this.name;
    }

    public List<CatalogTexture> getTextures() {
        this.checkFurnitureSorted();
        return Collections.unmodifiableList(this.textures);
    }

    private void checkFurnitureSorted() {
        if (!this.sorted) {
            Collections.sort(this.textures);
            this.sorted = true;
        }
    }

    public int getTexturesCount() {
        return this.textures.size();
    }

    public CatalogTexture getTexture(int n) {
        this.checkFurnitureSorted();
        return this.textures.get(n);
    }

    void add(CatalogTexture catalogTexture) {
        if (this.textures.contains(catalogTexture)) {
            throw new IllegalHomonymException(catalogTexture.getName() + " already in category " + this.name);
        }
        catalogTexture.setCategory(this);
        this.textures.add(catalogTexture);
        this.sorted = false;
    }

    void delete(CatalogTexture catalogTexture) {
        int n = this.textures.indexOf(catalogTexture);
        if (n == -1) {
            throw new IllegalArgumentException(this.name + " doesn't contain texture " + catalogTexture.getName());
        }
        this.textures = new ArrayList<CatalogTexture>(this.textures);
        this.textures.remove(n);
    }

    public boolean equals(Object object) {
        return object instanceof TexturesCategory && COMPARATOR.equals(this.name, ((TexturesCategory)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(TexturesCategory texturesCategory) {
        return COMPARATOR.compare(this.name, texturesCategory.name);
    }
}

