/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.PatternsCatalog;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserPreferences {
    private static final String[] SUPPORTED_LANGUAGES;
    private static final List<ClassLoader> DEFAULT_CLASS_LOADER;
    private static final TextStyle DEFAULT_TEXT_STYLE;
    private static final TextStyle DEFAULT_ROOM_TEXT_STYLE;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<Class<?>, ResourceBundle> classResourceBundles = new HashMap();
    private final Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();
    private FurnitureCatalog furnitureCatalog;
    private TexturesCatalog texturesCatalog;
    private PatternsCatalog patternsCatalog;
    private final String defaultCountry = Locale.getDefault().getCountry();
    private String language;
    private String currency;
    private LengthUnit unit;
    private boolean furnitureCatalogViewedInTree = true;
    private boolean navigationPanelVisible = true;
    private boolean magnetismEnabled = true;
    private boolean rulersVisible = true;
    private boolean gridVisible = true;
    private boolean furnitureViewedFromTop;
    private boolean roomFloorColoredOrTextured;
    private TextureImage wallPattern;
    private float newWallThickness;
    private float newWallHeight;
    private List<String> recentHomes;
    private int autoSaveDelayForRecovery;

    public UserPreferences() {
        String string = Locale.getDefault().getLanguage();
        for (String string2 : SUPPORTED_LANGUAGES) {
            if (string2.equals(string + "_" + this.defaultCountry)) {
                this.language = string2;
                break;
            }
            if (this.language != null || !string2.startsWith(string)) continue;
            this.language = string2;
        }
        if (this.language == null) {
            this.language = "en";
        }
        this.updateDefaultLocale();
    }

    private void updateDefaultLocale() {
        int n = this.language.indexOf("_");
        if (n != -1) {
            Locale.setDefault(new Locale(this.language.substring(0, n), this.language.substring(n + 1)));
        } else {
            Locale.setDefault(new Locale(this.language, this.defaultCountry));
        }
    }

    public abstract void write() throws RecorderException;

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public FurnitureCatalog getFurnitureCatalog() {
        return this.furnitureCatalog;
    }

    protected void setFurnitureCatalog(FurnitureCatalog furnitureCatalog) {
        this.furnitureCatalog = furnitureCatalog;
    }

    public TexturesCatalog getTexturesCatalog() {
        return this.texturesCatalog;
    }

    protected void setTexturesCatalog(TexturesCatalog texturesCatalog) {
        this.texturesCatalog = texturesCatalog;
    }

    public PatternsCatalog getPatternsCatalog() {
        return this.patternsCatalog;
    }

    protected void setPatternsCatalog(PatternsCatalog patternsCatalog) {
        this.patternsCatalog = patternsCatalog;
    }

    public LengthUnit getLengthUnit() {
        return this.unit;
    }

    public void setUnit(LengthUnit lengthUnit) {
        if (this.unit != lengthUnit) {
            LengthUnit lengthUnit2 = this.unit;
            this.unit = lengthUnit;
            this.propertyChangeSupport.firePropertyChange(Property.UNIT.name(), (Object)lengthUnit2, (Object)lengthUnit);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        if (!string.equals(this.language)) {
            String string2 = this.language;
            this.language = string;
            this.updateDefaultLocale();
            this.classResourceBundles.clear();
            this.resourceBundles.clear();
            this.propertyChangeSupport.firePropertyChange(Property.LANGUAGE.name(), string2, string);
        }
    }

    public String[] getSupportedLanguages() {
        return (String[])SUPPORTED_LANGUAGES.clone();
    }

    public String getLocalizedString(Class<?> clazz, String string, Object ... objectArray) {
        ResourceBundle resourceBundle = this.classResourceBundles.get(clazz);
        if (resourceBundle == null) {
            try {
                resourceBundle = this.getResourceBundle(clazz.getName());
                this.classResourceBundles.put(clazz, resourceBundle);
            }
            catch (IOException iOException) {
                try {
                    String string2 = clazz.getName();
                    int n = string2.lastIndexOf(".");
                    String string3 = n != -1 ? string2.substring(0, n) + ".package" : "package";
                    resourceBundle = new PrefixedResourceBundle(this.getResourceBundle(string3), clazz.getSimpleName() + ".");
                    this.classResourceBundles.put(clazz, resourceBundle);
                }
                catch (IOException iOException2) {
                    throw new IllegalArgumentException("Can't find resource bundle for " + clazz, iOException);
                }
            }
        }
        return this.getLocalizedString(resourceBundle, string, objectArray);
    }

    public String getLocalizedString(String string, String string2, Object ... objectArray) {
        try {
            ResourceBundle resourceBundle = this.getResourceBundle(string);
            return this.getLocalizedString(resourceBundle, string2, objectArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Can't find resource bundle for " + string, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundle(String string) throws IOException {
        String[] stringArray;
        ResourceBundle resourceBundle = this.resourceBundles.get(string = string.replace('.', '/'));
        if (resourceBundle != null) {
            return resourceBundle;
        }
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        block3: for (String string4 : stringArray = new String[]{".properties", "_" + string2 + ".properties", "_" + string2 + "_" + string3 + ".properties"}) {
            for (ClassLoader classLoader : this.getResourceClassLoaders()) {
                InputStream inputStream = classLoader.getResourceAsStream(string + string4);
                if (inputStream == null) continue;
                final ResourceBundle resourceBundle2 = resourceBundle;
                try {
                    resourceBundle = new PropertyResourceBundle(inputStream){
                        {
                            super(inputStream);
                            this.setParent(resourceBundle2);
                        }
                    };
                    continue block3;
                }
                finally {
                    inputStream.close();
                }
            }
        }
        if (resourceBundle == null) {
            throw new IOException("No available resource bundle for " + string);
        }
        this.resourceBundles.put(string, resourceBundle);
        return resourceBundle;
    }

    private String getLocalizedString(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        try {
            String string2 = resourceBundle.getString(string);
            if (objectArray.length > 0) {
                string2 = String.format(string2, objectArray);
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("Unknown key " + string);
        }
    }

    public List<ClassLoader> getResourceClassLoaders() {
        return DEFAULT_CLASS_LOADER;
    }

    public String getCurrency() {
        return this.currency;
    }

    protected void setCurrency(String string) {
        this.currency = string;
    }

    public boolean isFurnitureCatalogViewedInTree() {
        return this.furnitureCatalogViewedInTree;
    }

    public void setFurnitureCatalogViewedInTree(boolean bl) {
        if (this.furnitureCatalogViewedInTree != bl) {
            this.furnitureCatalogViewedInTree = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_CATALOG_VIEWED_IN_TREE.name(), !bl, bl);
        }
    }

    public boolean isNavigationPanelVisible() {
        return this.navigationPanelVisible;
    }

    public void setNavigationPanelVisible(boolean bl) {
        if (this.navigationPanelVisible != bl) {
            this.navigationPanelVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAVIGATION_PANEL_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isMagnetismEnabled() {
        return this.magnetismEnabled;
    }

    public void setMagnetismEnabled(boolean bl) {
        if (this.magnetismEnabled != bl) {
            this.magnetismEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MAGNETISM_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isRulersVisible() {
        return this.rulersVisible;
    }

    public void setRulersVisible(boolean bl) {
        if (this.rulersVisible != bl) {
            this.rulersVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RULERS_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        if (this.gridVisible != bl) {
            this.gridVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.GRID_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isFurnitureViewedFromTop() {
        return this.furnitureViewedFromTop;
    }

    public void setFurnitureViewedFromTop(boolean bl) {
        if (this.furnitureViewedFromTop != bl) {
            this.furnitureViewedFromTop = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_VIEWED_FROM_TOP.name(), !bl, bl);
        }
    }

    public boolean isRoomFloorColoredOrTextured() {
        return this.roomFloorColoredOrTextured;
    }

    public void setFloorColoredOrTextured(boolean bl) {
        if (this.roomFloorColoredOrTextured != bl) {
            this.roomFloorColoredOrTextured = bl;
            this.propertyChangeSupport.firePropertyChange(Property.ROOM_FLOOR_COLORED_OR_TEXTURED.name(), !bl, bl);
        }
    }

    public TextureImage getWallPattern() {
        return this.wallPattern;
    }

    public void setWallPattern(TextureImage textureImage) {
        if (this.wallPattern != textureImage) {
            TextureImage textureImage2 = this.wallPattern;
            this.wallPattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.WALL_PATTERN.name(), textureImage2, textureImage);
        }
    }

    public float getNewWallThickness() {
        return this.newWallThickness;
    }

    public void setNewWallThickness(float f) {
        if (this.newWallThickness != f) {
            float f2 = this.newWallThickness;
            this.newWallThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewWallHeight() {
        return this.newWallHeight;
    }

    public void setNewWallHeight(float f) {
        if (this.newWallHeight != f) {
            float f2 = this.newWallHeight;
            this.newWallHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public int getAutoSaveDelayForRecovery() {
        return this.autoSaveDelayForRecovery;
    }

    public void setAutoSaveDelayForRecovery(int n) {
        if (this.autoSaveDelayForRecovery != n) {
            float f = this.autoSaveDelayForRecovery;
            this.autoSaveDelayForRecovery = n;
            this.propertyChangeSupport.firePropertyChange(Property.AUTO_SAVE_DELAY_FOR_RECOVERY.name(), Float.valueOf(f), (Object)n);
        }
    }

    public List<String> getRecentHomes() {
        return Collections.unmodifiableList(this.recentHomes);
    }

    public void setRecentHomes(List<String> list) {
        if (!((Object)list).equals(this.recentHomes)) {
            List<String> list2 = this.recentHomes;
            this.recentHomes = new ArrayList<String>(list);
            this.propertyChangeSupport.firePropertyChange(Property.RECENT_HOMES.name(), list2, this.getRecentHomes());
        }
    }

    public int getRecentHomesMaxCount() {
        return 10;
    }

    public void setActionTipIgnored(String string) {
        this.propertyChangeSupport.firePropertyChange(Property.IGNORED_ACTION_TIP.name(), null, string);
    }

    public boolean isActionTipIgnored(String string) {
        return true;
    }

    public void resetIgnoredActionTips() {
        this.propertyChangeSupport.firePropertyChange(Property.IGNORED_ACTION_TIP.name(), null, null);
    }

    public TextStyle getDefaultTextStyle(Class<? extends Selectable> clazz) {
        if (Room.class.isAssignableFrom(clazz)) {
            return DEFAULT_ROOM_TEXT_STYLE;
        }
        return DEFAULT_TEXT_STYLE;
    }

    public abstract void addLanguageLibrary(String var1) throws RecorderException;

    public abstract boolean languageLibraryExists(String var1) throws RecorderException;

    public abstract void addFurnitureLibrary(String var1) throws RecorderException;

    public abstract boolean furnitureLibraryExists(String var1) throws RecorderException;

    public abstract void addTexturesLibrary(String var1) throws RecorderException;

    public abstract boolean texturesLibraryExists(String var1) throws RecorderException;

    static {
        DEFAULT_CLASS_LOADER = Arrays.asList(UserPreferences.class.getClassLoader());
        DEFAULT_TEXT_STYLE = new TextStyle(18.0f);
        DEFAULT_ROOM_TEXT_STYLE = new TextStyle(24.0f);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(UserPreferences.class.getName());
        SUPPORTED_LANGUAGES = resourceBundle.getString("supportedLanguages").split("\\s");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrefixedResourceBundle
    extends ResourceBundle {
        private ResourceBundle resourceBundle;
        private String keyPrefix;

        public PrefixedResourceBundle(ResourceBundle resourceBundle, String string) {
            this.resourceBundle = resourceBundle;
            this.keyPrefix = string;
        }

        @Override
        public Locale getLocale() {
            return this.resourceBundle.getLocale();
        }

        @Override
        protected Object handleGetObject(String string) {
            string = this.keyPrefix + string;
            return this.resourceBundle.getObject(string);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.resourceBundle.getKeys();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        LANGUAGE,
        UNIT,
        MAGNETISM_ENABLED,
        RULERS_VISIBLE,
        GRID_VISIBLE,
        FURNITURE_VIEWED_FROM_TOP,
        ROOM_FLOOR_COLORED_OR_TEXTURED,
        WALL_PATTERN,
        NEW_WALL_HEIGHT,
        NEW_WALL_THICKNESS,
        RECENT_HOMES,
        IGNORED_ACTION_TIP,
        FURNITURE_CATALOG_VIEWED_IN_TREE,
        NAVIGATION_PANEL_VISIBLE,
        AUTO_SAVE_DELAY_FOR_RECOVERY;

    }
}

