/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.plugin;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.plugin.Plugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String LICENSE = "license";
    private static final String PROVIDER = "provider";
    private static final String APPLICATION_MINIMUM_VERSION = "applicationMinimumVersion";
    private static final String JAVA_MINIMUM_VERSION = "javaMinimumVersion";
    private static final String APPLICATION_PLUGIN_FAMILY = "ApplicationPlugin";
    private static final String DEFAULT_APPLICATION_PLUGIN_PROPERTIES_FILE = "ApplicationPlugin.properties";
    private final File[] pluginFolders;
    private final Map<String, PluginDefinition> pluginDefinitions = new TreeMap<String, PluginDefinition>();
    private final Map<Home, List<Plugin>> homePlugins = new HashMap<Home, List<Plugin>>();

    public PluginManager(File file) {
        this(new File[]{file});
    }

    public PluginManager(File[] fileArray) {
        this.pluginFolders = fileArray;
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder());
                for (File file2 : fileArray2) {
                    try {
                        this.loadPlugins(file2.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public PluginManager(URL[] uRLArray) {
        this.pluginFolders = null;
        for (URL uRL : uRLArray) {
            this.loadPlugins(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugins(URL uRL) {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(uRL.openStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                int n = string.lastIndexOf(DEFAULT_APPLICATION_PLUGIN_PROPERTIES_FILE);
                if (n == -1 || n != 0 && string.charAt(n - 1) != '/') continue;
                try {
                    String string2 = string.substring(0, n);
                    string2 = string2 + APPLICATION_PLUGIN_FAMILY;
                    URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader());
                    this.readPlugin(ResourceBundle.getBundle(string2, Locale.getDefault(), uRLClassLoader), "jar:" + uRL.toString() + "!/" + URLEncoder.encode(string, "UTF-8").replace("+", "%20"), uRLClassLoader);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readPlugin(ResourceBundle resourceBundle, String string, ClassLoader classLoader) {
        try {
            String string2 = resourceBundle.getString(NAME);
            String string3 = resourceBundle.getString(JAVA_MINIMUM_VERSION);
            if (!this.isJavaVersionSuperiorTo(string3)) {
                System.err.println("Invalid plug-in " + string + ":\n" + "Not compatible Java version " + System.getProperty("java.version"));
                return;
            }
            String string4 = resourceBundle.getString(APPLICATION_MINIMUM_VERSION);
            if (!this.isApplicationVersionSuperiorTo(string4)) {
                System.err.println("Invalid plug-in " + string + ":\n" + "Not compatible application version");
                return;
            }
            String string5 = resourceBundle.getString(CLASS);
            Class<? extends Plugin> clazz = this.getPluginClass(classLoader, string5);
            String string6 = resourceBundle.getString(DESCRIPTION);
            String string7 = resourceBundle.getString(VERSION);
            String string8 = resourceBundle.getString(LICENSE);
            String string9 = resourceBundle.getString(PROVIDER);
            if (this.pluginDefinitions.get(string2) == null) {
                this.pluginDefinitions.put(string2, new PluginDefinition(string2, clazz, classLoader, string6, string7, string8, string9));
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Invalid plug-in " + string + ":\n" + missingResourceException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Invalid plug-in " + string + ":\n" + illegalArgumentException.getMessage());
        }
    }

    private boolean isJavaVersionSuperiorTo(String string) {
        String string2 = System.getProperty("java.version");
        String[] stringArray = string2.split("\\.|_");
        String[] stringArray2 = string.split("\\.|_");
        if (stringArray.length >= 1 && stringArray2.length >= 1) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray2[0]);
                if (n > n2) {
                    return true;
                }
                if (n == n2 && stringArray.length >= 2 && stringArray2.length >= 2) {
                    return Integer.parseInt(stringArray[1]) >= Integer.parseInt(stringArray2[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isApplicationVersionSuperiorTo(String string) {
        String[] stringArray = string.split("\\.|_|\\s");
        if (stringArray.length >= 1) {
            try {
                int n = 3;
                int n2 = Integer.parseInt(stringArray[0]);
                if (n > n2) {
                    return true;
                }
                if (n == n2 && stringArray.length >= 2) {
                    return 3L >= (long)Integer.parseInt(stringArray[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private Class<? extends Plugin> getPluginClass(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            if (!Plugin.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(string + " not a subclass of " + Plugin.class.getName());
            }
            if (Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException(string + " not a public static class");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException(string + " constructor not accessible");
            }
            return clazz;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IllegalArgumentException(noClassDefFoundError.getMessage(), noClassDefFoundError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
    }

    public List<Plugin> getPlugins(final HomeApplication homeApplication, final Home home, UserPreferences userPreferences, UndoableEditSupport undoableEditSupport) {
        if (homeApplication.getHomes().contains(home)) {
            List<Plugin> list = this.homePlugins.get(home);
            if (list == null) {
                list = new ArrayList<Plugin>();
                for (PluginDefinition pluginDefinition : this.pluginDefinitions.values()) {
                    try {
                        Plugin plugin = pluginDefinition.getPluginClass().newInstance();
                        plugin.setPluginClassLoader(pluginDefinition.getPluginClassLoader());
                        plugin.setName(pluginDefinition.getName());
                        plugin.setDescription(pluginDefinition.getDescription());
                        plugin.setVersion(pluginDefinition.getVersion());
                        plugin.setLicense(pluginDefinition.getLicense());
                        plugin.setProvider(pluginDefinition.getProvider());
                        plugin.setUserPreferences(userPreferences);
                        plugin.setHome(home);
                        plugin.setUndoableEditSupport(undoableEditSupport);
                        list.add(plugin);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RuntimeException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
                list = Collections.unmodifiableList(list);
                this.homePlugins.put(home, list);
                homeApplication.addHomesListener(new CollectionListener<Home>(){

                    @Override
                    public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                        if (collectionEvent.getType() == CollectionEvent.Type.DELETE && collectionEvent.getItem() == home) {
                            for (Plugin plugin : (List)PluginManager.this.homePlugins.get(home)) {
                                plugin.destroy();
                            }
                            PluginManager.this.homePlugins.remove(home);
                            homeApplication.removeHomesListener(this);
                        }
                    }
                });
            }
            return list;
        }
        return Collections.emptyList();
    }

    public boolean pluginExists(String string) throws RecorderException {
        if (this.pluginFolders == null || this.pluginFolders.length == 0) {
            throw new RecorderException("Can't access to plugins folder");
        }
        String string2 = new File(string).getName();
        return new File(this.pluginFolders[0], string2).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlugin(String string) throws RecorderException {
        try {
            if (this.pluginFolders == null || this.pluginFolders.length == 0) {
                throw new RecorderException("Can't access to plugins folder");
            }
            String string2 = new File(string).getName();
            File file = new File(this.pluginFolders[0], string2);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = new BufferedInputStream(new FileInputStream(string));
                this.pluginFolders[0].mkdirs();
                outputStream = new FileOutputStream(file);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in furniture libraries plugin folder", iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginDefinition {
        private final String name;
        private final Class<? extends Plugin> pluginClass;
        private final ClassLoader pluginClassLoader;
        private final String description;
        private final String version;
        private final String license;
        private final String provider;

        public PluginDefinition(String string, Class<? extends Plugin> clazz, ClassLoader classLoader, String string2, String string3, String string4, String string5) {
            this.name = string;
            this.pluginClass = clazz;
            this.pluginClassLoader = classLoader;
            this.description = string2;
            this.version = string3;
            this.license = string4;
            this.provider = string5;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends Plugin> getPluginClass() {
            return this.pluginClass;
        }

        public ClassLoader getPluginClassLoader() {
            return this.pluginClassLoader;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public String getLicense() {
            return this.license;
        }

        public String getProvider() {
            return this.provider;
        }
    }
}

