/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FileContentManager
implements ContentManager {
    private static final String OBJ_EXTENSION = ".obj";
    private static final FileFilter[] OBJ_FILTER = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.OBJ_EXTENSION);
        }

        public String getDescription() {
            return "OBJ - Wavefront";
        }
    }};
    private static final FileFilter[] MODEL_FILTERS = new FileFilter[]{OBJ_FILTER[0], new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".lws");
        }

        public String getDescription() {
            return "LWS - LightWave Scene";
        }
    }, new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".3ds");
        }

        public String getDescription() {
            return "3DS - 3D Studio";
        }
    }, new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".dae");
        }

        public String getDescription() {
            return "DAE - Collada";
        }
    }, new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".zip");
        }

        public String getDescription() {
            return "ZIP";
        }
    }};
    private static final String PNG_EXTENSION = ".png";
    private static final FileFilter[] PNG_FILTER = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.PNG_EXTENSION);
        }

        public String getDescription() {
            return "PNG";
        }
    }};
    private static final FileFilter[] IMAGE_FILTERS = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".bmp") || file.getName().toLowerCase().endsWith(".wbmp");
        }

        public String getDescription() {
            return "BMP";
        }
    }, new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".gif");
        }

        public String getDescription() {
            return "GIF";
        }
    }, new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".jpeg");
        }

        public String getDescription() {
            return "JPEG";
        }
    }, PNG_FILTER[0]};
    private static final String MOV_EXTENSION = ".mov";
    private static final FileFilter[] MOV_FILTER = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.MOV_EXTENSION);
        }

        public String getDescription() {
            return "MOV";
        }
    }};
    private static final String PDF_EXTENSION = ".pdf";
    private static final FileFilter[] PDF_FILTER = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.PDF_EXTENSION);
        }

        public String getDescription() {
            return "PDF";
        }
    }};
    private static final String SVG_EXTENSION = ".svg";
    private static final FileFilter[] SVG_FILTER = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.SVG_EXTENSION);
        }

        public String getDescription() {
            return "SVG - Scalable Vector Graphics";
        }
    }};
    private final UserPreferences preferences;
    private final String sweetHome3DFileExtension;
    private final String languageLibraryFileExtension;
    private final String furnitureLibraryFileExtension;
    private final String texturesLibraryFileExtension;
    private final String pluginFileExtension;
    private File currentDirectory;
    private Map<ContentManager.ContentType, FileFilter[]> fileFilters;
    private Map<ContentManager.ContentType, String> defaultFileExtensions;

    public FileContentManager(final UserPreferences userPreferences) {
        this.preferences = userPreferences;
        this.sweetHome3DFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "homeExtension", new Object[0]);
        this.languageLibraryFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "languageLibraryExtension", new Object[0]);
        this.furnitureLibraryFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "furnitureLibraryExtension", new Object[0]);
        this.texturesLibraryFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "texturesLibraryExtension", new Object[0]);
        this.pluginFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "pluginExtension", new Object[0]);
        this.fileFilters = new HashMap<ContentManager.ContentType, FileFilter[]>();
        this.fileFilters.put(ContentManager.ContentType.MODEL, MODEL_FILTERS);
        this.fileFilters.put(ContentManager.ContentType.IMAGE, IMAGE_FILTERS);
        this.fileFilters.put(ContentManager.ContentType.MOV, MOV_FILTER);
        this.fileFilters.put(ContentManager.ContentType.PNG, PNG_FILTER);
        this.fileFilters.put(ContentManager.ContentType.PDF, PDF_FILTER);
        this.fileFilters.put(ContentManager.ContentType.SVG, SVG_FILTER);
        this.fileFilters.put(ContentManager.ContentType.OBJ, OBJ_FILTER);
        this.fileFilters.put(ContentManager.ContentType.SWEET_HOME_3D, new FileFilter[]{new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.sweetHome3DFileExtension);
            }

            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "homeDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.LANGUAGE_LIBRARY, new FileFilter[]{new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.languageLibraryFileExtension);
            }

            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "languageLibraryDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.FURNITURE_LIBRARY, new FileFilter[]{new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.furnitureLibraryFileExtension);
            }

            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "furnitureLibraryDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.TEXTURES_LIBRARY, new FileFilter[]{new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.texturesLibraryFileExtension);
            }

            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "texturesLibraryDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.PLUGIN, new FileFilter[]{new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.pluginFileExtension);
            }

            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "pluginDescription", new Object[0]);
            }
        }});
        this.defaultFileExtensions = new HashMap<ContentManager.ContentType, String>();
        this.defaultFileExtensions.put(ContentManager.ContentType.SWEET_HOME_3D, this.sweetHome3DFileExtension);
        this.defaultFileExtensions.put(ContentManager.ContentType.LANGUAGE_LIBRARY, this.languageLibraryFileExtension);
        this.defaultFileExtensions.put(ContentManager.ContentType.FURNITURE_LIBRARY, this.furnitureLibraryFileExtension);
        this.defaultFileExtensions.put(ContentManager.ContentType.TEXTURES_LIBRARY, this.texturesLibraryFileExtension);
        this.defaultFileExtensions.put(ContentManager.ContentType.PLUGIN, this.pluginFileExtension);
        this.defaultFileExtensions.put(ContentManager.ContentType.PNG, PNG_EXTENSION);
        this.defaultFileExtensions.put(ContentManager.ContentType.MOV, MOV_EXTENSION);
        this.defaultFileExtensions.put(ContentManager.ContentType.PDF, PDF_EXTENSION);
        this.defaultFileExtensions.put(ContentManager.ContentType.SVG, SVG_EXTENSION);
        this.defaultFileExtensions.put(ContentManager.ContentType.OBJ, OBJ_EXTENSION);
    }

    public Content getContent(String string) throws RecorderException {
        try {
            return new URLContent(new File(string).toURI().toURL());
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't access to content " + string);
        }
    }

    public String getPresentationName(String string, ContentManager.ContentType contentType) {
        switch (contentType) {
            case SWEET_HOME_3D: {
                return new File(string).getName();
            }
        }
        String string2 = new File(string).getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected FileFilter[] getFileFilter(ContentManager.ContentType contentType) {
        if (contentType == ContentManager.ContentType.USER_DEFINED) {
            throw new IllegalArgumentException("Unknown user defined content type");
        }
        return this.fileFilters.get((Object)contentType);
    }

    public String getDefaultFileExtension(ContentManager.ContentType contentType) {
        if (contentType == ContentManager.ContentType.USER_DEFINED) {
            return null;
        }
        return this.defaultFileExtensions.get((Object)contentType);
    }

    public boolean isAcceptable(String string, ContentManager.ContentType contentType) {
        for (FileFilter fileFilter : this.getFileFilter(contentType)) {
            if (!fileFilter.accept(new File(string))) continue;
            return true;
        }
        return false;
    }

    public String showOpenDialog(View view, String string, ContentManager.ContentType contentType) {
        if (OperatingSystem.isMacOSX()) {
            return this.showFileDialog(view, string, contentType, null, false);
        }
        return this.showFileChooser(view, string, contentType, null, false);
    }

    public String showSaveDialog(View view, String string, ContentManager.ContentType contentType, String string2) {
        int n;
        String string3 = this.getDefaultFileExtension(contentType);
        if (string2 != null && (n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
            if (string3 != null) {
                string2 = string2 + string3;
            }
        }
        String string4 = OperatingSystem.isMacOSX() ? this.showFileDialog(view, string, contentType, string2, true) : this.showFileChooser(view, string, contentType, string2, true);
        boolean bl = false;
        if (string4 != null) {
            if (string3 != null && !string4.toLowerCase().endsWith(string3)) {
                string4 = string4 + string3;
                bl = true;
            }
            if (OperatingSystem.isMacOSX() && !bl) {
                return string4;
            }
            File file = new File(string4);
            if (file.exists() && !this.confirmOverwrite(view, file.getName())) {
                return this.showSaveDialog(view, string, contentType, string4);
            }
        }
        return string4;
    }

    private String showFileDialog(View view, String string, final ContentManager.ContentType contentType, String string2, boolean bl) {
        FileDialog fileDialog = new FileDialog(JOptionPane.getFrameForComponent((JComponent)((Object)view)));
        if (bl && string2 != null) {
            fileDialog.setFile(new File(string2).getName());
        }
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return FileContentManager.this.isAcceptable(new File(file, string).toString(), contentType);
            }
        });
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory.toString());
        }
        if (bl) {
            fileDialog.setMode(1);
        } else {
            fileDialog.setMode(0);
        }
        if (string == null) {
            string = this.getFileDialogTitle(bl);
        }
        fileDialog.setTitle(string);
        fileDialog.setVisible(true);
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            this.currentDirectory = new File(fileDialog.getDirectory());
            return this.currentDirectory + File.separator + string3;
        }
        return null;
    }

    private String showFileChooser(View view, String string, ContentManager.ContentType contentType, String string2, boolean bl) {
        FileFilter[] fileFilterArray;
        JFileChooser jFileChooser = new JFileChooser();
        if (bl && string2 != null) {
            jFileChooser.setSelectedFile(new File(string2));
        }
        FileFilter fileFilter = jFileChooser.getAcceptAllFileFilter();
        jFileChooser.addChoosableFileFilter(fileFilter);
        for (FileFilter fileFilter2 : fileFilterArray = this.getFileFilter(contentType)) {
            jFileChooser.addChoosableFileFilter(fileFilter2);
        }
        if (fileFilterArray.length == 1) {
            jFileChooser.setFileFilter(fileFilterArray[0]);
        } else {
            jFileChooser.setFileFilter(fileFilter);
        }
        if (this.currentDirectory != null) {
            jFileChooser.setCurrentDirectory(this.currentDirectory);
        }
        if (string == null) {
            string = this.getFileDialogTitle(bl);
        }
        jFileChooser.setDialogTitle(string);
        int n = bl ? jFileChooser.showSaveDialog((JComponent)((Object)view)) : jFileChooser.showOpenDialog((JComponent)((Object)view));
        if (n == 0) {
            this.currentDirectory = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile().toString();
        }
        return null;
    }

    protected String getFileDialogTitle(boolean bl) {
        if (bl) {
            return this.preferences.getLocalizedString(FileContentManager.class, "saveDialog.title", new Object[0]);
        }
        return this.preferences.getLocalizedString(FileContentManager.class, "openDialog.title", new Object[0]);
    }

    protected boolean confirmOverwrite(View view, String string) {
        String string2 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.message", string);
        String string3 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.overwrite", new Object[0]);
        String string5 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.cancel", new Object[0]);
        return JOptionPane.showOptionDialog(SwingUtilities.getRootPane((JComponent)((Object)view)), string2, string3, 2, 3, null, new Object[]{string4, string5}, string5) == 0;
    }
}

