/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FurnitureCatalogTree;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureCatalogListPanel
extends JPanel
implements View {
    private ListSelectionListener listSelectionListener;
    private JLabel categoryFilterLabel;
    private JComboBox categoryFilterComboBox;
    private JLabel searchLabel;
    private JTextField searchTextField;
    private JList catalogFurnitureList;

    public FurnitureCatalogListPanel(FurnitureCatalog furnitureCatalog, UserPreferences userPreferences, FurnitureCatalogController furnitureCatalogController) {
        super(new GridBagLayout());
        this.createComponents(furnitureCatalog, userPreferences, furnitureCatalogController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(FurnitureCatalog furnitureCatalog, final UserPreferences userPreferences, final FurnitureCatalogController furnitureCatalogController) {
        final CatalogListModel catalogListModel = new CatalogListModel(furnitureCatalog);
        this.catalogFurnitureList = new JList(catalogListModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)this.getModel().getElementAt(n);
                    String string = "<html><table><tr><td align='center'>- <b>" + catalogPieceOfFurniture.getCategory().getName() + "</b> -" + "<br><b>" + catalogPieceOfFurniture.getName() + "</b>";
                    if (catalogPieceOfFurniture.getCreator() != null) {
                        string = string + "<br>" + userPreferences.getLocalizedString(FurnitureCatalogTree.class, "tooltipCreator", catalogPieceOfFurniture.getCreator() + "</td></tr>");
                    }
                    if (catalogPieceOfFurniture.getIcon() instanceof URLContent) {
                        try {
                            BufferedImage bufferedImage = ImageIO.read(((URLContent)catalogPieceOfFurniture.getIcon()).getURL());
                            if (bufferedImage == null) {
                                return null;
                            }
                            int n2 = Math.round(128.0f * (float)Math.min(1, bufferedImage.getWidth() / bufferedImage.getHeight()));
                            int n3 = Math.round((float)n2 * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
                            string = string + "<tr><td width='128' height='128' align='center' valign='middle'><img width='" + n2 + "' height='" + n3 + "' src='" + ((URLContent)catalogPieceOfFurniture.getIcon()).getURL() + "'></td></tr>";
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    return string + "</table>";
                }
                return null;
            }
        };
        this.catalogFurnitureList.setLayoutOrientation(2);
        this.catalogFurnitureList.setCellRenderer(new CatalogCellRenderer());
        this.catalogFurnitureList.getActionMap().getParent().remove("selectAll");
        this.catalogFurnitureList.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && FurnitureCatalogListPanel.this.catalogFurnitureList.getSelectedValue() != null && FurnitureCatalogListPanel.this.catalogFurnitureList.getTransferHandler() != null) {
                    FurnitureCatalogListPanel.this.catalogFurnitureList.getTransferHandler().exportAsDrag(FurnitureCatalogListPanel.this.catalogFurnitureList, mouseEvent, 1);
                }
            }
        });
        this.catalogFurnitureList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = FurnitureCatalogListPanel.this.catalogFurnitureList.locationToIndex(mouseEvent.getPoint())) != -1) {
                    furnitureCatalogController.modifySelectedFurniture();
                }
            }
        });
        catalogListModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.catalogFurnitureList);
        this.catalogFurnitureList.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }
        });
        this.updateListSelectedFurniture(furnitureCatalog, furnitureCatalogController);
        this.addSelectionListeners(furnitureCatalog, furnitureCatalogController);
        this.categoryFilterLabel = new JLabel(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "categoryFilterLabel.text", new Object[0]));
        ArrayList<FurnitureCategory> arrayList = new ArrayList<FurnitureCategory>();
        arrayList.add(null);
        arrayList.addAll(furnitureCatalog.getCategories());
        this.categoryFilterComboBox = new JComboBox(new DefaultComboBoxModel<Object>(arrayList.toArray())){

            public Dimension getMinimumSize() {
                return new Dimension(60, super.getMinimumSize().height);
            }
        };
        this.categoryFilterComboBox.setMaximumRowCount(20);
        this.categoryFilterComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object == null) {
                    return super.getListCellRendererComponent((JList<?>)jList, userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "categoryFilterComboBox.noCategory", new Object[0]), n, bl, bl2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, ((FurnitureCategory)object).getName(), n, bl, bl2);
            }
        });
        this.categoryFilterComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                catalogListModel.setFilterCategory((FurnitureCategory)FurnitureCatalogListPanel.this.categoryFilterComboBox.getSelectedItem());
                FurnitureCatalogListPanel.this.catalogFurnitureList.clearSelection();
            }
        });
        this.searchLabel = new JLabel(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "searchLabel.text", new Object[0]));
        this.searchTextField = new JTextField(5);
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                Object e = FurnitureCatalogListPanel.this.catalogFurnitureList.getSelectedValue();
                catalogListModel.setFilterText(FurnitureCatalogListPanel.this.searchTextField.getText());
                FurnitureCatalogListPanel.this.catalogFurnitureList.clearSelection();
                FurnitureCatalogListPanel.this.catalogFurnitureList.setSelectedValue(e, true);
                if (catalogListModel.getSize() == 1) {
                    FurnitureCatalogListPanel.this.catalogFurnitureList.setSelectedIndex(0);
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.searchTextField.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "deleteContent");
        this.searchTextField.getActionMap().put("deleteContent", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FurnitureCatalogListPanel.this.searchTextField.setText("");
            }
        });
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            this.searchTextField.putClientProperty("JTextField.variant", "search");
        }
        PreferencesChangeListener preferencesChangeListener = new PreferencesChangeListener(this);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, preferencesChangeListener);
        furnitureCatalog.addFurnitureListener(preferencesChangeListener);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.categoryFilterLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "categoryFilterLabel.mnemonic", new Object[0])).getKeyCode());
            this.categoryFilterLabel.setLabelFor(this.categoryFilterComboBox);
            this.searchLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "searchLabel.mnemonic", new Object[0])).getKeyCode());
            this.searchLabel.setLabelFor(this.searchTextField);
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        Insets insets = new Insets(0, 2, 5, 3);
        Insets insets2 = new Insets(0, 2, 3, 0);
        if (!OperatingSystem.isMacOSX()) {
            insets.top = 2;
            insets2.top = 2;
            insets2.right = 2;
        }
        this.add((Component)this.categoryFilterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add((Component)this.categoryFilterComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            this.add((Component)this.searchTextField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 3, 0), 0, 0));
        } else {
            this.add((Component)this.searchLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.searchTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        JScrollPane jScrollPane = new JScrollPane(this.catalogFurnitureList);
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        SwingTools.installFocusBorder(this.catalogFurnitureList);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FurnitureCatalogListPanel.this.setFocusTraversalPolicyProvider(false);
                    }
                });
                return FurnitureCatalogListPanel.this.catalogFurnitureList;
            }
        });
    }

    private void spreadFurnitureIconsAlongListWidth() {
        int n = this.catalogFurnitureList.getModel().getSize();
        int n2 = ((JViewport)this.catalogFurnitureList.getParent()).getExtentSize().width;
        Dimension dimension = ((JComponent)((Object)this.catalogFurnitureList.getCellRenderer())).getPreferredSize();
        int n3 = dimension.width;
        int n4 = Math.max(1, n2 / n3);
        this.catalogFurnitureList.setVisibleRowCount(n % n4 == 0 ? n / n4 : n / n4 + 1);
        this.catalogFurnitureList.setFixedCellWidth(n3 + n2 % n3 / n4);
        this.catalogFurnitureList.setFixedCellHeight(dimension.height);
    }

    private void addSelectionListeners(final FurnitureCatalog furnitureCatalog, final FurnitureCatalogController furnitureCatalogController) {
        final SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureCatalogListPanel.this.updateListSelectedFurniture(furnitureCatalog, furnitureCatalogController);
            }
        };
        this.listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                furnitureCatalogController.removeSelectionListener(selectionListener);
                furnitureCatalogController.setSelectedFurniture(FurnitureCatalogListPanel.this.getSelectedFurniture());
                furnitureCatalogController.addSelectionListener(selectionListener);
            }
        };
        furnitureCatalogController.addSelectionListener(selectionListener);
        this.catalogFurnitureList.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    private void updateListSelectedFurniture(FurnitureCatalog furnitureCatalog, FurnitureCatalogController furnitureCatalogController) {
        if (this.listSelectionListener != null) {
            this.catalogFurnitureList.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        }
        this.catalogFurnitureList.clearSelection();
        List<CatalogPieceOfFurniture> list = furnitureCatalogController.getSelectedFurniture();
        if (list.size() > 0) {
            ListModel listModel = this.catalogFurnitureList.getModel();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            block0: for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
                int n = listModel.getSize();
                for (int i = 0; i < n; ++i) {
                    if (catalogPieceOfFurniture != listModel.getElementAt(i)) continue;
                    arrayList.add(i);
                    continue block0;
                }
            }
            Object object = new int[arrayList.size()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            this.catalogFurnitureList.setSelectedIndices((int[])object);
            this.catalogFurnitureList.ensureIndexIsVisible((int)object[0]);
        }
        if (this.listSelectionListener != null) {
            this.catalogFurnitureList.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        }
    }

    private List<CatalogPieceOfFurniture> getSelectedFurniture() {
        Object[] objectArray = this.catalogFurnitureList.getSelectedValues();
        CatalogPieceOfFurniture[] catalogPieceOfFurnitureArray = new CatalogPieceOfFurniture[objectArray.length];
        System.arraycopy(objectArray, 0, catalogPieceOfFurnitureArray, 0, objectArray.length);
        return Arrays.asList(catalogPieceOfFurnitureArray);
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this.catalogFurnitureList.setTransferHandler(transferHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.catalogFurnitureList.getTransferHandler();
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        this.catalogFurnitureList.setComponentPopupMenu(jPopupMenu);
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        return this.catalogFurnitureList.getComponentPopupMenu();
    }

    private static class CatalogListModel
    extends AbstractListModel {
        private FurnitureCatalog catalog;
        private List<CatalogPieceOfFurniture> furniture;
        private FurnitureCategory filterCategory;
        private Pattern filterNamePattern;

        public CatalogListModel(FurnitureCatalog furnitureCatalog) {
            this.catalog = furnitureCatalog;
            this.furniture = new ArrayList<CatalogPieceOfFurniture>();
            this.filterNamePattern = Pattern.compile(".*");
            furnitureCatalog.addFurnitureListener(new CatalogFurnitureListener(this));
            this.updateFurnitureList();
        }

        public void setFilterCategory(FurnitureCategory furnitureCategory) {
            this.filterCategory = furnitureCategory;
            this.updateFurnitureList();
        }

        public void setFilterText(String string) {
            this.filterNamePattern = Pattern.compile(".*" + string + ".*", 2);
            this.updateFurnitureList();
        }

        public Object getElementAt(int n) {
            return this.furniture.get(n);
        }

        public int getSize() {
            return this.furniture.size();
        }

        private void updateFurnitureList() {
            this.furniture.clear();
            for (FurnitureCategory furnitureCategory : this.catalog.getCategories()) {
                for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                    if (this.filterCategory != null && !catalogPieceOfFurniture.getCategory().equals(this.filterCategory) || !this.filterNamePattern.matcher(catalogPieceOfFurniture.getName()).matches() && !this.filterNamePattern.matcher(catalogPieceOfFurniture.getCategory().getName()).matches() && (catalogPieceOfFurniture.getCreator() == null || !this.filterNamePattern.matcher(catalogPieceOfFurniture.getCreator()).matches()) && (catalogPieceOfFurniture.getDescription() == null || !this.filterNamePattern.matcher(catalogPieceOfFurniture.getDescription()).matches())) continue;
                    this.furniture.add(catalogPieceOfFurniture);
                }
            }
            Collections.sort(this.furniture);
            this.fireContentsChanged(this, 0, this.furniture.size() - 1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CatalogFurnitureListener
        implements CollectionListener<CatalogPieceOfFurniture> {
            private WeakReference<CatalogListModel> catalogListModel;

            public CatalogFurnitureListener(CatalogListModel catalogListModel) {
                this.catalogListModel = new WeakReference<CatalogListModel>(catalogListModel);
            }

            @Override
            public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                CatalogListModel catalogListModel = (CatalogListModel)this.catalogListModel.get();
                FurnitureCatalog furnitureCatalog = (FurnitureCatalog)collectionEvent.getSource();
                if (catalogListModel == null) {
                    furnitureCatalog.removeFurnitureListener(this);
                } else {
                    catalogListModel.updateFurnitureList();
                }
            }
        }
    }

    private static class CatalogCellRenderer
    extends DefaultListCellRenderer {
        private static final int DEFAULT_ICON_HEIGHT = 48;
        private Font defaultFont;
        private Font modifiablePieceFont;

        private CatalogCellRenderer() {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.defaultFont = UIManager.getFont("ToolTip.font");
            this.modifiablePieceFont = new Font(this.defaultFont.getFontName(), 2, this.defaultFont.getSize());
            this.setFont(this.defaultFont);
            this.setText("");
            this.setIcon(IconManager.getInstance().getWaitIcon(48));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setText(" " + catalogPieceOfFurniture.getName() + " ");
            jLabel.setIcon(this.getLabelIcon(jList, catalogPieceOfFurniture.getIcon()));
            jLabel.setFont(catalogPieceOfFurniture.isModifiable() ? this.modifiablePieceFont : this.defaultFont);
            return jLabel;
        }

        private Icon getLabelIcon(JList jList, Content content) {
            return IconManager.getInstance().getIcon(content, 48, jList);
        }

        protected void paintComponent(Graphics graphics) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(77, super.getPreferredSize().height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreferencesChangeListener
    implements PropertyChangeListener,
    CollectionListener<CatalogPieceOfFurniture> {
        private final WeakReference<FurnitureCatalogListPanel> furnitureCatalogPanel;

        public PreferencesChangeListener(FurnitureCatalogListPanel furnitureCatalogListPanel) {
            this.furnitureCatalogPanel = new WeakReference<FurnitureCatalogListPanel>(furnitureCatalogListPanel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureCatalogListPanel furnitureCatalogListPanel = (FurnitureCatalogListPanel)this.furnitureCatalogPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (furnitureCatalogListPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                furnitureCatalogListPanel.categoryFilterLabel.setText(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "categoryFilterLabel.text", new Object[0]));
                furnitureCatalogListPanel.searchLabel.setText(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "searchLabel.text", new Object[0]));
                furnitureCatalogListPanel.setMnemonics(userPreferences);
                ArrayList<FurnitureCategory> arrayList = new ArrayList<FurnitureCategory>();
                arrayList.add(null);
                arrayList.addAll(userPreferences.getFurnitureCatalog().getCategories());
                furnitureCatalogListPanel.categoryFilterComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
            }
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            FurnitureCatalogListPanel furnitureCatalogListPanel = (FurnitureCatalogListPanel)this.furnitureCatalogPanel.get();
            FurnitureCatalog furnitureCatalog = (FurnitureCatalog)collectionEvent.getSource();
            if (furnitureCatalogListPanel == null) {
                furnitureCatalog.removeFurnitureListener(this);
            } else {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)furnitureCatalogListPanel.categoryFilterComboBox.getModel();
                FurnitureCategory furnitureCategory = collectionEvent.getItem().getCategory();
                List<FurnitureCategory> list = furnitureCatalog.getCategories();
                if (!list.contains(furnitureCategory)) {
                    defaultComboBoxModel.removeElement(furnitureCategory);
                    furnitureCatalogListPanel.categoryFilterComboBox.setSelectedIndex(0);
                } else if (defaultComboBoxModel.getIndexOf(furnitureCategory) == -1) {
                    defaultComboBoxModel.insertElementAt(furnitureCategory, list.indexOf(furnitureCategory) + 1);
                }
            }
        }
    }
}

