/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureCatalogTree
extends JTree
implements View {
    private final UserPreferences preferences;
    private TreeSelectionListener treeSelectionListener;

    public FurnitureCatalogTree(FurnitureCatalog furnitureCatalog) {
        this(furnitureCatalog, null);
    }

    public FurnitureCatalogTree(FurnitureCatalog furnitureCatalog, FurnitureCatalogController furnitureCatalogController) {
        this(furnitureCatalog, null, furnitureCatalogController);
    }

    public FurnitureCatalogTree(FurnitureCatalog furnitureCatalog, UserPreferences userPreferences, FurnitureCatalogController furnitureCatalogController) {
        this.preferences = userPreferences;
        this.setModel(new CatalogTreeModel(furnitureCatalog));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new CatalogCellRenderer());
        this.addDragListener();
        if (furnitureCatalogController != null) {
            this.updateTreeSelectedFurniture(furnitureCatalog, furnitureCatalogController);
            this.addSelectionListeners(furnitureCatalog, furnitureCatalogController);
            this.addMouseListener(furnitureCatalogController);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.getActionMap().getParent().remove("selectAll");
    }

    private void addDragListener() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                TreePath treePath;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (treePath = FurnitureCatalogTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getLastPathComponent() instanceof CatalogPieceOfFurniture && FurnitureCatalogTree.this.getTransferHandler() != null) {
                    FurnitureCatalogTree.this.getTransferHandler().exportAsDrag(FurnitureCatalogTree.this, mouseEvent, 1);
                }
            }
        });
    }

    private void addSelectionListeners(final FurnitureCatalog furnitureCatalog, final FurnitureCatalogController furnitureCatalogController) {
        final SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureCatalogTree.this.updateTreeSelectedFurniture(furnitureCatalog, furnitureCatalogController);
            }
        };
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                furnitureCatalogController.removeSelectionListener(selectionListener);
                furnitureCatalogController.setSelectedFurniture(FurnitureCatalogTree.this.getSelectedFurniture());
                furnitureCatalogController.addSelectionListener(selectionListener);
            }
        };
        furnitureCatalogController.addSelectionListener(selectionListener);
        this.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
    }

    private void updateTreeSelectedFurniture(FurnitureCatalog furnitureCatalog, FurnitureCatalogController furnitureCatalogController) {
        if (this.treeSelectionListener != null) {
            this.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.clearSelection();
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCatalogController.getSelectedFurniture()) {
            TreePath treePath = new TreePath(new Object[]{furnitureCatalog, catalogPieceOfFurniture.getCategory(), catalogPieceOfFurniture});
            this.addSelectionPath(treePath);
            this.scrollRowToVisible(this.getRowForPath(treePath));
        }
        if (this.treeSelectionListener != null) {
            this.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    private List<CatalogPieceOfFurniture> getSelectedFurniture() {
        ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                if (treePath.getPathCount() != 3) continue;
                arrayList.add((CatalogPieceOfFurniture)treePath.getLastPathComponent());
            }
        }
        return arrayList;
    }

    private void addMouseListener(final FurnitureCatalogController furnitureCatalogController) {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                if (mouseEvent.getClickCount() == 2 && (treePath = FurnitureCatalogTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getLastPathComponent() instanceof CatalogPieceOfFurniture) {
                    furnitureCatalogController.modifySelectedFurniture();
                }
            }
        });
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this.preferences != null && treePath != null && treePath.getPathCount() == 3) {
            CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)treePath.getLastPathComponent();
            String string = "<html><table><tr><td align='center'><b>" + catalogPieceOfFurniture.getName() + "</b>";
            if (catalogPieceOfFurniture.getCreator() != null) {
                string = string + "<br>" + this.preferences.getLocalizedString(FurnitureCatalogTree.class, "tooltipCreator", catalogPieceOfFurniture.getCreator() + "</td></tr>");
            }
            if (catalogPieceOfFurniture.getIcon() instanceof URLContent) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(((URLContent)catalogPieceOfFurniture.getIcon()).getURL());
                    if (bufferedImage == null) {
                        return null;
                    }
                    int n = Math.round(128.0f * (float)Math.min(1, bufferedImage.getWidth() / bufferedImage.getHeight()));
                    int n2 = Math.round((float)n * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
                    string = string + "<tr><td width='128' height='128' align='center' valign='middle'><img width='" + n + "' height='" + n2 + "' src='" + ((URLContent)catalogPieceOfFurniture.getIcon()).getURL() + "'></td></tr>";
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return string + "</table>";
        }
        return null;
    }

    private static class CatalogTreeModel
    implements TreeModel {
        private FurnitureCatalog catalog;
        private List<TreeModelListener> listeners;

        public CatalogTreeModel(FurnitureCatalog furnitureCatalog) {
            this.catalog = furnitureCatalog;
            this.listeners = new ArrayList<TreeModelListener>(2);
            furnitureCatalog.addFurnitureListener(new CatalogFurnitureListener(this));
        }

        public Object getRoot() {
            return this.catalog;
        }

        public Object getChild(Object object, int n) {
            if (object instanceof FurnitureCatalog) {
                return ((FurnitureCatalog)object).getCategory(n);
            }
            return ((FurnitureCategory)object).getPieceOfFurniture(n);
        }

        public int getChildCount(Object object) {
            if (object instanceof FurnitureCatalog) {
                return ((FurnitureCatalog)object).getCategoriesCount();
            }
            return ((FurnitureCategory)object).getFurnitureCount();
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof FurnitureCatalog) {
                return Collections.binarySearch(((FurnitureCatalog)object).getCategories(), (FurnitureCategory)object2);
            }
            return Collections.binarySearch(((FurnitureCategory)object).getFurniture(), (CatalogPieceOfFurniture)object2);
        }

        public boolean isLeaf(Object object) {
            return object instanceof CatalogPieceOfFurniture;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.add(treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.remove(treeModelListener);
        }

        private void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeModelListener[] treeModelListenerArray;
            for (TreeModelListener treeModelListener : treeModelListenerArray = this.listeners.toArray(new TreeModelListener[this.listeners.size()])) {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        private void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModelListener[] treeModelListenerArray;
            for (TreeModelListener treeModelListener : treeModelListenerArray = this.listeners.toArray(new TreeModelListener[this.listeners.size()])) {
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CatalogFurnitureListener
        implements CollectionListener<CatalogPieceOfFurniture> {
            private WeakReference<CatalogTreeModel> catalogTreeModel;

            public CatalogFurnitureListener(CatalogTreeModel catalogTreeModel) {
                this.catalogTreeModel = new WeakReference<CatalogTreeModel>(catalogTreeModel);
            }

            @Override
            public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                CatalogTreeModel catalogTreeModel = (CatalogTreeModel)this.catalogTreeModel.get();
                FurnitureCatalog furnitureCatalog = (FurnitureCatalog)collectionEvent.getSource();
                if (catalogTreeModel == null) {
                    furnitureCatalog.removeFurnitureListener(this);
                } else {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = collectionEvent.getItem();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            if (catalogPieceOfFurniture.getCategory().getFurnitureCount() == 1) {
                                catalogTreeModel.fireTreeNodesInserted(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog}, new int[]{Collections.binarySearch(furnitureCatalog.getCategories(), catalogPieceOfFurniture.getCategory())}, new Object[]{catalogPieceOfFurniture.getCategory()}));
                                break;
                            }
                            catalogTreeModel.fireTreeNodesInserted(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog, catalogPieceOfFurniture.getCategory()}, new int[]{collectionEvent.getIndex()}, new Object[]{catalogPieceOfFurniture}));
                            break;
                        }
                        case DELETE: {
                            if (catalogPieceOfFurniture.getCategory().getFurnitureCount() == 0) {
                                catalogTreeModel.fireTreeNodesRemoved(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog}, new int[]{-(Collections.binarySearch(furnitureCatalog.getCategories(), catalogPieceOfFurniture.getCategory()) + 1)}, new Object[]{catalogPieceOfFurniture.getCategory()}));
                                break;
                            }
                            catalogTreeModel.fireTreeNodesRemoved(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog, catalogPieceOfFurniture.getCategory()}, new int[]{collectionEvent.getIndex()}, new Object[]{catalogPieceOfFurniture}));
                        }
                    }
                }
            }
        }
    }

    private static class CatalogCellRenderer
    extends DefaultTreeCellRenderer {
        private static final int DEFAULT_ICON_HEIGHT = 32;
        private Font defaultFont;
        private Font modifiablePieceFont;

        private CatalogCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (this.defaultFont == null) {
                this.defaultFont = jLabel.getFont();
                this.modifiablePieceFont = new Font(this.defaultFont.getFontName(), 2, this.defaultFont.getSize());
            }
            if (object instanceof FurnitureCategory) {
                jLabel.setText(((FurnitureCategory)object).getName());
                jLabel.setFont(this.defaultFont);
            } else if (object instanceof CatalogPieceOfFurniture) {
                CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                jLabel.setText(catalogPieceOfFurniture.getName());
                jLabel.setIcon(this.getLabelIcon(jTree, catalogPieceOfFurniture.getIcon()));
                jLabel.setFont(catalogPieceOfFurniture.isModifiable() ? this.modifiablePieceFont : this.defaultFont);
            }
            return jLabel;
        }

        private Icon getLabelIcon(JTree jTree, Content content) {
            int n = jTree.isFixedRowHeight() ? jTree.getRowHeight() : 32;
            return IconManager.getInstance().getIcon(content, n, jTree);
        }

        protected void paintComponent(Graphics graphics) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(graphics);
        }
    }
}

