/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FurnitureTable;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureTable
extends JTable
implements View,
Printable {
    private ListSelectionListener tableSelectionListener;
    private boolean selectionByUser;

    public FurnitureTable(Home home, UserPreferences userPreferences) {
        this(home, userPreferences, null);
    }

    public FurnitureTable(Home home, UserPreferences userPreferences, FurnitureController furnitureController) {
        this.setModel(new FurnitureTableModel(home));
        this.setColumnModel(new FurnitureTableColumnModel(home, userPreferences));
        this.updateTableColumnsWidth();
        this.updateTableSelectedFurniture(home.getSelectedItems());
        if (furnitureController != null) {
            this.addSelectionListeners(home, furnitureController);
            this.addTableHeaderListener(furnitureController);
            this.addTableColumnModelListener(furnitureController);
            this.addMouseListener(furnitureController);
        }
        this.addHomeListener(home);
        this.addUserPreferencesListener(userPreferences);
    }

    private void addSelectionListeners(final Home home, final FurnitureController furnitureController) {
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureTable.this.updateTableSelectedFurniture(home.getSelectedItems());
            }
        };
        this.tableSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FurnitureTable.this.selectionByUser = true;
                int[] nArray = FurnitureTable.this.getSelectedRows();
                ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(nArray.length);
                TableModel tableModel = FurnitureTable.this.getModel();
                for (int n : nArray) {
                    arrayList.add((HomePieceOfFurniture)tableModel.getValueAt(n, 0));
                }
                furnitureController.setSelectedFurniture(arrayList);
                FurnitureTable.this.selectionByUser = false;
            }
        };
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        home.addSelectionListener(selectionListener);
    }

    private void updateTableSelectedFurniture(List<Selectable> list) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.tableSelectionListener);
        FurnitureTableModel furnitureTableModel = (FurnitureTableModel)this.getModel();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        Object object = new int[list.size()];
        int n3 = 0;
        for (Selectable selectable : list) {
            int n4;
            if (!(selectable instanceof HomePieceOfFurniture) || (n4 = furnitureTableModel.getPieceOfFurnitureIndex((HomePieceOfFurniture)selectable)) == -1) continue;
            object[n3++] = n4;
            n = Math.min(n, n4);
            n2 = Math.max(n2, n4);
        }
        if (n3 < ((int[])object).length) {
            Object object2 = new int[n3];
            System.arraycopy(object, 0, object2, 0, n3);
            object = object2;
        }
        Arrays.sort(object);
        if (this.getSelectedRowCount() != n3 || !Arrays.equals(this.getSelectedRows(), object)) {
            this.clearSelection();
            int n5 = 0;
            while (n5 < ((int[])object).length) {
                int n6 = n5;
                while (n6 + 1 < ((int[])object).length && object[n6] + 1 == object[n6 + 1]) {
                    ++n6;
                }
                this.addRowSelectionInterval(object[n5], object[n6]);
                n5 = n6 + 1;
            }
        }
        if (!this.selectionByUser && n != Integer.MIN_VALUE) {
            this.makeRowsVisible(n, n2);
        }
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    private void updateTableColumnsWidth() {
        int n = this.getIntercellSpacing().width;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableModel tableModel = this.getModel();
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = this.convertColumnIndexToModel(i);
            int n4 = tableColumn.getHeaderRenderer().getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width;
            int n5 = tableModel.getRowCount();
            if (n5 > 0) {
                for (int j = 0; j < n5; ++j) {
                    n4 = Math.max(n4, tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)this, (Object)tableModel.getValueAt((int)j, (int)n3), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width);
                }
            } else {
                n4 = Math.max(n4, tableColumn.getPreferredWidth());
            }
            tableColumn.setPreferredWidth(n4 + n);
            tableColumn.setWidth(n4 + n);
        }
    }

    private void addMouseListener(final FurnitureController furnitureController) {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    furnitureController.modifySelectedFurniture();
                }
            }
        });
    }

    private void addUserPreferencesListener(UserPreferences userPreferences) {
        userPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new UserPreferencesChangeListener(this));
    }

    private void addHomeListener(final Home home) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((FurnitureTableModel)FurnitureTable.this.getModel()).filterAndSortFurniture();
                FurnitureTable.this.updateTableSelectedFurniture(home.getSelectedItems());
                FurnitureTable.this.getTableHeader().repaint();
            }
        };
        home.addPropertyChangeListener(Home.Property.FURNITURE_SORTED_PROPERTY, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.FURNITURE_DESCENDING_SORTED, propertyChangeListener);
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((FurnitureTableModel)FurnitureTable.this.getModel()).filterAndSortFurniture();
                FurnitureTable.this.updateTableSelectedFurniture(home.getSelectedItems());
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener2);
        }
        home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                } else {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                }
            }
        });
    }

    private void makeRowsVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (n != n2) {
            rectangle = rectangle.union(this.getCellRect(n2, 0, true));
        }
        if (this.getAutoResizeMode() == 0) {
            int n3 = this.getColumnCount() - 1;
            rectangle = rectangle.union(this.getCellRect(n, n3, true));
            if (n != n2) {
                rectangle = rectangle.union(this.getCellRect(n2, n3, true));
            }
        }
        this.scrollRectToVisible(rectangle);
    }

    private void addTableHeaderListener(final FurnitureController furnitureController) {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = FurnitureTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                Object object = FurnitureTable.this.getColumnModel().getColumn(n).getIdentifier();
                if (object instanceof HomePieceOfFurniture.SortableProperty) {
                    furnitureController.sortFurniture((HomePieceOfFurniture.SortableProperty)((Object)object));
                }
            }
        });
    }

    private void addTableColumnModelListener(final FurnitureController furnitureController) {
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                FurnitureTable.this.getColumnModel().removeColumnModelListener(this);
                ArrayList<HomePieceOfFurniture.SortableProperty> arrayList = new ArrayList<HomePieceOfFurniture.SortableProperty>();
                Enumeration<TableColumn> enumeration = FurnitureTable.this.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement().getIdentifier();
                    if (!(object instanceof HomePieceOfFurniture.SortableProperty)) continue;
                    arrayList.add((HomePieceOfFurniture.SortableProperty)((Object)object));
                }
                furnitureController.setFurnitureVisibleProperties(arrayList);
                FurnitureTable.this.getColumnModel().addColumnModelListener(this);
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setIcon(null);
                jLabel.setBackground(Color.LIGHT_GRAY);
                jLabel.setForeground(Color.BLACK);
                jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), jLabel.getBorder()));
                return jLabel;
            }
        };
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            final TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableColumn tableColumn2 = new TableColumn();
            tableColumn2.setIdentifier(tableColumn.getIdentifier());
            tableColumn2.setHeaderValue(tableColumn.getHeaderValue());
            TableCellRenderer tableCellRenderer2 = new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof JCheckBox) {
                        component = defaultTableCellRenderer.getTableCellRendererComponent(jTable, ((JCheckBox)component).isSelected() ? "x" : "", false, false, n, n2);
                    }
                    component.setBackground(Color.WHITE);
                    component.setForeground(Color.BLACK);
                    return component;
                }
            };
            tableColumn2.setCellRenderer(tableCellRenderer2);
            tableColumn2.setHeaderRenderer(tableCellRenderer);
            defaultTableColumnModel.addColumn(tableColumn2);
        }
        return this.print(graphics, pageFormat, n, defaultTableColumnModel, Color.BLACK);
    }

    private int print(final Graphics graphics, final PageFormat pageFormat, final int n, final TableColumnModel tableColumnModel, final Color color) throws PrinterException {
        if (EventQueue.isDispatchThread()) {
            TableColumnModel tableColumnModel2 = this.getColumnModel();
            Color color2 = this.getGridColor();
            this.setColumnModel(tableColumnModel);
            this.updateTableColumnsWidth();
            this.setGridColor(color);
            Printable printable = this.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
            int n2 = printable.print(graphics, pageFormat, n);
            this.setColumnModel(tableColumnModel2);
            this.setGridColor(color2);
            return n2;
        }
        class RunnableContext {
            int pageExists;
            PrinterException exception;

            RunnableContext() {
            }
        }
        final RunnableContext runnableContext = new RunnableContext();
        try {
            EventQueue.invokeAndWait(new Runnable(){
                {
                }

                public void run() {
                    try {
                        runnableContext.pageExists = FurnitureTable.this.print(graphics, pageFormat, n, tableColumnModel, color);
                    }
                    catch (PrinterException printerException) {
                        runnableContext.exception = printerException;
                    }
                }
            });
            if (runnableContext.exception != null) {
                throw runnableContext.exception;
            }
            return runnableContext.pageExists;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedPrinterException("Print interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw (Error)invocationTargetException.getCause();
        }
    }

    public String getClipboardCSV() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        int n = this.columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(this.columnModel.getColumn(i).getHeaderValue());
        }
        stringBuilder.append(string);
        for (int n2 : this.getSelectedRows()) {
            TableModel tableModel = this.getModel();
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)tableModel.getValueAt(n2, 0);
            int n3 = this.columnModel.getColumnCount();
            for (int i = 0; i < n3; ++i) {
                Object object;
                TableColumn tableColumn;
                Object object2;
                if (i > 0) {
                    stringBuilder.append("\t");
                }
                if ((object2 = (tableColumn = this.columnModel.getColumn(i)).getIdentifier()) instanceof HomePieceOfFurniture.SortableProperty) {
                    switch ((HomePieceOfFurniture.SortableProperty)((Object)object2)) {
                        case CATALOG_ID: {
                            object = homePieceOfFurniture.getCatalogId();
                            stringBuilder.append((String)(object != null ? object : ""));
                            break;
                        }
                        case NAME: {
                            stringBuilder.append(homePieceOfFurniture.getName());
                            break;
                        }
                        case COLOR: {
                            if (homePieceOfFurniture.getColor() == null) break;
                            stringBuilder.append("#" + Integer.toHexString(homePieceOfFurniture.getColor()).substring(2));
                            break;
                        }
                        case TEXTURE: {
                            if (homePieceOfFurniture.getTexture() != null) {
                                stringBuilder.append(homePieceOfFurniture.getTexture().getName());
                            }
                        }
                        case WIDTH: 
                        case DEPTH: 
                        case HEIGHT: 
                        case X: 
                        case Y: 
                        case ELEVATION: 
                        case ANGLE: 
                        case PRICE: 
                        case VALUE_ADDED_TAX_PERCENTAGE: 
                        case VALUE_ADDED_TAX: 
                        case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                            stringBuilder.append(((JLabel)tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n2, i)).getText());
                            break;
                        }
                        case MOVABLE: {
                            stringBuilder.append(homePieceOfFurniture.isMovable());
                            break;
                        }
                        case DOOR_OR_WINDOW: {
                            stringBuilder.append(homePieceOfFurniture.isDoorOrWindow());
                            break;
                        }
                        case VISIBLE: {
                            stringBuilder.append(homePieceOfFurniture.isVisible());
                        }
                    }
                    continue;
                }
                object = tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n2, i);
                if (object instanceof JLabel) {
                    stringBuilder.append(((JLabel)object).getText());
                    continue;
                }
                stringBuilder.append(tableModel.getValueAt(n2, i));
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void setFurnitureFilter(FurnitureFilter furnitureFilter) {
        FurnitureTableModel furnitureTableModel = (FurnitureTableModel)this.getModel();
        furnitureTableModel.setFurnitureFilter(furnitureFilter);
    }

    public static interface FurnitureFilter {
        public boolean include(Home var1, HomePieceOfFurniture var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureTableModel
    extends AbstractTableModel {
        private Home home;
        private List<HomePieceOfFurniture> filteredAndSortedFurniture;
        private FurnitureFilter furnitureFilter;

        public FurnitureTableModel(Home home) {
            this.home = home;
            this.addHomeListener(home);
            this.filterAndSortFurniture();
        }

        private void addHomeListener(final Home home) {
            home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

                @Override
                public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                    HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                    int n = collectionEvent.getIndex();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            int n2 = this.getPieceOfFurnitureInsertionIndex(homePieceOfFurniture, home, n);
                            if (n2 == -1) break;
                            FurnitureTableModel.this.filteredAndSortedFurniture.add(n2, homePieceOfFurniture);
                            FurnitureTableModel.this.fireTableRowsInserted(n2, n2);
                            break;
                        }
                        case DELETE: {
                            int n3 = this.getPieceOfFurnitureDeletionIndex(homePieceOfFurniture, home, n);
                            if (n3 == -1) break;
                            FurnitureTableModel.this.filteredAndSortedFurniture.remove(n3);
                            FurnitureTableModel.this.fireTableRowsDeleted(n3, n3);
                        }
                    }
                }

                private int getPieceOfFurnitureInsertionIndex(HomePieceOfFurniture homePieceOfFurniture, Home home2, int n) {
                    int n2;
                    if (FurnitureTableModel.this.furnitureFilter == null) {
                        if (home2.getFurnitureSortedProperty() == null) {
                            return n;
                        }
                    } else {
                        if (!FurnitureTableModel.this.furnitureFilter.include(home2, homePieceOfFurniture)) {
                            return -1;
                        }
                        if (home2.getFurnitureSortedProperty() == null) {
                            int n3;
                            List<HomePieceOfFurniture> list = home2.getFurniture();
                            for (n3 = n - 1; n3 > 0 && !FurnitureTableModel.this.furnitureFilter.include(home2, list.get(n3)); --n3) {
                            }
                            if (FurnitureTableModel.this.filteredAndSortedFurniture.size() == 0) {
                                return 0;
                            }
                            return FurnitureTableModel.this.getPieceOfFurnitureIndex(list.get(n3)) + 1;
                        }
                    }
                    if ((n2 = Collections.binarySearch(FurnitureTableModel.this.filteredAndSortedFurniture, homePieceOfFurniture, FurnitureTableModel.this.getFurnitureComparator(home2))) >= 0) {
                        return n2;
                    }
                    return -(n2 + 1);
                }

                private int getPieceOfFurnitureDeletionIndex(HomePieceOfFurniture homePieceOfFurniture, Home home2, int n) {
                    if (FurnitureTableModel.this.furnitureFilter == null && home2.getFurnitureSortedProperty() == null) {
                        return n;
                    }
                    return FurnitureTableModel.this.getPieceOfFurnitureIndex(homePieceOfFurniture);
                }
            });
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.filteredAndSortedFurniture.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.filteredAndSortedFurniture.get(n);
        }

        public int getPieceOfFurnitureIndex(HomePieceOfFurniture homePieceOfFurniture) {
            return this.filteredAndSortedFurniture.indexOf(homePieceOfFurniture);
        }

        public void filterAndSortFurniture() {
            int n = this.filteredAndSortedFurniture != null ? this.filteredAndSortedFurniture.size() : 0;
            List<HomePieceOfFurniture> list = this.home.getFurniture();
            if (this.furnitureFilter == null) {
                this.filteredAndSortedFurniture = new ArrayList<HomePieceOfFurniture>(list);
            } else {
                this.filteredAndSortedFurniture = new ArrayList<HomePieceOfFurniture>(list.size());
                for (HomePieceOfFurniture homePieceOfFurniture : list) {
                    if (!this.furnitureFilter.include(this.home, homePieceOfFurniture)) continue;
                    this.filteredAndSortedFurniture.add(homePieceOfFurniture);
                }
            }
            if (this.home.getFurnitureSortedProperty() != null) {
                Comparator<HomePieceOfFurniture> comparator = this.getFurnitureComparator(this.home);
                Collections.sort(this.filteredAndSortedFurniture, comparator);
            }
            if (n != this.filteredAndSortedFurniture.size()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }

        private Comparator<HomePieceOfFurniture> getFurnitureComparator(Home home) {
            Comparator<HomePieceOfFurniture> comparator = HomePieceOfFurniture.getFurnitureComparator(home.getFurnitureSortedProperty());
            if (home.isFurnitureDescendingSorted()) {
                comparator = Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        public void setFurnitureFilter(FurnitureFilter furnitureFilter) {
            this.furnitureFilter = furnitureFilter;
            this.filterAndSortFurniture();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureTableColumnModel
    extends DefaultTableColumnModel {
        private static final ResourceURLContent GROUP_ICON_CONTENT = new ResourceURLContent(FurnitureTable.class, "resources/groupIcon.png");
        private Map<HomePieceOfFurniture.SortableProperty, TableColumn> availableColumns;

        public FurnitureTableColumnModel(Home home, UserPreferences userPreferences) {
            this.createAvailableColumns(home, userPreferences);
            this.addHomeListener(home);
            this.addLanguageListener(userPreferences);
            this.updateModelColumns(home.getFurnitureVisibleProperties());
        }

        private void createAvailableColumns(Home home, UserPreferences userPreferences) {
            this.availableColumns = new HashMap<HomePieceOfFurniture.SortableProperty, TableColumn>();
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer(home);
            for (HomePieceOfFurniture.SortableProperty sortableProperty : HomePieceOfFurniture.SortableProperty.values()) {
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier((Object)sortableProperty);
                tableColumn.setHeaderValue(this.getColumnName(sortableProperty, userPreferences));
                tableColumn.setCellRenderer(this.getColumnRenderer(sortableProperty, userPreferences));
                tableColumn.setPreferredWidth(this.getColumnPreferredWidth(sortableProperty));
                tableColumn.setHeaderRenderer(tableCellRenderer);
                this.availableColumns.put(sortableProperty, tableColumn);
            }
        }

        private void addHomeListener(final Home home) {
            home.addPropertyChangeListener(Home.Property.FURNITURE_VISIBLE_PROPERTIES, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurnitureTableColumnModel.this.updateModelColumns(home.getFurnitureVisibleProperties());
                }
            });
        }

        private void addLanguageListener(UserPreferences userPreferences) {
            userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
        }

        private void updateModelColumns(List<HomePieceOfFurniture.SortableProperty> list) {
            Object object;
            for (int i = this.tableColumns.size() - 1; i >= 0; --i) {
                TableColumn object2 = (TableColumn)this.tableColumns.get(i);
                object = object2.getIdentifier();
                if (!(object instanceof HomePieceOfFurniture.SortableProperty) || list.contains(object)) continue;
                this.removeColumn(object2);
            }
            for (HomePieceOfFurniture.SortableProperty sortableProperty : list) {
                object = this.availableColumns.get((Object)sortableProperty);
                if (this.tableColumns.contains(object)) continue;
                this.addColumn((TableColumn)object);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                object = this.availableColumns.get((Object)list.get(i));
                int n2 = this.tableColumns.indexOf(object);
                if (n2 == i) continue;
                this.moveColumn(n2, i);
            }
        }

        private String getColumnName(HomePieceOfFurniture.SortableProperty sortableProperty, UserPreferences userPreferences) {
            switch (sortableProperty) {
                case CATALOG_ID: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "catalogIdColumn", new Object[0]);
                }
                case NAME: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "nameColumn", new Object[0]);
                }
                case WIDTH: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "widthColumn", new Object[0]);
                }
                case DEPTH: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "depthColumn", new Object[0]);
                }
                case HEIGHT: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "heightColumn", new Object[0]);
                }
                case X: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "xColumn", new Object[0]);
                }
                case Y: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "yColumn", new Object[0]);
                }
                case ELEVATION: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "elevationColumn", new Object[0]);
                }
                case ANGLE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "angleColumn", new Object[0]);
                }
                case COLOR: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "colorColumn", new Object[0]);
                }
                case TEXTURE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "textureColumn", new Object[0]);
                }
                case MOVABLE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "movableColumn", new Object[0]);
                }
                case DOOR_OR_WINDOW: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "doorOrWindowColumn", new Object[0]);
                }
                case VISIBLE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "visibleColumn", new Object[0]);
                }
                case PRICE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "priceColumn", new Object[0]);
                }
                case VALUE_ADDED_TAX_PERCENTAGE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "valueAddedTaxPercentageColumn", new Object[0]);
                }
                case VALUE_ADDED_TAX: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "valueAddedTaxColumn", new Object[0]);
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "priceValueAddedTaxIncludedColumn", new Object[0]);
                }
            }
            throw new IllegalArgumentException("Unknown column name " + (Object)((Object)sortableProperty));
        }

        private int getColumnPreferredWidth(HomePieceOfFurniture.SortableProperty sortableProperty) {
            switch (sortableProperty) {
                case CATALOG_ID: 
                case NAME: {
                    return 120;
                }
                case WIDTH: 
                case DEPTH: 
                case HEIGHT: 
                case X: 
                case Y: 
                case ELEVATION: {
                    return 50;
                }
                case ANGLE: {
                    return 35;
                }
                case COLOR: 
                case TEXTURE: {
                    return 30;
                }
                case MOVABLE: 
                case DOOR_OR_WINDOW: 
                case VISIBLE: {
                    return 20;
                }
                case PRICE: 
                case VALUE_ADDED_TAX_PERCENTAGE: 
                case VALUE_ADDED_TAX: 
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return 70;
                }
            }
            throw new IllegalArgumentException("Unknown column name " + (Object)((Object)sortableProperty));
        }

        private TableCellRenderer getColumnRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, UserPreferences userPreferences) {
            switch (sortableProperty) {
                case CATALOG_ID: {
                    return this.getCatalogIdRenderer();
                }
                case NAME: {
                    return this.getNameWithIconRenderer();
                }
                case WIDTH: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.WIDTH, userPreferences);
                }
                case DEPTH: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.DEPTH, userPreferences);
                }
                case HEIGHT: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.HEIGHT, userPreferences);
                }
                case X: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.X, userPreferences);
                }
                case Y: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.Y, userPreferences);
                }
                case ELEVATION: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.ELEVATION, userPreferences);
                }
                case ANGLE: {
                    return this.getAngleRenderer();
                }
                case COLOR: {
                    return this.getColorRenderer();
                }
                case TEXTURE: {
                    return this.getTextureRenderer();
                }
                case MOVABLE: {
                    return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.MOVABLE);
                }
                case DOOR_OR_WINDOW: {
                    return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW);
                }
                case VISIBLE: {
                    return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.VISIBLE);
                }
                case PRICE: {
                    return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.PRICE, userPreferences);
                }
                case VALUE_ADDED_TAX_PERCENTAGE: {
                    return this.getValueAddedTaxPercentageRenderer();
                }
                case VALUE_ADDED_TAX: {
                    return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, userPreferences);
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences);
                }
            }
            throw new IllegalArgumentException("Unknown column name " + (Object)((Object)sortableProperty));
        }

        private TableCellRenderer getCatalogIdRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    return super.getTableCellRendererComponent(jTable, homePieceOfFurniture.getCatalogId(), bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getNameWithIconRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, homePieceOfFurniture.getName(), bl, bl2, n, n2);
                    Content content = homePieceOfFurniture instanceof HomeFurnitureGroup ? GROUP_ICON_CONTENT : homePieceOfFurniture.getIcon();
                    jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight(), jTable));
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getSizeRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, final UserPreferences userPreferences) {
            switch (sortableProperty) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class SizeRenderer
                extends DefaultTableCellRenderer {
                    final /* synthetic */ UserPreferences val$preferences;
                    final /* synthetic */ FurnitureTableColumnModel this$0;

                    SizeRenderer() {
                        this.this$0 = furnitureTableColumnModel;
                        this.val$preferences = userPreferences;
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        object = this.val$preferences.getLengthUnit().getFormat().format((Float)object);
                        this.setHorizontalAlignment(4);
                        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                }
                case WIDTH: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getWidth()), bl, bl2, n, n2);
                        }
                    };
                }
                case DEPTH: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getDepth()), bl, bl2, n, n2);
                        }
                    };
                }
                case HEIGHT: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getHeight()), bl, bl2, n, n2);
                        }
                    };
                }
                case X: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getX()), bl, bl2, n, n2);
                        }
                    };
                }
                case Y: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getY()), bl, bl2, n, n2);
                        }
                    };
                }
                case ELEVATION: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getElevation()), bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a size column");
        }

        private TableCellRenderer getPriceRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, final UserPreferences userPreferences) {
            switch (sortableProperty) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class PriceRenderer
                extends DefaultTableCellRenderer {
                    final /* synthetic */ UserPreferences val$preferences;
                    final /* synthetic */ FurnitureTableColumnModel this$0;

                    PriceRenderer() {
                        this.this$0 = furnitureTableColumnModel;
                        this.val$preferences = userPreferences;
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        String string = this.val$preferences.getCurrency();
                        if (object != null && string != null) {
                            NumberFormat numberFormat = DecimalFormat.getCurrencyInstance();
                            numberFormat.setCurrency(Currency.getInstance(string));
                            object = numberFormat.format((BigDecimal)object);
                        } else {
                            object = "";
                        }
                        this.setHorizontalAlignment(4);
                        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                }
                case PRICE: {
                    return new PriceRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).getPrice(), bl, bl2, n, n2);
                        }
                    };
                }
                case VALUE_ADDED_TAX: {
                    return new PriceRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).getValueAddedTax(), bl, bl2, n, n2);
                        }
                    };
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return new PriceRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).getPriceValueAddedTaxIncluded(), bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a price column");
        }

        private TableCellRenderer getAngleRenderer() {
            return new DefaultTableCellRenderer(){
                private TableCellRenderer integerRenderer;

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.integerRenderer == null) {
                        this.integerRenderer = jTable.getDefaultRenderer(Integer.class);
                    }
                    int n3 = (int)(Math.round(Math.toDegrees(((HomePieceOfFurniture)object).getAngle()) + 360.0) % 360L);
                    return this.integerRenderer.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getValueAddedTaxPercentageRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    BigDecimal bigDecimal = ((HomePieceOfFurniture)object).getValueAddedTaxPercentage();
                    if (bigDecimal != null) {
                        NumberFormat numberFormat = DecimalFormat.getPercentInstance();
                        numberFormat.setMinimumFractionDigits(bigDecimal.scale() - 2);
                        object = numberFormat.format(bigDecimal);
                    } else {
                        object = "";
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getColorRenderer() {
            return new DefaultTableCellRenderer(){
                private Icon squareIcon = new Icon(){

                    public int getIconHeight() {
                        return this.getFont().getSize();
                    }

                    public int getIconWidth() {
                        return this.getIconHeight();
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        int n3 = this.getIconHeight();
                        graphics.setColor(component.getForeground());
                        graphics.fillRect(n + 2, n2 + 2, n3 - 3, n3 - 3);
                        graphics.setColor(component.getParent().getParent().getForeground());
                        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n3 - 2);
                    }
                };

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Integer n3 = ((HomePieceOfFurniture)object).getColor();
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                    if (n3 != null) {
                        jLabel.setText(null);
                        jLabel.setIcon(this.squareIcon);
                        jLabel.setForeground(new Color(n3));
                    } else {
                        jLabel.setText("-");
                        jLabel.setIcon(null);
                        jLabel.setForeground(jTable.getForeground());
                    }
                    jLabel.setHorizontalAlignment(0);
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getTextureRenderer() {
            return new DefaultTableCellRenderer(){
                {
                    this.setHorizontalAlignment(0);
                }

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
                    HomeTexture homeTexture = homePieceOfFurniture.getTexture();
                    if (homeTexture != null) {
                        Content content = homeTexture.getImage();
                        jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - 2, jTable));
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getBooleanRenderer(HomePieceOfFurniture.SortableProperty sortableProperty) {
            switch (sortableProperty) {
                class BooleanRenderer
                implements TableCellRenderer {
                    private TableCellRenderer booleanRenderer;
                    final /* synthetic */ FurnitureTableColumnModel this$0;

                    BooleanRenderer(FurnitureTableColumnModel furnitureTableColumnModel) {
                        this.this$0 = furnitureTableColumnModel;
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        if (this.booleanRenderer == null) {
                            this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                        }
                        return this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                }
                case MOVABLE: {
                    return new BooleanRenderer(){
                        {
                            super(FurnitureTableColumnModel.this);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).isMovable(), bl, bl2, n, n2);
                        }
                    };
                }
                case DOOR_OR_WINDOW: {
                    return new BooleanRenderer(){
                        {
                            super(FurnitureTableColumnModel.this);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).isDoorOrWindow(), bl, bl2, n, n2);
                        }
                    };
                }
                case VISIBLE: {
                    return new BooleanRenderer(){
                        {
                            super(FurnitureTableColumnModel.this);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).isVisible(), bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a boolean column");
        }

        private TableCellRenderer getHeaderRenderer(final Home home) {
            return new TableCellRenderer(){
                private TableCellRenderer headerRenderer;
                private ImageIcon ascendingSortIcon = new ImageIcon(this.getClass().getResource("resources/ascending.png"));
                private ImageIcon descendingSortIcon = new ImageIcon(this.getClass().getResource("resources/descending.png"));

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.headerRenderer == null) {
                        this.headerRenderer = jTable.getTableHeader().getDefaultRenderer();
                    }
                    JLabel jLabel = (JLabel)this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (FurnitureTableColumnModel.this.getColumn(n2).getIdentifier().equals((Object)home.getFurnitureSortedProperty())) {
                        jLabel.setHorizontalTextPosition(10);
                        if (home.isFurnitureDescendingSorted()) {
                            jLabel.setIcon(this.descendingSortIcon);
                        } else {
                            jLabel.setIcon(this.ascendingSortIcon);
                        }
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private static class LanguageChangeListener
        implements PropertyChangeListener {
            private WeakReference<FurnitureTableColumnModel> furnitureTableColumnModel;

            public LanguageChangeListener(FurnitureTableColumnModel furnitureTableColumnModel) {
                this.furnitureTableColumnModel = new WeakReference<FurnitureTableColumnModel>(furnitureTableColumnModel);
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureTableColumnModel furnitureTableColumnModel = (FurnitureTableColumnModel)this.furnitureTableColumnModel.get();
                UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
                if (furnitureTableColumnModel == null) {
                    userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
                } else {
                    for (TableColumn tableColumn : furnitureTableColumnModel.availableColumns.values()) {
                        HomePieceOfFurniture.SortableProperty sortableProperty = (HomePieceOfFurniture.SortableProperty)((Object)tableColumn.getIdentifier());
                        tableColumn.setHeaderValue(furnitureTableColumnModel.getColumnName(sortableProperty, userPreferences));
                        tableColumn.setCellRenderer(furnitureTableColumnModel.getColumnRenderer(sortableProperty, userPreferences));
                    }
                }
            }
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureTable> furnitureTable;

        public UserPreferencesChangeListener(FurnitureTable furnitureTable) {
            this.furnitureTable = new WeakReference<FurnitureTable>(furnitureTable);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureTable furnitureTable = (FurnitureTable)this.furnitureTable.get();
            if (furnitureTable == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                furnitureTable.repaint();
                furnitureTable.getTableHeader().repaint();
            }
        }
    }
}

