/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.Home3DAttributesController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Home3DAttributesPanel
extends JPanel
implements DialogView {
    private final Home3DAttributesController controller;
    private JLabel observerFieldOfViewLabel;
    private JSpinner observerFieldOfViewSpinner;
    private JLabel observerHeightLabel;
    private JSpinner observerHeightSpinner;
    private JRadioButton groundColorRadioButton;
    private ColorButton groundColorButton;
    private JRadioButton groundTextureRadioButton;
    private JComponent groundTextureComponent;
    private JRadioButton skyColorRadioButton;
    private ColorButton skyColorButton;
    private JRadioButton skyTextureRadioButton;
    private JComponent skyTextureComponent;
    private JLabel brightnessLabel;
    private JSlider brightnessSlider;
    private JLabel wallsTransparencyLabel;
    private JSlider wallsTransparencySlider;
    private String dialogTitle;

    public Home3DAttributesPanel(UserPreferences userPreferences, Home3DAttributesController home3DAttributesController) {
        super(new GridBagLayout());
        this.controller = home3DAttributesController;
        this.createComponents(userPreferences, home3DAttributesController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(UserPreferences userPreferences, final Home3DAttributesController home3DAttributesController) {
        String string = userPreferences.getLengthUnit().getName();
        this.observerFieldOfViewLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "observerFieldOfViewLabel.text", new Object[0]));
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 10, 120, 1);
        this.observerFieldOfViewSpinner = new AutoCommitSpinner(spinnerNumberModel);
        spinnerNumberModel.setValue(home3DAttributesController.getObserverFieldOfViewInDegrees());
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                home3DAttributesController.setObserverFieldOfViewInDegrees(((Number)spinnerNumberModel.getValue()).intValue());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.OBSERVER_FIELD_OF_VIEW_IN_DEGREES, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel.setValue(home3DAttributesController.getObserverFieldOfViewInDegrees());
            }
        });
        this.observerHeightLabel = new JLabel(String.format(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "observerHeightLabel.text", new Object[0]), string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 10.0f, 2678.5715f);
        this.observerHeightSpinner = new AutoCommitSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setLength(Float.valueOf((float)Math.round(home3DAttributesController.getObserverHeight() * 100.0f) / 100.0f));
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                home3DAttributesController.setObserverHeight(nullableSpinnerLengthModel.getLength().floatValue());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.OBSERVER_HEIGHT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength(Float.valueOf((float)Math.round(home3DAttributesController.getObserverHeight() * 100.0f) / 100.0f));
            }
        });
        this.groundColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "groundColorRadioButton.text", new Object[0]));
        this.groundColorRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.groundColorRadioButton.isSelected()) {
                    home3DAttributesController.setGroundPaint(Home3DAttributesController.EnvironmentPaint.COLORED);
                }
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.GROUND_PAINT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.updateGroundRadioButtons(home3DAttributesController);
            }
        });
        this.groundColorButton = new ColorButton();
        this.groundColorButton.setColorDialogTitle(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundColorDialog.title", new Object[0]));
        this.groundColorButton.setColor(home3DAttributesController.getGroundColor());
        this.groundColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                home3DAttributesController.setGroundColor(Home3DAttributesPanel.this.groundColorButton.getColor());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.GROUND_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.groundColorButton.setColor(home3DAttributesController.getGroundColor());
            }
        });
        this.groundTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "groundTextureRadioButton.text", new Object[0]));
        this.groundTextureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.groundTextureRadioButton.isSelected()) {
                    home3DAttributesController.setGroundPaint(Home3DAttributesController.EnvironmentPaint.TEXTURED);
                }
            }
        });
        this.groundTextureComponent = (JComponent)((Object)home3DAttributesController.getGroundTextureController().getView());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.groundColorRadioButton);
        buttonGroup.add(this.groundTextureRadioButton);
        this.updateGroundRadioButtons(home3DAttributesController);
        this.skyColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "skyColorRadioButton.text", new Object[0]));
        this.skyColorRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.skyColorRadioButton.isSelected()) {
                    home3DAttributesController.setSkyPaint(Home3DAttributesController.EnvironmentPaint.COLORED);
                }
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.SKY_PAINT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.updateSkyRadioButtons(home3DAttributesController);
            }
        });
        this.skyColorButton = new ColorButton();
        this.skyColorButton.setColorDialogTitle(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyColorDialog.title", new Object[0]));
        this.skyColorButton.setColor(home3DAttributesController.getSkyColor());
        this.skyColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                home3DAttributesController.setSkyColor(Home3DAttributesPanel.this.skyColorButton.getColor());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.SKY_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.skyColorButton.setColor(home3DAttributesController.getSkyColor());
            }
        });
        this.skyTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "skyTextureRadioButton.text", new Object[0]));
        this.skyTextureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.skyTextureRadioButton.isSelected()) {
                    home3DAttributesController.setSkyPaint(Home3DAttributesController.EnvironmentPaint.TEXTURED);
                }
            }
        });
        this.skyTextureComponent = (JComponent)((Object)home3DAttributesController.getSkyTextureController().getView());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.skyColorRadioButton);
        buttonGroup2.add(this.skyTextureRadioButton);
        this.updateSkyRadioButtons(home3DAttributesController);
        this.brightnessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "brightnessLabel.text", new Object[0]));
        this.brightnessSlider = new JSlider(0, 255);
        JLabel jLabel = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "darkLabel.text", new Object[0]));
        JLabel jLabel2 = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "brightLabel.text", new Object[0]));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, jLabel);
        ((Dictionary)hashtable).put(255, jLabel2);
        this.brightnessSlider.setLabelTable(hashtable);
        this.brightnessSlider.setPaintLabels(true);
        this.brightnessSlider.setPaintTicks(true);
        this.brightnessSlider.setMajorTickSpacing(16);
        this.brightnessSlider.setValue(home3DAttributesController.getLightColor() & 0xFF);
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = Home3DAttributesPanel.this.brightnessSlider.getValue();
                home3DAttributesController.setLightColor((n << 16) + (n << 8) + n);
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.LIGHT_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.brightnessSlider.setValue(home3DAttributesController.getLightColor() & 0xFF);
            }
        });
        this.wallsTransparencyLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "wallsTransparencyLabel.text", new Object[0]));
        this.wallsTransparencySlider = new JSlider(0, 255);
        JLabel jLabel3 = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "opaqueLabel.text", new Object[0]));
        JLabel jLabel4 = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "invisibleLabel.text", new Object[0]));
        Hashtable<Integer, JLabel> hashtable2 = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable2).put(0, jLabel3);
        ((Dictionary)hashtable2).put(255, jLabel4);
        this.wallsTransparencySlider.setLabelTable(hashtable2);
        this.wallsTransparencySlider.setPaintLabels(true);
        this.wallsTransparencySlider.setPaintTicks(true);
        this.wallsTransparencySlider.setMajorTickSpacing(16);
        this.wallsTransparencySlider.setValue((int)(home3DAttributesController.getWallsAlpha() * 255.0f));
        this.wallsTransparencySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                home3DAttributesController.setWallsAlpha((float)Home3DAttributesPanel.this.wallsTransparencySlider.getValue() / 255.0f);
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.WALLS_ALPHA, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.wallsTransparencySlider.setValue((int)(home3DAttributesController.getWallsAlpha() * 255.0f));
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(Home3DAttributesPanel.class, "home3DAttributes.title", new Object[0]);
    }

    private void updateGroundRadioButtons(Home3DAttributesController home3DAttributesController) {
        if (home3DAttributesController.getGroundPaint() == Home3DAttributesController.EnvironmentPaint.COLORED) {
            this.groundColorRadioButton.setSelected(true);
        } else {
            this.groundTextureRadioButton.setSelected(true);
        }
    }

    private void updateSkyRadioButtons(Home3DAttributesController home3DAttributesController) {
        if (home3DAttributesController.getSkyPaint() == Home3DAttributesController.EnvironmentPaint.COLORED) {
            this.skyColorRadioButton.setSelected(true);
        } else {
            this.skyTextureRadioButton.setSelected(true);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.observerFieldOfViewLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "observerFieldOfViewLabel.mnemonic", new Object[0])).getKeyCode());
            this.observerFieldOfViewLabel.setLabelFor(this.observerFieldOfViewLabel);
            this.observerHeightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "observerHeightLabel.mnemonic", new Object[0])).getKeyCode());
            this.observerHeightLabel.setLabelFor(this.observerHeightSpinner);
            this.groundColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.groundTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.skyColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.skyTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.brightnessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "brightnessLabel.mnemonic", new Object[0])).getKeyCode());
            this.brightnessLabel.setLabelFor(this.brightnessSlider);
            this.wallsTransparencyLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "wallsTransparencyLabel.mnemonic", new Object[0])).getKeyCode());
            this.wallsTransparencyLabel.setLabelFor(this.wallsTransparencySlider);
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        Insets insets = new Insets(0, 0, 10, 5);
        this.add((Component)this.observerFieldOfViewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        Insets insets2 = new Insets(0, 0, 10, 15);
        this.add((Component)this.observerFieldOfViewSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, 20, 0));
        this.add((Component)this.observerHeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        Insets insets3 = new Insets(0, 0, 10, 0);
        this.add((Component)this.observerHeightSpinner, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 2, insets3, -25, 0));
        Insets insets4 = new Insets(0, 0, 2, 5);
        this.add((Component)this.groundColorRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets4, 0, 0));
        this.add((Component)this.groundColorButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 2, 15), 0, 0));
        this.add((Component)this.skyColorRadioButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, n, 0, insets4, 0, 0));
        this.add((Component)this.skyColorButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.groundTextureRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.groundTextureComponent, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.skyTextureRadioButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.skyTextureComponent, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        this.add((Component)this.brightnessLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.brightnessSlider, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.wallsTransparencyLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.wallsTransparencySlider, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void displayView(View view) {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.observerFieldOfViewSpinner.getEditor()).getTextField();
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, jFormattedTextField) == 0 && this.controller != null) {
            this.controller.modify3DAttributes();
        }
    }
}

