/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.ImportedFurnitureWizardStepsPanel;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HomeFurniturePanel
extends JPanel
implements DialogView {
    private final HomeFurnitureController controller;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private NullableCheckBox nameVisibleCheckBox;
    private JLabel xLabel;
    private JSpinner xSpinner;
    private JLabel yLabel;
    private JSpinner ySpinner;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private JLabel angleLabel;
    private JSpinner angleSpinner;
    private NullableCheckBox basePlanItemCheckBox;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel depthLabel;
    private JSpinner depthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox keepProportionsCheckBox;
    private NullableCheckBox mirroredModelCheckBox;
    private JRadioButton defaultColorAndTextureRadioButton;
    private JRadioButton colorRadioButton;
    private ColorButton colorButton;
    private JRadioButton textureRadioButton;
    private JComponent textureComponent;
    private JRadioButton defaultShininessRadioButton;
    private JRadioButton mattRadioButton;
    private JRadioButton shinyRadioButton;
    private NullableCheckBox visibleCheckBox;
    private JLabel lightPowerLabel;
    private JSpinner lightPowerSpinner;
    private String dialogTitle;

    public HomeFurniturePanel(UserPreferences userPreferences, HomeFurnitureController homeFurnitureController) {
        super(new GridBagLayout());
        this.controller = homeFurnitureController;
        this.createComponents(userPreferences, homeFurnitureController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, homeFurnitureController);
    }

    private void createComponents(UserPreferences userPreferences, final HomeFurnitureController homeFurnitureController) {
        Object object;
        String string = userPreferences.getLengthUnit().getName();
        this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "nameLabel.text", new Object[0]));
        this.nameTextField = new JTextField(homeFurnitureController.getName(), 15);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.nameTextField.setText(homeFurnitureController.getName());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME, propertyChangeListener);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.NAME, propertyChangeListener);
                String string = HomeFurniturePanel.this.nameTextField.getText();
                if (string == null || string.trim().length() == 0) {
                    homeFurnitureController.setName(null);
                } else {
                    homeFurnitureController.setName(string);
                }
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME, propertyChangeListener);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.nameVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "nameVisibleCheckBox.text", new Object[0]));
        this.nameVisibleCheckBox.setNullable(homeFurnitureController.getNameVisible() == null);
        this.nameVisibleCheckBox.setValue(homeFurnitureController.getNameVisible());
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.nameVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                HomeFurniturePanel.this.nameVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, propertyChangeListener2);
        this.nameVisibleCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, propertyChangeListener2);
                homeFurnitureController.setNameVisible(HomeFurniturePanel.this.nameVisibleCheckBox.getValue());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, propertyChangeListener2);
            }
        });
        this.xLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "xLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -100000.0f, 100000.0f);
        this.xSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setNullable(homeFurnitureController.getX() == null);
        nullableSpinnerLengthModel.setLength(homeFurnitureController.getX());
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.X, propertyChangeListener3);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.X, propertyChangeListener3);
                homeFurnitureController.setX(nullableSpinnerLengthModel.getLength());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.X, propertyChangeListener3);
            }
        });
        this.yLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -100000.0f, 100000.0f);
        this.ySpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setNullable(homeFurnitureController.getY() == null);
        nullableSpinnerLengthModel2.setLength(homeFurnitureController.getY());
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.Y, propertyChangeListener4);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.Y, propertyChangeListener4);
                homeFurnitureController.setY(nullableSpinnerLengthModel2.getLength());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.Y, propertyChangeListener4);
            }
        });
        this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "elevationLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, 2500.0f);
        this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.setNullable(homeFurnitureController.getElevation() == null);
        nullableSpinnerLengthModel3.setLength(homeFurnitureController.getElevation());
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel3.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ELEVATION, propertyChangeListener5);
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ELEVATION, propertyChangeListener5);
                homeFurnitureController.setElevation(nullableSpinnerLengthModel3.getLength());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ELEVATION, propertyChangeListener5);
            }
        });
        this.angleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "angleLabel.text", new Object[0]));
        final NullableSpinner.NullableSpinnerNumberModel nullableSpinnerNumberModel = new NullableSpinner.NullableSpinnerNumberModel(0, 0, 360, 1);
        this.angleSpinner = new NullableSpinner(nullableSpinnerNumberModel);
        Integer n = homeFurnitureController.getAngleInDegrees();
        nullableSpinnerNumberModel.setNullable(n == null);
        nullableSpinnerNumberModel.setValue(n);
        final PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f = (Float)propertyChangeEvent.getNewValue();
                nullableSpinnerNumberModel.setNullable(f == null);
                nullableSpinnerNumberModel.setValue(f);
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ANGLE_IN_DEGREES, propertyChangeListener6);
        nullableSpinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ANGLE_IN_DEGREES, propertyChangeListener6);
                Number number = (Number)nullableSpinnerNumberModel.getValue();
                if (number == null) {
                    homeFurnitureController.setAngleInDegrees(null);
                } else {
                    homeFurnitureController.setAngleInDegrees(number.intValue());
                }
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ANGLE_IN_DEGREES, propertyChangeListener6);
            }
        });
        this.basePlanItemCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "basePlanItemCheckBox.text", new Object[0]));
        String string2 = userPreferences.getLocalizedString(HomeFurniturePanel.class, "basePlanItemCheckBox.tooltip", new Object[0]);
        if (string2.length() > 0) {
            this.basePlanItemCheckBox.setToolTipText(string2);
        }
        this.basePlanItemCheckBox.setNullable(homeFurnitureController.getBasePlanItem() == null);
        this.basePlanItemCheckBox.setValue(homeFurnitureController.getBasePlanItem());
        final PropertyChangeListener propertyChangeListener7 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.basePlanItemCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                HomeFurniturePanel.this.basePlanItemCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, propertyChangeListener7);
        this.basePlanItemCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, propertyChangeListener7);
                homeFurnitureController.setBasePlanItem(HomeFurniturePanel.this.basePlanItemCheckBox.getValue());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, propertyChangeListener7);
            }
        });
        this.basePlanItemCheckBox.setEnabled(homeFurnitureController.isBasePlanItemEditable());
        this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "widthLabel.text", string));
        final float f = userPreferences.getLengthUnit().getMinimumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, 100000.0f);
        this.widthSpinner = new NullableSpinner(nullableSpinnerLengthModel4);
        final PropertyChangeListener propertyChangeListener8 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f2 = homeFurnitureController.getWidth();
                nullableSpinnerLengthModel4.setNullable(f2 == null);
                nullableSpinnerLengthModel4.setLength(f2);
                if (f2 != null) {
                    nullableSpinnerLengthModel4.setMinimum(Float.valueOf(Math.min(f2.floatValue(), f)));
                }
            }
        };
        propertyChangeListener8.propertyChange(null);
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.WIDTH, propertyChangeListener8);
        nullableSpinnerLengthModel4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.WIDTH, propertyChangeListener8);
                homeFurnitureController.setWidth(nullableSpinnerLengthModel4.getLength());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.WIDTH, propertyChangeListener8);
            }
        });
        this.depthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "depthLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel5 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, 100000.0f);
        this.depthSpinner = new NullableSpinner(nullableSpinnerLengthModel5);
        final PropertyChangeListener propertyChangeListener9 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f2 = homeFurnitureController.getDepth();
                nullableSpinnerLengthModel5.setNullable(f2 == null);
                nullableSpinnerLengthModel5.setLength(f2);
                if (f2 != null) {
                    nullableSpinnerLengthModel5.setMinimum(Float.valueOf(Math.min(f2.floatValue(), f)));
                }
            }
        };
        propertyChangeListener9.propertyChange(null);
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEPTH, propertyChangeListener9);
        nullableSpinnerLengthModel5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.DEPTH, propertyChangeListener9);
                homeFurnitureController.setDepth(nullableSpinnerLengthModel5.getLength());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEPTH, propertyChangeListener9);
            }
        });
        this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "heightLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel6 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, 100000.0f);
        this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel6);
        final PropertyChangeListener propertyChangeListener10 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f2 = homeFurnitureController.getHeight();
                nullableSpinnerLengthModel6.setNullable(f2 == null);
                nullableSpinnerLengthModel6.setLength(f2);
                if (f2 != null) {
                    nullableSpinnerLengthModel6.setMinimum(Float.valueOf(Math.min(f2.floatValue(), f)));
                }
            }
        };
        propertyChangeListener10.propertyChange(null);
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HEIGHT, propertyChangeListener10);
        nullableSpinnerLengthModel6.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.HEIGHT, propertyChangeListener10);
                homeFurnitureController.setHeight(nullableSpinnerLengthModel6.getLength());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HEIGHT, propertyChangeListener10);
            }
        });
        this.keepProportionsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.text", new Object[0]));
        this.keepProportionsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                homeFurnitureController.setProportional(HomeFurniturePanel.this.keepProportionsCheckBox.isSelected());
            }
        });
        this.keepProportionsCheckBox.setSelected(homeFurnitureController.isProportional());
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PROPORTIONAL, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.keepProportionsCheckBox.setSelected(homeFurnitureController.isProportional());
            }
        });
        this.mirroredModelCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "mirroredModelCheckBox.text", new Object[0]));
        String string3 = userPreferences.getLocalizedString(HomeFurniturePanel.class, "mirroredModelCheckBox.tooltip", new Object[0]);
        if (string3.length() > 0) {
            this.mirroredModelCheckBox.setToolTipText(string3);
        }
        this.mirroredModelCheckBox.setNullable(homeFurnitureController.getModelMirrored() == null);
        this.mirroredModelCheckBox.setValue(homeFurnitureController.getModelMirrored());
        final PropertyChangeListener propertyChangeListener11 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.mirroredModelCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                HomeFurniturePanel.this.mirroredModelCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, propertyChangeListener11);
        this.mirroredModelCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, propertyChangeListener11);
                homeFurnitureController.setModelMirrored(HomeFurniturePanel.this.mirroredModelCheckBox.getValue());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, propertyChangeListener11);
            }
        });
        this.defaultColorAndTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "defaultColorAndTextureRadioButton.text", new Object[0]));
        this.defaultColorAndTextureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (HomeFurniturePanel.this.defaultColorAndTextureRadioButton.isSelected()) {
                    homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.DEFAULT);
                }
            }
        });
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PAINT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.updateColorAndTextureRadioButtons(homeFurnitureController);
            }
        });
        this.colorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "colorRadioButton.text", new Object[0]));
        this.colorRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (HomeFurniturePanel.this.colorRadioButton.isSelected()) {
                    homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
                }
            }
        });
        this.colorButton = new ColorButton();
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.setColor(homeFurnitureController.getColor());
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                homeFurnitureController.setColor(HomeFurniturePanel.this.colorButton.getColor());
                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
            }
        });
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.colorButton.setColor(homeFurnitureController.getColor());
            }
        });
        this.textureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "textureRadioButton.text", new Object[0]));
        this.textureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (HomeFurniturePanel.this.textureRadioButton.isSelected()) {
                    homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.TEXTURED);
                }
            }
        });
        TextureChoiceController textureChoiceController = homeFurnitureController.getTextureController();
        if (textureChoiceController != null) {
            this.textureComponent = (JComponent)((Object)textureChoiceController.getView());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultColorAndTextureRadioButton);
        buttonGroup.add(this.colorRadioButton);
        buttonGroup.add(this.textureRadioButton);
        this.updateColorAndTextureRadioButtons(homeFurnitureController);
        this.defaultShininessRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "defaultShininessRadioButton.text", new Object[0]));
        this.defaultShininessRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (HomeFurniturePanel.this.defaultShininessRadioButton.isSelected()) {
                    homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.DEFAULT);
                }
            }
        });
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.SHININESS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.updateShininessRadioButtons(homeFurnitureController);
            }
        });
        this.mattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "mattRadioButton.text", new Object[0]));
        this.mattRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (HomeFurniturePanel.this.mattRadioButton.isSelected()) {
                    homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.MATT);
                }
            }
        });
        this.shinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "shinyRadioButton.text", new Object[0]));
        this.shinyRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (HomeFurniturePanel.this.shinyRadioButton.isSelected()) {
                    homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.SHINY);
                }
            }
        });
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultShininessRadioButton);
        buttonGroup.add(this.mattRadioButton);
        buttonGroup.add(this.shinyRadioButton);
        this.updateShininessRadioButtons(homeFurnitureController);
        this.visibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "visibleCheckBox.text", new Object[0]));
        this.visibleCheckBox.setNullable(homeFurnitureController.getVisible() == null);
        this.visibleCheckBox.setValue(homeFurnitureController.getVisible());
        final PropertyChangeListener propertyChangeListener12 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.visibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                HomeFurniturePanel.this.visibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VISIBLE, propertyChangeListener12);
        this.visibleCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.VISIBLE, propertyChangeListener12);
                homeFurnitureController.setVisible(HomeFurniturePanel.this.visibleCheckBox.getValue());
                homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VISIBLE, propertyChangeListener12);
            }
        });
        if (homeFurnitureController.isLightPowerEditable()) {
            this.lightPowerLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "lightPowerLabel.text", string));
            object = new NullableSpinner.NullableSpinnerNumberModel(0, 0, 100, 5);
            this.lightPowerSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object);
            ((NullableSpinner.NullableSpinnerNumberModel)object).setNullable(homeFurnitureController.getLightPower() == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object).setValue(homeFurnitureController.getLightPower() != null ? Integer.valueOf(Math.round(homeFurnitureController.getLightPower().floatValue() * 100.0f)) : null);
            final PropertyChangeListener propertyChangeListener13 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$lightPowerSpinnerModel;
                {
                    this.val$lightPowerSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = (Float)propertyChangeEvent.getNewValue();
                    this.val$lightPowerSpinnerModel.setNullable(f == null);
                    this.val$lightPowerSpinnerModel.setValue(f != null ? Integer.valueOf(Math.round(((Float)propertyChangeEvent.getNewValue()).floatValue() * 100.0f)) : null);
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, propertyChangeListener13);
            ((AbstractSpinnerModel)object).addChangeListener(new ChangeListener((NullableSpinner.NullableSpinnerNumberModel)object){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$lightPowerSpinnerModel;
                {
                    this.val$lightPowerSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, propertyChangeListener13);
                    homeFurnitureController.setLightPower(Float.valueOf(((Number)this.val$lightPowerSpinnerModel.getValue()).floatValue() / 100.0f));
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, propertyChangeListener13);
                }
            });
        }
        this.updateSizeComponents(homeFurnitureController);
        object = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.updateSizeComponents(homeFurnitureController);
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.RESIZABLE, (PropertyChangeListener)object);
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEFORMABLE, (PropertyChangeListener)object);
        this.dialogTitle = userPreferences.getLocalizedString(HomeFurniturePanel.class, "homeFurniture.title", new Object[0]);
    }

    private void updateColorAndTextureRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.getPaint() == HomeFurnitureController.FurniturePaint.DEFAULT) {
            this.defaultColorAndTextureRadioButton.setSelected(true);
        } else if (homeFurnitureController.getPaint() == HomeFurnitureController.FurniturePaint.COLORED) {
            this.colorRadioButton.setSelected(true);
        } else if (homeFurnitureController.getPaint() == HomeFurnitureController.FurniturePaint.TEXTURED) {
            this.textureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.defaultColorAndTextureRadioButton, this.colorRadioButton, this.textureRadioButton);
        }
    }

    private void updateShininessRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.DEFAULT) {
            this.defaultShininessRadioButton.setSelected(true);
        } else if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.MATT) {
            this.mattRadioButton.setSelected(true);
        } else if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.SHINY) {
            this.shinyRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.defaultShininessRadioButton, this.mattRadioButton, this.shinyRadioButton);
        }
    }

    private void updateSizeComponents(HomeFurnitureController homeFurnitureController) {
        boolean bl = homeFurnitureController.isResizable();
        this.widthLabel.setEnabled(bl);
        this.widthSpinner.setEnabled(bl);
        this.depthLabel.setEnabled(bl);
        this.depthSpinner.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.heightSpinner.setEnabled(bl);
        this.keepProportionsCheckBox.setEnabled(bl && homeFurnitureController.isDeformable());
        this.mirroredModelCheckBox.setEnabled(bl);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setLabelFor(this.nameTextField);
            this.nameVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "nameVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.xLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xLabel.setLabelFor(this.xSpinner);
            this.yLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yLabel.setLabelFor(this.ySpinner);
            this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setLabelFor(this.elevationSpinner);
            this.angleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "angleLabel.mnemonic", new Object[0])).getKeyCode());
            this.angleLabel.setLabelFor(this.angleSpinner);
            this.keepProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "keepProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.depthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "depthLabel.mnemonic", new Object[0])).getKeyCode());
            this.depthLabel.setLabelFor(this.depthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
            this.basePlanItemCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "basePlanItemCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.mirroredModelCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "mirroredModelCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.defaultColorAndTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "defaultColorAndTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.colorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.textureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "textureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.defaultShininessRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "defaultShininessRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.mattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "mattRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.shinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "shinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.visibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "visibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            if (this.lightPowerLabel != null) {
                this.lightPowerLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "lightPowerLabel.mnemonic", new Object[0])).getKeyCode());
                this.lightPowerLabel.setLabelFor(this.lightPowerSpinner);
            }
        }
    }

    private void layoutComponents(UserPreferences userPreferences, final HomeFurnitureController homeFurnitureController) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "namePanel.title", new Object[0]));
        int n2 = OperatingSystem.isMacOSXLeopardOrSuperior() ? 0 : 5;
        jPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.nameVisibleCheckBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, n, 2, new Insets(0, 0, n2, 0), 0, 0));
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "locationPanel.title", new Object[0]));
        Insets insets = new Insets(0, 0, 5, 5);
        Insets insets2 = new Insets(0, 0, 5, 0);
        jPanel2.add((Component)this.xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.xSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        jPanel2.add((Component)this.yLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.ySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        jPanel2.add((Component)this.elevationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.elevationSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        jPanel2.add((Component)this.angleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.angleSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 21, 2, insets2, -15, 0));
        jPanel2.add((Component)this.basePlanItemCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, n, 1, new Insets(0, 0, n2, 0), 0, 0));
        JPanel jPanel3 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "sizePanel.title", new Object[0]));
        jPanel3.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel3.add((Component)this.widthSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        jPanel3.add((Component)this.depthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel3.add((Component)this.depthSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        jPanel3.add((Component)this.heightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel3.add((Component)this.heightSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 21, 0, insets2, -10, 0));
        jPanel3.add((Component)this.keepProportionsCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        jPanel3.add((Component)this.mirroredModelCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, n, 1, new Insets(0, 0, n2, 0), 0, 0));
        final JPanel jPanel4 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorAndTexturePanel.title", new Object[0]));
        jPanel4.add((Component)this.defaultColorAndTextureRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel4.add((Component)this.colorRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel4.add((Component)this.colorButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.textureComponent != null) {
            jPanel4.add((Component)this.textureRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 5), 0, 0));
            jPanel4.add((Component)this.textureComponent, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.textureComponent.setPreferredSize(this.colorButton.getPreferredSize());
        }
        this.add((Component)jPanel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 1, new Insets(0, 0, n2, 0), 0, 0));
        final JPanel jPanel5 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "shininessPanel.title", new Object[0]));
        jPanel5.add((Component)this.defaultShininessRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel5.add((Component)this.mattRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)this.shinyRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)jPanel5, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, n, 1, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)this.visibleCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        if (this.lightPowerLabel != null) {
            this.add((Component)this.lightPowerLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 10, 0, 5), 0, 0));
            this.add((Component)this.lightPowerSpinner, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.TEXTURABLE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jPanel4.setVisible(homeFurnitureController.isTexturable());
                jPanel5.setVisible(homeFurnitureController.isTexturable());
            }
        });
        jPanel4.setVisible(homeFurnitureController.isTexturable());
        jPanel5.setVisible(homeFurnitureController.isTexturable());
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.nameTextField) == 0) {
            this.controller.modifyFurniture();
        }
    }
}

