/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.RoomController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RoomPanel
extends JPanel
implements DialogView {
    private final RoomController controller;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private NullableCheckBox areaVisibleCheckBox;
    private NullableCheckBox floorVisibleCheckBox;
    private JRadioButton floorColorRadioButton;
    private ColorButton floorColorButton;
    private JRadioButton floorTextureRadioButton;
    private JComponent floorTextureComponent;
    private JRadioButton floorMattRadioButton;
    private JRadioButton floorShinyRadioButton;
    private NullableCheckBox ceilingVisibleCheckBox;
    private JRadioButton ceilingColorRadioButton;
    private ColorButton ceilingColorButton;
    private JRadioButton ceilingTextureRadioButton;
    private JComponent ceilingTextureComponent;
    private JRadioButton ceilingMattRadioButton;
    private JRadioButton ceilingShinyRadioButton;
    private String dialogTitle;

    public RoomPanel(UserPreferences userPreferences, RoomController roomController) {
        super(new GridBagLayout());
        this.controller = roomController;
        this.createComponents(userPreferences, roomController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, roomController);
    }

    private void createComponents(UserPreferences userPreferences, final RoomController roomController) {
        this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "nameLabel.text", new Object[0]));
        this.nameTextField = new JTextField(roomController.getName(), 10);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.nameTextField.setText(roomController.getName());
            }
        };
        roomController.addPropertyChangeListener(RoomController.Property.NAME, propertyChangeListener);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                roomController.removePropertyChangeListener(RoomController.Property.NAME, propertyChangeListener);
                String string = RoomPanel.this.nameTextField.getText();
                if (string == null || string.trim().length() == 0) {
                    roomController.setName("");
                } else {
                    roomController.setName(string);
                }
                roomController.addPropertyChangeListener(RoomController.Property.NAME, propertyChangeListener);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.areaVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "areaVisibleCheckBox.text", new Object[0]));
        this.areaVisibleCheckBox.setNullable(roomController.getAreaVisible() == null);
        this.areaVisibleCheckBox.setValue(roomController.getAreaVisible());
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.areaVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                RoomPanel.this.areaVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        roomController.addPropertyChangeListener(RoomController.Property.AREA_VISIBLE, propertyChangeListener2);
        this.areaVisibleCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                roomController.removePropertyChangeListener(RoomController.Property.AREA_VISIBLE, propertyChangeListener2);
                roomController.setAreaVisible(RoomPanel.this.areaVisibleCheckBox.getValue());
                roomController.addPropertyChangeListener(RoomController.Property.AREA_VISIBLE, propertyChangeListener2);
            }
        });
        this.floorVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorVisibleCheckBox.text", new Object[0]));
        this.floorVisibleCheckBox.setNullable(roomController.getFloorVisible() == null);
        this.floorVisibleCheckBox.setValue(roomController.getFloorVisible());
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.floorVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                RoomPanel.this.floorVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        roomController.addPropertyChangeListener(RoomController.Property.FLOOR_VISIBLE, propertyChangeListener3);
        this.floorVisibleCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                roomController.removePropertyChangeListener(RoomController.Property.FLOOR_VISIBLE, propertyChangeListener3);
                roomController.setFloorVisible(RoomPanel.this.floorVisibleCheckBox.getValue());
                roomController.addPropertyChangeListener(RoomController.Property.FLOOR_VISIBLE, propertyChangeListener3);
            }
        });
        this.floorColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorColorRadioButton.text", new Object[0]));
        this.floorColorRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.floorColorRadioButton.isSelected()) {
                    roomController.setFloorPaint(RoomController.RoomPaint.COLORED);
                }
            }
        });
        roomController.addPropertyChangeListener(RoomController.Property.FLOOR_PAINT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.updateFloorColorRadioButtons(roomController);
            }
        });
        this.floorColorButton = new ColorButton();
        this.floorColorButton.setColorDialogTitle(userPreferences.getLocalizedString(RoomPanel.class, "floorColorDialog.title", new Object[0]));
        this.floorColorButton.setColor(roomController.getFloorColor());
        this.floorColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                roomController.setFloorColor(RoomPanel.this.floorColorButton.getColor());
                roomController.setFloorPaint(RoomController.RoomPaint.COLORED);
            }
        });
        roomController.addPropertyChangeListener(RoomController.Property.FLOOR_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.floorColorButton.setColor(roomController.getFloorColor());
            }
        });
        this.floorTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorTextureRadioButton.text", new Object[0]));
        this.floorTextureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.floorTextureRadioButton.isSelected()) {
                    roomController.setFloorPaint(RoomController.RoomPaint.TEXTURED);
                }
            }
        });
        this.floorTextureComponent = (JComponent)((Object)roomController.getFloorTextureController().getView());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.floorColorRadioButton);
        buttonGroup.add(this.floorTextureRadioButton);
        this.updateFloorColorRadioButtons(roomController);
        this.floorMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorMattRadioButton.text", new Object[0]));
        this.floorMattRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.floorMattRadioButton.isSelected()) {
                    roomController.setFloorShininess(Float.valueOf(0.0f));
                }
            }
        });
        PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.updateFloorShininessRadioButtons(roomController);
            }
        };
        roomController.addPropertyChangeListener(RoomController.Property.FLOOR_SHININESS, propertyChangeListener4);
        this.floorShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorShinyRadioButton.text", new Object[0]));
        this.floorShinyRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.floorShinyRadioButton.isSelected()) {
                    roomController.setFloorShininess(Float.valueOf(0.25f));
                }
            }
        });
        roomController.addPropertyChangeListener(RoomController.Property.FLOOR_SHININESS, propertyChangeListener4);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.floorMattRadioButton);
        buttonGroup2.add(this.floorShinyRadioButton);
        this.updateFloorShininessRadioButtons(roomController);
        this.ceilingVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingVisibleCheckBox.text", new Object[0]));
        this.ceilingVisibleCheckBox.setNullable(roomController.getCeilingVisible() == null);
        this.ceilingVisibleCheckBox.setValue(roomController.getCeilingVisible());
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.ceilingVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                RoomPanel.this.ceilingVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        roomController.addPropertyChangeListener(RoomController.Property.CEILING_VISIBLE, propertyChangeListener5);
        this.ceilingVisibleCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                roomController.removePropertyChangeListener(RoomController.Property.CEILING_VISIBLE, propertyChangeListener5);
                roomController.setCeilingVisible(RoomPanel.this.ceilingVisibleCheckBox.getValue());
                roomController.addPropertyChangeListener(RoomController.Property.CEILING_VISIBLE, propertyChangeListener5);
            }
        });
        this.ceilingColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingColorRadioButton.text", new Object[0]));
        this.ceilingColorRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.ceilingColorRadioButton.isSelected()) {
                    roomController.setCeilingPaint(RoomController.RoomPaint.COLORED);
                }
            }
        });
        roomController.addPropertyChangeListener(RoomController.Property.CEILING_PAINT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.updateCeilingColorRadioButtons(roomController);
            }
        });
        this.ceilingColorButton = new ColorButton();
        this.ceilingColorButton.setColor(roomController.getCeilingColor());
        this.ceilingColorButton.setColorDialogTitle(userPreferences.getLocalizedString(RoomPanel.class, "ceilingColorDialog.title", new Object[0]));
        this.ceilingColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                roomController.setCeilingColor(RoomPanel.this.ceilingColorButton.getColor());
                roomController.setCeilingPaint(RoomController.RoomPaint.COLORED);
            }
        });
        roomController.addPropertyChangeListener(RoomController.Property.CEILING_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.ceilingColorButton.setColor(roomController.getCeilingColor());
            }
        });
        this.ceilingTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingTextureRadioButton.text", new Object[0]));
        this.ceilingTextureRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.ceilingTextureRadioButton.isSelected()) {
                    roomController.setCeilingPaint(RoomController.RoomPaint.TEXTURED);
                }
            }
        });
        this.ceilingTextureComponent = (JComponent)((Object)roomController.getCeilingTextureController().getView());
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.ceilingColorRadioButton);
        buttonGroup3.add(this.ceilingTextureRadioButton);
        this.updateCeilingColorRadioButtons(roomController);
        this.ceilingMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingMattRadioButton.text", new Object[0]));
        this.ceilingMattRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.ceilingMattRadioButton.isSelected()) {
                    roomController.setCeilingShininess(Float.valueOf(0.0f));
                }
            }
        });
        PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RoomPanel.this.updateCeilingShininessRadioButtons(roomController);
            }
        };
        roomController.addPropertyChangeListener(RoomController.Property.CEILING_SHININESS, propertyChangeListener6);
        this.ceilingShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingShinyRadioButton.text", new Object[0]));
        this.ceilingShinyRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RoomPanel.this.ceilingShinyRadioButton.isSelected()) {
                    roomController.setCeilingShininess(Float.valueOf(0.25f));
                }
            }
        });
        roomController.addPropertyChangeListener(RoomController.Property.CEILING_SHININESS, propertyChangeListener6);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.ceilingMattRadioButton);
        buttonGroup4.add(this.ceilingShinyRadioButton);
        this.updateCeilingShininessRadioButtons(roomController);
        this.dialogTitle = userPreferences.getLocalizedString(RoomPanel.class, "room.title", new Object[0]);
    }

    private void updateFloorColorRadioButtons(RoomController roomController) {
        if (roomController.getFloorPaint() == RoomController.RoomPaint.COLORED) {
            this.floorColorRadioButton.setSelected(true);
        } else if (roomController.getFloorPaint() == RoomController.RoomPaint.TEXTURED) {
            this.floorTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.floorColorRadioButton, this.floorTextureRadioButton);
        }
    }

    private void updateFloorShininessRadioButtons(RoomController roomController) {
        if (roomController.getFloorShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.floorMattRadioButton, this.floorShinyRadioButton);
        } else if (roomController.getFloorShininess().floatValue() == 0.0f) {
            this.floorMattRadioButton.setSelected(true);
        } else {
            this.floorShinyRadioButton.setSelected(true);
        }
    }

    private void updateCeilingColorRadioButtons(RoomController roomController) {
        if (roomController.getCeilingPaint() == RoomController.RoomPaint.COLORED) {
            this.ceilingColorRadioButton.setSelected(true);
        } else if (roomController.getCeilingPaint() == RoomController.RoomPaint.TEXTURED) {
            this.ceilingTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.ceilingColorRadioButton, this.ceilingTextureRadioButton);
        }
    }

    private void updateCeilingShininessRadioButtons(RoomController roomController) {
        if (roomController.getCeilingShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.ceilingMattRadioButton, this.ceilingShinyRadioButton);
        } else if (roomController.getCeilingShininess().floatValue() == 0.0f) {
            this.ceilingMattRadioButton.setSelected(true);
        } else {
            this.ceilingShinyRadioButton.setSelected(true);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setLabelFor(this.nameTextField);
            this.areaVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "areaVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.floorVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.floorColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.floorTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.floorMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorMattRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.floorShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.ceilingVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.ceilingColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.ceilingTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.ceilingMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingMattRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.ceilingShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents(UserPreferences userPreferences, RoomController roomController) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "nameAndAreaPanel.title", new Object[0]));
        jPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 2, new Insets(0, 8, 0, 5), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.areaVisibleCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        Insets insets = OperatingSystem.isMacOSXLeopardOrSuperior() ? new Insets(0, 0, 0, 0) : new Insets(0, 0, 5, 0);
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel2 = this.createVerticalTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "floorPanel.title", new Object[0]), new JComponent[]{this.floorVisibleCheckBox, null, this.floorColorRadioButton, this.floorColorButton, this.floorTextureRadioButton, this.floorTextureComponent});
        jPanel2.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        jPanel2.add((Component)this.floorMattRadioButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel2.add((Component)this.floorShinyRadioButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = this.createVerticalTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "ceilingPanel.title", new Object[0]), new JComponent[]{this.ceilingVisibleCheckBox, null, this.ceilingColorRadioButton, this.ceilingColorButton, this.ceilingTextureRadioButton, this.ceilingTextureComponent});
        jPanel3.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        jPanel3.add((Component)this.ceilingMattRadioButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel3.add((Component)this.ceilingShinyRadioButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createVerticalTitledPanel(String string, JComponent[] jComponentArray) {
        JPanel jPanel = SwingTools.createTitledPanel(string);
        for (int i = 0; i < jComponentArray.length; i += 2) {
            int n = i < jComponentArray.length - 2 ? 2 : 0;
            JComponent jComponent = jComponentArray[i];
            JComponent jComponent2 = jComponentArray[i + 1];
            if (jComponent2 != null) {
                jPanel.add((Component)jComponent, new GridBagConstraints(0, i / 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, n, 5), 0, 0));
                jPanel.add((Component)jComponent2, new GridBagConstraints(1, i / 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n, 0), 0, 0));
                continue;
            }
            jPanel.add((Component)jComponent, new GridBagConstraints(0, i / 2, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n, 0), 0, 0));
        }
        return jPanel;
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.nameTextField) == 0 && this.controller != null) {
            this.controller.modifyRooms();
        }
    }
}

