/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTools {
    private static Border unfocusedViewBorder;
    private static Border focusedViewBorder;
    private static Map<TextureImage, BufferedImage> patternImages;

    private SwingTools() {
    }

    public static void installFocusBorder(JComponent jComponent) {
        Serializable serializable;
        if (unfocusedViewBorder == null) {
            serializable = new AbstractBorder(){
                private Color topLeftColor;
                private Color botomRightColor;
                private Insets insets = new Insets(1, 1, 1, 1);
                {
                    if (OperatingSystem.isMacOSX()) {
                        this.topLeftColor = Color.GRAY;
                        this.botomRightColor = Color.LIGHT_GRAY;
                    } else {
                        this.topLeftColor = UIManager.getColor("TextField.darkShadow");
                        this.botomRightColor = UIManager.getColor("TextField.shadow");
                    }
                }

                public Insets getBorderInsets(Component component) {
                    return this.insets;
                }

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Color color = graphics.getColor();
                    Rectangle rectangle = this.getInteriorRectangle(component, n, n2, n3, n4);
                    graphics.setColor(this.topLeftColor);
                    graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x + rectangle.width, rectangle.y - 1);
                    graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.y + rectangle.height);
                    graphics.setColor(this.botomRightColor);
                    graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    graphics.setColor(color);
                }
            };
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                unfocusedViewBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Panel.background"), 2), (Border)((Object)serializable));
                focusedViewBorder = new AbstractBorder(){
                    private Insets insets = new Insets(3, 3, 3, 3);

                    public Insets getBorderInsets(Component component) {
                        return this.insets;
                    }

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        Color color = graphics.getColor();
                        Rectangle rectangle = this.getInteriorRectangle(component, n, n2, n3, n4);
                        graphics.setColor(Color.GRAY);
                        graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x + rectangle.width, rectangle.y - 1);
                        graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.y + rectangle.height);
                        graphics.setColor(Color.LIGHT_GRAY);
                        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                        Color color2 = UIManager.getColor("Focus.color");
                        int n5 = 128;
                        int n6 = 180;
                        if (color2 == null) {
                            color2 = UIManager.getColor("textHighlight");
                            n5 = 128;
                            n6 = 255;
                        }
                        graphics.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n5));
                        graphics.drawRoundRect(rectangle.x - 3, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5, 6, 6);
                        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        graphics.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n6));
                        graphics.drawRoundRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3, 4, 4);
                        graphics.setColor(UIManager.getColor("Panel.background"));
                        graphics.drawLine(rectangle.x - 3, rectangle.y - 3, rectangle.x - 2, rectangle.y - 3);
                        graphics.drawLine(rectangle.x - 3, rectangle.y - 2, rectangle.x - 3, rectangle.y - 2);
                        graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y - 3, rectangle.x + rectangle.width + 2, rectangle.y - 3);
                        graphics.drawLine(rectangle.x + rectangle.width + 2, rectangle.y - 2, rectangle.x + rectangle.width + 2, rectangle.y - 2);
                        graphics.drawLine(rectangle.x - 3, rectangle.y + rectangle.height + 2, rectangle.x - 2, rectangle.y + rectangle.height + 2);
                        graphics.drawLine(rectangle.x - 3, rectangle.y + rectangle.height + 1, rectangle.x - 3, rectangle.y + rectangle.height + 1);
                        graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height + 2, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 2);
                        graphics.drawLine(rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 1, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 1);
                        graphics.setColor(color);
                    }
                };
            } else {
                unfocusedViewBorder = OperatingSystem.isMacOSX() ? BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Panel.background"), 1), (Border)((Object)serializable)) : BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), (Border)((Object)serializable));
                focusedViewBorder = BorderFactory.createLineBorder(UIManager.getColor("textHighlight"), 2);
            }
        }
        serializable = jComponent.getParent() instanceof JViewport && jComponent.getParent().getParent() instanceof JScrollPane ? (JComponent)jComponent.getParent().getParent() : jComponent;
        ((JComponent)serializable).setBorder(unfocusedViewBorder);
        jComponent.addFocusListener(new FocusListener((JComponent)serializable){
            final /* synthetic */ JComponent val$feedbackComponent;
            {
                this.val$feedbackComponent = jComponent;
            }

            public void focusLost(FocusEvent focusEvent) {
                if (this.val$feedbackComponent.getBorder() == focusedViewBorder) {
                    this.val$feedbackComponent.setBorder(unfocusedViewBorder);
                }
            }

            public void focusGained(FocusEvent focusEvent) {
                if (this.val$feedbackComponent.getBorder() == unfocusedViewBorder) {
                    this.val$feedbackComponent.setBorder(focusedViewBorder);
                }
            }
        });
    }

    public static void updateSwingResourceLanguage() {
        SwingTools.updateSwingResourceBundle("com.sun.swing.internal.plaf.metal.resources.metal");
        SwingTools.updateSwingResourceBundle("com.sun.swing.internal.plaf.basic.resources.basic");
        if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            SwingTools.updateSwingResourceBundle("com.sun.java.swing.plaf.gtk.resources.gtk");
        } else if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            SwingTools.updateSwingResourceBundle("com.sun.java.swing.plaf.motif.resources.motif");
        }
    }

    private static void updateSwingResourceBundle(String string) {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = ResourceBundle.getBundle(string, Locale.ENGLISH);
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            UIManager.put(string2, resourceBundle.getString(string2));
        }
    }

    public static String getLocalizedLabelText(UserPreferences userPreferences, Class<?> clazz, String string, Object ... objectArray) {
        char c;
        int n;
        int n2;
        String string2 = userPreferences.getLocalizedString(clazz, string, objectArray);
        String string3 = Locale.getDefault().getLanguage();
        if (OperatingSystem.isMacOSX() && (string3.equals(Locale.CHINESE.getLanguage()) || string3.equals(Locale.JAPANESE.getLanguage()) || string3.equals(Locale.KOREAN.getLanguage())) && (n2 = string2.indexOf(40)) != -1 && n2 == (n = string2.indexOf(41)) - 2 && (c = string2.charAt(n2 + 1)) >= 'A' && c <= 'Z') {
            string2 = string2.substring(0, n2) + string2.substring(n + 1);
        }
        return string2;
    }

    public static void addAutoSelectionOnFocusGain(JTextComponent jTextComponent) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SelectionOnFocusManager
        extends MouseAdapter
        implements FocusListener {
            private boolean mousePressedInTextField = false;
            private int selectionStartBeforeFocusLost = -1;
            private int selectionEndBeforeFocusLost = -1;
            final /* synthetic */ JTextComponent val$textComponent;

            SelectionOnFocusManager(JTextComponent jTextComponent) {
                this.val$textComponent = jTextComponent;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.mousePressedInTextField = true;
                this.selectionStartBeforeFocusLost = -1;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() == null || SwingUtilities.getWindowAncestor(focusEvent.getOppositeComponent()) != SwingUtilities.getWindowAncestor(this.val$textComponent)) {
                    this.selectionStartBeforeFocusLost = this.val$textComponent.getSelectionStart();
                    this.selectionEndBeforeFocusLost = this.val$textComponent.getSelectionEnd();
                } else {
                    this.selectionStartBeforeFocusLost = -1;
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (this.selectionStartBeforeFocusLost != -1) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            val$textComponent.setSelectionStart(selectionStartBeforeFocusLost);
                            val$textComponent.setSelectionEnd(selectionEndBeforeFocusLost);
                        }
                    });
                } else if (!this.mousePressedInTextField && focusEvent.getOppositeComponent() != null && SwingUtilities.getWindowAncestor(focusEvent.getOppositeComponent()) == SwingUtilities.getWindowAncestor(this.val$textComponent)) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            val$textComponent.selectAll();
                        }
                    });
                }
                this.mousePressedInTextField = false;
            }
        }
        SelectionOnFocusManager selectionOnFocusManager = new SelectionOnFocusManager(jTextComponent);
        jTextComponent.addFocusListener(selectionOnFocusManager);
        jTextComponent.addMouseListener(selectionOnFocusManager);
    }

    public static void deselectAllRadioButtons(JRadioButton ... jRadioButtonArray) {
        for (JRadioButton jRadioButton : jRadioButtonArray) {
            ButtonGroup buttonGroup = ((JToggleButton.ToggleButtonModel)jRadioButton.getModel()).getGroup();
            buttonGroup.remove(jRadioButton);
            jRadioButton.setSelected(false);
            buttonGroup.add(jRadioButton);
        }
    }

    public static int showConfirmDialog(JComponent jComponent, JComponent jComponent2, String string, final JComponent jComponent3) {
        JOptionPane jOptionPane = new JOptionPane(jComponent2, -1, 2);
        if ((jComponent = SwingUtilities.getRootPane(jComponent)) != null) {
            jOptionPane.setComponentOrientation(jComponent.getComponentOrientation());
        }
        final JDialog jDialog = jOptionPane.createDialog(jComponent, string);
        if (jComponent3 != null) {
            jDialog.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    jComponent3.requestFocusInWindow();
                    jDialog.removeComponentListener(this);
                }
            });
        }
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object = jOptionPane.getValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public static void showMessageDialog(JComponent jComponent, JComponent jComponent2, String string, int n, final JComponent jComponent3) {
        JOptionPane jOptionPane = new JOptionPane(jComponent2, n, -1);
        if ((jComponent = SwingUtilities.getRootPane(jComponent)) != null) {
            jOptionPane.setComponentOrientation(jComponent.getComponentOrientation());
        }
        final JDialog jDialog = jOptionPane.createDialog(jComponent, string);
        if (jComponent3 != null) {
            jDialog.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    jComponent3.requestFocusInWindow();
                    jDialog.removeComponentListener(this);
                }
            });
        }
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    public static BufferedImage getPatternImage(TextureImage textureImage, Color color, Color color2) {
        if (patternImages == null) {
            patternImages = new HashMap<TextureImage, BufferedImage>();
        }
        BufferedImage bufferedImage = new BufferedImage((int)textureImage.getWidth(), (int)textureImage.getHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = patternImages.get(textureImage);
        if (bufferedImage2 == null) {
            try {
                InputStream inputStream = textureImage.getImage().openStream();
                bufferedImage2 = ImageIO.read(inputStream);
                inputStream.close();
                patternImages.put(textureImage, bufferedImage2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Can't read pattern image " + textureImage.getName());
            }
        }
        final int n = color2.getRGB() & 0xFFFFFF;
        graphics2D.drawImage(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bufferedImage2.getSource(), new RGBImageFilter(){
            {
                this.canFilterIndexColorModel = true;
            }

            public int filterRGB(int n4, int n2, int n3) {
                return n3 & 0xFF000000 | n;
            }
        })), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Border getDropableComponentBorder() {
        Border border = null;
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            border = UIManager.getBorder("InsetBorder.aquaVariant");
        }
        if (border == null) {
            border = BorderFactory.createLoweredBevelBorder();
        }
        return border;
    }

    public static void showSplashScreenWindow(URL uRL) {
        try {
            final BufferedImage bufferedImage = ImageIO.read(uRL);
            final Window window = new Window(new Frame()){

                public void paint(Graphics graphics) {
                    graphics.drawImage(bufferedImage, 0, 0, this);
                }
            };
            window.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
            window.setLocationRelativeTo(null);
            window.setVisible(true);
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                public void run() {
                    try {
                        while (window.isVisible()) {
                            Thread.sleep(500L);
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    if (Frame.getFrames().length > 1) {
                                        window.dispose();
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                window.dispose();
                            }
                        });
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JPanel createTitledPanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        AbstractBorder abstractBorder = BorderFactory.createTitledBorder(string);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            abstractBorder = BorderFactory.createCompoundBorder(abstractBorder, BorderFactory.createEmptyBorder(0, 2, 2, 2));
        }
        jPanel.setBorder(abstractBorder);
        return jPanel;
    }

    public static void hideDisabledMenuItems(JPopupMenu jPopupMenu) {
        jPopupMenu.addPopupMenuListener(new MenuItemsVisibilityListener());
    }

    private static class MenuItemsVisibilityListener
    implements PopupMenuListener {
        private MenuItemsVisibilityListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            int n;
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            for (n = 0; n < jPopupMenu.getComponentCount(); ++n) {
                Component component = jPopupMenu.getComponent(n);
                if (component instanceof JMenu) {
                    component.setVisible(this.containsEnabledItems((JMenu)component));
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                component.setVisible(component.isEnabled());
            }
            this.hideUselessSeparators(jPopupMenu);
            n = 1;
            for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
                if (!jPopupMenu.getComponent(i).isVisible()) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                jPopupMenu.getComponent(0).setVisible(true);
            }
        }

        private void hideUselessSeparators(JPopupMenu jPopupMenu) {
            int n;
            boolean bl = true;
            int n2 = -1;
            for (n = 0; n < jPopupMenu.getComponentCount(); ++n) {
                Component component = jPopupMenu.getComponent(n);
                if (bl && component instanceof JMenuItem) {
                    if (!component.isVisible()) continue;
                    bl = false;
                    continue;
                }
                if (!(component instanceof JSeparator)) continue;
                component.setVisible(!bl);
                if (!bl) {
                    n2 = n;
                }
                bl = true;
            }
            if (n2 != -1 && bl) {
                int n3;
                n = 1;
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    if (!jPopupMenu.getComponent(n3).isVisible()) continue;
                    n = 0;
                    break;
                }
                n3 = 1;
                for (int i = n2; i < jPopupMenu.getComponentCount(); ++i) {
                    if (!jPopupMenu.getComponent(i).isVisible()) continue;
                    n = 0;
                    break;
                }
                jPopupMenu.getComponent(n2).setVisible(n == 0 && n3 == 0);
            }
        }

        private boolean containsEnabledItems(JMenu jMenu) {
            boolean bl = false;
            for (int i = 0; i < jMenu.getMenuComponentCount() && !bl; ++i) {
                Component component = jMenu.getMenuComponent(i);
                if (component instanceof JMenu) {
                    bl = this.containsEnabledItems((JMenu)component);
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                bl = component.isEnabled();
            }
            return bl;
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

