/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private View furnitureView;
    private HomePieceOfFurniture leadSelectedPieceOfFurniture;

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this(home, userPreferences, viewFactory, null, null);
    }

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.contentManager = contentManager;
        this.addModelListeners();
    }

    @Override
    public View getView() {
        if (this.furnitureView == null) {
            this.furnitureView = this.viewFactory.createFurnitureView(this.home, this.preferences, this);
        }
        return this.furnitureView;
    }

    private void addModelListeners() {
        this.home.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                List<HomePieceOfFurniture> list = Home.getFurnitureSubList(FurnitureController.this.home.getSelectedItems());
                if (list.isEmpty()) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = null;
                } else if (FurnitureController.this.leadSelectedPieceOfFurniture == null || list.size() == 1) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = list.get(0);
                }
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HomePieceOfFurniture.Property.MOVABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    List<Selectable> list;
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                    if (FurnitureController.this.home.isBasePlanLocked() && FurnitureController.this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture) && (list = FurnitureController.this.home.getSelectedItems()).contains(homePieceOfFurniture)) {
                        list = new ArrayList<Selectable>(list);
                        list.remove(homePieceOfFurniture);
                        FurnitureController.this.home.setSelectedItems(list);
                    }
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
        }
        this.home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                }
            }
        });
    }

    public void addFurniture(List<HomePieceOfFurniture> list) {
        boolean bl;
        final boolean bl2 = this.home.isBasePlanLocked();
        final List<Selectable> list2 = this.home.getSelectedItems();
        final HomePieceOfFurniture[] homePieceOfFurnitureArray = list.toArray(new HomePieceOfFurniture[list.size()]);
        final int[] nArray = new int[list.size()];
        int n = this.home.getFurniture().size();
        boolean bl3 = bl2;
        for (bl = false; bl < nArray.length; bl += 1) {
            nArray[bl] = n++;
            bl3 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[bl]);
        }
        bl = bl3;
        this.doAddFurniture(homePieceOfFurnitureArray, nArray, bl);
        if (this.undoSupport != null) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    FurnitureController.this.doDeleteFurniture(homePieceOfFurnitureArray, bl2);
                    FurnitureController.this.home.setSelectedItems(list2);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    FurnitureController.this.doAddFurniture(homePieceOfFurnitureArray, nArray, bl);
                }

                public String getPresentationName() {
                    return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAddFurnitureName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doAddFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.home.addPieceOfFurniture(homePieceOfFurnitureArray[i], nArray[i]);
        }
        this.home.setBasePlanLocked(bl);
        this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
    }

    public void deleteSelection() {
        this.deleteFurniture(Home.getFurnitureSubList(this.home.getSelectedItems()));
    }

    public void deleteFurniture(List<HomePieceOfFurniture> list) {
        final boolean bl = this.home.isBasePlanLocked();
        List<HomePieceOfFurniture> list2 = this.home.getFurniture();
        TreeMap<Integer, HomePieceOfFurniture> treeMap = new TreeMap<Integer, HomePieceOfFurniture>();
        for (HomePieceOfFurniture object2 : list) {
            if (!this.isPieceOfFurnitureDeletable(object2)) continue;
            treeMap.put(list2.indexOf(object2), object2);
        }
        final HomePieceOfFurniture[] homePieceOfFurnitureArray = treeMap.values().toArray(new HomePieceOfFurniture[treeMap.size()]);
        final int[] nArray = new int[homePieceOfFurnitureArray.length];
        int n = 0;
        Object object = treeMap.keySet().iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            nArray[n++] = n2;
        }
        this.doDeleteFurniture(homePieceOfFurnitureArray, bl);
        if (this.undoSupport != null) {
            object = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    FurnitureController.this.doAddFurniture(homePieceOfFurnitureArray, nArray, bl);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    FurnitureController.this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
                    FurnitureController.this.doDeleteFurniture(homePieceOfFurnitureArray, bl);
                }

                public String getPresentationName() {
                    return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoDeleteSelectionName", new Object[0]);
                }
            };
            this.undoSupport.postEdit((UndoableEdit)object);
        }
    }

    private void doDeleteFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, boolean bl) {
        for (HomePieceOfFurniture homePieceOfFurniture : homePieceOfFurnitureArray) {
            this.home.deletePieceOfFurniture(homePieceOfFurniture);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void setSelectedFurniture(List<HomePieceOfFurniture> list) {
        if (this.home.isBasePlanLocked()) {
            list = this.getFurnitureNotPartOfBasePlan(list);
        }
        this.home.setSelectedItems(list);
    }

    public void selectAll() {
        this.setSelectedFurniture(this.home.getFurniture());
    }

    protected boolean isPieceOfFurniturePartOfBasePlan(HomePieceOfFurniture homePieceOfFurniture) {
        return !homePieceOfFurniture.isMovable() || homePieceOfFurniture.isDoorOrWindow();
    }

    protected boolean isPieceOfFurnitureMovable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    protected boolean isPieceOfFurnitureDeletable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    private List<HomePieceOfFurniture> getFurnitureNotPartOfBasePlan(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public void toggleFurnitureSort(HomePieceOfFurniture.SortableProperty sortableProperty) {
        if (sortableProperty.equals((Object)this.home.getFurnitureSortedProperty())) {
            this.home.setFurnitureSortedProperty(null);
        } else {
            this.home.setFurnitureSortedProperty(sortableProperty);
        }
    }

    public void toggleFurnitureSortOrder() {
        this.home.setFurnitureDescendingSorted(!this.home.isFurnitureDescendingSorted());
    }

    public void sortFurniture(HomePieceOfFurniture.SortableProperty sortableProperty) {
        HomePieceOfFurniture.SortableProperty sortableProperty2 = this.home.getFurnitureSortedProperty();
        boolean bl = this.home.isFurnitureDescendingSorted();
        boolean bl2 = false;
        if (sortableProperty.equals((Object)sortableProperty2)) {
            if (bl) {
                sortableProperty = null;
            } else {
                bl2 = true;
            }
        }
        this.home.setFurnitureSortedProperty(sortableProperty);
        this.home.setFurnitureDescendingSorted(bl2);
    }

    public void setFurnitureVisibleProperties(List<HomePieceOfFurniture.SortableProperty> list) {
        this.home.setFurnitureVisibleProperties(list);
    }

    public void toggleFurnitureVisibleProperty(HomePieceOfFurniture.SortableProperty sortableProperty) {
        ArrayList<HomePieceOfFurniture.SortableProperty> arrayList = new ArrayList<HomePieceOfFurniture.SortableProperty>(this.home.getFurnitureVisibleProperties());
        if (arrayList.contains((Object)sortableProperty)) {
            arrayList.remove((Object)sortableProperty);
            if (arrayList.isEmpty()) {
                arrayList.add(HomePieceOfFurniture.SortableProperty.NAME);
            }
        } else {
            List<HomePieceOfFurniture.SortableProperty> list = Arrays.asList(HomePieceOfFurniture.SortableProperty.CATALOG_ID, HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.X, HomePieceOfFurniture.SortableProperty.Y, HomePieceOfFurniture.SortableProperty.ELEVATION, HomePieceOfFurniture.SortableProperty.ANGLE, HomePieceOfFurniture.SortableProperty.COLOR, HomePieceOfFurniture.SortableProperty.TEXTURE, HomePieceOfFurniture.SortableProperty.MOVABLE, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW, HomePieceOfFurniture.SortableProperty.VISIBLE, HomePieceOfFurniture.SortableProperty.PRICE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED);
            int n = list.indexOf((Object)sortableProperty) - 1;
            if (n > 0) {
                while (n > 0) {
                    int n2 = arrayList.indexOf((Object)list.get(n));
                    if (n2 >= 0) {
                        n = n2 + 1;
                        break;
                    }
                    --n;
                }
            }
            if (n < 0) {
                n = 0;
            }
            arrayList.add(n, sortableProperty);
        }
        this.home.setFurnitureVisibleProperties(arrayList);
    }

    public void modifySelectedFurniture() {
        if (!Home.getFurnitureSubList(this.home.getSelectedItems()).isEmpty()) {
            new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void groupSelectedFurniture() {
        List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (!list.isEmpty()) {
            final boolean bl = this.home.isBasePlanLocked();
            final List<Selectable> list2 = this.home.getSelectedItems();
            List<HomePieceOfFurniture> list3 = this.home.getFurniture();
            TreeMap<Integer, HomePieceOfFurniture> treeMap = new TreeMap<Integer, HomePieceOfFurniture>();
            for (HomePieceOfFurniture object22 : list) {
                treeMap.put(list3.indexOf(object22), object22);
            }
            final HomePieceOfFurniture[] homePieceOfFurnitureArray = treeMap.values().toArray(new HomePieceOfFurniture[treeMap.size()]);
            final int[] nArray = new int[homePieceOfFurnitureArray.length];
            final boolean[] blArray = new boolean[homePieceOfFurnitureArray.length];
            final boolean[] blArray2 = new boolean[homePieceOfFurnitureArray.length];
            int n = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                nArray[n] = (Integer)entry.getKey();
                blArray[n] = ((HomePieceOfFurniture)entry.getValue()).isMovable();
                blArray2[n++] = ((HomePieceOfFurniture)entry.getValue()).isVisible();
            }
            String string = this.preferences.getLocalizedString(FurnitureController.class, "groupName", this.getFurnitureGroupCount(list3) + 1);
            final HomeFurnitureGroup homeFurnitureGroup = new HomeFurnitureGroup(list, string);
            final int n2 = list3.size() - homePieceOfFurnitureArray.length;
            final boolean bl2 = homeFurnitureGroup.isMovable();
            this.doGroupFurniture(homePieceOfFurnitureArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, new int[]{n2}, bl);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.doUngroupFurniture(homePieceOfFurnitureArray, nArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, bl);
                        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                            homePieceOfFurnitureArray[i].setMovable(blArray[i]);
                            homePieceOfFurnitureArray[i].setVisible(blArray2[i]);
                        }
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.doGroupFurniture(homePieceOfFurnitureArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, new int[]{n2}, bl);
                        homeFurnitureGroup.setMovable(bl2);
                        homeFurnitureGroup.setVisible(true);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoGroupName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private int getFurnitureGroupCount(List<HomePieceOfFurniture> list) {
        int n = 0;
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            n += 1 + this.getFurnitureGroupCount(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture());
        }
        return n;
    }

    private void doGroupFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray, int[] nArray, boolean bl) {
        this.doDeleteFurniture(homePieceOfFurnitureArray, bl);
        this.doAddFurniture(homeFurnitureGroupArray, nArray, bl);
    }

    private void doUngroupFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, HomeFurnitureGroup[] homeFurnitureGroupArray, boolean bl) {
        this.doDeleteFurniture(homeFurnitureGroupArray, bl);
        this.doAddFurniture(homePieceOfFurnitureArray, nArray, bl);
    }

    public void ungroupSelectedFurniture() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Selectable object2 : this.home.getSelectedItems()) {
            if (!(object2 instanceof HomeFurnitureGroup) || !this.isPieceOfFurnitureMovable((HomePieceOfFurniture)(object = (HomeFurnitureGroup)object2))) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            Object object22;
            boolean bl = this.home.isBasePlanLocked();
            List<Selectable> list = this.home.getSelectedItems();
            object = this.home.getFurniture();
            TreeMap<Integer, HomeFurnitureGroup> treeMap = new TreeMap<Integer, HomeFurnitureGroup>();
            for (Object object22 : arrayList) {
                treeMap.put(object.indexOf(object22), (HomeFurnitureGroup)object22);
            }
            final HomeFurnitureGroup[] homeFurnitureGroupArray = treeMap.values().toArray(new HomeFurnitureGroup[treeMap.size()]);
            object22 = new int[homeFurnitureGroupArray.length];
            int n = 0;
            Object object3 = treeMap.keySet().iterator();
            while (object3.hasNext()) {
                int homePieceOfFurnitureArray = (Integer)object3.next();
                object22[n++] = homePieceOfFurnitureArray;
            }
            object3 = new ArrayList();
            for (HomeFurnitureGroup bl2 : homeFurnitureGroupArray) {
                object3.addAll(bl2.getFurniture());
            }
            final HomePieceOfFurniture[] homePieceOfFurnitureArray = object3.toArray(new HomePieceOfFurniture[object3.size()]);
            int[] nArray = new int[homePieceOfFurnitureArray.length];
            int n2 = object.size() - homeFurnitureGroupArray.length;
            boolean bl2 = bl;
            for (n = 0; n < homePieceOfFurnitureArray.length; ++n) {
                nArray[n] = n2++;
                bl2 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[n]);
            }
            boolean bl3 = bl2;
            this.doUngroupFurniture(homePieceOfFurnitureArray, nArray, homeFurnitureGroupArray, bl3);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit((int[])object22, bl, list, nArray, bl3){
                    final /* synthetic */ int[] val$furnitureGroupsIndex;
                    final /* synthetic */ boolean val$oldBasePlanLocked;
                    final /* synthetic */ List val$oldSelection;
                    final /* synthetic */ int[] val$groupPiecesIndex;
                    final /* synthetic */ boolean val$newBasePlanLocked;
                    {
                        this.val$furnitureGroupsIndex = nArray;
                        this.val$oldBasePlanLocked = bl;
                        this.val$oldSelection = list;
                        this.val$groupPiecesIndex = nArray2;
                        this.val$newBasePlanLocked = bl2;
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.doGroupFurniture(homePieceOfFurnitureArray, homeFurnitureGroupArray, this.val$furnitureGroupsIndex, this.val$oldBasePlanLocked);
                        FurnitureController.this.home.setSelectedItems(this.val$oldSelection);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.doUngroupFurniture(homePieceOfFurnitureArray, this.val$groupPiecesIndex, homeFurnitureGroupArray, this.val$newBasePlanLocked);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoUngroupName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    public void importFurniture() {
        new ImportedFurnitureWizardController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void importFurniture(String string) {
        new ImportedFurnitureWizardController(this.home, string, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void alignSelectedFurnitureOnTop() {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 2) {
            final HomePieceOfFurniture homePieceOfFurniture = this.leadSelectedPieceOfFurniture;
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, homePieceOfFurniture, false);
            this.doAlignFurnitureOnTop(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray, false);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doAlignFurnitureOnTop(alignedPieceOfFurnitureArray, homePieceOfFurniture);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAlignName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private List<HomePieceOfFurniture> getMovableSelectedFurniture() {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            HomePieceOfFurniture homePieceOfFurniture;
            if (!(selectable instanceof HomePieceOfFurniture) || !this.isPieceOfFurnitureMovable(homePieceOfFurniture = (HomePieceOfFurniture)selectable)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private void doAlignFurnitureOnTop(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
        float f = this.getMinY(homePieceOfFurniture);
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
            float f2 = this.getMinY(homePieceOfFurniture2);
            homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
        }
    }

    private void undoAlignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, boolean bl) {
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture = alignedPieceOfFurniture.getPieceOfFurniture();
            if (bl) {
                homePieceOfFurniture.setX(alignedPieceOfFurniture.getXOrY());
                continue;
            }
            homePieceOfFurniture.setY(alignedPieceOfFurniture.getXOrY());
        }
    }

    public void alignSelectedFurnitureOnBottom() {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 2) {
            final HomePieceOfFurniture homePieceOfFurniture = this.leadSelectedPieceOfFurniture;
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, homePieceOfFurniture, false);
            this.doAlignFurnitureOnBottom(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray, false);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doAlignFurnitureOnBottom(alignedPieceOfFurnitureArray, homePieceOfFurniture);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAlignName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private void doAlignFurnitureOnBottom(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
        float f = this.getMaxY(homePieceOfFurniture);
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
            float f2 = this.getMaxY(homePieceOfFurniture2);
            homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
        }
    }

    public void alignSelectedFurnitureOnLeft() {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 2) {
            final HomePieceOfFurniture homePieceOfFurniture = this.leadSelectedPieceOfFurniture;
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, homePieceOfFurniture, true);
            this.doAlignFurnitureOnLeft(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray, true);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doAlignFurnitureOnLeft(alignedPieceOfFurnitureArray, homePieceOfFurniture);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAlignName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private void doAlignFurnitureOnLeft(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
        float f = this.getMinX(homePieceOfFurniture);
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
            float f2 = this.getMinX(homePieceOfFurniture2);
            homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
        }
    }

    public void alignSelectedFurnitureOnRight() {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 2) {
            final HomePieceOfFurniture homePieceOfFurniture = this.leadSelectedPieceOfFurniture;
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, homePieceOfFurniture, true);
            this.doAlignFurnitureOnRight(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray, true);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doAlignFurnitureOnRight(alignedPieceOfFurnitureArray, homePieceOfFurniture);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAlignName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private void doAlignFurnitureOnRight(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
        float f = this.getMaxX(homePieceOfFurniture);
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
            float f2 = this.getMaxX(homePieceOfFurniture2);
            homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
        }
    }

    private float getMinX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[0]);
        }
        return f;
    }

    private float getMaxX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[0]);
        }
        return f;
    }

    private float getMinY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[1]);
        }
        return f;
    }

    private float getMaxY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[1]);
        }
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlignedPieceOfFurniture {
        private HomePieceOfFurniture piece;
        private float xOrY;

        public AlignedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, boolean bl) {
            this.piece = homePieceOfFurniture;
            this.xOrY = bl ? homePieceOfFurniture.getX() : homePieceOfFurniture.getY();
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public float getXOrY() {
            return this.xOrY;
        }

        public static AlignedPieceOfFurniture[] getAlignedFurniture(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture, boolean bl) {
            AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = new AlignedPieceOfFurniture[list.size() - 1];
            int n = 0;
            for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
                if (homePieceOfFurniture2 == homePieceOfFurniture) continue;
                alignedPieceOfFurnitureArray[n++] = new AlignedPieceOfFurniture(homePieceOfFurniture2, bl);
            }
            return alignedPieceOfFurnitureArray;
        }
    }
}

