/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.Home3DAttributesController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.UndoableEditSupport;

public class HomeController3D
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private View home3DView;
    private final CameraControllerState topCameraState;
    private final CameraControllerState observerCameraState;
    private CameraControllerState cameraState;

    public HomeController3D(final Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.topCameraState = new TopCameraState();
        this.observerCameraState = new ObserverCameraState();
        this.setCameraState(home.getCamera() == home.getTopCamera() ? this.topCameraState : this.observerCameraState);
        home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController3D.this.setCameraState(home.getCamera() == home.getTopCamera() ? HomeController3D.this.topCameraState : HomeController3D.this.observerCameraState);
            }
        });
    }

    public View getView() {
        if (this.home3DView == null) {
            this.home3DView = this.viewFactory.createView3D(this.home, this.preferences, this);
        }
        return this.home3DView;
    }

    public void viewFromTop() {
        this.home.setCamera(this.home.getTopCamera());
    }

    public void viewFromObserver() {
        this.home.setCamera(this.home.getObserverCamera());
    }

    public void storeCamera(String string) {
        Camera camera = this.home.getCamera().clone();
        camera.setName(string);
        List<Camera> list = this.home.getStoredCameras();
        ArrayList<Camera> arrayList = new ArrayList<Camera>(list.size() + 1);
        arrayList.addAll(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Camera camera2 = (Camera)iterator.next();
            if (!string.equals(camera2.getName()) && (camera.getX() != camera2.getX() || camera.getY() != camera2.getY() || camera.getZ() != camera2.getZ() || camera.getPitch() != camera2.getPitch() || camera.getYaw() != camera2.getYaw() || camera.getFieldOfView() != camera2.getFieldOfView() || camera.getTime() != camera2.getTime() || camera.getLens() != camera2.getLens())) continue;
            iterator.remove();
        }
        arrayList.add(0, camera);
        while (arrayList.size() > 10) {
            arrayList.remove(arrayList.size() - 1);
        }
        this.home.setStoredCameras(arrayList);
    }

    public void goToCamera(Camera camera) {
        if (camera instanceof ObserverCamera) {
            this.viewFromObserver();
        } else {
            this.viewFromTop();
        }
        this.cameraState.goToCamera(camera);
        ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getStoredCameras());
        arrayList.remove(camera);
        arrayList.add(0, camera);
        this.home.setStoredCameras(arrayList);
    }

    public void modifyAttributes() {
        new Home3DAttributesController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    protected void setCameraState(CameraControllerState cameraControllerState) {
        if (this.cameraState != null) {
            this.cameraState.exit();
        }
        this.cameraState = cameraControllerState;
        this.cameraState.enter();
    }

    public void moveCamera(float f) {
        this.cameraState.moveCamera(f);
    }

    public void elevateCamera(float f) {
        this.cameraState.elevateCamera(f);
    }

    public void rotateCameraYaw(float f) {
        this.cameraState.rotateCameraYaw(f);
    }

    public void rotateCameraPitch(float f) {
        this.cameraState.rotateCameraPitch(f);
    }

    protected CameraControllerState getObserverCameraState() {
        return this.observerCameraState;
    }

    protected CameraControllerState getTopCameraState() {
        return this.topCameraState;
    }

    private class ObserverCameraState
    extends CameraControllerState {
        private ObserverCamera observerCamera;

        private ObserverCameraState() {
        }

        public void enter() {
            this.observerCamera = (ObserverCamera)HomeController3D.this.home.getCamera();
            HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
        }

        public void moveCamera(float f) {
            this.observerCamera.setX(this.observerCamera.getX() - (float)Math.sin(this.observerCamera.getYaw()) * f);
            this.observerCamera.setY(this.observerCamera.getY() + (float)Math.cos(this.observerCamera.getYaw()) * f);
            HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
        }

        public void elevateCamera(float f) {
            float f2 = this.observerCamera.getZ() + f;
            f2 = Math.max(f2, 9.0f);
            f2 = Math.min(f2, 933.0f);
            this.observerCamera.setZ(f2);
            HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
        }

        public void rotateCameraYaw(float f) {
            this.observerCamera.setYaw(this.observerCamera.getYaw() + f);
            HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
        }

        public void rotateCameraPitch(float f) {
            float f2 = this.observerCamera.getPitch() + f;
            f2 = Math.max(f2, -1.0471976f);
            f2 = Math.min(f2, 1.308997f);
            this.observerCamera.setPitch(f2);
            HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
        }

        public void goToCamera(Camera camera) {
            this.observerCamera.setCamera(camera);
            this.observerCamera.setTime(camera.getTime());
            this.observerCamera.setLens(camera.getLens());
        }

        public void exit() {
            List<Selectable> list = HomeController3D.this.home.getSelectedItems();
            if (list.contains(this.observerCamera)) {
                list = new ArrayList<Selectable>(list);
                list.remove(this.observerCamera);
                HomeController3D.this.home.setSelectedItems(list);
            }
            this.observerCamera = null;
        }
    }

    private class TopCameraState
    extends CameraControllerState {
        private final Rectangle2D MIN_BOUNDS = new Rectangle2D.Float(0.0f, 0.0f, 1000.0f, 1000.0f);
        private Camera topCamera;
        private Rectangle2D homeBounds;
        private float minDistanceToHomeCenter;
        private PropertyChangeListener objectChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TopCameraState.this.updateCameraFromHomeBounds();
            }
        };
        private CollectionListener<Wall> wallListener = new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds();
            }
        };
        private CollectionListener<HomePieceOfFurniture> furnitureListener = new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds();
            }
        };
        private CollectionListener<Room> roomsListener = new CollectionListener<Room>(){

            @Override
            public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds();
            }
        };

        private TopCameraState() {
        }

        public void enter() {
            this.topCamera = HomeController3D.this.home.getCamera();
            this.updateCameraFromHomeBounds();
            for (Wall selectable : HomeController3D.this.home.getWalls()) {
                selectable.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addWallsListener(this.wallListener);
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                homePieceOfFurniture.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addFurnitureListener(this.furnitureListener);
            for (Room room : HomeController3D.this.home.getRooms()) {
                room.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addRoomsListener(this.roomsListener);
        }

        private void updateCameraFromHomeBounds() {
            if (this.homeBounds == null) {
                this.homeBounds = this.getHomeBounds();
            }
            float f = (float)Math.sqrt(Math.pow(this.homeBounds.getCenterX() - (double)this.topCamera.getX(), 2.0) + Math.pow(this.homeBounds.getCenterY() - (double)this.topCamera.getY(), 2.0) + Math.pow(this.topCamera.getZ(), 2.0));
            this.homeBounds = this.getHomeBounds();
            this.minDistanceToHomeCenter = this.getMinDistanceToHomeCenter(this.homeBounds);
            this.placeCameraAt(f);
        }

        private Rectangle2D getHomeBounds() {
            Rectangle2D rectangle2D = null;
            Collection<Wall> collection = HomeController3D.this.home.getWalls();
            for (Wall selectable : collection) {
                for (float[] fArray : selectable.getPoints()) {
                    rectangle2D = this.updateHomeBounds(rectangle2D, fArray[0], fArray[1]);
                }
            }
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                if (!homePieceOfFurniture.isVisible()) continue;
                for (float[] fArray : homePieceOfFurniture.getPoints()) {
                    rectangle2D = this.updateHomeBounds(rectangle2D, fArray[0], fArray[1]);
                }
            }
            for (Room room : HomeController3D.this.home.getRooms()) {
                for (float[] fArray : room.getPoints()) {
                    rectangle2D = this.updateHomeBounds(rectangle2D, fArray[0], fArray[1]);
                }
            }
            if (rectangle2D != null) {
                if (collection.isEmpty()) {
                    return rectangle2D;
                }
                return new Rectangle2D.Float((float)(this.MIN_BOUNDS.getWidth() < rectangle2D.getWidth() ? rectangle2D.getMinX() : rectangle2D.getCenterX() - this.MIN_BOUNDS.getWidth() / 2.0), (float)(this.MIN_BOUNDS.getHeight() < rectangle2D.getHeight() ? rectangle2D.getMinY() : rectangle2D.getCenterY() - this.MIN_BOUNDS.getHeight() / 2.0), (float)Math.max(this.MIN_BOUNDS.getWidth(), rectangle2D.getWidth()), (float)Math.max(this.MIN_BOUNDS.getHeight(), rectangle2D.getHeight()));
            }
            return this.MIN_BOUNDS;
        }

        private Rectangle2D updateHomeBounds(Rectangle2D rectangle2D, float f, float f2) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
            } else {
                rectangle2D.add(f, f2);
            }
            return rectangle2D;
        }

        private float getMinDistanceToHomeCenter(Rectangle2D rectangle2D) {
            float f = 0.0f;
            Collection<Wall> collection = HomeController3D.this.home.getWalls();
            if (collection.isEmpty()) {
                for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                    if (!homePieceOfFurniture.isVisible()) continue;
                    f = Math.max(f, homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeight());
                }
            } else {
                for (Wall wall : collection) {
                    Float f2;
                    Float f3 = wall.getHeight();
                    if (f3 != null) {
                        f = Math.max(f, f3.floatValue());
                    }
                    if ((f2 = wall.getHeightAtEnd()) == null) continue;
                    f = Math.max(f, f2.floatValue());
                }
            }
            f = f > 0.0f ? Math.max(10.0f, f) : HomeController3D.this.home.getWallHeight();
            double d = Math.sqrt(rectangle2D.getWidth() * rectangle2D.getWidth() + rectangle2D.getHeight() * rectangle2D.getHeight()) / 2.0;
            return (float)Math.sqrt((double)(f * f) + d * d) * 1.1f;
        }

        public void moveCamera(float f) {
            float f2 = (float)Math.sqrt(Math.pow(this.homeBounds.getCenterX() - (double)this.topCamera.getX(), 2.0) + Math.pow(this.homeBounds.getCenterY() - (double)this.topCamera.getY(), 2.0) + Math.pow(this.topCamera.getZ(), 2.0)) - (f *= 5.0f);
            this.placeCameraAt(f2);
        }

        public void placeCameraAt(float f) {
            f = Math.max(f, this.minDistanceToHomeCenter);
            f = Math.min(f, 5.0f * this.minDistanceToHomeCenter);
            double d = (double)f * Math.cos(this.topCamera.getPitch());
            this.topCamera.setX((float)this.homeBounds.getCenterX() + (float)(Math.sin(this.topCamera.getYaw()) * d));
            this.topCamera.setY((float)this.homeBounds.getCenterY() - (float)(Math.cos(this.topCamera.getYaw()) * d));
            this.topCamera.setZ((float)Math.sin(this.topCamera.getPitch()) * f);
        }

        public void rotateCameraYaw(float f) {
            float f2 = this.topCamera.getYaw() + f;
            double d = (double)this.topCamera.getZ() / Math.tan(this.topCamera.getPitch());
            this.topCamera.setYaw(f2);
            this.topCamera.setX((float)this.homeBounds.getCenterX() + (float)(Math.sin(f2) * d));
            this.topCamera.setY((float)this.homeBounds.getCenterY() - (float)(Math.cos(f2) * d));
        }

        public void rotateCameraPitch(float f) {
            float f2 = this.topCamera.getPitch() - f;
            f2 = Math.max(f2, 0.19634955f);
            f2 = Math.min(f2, 1.5707964f);
            double d = Math.sqrt(Math.pow((double)this.topCamera.getX() - this.homeBounds.getCenterX(), 2.0) + Math.pow((double)this.topCamera.getY() - this.homeBounds.getCenterY(), 2.0) + Math.pow(this.topCamera.getZ(), 2.0));
            float f3 = (float)(d * Math.sin(f2));
            double d2 = (double)f3 / Math.tan(f2);
            this.topCamera.setPitch(f2);
            this.topCamera.setX((float)this.homeBounds.getCenterX() + (float)(Math.sin(this.topCamera.getYaw()) * d2));
            this.topCamera.setY((float)this.homeBounds.getCenterY() - (float)(Math.cos(this.topCamera.getYaw()) * d2));
            this.topCamera.setZ(f3);
        }

        public void goToCamera(Camera camera) {
            this.topCamera.setCamera(camera);
            this.topCamera.setTime(camera.getTime());
            this.topCamera.setLens(camera.getLens());
            this.updateCameraFromHomeBounds();
        }

        public void exit() {
            this.topCamera = null;
            for (Wall selectable : HomeController3D.this.home.getWalls()) {
                selectable.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeWallsListener(this.wallListener);
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                homePieceOfFurniture.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeFurnitureListener(this.furnitureListener);
            for (Room room : HomeController3D.this.home.getRooms()) {
                room.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeRoomsListener(this.roomsListener);
        }
    }

    protected static abstract class CameraControllerState {
        protected CameraControllerState() {
        }

        public void enter() {
        }

        public void exit() {
        }

        public void moveCamera(float f) {
        }

        public void elevateCamera(float f) {
        }

        public void rotateCameraYaw(float f) {
        }

        public void rotateCameraPitch(float f) {
        }

        public void goToCamera(Camera camera) {
        }
    }
}

