/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class LabelController
implements Controller {
    private final Home home;
    private final Float x;
    private final Float y;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView labelView;
    private String text;

    public LabelController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.x = null;
        this.y = null;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public LabelController(Home home, float f, float f2, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.x = Float.valueOf(f);
        this.y = Float.valueOf(f2);
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    protected void updateProperties() {
        List<Label> list = Home.getLabelsSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setText(null);
        } else {
            Label label = list.get(0);
            String string = label.getText();
            if (string != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string.equals(list.get(i).getText())) continue;
                    string = null;
                    break;
                }
            }
            this.setText(string);
        }
    }

    public DialogView getView() {
        if (this.labelView == null) {
            this.labelView = this.viewFactory.createLabelView(this.x == null, this.preferences, this);
        }
        return this.labelView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void setText(String string) {
        if (string != this.text) {
            String string2 = this.text;
            this.text = string;
            this.propertyChangeSupport.firePropertyChange(Property.TEXT.name(), string2, string);
        }
    }

    public String getText() {
        return this.text;
    }

    public void createLabel() {
        String string = this.getText();
        if (string != null && string.trim().length() > 0) {
            List<Selectable> list = this.home.getSelectedItems();
            boolean bl = this.home.isBasePlanLocked();
            Label label = new Label(string, this.x.floatValue(), this.y.floatValue());
            boolean bl2 = bl && !this.isLabelPartOfBasePlan(label);
            LabelController.doAddLabel(this.home, label, bl2);
            if (this.undoSupport != null) {
                LabelCreationUndoableEdit labelCreationUndoableEdit = new LabelCreationUndoableEdit(this.home, this.preferences, list, bl, label, bl2);
                this.undoSupport.postEdit(labelCreationUndoableEdit);
            }
        }
    }

    private static void doAddLabel(Home home, Label label, boolean bl) {
        home.addLabel(label);
        home.setBasePlanLocked(bl);
        home.setSelectedItems(Arrays.asList(label));
    }

    private static void doDeleteLabel(Home home, Label label, boolean bl) {
        home.deleteLabel(label);
        home.setBasePlanLocked(bl);
    }

    protected boolean isLabelPartOfBasePlan(Label label) {
        return true;
    }

    public void modifyLabels() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Label> list2 = Home.getLabelsSubList(list);
        if (!list2.isEmpty()) {
            String string = this.getText();
            ModifiedLabel[] modifiedLabelArray = new ModifiedLabel[list2.size()];
            for (int i = 0; i < modifiedLabelArray.length; ++i) {
                modifiedLabelArray[i] = new ModifiedLabel(list2.get(i));
            }
            LabelController.doModifyLabels(modifiedLabelArray, string);
            if (this.undoSupport != null) {
                LabelModificationUndoableEdit labelModificationUndoableEdit = new LabelModificationUndoableEdit(this.home, this.preferences, list, modifiedLabelArray, string);
                this.undoSupport.postEdit(labelModificationUndoableEdit);
            }
        }
    }

    private static void doModifyLabels(ModifiedLabel[] modifiedLabelArray, String string) {
        for (ModifiedLabel modifiedLabel : modifiedLabelArray) {
            Label label = modifiedLabel.getLabel();
            label.setText(string != null ? string : label.getText());
        }
    }

    private static void undoModifyLabels(ModifiedLabel[] modifiedLabelArray) {
        for (ModifiedLabel modifiedLabel : modifiedLabelArray) {
            modifiedLabel.reset();
        }
    }

    private static final class ModifiedLabel {
        private final Label label;
        private final String text;

        public ModifiedLabel(Label label) {
            this.label = label;
            this.text = label.getText();
        }

        public Label getLabel() {
            return this.label;
        }

        public void reset() {
            this.label.setText(this.text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final ModifiedLabel[] modifiedLabels;
        private final String text;

        private LabelModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, ModifiedLabel[] modifiedLabelArray, String string) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.modifiedLabels = modifiedLabelArray;
            this.text = string;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            LabelController.undoModifyLabels(this.modifiedLabels);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            LabelController.doModifyLabels(this.modifiedLabels, this.text);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(LabelController.class, "undoModifyLabelsName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelCreationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final boolean basePlanLocked;
        private final Label label;
        private final boolean newBasePlanLocked;

        private LabelCreationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, boolean bl, Label label, boolean bl2) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.basePlanLocked = bl;
            this.label = label;
            this.newBasePlanLocked = bl2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            LabelController.doDeleteLabel(this.home, this.label, this.basePlanLocked);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            LabelController.doAddLabel(this.home, this.label, this.newBasePlanLocked);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(LabelController.class, "undoCreateLabelName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        TEXT;

    }
}

