/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.CompassController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.LabelController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.RoomController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import com.eteks.sweethome3d.viewcontroller.WallController;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanController
extends FurnitureController
implements Controller {
    private static final String SCALE_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanScale";
    private static final int PIXEL_MARGIN = 3;
    private static final int PIXEL_WALL_MARGIN = 2;
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private PlanView planView;
    private SelectionListener selectionListener;
    private final ControllerState selectionState;
    private final ControllerState rectangleSelectionState;
    private final ControllerState selectionMoveState;
    private final ControllerState panningState;
    private final ControllerState dragAndDropState;
    private final ControllerState wallCreationState;
    private final ControllerState wallDrawingState;
    private final ControllerState wallResizeState;
    private final ControllerState pieceOfFurnitureRotationState;
    private final ControllerState pieceOfFurnitureElevationState;
    private final ControllerState pieceOfFurnitureHeightState;
    private final ControllerState pieceOfFurnitureResizeState;
    private final ControllerState lightPowerModificationState;
    private final ControllerState pieceOfFurnitureNameOffsetState;
    private final ControllerState cameraYawRotationState;
    private final ControllerState cameraPitchRotationState;
    private final ControllerState cameraElevationState;
    private final ControllerState dimensionLineCreationState;
    private final ControllerState dimensionLineDrawingState;
    private final ControllerState dimensionLineResizeState;
    private final ControllerState dimensionLineOffsetState;
    private final ControllerState roomCreationState;
    private final ControllerState roomDrawingState;
    private final ControllerState roomResizeState;
    private final ControllerState roomAreaOffsetState;
    private final ControllerState roomNameOffsetState;
    private final ControllerState labelCreationState;
    private final ControllerState compassRotationState;
    private final ControllerState compassResizeState;
    private ControllerState state;
    private ControllerState previousState;
    private float xLastMousePress;
    private float yLastMousePress;
    private boolean shiftDownLastMousePress;
    private boolean duplicationActivatedLastMousePress;
    private float xLastMouseMove;
    private float yLastMouseMove;
    private Area wallsAreaCache;
    private Area insideWallsAreaCache;
    private List<GeneralPath> roomPathsCache;
    private List<Selectable> draggedItems;

    public PlanController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        super(home, userPreferences, viewFactory, contentManager, undoableEditSupport);
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.selectionState = new SelectionState();
        this.selectionMoveState = new SelectionMoveState();
        this.rectangleSelectionState = new RectangleSelectionState();
        this.panningState = new PanningState();
        this.dragAndDropState = new DragAndDropState();
        this.wallCreationState = new WallCreationState();
        this.wallDrawingState = new WallDrawingState();
        this.wallResizeState = new WallResizeState();
        this.pieceOfFurnitureRotationState = new PieceOfFurnitureRotationState();
        this.pieceOfFurnitureElevationState = new PieceOfFurnitureElevationState();
        this.pieceOfFurnitureHeightState = new PieceOfFurnitureHeightState();
        this.pieceOfFurnitureResizeState = new PieceOfFurnitureResizeState();
        this.lightPowerModificationState = new LightPowerModificationState();
        this.pieceOfFurnitureNameOffsetState = new PieceOfFurnitureNameOffsetState();
        this.cameraYawRotationState = new CameraYawRotationState();
        this.cameraPitchRotationState = new CameraPitchRotationState();
        this.cameraElevationState = new CameraElevationState();
        this.dimensionLineCreationState = new DimensionLineCreationState();
        this.dimensionLineDrawingState = new DimensionLineDrawingState();
        this.dimensionLineResizeState = new DimensionLineResizeState();
        this.dimensionLineOffsetState = new DimensionLineOffsetState();
        this.roomCreationState = new RoomCreationState();
        this.roomDrawingState = new RoomDrawingState();
        this.roomResizeState = new RoomResizeState();
        this.roomAreaOffsetState = new RoomAreaOffsetState();
        this.roomNameOffsetState = new RoomNameOffsetState();
        this.labelCreationState = new LabelCreationState();
        this.compassRotationState = new CompassRotationState();
        this.compassResizeState = new CompassResizeState();
        this.setState(this.selectionState);
        this.addModelListeners();
        Float f = (Float)home.getVisualProperty(SCALE_VISUAL_PROPERTY);
        if (f != null) {
            this.setScale(f.floatValue());
        }
    }

    @Override
    public PlanView getView() {
        if (this.planView == null) {
            this.planView = this.viewFactory.createPlanView(this.home, this.preferences, this);
        }
        return this.planView;
    }

    protected void setState(ControllerState controllerState) {
        boolean bl = false;
        if (this.state != null) {
            this.state.exit();
            bl = this.state.isModificationState();
        }
        this.previousState = this.state;
        this.state = controllerState;
        if (bl != controllerState.isModificationState()) {
            this.propertyChangeSupport.firePropertyChange(Property.MODIFICATION_STATE.name(), bl, !bl);
        }
        this.state.enter();
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public Mode getMode() {
        return this.state.getMode();
    }

    public void setMode(Mode mode) {
        Mode mode2 = this.state.getMode();
        if (mode != mode2) {
            this.state.setMode(mode);
            this.propertyChangeSupport.firePropertyChange(Property.MODE.name(), mode2, mode);
        }
    }

    public boolean isModificationState() {
        return this.state.isModificationState();
    }

    @Override
    public void deleteSelection() {
        this.state.deleteSelection();
    }

    public void escape() {
        this.state.escape();
    }

    public void moveSelection(float f, float f2) {
        this.state.moveSelection(f, f2);
    }

    public void toggleMagnetism(boolean bl) {
        this.state.toggleMagnetism(bl);
    }

    public void setDuplicationActivated(boolean bl) {
        this.state.setDuplicationActivated(bl);
    }

    public void setEditionActivated(boolean bl) {
        this.state.setEditionActivated(bl);
    }

    public void updateEditableProperty(EditableProperty editableProperty, Object object) {
        this.state.updateEditableProperty(editableProperty, object);
    }

    public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
        this.xLastMousePress = f;
        this.yLastMousePress = f2;
        this.xLastMouseMove = f;
        this.yLastMouseMove = f2;
        this.shiftDownLastMousePress = bl;
        this.duplicationActivatedLastMousePress = bl2;
        this.state.pressMouse(f, f2, n, bl, bl2);
    }

    public void releaseMouse(float f, float f2) {
        this.state.releaseMouse(f, f2);
    }

    public void moveMouse(float f, float f2) {
        this.xLastMouseMove = f;
        this.yLastMouseMove = f2;
        this.state.moveMouse(f, f2);
    }

    public void zoom(float f) {
        this.state.zoom(f);
    }

    protected ControllerState getSelectionState() {
        return this.selectionState;
    }

    protected ControllerState getSelectionMoveState() {
        return this.selectionMoveState;
    }

    protected ControllerState getRectangleSelectionState() {
        return this.rectangleSelectionState;
    }

    protected ControllerState getPanningState() {
        return this.panningState;
    }

    protected ControllerState getDragAndDropState() {
        return this.dragAndDropState;
    }

    protected ControllerState getWallCreationState() {
        return this.wallCreationState;
    }

    protected ControllerState getWallDrawingState() {
        return this.wallDrawingState;
    }

    protected ControllerState getWallResizeState() {
        return this.wallResizeState;
    }

    protected ControllerState getPieceOfFurnitureRotationState() {
        return this.pieceOfFurnitureRotationState;
    }

    protected ControllerState getPieceOfFurnitureElevationState() {
        return this.pieceOfFurnitureElevationState;
    }

    protected ControllerState getPieceOfFurnitureHeightState() {
        return this.pieceOfFurnitureHeightState;
    }

    protected ControllerState getPieceOfFurnitureResizeState() {
        return this.pieceOfFurnitureResizeState;
    }

    protected ControllerState getLightPowerModificationState() {
        return this.lightPowerModificationState;
    }

    protected ControllerState getPieceOfFurnitureNameOffsetState() {
        return this.pieceOfFurnitureNameOffsetState;
    }

    protected ControllerState getCameraYawRotationState() {
        return this.cameraYawRotationState;
    }

    protected ControllerState getCameraPitchRotationState() {
        return this.cameraPitchRotationState;
    }

    protected ControllerState getCameraElevationState() {
        return this.cameraElevationState;
    }

    protected ControllerState getDimensionLineCreationState() {
        return this.dimensionLineCreationState;
    }

    protected ControllerState getDimensionLineDrawingState() {
        return this.dimensionLineDrawingState;
    }

    protected ControllerState getDimensionLineResizeState() {
        return this.dimensionLineResizeState;
    }

    protected ControllerState getDimensionLineOffsetState() {
        return this.dimensionLineOffsetState;
    }

    protected ControllerState getRoomCreationState() {
        return this.roomCreationState;
    }

    protected ControllerState getRoomDrawingState() {
        return this.roomDrawingState;
    }

    protected ControllerState getRoomResizeState() {
        return this.roomResizeState;
    }

    protected ControllerState getRoomAreaOffsetState() {
        return this.roomAreaOffsetState;
    }

    protected ControllerState getRoomNameOffsetState() {
        return this.roomNameOffsetState;
    }

    protected ControllerState getLabelCreationState() {
        return this.labelCreationState;
    }

    protected ControllerState getCompassRotationState() {
        return this.compassRotationState;
    }

    protected ControllerState getCompassResizeState() {
        return this.compassResizeState;
    }

    protected float getXLastMousePress() {
        return this.xLastMousePress;
    }

    protected float getYLastMousePress() {
        return this.yLastMousePress;
    }

    protected boolean wasShiftDownLastMousePress() {
        return this.shiftDownLastMousePress;
    }

    protected boolean wasDuplicationActivatedLastMousePress() {
        return this.duplicationActivatedLastMousePress;
    }

    protected float getXLastMouseMove() {
        return this.xLastMouseMove;
    }

    protected float getYLastMouseMove() {
        return this.yLastMouseMove;
    }

    public void modifySelectedWalls() {
        if (!Home.getWallsSubList(this.home.getSelectedItems()).isEmpty()) {
            new WallController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void lockBasePlan() {
        if (!this.home.isBasePlanLocked()) {
            List<Selectable> list = this.home.getSelectedItems();
            final Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            List<Selectable> list2 = this.getItemsNotPartOfBasePlan(list);
            final Selectable[] selectableArray2 = list2.toArray(new Selectable[list2.size()]);
            this.home.setBasePlanLocked(true);
            this.selectItems(list2);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.home.setBasePlanLocked(false);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.home.setBasePlanLocked(true);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray2));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoLockBasePlan", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    protected boolean isItemPartOfBasePlan(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return this.isPieceOfFurniturePartOfBasePlan((HomePieceOfFurniture)selectable);
        }
        return !(selectable instanceof ObserverCamera);
    }

    private List<Selectable> getItemsNotPartOfBasePlan(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        for (Selectable selectable : list) {
            if (this.isItemPartOfBasePlan(selectable)) continue;
            arrayList.add(selectable);
        }
        return arrayList;
    }

    public void unlockBasePlan() {
        if (this.home.isBasePlanLocked()) {
            List<Selectable> list = this.home.getSelectedItems();
            final Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            this.home.setBasePlanLocked(false);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.home.setBasePlanLocked(true);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.home.setBasePlanLocked(false);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoUnlockBasePlan", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    protected boolean isItemMovable(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return this.isPieceOfFurnitureMovable((HomePieceOfFurniture)selectable);
        }
        return true;
    }

    protected boolean isItemResizable(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return ((HomePieceOfFurniture)selectable).isResizable();
        }
        return true;
    }

    protected boolean isItemDeletable(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return this.isPieceOfFurnitureDeletable((HomePieceOfFurniture)selectable);
        }
        return !(selectable instanceof Compass) && !(selectable instanceof Camera);
    }

    public void reverseSelectedWallsDirection() {
        List<Wall> list = Home.getWallsSubList(this.home.getSelectedItems());
        if (!list.isEmpty()) {
            Wall[] wallArray = list.toArray(new Wall[list.size()]);
            this.doReverseWallsDirection(wallArray);
            this.postReverseSelectedWallsDirection(wallArray, this.home.getSelectedItems());
        }
    }

    private void postReverseSelectedWallsDirection(final Wall[] wallArray, List<Selectable> list) {
        final Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                PlanController.this.doReverseWallsDirection(wallArray);
                PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
            }

            public void redo() throws CannotRedoException {
                super.redo();
                PlanController.this.doReverseWallsDirection(wallArray);
                PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
            }

            public String getPresentationName() {
                return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoReverseWallsDirectionName", new Object[0]);
            }
        };
        this.undoSupport.postEdit(abstractUndoableEdit);
    }

    private void doReverseWallsDirection(Wall[] wallArray) {
        for (Wall wall : wallArray) {
            Wall wall2;
            float f = wall.getXStart();
            float f2 = wall.getYStart();
            float f3 = wall.getXEnd();
            float f4 = wall.getYEnd();
            wall.setXStart(f3);
            wall.setYStart(f4);
            wall.setXEnd(f);
            wall.setYEnd(f2);
            if (wall.getArcExtent() != null) {
                wall.setArcExtent(Float.valueOf(-wall.getArcExtent().floatValue()));
            }
            boolean bl = (wall2 = wall.getWallAtStart()) != null && wall2.getWallAtEnd() == wall;
            boolean bl2 = wall2 != null && wall2.getWallAtStart() == wall;
            Wall wall3 = wall.getWallAtEnd();
            boolean bl3 = wall3 != null && wall3.getWallAtEnd() == wall;
            boolean bl4 = wall3 != null && wall3.getWallAtStart() == wall;
            wall.setWallAtStart(wall3);
            wall.setWallAtEnd(wall2);
            if (bl) {
                wall2.setWallAtEnd(wall);
            } else if (bl2) {
                wall2.setWallAtStart(wall);
            }
            if (bl3) {
                wall3.setWallAtEnd(wall);
            } else if (bl4) {
                wall3.setWallAtStart(wall);
            }
            Integer n = wall.getRightSideColor();
            HomeTexture homeTexture = wall.getRightSideTexture();
            float f5 = wall.getLeftSideShininess();
            Integer n2 = wall.getLeftSideColor();
            HomeTexture homeTexture2 = wall.getLeftSideTexture();
            float f6 = wall.getRightSideShininess();
            wall.setLeftSideColor(n);
            wall.setLeftSideTexture(homeTexture);
            wall.setLeftSideShininess(f6);
            wall.setRightSideColor(n2);
            wall.setRightSideTexture(homeTexture2);
            wall.setRightSideShininess(f5);
            Float f7 = wall.getHeightAtEnd();
            if (f7 == null) continue;
            Float f8 = wall.getHeight();
            wall.setHeight(f7);
            wall.setHeightAtEnd(f8);
        }
    }

    public void splitSelectedWall() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Wall> list2 = Home.getWallsSubList(list);
        if (list2.size() == 1) {
            boolean bl = this.home.isBasePlanLocked();
            Wall wall = list2.get(0);
            JoinedWall joinedWall = new JoinedWall(wall);
            float f = wall.getXStart();
            float f2 = wall.getYStart();
            float f3 = wall.getXEnd();
            float f4 = wall.getYEnd();
            float f5 = (f + f3) / 2.0f;
            float f6 = (f2 + f4) / 2.0f;
            Wall wall2 = wall.getWallAtStart();
            boolean bl2 = wall2 != null && wall2.getWallAtEnd() == wall;
            boolean bl3 = wall2 != null && wall2.getWallAtStart() == wall;
            Wall wall3 = wall.getWallAtEnd();
            boolean bl4 = wall3 != null && wall3.getWallAtEnd() == wall;
            boolean bl5 = wall3 != null && wall3.getWallAtStart() == wall;
            Wall wall4 = wall.clone();
            this.home.addWall(wall4);
            Wall wall5 = wall.clone();
            this.home.addWall(wall5);
            wall4.setXEnd(f5);
            wall4.setYEnd(f6);
            wall5.setXStart(f5);
            wall5.setYStart(f6);
            if (wall.getHeightAtEnd() != null) {
                Float f7 = Float.valueOf((wall.getHeight().floatValue() + wall.getHeightAtEnd().floatValue()) / 2.0f);
                wall4.setHeightAtEnd(f7);
                wall5.setHeight(f7);
            }
            wall4.setWallAtEnd(wall5);
            wall5.setWallAtStart(wall4);
            wall4.setWallAtStart(wall2);
            if (bl2) {
                wall2.setWallAtEnd(wall4);
            } else if (bl3) {
                wall2.setWallAtStart(wall4);
            }
            wall5.setWallAtEnd(wall3);
            if (bl4) {
                wall3.setWallAtEnd(wall5);
            } else if (bl5) {
                wall3.setWallAtStart(wall5);
            }
            this.home.deleteWall(wall);
            this.selectAndShowItems(Arrays.asList(wall4));
            this.postSplitSelectedWall(joinedWall, new JoinedWall(wall4), new JoinedWall(wall5), list, bl);
        }
    }

    private void postSplitSelectedWall(final JoinedWall joinedWall, final JoinedWall joinedWall2, final JoinedWall joinedWall3, List<Selectable> list, final boolean bl) {
        final Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
        final boolean bl2 = this.home.isBasePlanLocked();
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                PlanController.this.doDeleteWalls(new JoinedWall[]{joinedWall2, joinedWall3}, bl);
                PlanController.this.doAddWalls(new JoinedWall[]{joinedWall}, bl);
                PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
            }

            public void redo() throws CannotRedoException {
                super.redo();
                PlanController.this.doDeleteWalls(new JoinedWall[]{joinedWall}, bl2);
                PlanController.this.doAddWalls(new JoinedWall[]{joinedWall2, joinedWall3}, bl2);
                PlanController.this.selectAndShowItems(Arrays.asList(joinedWall2.getWall()));
            }

            public String getPresentationName() {
                return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoSplitWallName", new Object[0]);
            }
        };
        this.undoSupport.postEdit(abstractUndoableEdit);
    }

    public void modifySelectedRooms() {
        if (!Home.getRoomsSubList(this.home.getSelectedItems()).isEmpty()) {
            new RoomController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    private void createLabel(float f, float f2) {
        new LabelController(this.home, f, f2, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
    }

    public void modifySelectedLabels() {
        if (!Home.getLabelsSubList(this.home.getSelectedItems()).isEmpty()) {
            new LabelController(this.home, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
        }
    }

    public void modifyCompass() {
        new CompassController(this.home, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
    }

    public void toggleBoldStyle() {
        Serializable serializable;
        Boolean bl = null;
        for (Selectable cloneable2 : this.home.getSelectedItems()) {
            if (cloneable2 instanceof Label) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((Label)cloneable2).getStyle()).isBold());
            } else if (cloneable2 instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)cloneable2).isVisible()) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((HomePieceOfFurniture)cloneable2).getNameStyle()).isBold());
            } else if (cloneable2 instanceof Room) {
                Room room = (Room)cloneable2;
                serializable = Boolean.valueOf(this.getItemTextStyle(room, room.getNameStyle()).isBold());
                if (((Boolean)serializable).booleanValue() != this.getItemTextStyle(room, room.getAreaStyle()).isBold()) {
                    serializable = null;
                }
            } else {
                if (!(cloneable2 instanceof DimensionLine)) continue;
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((DimensionLine)cloneable2).getLengthStyle()).isBold());
            }
            if (bl == null) {
                bl = serializable;
                continue;
            }
            if (serializable != null && bl.equals(serializable)) continue;
            bl = null;
            break;
        }
        bl = bl == null ? Boolean.TRUE : Boolean.valueOf(bl == false);
        ArrayList arrayList = new ArrayList();
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        serializable = new ArrayList();
        for (Selectable selectable : this.home.getSelectedItems()) {
            TextStyle textStyle;
            Selectable selectable2;
            if (selectable instanceof Label) {
                selectable2 = (Label)selectable;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((Label)selectable2).getStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveBoldStyle(bl));
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                selectable2 = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)selectable2).isVisible()) continue;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((HomePieceOfFurniture)selectable2).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveBoldStyle(bl));
                continue;
            }
            if (selectable instanceof Room) {
                selectable2 = (Room)selectable;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((Room)selectable2).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveBoldStyle(bl));
                TextStyle textStyle2 = this.getItemTextStyle(selectable2, ((Room)selectable2).getAreaStyle());
                arrayList2.add(textStyle2);
                serializable.add(textStyle2.deriveBoldStyle(bl));
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            selectable2 = (DimensionLine)selectable;
            arrayList.add(selectable2);
            textStyle = this.getItemTextStyle(selectable2, ((DimensionLine)selectable2).getLengthStyle());
            arrayList2.add(textStyle);
            serializable.add(textStyle.deriveBoldStyle(bl));
        }
        this.modifyTextStyle(arrayList.toArray(new Selectable[arrayList.size()]), arrayList2.toArray(new TextStyle[arrayList2.size()]), serializable.toArray(new TextStyle[serializable.size()]));
    }

    private TextStyle getItemTextStyle(Selectable selectable, TextStyle textStyle) {
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(selectable.getClass());
        }
        return textStyle;
    }

    public void toggleItalicStyle() {
        Serializable serializable;
        Boolean bl = null;
        for (Selectable cloneable2 : this.home.getSelectedItems()) {
            if (cloneable2 instanceof Label) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((Label)cloneable2).getStyle()).isItalic());
            } else if (cloneable2 instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)cloneable2).isVisible()) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((HomePieceOfFurniture)cloneable2).getNameStyle()).isItalic());
            } else if (cloneable2 instanceof Room) {
                Room room = (Room)cloneable2;
                serializable = Boolean.valueOf(this.getItemTextStyle(room, room.getNameStyle()).isItalic());
                if (((Boolean)serializable).booleanValue() != this.getItemTextStyle(room, room.getAreaStyle()).isItalic()) {
                    serializable = null;
                }
            } else {
                if (!(cloneable2 instanceof DimensionLine)) continue;
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((DimensionLine)cloneable2).getLengthStyle()).isItalic());
            }
            if (bl == null) {
                bl = serializable;
                continue;
            }
            if (serializable != null && bl.equals(serializable)) continue;
            bl = null;
            break;
        }
        bl = bl == null ? Boolean.TRUE : Boolean.valueOf(bl == false);
        ArrayList arrayList = new ArrayList();
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        serializable = new ArrayList();
        for (Selectable selectable : this.home.getSelectedItems()) {
            TextStyle textStyle;
            Selectable selectable2;
            if (selectable instanceof Label) {
                selectable2 = (Label)selectable;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((Label)selectable2).getStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveItalicStyle(bl));
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                selectable2 = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)selectable2).isVisible()) continue;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((HomePieceOfFurniture)selectable2).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveItalicStyle(bl));
                continue;
            }
            if (selectable instanceof Room) {
                selectable2 = (Room)selectable;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((Room)selectable2).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveItalicStyle(bl));
                TextStyle textStyle2 = this.getItemTextStyle(selectable2, ((Room)selectable2).getAreaStyle());
                arrayList2.add(textStyle2);
                serializable.add(textStyle2.deriveItalicStyle(bl));
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            selectable2 = (DimensionLine)selectable;
            arrayList.add(selectable2);
            textStyle = this.getItemTextStyle(selectable2, ((DimensionLine)selectable2).getLengthStyle());
            arrayList2.add(textStyle);
            serializable.add(textStyle.deriveItalicStyle(bl));
        }
        this.modifyTextStyle(arrayList.toArray(new Selectable[arrayList.size()]), arrayList2.toArray(new TextStyle[arrayList2.size()]), serializable.toArray(new TextStyle[serializable.size()]));
    }

    public void increaseTextSize() {
        this.applyFactorToTextSize(1.1f);
    }

    public void decreaseTextSize() {
        this.applyFactorToTextSize(0.9090909f);
    }

    private void applyFactorToTextSize(float f) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        ArrayList<TextStyle> arrayList3 = new ArrayList<TextStyle>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            TextStyle textStyle;
            Selectable selectable2;
            if (selectable instanceof Label) {
                selectable2 = (Label)selectable;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable, ((Label)selectable2).getStyle());
                arrayList2.add(textStyle);
                arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                selectable2 = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)selectable2).isVisible()) continue;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((HomePieceOfFurniture)selectable2).getNameStyle());
                arrayList2.add(textStyle);
                arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
                continue;
            }
            if (selectable instanceof Room) {
                selectable2 = (Room)selectable;
                arrayList.add(selectable2);
                textStyle = this.getItemTextStyle(selectable2, ((Room)selectable2).getNameStyle());
                arrayList2.add(textStyle);
                arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
                TextStyle textStyle2 = this.getItemTextStyle(selectable2, ((Room)selectable2).getAreaStyle());
                arrayList2.add(textStyle2);
                arrayList3.add(textStyle2.deriveStyle(Math.round(textStyle2.getFontSize() * f)));
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            selectable2 = (DimensionLine)selectable;
            arrayList.add(selectable2);
            textStyle = this.getItemTextStyle(selectable2, ((DimensionLine)selectable2).getLengthStyle());
            arrayList2.add(textStyle);
            arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
        }
        this.modifyTextStyle(arrayList.toArray(new Selectable[arrayList.size()]), arrayList2.toArray(new TextStyle[arrayList2.size()]), arrayList3.toArray(new TextStyle[arrayList3.size()]));
    }

    private void modifyTextStyle(final Selectable[] selectableArray, final TextStyle[] textStyleArray, final TextStyle[] textStyleArray2) {
        List<Selectable> list = this.home.getSelectedItems();
        final Selectable[] selectableArray2 = list.toArray(new Selectable[list.size()]);
        this.doModifyTextStyle(selectableArray, textStyleArray2);
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                PlanController.this.doModifyTextStyle(selectableArray, textStyleArray);
                PlanController.this.selectAndShowItems(Arrays.asList(selectableArray2));
            }

            public void redo() throws CannotRedoException {
                super.redo();
                PlanController.this.doModifyTextStyle(selectableArray, textStyleArray2);
                PlanController.this.selectAndShowItems(Arrays.asList(selectableArray2));
            }

            public String getPresentationName() {
                return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoModifyTextStyleName", new Object[0]);
            }
        };
        this.undoSupport.postEdit(abstractUndoableEdit);
    }

    private void doModifyTextStyle(Selectable[] selectableArray, TextStyle[] textStyleArray) {
        int n = 0;
        for (Selectable selectable : selectableArray) {
            Selectable selectable2;
            if (selectable instanceof Label) {
                ((Label)selectable).setStyle(textStyleArray[n++]);
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                selectable2 = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)selectable2).isVisible()) continue;
                ((HomePieceOfFurniture)selectable2).setNameStyle(textStyleArray[n++]);
                continue;
            }
            if (selectable instanceof Room) {
                selectable2 = (Room)selectable;
                ((Room)selectable2).setNameStyle(textStyleArray[n++]);
                ((Room)selectable2).setAreaStyle(textStyleArray[n++]);
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            ((DimensionLine)selectable).setLengthStyle(textStyleArray[n++]);
        }
    }

    public float getMinimumScale() {
        return 0.05f;
    }

    public float getMaximumScale() {
        return 5.0f;
    }

    public float getScale() {
        return this.getView().getScale();
    }

    public void setScale(float f) {
        f = Math.max(this.getMinimumScale(), Math.min(f, this.getMaximumScale()));
        if (f != this.getView().getScale()) {
            float f2 = this.getView().getScale();
            if (this.getView() != null) {
                int n = this.getView().convertXModelToScreen(this.getXLastMouseMove());
                int n2 = this.getView().convertXModelToScreen(this.getYLastMouseMove());
                this.getView().setScale(f);
                this.moveMouse(this.getView().convertXPixelToModel(n), this.getView().convertYPixelToModel(n2));
            }
            this.propertyChangeSupport.firePropertyChange(Property.SCALE.name(), Float.valueOf(f2), Float.valueOf(f));
            this.home.setVisualProperty(SCALE_VISUAL_PROPERTY, Float.valueOf(f));
        }
    }

    @Override
    public void selectAll() {
        ArrayList<Wall> arrayList = new ArrayList<Wall>(this.home.getWalls());
        arrayList.addAll(this.home.getRooms());
        arrayList.addAll(this.home.getDimensionLines());
        arrayList.addAll(this.home.getLabels());
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            if (!homePieceOfFurniture.isVisible()) continue;
            arrayList.add((Wall)((Object)homePieceOfFurniture));
        }
        if (this.home.getCompass().isVisible()) {
            arrayList.add((Wall)((Object)this.home.getCompass()));
        }
        if (this.home.isBasePlanLocked()) {
            this.home.setSelectedItems(this.getItemsNotPartOfBasePlan(arrayList));
        } else {
            this.home.setSelectedItems(arrayList);
        }
    }

    public View getHorizontalRulerView() {
        return this.getView().getHorizontalRuler();
    }

    public View getVerticalRulerView() {
        return this.getView().getVerticalRuler();
    }

    private void addModelListeners() {
        this.selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                if (PlanController.this.getView() != null) {
                    PlanController.this.getView().makeSelectionVisible();
                }
            }
        };
        this.home.addSelectionListener(this.selectionListener);
        this.home.getObserverCamera().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PlanController.this.home.getSelectedItems().contains(propertyChangeEvent.getSource()) && PlanController.this.getView() != null) {
                    PlanController.this.getView().makeSelectionVisible();
                }
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Wall.Property.X_START.name().equals(string) || Wall.Property.X_END.name().equals(string) || Wall.Property.Y_START.name().equals(string) || Wall.Property.Y_END.name().equals(string) || Wall.Property.WALL_AT_START.name().equals(string) || Wall.Property.WALL_AT_END.name().equals(string) || Wall.Property.THICKNESS.name().equals(string)) {
                    PlanController.this.wallsAreaCache = null;
                    PlanController.this.insideWallsAreaCache = null;
                    PlanController.this.roomPathsCache = null;
                }
            }
        };
        for (Wall wall : this.home.getWalls()) {
            wall.addPropertyChangeListener(propertyChangeListener);
        }
        this.home.addWallsListener(new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                }
                PlanController.this.wallsAreaCache = null;
                PlanController.this.insideWallsAreaCache = null;
                PlanController.this.roomPathsCache = null;
            }
        });
    }

    public void startDraggedItems(List<Selectable> list, float f, float f2) {
        this.draggedItems = list;
        if (this.preferences.isMagnetismEnabled()) {
            for (HomePieceOfFurniture homePieceOfFurniture : Home.getFurnitureSubList(list)) {
                if (homePieceOfFurniture.isResizable()) {
                    homePieceOfFurniture.setWidth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getWidth(), 0.1f));
                    homePieceOfFurniture.setDepth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getDepth(), 0.1f));
                    homePieceOfFurniture.setHeight(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getHeight(), 0.1f));
                }
                homePieceOfFurniture.setElevation(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getElevation(), 0.1f));
            }
        }
        this.setState(this.getDragAndDropState());
        this.moveMouse(f, f2);
    }

    public void stopDraggedItems() {
        if (this.state != this.getDragAndDropState()) {
            throw new IllegalStateException("Controller isn't in a drag and drop state");
        }
        this.draggedItems = null;
        this.setState(this.previousState);
    }

    protected void adjustMagnetizedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, float f, float f2) {
        this.adjustPieceOfFurnitureOnWallAt(homePieceOfFurniture, f, f2);
        this.adjustPieceOfFurnitureElevationAt(homePieceOfFurniture);
    }

    private Wall adjustPieceOfFurnitureOnWallAt(HomePieceOfFurniture homePieceOfFurniture, float f, float f2) {
        Wall object = null;
        for (Wall object2 : this.home.getWalls()) {
            if (object2.getArcExtent() != null || !object2.containsPoint(f, f2, 0.0f) || !(object2.getStartPointToEndPointDistance() > 0.0f)) continue;
            object = object2;
            break;
        }
        if (object == null) {
            float f3 = 3.0f / this.getScale();
            for (Wall bl : this.home.getWalls()) {
                if (bl.getArcExtent() != null || !bl.containsPoint(f, f2, f3) || !(bl.getStartPointToEndPointDistance() > 0.0f)) continue;
                object = bl;
                break;
            }
        }
        if (object != null) {
            double d;
            double d2;
            double d3;
            double d4 = Math.atan2(object.getYEnd() - object.getYStart(), object.getXEnd() - object.getXStart());
            boolean bl = d4 > -1.5707963267948966 && d4 <= 1.5707963267948966;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            float[][] fArray = object.getPoints();
            double d7 = Line2D.ptLineDist(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], f, f2);
            double d8 = Line2D.ptLineDist(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1], f, f2);
            float[][] fArray2 = homePieceOfFurniture.getPoints();
            float f3 = homePieceOfFurniture.getAngle();
            double d9 = Line2D.ptLineDist(fArray2[0][0], fArray2[0][1], fArray2[3][0], fArray2[3][1], f, f2);
            double d10 = Line2D.ptLineDist(fArray2[1][0], fArray2[1][1], fArray2[2][0], fArray2[2][1], f, f2);
            double d11 = (double)f3 > 4.71238998038469 || (double)f3 < 1.5707973267948965 ? d9 : d10;
            float f4 = homePieceOfFurniture.getWidth() / 2.0f;
            if (homePieceOfFurniture.isDoorOrWindow()) {
                float f8 = 1.0E-4f;
                if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                    HomeDoorOrWindow f7 = (HomeDoorOrWindow)homePieceOfFurniture;
                    if (homePieceOfFurniture.isResizable() && this.isItemResizable(homePieceOfFurniture)) {
                        homePieceOfFurniture.setDepth(2.0E-4f + object.getThickness() / f7.getWallThickness());
                    }
                    f8 += homePieceOfFurniture.getDepth() * f7.getWallDistance();
                }
                float n = homePieceOfFurniture.getDepth() / 2.0f;
                if (d8 < d7) {
                    d3 = d4;
                    d2 = (double)f + d6 * (d7 + (double)f8);
                    d = (double)f2 - d5 * (d7 + (double)f8);
                    if (bl) {
                        d2 += d5 * ((double)f4 - d11) - d6 * (double)n;
                        d += d6 * ((double)f4 - d11) + d5 * (double)n;
                    } else {
                        d2 += -d5 * ((double)f4 - d11) - d6 * (double)n;
                        d += -d6 * ((double)f4 - d11) + d5 * (double)n;
                    }
                } else {
                    d3 = d4 + Math.PI;
                    d2 = (double)f - d6 * (d8 + (double)f8);
                    d = (double)f2 + d5 * (d8 + (double)f8);
                    if (bl) {
                        d2 += d5 * ((double)f4 - d11) + d6 * (double)n;
                        d += d6 * ((double)f4 - d11) - d5 * (double)n;
                    } else {
                        d2 += -d5 * ((double)f4 - d11) + d6 * (double)n;
                        d += -d6 * ((double)f4 - d11) - d5 * (double)n;
                    }
                }
            } else {
                float f5 = homePieceOfFurniture.getDepth() / 2.0f;
                if (d8 < d7) {
                    d3 = d4;
                    int n = Line2D.relativeCCW(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1], f, f2);
                    d2 = (double)f + (double)n * d6 * d8;
                    d = (double)f2 - (double)n * d5 * d8;
                    if (bl) {
                        d2 += d5 * ((double)f4 - d11) - d6 * (double)f5;
                        d += d6 * ((double)f4 - d11) + d5 * (double)f5;
                    } else {
                        d2 += -d5 * ((double)f4 - d11) - d6 * (double)f5;
                        d += -d6 * ((double)f4 - d11) + d5 * (double)f5;
                    }
                } else {
                    d3 = d4 + Math.PI;
                    int n = Line2D.relativeCCW(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], f, f2);
                    d2 = (double)f - (double)n * d6 * d7;
                    d = (double)f2 + (double)n * d5 * d7;
                    if (bl) {
                        d2 += d5 * ((double)f4 - d11) + d6 * (double)f5;
                        d += d6 * ((double)f4 - d11) - d5 * (double)f5;
                    } else {
                        d2 += -d5 * ((double)f4 - d11) + d6 * (double)f5;
                        d += -d6 * ((double)f4 - d11) - d5 * (double)f5;
                    }
                }
            }
            homePieceOfFurniture.setAngle((float)d3);
            homePieceOfFurniture.setX((float)d2);
            homePieceOfFurniture.setY((float)d);
            if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(true);
            }
        }
        return object;
    }

    private List<DimensionLine> getDimensionLinesAlongWall(HomePieceOfFurniture homePieceOfFurniture, Wall wall) {
        boolean bl;
        float[] fArray;
        float[] fArray2;
        float[][] fArray3 = homePieceOfFurniture.getPoints();
        float[] fArray4 = homePieceOfFurniture.isDoorOrWindow() ? fArray3[3] : fArray3[0];
        float[][] fArray5 = wall.getPoints();
        if (Line2D.ptLineDistSq(fArray5[0][0], fArray5[0][1], fArray5[1][0], fArray5[1][1], fArray4[0], fArray4[1]) <= Line2D.ptLineDistSq(fArray5[2][0], fArray5[2][1], fArray5[3][0], fArray5[3][1], fArray4[0], fArray4[1])) {
            fArray2 = this.computeIntersection(fArray5[0], fArray5[1], fArray3[0], fArray3[3]);
            fArray = this.computeIntersection(fArray5[0], fArray5[1], fArray3[1], fArray3[2]);
        } else {
            fArray2 = this.computeIntersection(fArray5[2], fArray5[3], fArray3[0], fArray3[3]);
            fArray = this.computeIntersection(fArray5[2], fArray5[3], fArray3[1], fArray3[2]);
        }
        ArrayList<DimensionLine> arrayList = new ArrayList<DimensionLine>();
        float[] fArray6 = null;
        float[] fArray7 = null;
        List<GeneralPath> list = this.getRoomPathsFromWalls();
        block0: for (int i = 0; i < list.size() && fArray6 == null && fArray7 == null; ++i) {
            float[][] fArray8 = this.getPathPoints(list.get(i), true);
            for (int j = 0; j < fArray8.length; ++j) {
                double d;
                double d2;
                boolean bl2;
                float[] fArray9 = fArray8[j];
                float[] fArray10 = fArray8[(j + 1) % fArray8.length];
                boolean bl3 = Line2D.ptSegDistSq(fArray9[0], fArray9[1], fArray10[0], fArray10[1], fArray2[0], fArray2[1]) < 1.0E-4;
                boolean bl4 = bl2 = Line2D.ptSegDistSq(fArray9[0], fArray9[1], fArray10[0], fArray10[1], fArray[0], fArray[1]) < 1.0E-4;
                if (!bl3 && !bl2) continue;
                if (bl3) {
                    d2 = Point2D.distanceSq(fArray9[0], fArray9[1], fArray2[0], fArray2[1]);
                    fArray6 = d2 < (d = Point2D.distanceSq(fArray9[0], fArray9[1], fArray[0], fArray[1])) || !bl2 ? (float[])fArray9.clone() : (float[])fArray10.clone();
                }
                if (!bl2) continue block0;
                d2 = Point2D.distanceSq(fArray10[0], fArray10[1], fArray2[0], fArray2[1]);
                if (d2 < (d = Point2D.distanceSq(fArray10[0], fArray10[1], fArray[0], fArray[1])) && bl3) {
                    fArray7 = (float[])fArray9.clone();
                    continue block0;
                }
                fArray7 = (float[])fArray10.clone();
                continue block0;
            }
        }
        float f = homePieceOfFurniture.getAngle();
        boolean bl5 = bl = (double)f > 1.5707963267948966 && (double)f <= 4.71238898038469;
        if (fArray6 != null) {
            float f2 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray3[3][0], fArray3[3][1]) + 10.0f / this.getView().getScale();
            if (bl) {
                arrayList.add(new DimensionLine(fArray2[0], fArray2[1], (float)fArray6[0], (float)fArray6[1], -f2));
            } else {
                arrayList.add(new DimensionLine((float)fArray6[0], (float)fArray6[1], fArray2[0], fArray2[1], f2));
            }
        }
        if (fArray7 != null) {
            float f3 = (float)Point2D.distance(fArray[0], fArray[1], fArray3[2][0], fArray3[2][1]) + 10.0f / this.getView().getScale();
            if (bl) {
                arrayList.add(new DimensionLine((float)fArray7[0], (float)fArray7[1], fArray[0], fArray[1], -f3));
            } else {
                arrayList.add(new DimensionLine(fArray[0], fArray[1], (float)fArray7[0], (float)fArray7[1], f3));
            }
        }
        return arrayList;
    }

    private float[] computeIntersection(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = (fArray2[1] - fArray[1]) / (fArray2[0] - fArray[0]);
        float f4 = (fArray4[1] - fArray3[1]) / (fArray4[0] - fArray3[0]);
        if (f3 != f4) {
            if ((double)Math.abs(f3) > 100000.0) {
                if ((double)Math.abs(f4) < 100000.0) {
                    f = fArray[0];
                    float f5 = fArray4[1] - f4 * fArray4[0];
                    f2 = f4 * f + f5;
                }
            } else if ((double)Math.abs(f4) > 100000.0) {
                if ((double)Math.abs(f3) < 100000.0) {
                    f = fArray3[0];
                    float f6 = fArray2[1] - f3 * fArray2[0];
                    f2 = f3 * f + f6;
                }
            } else {
                boolean bl;
                boolean bl2 = bl = Math.signum(f3) == Math.signum(f4);
                if (bl && (double)(Math.abs(f3) > Math.abs(f4) ? f3 / f4 : f4 / f3) > 1.0001 || !bl && (double)Math.abs(f3 - f4) > 1.0E-5) {
                    float f7 = fArray2[1] - f3 * fArray2[0];
                    float f8 = fArray4[1] - f4 * fArray4[0];
                    f = (f8 - f7) / (f3 - f4);
                    f2 = f3 * f + f7;
                }
            }
        }
        return new float[]{f, f2};
    }

    private HomePieceOfFurniture adjustPieceOfFurnitureElevationAt(HomePieceOfFurniture homePieceOfFurniture) {
        if (!homePieceOfFurniture.isDoorOrWindow() && homePieceOfFurniture.getElevation() == 0.0f) {
            float[][] fArray = homePieceOfFurniture.getPoints();
            HomePieceOfFurniture homePieceOfFurniture2 = null;
            float f = Float.MIN_VALUE;
            for (HomePieceOfFurniture homePieceOfFurniture3 : this.home.getFurniture()) {
                float f2;
                if (homePieceOfFurniture3 == homePieceOfFurniture || homePieceOfFurniture3.isDoorOrWindow() || !homePieceOfFurniture3.isVisible()) continue;
                GeneralPath generalPath = this.getPath(homePieceOfFurniture3.getPoints());
                boolean bl = true;
                for (float[] fArray2 : fArray) {
                    if (generalPath.contains(fArray2[0], fArray2[1])) continue;
                    bl = false;
                    break;
                }
                if (!bl || !((f2 = homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeight()) > f)) continue;
                f = f2;
                homePieceOfFurniture2 = homePieceOfFurniture3;
            }
            if (homePieceOfFurniture2 != null) {
                homePieceOfFurniture.setElevation(f);
                return homePieceOfFurniture2;
            }
        }
        return null;
    }

    private DimensionLine getMeasuringDimensionLineAt(float f, float f2, boolean bl) {
        DimensionLine dimensionLine;
        for (HomePieceOfFurniture cloneable : this.home.getFurniture()) {
            dimensionLine = this.getDimensionLineBetweenPointsAt(cloneable.getPoints(), f, f2, bl);
            if (dimensionLine == null) continue;
            return dimensionLine;
        }
        for (GeneralPath generalPath : this.getRoomPathsFromWalls()) {
            if (!generalPath.intersects(f - 3.0f, f2 - 3.0f, 6.0, 6.0) || (dimensionLine = this.getDimensionLineBetweenPointsAt(this.getPathPoints(generalPath, true), f, f2, bl)) == null) continue;
            return dimensionLine;
        }
        for (Room room : this.home.getRooms()) {
            dimensionLine = this.getDimensionLineBetweenPointsAt(room.getPoints(), f, f2, bl);
            if (dimensionLine == null) continue;
            return dimensionLine;
        }
        return null;
    }

    private DimensionLine getDimensionLineBetweenPointsAt(float[][] fArray, float f, float f2, boolean bl) {
        for (int i = 0; i < fArray.length; ++i) {
            float f3;
            float f4;
            float f5;
            float f6;
            boolean bl2;
            int n = (i + 1) % fArray.length;
            double d = Point2D.distanceSq(fArray[i][0], fArray[i][1], fArray[n][0], fArray[n][1]);
            if (!(d > 0.01) || !(Line2D.ptSegDistSq(fArray[i][0], fArray[i][1], fArray[n][0], fArray[n][1], f, f2) <= 9.0)) continue;
            double d2 = Math.atan2(fArray[i][1] - fArray[n][1], fArray[n][0] - fArray[i][0]);
            boolean bl3 = bl2 = d2 < -1.5707963267948966 || d2 > 1.5707963267948966;
            if (bl2) {
                f6 = fArray[n][0];
                f5 = fArray[n][1];
                f4 = fArray[i][0];
                f3 = fArray[i][1];
            } else {
                f6 = fArray[i][0];
                f5 = fArray[i][1];
                f4 = fArray[n][0];
                f3 = fArray[n][1];
            }
            if (bl) {
                float f7 = this.preferences.getLengthUnit().getMagnetizedLength((float)Math.sqrt(d), this.getView().getPixelLength());
                if (bl2) {
                    f4 = fArray[n][0] - (float)((double)f7 * Math.cos(d2));
                    f3 = fArray[n][1] + (float)((double)f7 * Math.sin(d2));
                } else {
                    f4 = fArray[i][0] + (float)((double)f7 * Math.cos(d2));
                    f3 = fArray[i][1] - (float)((double)f7 * Math.sin(d2));
                }
            }
            return new DimensionLine(f6, f5, f4, f3, 0.0f);
        }
        return null;
    }

    protected Wall createWall(float f, float f2, float f3, float f4, Wall wall, Wall wall2) {
        Wall wall3 = new Wall(f, f2, f3, f4, this.preferences.getNewWallThickness(), this.preferences.getNewWallHeight());
        this.home.addWall(wall3);
        if (wall != null) {
            wall3.setWallAtStart(wall);
            wall.setWallAtStart(wall3);
        } else if (wall2 != null) {
            wall3.setWallAtStart(wall2);
            wall2.setWallAtEnd(wall3);
        }
        return wall3;
    }

    private void joinNewWallEndToWall(Wall wall, Wall wall2, Wall wall3) {
        if (wall2 != null) {
            wall.setWallAtEnd(wall2);
            wall2.setWallAtStart(wall);
            wall.setXEnd(wall2.getXStart());
            wall.setYEnd(wall2.getYStart());
        } else if (wall3 != null) {
            wall.setWallAtEnd(wall3);
            wall3.setWallAtEnd(wall);
            wall.setXEnd(wall3.getXEnd());
            wall.setYEnd(wall3.getYEnd());
        }
    }

    private Wall getWallStartAt(float f, float f2, Wall wall) {
        float f3 = 2.0f / this.getScale();
        for (Wall wall2 : this.home.getWalls()) {
            if (wall2 == wall || wall2.getWallAtStart() != null || !wall2.containsWallStartAt(f, f2, f3)) continue;
            return wall2;
        }
        return null;
    }

    private Wall getWallEndAt(float f, float f2, Wall wall) {
        float f3 = 2.0f / this.getScale();
        for (Wall wall2 : this.home.getWalls()) {
            if (wall2 == wall || wall2.getWallAtEnd() != null || !wall2.containsWallEndAt(f, f2, f3)) continue;
            return wall2;
        }
        return null;
    }

    private Wall getResizedWallStartAt(float f, float f2) {
        float f3;
        Wall wall;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Wall && this.isItemResizable(list.get(0)) && (wall = (Wall)list.get(0)).containsWallStartAt(f, f2, f3 = 3.0f / this.getScale())) {
            return wall;
        }
        return null;
    }

    private Wall getResizedWallEndAt(float f, float f2) {
        float f3;
        Wall wall;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Wall && this.isItemResizable(list.get(0)) && (wall = (Wall)list.get(0)).containsWallEndAt(f, f2, f3 = 3.0f / this.getScale())) {
            return wall;
        }
        return null;
    }

    protected Room createRoom(float[][] fArray) {
        Room room = new Room(fArray);
        this.home.addRoom(room);
        return room;
    }

    private Room getResizedRoomAt(float f, float f2) {
        float f3;
        Room room;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && (room = (Room)list.get(0)).getPointIndexAt(f, f2, f3 = 3.0f / this.getScale()) != -1) {
            return room;
        }
        return null;
    }

    private Room getRoomNameAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemMovable(list.get(0))) {
            Room room = (Room)list.get(0);
            float f3 = 3.0f / this.getScale();
            if (room.getName() != null && room.getName().trim().length() > 0 && room.isNameCenterPointAt(f, f2, f3)) {
                return room;
            }
        }
        return null;
    }

    private Room getRoomAreaAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemMovable(list.get(0))) {
            Room room = (Room)list.get(0);
            float f3 = 3.0f / this.getScale();
            if (room.isAreaVisible() && room.isAreaCenterPointAt(f, f2, f3)) {
                return room;
            }
        }
        return null;
    }

    protected DimensionLine createDimensionLine(float f, float f2, float f3, float f4, float f5) {
        DimensionLine dimensionLine = new DimensionLine(f, f2, f3, f4, f5);
        this.home.addDimensionLine(dimensionLine);
        return dimensionLine;
    }

    private DimensionLine getResizedDimensionLineStartAt(float f, float f2) {
        float f3;
        DimensionLine dimensionLine;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && this.isItemResizable(list.get(0)) && (dimensionLine = (DimensionLine)list.get(0)).containsStartExtensionLinetAt(f, f2, f3 = 3.0f / this.getScale())) {
            return dimensionLine;
        }
        return null;
    }

    private DimensionLine getResizedDimensionLineEndAt(float f, float f2) {
        float f3;
        DimensionLine dimensionLine;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && this.isItemResizable(list.get(0)) && (dimensionLine = (DimensionLine)list.get(0)).containsEndExtensionLineAt(f, f2, f3 = 3.0f / this.getScale())) {
            return dimensionLine;
        }
        return null;
    }

    private DimensionLine getOffsetDimensionLineAt(float f, float f2) {
        float f3;
        DimensionLine dimensionLine;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && this.isItemResizable(list.get(0)) && (dimensionLine = (DimensionLine)list.get(0)).isMiddlePointAt(f, f2, f3 = 3.0f / this.getScale())) {
            return dimensionLine;
        }
        return null;
    }

    protected Selectable getSelectableItemAt(float f, float f2) {
        List<Selectable> list = this.getSelectableItemsAt(f, f2, true);
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    protected List<Selectable> getSelectableItemsAt(float f, float f2) {
        return this.getSelectableItemsAt(f, f2, false);
    }

    /*
     * WARNING - void declaration
     */
    private List<Selectable> getSelectableItemsAt(float f, float f2, boolean bl) {
        void var12_23;
        void var10_14;
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        float f3 = 3.0f / this.getScale();
        float f4 = 1.0f / this.getScale();
        ObserverCamera observerCamera = this.home.getObserverCamera();
        if (observerCamera != null && observerCamera == this.home.getCamera() && observerCamera.containsPoint(f, f2, f3)) {
            arrayList.add(observerCamera);
            if (bl) {
                return arrayList;
            }
        }
        boolean bl2 = this.home.isBasePlanLocked();
        for (Label selectable22 : this.home.getLabels()) {
            if (bl2 && this.isItemPartOfBasePlan(selectable22)) continue;
            if (selectable22.containsPoint(f, f2, f3)) {
                arrayList.add(selectable22);
                if (!bl) continue;
                return arrayList;
            }
            if (!this.isItemTextAt(selectable22, selectable22.getText(), selectable22.getStyle(), selectable22.getX(), selectable22.getY(), f, f2, f4)) continue;
            arrayList.add(selectable22);
            if (!bl) continue;
            return arrayList;
        }
        for (DimensionLine dimensionLine : this.home.getDimensionLines()) {
            if (bl2 && this.isItemPartOfBasePlan(dimensionLine) || !dimensionLine.containsPoint(f, f2, f3)) continue;
            arrayList.add(dimensionLine);
            if (!bl) continue;
            return arrayList;
        }
        List<HomePieceOfFurniture> list = this.home.getFurniture();
        Object var10_13 = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            String string;
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)list.get(i);
            if (bl2 && this.isItemPartOfBasePlan(homePieceOfFurniture) || !homePieceOfFurniture.isVisible()) continue;
            if (homePieceOfFurniture.containsPoint(f, f2, f3)) {
                arrayList.add(homePieceOfFurniture);
                if (var10_14 != null && !(homePieceOfFurniture.getElevation() > var10_14.getElevation())) continue;
                HomePieceOfFurniture homePieceOfFurniture2 = homePieceOfFurniture;
                continue;
            }
            if (var10_14 != null || (string = homePieceOfFurniture.getName()) == null || !homePieceOfFurniture.isNameVisible() || !this.isItemTextAt(homePieceOfFurniture, string, homePieceOfFurniture.getNameStyle(), homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset(), homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset(), f, f2, f4)) continue;
            arrayList.add(homePieceOfFurniture);
            HomePieceOfFurniture homePieceOfFurniture3 = homePieceOfFurniture;
        }
        if (var10_14 != null && bl) {
            return Arrays.asList(var10_14);
        }
        for (Wall wall : this.home.getWalls()) {
            if (bl2 && this.isItemPartOfBasePlan(wall) || !wall.containsPoint(f, f2, f3)) continue;
            arrayList.add(wall);
            if (!bl) continue;
            return arrayList;
        }
        List<Room> list2 = this.home.getRooms();
        Object var12_22 = null;
        for (int i = list2.size() - 1; i >= 0; --i) {
            String string;
            Room room = (Room)list2.get(i);
            if (bl2 && this.isItemPartOfBasePlan(room)) continue;
            if (room.containsPoint(f, f2, f3)) {
                arrayList.add(room);
                if (var12_23 != null && (!room.isCeilingVisible() || var12_23.isCeilingVisible())) continue;
                Room room2 = room;
                continue;
            }
            String string2 = room.getName();
            if (string2 != null && this.isItemTextAt(room, string2, room.getNameStyle(), room.getXCenter() + room.getNameXOffset(), room.getYCenter() + room.getNameYOffset(), f, f2, f4)) {
                arrayList.add(room);
                Room room3 = room;
            }
            if (!room.isAreaVisible() || !this.isItemTextAt(room, string = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(room.getArea())), room.getAreaStyle(), room.getXCenter() + room.getAreaXOffset(), room.getYCenter() + room.getAreaYOffset(), f, f2, f4)) continue;
            arrayList.add(room);
            Room room4 = room;
        }
        if (var12_23 != null && bl) {
            return Arrays.asList(var12_23);
        }
        Compass compass = this.home.getCompass();
        if (!(bl2 && this.isItemPartOfBasePlan(compass) || !compass.containsPoint(f, f2, f4))) {
            arrayList.add(compass);
        }
        return arrayList;
    }

    private boolean isItemTextAt(Selectable selectable, String string, TextStyle textStyle, float f, float f2, float f3, float f4, float f5) {
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(selectable.getClass());
        }
        float[][] fArray = this.getView().getTextBounds(string, textStyle, f, f2, 0.0f);
        return this.getPath(fArray).intersects(f3 - f5, f4 - f5, 2.0f * f5, 2.0f * f5);
    }

    protected List<Selectable> getSelectableItemsIntersectingRectangle(float f, float f2, float f3, float f4) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        this.updateRectangleItems(arrayList, this.home.getDimensionLines(), f, f2, f3, f4);
        this.updateRectangleItems(arrayList, this.home.getRooms(), f, f2, f3, f4);
        this.updateRectangleItems(arrayList, this.home.getWalls(), f, f2, f3, f4);
        this.updateRectangleItems(arrayList, this.home.getLabels(), f, f2, f3, f4);
        this.updateRectangleItems(arrayList, Arrays.asList(this.home.getCompass()), f, f2, f3, f4);
        ObserverCamera observerCamera = this.home.getObserverCamera();
        if (observerCamera != null && observerCamera.intersectsRectangle(f, f2, f3, f4)) {
            arrayList.add(observerCamera);
        }
        boolean bl = this.home.isBasePlanLocked();
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            if (bl && this.isItemPartOfBasePlan(homePieceOfFurniture) || !homePieceOfFurniture.isVisible() || !homePieceOfFurniture.intersectsRectangle(f, f2, f3, f4)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private void updateRectangleItems(List<Selectable> list, Collection<? extends Selectable> collection, float f, float f2, float f3, float f4) {
        boolean bl = this.home.isBasePlanLocked();
        for (Selectable selectable : collection) {
            if (bl && this.isItemPartOfBasePlan(selectable) || !selectable.intersectsRectangle(f, f2, f3, f4)) continue;
            list.add(selectable);
        }
    }

    private HomePieceOfFurniture getRotatedPieceOfFurnitureAt(float f, float f2) {
        float f3;
        float f4;
        HomePieceOfFurniture homePieceOfFurniture;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomePieceOfFurniture && this.isItemMovable(list.get(0)) && (homePieceOfFurniture = (HomePieceOfFurniture)list.get(0)).isTopLeftPointAt(f, f2, f4 = 3.0f * (f3 = 1.0f / this.getScale())) && Math.abs(f - homePieceOfFurniture.getX()) > f3 && Math.abs(f2 - homePieceOfFurniture.getY()) > f3) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getElevatedPieceOfFurnitureAt(float f, float f2) {
        float f3;
        float f4;
        HomePieceOfFurniture homePieceOfFurniture;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomePieceOfFurniture && this.isItemMovable(list.get(0)) && (homePieceOfFurniture = (HomePieceOfFurniture)list.get(0)).isTopRightPointAt(f, f2, f4 = 3.0f * (f3 = 1.0f / this.getScale())) && Math.abs(f - homePieceOfFurniture.getX()) > f3 && Math.abs(f2 - homePieceOfFurniture.getY()) > f3) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getHeightResizedPieceOfFurnitureAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomePieceOfFurniture) {
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)list.get(0);
            float f3 = 1.0f / this.getScale();
            float f4 = 3.0f * f3;
            if (homePieceOfFurniture.isResizable() && this.isItemResizable(homePieceOfFurniture) && homePieceOfFurniture.isBottomLeftPointAt(f, f2, f4) && Math.abs(f - homePieceOfFurniture.getX()) > f3 && Math.abs(f2 - homePieceOfFurniture.getY()) > f3) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private HomePieceOfFurniture getWidthAndDepthResizedPieceOfFurnitureAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomePieceOfFurniture && this.isItemResizable(list.get(0))) {
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)list.get(0);
            float f3 = 1.0f / this.getScale();
            float f4 = 3.0f * f3;
            if (homePieceOfFurniture.isResizable() && this.isItemResizable(homePieceOfFurniture) && homePieceOfFurniture.isBottomRightPointAt(f, f2, f4) && Math.abs(f - homePieceOfFurniture.getX()) > f3 && Math.abs(f2 - homePieceOfFurniture.getY()) > f3) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private HomeLight getModifiedLightPowerAt(float f, float f2) {
        float f3;
        float f4;
        HomeLight homeLight;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomeLight && (homeLight = (HomeLight)list.get(0)).isBottomLeftPointAt(f, f2, f4 = 3.0f * (f3 = 1.0f / this.getScale())) && Math.abs(f - homeLight.getX()) > f3 && Math.abs(f2 - homeLight.getY()) > f3) {
            return homeLight;
        }
        return null;
    }

    private HomePieceOfFurniture getPieceOfFurnitureNameAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomePieceOfFurniture && this.isItemMovable(list.get(0))) {
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)list.get(0);
            float f3 = 1.0f / this.getScale();
            float f4 = 3.0f * f3;
            if (homePieceOfFurniture.isNameVisible() && homePieceOfFurniture.getName().trim().length() > 0 && homePieceOfFurniture.isNameCenterPointAt(f, f2, f4)) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private Camera getYawRotatedCameraAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Camera && this.isItemResizable(list.get(0))) {
            ObserverCamera observerCamera = (ObserverCamera)list.get(0);
            float f3 = 3.0f / this.getScale();
            float[][] fArray = observerCamera.getPoints();
            float f4 = (fArray[0][0] + fArray[3][0]) / 2.0f;
            float f5 = (fArray[0][1] + fArray[3][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3) {
                return observerCamera;
            }
        }
        return null;
    }

    private Camera getPitchRotatedCameraAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Camera && this.isItemResizable(list.get(0))) {
            ObserverCamera observerCamera = (ObserverCamera)list.get(0);
            float f3 = 3.0f / this.getScale();
            float[][] fArray = observerCamera.getPoints();
            float f4 = (fArray[1][0] + fArray[2][0]) / 2.0f;
            float f5 = (fArray[1][1] + fArray[2][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3) {
                return observerCamera;
            }
        }
        return null;
    }

    private Camera getElevatedCameraAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Camera && this.isItemResizable(list.get(0))) {
            ObserverCamera observerCamera = (ObserverCamera)list.get(0);
            float f3 = 3.0f / this.getScale();
            float[][] fArray = observerCamera.getPoints();
            float f4 = (fArray[0][0] + fArray[1][0]) / 2.0f;
            float f5 = (fArray[0][1] + fArray[1][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3) {
                return observerCamera;
            }
        }
        return null;
    }

    private Compass getRotatedCompassAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Compass && this.isItemMovable(list.get(0))) {
            Compass compass = (Compass)list.get(0);
            float f3 = 3.0f / this.getScale();
            float[][] fArray = compass.getPoints();
            float f4 = (fArray[2][0] + fArray[3][0]) / 2.0f;
            float f5 = (fArray[2][1] + fArray[3][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3) {
                return compass;
            }
        }
        return null;
    }

    private Compass getResizedCompassAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Compass && this.isItemMovable(list.get(0))) {
            Compass compass = (Compass)list.get(0);
            float f3 = 3.0f / this.getScale();
            float[][] fArray = compass.getPoints();
            float f4 = (fArray[1][0] + fArray[2][0]) / 2.0f;
            float f5 = (fArray[1][1] + fArray[2][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3) {
                return compass;
            }
        }
        return null;
    }

    public void deleteItems(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable cloneable : list) {
            if (!this.isItemDeletable(cloneable)) continue;
            arrayList.add(cloneable);
        }
        if (!arrayList.isEmpty()) {
            this.undoSupport.beginUpdate();
            final ArrayList<? extends Selectable> arrayList2 = new ArrayList<Selectable>(list);
            this.undoSupport.postEdit(new AbstractUndoableEdit(){

                public void undo() throws CannotRedoException {
                    super.undo();
                    PlanController.this.selectAndShowItems(arrayList2);
                }
            });
            this.deleteFurniture(Home.getFurnitureSubList(arrayList));
            ArrayList<Selectable> arrayList3 = new ArrayList<Selectable>(Home.getWallsSubList(arrayList));
            arrayList3.addAll(Home.getRoomsSubList(arrayList));
            arrayList3.addAll(Home.getDimensionLinesSubList(arrayList));
            arrayList3.addAll(Home.getLabelsSubList(arrayList));
            this.postDeleteItems(arrayList3, this.home.isBasePlanLocked());
            this.doDeleteItems(arrayList3);
            this.undoSupport.endUpdate();
        }
    }

    private void postDeleteItems(final List<? extends Selectable> list, final boolean bl) {
        List<Wall> list2 = Home.getWallsSubList(list);
        final JoinedWall[] joinedWallArray = JoinedWall.getJoinedWalls(list2);
        List<Room> list3 = Home.getRoomsSubList(list);
        List<Room> list4 = this.home.getRooms();
        TreeMap<Integer, Room> treeMap = new TreeMap<Integer, Room>();
        for (Room object2 : list3) {
            treeMap.put(list4.indexOf(object2), object2);
        }
        final Room[] roomArray = treeMap.values().toArray(new Room[treeMap.size()]);
        final int[] nArray = new int[roomArray.length];
        int n = 0;
        Object object = treeMap.keySet().iterator();
        while (object.hasNext()) {
            int dimensionLineArray = (Integer)object.next();
            nArray[n++] = dimensionLineArray;
        }
        object = Home.getDimensionLinesSubList(list);
        final DimensionLine[] dimensionLineArray = object.toArray(new DimensionLine[object.size()]);
        List<Label> list5 = Home.getLabelsSubList(list);
        final Label[] labelArray = list5.toArray(new Label[list5.size()]);
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                PlanController.this.doAddWalls(joinedWallArray, bl);
                PlanController.this.doAddRooms(roomArray, nArray, bl);
                PlanController.this.doAddDimensionLines(dimensionLineArray, bl);
                PlanController.this.doAddLabels(labelArray, bl);
                PlanController.this.selectAndShowItems(list);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                PlanController.this.selectItems(list);
                PlanController.this.doDeleteWalls(joinedWallArray, bl);
                PlanController.this.doDeleteRooms(roomArray, bl);
                PlanController.this.doDeleteDimensionLines(dimensionLineArray, bl);
                PlanController.this.doDeleteLabels(labelArray, bl);
            }

            public String getPresentationName() {
                return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoDeleteSelectionName", new Object[0]);
            }
        };
        this.undoSupport.postEdit(abstractUndoableEdit);
    }

    private void doDeleteItems(List<Selectable> list) {
        boolean bl = this.home.isBasePlanLocked();
        for (Selectable selectable : list) {
            if (selectable instanceof Wall) {
                this.home.deleteWall((Wall)selectable);
            } else if (selectable instanceof DimensionLine) {
                this.home.deleteDimensionLine((DimensionLine)selectable);
            } else if (selectable instanceof Room) {
                this.home.deleteRoom((Room)selectable);
            } else if (selectable instanceof Label) {
                this.home.deleteLabel((Label)selectable);
            } else if (selectable instanceof HomePieceOfFurniture) {
                this.home.deletePieceOfFurniture((HomePieceOfFurniture)selectable);
            }
            bl &= !this.isItemPartOfBasePlan(selectable);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void moveAndShowSelectedItems(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable selectable : list) {
            if (!this.isItemMovable(selectable)) continue;
            arrayList.add(selectable);
        }
        if (!arrayList.isEmpty()) {
            this.moveItems(arrayList, f, f2);
            this.selectAndShowItems(arrayList);
            if (arrayList.size() != 1 || !(arrayList.get(0) instanceof Camera)) {
                this.postItemsMove(arrayList, list, f, f2);
            }
        }
    }

    public void moveItems(List<? extends Selectable> list, float f, float f2) {
        for (Selectable selectable : list) {
            if (selectable instanceof Wall) {
                Wall wall = (Wall)selectable;
                this.moveWallStartPoint(wall, wall.getXStart() + f, wall.getYStart() + f2, !list.contains(wall.getWallAtStart()));
                this.moveWallEndPoint(wall, wall.getXEnd() + f, wall.getYEnd() + f2, !list.contains(wall.getWallAtEnd()));
                continue;
            }
            selectable.move(f, f2);
        }
    }

    private void moveWallStartPoint(Wall wall, float f, float f2, boolean bl) {
        float f3 = wall.getXStart();
        float f4 = wall.getYStart();
        wall.setXStart(f);
        wall.setYStart(f2);
        Wall wall2 = wall.getWallAtStart();
        if (wall2 != null && bl) {
            if (wall2.getWallAtStart() == wall && (wall2.getWallAtEnd() != wall || wall2.getXStart() == f3 && wall2.getYStart() == f4)) {
                wall2.setXStart(f);
                wall2.setYStart(f2);
            } else if (wall2.getWallAtEnd() == wall && (wall2.getWallAtStart() != wall || wall2.getXEnd() == f3 && wall2.getYEnd() == f4)) {
                wall2.setXEnd(f);
                wall2.setYEnd(f2);
            }
        }
    }

    private void moveWallEndPoint(Wall wall, float f, float f2, boolean bl) {
        float f3 = wall.getXEnd();
        float f4 = wall.getYEnd();
        wall.setXEnd(f);
        wall.setYEnd(f2);
        Wall wall2 = wall.getWallAtEnd();
        if (wall2 != null && bl) {
            if (wall2.getWallAtStart() == wall && (wall2.getWallAtEnd() != wall || wall2.getXStart() == f3 && wall2.getYStart() == f4)) {
                wall2.setXStart(f);
                wall2.setYStart(f2);
            } else if (wall2.getWallAtEnd() == wall && (wall2.getWallAtStart() != wall || wall2.getXEnd() == f3 && wall2.getYEnd() == f4)) {
                wall2.setXEnd(f);
                wall2.setYEnd(f2);
            }
        }
    }

    private void moveWallPoint(Wall wall, float f, float f2, boolean bl) {
        if (bl) {
            this.moveWallStartPoint(wall, f, f2, true);
        } else {
            this.moveWallEndPoint(wall, f, f2, true);
        }
    }

    private void moveRoomPoint(Room room, float f, float f2, int n) {
        room.setPoint(f, f2, n);
    }

    private void moveDimensionLinePoint(DimensionLine dimensionLine, float f, float f2, boolean bl) {
        if (bl) {
            dimensionLine.setXStart(f);
            dimensionLine.setYStart(f2);
        } else {
            dimensionLine.setXEnd(f);
            dimensionLine.setYEnd(f2);
        }
    }

    private void reverseDimensionLine(DimensionLine dimensionLine) {
        float f = dimensionLine.getXStart();
        float f2 = dimensionLine.getYStart();
        dimensionLine.setXStart(dimensionLine.getXEnd());
        dimensionLine.setYStart(dimensionLine.getYEnd());
        dimensionLine.setXEnd(f);
        dimensionLine.setYEnd(f2);
        dimensionLine.setOffset(-dimensionLine.getOffset());
    }

    protected void selectAndShowItems(List<? extends Selectable> list) {
        this.selectItems(list);
        this.getView().makeSelectionVisible();
    }

    protected void selectItems(List<? extends Selectable> list) {
        this.home.removeSelectionListener(this.selectionListener);
        this.home.setSelectedItems(list);
        this.home.addSelectionListener(this.selectionListener);
    }

    private void selectItem(Selectable selectable) {
        this.selectItems(Arrays.asList(selectable));
    }

    private void deselectAll() {
        List list = Collections.emptyList();
        this.selectItems(list);
    }

    public void addWalls(List<Wall> list) {
        for (Wall wall : list) {
            this.home.addWall(wall);
        }
        this.postCreateWalls(list, this.home.getSelectedItems(), this.home.isBasePlanLocked());
    }

    private void postCreateWalls(List<Wall> list, List<Selectable> list2, final boolean bl) {
        if (list.size() > 0) {
            boolean bl2 = this.home.isBasePlanLocked();
            if (bl2) {
                for (Wall object2 : list) {
                    bl2 &= !this.isItemPartOfBasePlan(object2);
                }
                this.home.setBasePlanLocked(bl2);
            }
            final boolean bl3 = bl2;
            final JoinedWall[] joinedWallArray = new JoinedWall[list.size()];
            for (int selectableArray = 0; selectableArray < joinedWallArray.length; ++selectableArray) {
                joinedWallArray[selectableArray] = new JoinedWall(list.get(selectableArray));
            }
            final Selectable[] selectableArray = list2.toArray(new Selectable[list2.size()]);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.doDeleteWalls(joinedWallArray, bl);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.doAddWalls(joinedWallArray, bl3);
                    PlanController.this.selectAndShowItems(JoinedWall.getWalls(joinedWallArray));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoCreateWallsName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doAddWalls(JoinedWall[] joinedWallArray, boolean bl) {
        Wall wall;
        for (JoinedWall joinedWall : joinedWallArray) {
            wall = joinedWall.getWall();
            this.home.addWall(wall);
        }
        this.home.setBasePlanLocked(bl);
        for (JoinedWall joinedWall : joinedWallArray) {
            Wall wall2;
            wall = joinedWall.getWall();
            Wall wall3 = joinedWall.getWallAtStart();
            if (wall3 != null) {
                wall.setWallAtStart(wall3);
                if (joinedWall.isJoinedAtEndOfWallAtStart()) {
                    wall3.setWallAtEnd(wall);
                } else if (joinedWall.isJoinedAtStartOfWallAtStart()) {
                    wall3.setWallAtStart(wall);
                }
            }
            if ((wall2 = joinedWall.getWallAtEnd()) == null) continue;
            wall.setWallAtEnd(wall2);
            if (joinedWall.isJoinedAtStartOfWallAtEnd()) {
                wall2.setWallAtStart(wall);
                continue;
            }
            if (!joinedWall.isJoinedAtEndOfWallAtEnd()) continue;
            wall2.setWallAtEnd(wall);
        }
    }

    private void doDeleteWalls(JoinedWall[] joinedWallArray, boolean bl) {
        for (JoinedWall joinedWall : joinedWallArray) {
            this.home.deleteWall(joinedWall.getWall());
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addRooms(List<Room> list) {
        Room[] roomArray = list.toArray(new Room[list.size()]);
        int[] nArray = new int[list.size()];
        int n = this.home.getRooms().size();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n++;
            this.home.addRoom(roomArray[i], nArray[i]);
        }
        this.postCreateRooms(roomArray, nArray, this.home.getSelectedItems(), this.home.isBasePlanLocked());
    }

    private void postCreateRooms(final Room[] roomArray, final int[] nArray, List<Selectable> list, final boolean bl) {
        if (roomArray.length > 0) {
            boolean bl2 = this.home.isBasePlanLocked();
            if (bl2) {
                for (Room room : roomArray) {
                    bl2 &= !this.isItemPartOfBasePlan(room);
                }
                this.home.setBasePlanLocked(bl2);
            }
            final boolean bl3 = bl2;
            final Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.doDeleteRooms(roomArray, bl);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.doAddRooms(roomArray, nArray, bl3);
                    PlanController.this.selectAndShowItems(Arrays.asList(roomArray));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoCreateRoomsName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postCreateRooms(List<Room> list, List<Selectable> list2, boolean bl) {
        Room[] roomArray = list.toArray(new Room[list.size()]);
        int[] nArray = new int[list.size()];
        List<Room> list3 = this.home.getRooms();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list3.lastIndexOf(roomArray[i]);
        }
        this.postCreateRooms(roomArray, nArray, list2, bl);
    }

    private void doAddRooms(Room[] roomArray, int[] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.home.addRoom(roomArray[i], nArray[i]);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeleteRooms(Room[] roomArray, boolean bl) {
        for (Room room : roomArray) {
            this.home.deleteRoom(room);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addDimensionLines(List<DimensionLine> list) {
        for (DimensionLine dimensionLine : list) {
            this.home.addDimensionLine(dimensionLine);
        }
        this.postCreateDimensionLines(list, this.home.getSelectedItems(), this.home.isBasePlanLocked());
    }

    private void postCreateDimensionLines(List<DimensionLine> list, List<Selectable> list2, final boolean bl) {
        if (list.size() > 0) {
            boolean bl2 = this.home.isBasePlanLocked();
            if (bl2) {
                for (DimensionLine object2 : list) {
                    bl2 &= !this.isItemPartOfBasePlan(object2);
                }
                this.home.setBasePlanLocked(bl2);
            }
            final boolean bl3 = bl2;
            final DimensionLine[] dimensionLineArray = list.toArray(new DimensionLine[list.size()]);
            final Selectable[] selectableArray = list2.toArray(new Selectable[list2.size()]);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.doDeleteDimensionLines(dimensionLineArray, bl);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.doAddDimensionLines(dimensionLineArray, bl3);
                    PlanController.this.selectAndShowItems(Arrays.asList(dimensionLineArray));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoCreateDimensionLinesName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doAddDimensionLines(DimensionLine[] dimensionLineArray, boolean bl) {
        for (DimensionLine dimensionLine : dimensionLineArray) {
            this.home.addDimensionLine(dimensionLine);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeleteDimensionLines(DimensionLine[] dimensionLineArray, boolean bl) {
        for (DimensionLine dimensionLine : dimensionLineArray) {
            this.home.deleteDimensionLine(dimensionLine);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addLabels(List<Label> list) {
        for (Label label : list) {
            this.home.addLabel(label);
        }
        this.postCreateLabels(list, this.home.getSelectedItems(), this.home.isBasePlanLocked());
    }

    private void postCreateLabels(List<Label> list, List<Selectable> list2, final boolean bl) {
        if (list.size() > 0) {
            boolean bl2 = this.home.isBasePlanLocked();
            if (bl2) {
                for (Label object2 : list) {
                    bl2 &= !this.isItemPartOfBasePlan(object2);
                }
                this.home.setBasePlanLocked(bl2);
            }
            final boolean bl3 = bl2;
            final Label[] labelArray = list.toArray(new Label[list.size()]);
            final Selectable[] selectableArray = list2.toArray(new Selectable[list2.size()]);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.doDeleteLabels(labelArray, bl);
                    PlanController.this.selectAndShowItems(Arrays.asList(selectableArray));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.doAddLabels(labelArray, bl3);
                    PlanController.this.selectAndShowItems(Arrays.asList(labelArray));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoCreateLabelsName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doAddLabels(Label[] labelArray, boolean bl) {
        for (Label label : labelArray) {
            this.home.addLabel(label);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeleteLabels(Label[] labelArray, boolean bl) {
        for (Label label : labelArray) {
            this.home.deleteLabel(label);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void postItemsMove(List<? extends Selectable> list, List<? extends Selectable> list2, final float f, final float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            final Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            final Selectable[] selectableArray2 = list2.toArray(new Selectable[list2.size()]);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.doMoveAndShowItems(selectableArray, selectableArray2, -f, -f2);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.doMoveAndShowItems(selectableArray, selectableArray, f, f2);
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoMoveSelectionName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doMoveAndShowItems(Selectable[] selectableArray, Selectable[] selectableArray2, float f, float f2) {
        this.moveItems(Arrays.asList(selectableArray), f, f2);
        this.selectAndShowItems(Arrays.asList(selectableArray2));
    }

    private void postPieceOfFurnitureMove(final HomePieceOfFurniture homePieceOfFurniture, final float f, final float f2, final float f3, final float f4, final float f5, final boolean bl) {
        final float f6 = homePieceOfFurniture.getAngle();
        final float f7 = homePieceOfFurniture.getDepth();
        final float f8 = homePieceOfFurniture.getElevation();
        if (f != 0.0f || f2 != 0.0f || f6 != f3 || f7 != f4 || f8 != f5) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    homePieceOfFurniture.move(-f, -f2);
                    homePieceOfFurniture.setAngle(f3);
                    if (homePieceOfFurniture.isResizable() && PlanController.this.isItemResizable(homePieceOfFurniture)) {
                        homePieceOfFurniture.setDepth(f4);
                    }
                    homePieceOfFurniture.setElevation(f5);
                    if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                        ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(bl);
                    }
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    homePieceOfFurniture.move(f, f2);
                    homePieceOfFurniture.setAngle(f6);
                    if (homePieceOfFurniture.isResizable() && PlanController.this.isItemResizable(homePieceOfFurniture)) {
                        homePieceOfFurniture.setDepth(f7);
                    }
                    homePieceOfFurniture.setElevation(f8);
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoMoveSelectionName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postItemsDuplication(final List<Selectable> list, final List<Selectable> list2) {
        boolean bl = this.home.isBasePlanLocked();
        List<HomePieceOfFurniture> list3 = Home.getFurnitureSubList(list);
        for (HomePieceOfFurniture homePieceOfFurniture : list3) {
            this.home.deletePieceOfFurniture(homePieceOfFurniture);
        }
        this.undoSupport.beginUpdate();
        this.undoSupport.postEdit(new AbstractUndoableEdit(){

            public void undo() throws CannotRedoException {
                super.undo();
                PlanController.this.selectAndShowItems(list2);
            }
        });
        this.addFurniture(list3);
        List list4 = Collections.emptyList();
        this.postCreateWalls(Home.getWallsSubList(list), list4, bl);
        this.postCreateRooms(Home.getRoomsSubList(list), list4, bl);
        this.postCreateDimensionLines(Home.getDimensionLinesSubList(list), list4, bl);
        this.postCreateLabels(Home.getLabelsSubList(list), list4, bl);
        this.undoSupport.postEdit(new AbstractUndoableEdit(){

            public void redo() throws CannotRedoException {
                super.redo();
                PlanController.this.selectAndShowItems(list);
            }

            public String getPresentationName() {
                return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoDuplicateSelectionName", new Object[0]);
            }
        });
        this.undoSupport.endUpdate();
        this.selectItems(list);
    }

    private void postWallResize(final Wall wall, final float f, final float f2, final boolean bl) {
        float f3;
        float f4;
        if (bl) {
            f4 = wall.getXStart();
            f3 = wall.getYStart();
        } else {
            f4 = wall.getXEnd();
            f3 = wall.getYEnd();
        }
        if (f4 != f || f3 != f2) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.moveWallPoint(wall, f, f2, bl);
                    PlanController.this.selectAndShowItems(Arrays.asList(wall));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.moveWallPoint(wall, f4, f3, bl);
                    PlanController.this.selectAndShowItems(Arrays.asList(wall));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoWallResizeName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postRoomResize(final Room room, final float f, final float f2, final int n) {
        float[] fArray = room.getPoints()[n];
        final float f3 = fArray[0];
        final float f4 = fArray[1];
        if (f3 != f || f4 != f2) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    PlanController.this.moveRoomPoint(room, f, f2, n);
                    PlanController.this.selectAndShowItems(Arrays.asList(room));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.moveRoomPoint(room, f3, f4, n);
                    PlanController.this.selectAndShowItems(Arrays.asList(room));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoRoomResizeName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postRoomNameOffset(final Room room, final float f, final float f2) {
        final float f3 = room.getNameXOffset();
        final float f4 = room.getNameYOffset();
        if (f3 != f || f4 != f2) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    room.setNameXOffset(f);
                    room.setNameYOffset(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(room));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    room.setNameXOffset(f3);
                    room.setNameYOffset(f4);
                    PlanController.this.selectAndShowItems(Arrays.asList(room));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoRoomNameOffsetName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postRoomAreaOffset(final Room room, final float f, final float f2) {
        final float f3 = room.getAreaXOffset();
        final float f4 = room.getAreaYOffset();
        if (f3 != f || f4 != f2) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    room.setAreaXOffset(f);
                    room.setAreaYOffset(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(room));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    room.setAreaXOffset(f3);
                    room.setAreaYOffset(f4);
                    PlanController.this.selectAndShowItems(Arrays.asList(room));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoRoomAreaOffsetName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postPieceOfFurnitureRotation(final HomePieceOfFurniture homePieceOfFurniture, final float f, final boolean bl) {
        final float f2 = homePieceOfFurniture.getAngle();
        if (f2 != f) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    homePieceOfFurniture.setAngle(f);
                    if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                        ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(bl);
                    }
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    homePieceOfFurniture.setAngle(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoPieceOfFurnitureRotationName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postPieceOfFurnitureElevation(final HomePieceOfFurniture homePieceOfFurniture, final float f) {
        final float f2 = homePieceOfFurniture.getElevation();
        if (f2 != f) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    homePieceOfFurniture.setElevation(f);
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    homePieceOfFurniture.setElevation(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, f < f2 ? "undoPieceOfFurnitureRaiseName" : "undoPieceOfFurnitureLowerName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postPieceOfFurnitureHeightResize(ResizedPieceOfFurniture resizedPieceOfFurniture) {
        if (resizedPieceOfFurniture.getPieceOfFurniture().getHeight() != resizedPieceOfFurniture.getHeight()) {
            this.postPieceOfFurnitureResize(resizedPieceOfFurniture, "undoPieceOfFurnitureHeightResizeName");
        }
    }

    private void postPieceOfFurnitureWidthAndDepthResize(ResizedPieceOfFurniture resizedPieceOfFurniture) {
        HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
        if (homePieceOfFurniture.getWidth() != resizedPieceOfFurniture.getWidth() || homePieceOfFurniture.getDepth() != resizedPieceOfFurniture.getDepth()) {
            this.postPieceOfFurnitureResize(resizedPieceOfFurniture, "undoPieceOfFurnitureWidthAndDepthResizeName");
        }
    }

    private void postPieceOfFurnitureResize(final ResizedPieceOfFurniture resizedPieceOfFurniture, final String string) {
        HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
        final float f = homePieceOfFurniture.getX();
        final float f2 = homePieceOfFurniture.getY();
        final float f3 = homePieceOfFurniture.getWidth();
        final float f4 = homePieceOfFurniture.getDepth();
        final float f5 = homePieceOfFurniture.getHeight();
        final boolean bl = homePieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)homePieceOfFurniture).isBoundToWall();
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                resizedPieceOfFurniture.reset();
                PlanController.this.selectAndShowItems(Arrays.asList(resizedPieceOfFurniture.getPieceOfFurniture()));
            }

            public void redo() throws CannotRedoException {
                super.redo();
                HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
                homePieceOfFurniture.setX(f);
                homePieceOfFurniture.setY(f2);
                homePieceOfFurniture.setWidth(f3);
                homePieceOfFurniture.setDepth(f4);
                homePieceOfFurniture.setHeight(f5);
                if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                    ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(bl);
                }
                PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
            }

            public String getPresentationName() {
                return PlanController.this.preferences.getLocalizedString(PlanController.class, string, new Object[0]);
            }
        };
        this.undoSupport.postEdit(abstractUndoableEdit);
    }

    private void postLightPowerModification(final HomeLight homeLight, final float f) {
        final float f2 = homeLight.getPower();
        if (f2 != f) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    homeLight.setPower(f);
                    PlanController.this.selectAndShowItems(Arrays.asList(homeLight));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    homeLight.setPower(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(homeLight));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoLightPowerModificationName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postPieceOfFurnitureNameOffset(final HomePieceOfFurniture homePieceOfFurniture, final float f, final float f2) {
        final float f3 = homePieceOfFurniture.getNameXOffset();
        final float f4 = homePieceOfFurniture.getNameYOffset();
        if (f3 != f || f4 != f2) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    homePieceOfFurniture.setNameXOffset(f);
                    homePieceOfFurniture.setNameYOffset(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    homePieceOfFurniture.setNameXOffset(f3);
                    homePieceOfFurniture.setNameYOffset(f4);
                    PlanController.this.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoPieceOfFurnitureNameOffsetName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postDimensionLineResize(final DimensionLine dimensionLine, final float f, final float f2, final boolean bl, final boolean bl2) {
        float f3;
        float f4;
        if (bl) {
            f4 = dimensionLine.getXStart();
            f3 = dimensionLine.getYStart();
        } else {
            f4 = dimensionLine.getXEnd();
            f3 = dimensionLine.getYEnd();
        }
        if (f4 != f || f3 != f2 || bl2) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    if (bl2) {
                        PlanController.this.reverseDimensionLine(dimensionLine);
                        PlanController.this.moveDimensionLinePoint(dimensionLine, f, f2, !bl);
                    } else {
                        PlanController.this.moveDimensionLinePoint(dimensionLine, f, f2, bl);
                    }
                    PlanController.this.selectAndShowItems(Arrays.asList(dimensionLine));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    PlanController.this.moveDimensionLinePoint(dimensionLine, f4, f3, bl);
                    if (bl2) {
                        PlanController.this.reverseDimensionLine(dimensionLine);
                    }
                    PlanController.this.selectAndShowItems(Arrays.asList(dimensionLine));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoDimensionLineResizeName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postDimensionLineOffset(final DimensionLine dimensionLine, final float f) {
        final float f2 = dimensionLine.getOffset();
        if (f2 != f) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    dimensionLine.setOffset(f);
                    PlanController.this.selectAndShowItems(Arrays.asList(dimensionLine));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    dimensionLine.setOffset(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(dimensionLine));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoDimensionLineOffsetName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postCompassRotation(final Compass compass, final float f) {
        final float f2 = compass.getNorthDirection();
        if (f2 != f) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    compass.setNorthDirection(f);
                    PlanController.this.selectAndShowItems(Arrays.asList(compass));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    compass.setNorthDirection(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(compass));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoCompassRotationName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void postCompassResize(final Compass compass, final float f) {
        final float f2 = compass.getDiameter();
        if (f2 != f) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    compass.setDiameter(f);
                    PlanController.this.selectAndShowItems(Arrays.asList(compass));
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    compass.setDiameter(f2);
                    PlanController.this.selectAndShowItems(Arrays.asList(compass));
                }

                public String getPresentationName() {
                    return PlanController.this.preferences.getLocalizedString(PlanController.class, "undoCompassResizeName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private float[][] getPathPoints(GeneralPath generalPath, boolean bl) {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        float[] fArray = null;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            float[] fArray2 = new float[2];
            if (!(pathIterator.currentSegment(fArray2) == 4 || fArray != null && Arrays.equals(fArray2, fArray))) {
                boolean bl2 = false;
                if (bl && arrayList.size() > 1) {
                    float[] fArray3;
                    float[] fArray4 = (float[])arrayList.get(arrayList.size() - 2);
                    boolean bl3 = bl2 = Line2D.ptLineDistSq(fArray4[0], fArray4[1], (fArray3 = fArray)[0], fArray3[1], fArray2[0], fArray2[1]) < 1.0E-4;
                }
                if (bl2) {
                    arrayList.set(arrayList.size() - 1, fArray2);
                } else {
                    arrayList.add(fArray2);
                }
                fArray = fArray2;
            }
            pathIterator.next();
        }
        if (arrayList.size() > 1 && Arrays.equals((float[])arrayList.get(0), (float[])arrayList.get(arrayList.size() - 1))) {
            arrayList.remove(arrayList.size() - 1);
        }
        return (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
    }

    private List<GeneralPath> getRoomPathsFromWalls() {
        if (this.roomPathsCache == null) {
            ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
            Area area = this.getWallsArea();
            Area area2 = new Area(area);
            GeneralPath generalPath = new GeneralPath();
            PathIterator pathIterator = area.getPathIterator(null, 0.5);
            while (!pathIterator.isDone()) {
                float[] fArray = new float[2];
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        generalPath.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        generalPath.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 4: {
                        generalPath.closePath();
                        area2.add(new Area(generalPath));
                        arrayList.add(generalPath);
                        generalPath = new GeneralPath();
                    }
                }
                pathIterator.next();
            }
            this.roomPathsCache = arrayList;
            this.insideWallsAreaCache = area2;
        }
        return this.roomPathsCache;
    }

    private Area getInsideWallsArea() {
        if (this.insideWallsAreaCache == null) {
            this.getRoomPathsFromWalls();
        }
        return this.insideWallsAreaCache;
    }

    private Area getWallsArea() {
        if (this.wallsAreaCache == null) {
            Area area = new Area();
            for (Wall wall : this.home.getWalls()) {
                area.add(new Area(this.getPath(wall.getPoints())));
            }
            this.wallsAreaCache = area;
        }
        return this.wallsAreaCache;
    }

    private GeneralPath getPath(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath getPath(Area area) {
        GeneralPath generalPath = new GeneralPath();
        float[] fArray = new float[2];
        PathIterator pathIterator = area.getPathIterator(null, 0.5);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    generalPath.lineTo(fArray[0], fArray[1]);
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    private class CompassResizeState
    extends ControllerState {
        private Compass selectedCompass;
        private float oldDiameter;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private String resizeToolTipFeedback;

        private CompassResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.resizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "diameterToolTipFeedback", new Object[0]);
            this.selectedCompass = (Compass)PlanController.this.home.getSelectedItems().get(0);
            float[][] fArray = this.selectedCompass.getPoints();
            float f = (fArray[1][0] + fArray[2][0]) / 2.0f;
            float f2 = (fArray[1][1] + fArray[2][1]) / 2.0f;
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - f;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - f2;
            this.oldDiameter = this.selectedCompass.getDiameter();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldDiameter), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = (float)Point2D.distance(this.selectedCompass.getX(), this.selectedCompass.getY(), f - this.deltaXToResizePoint, f2 - this.deltaYToResizePoint) * 2.0f;
            f3 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f3, planView.getPixelLength());
            f3 = Math.max(f3, PlanController.this.preferences.getLengthUnit().getMinimumLength());
            this.selectedCompass.setDiameter(f3);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postCompassResize(this.selectedCompass, this.oldDiameter);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCompass.setDiameter(this.oldDiameter);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCompass = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.resizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class CompassRotationState
    extends ControllerState {
        private Compass selectedCompass;
        private float angleMousePress;
        private float oldNorthDirection;
        private String rotationToolTipFeedback;

        private CompassRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "rotationToolTipFeedback", new Object[0]);
            this.selectedCompass = (Compass)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedCompass.getY() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedCompass.getX());
            this.oldNorthDirection = this.selectedCompass.getNorthDirection();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldNorthDirection), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedCompass.getX() || f2 != this.selectedCompass.getY()) {
                float f3 = (float)Math.atan2(this.selectedCompass.getY() - f2, f - this.selectedCompass.getX());
                float f4 = this.oldNorthDirection - f3 + this.angleMousePress;
                float f5 = (float)Math.PI / 180;
                f4 = (float)Math.round(f4 / f5) * f5;
                f4 = (float)(((double)f4 + Math.PI * 2) % (Math.PI * 2));
                this.selectedCompass.setNorthDirection(f4);
                PlanView planView = PlanController.this.getView();
                planView.makePointVisible(f, f2);
                planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postCompassRotation(this.selectedCompass, this.oldNorthDirection);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCompass.setNorthDirection(this.oldNorthDirection);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCompass = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, Math.round(Math.toDegrees(f)));
        }
    }

    private class LabelCreationState
    extends AbstractModeChangeState {
        private LabelCreationState() {
        }

        public Mode getMode() {
            return Mode.LABEL_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.createLabel(f, f2);
        }
    }

    private class RoomAreaOffsetState
    extends ControllerState {
        private Room selectedRoom;
        private float oldAreaXOffset;
        private float oldAreaYOffset;
        private float xLastMouseMove;
        private float yLastMouseMove;

        private RoomAreaOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.oldAreaXOffset = this.selectedRoom.getAreaXOffset();
            this.oldAreaYOffset = this.selectedRoom.getAreaYOffset();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            this.selectedRoom.setAreaXOffset(this.selectedRoom.getAreaXOffset() + f - this.xLastMouseMove);
            this.selectedRoom.setAreaYOffset(this.selectedRoom.getAreaYOffset() + f2 - this.yLastMouseMove);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomAreaOffset(this.selectedRoom, this.oldAreaXOffset, this.oldAreaYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedRoom.setAreaXOffset(this.oldAreaXOffset);
            this.selectedRoom.setAreaYOffset(this.oldAreaYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedRoom = null;
        }
    }

    private class RoomNameOffsetState
    extends ControllerState {
        private Room selectedRoom;
        private float oldNameXOffset;
        private float oldNameYOffset;
        private float xLastMouseMove;
        private float yLastMouseMove;

        private RoomNameOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.oldNameXOffset = this.selectedRoom.getNameXOffset();
            this.oldNameYOffset = this.selectedRoom.getNameYOffset();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            this.selectedRoom.setNameXOffset(this.selectedRoom.getNameXOffset() + f - this.xLastMouseMove);
            this.selectedRoom.setNameYOffset(this.selectedRoom.getNameYOffset() + f2 - this.yLastMouseMove);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomNameOffset(this.selectedRoom, this.oldNameXOffset, this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedRoom.setNameXOffset(this.oldNameXOffset);
            this.selectedRoom.setNameYOffset(this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedRoom = null;
        }
    }

    private class RoomResizeState
    extends AbstractRoomState {
        private Collection<Room> rooms;
        private Room selectedRoom;
        private int roomPointIndex;
        private float oldX;
        private float oldY;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private boolean magnetismEnabled;

        private RoomResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            super.enter();
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.rooms = new ArrayList<Room>(PlanController.this.home.getRooms());
            this.rooms.remove(this.selectedRoom);
            float f = 3.0f / PlanController.this.getScale();
            this.roomPointIndex = this.selectedRoom.getPointIndexAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f);
            float[][] fArray = this.selectedRoom.getPoints();
            this.oldX = fArray[this.roomPointIndex][0];
            this.oldY = fArray[this.roomPointIndex][1];
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - this.oldX;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.oldY;
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedRoom, this.roomPointIndex), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            this.showRoomAngleFeedback(this.selectedRoom, this.roomPointIndex);
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToResizePoint;
            float f4 = f2 - this.deltaYToResizePoint;
            boolean bl = false;
            if (this.magnetismEnabled) {
                PointMagnetizedToClosestWallOrRoomPoint pointMagnetizedToClosestWallOrRoomPoint = new PointMagnetizedToClosestWallOrRoomPoint(this.rooms, f3, f4, 2.0f / PlanController.this.getScale());
                bl = pointMagnetizedToClosestWallOrRoomPoint.isMagnetized();
                if (bl) {
                    f3 = pointMagnetizedToClosestWallOrRoomPoint.getX();
                    f4 = pointMagnetizedToClosestWallOrRoomPoint.getY();
                } else {
                    float[][] fArray = this.selectedRoom.getPoints();
                    int n = this.roomPointIndex == 0 ? fArray.length - 1 : this.roomPointIndex - 1;
                    float f5 = fArray[n][0];
                    float f6 = fArray[n][1];
                    PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(f5, f6, f3, f4, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                    f3 = pointWithAngleMagnetism.getX();
                    f4 = pointWithAngleMagnetism.getY();
                }
            }
            PlanController.this.moveRoomPoint(this.selectedRoom, f3, f4, this.roomPointIndex);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedRoom, this.roomPointIndex), f, f2);
            planView.setAlignmentFeedback(Room.class, this.selectedRoom, f3, f4, bl);
            this.showRoomAngleFeedback(this.selectedRoom, this.roomPointIndex);
            planView.makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomResize(this.selectedRoom, this.oldX, this.oldY, this.roomPointIndex);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            PlanController.this.moveRoomPoint(this.selectedRoom, this.oldX, this.oldY, this.roomPointIndex);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedRoom = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoomDrawingState
    extends AbstractRoomState {
        private Collection<Room> rooms;
        private float xPreviousPoint;
        private float yPreviousPoint;
        private Room newRoom;
        private float[] newPoint;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private boolean magnetismEnabled;
        private long lastPointCreationTime;

        private RoomDrawingState() {
        }

        @Override
        public Mode getMode() {
            return Mode.ROOM_CREATION;
        }

        @Override
        public boolean isModificationState() {
            return true;
        }

        @Override
        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        @Override
        public void enter() {
            super.enter();
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.rooms = PlanController.this.home.getRooms();
            this.newRoom = null;
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            if (this.magnetismEnabled) {
                PointMagnetizedToClosestWallOrRoomPoint pointMagnetizedToClosestWallOrRoomPoint = new PointMagnetizedToClosestWallOrRoomPoint(this.rooms, PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove(), 2.0f / PlanController.this.getScale());
                this.xPreviousPoint = pointMagnetizedToClosestWallOrRoomPoint.getX();
                this.yPreviousPoint = pointMagnetizedToClosestWallOrRoomPoint.getY();
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, pointMagnetizedToClosestWallOrRoomPoint.getX(), pointMagnetizedToClosestWallOrRoomPoint.getY(), pointMagnetizedToClosestWallOrRoomPoint.isMagnetized());
            } else {
                this.xPreviousPoint = PlanController.this.getXLastMousePress();
                this.yPreviousPoint = PlanController.this.getYLastMousePress();
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, this.xPreviousPoint, this.yPreviousPoint, false);
            }
            PlanController.this.deselectAll();
        }

        @Override
        public void moveMouse(float f, float f2) {
            Object object;
            PlanView planView = PlanController.this.getView();
            float f3 = f;
            float f4 = f2;
            boolean bl = false;
            if (this.magnetismEnabled) {
                object = new PointMagnetizedToClosestWallOrRoomPoint(this.rooms, f, f2, 2.0f / PlanController.this.getScale());
                bl = ((PointMagnetizedToClosestWallOrRoomPoint)object).isMagnetized();
                if (bl) {
                    f3 = ((PointMagnetizedToClosestWallOrRoomPoint)object).getX();
                    f4 = ((PointMagnetizedToClosestWallOrRoomPoint)object).getY();
                } else {
                    PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.xPreviousPoint, this.yPreviousPoint, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                    f3 = pointWithAngleMagnetism.getX();
                    f4 = pointWithAngleMagnetism.getY();
                }
            }
            if (this.newRoom == null) {
                this.newRoom = this.createAndSelectRoom(this.xPreviousPoint, this.yPreviousPoint, f3, f4);
            } else if (this.newPoint != null) {
                object = this.newRoom.getPoints();
                this.xPreviousPoint = object[((float[][])object).length - 1][0];
                this.yPreviousPoint = (float)object[((Object)object).length - 1][1];
                this.newRoom.addPoint(f3, f4);
                this.newPoint = null;
            } else {
                this.newRoom.setPoint(f3, f4, this.newRoom.getPointCount() - 1);
            }
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.newRoom, this.newRoom.getPointCount() - 1), f, f2);
            planView.setAlignmentFeedback(Room.class, this.newRoom, f3, f4, bl);
            this.showRoomAngleFeedback(this.newRoom, this.newRoom.getPointCount() - 1);
            planView.makePointVisible(f, f2);
        }

        private Room createAndSelectRoom(float f, float f2, float f3, float f4) {
            Room room = PlanController.this.createRoom(new float[][]{{f, f2}, {f3, f4}});
            Area area = PlanController.this.getInsideWallsArea();
            room.setCeilingVisible(area.contains(f, f2));
            PlanController.this.selectItem(room);
            return room;
        }

        @Override
        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 2) {
                if (this.newRoom == null) {
                    this.newRoom = this.createRoomAt(f, f2);
                    if (this.newRoom != null) {
                        PlanController.this.selectItem(this.newRoom);
                    }
                }
                this.validateDrawnRoom();
            } else {
                this.endRoomSide();
            }
        }

        private void validateDrawnRoom() {
            if (this.newRoom != null) {
                float[][] fArray = this.newRoom.getPoints();
                if (fArray.length < 3) {
                    PlanController.this.home.deleteRoom(this.newRoom);
                } else {
                    PlanController.this.postCreateRooms(Arrays.asList(this.newRoom), this.oldSelection, this.oldBasePlanLocked);
                }
            }
            PlanController.this.setState(PlanController.this.getRoomCreationState());
        }

        private void endRoomSide() {
            if (this.newRoom != null && this.getRoomSideLength(this.newRoom, this.newRoom.getPointCount() - 1) > 0.0f) {
                this.newPoint = new float[2];
                if (this.newRoom.isCeilingVisible()) {
                    float[][] fArray = this.newRoom.getPoints();
                    float[] fArray2 = fArray[fArray.length - 1];
                    if (!PlanController.this.getInsideWallsArea().contains(fArray2[0], fArray2[1])) {
                        this.newRoom.setCeilingVisible(false);
                    }
                }
            }
        }

        private Room createRoomAt(float f, float f2) {
            for (GeneralPath generalPath : PlanController.this.getRoomPathsFromWalls()) {
                if (!generalPath.contains(f, f2)) continue;
                for (HomePieceOfFurniture homePieceOfFurniture : this.getVisibleDoorsAndWindowsAtGround(PlanController.this.home.getFurniture())) {
                    float[][] fArray = homePieceOfFurniture.getPoints();
                    int n = 0;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!generalPath.contains(fArray[i][0], fArray[i][1])) continue;
                        ++n;
                    }
                    if (n != 2 || fArray.length != 4) continue;
                    Area area = new Area(PlanController.this.getWallsArea());
                    area.intersect(new Area(PlanController.this.getPath(fArray)));
                    float[][] fArray2 = PlanController.this.getPathPoints(PlanController.this.getPath(area), false);
                    Shape shape = null;
                    if (fArray2.length == 4) {
                        float f3 = 0.05f;
                        for (int i = 0; i < fArray2.length; ++i) {
                            int n2;
                            int n3;
                            int n4;
                            if (!generalPath.intersects(fArray2[i][0] - f3 / 2.0f, fArray2[i][1] - f3 / 2.0f, f3, f3)) continue;
                            int n5 = i;
                            if (generalPath.intersects(fArray2[i + 1][0] - f3 / 2.0f, fArray2[i + 1][1] - f3 / 2.0f, f3, f3)) {
                                n4 = i + 1;
                                n3 = (i + 2) % 4;
                                n2 = (i + 3) % 4;
                            } else {
                                n2 = (i + 1) % 4;
                                n3 = (i + 2) % 4;
                                n4 = (i + 3) % 4;
                            }
                            fArray2[n2][0] = (fArray2[n2][0] + fArray2[n5][0]) / 2.0f;
                            fArray2[n2][1] = (fArray2[n2][1] + fArray2[n5][1]) / 2.0f;
                            fArray2[n3][0] = (fArray2[n3][0] + fArray2[n4][0]) / 2.0f;
                            fArray2[n3][1] = (fArray2[n3][1] + fArray2[n4][1]) / 2.0f;
                            GeneralPath generalPath2 = PlanController.this.getPath(fArray2);
                            AffineTransform affineTransform = new AffineTransform();
                            Rectangle2D rectangle2D = generalPath2.getBounds2D();
                            affineTransform.translate(rectangle2D.getCenterX(), rectangle2D.getCenterY());
                            double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                            double d2 = (d + (double)f3) / d;
                            affineTransform.scale(d2, d2);
                            affineTransform.translate(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
                            shape = generalPath2.createTransformedShape(affineTransform);
                            break;
                        }
                    }
                    if (shape == null) continue;
                    Area area2 = new Area(shape);
                    area2.add(new Area(generalPath));
                    generalPath = PlanController.this.getPath(area2);
                }
                return PlanController.this.createRoom(PlanController.this.getPathPoints(generalPath, false));
            }
            return null;
        }

        private List<HomePieceOfFurniture> getVisibleDoorsAndWindowsAtGround(List<HomePieceOfFurniture> list) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getElevation() != 0.0f) continue;
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    arrayList.addAll(this.getVisibleDoorsAndWindowsAtGround(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                    continue;
                }
                if (!homePieceOfFurniture.isDoorOrWindow()) continue;
                arrayList.add(homePieceOfFurniture);
            }
            return arrayList;
        }

        @Override
        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newRoom == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xPreviousPoint), Float.valueOf(this.yPreviousPoint)}, this.xPreviousPoint, this.yPreviousPoint);
                } else {
                    if (this.newPoint != null) {
                        this.createNextSide();
                    }
                    float[][] fArray = this.newRoom.getPoints();
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE}, new Object[]{Float.valueOf(this.getRoomSideLength(this.newRoom, fArray.length - 1)), this.getRoomSideAngle(this.newRoom, fArray.length - 1)}, fArray[fArray.length - 1][0], fArray[fArray.length - 1][1]);
                }
            } else if (this.newRoom == null) {
                float f = PlanController.this.preferences.getLengthUnit() == LengthUnit.INCH ? LengthUnit.footToCentimeter(10.0f) : 300.0f;
                this.newRoom = this.createAndSelectRoom(this.xPreviousPoint, this.yPreviousPoint, this.xPreviousPoint + f, this.yPreviousPoint);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (System.currentTimeMillis() - this.lastPointCreationTime < 300L) {
                this.escape();
            } else {
                this.endRoomSide();
                float[][] fArray = this.newRoom.getPoints();
                if (fArray.length > 2 && this.newRoom.getPointIndexAt(fArray[fArray.length - 1][0], fArray[fArray.length - 1][1], 0.001f) == 0) {
                    this.newRoom.removePoint(this.newRoom.getPointCount() - 1);
                    this.validateDrawnRoom();
                    return;
                }
                this.createNextSide();
                planView.deleteToolTipFeedback();
                this.setEditionActivated(true);
            }
        }

        private void createNextSide() {
            float[][] fArray = this.newRoom.getPoints();
            this.xPreviousPoint = fArray[fArray.length - 1][0];
            this.yPreviousPoint = fArray[fArray.length - 1][1];
            double d = Math.PI - Math.atan2(fArray[fArray.length - 2][1] - fArray[fArray.length - 1][1], fArray[fArray.length - 2][0] - fArray[fArray.length - 1][0]);
            float f = this.getRoomSideLength(this.newRoom, fArray.length - 1);
            this.newRoom.addPoint((float)((double)this.xPreviousPoint + (double)f * Math.cos(d -= 1.5707963267948966)), (float)((double)this.yPreviousPoint - (double)f * Math.sin(d)));
            this.newPoint = null;
            this.lastPointCreationTime = System.currentTimeMillis();
        }

        @Override
        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            PlanView planView = PlanController.this.getView();
            if (this.newRoom == null) {
                switch (editableProperty) {
                    case X: {
                        this.xPreviousPoint = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xPreviousPoint = Math.max(-100000.0f, Math.min(this.xPreviousPoint, 100000.0f));
                        break;
                    }
                    case Y: {
                        this.yPreviousPoint = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yPreviousPoint = Math.max(-100000.0f, Math.min(this.yPreviousPoint, 100000.0f));
                    }
                }
                planView.setAlignmentFeedback(Room.class, null, this.xPreviousPoint, this.yPreviousPoint, true);
                planView.makePointVisible(this.xPreviousPoint, this.yPreviousPoint);
            } else {
                float f;
                float f2;
                float[][] fArray = this.newRoom.getPoints();
                float[] fArray2 = fArray[fArray.length - 2];
                float[] fArray3 = fArray[fArray.length - 1];
                switch (editableProperty) {
                    case LENGTH: {
                        float f3 = object != null ? ((Number)object).floatValue() : 0.0f;
                        f3 = Math.max(0.001f, Math.min(f3, 100000.0f));
                        double d = Math.PI - Math.atan2(fArray2[1] - fArray3[1], fArray2[0] - fArray3[0]);
                        f2 = (float)((double)fArray2[0] + (double)f3 * Math.cos(d));
                        f = (float)((double)fArray2[1] - (double)f3 * Math.sin(d));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? (double)((Number)object).floatValue() : 0.0);
                        if (fArray.length > 2) {
                            d -= Math.atan2(fArray[fArray.length - 3][1] - fArray2[1], fArray[fArray.length - 3][0] - fArray2[0]);
                        }
                        float f4 = this.getRoomSideLength(this.newRoom, fArray.length - 1);
                        f2 = (float)((double)fArray2[0] + (double)f4 * Math.cos(d));
                        f = (float)((double)fArray2[1] - (double)f4 * Math.sin(d));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.newRoom.setPoint(f2, f, fArray.length - 1);
                planView.setAlignmentFeedback(Room.class, this.newRoom, f2, f, false);
                this.showRoomAngleFeedback(this.newRoom, fArray.length - 1);
                planView.makePointVisible(fArray2[0], fArray2[1]);
                planView.makePointVisible(f2, f);
            }
        }

        @Override
        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newRoom != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        @Override
        public void escape() {
            if (this.newRoom != null && this.newPoint == null) {
                this.newRoom.removePoint(this.newRoom.getPointCount() - 1);
            }
            this.validateDrawnRoom();
        }

        @Override
        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.newRoom = null;
            this.newPoint = null;
            this.oldSelection = null;
        }
    }

    private abstract class AbstractRoomState
    extends ControllerState {
        private String roomSideLengthToolTipFeedback;
        private String roomSideAngleToolTipFeedback;

        private AbstractRoomState() {
        }

        public void enter() {
            this.roomSideLengthToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "roomSideLengthToolTipFeedback", new Object[0]);
            this.roomSideAngleToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "roomSideAngleToolTipFeedback", new Object[0]);
        }

        protected String getToolTipFeedbackText(Room room, int n) {
            float f = this.getRoomSideLength(room, n);
            int n2 = this.getRoomSideAngle(room, n);
            return "<html>" + String.format(this.roomSideLengthToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f))) + "<br>" + String.format(this.roomSideAngleToolTipFeedback, n2);
        }

        protected float getRoomSideLength(Room room, int n) {
            float[][] fArray = room.getPoints();
            float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
            return (float)Point2D.distance(fArray2[0], fArray2[1], fArray[n][0], fArray[n][1]);
        }

        protected Integer getRoomSideAngle(Room room, int n) {
            float[][] fArray = room.getPoints();
            float[] fArray2 = fArray[n];
            float[] fArray3 = fArray[(n + fArray.length - 1) % fArray.length];
            float[] fArray4 = fArray[(n + fArray.length - 2) % fArray.length];
            float f = (float)Point2D.distance(fArray3[0], fArray3[1], fArray[n][0], fArray[n][1]);
            float f2 = (float)Point2D.distance(fArray4[0], fArray4[1], fArray3[0], fArray3[1]);
            if (fArray4 != fArray2 && f != 0.0f && f2 != 0.0f) {
                float f3 = (fArray2[1] - fArray3[1]) / f;
                float f4 = (fArray3[0] - fArray4[0]) / f2;
                float f5 = (fArray2[0] - fArray3[0]) / f;
                float f6 = (fArray3[1] - fArray4[1]) / f2;
                int n2 = (int)Math.round(180.0 - Math.toDegrees(Math.atan2(f3 * f4 - f5 * f6, f5 * f4 + f3 * f6)));
                if (n2 > 180) {
                    n2 -= 360;
                }
                return n2;
            }
            if (f == 0.0f) {
                return 0;
            }
            return (int)Math.round(Math.toDegrees(Math.atan2(fArray3[1] - fArray2[1], fArray2[0] - fArray3[0])));
        }

        protected void showRoomAngleFeedback(Room room, int n) {
            float[][] fArray = room.getPoints();
            if (fArray.length > 2) {
                float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
                float[] fArray3 = fArray[(n + fArray.length - 2) % fArray.length];
                if (this.getRoomSideAngle(room, n) > 0) {
                    PlanController.this.getView().setAngleFeedback(fArray2[0], fArray2[1], fArray3[0], fArray3[1], fArray[n][0], fArray[n][1]);
                } else {
                    PlanController.this.getView().setAngleFeedback(fArray2[0], fArray2[1], fArray[n][0], fArray[n][1], fArray3[0], fArray3[1]);
                }
            }
        }
    }

    private class RoomCreationState
    extends AbstractModeChangeState {
        private boolean magnetismEnabled;

        private RoomCreationState() {
        }

        public Mode getMode() {
            return Mode.ROOM_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void moveMouse(float f, float f2) {
            if (this.magnetismEnabled) {
                PointMagnetizedToClosestWallOrRoomPoint pointMagnetizedToClosestWallOrRoomPoint = new PointMagnetizedToClosestWallOrRoomPoint(PlanController.this.home.getRooms(), f, f2, 2.0f / PlanController.this.getScale());
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, pointMagnetizedToClosestWallOrRoomPoint.getX(), pointMagnetizedToClosestWallOrRoomPoint.getY(), pointMagnetizedToClosestWallOrRoomPoint.isMagnetized());
            } else {
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, f, f2, false);
            }
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.setState(PlanController.this.getRoomDrawingState());
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getRoomDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class DimensionLineOffsetState
    extends ControllerState {
        private DimensionLine selectedDimensionLine;
        private float oldOffset;
        private float deltaXToOffsetPoint;
        private float deltaYToOffsetPoint;

        private DimensionLineOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedDimensionLine = (DimensionLine)PlanController.this.home.getSelectedItems().get(0);
            this.oldOffset = this.selectedDimensionLine.getOffset();
            double d = Math.atan2(this.selectedDimensionLine.getYEnd() - this.selectedDimensionLine.getYStart(), this.selectedDimensionLine.getXEnd() - this.selectedDimensionLine.getXStart());
            float f = (float)(-Math.sin(d)) * this.oldOffset;
            float f2 = (float)Math.cos(d) * this.oldOffset;
            float f3 = (this.selectedDimensionLine.getXStart() + this.selectedDimensionLine.getXEnd()) / 2.0f + f;
            float f4 = (this.selectedDimensionLine.getYStart() + this.selectedDimensionLine.getYEnd()) / 2.0f + f2;
            this.deltaXToOffsetPoint = PlanController.this.getXLastMousePress() - f3;
            this.deltaYToOffsetPoint = PlanController.this.getYLastMousePress() - f4;
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            float f3 = f - this.deltaXToOffsetPoint;
            float f4 = f2 - this.deltaYToOffsetPoint;
            float f5 = (float)Line2D.ptLineDist(this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), f3, f4);
            int n = Line2D.relativeCCW(this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), f3, f4);
            this.selectedDimensionLine.setOffset(-Math.signum(n) * f5);
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postDimensionLineOffset(this.selectedDimensionLine, this.oldOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedDimensionLine.setOffset(this.oldOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedDimensionLine = null;
        }
    }

    private class DimensionLineResizeState
    extends ControllerState {
        private DimensionLine selectedDimensionLine;
        private boolean editingStartPoint;
        private float oldX;
        private float oldY;
        private boolean reversedDimensionLine;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private float distanceFromResizePointToDimensionBaseLine;
        private boolean magnetismEnabled;

        private DimensionLineResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            float f;
            float f2;
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            this.selectedDimensionLine = (DimensionLine)PlanController.this.home.getSelectedItems().get(0);
            boolean bl = this.editingStartPoint = this.selectedDimensionLine == PlanController.this.getResizedDimensionLineStartAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            if (this.editingStartPoint) {
                this.oldX = this.selectedDimensionLine.getXStart();
                this.oldY = this.selectedDimensionLine.getYStart();
            } else {
                this.oldX = this.selectedDimensionLine.getXEnd();
                this.oldY = this.selectedDimensionLine.getYEnd();
            }
            this.reversedDimensionLine = false;
            float f3 = (this.selectedDimensionLine.getYEnd() - this.selectedDimensionLine.getYStart()) / (this.selectedDimensionLine.getXEnd() - this.selectedDimensionLine.getXStart());
            if ((double)Math.abs(f3) > 100000.0) {
                f2 = PlanController.this.getXLastMousePress();
                f = this.editingStartPoint ? this.selectedDimensionLine.getYStart() : this.selectedDimensionLine.getYEnd();
            } else if (this.selectedDimensionLine.getYStart() == this.selectedDimensionLine.getYEnd()) {
                f2 = this.editingStartPoint ? this.selectedDimensionLine.getXStart() : this.selectedDimensionLine.getXEnd();
                f = PlanController.this.getYLastMousePress();
            } else {
                float f4 = PlanController.this.getYLastMousePress() - f3 * PlanController.this.getXLastMousePress();
                float f5 = -1.0f / f3;
                float f6 = this.editingStartPoint ? this.selectedDimensionLine.getYStart() - f5 * this.selectedDimensionLine.getXStart() : this.selectedDimensionLine.getYEnd() - f5 * this.selectedDimensionLine.getXEnd();
                f2 = (f6 - f4) / (f3 - f5);
                f = f3 * f2 + f4;
            }
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - f2;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - f;
            if (this.editingStartPoint) {
                this.distanceFromResizePointToDimensionBaseLine = (float)Point2D.distance(f2, f, this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart());
                planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), false);
            } else {
                this.distanceFromResizePointToDimensionBaseLine = (float)Point2D.distance(f2, f, this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd());
                planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), false);
            }
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToResizePoint;
            float f4 = f2 - this.deltaYToResizePoint;
            if (this.editingStartPoint) {
                double d = Point2D.distance(f3, f4, this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd());
                double d2 = Math.sqrt(d * d - (double)(this.distanceFromResizePointToDimensionBaseLine * this.distanceFromResizePointToDimensionBaseLine));
                if (d2 > 0.0) {
                    double d3 = -Math.atan2(this.distanceFromResizePointToDimensionBaseLine, d2);
                    if (this.selectedDimensionLine.getOffset() >= 0.0f) {
                        d3 = -d3;
                    }
                    double d4 = Math.atan2(f4 - this.selectedDimensionLine.getYEnd(), f3 - this.selectedDimensionLine.getXEnd());
                    double d5 = d3 + d4;
                    float f5 = this.selectedDimensionLine.getXEnd() + (float)(d2 * Math.cos(d5));
                    float f6 = this.selectedDimensionLine.getYEnd() + (float)(d2 * Math.sin(d5));
                    if (this.magnetismEnabled) {
                        PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), f5, f6, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                        f5 = pointWithAngleMagnetism.getX();
                        f6 = pointWithAngleMagnetism.getY();
                    }
                    PlanController.this.moveDimensionLinePoint(this.selectedDimensionLine, f5, f6, this.editingStartPoint);
                    this.updateReversedDimensionLine();
                    planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, f5, f6, false);
                } else {
                    planView.deleteFeedback();
                }
            } else {
                double d = Point2D.distance(f3, f4, this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart());
                double d6 = Math.sqrt(d * d - (double)(this.distanceFromResizePointToDimensionBaseLine * this.distanceFromResizePointToDimensionBaseLine));
                if (d6 > 0.0) {
                    double d7 = Math.atan2(this.distanceFromResizePointToDimensionBaseLine, d6);
                    if (this.selectedDimensionLine.getOffset() >= 0.0f) {
                        d7 = -d7;
                    }
                    double d8 = Math.atan2(f4 - this.selectedDimensionLine.getYStart(), f3 - this.selectedDimensionLine.getXStart());
                    double d9 = d7 + d8;
                    float f7 = this.selectedDimensionLine.getXStart() + (float)(d6 * Math.cos(d9));
                    float f8 = this.selectedDimensionLine.getYStart() + (float)(d6 * Math.sin(d9));
                    if (this.magnetismEnabled) {
                        PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), f7, f8, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                        f7 = pointWithAngleMagnetism.getX();
                        f8 = pointWithAngleMagnetism.getY();
                    }
                    PlanController.this.moveDimensionLinePoint(this.selectedDimensionLine, f7, f8, this.editingStartPoint);
                    this.updateReversedDimensionLine();
                    planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, f7, f8, false);
                } else {
                    planView.deleteFeedback();
                }
            }
            PlanController.this.getView().makePointVisible(f, f2);
        }

        private void updateReversedDimensionLine() {
            double d = this.getDimensionLineAngle();
            if (d < -1.5707963267948966 || d > 1.5707963267948966) {
                PlanController.this.reverseDimensionLine(this.selectedDimensionLine);
                this.editingStartPoint = !this.editingStartPoint;
                this.reversedDimensionLine = !this.reversedDimensionLine;
            }
        }

        private double getDimensionLineAngle() {
            if (this.selectedDimensionLine.getLength() == 0.0f) {
                return 0.0;
            }
            return Math.atan2(this.selectedDimensionLine.getYStart() - this.selectedDimensionLine.getYEnd(), this.selectedDimensionLine.getXEnd() - this.selectedDimensionLine.getXStart());
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postDimensionLineResize(this.selectedDimensionLine, this.oldX, this.oldY, this.editingStartPoint, this.reversedDimensionLine);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            if (this.reversedDimensionLine) {
                PlanController.this.reverseDimensionLine(this.selectedDimensionLine);
                this.editingStartPoint = !this.editingStartPoint;
            }
            PlanController.this.moveDimensionLinePoint(this.selectedDimensionLine, this.oldX, this.oldY, this.editingStartPoint);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.deleteFeedback();
            planView.setResizeIndicatorVisible(false);
            this.selectedDimensionLine = null;
        }
    }

    private class DimensionLineDrawingState
    extends ControllerState {
        private float xStart;
        private float yStart;
        private boolean editingStartPoint;
        private DimensionLine newDimensionLine;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private boolean magnetismEnabled;
        private boolean offsetChoice;

        private DimensionLineDrawingState() {
        }

        public Mode getMode() {
            return Mode.DIMENSION_LINE_CREATION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.xStart = PlanController.this.getXLastMousePress();
            this.yStart = PlanController.this.getYLastMousePress();
            this.editingStartPoint = false;
            this.offsetChoice = false;
            this.newDimensionLine = null;
            PlanController.this.deselectAll();
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            DimensionLine dimensionLine = PlanController.this.getMeasuringDimensionLineAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), this.magnetismEnabled);
            if (dimensionLine != null) {
                PlanController.this.getView().setDimensionLinesFeedback(Arrays.asList(dimensionLine));
            }
            PlanController.this.getView().setAlignmentFeedback(DimensionLine.class, null, PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), false);
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            planView.deleteFeedback();
            if (this.offsetChoice) {
                float f3 = (float)Line2D.ptLineDist(this.newDimensionLine.getXStart(), this.newDimensionLine.getYStart(), this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd(), f, f2);
                if (this.newDimensionLine.getLength() > 0.0f) {
                    int n = Line2D.relativeCCW(this.newDimensionLine.getXStart(), this.newDimensionLine.getYStart(), this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd(), f, f2);
                    this.newDimensionLine.setOffset(-Math.signum(n) * f3);
                }
            } else {
                float f4;
                float f5;
                if (this.magnetismEnabled) {
                    PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.xStart, this.yStart, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                    f5 = pointWithAngleMagnetism.getX();
                    f4 = pointWithAngleMagnetism.getY();
                } else {
                    f5 = f;
                    f4 = f2;
                }
                if (this.newDimensionLine == null) {
                    this.newDimensionLine = PlanController.this.createDimensionLine(this.xStart, this.yStart, f5, f4, 0.0f);
                    PlanController.this.getView().setDimensionLinesFeedback(null);
                } else if (this.editingStartPoint) {
                    this.newDimensionLine.setXStart(f5);
                    this.newDimensionLine.setYStart(f4);
                } else {
                    this.newDimensionLine.setXEnd(f5);
                    this.newDimensionLine.setYEnd(f4);
                }
                this.updateReversedDimensionLine();
                planView.setAlignmentFeedback(DimensionLine.class, this.newDimensionLine, f5, f4, false);
            }
            planView.makePointVisible(f, f2);
        }

        private void updateReversedDimensionLine() {
            boolean bl;
            double d = this.getDimensionLineAngle();
            boolean bl2 = bl = d < -1.5707963267948966 || d > 1.5707963267948966;
            if (bl ^ this.editingStartPoint) {
                PlanController.this.reverseDimensionLine(this.newDimensionLine);
                this.editingStartPoint = !this.editingStartPoint;
            }
        }

        private double getDimensionLineAngle() {
            if (this.newDimensionLine.getLength() == 0.0f) {
                return 0.0;
            }
            if (this.editingStartPoint) {
                return Math.atan2(this.yStart - this.newDimensionLine.getYStart(), this.newDimensionLine.getXStart() - this.xStart);
            }
            return Math.atan2(this.yStart - this.newDimensionLine.getYEnd(), this.newDimensionLine.getXEnd() - this.xStart);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            Object object;
            if (this.newDimensionLine == null && n == 2) {
                object = PlanController.this.getMeasuringDimensionLineAt(f, f2, this.magnetismEnabled);
                this.newDimensionLine = PlanController.this.createDimensionLine(((DimensionLine)object).getXStart(), ((DimensionLine)object).getYStart(), ((DimensionLine)object).getXEnd(), ((DimensionLine)object).getYEnd(), ((DimensionLine)object).getOffset());
            }
            if (this.newDimensionLine != null) {
                if (this.offsetChoice) {
                    this.validateDrawnDimensionLine();
                } else {
                    this.offsetChoice = true;
                    object = PlanController.this.getView();
                    object.setCursor(PlanView.CursorType.HEIGHT);
                    object.deleteFeedback();
                }
            }
        }

        private void validateDrawnDimensionLine() {
            PlanController.this.selectItem(this.newDimensionLine);
            PlanController.this.postCreateDimensionLines(Arrays.asList(this.newDimensionLine), this.oldSelection, this.oldBasePlanLocked);
            this.newDimensionLine = null;
            PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
        }

        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newDimensionLine == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xStart), Float.valueOf(this.yStart)}, this.xStart, this.yStart);
                } else if (this.offsetChoice) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.OFFSET}, new Object[]{Float.valueOf(this.newDimensionLine.getOffset())}, this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd());
                } else {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE}, new Object[]{Float.valueOf(this.newDimensionLine.getLength()), (int)Math.round(Math.toDegrees(this.getDimensionLineAngle()))}, this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd());
                }
            } else if (this.newDimensionLine == null) {
                float f = PlanController.this.preferences.getLengthUnit() == LengthUnit.INCH ? LengthUnit.footToCentimeter(3.0f) : 100.0f;
                this.newDimensionLine = PlanController.this.createDimensionLine(this.xStart, this.yStart, this.xStart + f, this.yStart, 0.0f);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (this.offsetChoice) {
                this.validateDrawnDimensionLine();
            } else {
                this.offsetChoice = true;
                this.setEditionActivated(true);
            }
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            PlanView planView = PlanController.this.getView();
            if (this.newDimensionLine == null) {
                switch (editableProperty) {
                    case X: {
                        this.xStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xStart = Math.max(-100000.0f, Math.min(this.xStart, 100000.0f));
                        break;
                    }
                    case Y: {
                        this.yStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yStart = Math.max(-100000.0f, Math.min(this.yStart, 100000.0f));
                    }
                }
                planView.setAlignmentFeedback(DimensionLine.class, null, this.xStart, this.yStart, true);
                planView.makePointVisible(this.xStart, this.yStart);
            } else if (this.offsetChoice) {
                if (editableProperty == EditableProperty.OFFSET) {
                    float f = object != null ? ((Number)object).floatValue() : 0.0f;
                    f = Math.max(-100000.0f, Math.min(f, 100000.0f));
                    this.newDimensionLine.setOffset(f);
                }
            } else {
                float f;
                float f2;
                switch (editableProperty) {
                    case LENGTH: {
                        float f3 = object != null ? ((Number)object).floatValue() : 0.0f;
                        f3 = Math.max(0.001f, Math.min(f3, 100000.0f));
                        double d = this.getDimensionLineAngle();
                        f2 = (float)((double)this.xStart + (double)f3 * Math.cos(d));
                        f = (float)((double)this.yStart - (double)f3 * Math.sin(d));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? (double)((Number)object).floatValue() : 0.0);
                        float f4 = this.newDimensionLine.getLength();
                        f2 = (float)((double)this.xStart + (double)f4 * Math.cos(d));
                        f = (float)((double)this.yStart - (double)f4 * Math.sin(d));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (this.editingStartPoint) {
                    this.newDimensionLine.setXStart(f2);
                    this.newDimensionLine.setYStart(f);
                } else {
                    this.newDimensionLine.setXEnd(f2);
                    this.newDimensionLine.setYEnd(f);
                }
                this.updateReversedDimensionLine();
                planView.setAlignmentFeedback(DimensionLine.class, this.newDimensionLine, f2, f, false);
                planView.makePointVisible(this.xStart, this.yStart);
                planView.makePointVisible(f2, f);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newDimensionLine != null && !this.offsetChoice) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void escape() {
            if (this.newDimensionLine != null) {
                PlanController.this.home.deleteDimensionLine(this.newDimensionLine);
            }
            PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.newDimensionLine = null;
            this.oldSelection = null;
        }
    }

    private class DimensionLineCreationState
    extends AbstractModeChangeState {
        private boolean magnetismEnabled;

        private DimensionLineCreationState() {
        }

        public Mode getMode() {
            return Mode.DIMENSION_LINE_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanController.this.getView().setAlignmentFeedback(DimensionLine.class, null, f, f2, false);
            DimensionLine dimensionLine = PlanController.this.getMeasuringDimensionLineAt(f, f2, this.magnetismEnabled);
            if (dimensionLine != null) {
                PlanController.this.getView().setDimensionLinesFeedback(Arrays.asList(dimensionLine));
            } else {
                PlanController.this.getView().setDimensionLinesFeedback(null);
            }
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 1) {
                PlanController.this.setState(PlanController.this.getDimensionLineDrawingState());
            }
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getDimensionLineDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class CameraElevationState
    extends ControllerState {
        private ObserverCamera selectedCamera;
        private float oldElevation;
        private String cameraElevationToolTipFeedback;
        private String observerHeightToolTipFeedback;

        private CameraElevationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.cameraElevationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "cameraElevationToolTipFeedback", new Object[0]);
            this.observerHeightToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "observerHeightToolTipFeedback", new Object[0]);
            this.selectedCamera = (ObserverCamera)PlanController.this.home.getSelectedItems().get(0);
            this.oldElevation = this.selectedCamera.getZ();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldElevation), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3 = this.oldElevation - (f2 - PlanController.this.getYLastMousePress());
            f3 = Math.max(f3, 9.0f);
            f3 = Math.min(f3, 2500.0f);
            this.selectedCamera.setZ(f3);
            PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCamera.setZ(this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCamera = null;
        }

        private String getToolTipFeedbackText(float f) {
            String string = "<html>" + String.format(this.cameraElevationToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
            if (f >= 70.0f && f <= 218.75f) {
                string = string + "<br>" + String.format(this.observerHeightToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f * 15.0f / 14.0f)));
            }
            return string;
        }
    }

    private class CameraPitchRotationState
    extends ControllerState {
        private ObserverCamera selectedCamera;
        private float oldPitch;
        private String rotationToolTipFeedback;

        private CameraPitchRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "cameraPitchRotationToolTipFeedback", new Object[0]);
            this.selectedCamera = (ObserverCamera)PlanController.this.home.getSelectedItems().get(0);
            this.oldPitch = this.selectedCamera.getPitch();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldPitch), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3 = (float)((double)this.oldPitch + (double)(f2 - PlanController.this.getYLastMousePress()) * Math.cos(this.selectedCamera.getYaw()) * Math.PI / 360.0 - (double)(f - PlanController.this.getXLastMousePress()) * Math.sin(this.selectedCamera.getYaw()) * Math.PI / 360.0);
            f3 = Math.max(f3, -1.0471976f);
            f3 = Math.min(f3, 1.308997f);
            this.selectedCamera.setPitch(f3);
            PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCamera.setPitch(this.oldPitch);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCamera = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, Math.round(Math.toDegrees(f)) % 360L);
        }
    }

    private class CameraYawRotationState
    extends ControllerState {
        private ObserverCamera selectedCamera;
        private float oldYaw;
        private float xLastMouseMove;
        private float yLastMouseMove;
        private float angleLastMouseMove;
        private String rotationToolTipFeedback;

        private CameraYawRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "cameraYawRotationToolTipFeedback", new Object[0]);
            this.selectedCamera = (ObserverCamera)PlanController.this.home.getSelectedItems().get(0);
            this.oldYaw = this.selectedCamera.getYaw();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.angleLastMouseMove = (float)Math.atan2(this.selectedCamera.getY() - this.yLastMouseMove, this.xLastMouseMove - this.selectedCamera.getX());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldYaw), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedCamera.getX() || f2 != this.selectedCamera.getY()) {
                float f3 = (float)Math.atan2(this.selectedCamera.getY() - f2, f - this.selectedCamera.getX());
                float f4 = this.angleLastMouseMove - f3;
                float f5 = Math.signum((f2 - this.selectedCamera.getY()) * (this.xLastMouseMove - this.selectedCamera.getX()) - (this.yLastMouseMove - this.selectedCamera.getY()) * (f - this.selectedCamera.getX()));
                if (f5 < 0.0f && f4 > 0.0f) {
                    f4 -= (float)Math.PI * 2;
                } else if (f5 > 0.0f && f4 < 0.0f) {
                    f4 += (float)Math.PI * 2;
                }
                float f6 = this.selectedCamera.getYaw() + f4;
                this.selectedCamera.setYaw(f6);
                PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f6), f, f2);
                this.xLastMouseMove = f;
                this.yLastMouseMove = f2;
                this.angleLastMouseMove = f3;
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCamera.setYaw(this.oldYaw);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCamera = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, (Math.round(Math.toDegrees(f)) + 360L) % 360L);
        }
    }

    private class PieceOfFurnitureNameOffsetState
    extends ControllerState {
        private HomePieceOfFurniture selectedPiece;
        private float oldNameXOffset;
        private float oldNameYOffset;
        private float xLastMouseMove;
        private float yLastMouseMove;

        private PieceOfFurnitureNameOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.oldNameXOffset = this.selectedPiece.getNameXOffset();
            this.oldNameYOffset = this.selectedPiece.getNameYOffset();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            this.selectedPiece.setNameXOffset(this.selectedPiece.getNameXOffset() + f - this.xLastMouseMove);
            this.selectedPiece.setNameYOffset(this.selectedPiece.getNameYOffset() + f2 - this.yLastMouseMove);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureNameOffset(this.selectedPiece, this.oldNameXOffset, this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedPiece.setNameXOffset(this.oldNameXOffset);
            this.selectedPiece.setNameYOffset(this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedPiece = null;
        }
    }

    private class LightPowerModificationState
    extends ControllerState {
        private float deltaXToModificationPoint;
        private HomeLight selectedLight;
        private float oldPower;
        private String lightPowerToolTipFeedback;

        private LightPowerModificationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.lightPowerToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "lightPowerToolTipFeedback", new Object[0]);
            this.selectedLight = (HomeLight)PlanController.this.home.getSelectedItems().get(0);
            float[] fArray = this.selectedLight.getPoints()[3];
            this.deltaXToModificationPoint = PlanController.this.getXLastMousePress() - fArray[0];
            this.oldPower = this.selectedLight.getPower();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldPower), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float[] fArray = this.selectedLight.getPoints()[3];
            float f3 = f - this.deltaXToModificationPoint - fArray[0];
            float f4 = this.oldPower + f3 / 100.0f * PlanController.this.getScale();
            f4 = Math.min(Math.max(f4, 0.0f), 1.0f);
            this.selectedLight.setPower(f4);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postLightPowerModification(this.selectedLight, this.oldPower);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedLight.setPower(this.oldPower);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedLight = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.lightPowerToolTipFeedback, Math.round(f * 100.0f));
        }
    }

    private class PieceOfFurnitureResizeState
    extends ControllerState {
        private boolean magnetismEnabled;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private ResizedPieceOfFurniture resizedPiece;
        private float[] topLeftPoint;
        private String widthResizeToolTipFeedback;
        private String depthResizeToolTipFeedback;

        private PieceOfFurnitureResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.widthResizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "widthResizeToolTipFeedback", new Object[0]);
            this.depthResizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "depthResizeToolTipFeedback", new Object[0]);
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.resizedPiece = new ResizedPieceOfFurniture(homePieceOfFurniture);
            float[][] fArray = homePieceOfFurniture.getPoints();
            float[] fArray2 = fArray[2];
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - fArray2[0];
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - fArray2[1];
            this.topLeftPoint = fArray[0];
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasShiftDownLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getDepth()), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3;
            float f4;
            PlanView planView = PlanController.this.getView();
            HomePieceOfFurniture homePieceOfFurniture = this.resizedPiece.getPieceOfFurniture();
            float f5 = homePieceOfFurniture.getAngle();
            double d = Math.cos(f5);
            double d2 = Math.sin(f5);
            float f6 = f - this.deltaXToResizePoint - this.topLeftPoint[0];
            float f7 = f2 - this.deltaYToResizePoint - this.topLeftPoint[1];
            float f8 = (float)((double)f7 * d2 + (double)f6 * d);
            if (this.magnetismEnabled) {
                f8 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f8, planView.getPixelLength());
            }
            f8 = Math.max(f8, PlanController.this.preferences.getLengthUnit().getMinimumLength());
            if (!(this.resizedPiece.isDoorOrWindowBoundToWall() && homePieceOfFurniture.isDeformable() && this.magnetismEnabled)) {
                f4 = (float)((double)f7 * d - (double)f6 * d2);
                if (this.magnetismEnabled) {
                    f4 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f4, planView.getPixelLength());
                }
                f4 = Math.max(f4, PlanController.this.preferences.getLengthUnit().getMinimumLength());
            } else {
                f4 = this.resizedPiece.getDepth();
            }
            float f9 = this.resizedPiece.getHeight();
            if (!homePieceOfFurniture.isDeformable()) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                if (Line2D.relativeCCW(fArray[0][0], fArray[0][1], fArray[2][0], fArray[2][1], f, f2) >= 0) {
                    f3 = f8 / this.resizedPiece.getWidth();
                    f4 = this.resizedPiece.getDepth() * f3;
                } else {
                    f3 = f4 / this.resizedPiece.getDepth();
                    f8 = this.resizedPiece.getWidth() * f3;
                }
                f9 = this.resizedPiece.getHeight() * f3;
            }
            float f10 = (float)((double)this.topLeftPoint[0] + ((double)f8 * d - (double)f4 * d2) / 2.0);
            f3 = (float)((double)this.topLeftPoint[1] + ((double)f8 * d2 + (double)f4 * d) / 2.0);
            homePieceOfFurniture.setX(f10);
            homePieceOfFurniture.setY(f3);
            homePieceOfFurniture.setWidth(f8);
            homePieceOfFurniture.setDepth(f4);
            homePieceOfFurniture.setHeight(f9);
            if (this.resizedPiece.isDoorOrWindowBoundToWall()) {
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(this.magnetismEnabled);
            }
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f8, f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureWidthAndDepthResize(this.resizedPiece);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.resizedPiece.reset();
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.resizedPiece = null;
        }

        private String getToolTipFeedbackText(float f, float f2) {
            String string = "<html>" + String.format(this.widthResizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
            if (!(this.resizedPiece.getPieceOfFurniture() instanceof HomeDoorOrWindow) || !((HomeDoorOrWindow)this.resizedPiece.getPieceOfFurniture()).isBoundToWall()) {
                string = string + "<br>" + String.format(this.depthResizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f2)));
            }
            return string;
        }
    }

    private class PieceOfFurnitureHeightState
    extends ControllerState {
        private boolean magnetismEnabled;
        private float deltaYToResizePoint;
        private ResizedPieceOfFurniture resizedPiece;
        private float[] topLeftPoint;
        private float[] resizePoint;
        private String resizeToolTipFeedback;

        private PieceOfFurnitureHeightState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.resizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "heightResizeToolTipFeedback", new Object[0]);
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.resizedPiece = new ResizedPieceOfFurniture(homePieceOfFurniture);
            float[][] fArray = homePieceOfFurniture.getPoints();
            this.resizePoint = fArray[3];
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.resizePoint[1];
            this.topLeftPoint = fArray[0];
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasShiftDownLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(homePieceOfFurniture.getHeight()), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            HomePieceOfFurniture homePieceOfFurniture = this.resizedPiece.getPieceOfFurniture();
            float f3 = f2 - this.deltaYToResizePoint - this.resizePoint[1];
            float f4 = this.resizedPiece.getHeight() - f3;
            f4 = Math.max(f4, 0.0f);
            if (this.magnetismEnabled) {
                f4 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f4, planView.getPixelLength());
            }
            f4 = Math.max(f4, PlanController.this.preferences.getLengthUnit().getMinimumLength());
            homePieceOfFurniture.setHeight(f4);
            if (!homePieceOfFurniture.isDeformable()) {
                float f5 = f4 / this.resizedPiece.getHeight();
                float f6 = this.resizedPiece.getWidth() * f5;
                float f7 = this.resizedPiece.getDepth() * f5;
                float f8 = homePieceOfFurniture.getAngle();
                double d = Math.cos(f8);
                double d2 = Math.sin(f8);
                float f9 = (float)((double)this.topLeftPoint[0] + ((double)f6 * d - (double)f7 * d2) / 2.0);
                float f10 = (float)((double)this.topLeftPoint[1] + ((double)f6 * d2 + (double)f7 * d) / 2.0);
                homePieceOfFurniture.setX(f9);
                homePieceOfFurniture.setY(f10);
                homePieceOfFurniture.setWidth(f6);
                homePieceOfFurniture.setDepth(f7);
            }
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureHeightResize(this.resizedPiece);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.resizedPiece.reset();
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.resizedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.resizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class PieceOfFurnitureElevationState
    extends ControllerState {
        private boolean magnetismEnabled;
        private float deltaYToElevationPoint;
        private HomePieceOfFurniture selectedPiece;
        private float oldElevation;
        private String elevationToolTipFeedback;

        private PieceOfFurnitureElevationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.elevationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "elevationToolTipFeedback", new Object[0]);
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            float[] fArray = this.selectedPiece.getPoints()[1];
            this.deltaYToElevationPoint = PlanController.this.getYLastMousePress() - fArray[1];
            this.oldElevation = this.selectedPiece.getElevation();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasShiftDownLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldElevation), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float[] fArray = this.selectedPiece.getPoints()[1];
            float f3 = f2 - this.deltaYToElevationPoint - fArray[1];
            float f4 = this.oldElevation - f3;
            f4 = Math.max(f4, 0.0f);
            if (this.magnetismEnabled) {
                f4 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f4, planView.getPixelLength());
            }
            this.selectedPiece.setElevation(f4);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureElevation(this.selectedPiece, this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedPiece.setElevation(this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.elevationToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class PieceOfFurnitureRotationState
    extends ControllerState {
        private static final int STEP_COUNT = 24;
        private boolean magnetismEnabled;
        private HomePieceOfFurniture selectedPiece;
        private float angleMousePress;
        private float oldAngle;
        private boolean doorOrWindowBoundToWall;
        private String rotationToolTipFeedback;

        private PieceOfFurnitureRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "rotationToolTipFeedback", new Object[0]);
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedPiece.getY() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedPiece.getX());
            this.oldAngle = this.selectedPiece.getAngle();
            this.doorOrWindowBoundToWall = this.selectedPiece instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)this.selectedPiece).isBoundToWall();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasShiftDownLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldAngle), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedPiece.getX() || f2 != this.selectedPiece.getY()) {
                float f3 = (float)Math.atan2(this.selectedPiece.getY() - f2, f - this.selectedPiece.getX());
                float f4 = this.oldAngle - f3 + this.angleMousePress;
                if (this.magnetismEnabled) {
                    float f5 = 0.2617994f;
                    f4 = (float)Math.round(f4 / f5) * f5;
                }
                this.selectedPiece.setAngle(f4);
                PlanView planView = PlanController.this.getView();
                planView.makePointVisible(f, f2);
                planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureRotation(this.selectedPiece, this.oldAngle, this.doorOrWindowBoundToWall);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedPiece.setAngle(this.oldAngle);
            if (this.selectedPiece instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)this.selectedPiece).setBoundToWall(this.doorOrWindowBoundToWall);
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, (Math.round(Math.toDegrees(f)) + 360L) % 360L);
        }
    }

    private class WallResizeState
    extends AbstractWallState {
        private Wall selectedWall;
        private boolean startPoint;
        private float oldX;
        private float oldY;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private boolean magnetismEnabled;

        private WallResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            super.enter();
            this.selectedWall = (Wall)PlanController.this.home.getSelectedItems().get(0);
            boolean bl = this.startPoint = this.selectedWall == PlanController.this.getResizedWallStartAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            if (this.startPoint) {
                this.oldX = this.selectedWall.getXStart();
                this.oldY = this.selectedWall.getYStart();
            } else {
                this.oldX = this.selectedWall.getXEnd();
                this.oldY = this.selectedWall.getYEnd();
            }
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - this.oldX;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.oldY;
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedWall, true), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            planView.setAlignmentFeedback(Wall.class, this.selectedWall, this.oldX, this.oldY, false);
            this.showWallAngleFeedback(this.selectedWall, true);
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToResizePoint;
            float f4 = f2 - this.deltaYToResizePoint;
            if (this.magnetismEnabled) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.startPoint ? this.selectedWall.getXEnd() : this.selectedWall.getXStart(), this.startPoint ? this.selectedWall.getYEnd() : this.selectedWall.getYStart(), f3, f4, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f3 = pointWithAngleMagnetism.getX();
                f4 = pointWithAngleMagnetism.getY();
            }
            PlanController.this.moveWallPoint(this.selectedWall, f3, f4, this.startPoint);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedWall, true), f, f2);
            planView.setAlignmentFeedback(Wall.class, this.selectedWall, f3, f4, false);
            this.showWallAngleFeedback(this.selectedWall, true);
            planView.makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postWallResize(this.selectedWall, this.oldX, this.oldY, this.startPoint);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            PlanController.this.moveWallPoint(this.selectedWall, this.oldX, this.oldY, this.startPoint);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedWall = null;
        }
    }

    private class WallDrawingState
    extends AbstractWallState {
        private float xStart;
        private float yStart;
        private float xLastEnd;
        private float yLastEnd;
        private Wall wallStartAtStart;
        private Wall wallEndAtStart;
        private Wall newWall;
        private Wall wallStartAtEnd;
        private Wall wallEndAtEnd;
        private Wall lastWall;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private List<Wall> newWalls;
        private boolean magnetismEnabled;
        private boolean roundWall;
        private long lastWallCreationTime;
        private Float wallArcExtent;

        private WallDrawingState() {
        }

        public Mode getMode() {
            return Mode.WALL_CREATION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            super.enter();
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.xStart = PlanController.this.getXLastMousePress();
            this.yStart = PlanController.this.getYLastMousePress();
            this.wallEndAtStart = PlanController.this.getWallEndAt(this.xStart, this.yStart, null);
            if (this.wallEndAtStart != null) {
                this.wallStartAtStart = null;
                this.xStart = this.wallEndAtStart.getXEnd();
                this.yStart = this.wallEndAtStart.getYEnd();
            } else {
                this.wallStartAtStart = PlanController.this.getWallStartAt(this.xStart, this.yStart, null);
                if (this.wallStartAtStart != null) {
                    this.xStart = this.wallStartAtStart.getXStart();
                    this.yStart = this.wallStartAtStart.getYStart();
                }
            }
            this.newWall = null;
            this.wallStartAtEnd = null;
            this.wallEndAtEnd = null;
            this.lastWall = null;
            this.newWalls = new ArrayList<Wall>();
            this.lastWallCreationTime = -1L;
            PlanController.this.deselectAll();
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            this.setDuplicationActivated(PlanController.this.wasDuplicationActivatedLastMousePress());
            PlanView planView = PlanController.this.getView();
            planView.setAlignmentFeedback(Wall.class, null, this.xStart, this.yStart, false);
        }

        public void moveMouse(float f, float f2) {
            float f3;
            float f4;
            Object object;
            PlanView planView = PlanController.this.getView();
            if (this.magnetismEnabled) {
                object = new PointWithAngleMagnetism(this.xStart, this.yStart, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f4 = ((PointWithAngleMagnetism)object).getX();
                f3 = ((PointWithAngleMagnetism)object).getY();
            } else {
                f4 = f;
                f3 = f2;
            }
            if (this.newWall == null) {
                this.newWall = PlanController.this.createWall(this.xStart, this.yStart, f4, f3, this.wallStartAtStart, this.wallEndAtStart);
                this.newWalls.add(this.newWall);
            } else if (this.wallArcExtent != null) {
                object = this.getCircumscribedCircleCenter(this.newWall.getXStart(), this.newWall.getYStart(), this.newWall.getXEnd(), this.newWall.getYEnd(), f, f2);
                double d = Point2D.distance(this.newWall.getXStart(), this.newWall.getYStart(), this.newWall.getXEnd(), this.newWall.getYEnd()) / 2.0;
                double d2 = Float.isInfinite((float)object[0]) || Float.isInfinite((float)object[1]) ? Double.POSITIVE_INFINITY : Line2D.ptLineDist(this.newWall.getXStart(), this.newWall.getYStart(), this.newWall.getXEnd(), this.newWall.getYEnd(), (double)object[0], (double)object[1]);
                int n = Line2D.relativeCCW(this.newWall.getXStart(), this.newWall.getYStart(), this.newWall.getXEnd(), this.newWall.getYEnd(), f, f2);
                int n2 = Line2D.relativeCCW(this.newWall.getXStart(), this.newWall.getYStart(), this.newWall.getXEnd(), this.newWall.getYEnd(), (double)object[0], (double)object[1]);
                this.wallArcExtent = n2 == n ? Float.valueOf((float)(Math.PI + 2.0 * Math.atan2(d2, d))) : Float.valueOf((float)(2.0 * Math.atan2(d, d2)));
                this.wallArcExtent = Float.valueOf(Math.min(this.wallArcExtent.floatValue(), 4.712389f));
                WallDrawingState wallDrawingState = this;
                wallDrawingState.wallArcExtent = Float.valueOf(wallDrawingState.wallArcExtent.floatValue() * (float)n);
                if (this.magnetismEnabled) {
                    this.wallArcExtent = Float.valueOf((float)Math.toRadians(Math.round(Math.toDegrees(this.wallArcExtent.floatValue()))));
                }
                this.newWall.setArcExtent(this.wallArcExtent);
            } else {
                this.newWall.setXEnd(f4);
                this.newWall.setYEnd(f3);
            }
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.newWall, false), f, f2);
            planView.setAlignmentFeedback(Wall.class, this.newWall, f4, f3, false);
            this.showWallAngleFeedback(this.newWall, false);
            this.wallStartAtEnd = PlanController.this.getWallStartAt(f4, f3, this.newWall);
            if (this.wallStartAtEnd != null) {
                this.wallEndAtEnd = null;
                PlanController.this.selectItem(this.wallStartAtEnd);
            } else {
                this.wallEndAtEnd = PlanController.this.getWallEndAt(f4, f3, this.newWall);
                if (this.wallEndAtEnd != null) {
                    PlanController.this.selectItem(this.wallEndAtEnd);
                } else {
                    PlanController.this.deselectAll();
                }
            }
            planView.makePointVisible(f, f2);
            this.xLastEnd = f4;
            this.yLastEnd = f3;
        }

        private float[] getCircumscribedCircleCenter(float f, float f2, float f3, float f4, float f5, float f6) {
            float[][] fArray = this.getBissectorLine(f, f2, f3, f4);
            float[][] fArray2 = this.getBissectorLine(f, f2, f5, f6);
            float[] fArray3 = PlanController.this.computeIntersection(fArray[0], fArray[1], fArray2[0], fArray2[1]);
            return fArray3;
        }

        private float[][] getBissectorLine(float f, float f2, float f3, float f4) {
            float f5 = (f + f3) / 2.0f;
            float f6 = (f2 + f4) / 2.0f;
            float f7 = (f - f3) / (f4 - f2);
            if ((double)f7 > 1.0E10) {
                return new float[][]{{f5, f6}, {f5, f6 + 1.0f}};
            }
            return new float[][]{{f5, f6}, {f5 + 1.0f, f7 + f6}};
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 2) {
                Selectable selectable = PlanController.this.getSelectableItemAt(f, f2);
                if (this.newWalls.size() == 0 && selectable instanceof Room) {
                    this.createWallsAroundRoom((Room)selectable);
                } else {
                    if (this.roundWall && this.newWall != null) {
                        this.endWallCreation();
                    }
                    if (this.lastWall != null) {
                        PlanController.this.joinNewWallEndToWall(this.lastWall, this.wallStartAtEnd, this.wallEndAtEnd);
                    }
                }
                this.validateDrawnWalls();
            } else if (this.newWall != null && this.newWall.getStartPointToEndPointDistance() > 0.0f) {
                if (this.roundWall && this.wallArcExtent == null) {
                    this.wallArcExtent = Float.valueOf((float)Math.PI);
                    this.newWall.setArcExtent(this.wallArcExtent);
                    PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(this.newWall, false), f, f2);
                } else {
                    PlanController.this.getView().deleteToolTipFeedback();
                    PlanController.this.selectItem(this.newWall);
                    this.endWallCreation();
                }
            }
        }

        private void createWallsAroundRoom(Room room) {
            if (room.isSingular()) {
                Object object;
                Object object2;
                Object object3;
                float[][] fArray = room.getPoints();
                ArrayList arrayList = new ArrayList(Arrays.asList(fArray));
                if (!room.isClockwise()) {
                    Collections.reverse(arrayList);
                }
                int n = 0;
                while (n < arrayList.size()) {
                    float[] fArray2;
                    object3 = (float[])arrayList.get(n);
                    if (object3[0] == (fArray2 = (float[])arrayList.get((n + 1) % arrayList.size()))[0] && object3[1] == fArray2[1]) {
                        arrayList.remove(n);
                        continue;
                    }
                    ++n;
                }
                fArray = (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
                float f = PlanController.this.preferences.getNewWallThickness() / 2.0f;
                object3 = new float[fArray.length][];
                for (int i = 0; i < fArray.length; ++i) {
                    float[] fArray3 = fArray[i];
                    object2 = fArray[(i + fArray.length - 1) % fArray.length];
                    object = fArray[(i + 1) % fArray.length];
                    double d = Math.atan2(fArray3[0] - object2[0], (double)(object2[1] - fArray3[1]));
                    float f2 = (float)(Math.cos(d) * (double)f);
                    float f3 = (float)(Math.sin(d) * (double)f);
                    float[] fArray4 = new float[]{object2[0] - f2, object2[1] - f3};
                    float[] fArray5 = new float[]{fArray3[0] - f2, fArray3[1] - f3};
                    double d2 = Math.atan2((double)(object[0] - fArray3[0]), fArray3[1] - object[1]);
                    f2 = (float)(Math.cos(d2) * (double)f);
                    f3 = (float)(Math.sin(d2) * (double)f);
                    float[] fArray6 = new float[]{fArray3[0] - f2, fArray3[1] - f3};
                    float[] fArray7 = new float[]{object[0] - f2, object[1] - f3};
                    object3[i] = (float)PlanController.this.computeIntersection(fArray4, fArray5, fArray6, fArray7);
                }
                Wall wall = null;
                for (int i = 0; i < ((float[])object3).length; ++i) {
                    object2 = object3[i];
                    object = object3[(i + 1) % fArray.length];
                    Wall wall2 = PlanController.this.createWall((float)object2[0], (float)object2[1], (float)object[0], (float)object[1], null, wall);
                    this.newWalls.add(wall2);
                    wall = wall2;
                }
                PlanController.this.joinNewWallEndToWall(wall, this.newWalls.get(0), null);
            }
        }

        private void validateDrawnWalls() {
            if (this.newWalls.size() > 0) {
                PlanController.this.postCreateWalls(this.newWalls, this.oldSelection, this.oldBasePlanLocked);
                PlanController.this.selectItems(this.newWalls);
            }
            PlanController.this.setState(PlanController.this.getWallCreationState());
        }

        private void endWallCreation() {
            this.lastWall = this.wallEndAtStart = this.newWall;
            this.wallStartAtStart = null;
            this.xStart = this.newWall.getXEnd();
            this.yStart = this.newWall.getYEnd();
            this.newWall = null;
            this.wallArcExtent = null;
        }

        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newWalls.size() == 0 && this.wallEndAtStart == null && this.wallStartAtStart == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xStart), Float.valueOf(this.yStart)}, this.xStart, this.yStart);
                } else {
                    if (this.newWall == null) {
                        this.createNextWall();
                    }
                    if (this.wallArcExtent == null) {
                        planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE, EditableProperty.THICKNESS}, new Object[]{Float.valueOf(this.newWall.getLength()), this.getWallAngleInDegrees(this.newWall), Float.valueOf(this.newWall.getThickness())}, this.newWall.getXEnd(), this.newWall.getYEnd());
                    } else {
                        planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.ARC_EXTENT}, new Object[]{new Integer((int)Math.round(Math.toDegrees(this.wallArcExtent.floatValue())))}, this.newWall.getXEnd(), this.newWall.getYEnd());
                    }
                }
            } else if (this.newWall == null) {
                float f = PlanController.this.preferences.getLengthUnit() == LengthUnit.INCH ? LengthUnit.footToCentimeter(10.0f) : 300.0f;
                this.xLastEnd = this.xStart + f;
                this.yLastEnd = this.yStart;
                this.newWall = PlanController.this.createWall(this.xStart, this.yStart, this.xLastEnd, this.yLastEnd, this.wallStartAtStart, this.wallEndAtStart);
                this.newWalls.add(this.newWall);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (this.roundWall && this.wallArcExtent == null) {
                this.wallArcExtent = Float.valueOf((float)Math.PI);
                this.newWall.setArcExtent(this.wallArcExtent);
                this.setEditionActivated(true);
            } else if (System.currentTimeMillis() - this.lastWallCreationTime < 300L) {
                if (this.newWalls.size() > 1) {
                    this.newWalls.remove(this.newWall);
                    PlanController.this.home.deleteWall(this.newWall);
                }
                this.validateDrawnWalls();
            } else {
                this.endWallCreation();
                if (this.newWalls.size() > 2 && this.wallStartAtEnd != null) {
                    PlanController.this.joinNewWallEndToWall(this.lastWall, this.wallStartAtEnd, null);
                    this.validateDrawnWalls();
                    return;
                }
                this.createNextWall();
                planView.deleteToolTipFeedback();
                this.setEditionActivated(true);
            }
        }

        private void createNextWall() {
            Wall wall = this.wallEndAtStart != null ? this.wallEndAtStart : this.wallStartAtStart;
            double d = Math.PI - Math.atan2(wall.getYStart() - wall.getYEnd(), wall.getXStart() - wall.getXEnd());
            float f = wall.getStartPointToEndPointDistance();
            this.xLastEnd = (float)((double)this.xStart + (double)f * Math.cos(d -= 1.5707963267948966));
            this.yLastEnd = (float)((double)this.yStart - (double)f * Math.sin(d));
            this.newWall = PlanController.this.createWall(this.xStart, this.yStart, this.xLastEnd, this.yLastEnd, this.wallStartAtStart, wall);
            this.newWall.setThickness(wall.getThickness());
            this.newWalls.add(this.newWall);
            this.lastWallCreationTime = System.currentTimeMillis();
            PlanController.this.deselectAll();
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            PlanView planView = PlanController.this.getView();
            if (this.newWall == null) {
                switch (editableProperty) {
                    case X: {
                        this.xStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xStart = Math.max(-100000.0f, Math.min(this.xStart, 100000.0f));
                        break;
                    }
                    case Y: {
                        this.yStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yStart = Math.max(-100000.0f, Math.min(this.yStart, 100000.0f));
                    }
                }
                planView.setAlignmentFeedback(Wall.class, null, this.xStart, this.yStart, true);
                planView.makePointVisible(this.xStart, this.yStart);
            } else if (editableProperty == EditableProperty.THICKNESS) {
                float f = object != null ? Math.abs(((Number)object).floatValue()) : 0.0f;
                f = Math.max(0.01f, Math.min(f, 1000.0f));
                this.newWall.setThickness(f);
            } else if (editableProperty == EditableProperty.ARC_EXTENT) {
                double d = Math.toRadians(object != null ? ((Number)object).doubleValue() : 0.0);
                this.wallArcExtent = Float.valueOf((float)(Math.signum(d) * Math.min(Math.abs(d), 4.71238898038469)));
                this.newWall.setArcExtent(this.wallArcExtent);
                this.showWallAngleFeedback(this.newWall, false);
            } else {
                switch (editableProperty) {
                    case LENGTH: {
                        float f = object != null ? ((Number)object).floatValue() : 0.0f;
                        f = Math.max(0.001f, Math.min(f, 100000.0f));
                        double d = Math.PI - Math.atan2(this.yStart - this.yLastEnd, this.xStart - this.xLastEnd);
                        this.xLastEnd = (float)((double)this.xStart + (double)f * Math.cos(d));
                        this.yLastEnd = (float)((double)this.yStart - (double)f * Math.sin(d));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? ((Number)object).doubleValue() : 0.0);
                        Wall wall = this.newWall.getWallAtStart();
                        if (wall != null && wall.getStartPointToEndPointDistance() > 0.0f) {
                            d -= Math.atan2(wall.getYStart() - wall.getYEnd(), wall.getXStart() - wall.getXEnd());
                        }
                        float f = this.newWall.getStartPointToEndPointDistance();
                        this.xLastEnd = (float)((double)this.xStart + (double)f * Math.cos(d));
                        this.yLastEnd = (float)((double)this.yStart - (double)f * Math.sin(d));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.newWall.setXEnd(this.xLastEnd);
                this.newWall.setYEnd(this.yLastEnd);
                planView.setAlignmentFeedback(Wall.class, this.newWall, this.xLastEnd, this.yLastEnd, false);
                this.showWallAngleFeedback(this.newWall, false);
                planView.makePointVisible(this.xStart, this.yStart);
                planView.makePointVisible(this.xLastEnd, this.yLastEnd);
                if (this.newWalls.size() > 2 && this.newWalls.get(0).getWallAtStart() == null && this.newWalls.get(0).containsWallStartAt(this.xLastEnd, this.yLastEnd, 0.001f)) {
                    this.wallStartAtEnd = this.newWalls.get(0);
                    PlanController.this.selectItem(this.wallStartAtEnd);
                } else {
                    this.wallStartAtEnd = null;
                    PlanController.this.deselectAll();
                }
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newWall != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void setDuplicationActivated(boolean bl) {
            this.roundWall = bl;
        }

        public void escape() {
            if (this.newWall != null) {
                PlanController.this.home.deleteWall(this.newWall);
                this.newWalls.remove(this.newWall);
            }
            this.validateDrawnWalls();
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.deleteFeedback();
            this.wallStartAtStart = null;
            this.wallEndAtStart = null;
            this.newWall = null;
            this.wallArcExtent = null;
            this.wallStartAtEnd = null;
            this.wallEndAtEnd = null;
            this.lastWall = null;
            this.oldSelection = null;
            this.newWalls = null;
        }
    }

    private abstract class AbstractWallState
    extends ControllerState {
        private String wallLengthToolTipFeedback;
        private String wallAngleToolTipFeedback;
        private String wallArcExtentToolTipFeedback;
        private String wallThicknessToolTipFeedback;

        private AbstractWallState() {
        }

        public void enter() {
            this.wallLengthToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallLengthToolTipFeedback", new Object[0]);
            this.wallAngleToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallAngleToolTipFeedback", new Object[0]);
            this.wallArcExtentToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallArcExtentToolTipFeedback", new Object[0]);
            this.wallThicknessToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallThicknessToolTipFeedback", new Object[0]);
        }

        protected String getToolTipFeedbackText(Wall wall, boolean bl) {
            Float f = wall.getArcExtent();
            if (!bl && f != null) {
                return "<html>" + String.format(this.wallArcExtentToolTipFeedback, Math.round(Math.toDegrees(f.floatValue())));
            }
            float f2 = wall.getStartPointToEndPointDistance();
            return "<html>" + String.format(this.wallLengthToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f2))) + "<br>" + String.format(this.wallAngleToolTipFeedback, this.getWallAngleInDegrees(wall, f2)) + "<br>" + String.format(this.wallThicknessToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(wall.getThickness())));
        }

        protected Integer getWallAngleInDegrees(Wall wall) {
            return this.getWallAngleInDegrees(wall, wall.getStartPointToEndPointDistance());
        }

        private Integer getWallAngleInDegrees(Wall wall, float f) {
            Wall wall2 = wall.getWallAtStart();
            if (wall2 != null) {
                float f2 = wall2.getStartPointToEndPointDistance();
                if (f != 0.0f && f2 != 0.0f) {
                    int n;
                    float f3 = (wall.getXEnd() - wall.getXStart()) / f;
                    float f4 = (wall.getYEnd() - wall.getYStart()) / f;
                    float f5 = (wall2.getXEnd() - wall2.getXStart()) / f2;
                    float f6 = (wall2.getYEnd() - wall2.getYStart()) / f2;
                    if (wall2.getWallAtStart() == wall) {
                        f5 = -f5;
                        f6 = -f6;
                    }
                    if ((n = (int)Math.round(180.0 - Math.toDegrees(Math.atan2(f4 * f5 - f3 * f6, f3 * f5 + f4 * f6)))) > 180) {
                        n -= 360;
                    }
                    return n;
                }
            }
            if (f == 0.0f) {
                return 0;
            }
            return (int)Math.round(Math.toDegrees(Math.atan2(wall.getYStart() - wall.getYEnd(), wall.getXEnd() - wall.getXStart())));
        }

        protected void showWallAngleFeedback(Wall wall, boolean bl) {
            Float f = wall.getArcExtent();
            if (!bl && f != null) {
                if (f.floatValue() < 0.0f) {
                    PlanController.this.getView().setAngleFeedback(wall.getXArcCircleCenter(), wall.getYArcCircleCenter(), wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd());
                } else {
                    PlanController.this.getView().setAngleFeedback(wall.getXArcCircleCenter(), wall.getYArcCircleCenter(), wall.getXEnd(), wall.getYEnd(), wall.getXStart(), wall.getYStart());
                }
            } else {
                Wall wall2 = wall.getWallAtStart();
                if (wall2 != null) {
                    if (wall2.getWallAtStart() == wall) {
                        if (this.getWallAngleInDegrees(wall) > 0) {
                            PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall2.getXEnd(), wall2.getYEnd(), wall.getXEnd(), wall.getYEnd());
                        } else {
                            PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), wall2.getXEnd(), wall2.getYEnd());
                        }
                    } else if (this.getWallAngleInDegrees(wall) > 0) {
                        PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall2.getXStart(), wall2.getYStart(), wall.getXEnd(), wall.getYEnd());
                    } else {
                        PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), wall2.getXStart(), wall2.getYStart());
                    }
                }
            }
        }
    }

    private class WallCreationState
    extends AbstractModeChangeState {
        private WallCreationState() {
        }

        public Mode getMode() {
            return Mode.WALL_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
        }

        public void moveMouse(float f, float f2) {
            PlanController.this.getView().setAlignmentFeedback(Wall.class, null, f, f2, false);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.setState(PlanController.this.getWallDrawingState());
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getWallDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class DragAndDropState
    extends ControllerState {
        private float xLastMouseMove;
        private float yLastMouseMove;
        private HomePieceOfFurniture draggedPieceOfFurniture;
        private float xDraggedPieceOfFurniture;
        private float yDraggedPieceOfFurniture;
        private float angleDraggedPieceOfFurniture;
        private float depthDraggedPieceOfFurniture;
        private float elevationDraggedPieceOfFurniture;

        private DragAndDropState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return false;
        }

        public void enter() {
            this.xLastMouseMove = 0.0f;
            this.yLastMouseMove = 0.0f;
            PlanController.this.getView().setDraggedItemsFeedback(PlanController.this.draggedItems);
            if (PlanController.this.draggedItems.size() == 1 && PlanController.this.draggedItems.get(0) instanceof HomePieceOfFurniture) {
                this.draggedPieceOfFurniture = (HomePieceOfFurniture)PlanController.this.draggedItems.get(0);
                this.xDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getX();
                this.yDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getY();
                this.angleDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getAngle();
                this.depthDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getDepth();
                this.elevationDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getElevation();
            }
        }

        public void moveMouse(float f, float f2) {
            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(PlanController.this.draggedItems);
            PlanController.this.moveItems(PlanController.this.draggedItems, f - this.xLastMouseMove, f2 - this.yLastMouseMove);
            if (this.draggedPieceOfFurniture != null && PlanController.this.preferences.isMagnetismEnabled()) {
                this.draggedPieceOfFurniture.setX(this.xDraggedPieceOfFurniture);
                this.draggedPieceOfFurniture.setY(this.yDraggedPieceOfFurniture);
                this.draggedPieceOfFurniture.setAngle(this.angleDraggedPieceOfFurniture);
                if (this.draggedPieceOfFurniture.isResizable()) {
                    this.draggedPieceOfFurniture.setDepth(this.depthDraggedPieceOfFurniture);
                }
                this.draggedPieceOfFurniture.setElevation(this.elevationDraggedPieceOfFurniture);
                this.draggedPieceOfFurniture.move(f, f2);
                Wall wall = PlanController.this.adjustPieceOfFurnitureOnWallAt(this.draggedPieceOfFurniture, f, f2);
                if (wall != null) {
                    PlanController.this.getView().setDimensionLinesFeedback(PlanController.this.getDimensionLinesAlongWall(this.draggedPieceOfFurniture, wall));
                } else {
                    PlanController.this.getView().setDimensionLinesFeedback(null);
                }
                PlanController.this.adjustPieceOfFurnitureElevationAt(this.draggedPieceOfFurniture);
            }
            PlanController.this.getView().setDraggedItemsFeedback(arrayList);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
        }

        public void exit() {
            this.draggedPieceOfFurniture = null;
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class PanningState
    extends ControllerState {
        private Integer xLastMouseMove;
        private Integer yLastMouseMove;

        private PanningState() {
        }

        public Mode getMode() {
            return Mode.PANNING;
        }

        public void setMode(Mode mode) {
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.PANNING);
        }

        public void moveSelection(float f, float f2) {
            PlanController.this.getView().moveView(f * 10.0f, f2 * 10.0f);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 1) {
                this.xLastMouseMove = PlanController.this.getView().convertXModelToScreen(f);
                this.yLastMouseMove = PlanController.this.getView().convertYModelToScreen(f2);
            } else {
                this.xLastMouseMove = null;
                this.yLastMouseMove = null;
            }
        }

        public void moveMouse(float f, float f2) {
            if (this.xLastMouseMove != null) {
                int n = PlanController.this.getView().convertXModelToScreen(f);
                int n2 = PlanController.this.getView().convertYModelToScreen(f2);
                PlanController.this.getView().moveView((float)(this.xLastMouseMove - n) / PlanController.this.getScale(), (float)(this.yLastMouseMove - n2) / PlanController.this.getScale());
                this.xLastMouseMove = n;
                this.yLastMouseMove = n2;
            }
        }

        public void releaseMouse(float f, float f2) {
            this.xLastMouseMove = null;
        }

        public void escape() {
            this.xLastMouseMove = null;
        }

        public void zoom(float f) {
            PlanController.this.setScale(PlanController.this.getScale() * f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RectangleSelectionState
    extends ControllerState {
        private List<Selectable> selectedItemsMousePressed;
        private boolean mouseMoved;

        private RectangleSelectionState() {
        }

        @Override
        public Mode getMode() {
            return Mode.SELECTION;
        }

        @Override
        public boolean isModificationState() {
            return true;
        }

        @Override
        public void enter() {
            Selectable selectable = PlanController.this.getSelectableItemAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            if (selectable == null && !PlanController.this.wasShiftDownLastMousePress()) {
                PlanController.this.deselectAll();
            }
            this.selectedItemsMousePressed = new ArrayList<Selectable>(PlanController.this.home.getSelectedItems());
            this.mouseMoved = false;
        }

        @Override
        public void moveMouse(float f, float f2) {
            this.mouseMoved = true;
            this.updateSelectedItems(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2, this.selectedItemsMousePressed);
            PlanView planView = PlanController.this.getView();
            planView.setRectangleFeedback(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2);
            planView.makePointVisible(f, f2);
        }

        @Override
        public void releaseMouse(float f, float f2) {
            Selectable selectable;
            if (!this.mouseMoved && (selectable = PlanController.this.getSelectableItemAt(f, f2)) != null) {
                if (this.selectedItemsMousePressed.contains(selectable)) {
                    this.selectedItemsMousePressed.remove(selectable);
                } else {
                    Iterator<Selectable> iterator = this.selectedItemsMousePressed.iterator();
                    while (iterator.hasNext()) {
                        if (!(iterator.next() instanceof Camera)) continue;
                        iterator.remove();
                    }
                    if (!(selectable instanceof Camera) || this.selectedItemsMousePressed.size() == 0) {
                        this.selectedItemsMousePressed.add(selectable);
                    }
                }
                PlanController.this.selectItems(this.selectedItemsMousePressed);
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        @Override
        public void escape() {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        @Override
        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.selectedItemsMousePressed = null;
        }

        private void updateSelectedItems(float f, float f2, float f3, float f4, List<Selectable> list) {
            boolean bl = PlanController.this.wasShiftDownLastMousePress();
            ArrayList<Object> arrayList = bl ? new ArrayList<Selectable>(list) : new ArrayList();
            for (Selectable selectable : PlanController.this.getSelectableItemsIntersectingRectangle(f, f2, f3, f4)) {
                if (selectable instanceof Camera) continue;
                if (bl) {
                    if (list.contains(selectable)) {
                        arrayList.remove(selectable);
                        continue;
                    }
                    arrayList.add(selectable);
                    continue;
                }
                if (list.contains(selectable)) continue;
                arrayList.add(selectable);
            }
            PlanController.this.selectItems(arrayList);
        }
    }

    private class SelectionMoveState
    extends ControllerState {
        private float xLastMouseMove;
        private float yLastMouseMove;
        private boolean mouseMoved;
        private List<Selectable> oldSelection;
        private List<Selectable> movedItems;
        private List<Selectable> duplicatedItems;
        private HomePieceOfFurniture movedPieceOfFurniture;
        private float angleMovedPieceOfFurniture;
        private float depthMovedPieceOfFurniture;
        private float elevationMovedPieceOfFurniture;
        private float xMovedPieceOfFurniture;
        private float yMovedPieceOfFurniture;
        private boolean movedDoorOrWindowBoundToWall;
        private boolean magnetismEnabled;
        private boolean duplicationActivated;

        private SelectionMoveState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.mouseMoved = false;
            List<Selectable> list = PlanController.this.getSelectableItemsAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.toggleMagnetism(PlanController.this.wasShiftDownLastMousePress());
            if (Collections.disjoint(list, this.oldSelection)) {
                PlanController.this.selectItem(PlanController.this.getSelectableItemAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress()));
            }
            List<Selectable> list2 = PlanController.this.home.getSelectedItems();
            this.movedItems = new ArrayList<Selectable>(list2.size());
            for (Selectable selectable : list2) {
                if (!PlanController.this.isItemMovable(selectable)) continue;
                this.movedItems.add(selectable);
            }
            if (this.movedItems.size() == 1 && this.movedItems.get(0) instanceof HomePieceOfFurniture) {
                this.movedPieceOfFurniture = (HomePieceOfFurniture)this.movedItems.get(0);
                this.xMovedPieceOfFurniture = this.movedPieceOfFurniture.getX();
                this.yMovedPieceOfFurniture = this.movedPieceOfFurniture.getY();
                this.angleMovedPieceOfFurniture = this.movedPieceOfFurniture.getAngle();
                this.depthMovedPieceOfFurniture = this.movedPieceOfFurniture.getDepth();
                this.elevationMovedPieceOfFurniture = this.movedPieceOfFurniture.getElevation();
                this.movedDoorOrWindowBoundToWall = this.movedPieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)this.movedPieceOfFurniture).isBoundToWall();
            }
            this.duplicatedItems = null;
            this.duplicationActivated = PlanController.this.wasDuplicationActivatedLastMousePress();
        }

        public void moveMouse(float f, float f2) {
            if (!this.mouseMoved) {
                this.toggleDuplication(this.duplicationActivated);
            }
            if (this.movedPieceOfFurniture != null) {
                this.movedPieceOfFurniture.setX(this.xMovedPieceOfFurniture);
                this.movedPieceOfFurniture.setY(this.yMovedPieceOfFurniture);
                this.movedPieceOfFurniture.setAngle(this.angleMovedPieceOfFurniture);
                if (this.movedPieceOfFurniture.isResizable() && PlanController.this.isItemResizable(this.movedPieceOfFurniture)) {
                    this.movedPieceOfFurniture.setDepth(this.depthMovedPieceOfFurniture);
                }
                this.movedPieceOfFurniture.setElevation(this.elevationMovedPieceOfFurniture);
                this.movedPieceOfFurniture.move(f - PlanController.this.getXLastMousePress(), f2 - PlanController.this.getYLastMousePress());
                if (this.magnetismEnabled) {
                    Wall wall = PlanController.this.adjustPieceOfFurnitureOnWallAt(this.movedPieceOfFurniture, f, f2);
                    if (wall != null) {
                        PlanController.this.getView().setDimensionLinesFeedback(PlanController.this.getDimensionLinesAlongWall(this.movedPieceOfFurniture, wall));
                    } else {
                        PlanController.this.getView().setDimensionLinesFeedback(null);
                    }
                    PlanController.this.adjustPieceOfFurnitureElevationAt(this.movedPieceOfFurniture);
                }
            } else {
                PlanController.this.moveItems(this.movedItems, f - this.xLastMouseMove, f2 - this.yLastMouseMove);
            }
            if (!this.mouseMoved) {
                PlanController.this.selectItems(this.movedItems);
            }
            PlanController.this.getView().makePointVisible(f, f2);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            this.mouseMoved = true;
        }

        public void releaseMouse(float f, float f2) {
            if (this.mouseMoved) {
                if (this.movedItems.size() > 0 && !(this.movedItems.get(0) instanceof Camera)) {
                    if (this.duplicatedItems != null) {
                        PlanController.this.postItemsDuplication(this.movedItems, this.duplicatedItems);
                    } else if (this.movedPieceOfFurniture != null) {
                        PlanController.this.postPieceOfFurnitureMove(this.movedPieceOfFurniture, this.movedPieceOfFurniture.getX() - this.xMovedPieceOfFurniture, this.movedPieceOfFurniture.getY() - this.yMovedPieceOfFurniture, this.angleMovedPieceOfFurniture, this.depthMovedPieceOfFurniture, this.elevationMovedPieceOfFurniture, this.movedDoorOrWindowBoundToWall);
                    } else {
                        PlanController.this.postItemsMove(this.movedItems, this.oldSelection, this.xLastMouseMove - PlanController.this.getXLastMousePress(), this.yLastMouseMove - PlanController.this.getYLastMousePress());
                    }
                }
            } else {
                Selectable selectable = PlanController.this.getSelectableItemAt(f, f2);
                if (selectable != null) {
                    PlanController.this.selectItem(selectable);
                }
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.movedPieceOfFurniture != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                if (!this.magnetismEnabled) {
                    PlanController.this.getView().deleteFeedback();
                }
            }
        }

        public void escape() {
            if (this.mouseMoved) {
                if (this.duplicatedItems != null) {
                    PlanController.this.doDeleteItems(this.movedItems);
                    PlanController.this.selectItems(this.duplicatedItems);
                } else if (this.movedPieceOfFurniture != null) {
                    this.movedPieceOfFurniture.setX(this.xMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.setY(this.yMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.setAngle(this.angleMovedPieceOfFurniture);
                    if (this.movedPieceOfFurniture.isResizable() && PlanController.this.isItemResizable(this.movedPieceOfFurniture)) {
                        this.movedPieceOfFurniture.setDepth(this.depthMovedPieceOfFurniture);
                    }
                    this.movedPieceOfFurniture.setElevation(this.elevationMovedPieceOfFurniture);
                    if (this.movedPieceOfFurniture instanceof HomeDoorOrWindow) {
                        ((HomeDoorOrWindow)this.movedPieceOfFurniture).setBoundToWall(this.movedDoorOrWindowBoundToWall);
                    }
                } else {
                    PlanController.this.moveItems(this.movedItems, PlanController.this.getXLastMousePress() - this.xLastMouseMove, PlanController.this.getYLastMousePress() - this.yLastMouseMove);
                }
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void setDuplicationActivated(boolean bl) {
            if (this.mouseMoved) {
                this.toggleDuplication(bl);
            }
            this.duplicationActivated = bl;
        }

        private void toggleDuplication(boolean bl) {
            if (this.movedItems.size() > 1 || this.movedItems.size() == 1 && !(this.movedItems.get(0) instanceof Camera) && !(this.movedItems.get(0) instanceof Compass)) {
                if (bl && this.duplicatedItems == null) {
                    this.duplicatedItems = this.movedItems;
                    this.movedItems = Home.duplicate(this.movedItems);
                    for (Selectable selectable : this.movedItems) {
                        if (selectable instanceof Wall) {
                            PlanController.this.home.addWall((Wall)selectable);
                            continue;
                        }
                        if (selectable instanceof Room) {
                            PlanController.this.home.addRoom((Room)selectable);
                            continue;
                        }
                        if (selectable instanceof DimensionLine) {
                            PlanController.this.home.addDimensionLine((DimensionLine)selectable);
                            continue;
                        }
                        if (selectable instanceof HomePieceOfFurniture) {
                            PlanController.this.home.addPieceOfFurniture((HomePieceOfFurniture)selectable);
                            continue;
                        }
                        if (!(selectable instanceof Label)) continue;
                        PlanController.this.home.addLabel((Label)selectable);
                    }
                    if (this.movedPieceOfFurniture != null) {
                        this.movedPieceOfFurniture.setX(this.xMovedPieceOfFurniture);
                        this.movedPieceOfFurniture.setY(this.yMovedPieceOfFurniture);
                        this.movedPieceOfFurniture.setAngle(this.angleMovedPieceOfFurniture);
                        if (this.movedPieceOfFurniture.isResizable() && PlanController.this.isItemResizable(this.movedPieceOfFurniture)) {
                            this.movedPieceOfFurniture.setDepth(this.depthMovedPieceOfFurniture);
                        }
                        this.movedPieceOfFurniture.setElevation(this.elevationMovedPieceOfFurniture);
                        this.movedPieceOfFurniture = (HomePieceOfFurniture)this.movedItems.get(0);
                    } else {
                        PlanController.this.moveItems(this.duplicatedItems, PlanController.this.getXLastMousePress() - this.xLastMouseMove, PlanController.this.getYLastMousePress() - this.yLastMouseMove);
                    }
                    PlanController.this.getView().setCursor(PlanView.CursorType.DUPLICATION);
                } else if (!bl && this.duplicatedItems != null) {
                    PlanController.this.doDeleteItems(this.movedItems);
                    PlanController.this.moveItems(this.duplicatedItems, this.xLastMouseMove - PlanController.this.getXLastMousePress(), this.yLastMouseMove - PlanController.this.getYLastMousePress());
                    this.movedItems = this.duplicatedItems;
                    this.duplicatedItems = null;
                    if (this.movedPieceOfFurniture != null) {
                        this.movedPieceOfFurniture = (HomePieceOfFurniture)this.movedItems.get(0);
                    }
                    PlanController.this.getView().setCursor(PlanView.CursorType.SELECTION);
                }
                PlanController.this.selectItems(this.movedItems);
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.movedItems = null;
            this.duplicatedItems = null;
            this.movedPieceOfFurniture = null;
        }
    }

    private class SelectionState
    extends AbstractModeChangeState {
        private final SelectionListener selectionListener;

        private SelectionState() {
            this.selectionListener = new SelectionListener(){

                public void selectionChanged(SelectionEvent selectionEvent) {
                    List<Selectable> list = PlanController.this.home.getSelectedItems();
                    PlanController.this.getView().setResizeIndicatorVisible(list.size() == 1 && (PlanController.this.isItemResizable(list.get(0)) || PlanController.this.isItemMovable(list.get(0))));
                }
            };
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public void enter() {
            if (PlanController.this.getView() != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                PlanController.this.home.addSelectionListener(this.selectionListener);
                this.selectionListener.selectionChanged(null);
            }
        }

        public void moveMouse(float f, float f2) {
            if (PlanController.this.getYawRotatedCameraAt(f, f2) != null || PlanController.this.getPitchRotatedCameraAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getElevatedCameraAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ELEVATION);
            } else if (PlanController.this.getRoomNameAt(f, f2) != null || PlanController.this.getRoomAreaAt(f, f2) != null || PlanController.this.getResizedDimensionLineStartAt(f, f2) != null || PlanController.this.getResizedDimensionLineEndAt(f, f2) != null || PlanController.this.getWidthAndDepthResizedPieceOfFurnitureAt(f, f2) != null || PlanController.this.getResizedWallStartAt(f, f2) != null || PlanController.this.getResizedWallEndAt(f, f2) != null || PlanController.this.getResizedRoomAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else if (PlanController.this.getModifiedLightPowerAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.POWER);
            } else if (PlanController.this.getOffsetDimensionLineAt(f, f2) != null || PlanController.this.getHeightResizedPieceOfFurnitureAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.HEIGHT);
            } else if (PlanController.this.getRotatedPieceOfFurnitureAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getElevatedPieceOfFurnitureAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ELEVATION);
            } else if (PlanController.this.getPieceOfFurnitureNameAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else if (PlanController.this.getRotatedCompassAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getResizedCompassAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else {
                PlanController.this.getView().setCursor(PlanView.CursorType.SELECTION);
            }
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 1) {
                if (PlanController.this.getYawRotatedCameraAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCameraYawRotationState());
                } else if (PlanController.this.getPitchRotatedCameraAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCameraPitchRotationState());
                } else if (PlanController.this.getElevatedCameraAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCameraElevationState());
                } else if (PlanController.this.getRoomNameAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomNameOffsetState());
                } else if (PlanController.this.getRoomAreaAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomAreaOffsetState());
                } else if (PlanController.this.getResizedDimensionLineStartAt(f, f2) != null || PlanController.this.getResizedDimensionLineEndAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getDimensionLineResizeState());
                } else if (PlanController.this.getWidthAndDepthResizedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureResizeState());
                } else if (PlanController.this.getResizedWallStartAt(f, f2) != null || PlanController.this.getResizedWallEndAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getWallResizeState());
                } else if (PlanController.this.getResizedRoomAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomResizeState());
                } else if (PlanController.this.getOffsetDimensionLineAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getDimensionLineOffsetState());
                } else if (PlanController.this.getModifiedLightPowerAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getLightPowerModificationState());
                } else if (PlanController.this.getHeightResizedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureHeightState());
                } else if (PlanController.this.getRotatedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureRotationState());
                } else if (PlanController.this.getElevatedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureElevationState());
                } else if (PlanController.this.getPieceOfFurnitureNameAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureNameOffsetState());
                } else if (PlanController.this.getRotatedCompassAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCompassRotationState());
                } else if (PlanController.this.getResizedCompassAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCompassResizeState());
                } else {
                    Selectable selectable = PlanController.this.getSelectableItemAt(f, f2);
                    if (!bl && selectable != null) {
                        PlanController.this.setState(PlanController.this.getSelectionMoveState());
                    } else {
                        PlanController.this.setState(PlanController.this.getRectangleSelectionState());
                    }
                }
            } else if (n == 2) {
                Selectable selectable = PlanController.this.getSelectableItemAt(f, f2);
                if (!bl && selectable != null) {
                    if (selectable instanceof Wall) {
                        PlanController.this.modifySelectedWalls();
                    } else if (selectable instanceof HomePieceOfFurniture) {
                        PlanController.this.modifySelectedFurniture();
                    } else if (selectable instanceof Room) {
                        PlanController.this.modifySelectedRooms();
                    } else if (selectable instanceof Label) {
                        PlanController.this.modifySelectedLabels();
                    } else if (selectable instanceof Compass) {
                        PlanController.this.modifyCompass();
                    }
                }
            }
        }

        public void exit() {
            if (PlanController.this.getView() != null) {
                PlanController.this.home.removeSelectionListener(this.selectionListener);
                PlanController.this.getView().setResizeIndicatorVisible(false);
            }
        }
    }

    private abstract class AbstractModeChangeState
    extends ControllerState {
        private AbstractModeChangeState() {
        }

        public void setMode(Mode mode) {
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void deleteSelection() {
            PlanController.this.deleteItems(PlanController.this.home.getSelectedItems());
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void moveSelection(float f, float f2) {
            PlanController.this.moveAndShowSelectedItems(f, f2);
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void zoom(float f) {
            PlanController.this.setScale(PlanController.this.getScale() * f);
        }
    }

    protected static abstract class ControllerState {
        protected ControllerState() {
        }

        public void enter() {
        }

        public void exit() {
        }

        public abstract Mode getMode();

        public void setMode(Mode mode) {
        }

        public boolean isModificationState() {
            return false;
        }

        public void deleteSelection() {
        }

        public void escape() {
        }

        public void moveSelection(float f, float f2) {
        }

        public void toggleMagnetism(boolean bl) {
        }

        public void setDuplicationActivated(boolean bl) {
        }

        public void setEditionActivated(boolean bl) {
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
        }

        public void releaseMouse(float f, float f2) {
        }

        public void moveMouse(float f, float f2) {
        }

        public void zoom(float f) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointMagnetizedToClosestWallOrRoomPoint {
        private float x;
        private float y;
        private boolean magnetized;

        public PointMagnetizedToClosestWallOrRoomPoint(Collection<Room> collection, float f, float f2, float f3) {
            double d = Double.MAX_VALUE;
            for (GeneralPath cloneable : PlanController.this.getRoomPathsFromWalls()) {
                d = this.updateMagnetizedPoint(f, f2, d, PlanController.this.getPathPoints(cloneable, false));
            }
            for (Room room : collection) {
                d = this.updateMagnetizedPoint(f, f2, d, room.getPoints());
            }
            boolean bl = this.magnetized = d <= (double)(f3 * f3);
            if (!this.magnetized) {
                this.x = f;
                this.y = f2;
            }
        }

        private double updateMagnetizedPoint(float f, float f2, double d, float[][] fArray) {
            for (int i = 0; i < fArray.length; ++i) {
                double d2 = Point2D.distanceSq(fArray[i][0], fArray[i][1], f, f2);
                if (!(d2 < d)) continue;
                this.x = fArray[i][0];
                this.y = fArray[i][1];
                d = d2;
            }
            return d;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public boolean isMagnetized() {
            return this.magnetized;
        }
    }

    private static class PointWithAngleMagnetism {
        private static final int STEP_COUNT = 24;
        private float x;
        private float y;

        public PointWithAngleMagnetism(float f, float f2, float f3, float f4, LengthUnit lengthUnit, float f5) {
            this.x = f3;
            this.y = f4;
            if (f == f3) {
                float f6 = lengthUnit.getMagnetizedLength(Math.abs(f2 - f4), f5);
                this.y = f2 + f6 * Math.signum(f4 - f2);
            } else if (f2 == f4) {
                float f7 = lengthUnit.getMagnetizedLength(Math.abs(f - f3), f5);
                this.x = f + f7 * Math.signum(f3 - f);
            } else {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6 = 0.2617993877991494;
                double d7 = Math.atan2(f2 - f4, f3 - f);
                double d8 = Math.floor(d7 / d6) * d6;
                if (Math.tan(d7) > 0.0) {
                    d5 = d8;
                    d4 = Math.tan(d8);
                    d3 = d8 + d6;
                    d2 = Math.tan(d8 + d6);
                } else {
                    d5 = d8 + d6;
                    d4 = Math.tan(d8 + d6);
                    d3 = d8;
                    d2 = Math.tan(d8);
                }
                double d9 = Math.abs(d4);
                double d10 = Math.abs(d2);
                float f8 = Math.abs(f - f3);
                float f9 = Math.abs(f2 - f4);
                float f10 = 0.0f;
                if (d10 > 1.0E-10) {
                    f10 = (float)((double)f9 / d10);
                }
                float f11 = 0.0f;
                if (d9 < 1.0E10) {
                    f11 = (float)((double)f8 * d9);
                }
                if (Math.abs(f10 - f8) < Math.abs(f11 - f9)) {
                    d = d3;
                    this.x = f + (float)((double)(f2 - f4) / d2);
                } else {
                    d = d5;
                    this.y = f2 - (float)((double)(f3 - f) * d4);
                }
                float f12 = lengthUnit.getMagnetizedLength((float)Point2D.distance(f, f2, this.x, this.y), f5);
                this.x = f + (float)((double)f12 * Math.cos(d));
                this.y = f2 - (float)((double)f12 * Math.sin(d));
            }
        }

        float getX() {
            return this.x;
        }

        float getY() {
            return this.y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JoinedWall {
        private final Wall wall;
        private final Wall wallAtStart;
        private final Wall wallAtEnd;
        private final boolean joinedAtStartOfWallAtStart;
        private final boolean joinedAtEndOfWallAtStart;
        private final boolean joinedAtStartOfWallAtEnd;
        private final boolean joinedAtEndOfWallAtEnd;

        public JoinedWall(Wall wall) {
            this.wall = wall;
            this.wallAtStart = wall.getWallAtStart();
            this.joinedAtEndOfWallAtStart = this.wallAtStart != null && this.wallAtStart.getWallAtEnd() == wall;
            this.joinedAtStartOfWallAtStart = this.wallAtStart != null && this.wallAtStart.getWallAtStart() == wall;
            this.wallAtEnd = wall.getWallAtEnd();
            this.joinedAtEndOfWallAtEnd = this.wallAtEnd != null && this.wallAtEnd.getWallAtEnd() == wall;
            this.joinedAtStartOfWallAtEnd = this.wallAtEnd != null && this.wallAtEnd.getWallAtStart() == wall;
        }

        public Wall getWall() {
            return this.wall;
        }

        public Wall getWallAtEnd() {
            return this.wallAtEnd;
        }

        public Wall getWallAtStart() {
            return this.wallAtStart;
        }

        public boolean isJoinedAtEndOfWallAtStart() {
            return this.joinedAtEndOfWallAtStart;
        }

        public boolean isJoinedAtStartOfWallAtStart() {
            return this.joinedAtStartOfWallAtStart;
        }

        public boolean isJoinedAtEndOfWallAtEnd() {
            return this.joinedAtEndOfWallAtEnd;
        }

        public boolean isJoinedAtStartOfWallAtEnd() {
            return this.joinedAtStartOfWallAtEnd;
        }

        public static JoinedWall[] getJoinedWalls(List<Wall> list) {
            JoinedWall[] joinedWallArray = new JoinedWall[list.size()];
            for (int i = 0; i < joinedWallArray.length; ++i) {
                joinedWallArray[i] = new JoinedWall(list.get(i));
            }
            return joinedWallArray;
        }

        public static List<Wall> getWalls(JoinedWall[] joinedWallArray) {
            Wall[] wallArray = new Wall[joinedWallArray.length];
            for (int i = 0; i < joinedWallArray.length; ++i) {
                wallArray[i] = joinedWallArray[i].getWall();
            }
            return Arrays.asList(wallArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResizedPieceOfFurniture {
        private final HomePieceOfFurniture piece;
        private final float x;
        private final float y;
        private final float width;
        private final float depth;
        private final float height;
        private final boolean doorOrWindowBoundToWall;
        private final float[] groupFurnitureX;
        private final float[] groupFurnitureY;
        private final float[] groupFurnitureWidth;
        private final float[] groupFurnitureDepth;
        private final float[] groupFurnitureHeight;

        public ResizedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
            this.width = homePieceOfFurniture.getWidth();
            this.depth = homePieceOfFurniture.getDepth();
            this.height = homePieceOfFurniture.getHeight();
            boolean bl = this.doorOrWindowBoundToWall = homePieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)homePieceOfFurniture).isBoundToWall();
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                List<HomePieceOfFurniture> list = this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture);
                this.groupFurnitureX = new float[list.size()];
                this.groupFurnitureY = new float[list.size()];
                this.groupFurnitureWidth = new float[list.size()];
                this.groupFurnitureDepth = new float[list.size()];
                this.groupFurnitureHeight = new float[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    HomePieceOfFurniture homePieceOfFurniture2 = list.get(i);
                    this.groupFurnitureX[i] = homePieceOfFurniture2.getX();
                    this.groupFurnitureY[i] = homePieceOfFurniture2.getY();
                    this.groupFurnitureWidth[i] = homePieceOfFurniture2.getWidth();
                    this.groupFurnitureDepth[i] = homePieceOfFurniture2.getDepth();
                    this.groupFurnitureHeight[i] = homePieceOfFurniture2.getHeight();
                }
            } else {
                this.groupFurnitureX = null;
                this.groupFurnitureY = null;
                this.groupFurnitureWidth = null;
                this.groupFurnitureDepth = null;
                this.groupFurnitureHeight = null;
            }
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public float getWidth() {
            return this.width;
        }

        public float getDepth() {
            return this.depth;
        }

        public float getHeight() {
            return this.height;
        }

        public boolean isDoorOrWindowBoundToWall() {
            return this.doorOrWindowBoundToWall;
        }

        public void reset() {
            this.piece.setX(this.x);
            this.piece.setY(this.y);
            this.piece.setWidth(this.width);
            this.piece.setDepth(this.depth);
            this.piece.setHeight(this.height);
            if (this.piece instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)this.piece).setBoundToWall(this.doorOrWindowBoundToWall);
            }
            if (this.piece instanceof HomeFurnitureGroup) {
                List<HomePieceOfFurniture> list = this.getGroupFurniture((HomeFurnitureGroup)this.piece);
                for (int i = 0; i < list.size(); ++i) {
                    HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                    if (!this.piece.isResizable()) continue;
                    homePieceOfFurniture.setX(this.groupFurnitureX[i]);
                    homePieceOfFurniture.setY(this.groupFurnitureY[i]);
                    homePieceOfFurniture.setWidth(this.groupFurnitureWidth[i]);
                    homePieceOfFurniture.setDepth(this.groupFurnitureDepth[i]);
                    homePieceOfFurniture.setHeight(this.groupFurnitureHeight[i]);
                }
            }
        }

        private List<HomePieceOfFurniture> getGroupFurniture(HomeFurnitureGroup homeFurnitureGroup) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
                arrayList.add(homePieceOfFurniture);
                if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                arrayList.addAll(this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture));
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditableProperty {
        X,
        Y,
        LENGTH,
        ANGLE,
        THICKNESS,
        OFFSET,
        ARC_EXTENT;

    }

    public static class Mode {
        public static final Mode SELECTION = new Mode("SELECTION");
        public static final Mode PANNING = new Mode("PANNING");
        public static final Mode WALL_CREATION = new Mode("WALL_CREATION");
        public static final Mode ROOM_CREATION = new Mode("ROOM_CREATION");
        public static final Mode DIMENSION_LINE_CREATION = new Mode("DIMENSION_LINE_CREATION");
        public static final Mode LABEL_CREATION = new Mode("LABEL_CREATION");
        private final String name;

        protected Mode(String string) {
            this.name = string;
        }

        public final String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        MODE,
        MODIFICATION_STATE,
        SCALE;

    }
}

