/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class RoomController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private TextureChoiceController floorTextureController;
    private TextureChoiceController ceilingTextureController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView roomView;
    private String name;
    private Boolean areaVisible;
    private Boolean floorVisible;
    private Integer floorColor;
    private RoomPaint floorPaint;
    private Float floorShininess;
    private Boolean ceilingVisible;
    private Integer ceilingColor;
    private RoomPaint ceilingPaint;
    private Float ceilingShininess;

    public RoomController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getFloorTextureController() {
        if (this.floorTextureController == null) {
            this.floorTextureController = new TextureChoiceController(this.preferences.getLocalizedString(RoomController.class, "floorTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.floorTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomController.this.setFloorPaint(RoomPaint.TEXTURED);
                }
            });
        }
        return this.floorTextureController;
    }

    public TextureChoiceController getCeilingTextureController() {
        if (this.ceilingTextureController == null) {
            this.ceilingTextureController = new TextureChoiceController(this.preferences.getLocalizedString(RoomController.class, "ceilingTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.ceilingTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomController.this.setCeilingPaint(RoomPaint.TEXTURED);
                }
            });
        }
        return this.ceilingTextureController;
    }

    public DialogView getView() {
        if (this.roomView == null) {
            this.roomView = this.viewFactory.createRoomView(this.preferences, this);
        }
        return this.roomView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<Room> list = Home.getRoomsSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setAreaVisible(null);
            this.setFloorColor(null);
            this.getFloorTextureController().setTexture(null);
            this.setFloorPaint(null);
            this.setFloorShininess(null);
            this.setCeilingColor(null);
            this.getCeilingTextureController().setTexture(null);
            this.setCeilingPaint(null);
            this.setCeilingShininess(null);
        } else {
            Room room = list.get(0);
            String string = room.getName();
            if (string != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string.equals(list.get(i).getName())) continue;
                    string = null;
                    break;
                }
            }
            this.setName(string);
            Boolean bl = room.isAreaVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl.booleanValue() == list.get(i).isAreaVisible()) continue;
                bl = null;
                break;
            }
            this.setAreaVisible(bl);
            Boolean bl2 = room.isFloorVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl2.booleanValue() == list.get(i).isFloorVisible()) continue;
                bl2 = null;
                break;
            }
            this.setFloorVisible(bl2);
            Integer n = room.getFloorColor();
            if (n != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n.equals(list.get(i).getFloorColor())) continue;
                    n = null;
                    break;
                }
            }
            this.setFloorColor(n);
            HomeTexture homeTexture = room.getFloorTexture();
            if (homeTexture != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (homeTexture.equals(list.get(i).getFloorTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            this.getFloorTextureController().setTexture(homeTexture);
            if (n != null) {
                this.setFloorPaint(RoomPaint.COLORED);
            } else if (homeTexture != null) {
                this.setFloorPaint(RoomPaint.TEXTURED);
            } else {
                this.setFloorPaint(null);
            }
            Float f = Float.valueOf(room.getFloorShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f.equals(Float.valueOf(list.get(i).getFloorShininess()))) continue;
                f = null;
                break;
            }
            this.setFloorShininess(f);
            Boolean bl3 = room.isCeilingVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl3.booleanValue() == list.get(i).isCeilingVisible()) continue;
                bl3 = null;
                break;
            }
            this.setCeilingVisible(bl3);
            Integer n2 = room.getCeilingColor();
            if (n2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n2.equals(list.get(i).getCeilingColor())) continue;
                    n2 = null;
                    break;
                }
            }
            this.setCeilingColor(n2);
            HomeTexture homeTexture2 = room.getCeilingTexture();
            if (homeTexture2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (homeTexture2.equals(list.get(i).getCeilingTexture())) continue;
                    homeTexture2 = null;
                    break;
                }
            }
            this.getCeilingTextureController().setTexture(homeTexture2);
            if (n2 != null) {
                this.setCeilingPaint(RoomPaint.COLORED);
            } else if (homeTexture2 != null) {
                this.setCeilingPaint(RoomPaint.TEXTURED);
            } else {
                this.setCeilingPaint(null);
            }
            Float f2 = Float.valueOf(room.getCeilingShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.equals(Float.valueOf(list.get(i).getCeilingShininess()))) continue;
                f2 = null;
                break;
            }
            this.setCeilingShininess(f2);
        }
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setAreaVisible(Boolean bl) {
        if (bl != this.areaVisible) {
            Boolean bl2 = this.areaVisible;
            this.areaVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.AREA_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getAreaVisible() {
        return this.areaVisible;
    }

    public void setFloorVisible(Boolean bl) {
        if (bl != this.floorVisible) {
            Boolean bl2 = this.floorVisible;
            this.floorVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getFloorVisible() {
        return this.floorVisible;
    }

    public void setFloorColor(Integer n) {
        if (n != this.floorColor) {
            Integer n2 = this.floorColor;
            this.floorColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_COLOR.name(), n2, n);
            this.setFloorPaint(RoomPaint.COLORED);
        }
    }

    public Integer getFloorColor() {
        return this.floorColor;
    }

    public void setFloorPaint(RoomPaint roomPaint) {
        if (roomPaint != this.floorPaint) {
            RoomPaint roomPaint2 = this.floorPaint;
            this.floorPaint = roomPaint;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_PAINT.name(), (Object)roomPaint2, (Object)roomPaint);
        }
    }

    public RoomPaint getFloorPaint() {
        return this.floorPaint;
    }

    public void setFloorShininess(Float f) {
        if (f != this.floorShininess) {
            Float f2 = this.floorShininess;
            this.floorShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_SHININESS.name(), f2, f);
        }
    }

    public Float getFloorShininess() {
        return this.floorShininess;
    }

    public void setCeilingVisible(Boolean bl) {
        if (bl != this.ceilingVisible) {
            Boolean bl2 = this.ceilingVisible;
            this.ceilingVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getCeilingVisible() {
        return this.ceilingVisible;
    }

    public void setCeilingColor(Integer n) {
        if (n != this.ceilingColor) {
            Integer n2 = this.ceilingColor;
            this.ceilingColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_COLOR.name(), n2, n);
            this.setCeilingPaint(RoomPaint.COLORED);
        }
    }

    public Integer getCeilingColor() {
        return this.ceilingColor;
    }

    public void setCeilingPaint(RoomPaint roomPaint) {
        if (roomPaint != this.ceilingPaint) {
            RoomPaint roomPaint2 = this.ceilingPaint;
            this.ceilingPaint = roomPaint;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_PAINT.name(), (Object)roomPaint2, (Object)roomPaint);
        }
    }

    public RoomPaint getCeilingPaint() {
        return this.ceilingPaint;
    }

    public void setCeilingShininess(Float f) {
        if (f != this.ceilingShininess) {
            Float f2 = this.ceilingShininess;
            this.ceilingShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_SHININESS.name(), f2, f);
        }
    }

    public Float getCeilingShininess() {
        return this.ceilingShininess;
    }

    public void modifyRooms() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Room> list2 = Home.getRoomsSubList(list);
        if (!list2.isEmpty()) {
            String string = this.getName();
            Boolean bl = this.getAreaVisible();
            Boolean bl2 = this.getFloorVisible();
            Integer n = this.getFloorPaint() == RoomPaint.COLORED ? this.getFloorColor() : null;
            HomeTexture homeTexture = this.getFloorPaint() == RoomPaint.TEXTURED ? this.getFloorTextureController().getTexture() : null;
            Float f = this.getFloorShininess();
            Boolean bl3 = this.getCeilingVisible();
            Integer n2 = this.getCeilingPaint() == RoomPaint.COLORED ? this.getCeilingColor() : null;
            HomeTexture homeTexture2 = this.getCeilingPaint() == RoomPaint.TEXTURED ? this.getCeilingTextureController().getTexture() : null;
            Float f2 = this.getCeilingShininess();
            ModifiedRoom[] modifiedRoomArray = new ModifiedRoom[list2.size()];
            for (int i = 0; i < modifiedRoomArray.length; ++i) {
                modifiedRoomArray[i] = new ModifiedRoom(list2.get(i));
            }
            RoomController.doModifyRooms(modifiedRoomArray, string, bl, bl2, n, homeTexture, f, bl3, n2, homeTexture2, f2);
            if (this.undoSupport != null) {
                RoomsModificationUndoableEdit roomsModificationUndoableEdit = new RoomsModificationUndoableEdit(this.home, this.preferences, list, modifiedRoomArray, string, bl, n, homeTexture, bl2, f, n2, homeTexture2, bl3, f2);
                this.undoSupport.postEdit(roomsModificationUndoableEdit);
            }
        }
    }

    private static void doModifyRooms(ModifiedRoom[] modifiedRoomArray, String string, Boolean bl, Boolean bl2, Integer n, HomeTexture homeTexture, Float f, Boolean bl3, Integer n2, HomeTexture homeTexture2, Float f2) {
        for (ModifiedRoom modifiedRoom : modifiedRoomArray) {
            Room room = modifiedRoom.getRoom();
            if (string != null) {
                room.setName(string);
            }
            if (bl != null) {
                room.setAreaVisible(bl);
            }
            if (bl2 != null) {
                room.setFloorVisible(bl2);
            }
            if (homeTexture != null) {
                room.setFloorTexture(homeTexture);
                room.setFloorColor(null);
            } else if (n != null) {
                room.setFloorColor(n);
                room.setFloorTexture(null);
            }
            if (f != null) {
                room.setFloorShininess(f.floatValue());
            }
            if (bl3 != null) {
                room.setCeilingVisible(bl3);
            }
            if (homeTexture2 != null) {
                room.setCeilingTexture(homeTexture2);
                room.setCeilingColor(null);
            } else if (n2 != null) {
                room.setCeilingColor(n2);
                room.setCeilingTexture(null);
            }
            if (f2 == null) continue;
            room.setCeilingShininess(f2.floatValue());
        }
    }

    private static void undoModifyRooms(ModifiedRoom[] modifiedRoomArray) {
        for (ModifiedRoom modifiedRoom : modifiedRoomArray) {
            modifiedRoom.reset();
        }
    }

    private static final class ModifiedRoom {
        private final Room room;
        private final String name;
        private final boolean areaVisible;
        private final boolean floorVisible;
        private final Integer floorColor;
        private final HomeTexture floorTexture;
        private final float floorShininess;
        private final boolean ceilingVisible;
        private final Integer ceilingColor;
        private final HomeTexture ceilingTexture;
        private final float ceilingShininess;

        public ModifiedRoom(Room room) {
            this.room = room;
            this.name = room.getName();
            this.areaVisible = room.isAreaVisible();
            this.floorVisible = room.isFloorVisible();
            this.floorColor = room.getFloorColor();
            this.floorTexture = room.getFloorTexture();
            this.floorShininess = room.getFloorShininess();
            this.ceilingVisible = room.isCeilingVisible();
            this.ceilingColor = room.getCeilingColor();
            this.ceilingTexture = room.getCeilingTexture();
            this.ceilingShininess = room.getCeilingShininess();
        }

        public Room getRoom() {
            return this.room;
        }

        public void reset() {
            this.room.setName(this.name);
            this.room.setAreaVisible(this.areaVisible);
            this.room.setFloorVisible(this.floorVisible);
            this.room.setFloorColor(this.floorColor);
            this.room.setFloorTexture(this.floorTexture);
            this.room.setFloorShininess(this.floorShininess);
            this.room.setCeilingVisible(this.ceilingVisible);
            this.room.setCeilingColor(this.ceilingColor);
            this.room.setCeilingTexture(this.ceilingTexture);
            this.room.setCeilingShininess(this.ceilingShininess);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoomsModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final ModifiedRoom[] modifiedRooms;
        private final String name;
        private final Boolean areaVisible;
        private final Integer floorColor;
        private final HomeTexture floorTexture;
        private final Boolean floorVisible;
        private final Float floorShininess;
        private final Integer ceilingColor;
        private final HomeTexture ceilingTexture;
        private final Boolean ceilingVisible;
        private final Float ceilingShininess;

        private RoomsModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, ModifiedRoom[] modifiedRoomArray, String string, Boolean bl, Integer n, HomeTexture homeTexture, Boolean bl2, Float f, Integer n2, HomeTexture homeTexture2, Boolean bl3, Float f2) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.modifiedRooms = modifiedRoomArray;
            this.name = string;
            this.areaVisible = bl;
            this.floorColor = n;
            this.floorTexture = homeTexture;
            this.floorVisible = bl2;
            this.floorShininess = f;
            this.ceilingColor = n2;
            this.ceilingTexture = homeTexture2;
            this.ceilingVisible = bl3;
            this.ceilingShininess = f2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            RoomController.undoModifyRooms(this.modifiedRooms);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            RoomController.doModifyRooms(this.modifiedRooms, this.name, this.areaVisible, this.floorVisible, this.floorColor, this.floorTexture, this.floorShininess, this.ceilingVisible, this.ceilingColor, this.ceilingTexture, this.ceilingShininess);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(RoomController.class, "undoModifyRoomsName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RoomPaint {
        COLORED,
        TEXTURED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        AREA_VISIBLE,
        FLOOR_VISIBLE,
        FLOOR_COLOR,
        FLOOR_PAINT,
        FLOOR_SHININESS,
        CEILING_VISIBLE,
        CEILING_COLOR,
        CEILING_PAINT,
        CEILING_SHININESS;

    }
}

