/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import java.awt.Color;
import javax.swing.UIManager;

class DerivedColor
extends Color {
    private final String uiDefaultParentName;
    private final float hOffset;
    private final float sOffset;
    private final float bOffset;
    private final int aOffset;
    private int argbValue;

    DerivedColor(String string, float f, float f2, float f3, int n) {
        super(0);
        this.uiDefaultParentName = string;
        this.hOffset = f;
        this.sOffset = f2;
        this.bOffset = f3;
        this.aOffset = n;
    }

    public String getUiDefaultParentName() {
        return this.uiDefaultParentName;
    }

    public float getHueOffset() {
        return this.hOffset;
    }

    public float getSaturationOffset() {
        return this.sOffset;
    }

    public float getBrightnessOffset() {
        return this.bOffset;
    }

    public int getAlphaOffset() {
        return this.aOffset;
    }

    public void rederiveColor() {
        Color color = UIManager.getColor(this.uiDefaultParentName);
        if (color != null) {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            fArray[0] = this.clamp(fArray[0] + this.hOffset);
            fArray[1] = this.clamp(fArray[1] + this.sOffset);
            fArray[2] = this.clamp(fArray[2] + this.bOffset);
            int n = this.clamp(color.getAlpha() + this.aOffset);
            this.argbValue = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]) & 0xFFFFFF | n << 24;
        } else {
            float[] fArray = new float[]{this.clamp(this.hOffset), this.clamp(this.sOffset), this.clamp(this.bOffset)};
            int n = this.clamp(this.aOffset);
            this.argbValue = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]) & 0xFFFFFF | n << 24;
        }
    }

    public int getRGB() {
        return this.argbValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DerivedColor)) {
            return false;
        }
        DerivedColor derivedColor = (DerivedColor)object;
        if (this.aOffset != derivedColor.aOffset) {
            return false;
        }
        if (Float.compare(derivedColor.bOffset, this.bOffset) != 0) {
            return false;
        }
        if (Float.compare(derivedColor.hOffset, this.hOffset) != 0) {
            return false;
        }
        if (Float.compare(derivedColor.sOffset, this.sOffset) != 0) {
            return false;
        }
        return this.uiDefaultParentName.equals(derivedColor.uiDefaultParentName);
    }

    public int hashCode() {
        int n = this.uiDefaultParentName.hashCode();
        n = (float)(31 * n) + this.hOffset != 0.0f ? Float.floatToIntBits(this.hOffset) : 0;
        n = (float)(31 * n) + this.sOffset != 0.0f ? Float.floatToIntBits(this.sOffset) : 0;
        n = (float)(31 * n) + this.bOffset != 0.0f ? Float.floatToIntBits(this.bOffset) : 0;
        n = 31 * n + this.aOffset;
        return n;
    }

    private float clamp(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private int clamp(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    public String toString() {
        Color color = UIManager.getColor(this.uiDefaultParentName);
        String string = "DerivedColor(color=" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + " parent=" + this.uiDefaultParentName + " offsets=" + this.getHueOffset() + "," + this.getSaturationOffset() + "," + this.getBrightnessOffset() + "," + this.getAlphaOffset();
        return color == null ? string : string + " pColor=" + color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    static class UIResource
    extends DerivedColor
    implements javax.swing.plaf.UIResource {
        UIResource(String string, float f, float f2, float f3, int n) {
            super(string, f, f2, f3, n);
        }
    }
}

