/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d;

import com.eteks.sweethome3d.HomeFrameController;
import com.eteks.sweethome3d.MacOSXConfiguration;
import com.eteks.sweethome3d.io.AutoRecoveryManager;
import com.eteks.sweethome3d.io.FileUserPreferences;
import com.eteks.sweethome3d.io.HomeFileRecorder;
import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.plugin.PluginManager;
import com.eteks.sweethome3d.swing.FileContentManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.swing.SwingViewFactory;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.ServiceManagerStub;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SweetHome3D
extends HomeApplication {
    private static final String PREFERENCES_FOLDER = "com.eteks.sweethome3d.preferencesFolder";
    private static final String APPLICATION_FOLDERS = "com.eteks.sweethome3d.applicationFolders";
    private static final String APPLICATION_PLUGINS_SUB_FOLDER = "plugins";
    private HomeRecorder homeRecorder;
    private HomeRecorder compressedHomeRecorder;
    private UserPreferences userPreferences;
    private ContentManager contentManager;
    private ViewFactory viewFactory;
    private PluginManager pluginManager;
    private boolean pluginManagerInitialized;
    private AutoRecoveryManager autoRecoveryManager;
    private final Map<Home, JFrame> homeFrames = new HashMap<Home, JFrame>();

    protected SweetHome3D() {
    }

    public HomeRecorder getHomeRecorder() {
        if (this.homeRecorder == null) {
            this.homeRecorder = new HomeFileRecorder();
        }
        return this.homeRecorder;
    }

    public HomeRecorder getHomeRecorder(HomeRecorder.Type type) {
        if (type == HomeRecorder.Type.COMPRESSED) {
            if (this.compressedHomeRecorder == null) {
                this.compressedHomeRecorder = new HomeFileRecorder(9);
            }
            return this.compressedHomeRecorder;
        }
        return super.getHomeRecorder(type);
    }

    public UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            File[] fileArray;
            File file;
            String string = System.getProperty(PREFERENCES_FOLDER, null);
            String string2 = System.getProperty(APPLICATION_FOLDERS, null);
            File file2 = file = string != null ? new File(string) : null;
            if (string2 != null) {
                String[] stringArray = string2.split(File.pathSeparator);
                fileArray = new File[stringArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i] = new File(stringArray[i]);
                }
            } else {
                fileArray = null;
            }
            this.userPreferences = new FileUserPreferences(file, fileArray);
        }
        return this.userPreferences;
    }

    protected ContentManager getContentManager() {
        if (this.contentManager == null) {
            this.contentManager = new FileContentManager(this.getUserPreferences());
        }
        return this.contentManager;
    }

    protected ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new SwingViewFactory();
        }
        return this.viewFactory;
    }

    protected PluginManager getPluginManager() {
        if (!this.pluginManagerInitialized) {
            try {
                UserPreferences userPreferences = this.getUserPreferences();
                if (userPreferences instanceof FileUserPreferences) {
                    File[] fileArray = ((FileUserPreferences)userPreferences).getApplicationSubfolders(APPLICATION_PLUGINS_SUB_FOLDER);
                    this.pluginManager = new PluginManager(fileArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.pluginManagerInitialized = true;
        }
        return this.pluginManager;
    }

    public String getName() {
        return this.getUserPreferences().getLocalizedString(SweetHome3D.class, "applicationName", new Object[0]);
    }

    public String getVersion() {
        String string = this.getUserPreferences().getLocalizedString(SweetHome3D.class, "applicationVersion", new Object[0]);
        String string2 = System.getProperty("com.eteks.sweethome3d.deploymentInformation");
        if (string2 != null) {
            string = string + " " + string2;
        }
        return string;
    }

    JFrame getHomeFrame(Home home) {
        return this.homeFrames.get(home);
    }

    private void showHomeFrame(Home home) {
        JFrame jFrame = this.getHomeFrame(home);
        jFrame.setVisible(true);
        jFrame.setState(0);
        jFrame.toFront();
    }

    public static void main(String[] stringArray) {
        new SweetHome3D().init(stringArray);
    }

    protected void init(final String[] stringArray) {
        this.initSystemProperties();
        if (ServiceManager.getServiceNames() == null) {
            if (StandaloneSingleInstanceService.callSingleInstanceServer(stringArray, this.getClass())) {
                System.exit(0);
            } else {
                SwingTools.showSplashScreenWindow(SweetHome3D.class.getResource("resources/splashScreen.jpg"));
                ServiceManager.setServiceManagerStub((ServiceManagerStub)new StandaloneServiceManager(this.getClass()));
            }
        }
        SingleInstanceService singleInstanceService = null;
        final SingleInstanceListener singleInstanceListener = new SingleInstanceListener(){

            public void newActivation(final String[] stringArray) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SweetHome3D.this.run(stringArray);
                    }
                });
            }
        };
        try {
            singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(singleInstanceListener);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            // empty catch block
        }
        final SingleInstanceService singleInstanceService2 = singleInstanceService;
        this.addHomesListener(new CollectionListener<Home>(){
            private boolean firstApplicationHomeAdded;

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        Home home = collectionEvent.getItem();
                        try {
                            HomeFrameController homeFrameController = SweetHome3D.this.createHomeFrameController(home);
                            homeFrameController.displayView();
                            if (!this.firstApplicationHomeAdded) {
                                SweetHome3D.this.addNewHomeCloseListener(home, homeFrameController.getHomeController());
                                this.firstApplicationHomeAdded = true;
                            }
                            JFrame jFrame = (JFrame)SwingUtilities.getRoot((JComponent)((Object)homeFrameController.getView()));
                            SweetHome3D.this.homeFrames.put(home, jFrame);
                            break;
                        }
                        catch (IllegalStateException illegalStateException) {
                            if ("javax.media.j3d.IllegalRenderingStateException".equals(illegalStateException.getClass().getName())) {
                                illegalStateException.printStackTrace();
                                SweetHome3D.this.exitAfter3DError();
                                break;
                            }
                            throw illegalStateException;
                        }
                    }
                    case DELETE: {
                        SweetHome3D.this.homeFrames.remove(collectionEvent.getItem());
                        if (!SweetHome3D.this.getHomes().isEmpty() || OperatingSystem.isMacOSX()) break;
                        if (singleInstanceService2 != null) {
                            singleInstanceService2.removeSingleInstanceListener(singleInstanceListener);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                System.exit(0);
                            }
                        });
                    }
                }
            }
        });
        this.addComponent3DRenderingErrorObserver();
        this.getUserPreferences();
        this.initLookAndFeel();
        try {
            this.autoRecoveryManager = new AutoRecoveryManager(this);
        }
        catch (RecorderException recorderException) {
            recorderException.printStackTrace();
        }
        if (OperatingSystem.isMacOSX()) {
            MacOSXConfiguration.bindToApplicationMenu(this);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SweetHome3D.this.run(stringArray);
            }
        });
    }

    protected HomeFrameController createHomeFrameController(Home home) {
        return new HomeFrameController(home, this, this.getViewFactory(), this.getContentManager(), this.getPluginManager());
    }

    private void initSystemProperties() {
        if (OperatingSystem.isMacOSX()) {
            String string = SweetHome3D.class.getName();
            string = string.substring(0, string.lastIndexOf("."));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string + "." + "package");
            String string2 = resourceBundle.getString("SweetHome3D.applicationName");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string2);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
    }

    private void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                UIManager.put("TitledBorder.border", UIManager.getBorder("TitledBorder.aquaVariant"));
            }
            SwingTools.updateSwingResourceLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addNewHomeCloseListener(final Home home, final HomeController homeController) {
        if (home.getName() == null) {
            final CollectionListener<Home> collectionListener = new CollectionListener<Home>(){

                @Override
                public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        if (collectionEvent.getItem().getName() != null && home.getName() == null && !home.isRecovered()) {
                            homeController.close();
                        }
                        SweetHome3D.this.removeHomesListener(this);
                    } else if (collectionEvent.getItem() == home && collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        SweetHome3D.this.removeHomesListener(this);
                    }
                }
            };
            this.addHomesListener(collectionListener);
            home.addPropertyChangeListener(Home.Property.MODIFIED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SweetHome3D.this.removeHomesListener(collectionListener);
                    home.removePropertyChangeListener(Home.Property.MODIFIED, this);
                }
            });
        }
    }

    private void addComponent3DRenderingErrorObserver() {
        if (!"true".equalsIgnoreCase(System.getProperty("com.eteks.sweethome3d.no3D"))) {
            Component3DManager.getInstance().setRenderingErrorObserver(new Component3DManager.RenderingErrorObserver(){

                public void errorOccured(int n, String string) {
                    System.err.print("Error in Java 3D : " + n + " " + string);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SweetHome3D.this.exitAfter3DError();
                        }
                    });
                }
            });
        }
    }

    private void exitAfter3DError() {
        boolean bl = false;
        for (Home home : this.getHomes()) {
            if (!home.isModified()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.show3DError();
        } else if (this.confirmSaveAfter3DError()) {
            for (Home home : this.getHomes()) {
                if (!home.isModified()) continue;
                String string = home.getName();
                if (string == null) {
                    JFrame jFrame = this.getHomeFrame(home);
                    jFrame.toFront();
                    string = this.contentManager.showSaveDialog((View)((Object)jFrame.getRootPane()), null, ContentManager.ContentType.SWEET_HOME_3D, null);
                }
                if (string != null) {
                    try {
                        this.getHomeRecorder().writeHome(home, string);
                    }
                    catch (RecorderException recorderException) {
                        recorderException.printStackTrace();
                    }
                }
                this.deleteHome(home);
            }
        }
        for (Home home : this.getHomes()) {
            this.deleteHome(home);
        }
        System.exit(0);
    }

    private void show3DError() {
        UserPreferences userPreferences = this.getUserPreferences();
        String string = userPreferences.getLocalizedString(SweetHome3D.class, "3DError.message", new Object[0]);
        String string2 = userPreferences.getLocalizedString(SweetHome3D.class, "3DError.title", new Object[0]);
        JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), string, string2, 0);
    }

    private boolean confirmSaveAfter3DError() {
        UserPreferences userPreferences = this.getUserPreferences();
        String string = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.message", new Object[0]);
        String string2 = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.title", new Object[0]);
        String string3 = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.save", new Object[0]);
        String string4 = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.doNotSave", new Object[0]);
        return JOptionPane.showOptionDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), string, string2, 0, 3, null, new Object[]{string3, string4}, string3) == 0;
    }

    void run(String[] stringArray) {
        if (stringArray.length == 2 && stringArray[0].equals("-open")) {
            Object object;
            for (Home home : this.getHomes()) {
                if (!stringArray[1].equals(home.getName())) continue;
                this.showHomeFrame(home);
                return;
            }
            if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.SWEET_HOME_3D)) {
                this.addHomesListener(new CollectionListener<Home>(){

                    @Override
                    public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                        if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                            SweetHome3D.this.removeHomesListener(this);
                            SweetHome3D.this.autoRecoveryManager.openRecoveredHomes();
                        }
                    }
                });
                this.createHomeFrameController(this.createHome()).getHomeController().open(stringArray[1]);
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.LANGUAGE_LIBRARY)) {
                this.run(new String[0]);
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable((String)object){
                    final /* synthetic */ String val$languageLibraryName;
                    {
                        this.val$languageLibraryName = string;
                    }

                    public void run() {
                        SweetHome3D.this.createHomeFrameController(SweetHome3D.this.createHome()).getHomeController().importLanguageLibrary(this.val$languageLibraryName);
                    }
                });
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.FURNITURE_LIBRARY)) {
                this.run(new String[0]);
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable((String)object){
                    final /* synthetic */ String val$furnitureLibraryName;
                    {
                        this.val$furnitureLibraryName = string;
                    }

                    public void run() {
                        SweetHome3D.this.createHomeFrameController(SweetHome3D.this.createHome()).getHomeController().importFurnitureLibrary(this.val$furnitureLibraryName);
                    }
                });
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.TEXTURES_LIBRARY)) {
                this.run(new String[0]);
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable((String)object){
                    final /* synthetic */ String val$texturesLibraryName;
                    {
                        this.val$texturesLibraryName = string;
                    }

                    public void run() {
                        SweetHome3D.this.createHomeFrameController(SweetHome3D.this.createHome()).getHomeController().importTexturesLibrary(this.val$texturesLibraryName);
                    }
                });
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.PLUGIN)) {
                this.run(new String[0]);
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable((String)object){
                    final /* synthetic */ String val$pluginName;
                    {
                        this.val$pluginName = string;
                    }

                    public void run() {
                        SweetHome3D.this.createHomeFrameController(SweetHome3D.this.createHome()).getHomeController().importPlugin(this.val$pluginName);
                    }
                });
            }
        } else if (this.getHomes().isEmpty()) {
            this.autoRecoveryManager.openRecoveredHomes();
            if (this.getHomes().isEmpty()) {
                this.addHome(this.createHome());
            }
        } else {
            JFrame jFrame;
            int n;
            List<Home> list = this.getHomes();
            Home home = null;
            for (n = list.size() - 1; n >= 0; --n) {
                jFrame = this.getHomeFrame(list.get(n));
                if (!jFrame.isActive() && jFrame.getState() == 1) continue;
                home = list.get(n);
                break;
            }
            if (home == null) {
                for (n = list.size() - 1; n >= 0; --n) {
                    jFrame = this.getHomeFrame(list.get(n));
                    if (!jFrame.isDisplayable()) continue;
                    home = list.get(n);
                    break;
                }
            }
            this.showHomeFrame(home);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandaloneSingleInstanceService
    implements SingleInstanceService {
        private static final String SINGLE_INSTANCE_PORT = "singleInstancePort";
        private final Class<?> mainClass;
        private final List<SingleInstanceListener> singleInstanceListeners = new ArrayList<SingleInstanceListener>();

        public StandaloneSingleInstanceService(Class<?> clazz) {
            this.mainClass = clazz;
        }

        public void addSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
            if (this.singleInstanceListeners.isEmpty() && !OperatingSystem.isMacOSX()) {
                this.launchSingleInstanceServer();
            }
            this.singleInstanceListeners.add(singleInstanceListener);
        }

        private void launchSingleInstanceServer() {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
                Preferences preferences = Preferences.userNodeForPackage(this.mainClass);
                preferences.putInt(SINGLE_INSTANCE_PORT, serverSocket.getLocalPort());
                preferences.flush();
            }
            catch (IOException iOException) {
                return;
            }
            catch (BackingStoreException backingStoreException) {
                return;
            }
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                public void run() {
                    try {
                        block2: while (true) {
                            SingleInstanceListener[] singleInstanceListenerArray;
                            Socket socket = serverSocket.accept();
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                            String[] stringArray = bufferedReader.readLine().split("\t");
                            bufferedReader.close();
                            socket.close();
                            SingleInstanceListener[] singleInstanceListenerArray2 = singleInstanceListenerArray = StandaloneSingleInstanceService.this.singleInstanceListeners.toArray(new SingleInstanceListener[StandaloneSingleInstanceService.this.singleInstanceListeners.size()]);
                            int n = singleInstanceListenerArray2.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block2;
                                SingleInstanceListener singleInstanceListener = singleInstanceListenerArray2[n2];
                                singleInstanceListener.newActivation(stringArray);
                                ++n2;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        StandaloneSingleInstanceService.this.launchSingleInstanceServer();
                        return;
                    }
                }
            });
        }

        public void removeSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
            this.singleInstanceListeners.remove(singleInstanceListener);
            if (this.singleInstanceListeners.isEmpty()) {
                Preferences preferences = Preferences.userNodeForPackage(this.mainClass);
                preferences.remove(SINGLE_INSTANCE_PORT);
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    throw new RuntimeException(backingStoreException);
                }
            }
        }

        public static boolean callSingleInstanceServer(String[] stringArray, Class<?> clazz) {
            Preferences preferences;
            int n;
            if (!OperatingSystem.isMacOSX() && (n = (preferences = Preferences.userNodeForPackage(clazz)).getInt(SINGLE_INSTANCE_PORT, -1)) != -1) {
                try {
                    Socket socket = new Socket("127.0.0.1", n);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
                    for (String string : stringArray) {
                        bufferedWriter.write(string);
                        bufferedWriter.write("\t");
                    }
                    bufferedWriter.write("\n");
                    bufferedWriter.close();
                    socket.close();
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static class StandaloneBasicService
    implements BasicService {
        private StandaloneBasicService() {
        }

        public boolean showDocument(URL uRL) {
            if (this.isJava6()) {
                try {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    clazz.getMethod("browse", URI.class).invoke(object, uRL.toURI());
                    return true;
                }
                catch (Exception exception) {}
            } else if (OperatingSystem.isMacOSX()) {
                try {
                    Runtime.getRuntime().exec(new String[]{"open", uRL.toString()});
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public URL getCodeBase() {
            return StandaloneServiceManager.class.getResource("resources");
        }

        public boolean isOffline() {
            return false;
        }

        public boolean isWebBrowserSupported() {
            if (this.isJava6()) {
                try {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                    Object object2 = clazz2.getMethod("valueOf", String.class).invoke(null, "BROWSE");
                    return (Boolean)clazz.getMethod("isSupported", clazz2).invoke(object, object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return OperatingSystem.isMacOSX();
        }

        private boolean isJava6() {
            String string = System.getProperty("java.version");
            String[] stringArray = string.split("\\.|_");
            if (stringArray.length >= 2) {
                try {
                    if (Integer.parseInt(stringArray[1]) >= 6) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandaloneServiceManager
    implements ServiceManagerStub {
        private final Class<?> mainClass;

        public StandaloneServiceManager(Class<?> clazz) {
            this.mainClass = clazz;
        }

        public Object lookup(String string) throws UnavailableServiceException {
            if (string.equals("javax.jnlp.BasicService")) {
                return new StandaloneBasicService();
            }
            if (string.equals("javax.jnlp.SingleInstanceService")) {
                return new StandaloneSingleInstanceService(this.mainClass);
            }
            throw new UnavailableServiceException(string);
        }

        public String[] getServiceNames() {
            return new String[]{"javax.jnlp.BasicService", "javax.jnlp.SingleInstanceService"};
        }
    }
}

