/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.IllegalHomonymException;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFurnitureCatalog
extends FurnitureCatalog {
    public static final String PLUGIN_FURNITURE_CATALOG_FAMILY = "PluginFurnitureCatalog";
    private static final String CONTRIBUTED_FURNITURE_CATALOG_FAMILY = "ContributedFurnitureCatalog";
    private static final String ADDITIONAL_FURNITURE_CATALOG_FAMILY = "AdditionalFurnitureCatalog";
    private static final String HOMONYM_FURNITURE_FORMAT = "%s -%d-";
    private static final Map<File, URL> pluginFurnitureCatalogUrlUpdates = new HashMap<File, URL>();

    public DefaultFurnitureCatalog() {
        this((File)null);
    }

    public DefaultFurnitureCatalog(File file) {
        this(null, file);
    }

    public DefaultFurnitureCatalog(UserPreferences userPreferences, File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(userPreferences, fileArray);
    }

    public DefaultFurnitureCatalog(UserPreferences userPreferences, File[] fileArray) {
        HashMap<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> hashMap = new HashMap<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = DefaultFurnitureCatalog.class.getName();
        this.readFurnitureCatalog(string, userPreferences, hashMap, arrayList);
        String string2 = string.substring(0, string.lastIndexOf("."));
        this.readFurnitureCatalog(string2 + "." + CONTRIBUTED_FURNITURE_CATALOG_FAMILY, userPreferences, hashMap, arrayList);
        this.readFurnitureCatalog(string2 + "." + ADDITIONAL_FURNITURE_CATALOG_FAMILY, userPreferences, hashMap, arrayList);
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder());
                for (File file2 : fileArray2) {
                    this.readPluginFurnitureCatalog(file2, hashMap, arrayList);
                }
            }
        }
    }

    public DefaultFurnitureCatalog(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DefaultFurnitureCatalog(URL[] uRLArray, URL uRL) {
        HashMap<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> hashMap = new HashMap<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URL uRL2 : uRLArray) {
            try {
                this.readFurniture(ResourceBundle.getBundle(PLUGIN_FURNITURE_CATALOG_FAMILY, Locale.getDefault(), new URLClassLoader(new URL[]{uRL2})), uRL2, uRL, hashMap, arrayList);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void readPluginFurnitureCatalog(File file, Map<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> map, List<String> list) {
        try {
            Object object;
            URL uRL = file.toURI().toURL();
            long l = file.lastModified();
            URL uRL2 = pluginFurnitureCatalogUrlUpdates.get(uRL.toString());
            if (file.canWrite() && (uRL2 == null || uRL2.openConnection().getLastModified() < l)) {
                object = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(uRL));
                URL uRL3 = ((URLContent)object).getURL();
                pluginFurnitureCatalogUrlUpdates.put(file, uRL3);
                uRL = uRL3;
            } else if (uRL2 != null) {
                uRL = uRL2;
            }
            object = ResourceBundle.getBundle(PLUGIN_FURNITURE_CATALOG_FAMILY, Locale.getDefault(), new URLClassLoader(new URL[]{uRL}));
            this.readFurniture((ResourceBundle)object, uRL, null, map, list);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readFurnitureCatalog(final String string, final UserPreferences userPreferences, Map<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> map, List<String> list) {
        ResourceBundle resourceBundle;
        if (userPreferences != null) {
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string2) {
                    try {
                        return userPreferences.getLocalizedString(string, string2, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MissingResourceException("Unknown key " + string2, string + "_" + Locale.getDefault(), string2);
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        this.readFurniture(resourceBundle, null, null, map, list);
    }

    private void readFurniture(ResourceBundle resourceBundle, URL uRL, URL uRL2, Map<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> map, List<String> list) {
        CatalogPieceOfFurniture catalogPieceOfFurniture;
        int n = 1;
        while ((catalogPieceOfFurniture = this.readPieceOfFurniture(resourceBundle, n, uRL, uRL2)) != null) {
            block4: {
                block3: {
                    if (catalogPieceOfFurniture.getId() == null) break block3;
                    if (list.contains(catalogPieceOfFurniture.getId())) break block4;
                    list.add(catalogPieceOfFurniture.getId());
                }
                FurnitureCategory furnitureCategory = this.readFurnitureCategory(resourceBundle, n);
                this.add(furnitureCategory, catalogPieceOfFurniture, map);
            }
            ++n;
        }
    }

    protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
        String string = null;
        try {
            string = resourceBundle.getString(PropertyKey.NAME.getKey(n));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        String string2 = this.getOptionalString(resourceBundle, PropertyKey.DESCRIPTION.getKey(n), null);
        Content content = this.getContent(resourceBundle, PropertyKey.ICON.getKey(n), uRL, uRL2, false, false);
        Content content2 = this.getContent(resourceBundle, PropertyKey.PLAN_ICON.getKey(n), uRL, uRL2, false, true);
        boolean bl = this.getOptionalBoolean(resourceBundle, PropertyKey.MULTI_PART_MODEL.getKey(n), false);
        Content content3 = this.getContent(resourceBundle, PropertyKey.MODEL.getKey(n), uRL, uRL2, bl, false);
        float f = Float.parseFloat(resourceBundle.getString(PropertyKey.WIDTH.getKey(n)));
        float f2 = Float.parseFloat(resourceBundle.getString(PropertyKey.DEPTH.getKey(n)));
        float f3 = Float.parseFloat(resourceBundle.getString(PropertyKey.HEIGHT.getKey(n)));
        boolean bl2 = Boolean.parseBoolean(resourceBundle.getString(PropertyKey.MOVABLE.getKey(n)));
        boolean bl3 = Boolean.parseBoolean(resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW.getKey(n)));
        float f4 = this.getOptionalFloat(resourceBundle, PropertyKey.ELEVATION.getKey(n), 0.0f);
        float[][] fArray = this.getModelRotation(resourceBundle, PropertyKey.MODEL_ROTATION.getKey(n));
        String string3 = this.getOptionalString(resourceBundle, PropertyKey.CREATOR.getKey(n), null);
        String string4 = this.getOptionalString(resourceBundle, PropertyKey.ID.getKey(n), null);
        boolean bl4 = this.getOptionalBoolean(resourceBundle, PropertyKey.RESIZABLE.getKey(n), true);
        boolean bl5 = this.getOptionalBoolean(resourceBundle, PropertyKey.DEFORMABLE.getKey(n), true);
        boolean bl6 = this.getOptionalBoolean(resourceBundle, PropertyKey.TEXTURABLE.getKey(n), true);
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(resourceBundle.getString(PropertyKey.PRICE.getKey(n)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        BigDecimal bigDecimal2 = null;
        try {
            bigDecimal2 = new BigDecimal(resourceBundle.getString(PropertyKey.VALUE_ADDED_TAX_PERCENTAGE.getKey(n)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (bl3) {
            float f5 = this.getOptionalFloat(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS.getKey(n), f2) / f2;
            float f6 = this.getOptionalFloat(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE.getKey(n), 0.0f) / f2;
            Sash[] sashArray = this.getDoorOrWindowSashes(resourceBundle, n, f, f2);
            return new CatalogDoorOrWindow(string4, string, string2, content, content2, content3, f, f2, f3, f4, bl2, f5, f6, sashArray, fArray, string3, bl4, bl5, bl6, bigDecimal, bigDecimal2);
        }
        LightSource[] lightSourceArray = this.getLightSources(resourceBundle, n, f, f2, f3);
        if (lightSourceArray != null) {
            return new CatalogLight(string4, string, string2, content, content2, content3, f, f2, f3, f4, bl2, lightSourceArray, fArray, string3, bl4, bl5, bl6, bigDecimal, bigDecimal2);
        }
        return new CatalogPieceOfFurniture(string4, string, string2, content, content2, content3, f, f2, f3, f4, bl2, fArray, string3, bl4, bl5, bl6, bigDecimal, bigDecimal2);
    }

    protected FurnitureCategory readFurnitureCategory(ResourceBundle resourceBundle, int n) {
        String string = resourceBundle.getString(PropertyKey.CATEGORY.getKey(n));
        return new FurnitureCategory(string);
    }

    private void add(FurnitureCategory furnitureCategory, CatalogPieceOfFurniture catalogPieceOfFurniture, Map<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> map) {
        try {
            this.add(furnitureCategory, catalogPieceOfFurniture);
        }
        catch (IllegalHomonymException illegalHomonymException) {
            Integer n;
            Map<CatalogPieceOfFurniture, Integer> map2 = map.get(furnitureCategory);
            if (map2 == null) {
                map2 = new HashMap<CatalogPieceOfFurniture, Integer>();
                map.put(furnitureCategory, map2);
            }
            if ((n = map2.get(catalogPieceOfFurniture)) == null) {
                n = 1;
            }
            n = n + 1;
            map2.put(catalogPieceOfFurniture, n);
            String string = String.format(HOMONYM_FURNITURE_FORMAT, catalogPieceOfFurniture.getName(), n);
            if (catalogPieceOfFurniture instanceof CatalogDoorOrWindow) {
                CatalogDoorOrWindow catalogDoorOrWindow = (CatalogDoorOrWindow)catalogPieceOfFurniture;
                catalogPieceOfFurniture = new CatalogDoorOrWindow(catalogDoorOrWindow.getId(), string, catalogDoorOrWindow.getDescription(), catalogDoorOrWindow.getIcon(), catalogDoorOrWindow.getPlanIcon(), catalogDoorOrWindow.getModel(), catalogDoorOrWindow.getWidth(), catalogDoorOrWindow.getDepth(), catalogDoorOrWindow.getHeight(), catalogDoorOrWindow.getElevation(), catalogDoorOrWindow.isMovable(), catalogDoorOrWindow.getWallThickness(), catalogDoorOrWindow.getWallDistance(), catalogDoorOrWindow.getSashes(), catalogDoorOrWindow.getModelRotation(), catalogDoorOrWindow.getCreator(), catalogDoorOrWindow.isResizable(), catalogDoorOrWindow.isDeformable(), catalogDoorOrWindow.isTexturable(), catalogDoorOrWindow.getPrice(), catalogDoorOrWindow.getValueAddedTaxPercentage());
            } else if (catalogPieceOfFurniture instanceof CatalogLight) {
                CatalogLight catalogLight = (CatalogLight)catalogPieceOfFurniture;
                catalogPieceOfFurniture = new CatalogLight(catalogLight.getId(), string, catalogLight.getDescription(), catalogLight.getIcon(), catalogLight.getPlanIcon(), catalogLight.getModel(), catalogLight.getWidth(), catalogLight.getDepth(), catalogLight.getHeight(), catalogLight.getElevation(), catalogLight.isMovable(), catalogLight.getLightSources(), catalogLight.getModelRotation(), catalogLight.getCreator(), catalogLight.isResizable(), catalogLight.isDeformable(), catalogLight.isTexturable(), catalogLight.getPrice(), catalogLight.getValueAddedTaxPercentage());
            } else {
                catalogPieceOfFurniture = new CatalogPieceOfFurniture(catalogPieceOfFurniture.getId(), string, catalogPieceOfFurniture.getDescription(), catalogPieceOfFurniture.getIcon(), catalogPieceOfFurniture.getPlanIcon(), catalogPieceOfFurniture.getModel(), catalogPieceOfFurniture.getWidth(), catalogPieceOfFurniture.getDepth(), catalogPieceOfFurniture.getHeight(), catalogPieceOfFurniture.getElevation(), catalogPieceOfFurniture.isMovable(), catalogPieceOfFurniture.getModelRotation(), catalogPieceOfFurniture.getCreator(), catalogPieceOfFurniture.isResizable(), catalogPieceOfFurniture.isDeformable(), catalogPieceOfFurniture.isTexturable(), catalogPieceOfFurniture.getPrice(), catalogPieceOfFurniture.getValueAddedTaxPercentage());
            }
            this.add(furnitureCategory, catalogPieceOfFurniture, map);
        }
    }

    private Content getContent(ResourceBundle resourceBundle, String string, URL uRL, URL uRL2, boolean bl, boolean bl2) {
        String string2;
        String string3 = string2 = bl2 ? this.getOptionalString(resourceBundle, string, null) : resourceBundle.getString(string);
        if (bl2 && string2 == null) {
            return null;
        }
        try {
            URL uRL3 = uRL2 != null ? (string2.indexOf(33) < 0 || string2.startsWith("jar:") ? new URL(uRL2, string2) : new URL("jar:" + new URL(uRL2, string2))) : new URL(string2);
            return new URLContent(uRL3);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                return new ResourceURLContent(DefaultFurnitureCatalog.class, string2, bl);
            }
            try {
                return new ResourceURLContent(new URL("jar:" + uRL + "!" + string2), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid URL", malformedURLException2);
            }
        }
    }

    private float[][] getModelRotation(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            String[] stringArray = string2.split(" ", 9);
            if (stringArray.length == 9) {
                return new float[][]{{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])}, {Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5])}, {Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7]), Float.parseFloat(stringArray[8])}};
            }
            return null;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Sash[] getDoorOrWindowSashes(ResourceBundle resourceBundle, int n, float f, float f2) throws MissingResourceException {
        Sash[] sashArray;
        String string = this.getOptionalString(resourceBundle, PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS.getKey(n), null);
        if (string != null) {
            String[] stringArray = string.split(" ");
            String[] stringArray2 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKey(n)).split(" ");
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKey(n) + " key");
            }
            String[] stringArray3 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKey(n)).split(" ");
            if (stringArray3.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKey(n) + " key");
            }
            String[] stringArray4 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKey(n)).split(" ");
            if (stringArray4.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKey(n) + " key");
            }
            String[] stringArray5 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKey(n)).split(" ");
            if (stringArray5.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKey(n) + " key");
            }
            sashArray = new Sash[stringArray.length];
            for (int i = 0; i < sashArray.length; ++i) {
                sashArray[i] = new Sash(Float.parseFloat(stringArray[i]) / f, Float.parseFloat(stringArray2[i]) / f2, Float.parseFloat(stringArray3[i]) / f, (float)Math.toRadians(Float.parseFloat(stringArray4[i])), (float)Math.toRadians(Float.parseFloat(stringArray5[i])));
            }
        } else {
            sashArray = new Sash[]{};
        }
        return sashArray;
    }

    private LightSource[] getLightSources(ResourceBundle resourceBundle, int n, float f, float f2, float f3) throws MissingResourceException {
        LightSource[] lightSourceArray = null;
        String string = this.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_X.getKey(n), null);
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = string.split(" ");
            String[] stringArray3 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_Y.getKey(n)).split(" ");
            if (stringArray3.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_Y.getKey(n) + " key");
            }
            String[] stringArray4 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_Z.getKey(n)).split(" ");
            if (stringArray4.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_Z.getKey(n) + " key");
            }
            String[] stringArray5 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_COLOR.getKey(n)).split(" ");
            if (stringArray5.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_COLOR.getKey(n) + " key");
            }
            String string2 = this.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_DIAMETER.getKey(n), null);
            if (string2 != null) {
                stringArray = string2.split(" ");
                if (stringArray.length != stringArray2.length) {
                    throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_DIAMETER.getKey(n) + " key");
                }
            } else {
                stringArray = null;
            }
            lightSourceArray = new LightSource[stringArray2.length];
            for (int i = 0; i < lightSourceArray.length; ++i) {
                int n2 = stringArray5[i].startsWith("#") ? Integer.parseInt(stringArray5[i].substring(1), 16) : Integer.parseInt(stringArray5[i]);
                lightSourceArray[i] = new LightSource(Float.parseFloat(stringArray2[i]) / f, Float.parseFloat(stringArray3[i]) / f2, Float.parseFloat(stringArray4[i]) / f3, n2, stringArray != null ? Float.valueOf(Float.parseFloat(stringArray[i]) / f) : null);
            }
        }
        return lightSourceArray;
    }

    private String getOptionalString(ResourceBundle resourceBundle, String string, String string2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private float getOptionalFloat(ResourceBundle resourceBundle, String string, float f) {
        try {
            return Float.parseFloat(resourceBundle.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return f;
        }
    }

    private boolean getOptionalBoolean(ResourceBundle resourceBundle, String string, boolean bl) {
        try {
            return Boolean.parseBoolean(resourceBundle.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        ID("id"),
        NAME("name"),
        DESCRIPTION("description"),
        CATEGORY("category"),
        ICON("icon"),
        PLAN_ICON("planIcon"),
        MODEL("model"),
        MULTI_PART_MODEL("multiPartModel"),
        WIDTH("width"),
        DEPTH("depth"),
        HEIGHT("height"),
        MOVABLE("movable"),
        DOOR_OR_WINDOW("doorOrWindow"),
        DOOR_OR_WINDOW_WALL_THICKNESS("doorOrWindowWallThickness"),
        DOOR_OR_WINDOW_WALL_DISTANCE("doorOrWindowWallDistance"),
        DOOR_OR_WINDOW_SASH_X_AXIS("doorOrWindowSashXAxis"),
        DOOR_OR_WINDOW_SASH_Y_AXIS("doorOrWindowSashYAxis"),
        DOOR_OR_WINDOW_SASH_WIDTH("doorOrWindowSashWidth"),
        DOOR_OR_WINDOW_SASH_START_ANGLE("doorOrWindowSashStartAngle"),
        DOOR_OR_WINDOW_SASH_END_ANGLE("doorOrWindowSashEndAngle"),
        LIGHT_SOURCE_X("lightSourceX"),
        LIGHT_SOURCE_Y("lightSourceY"),
        LIGHT_SOURCE_Z("lightSourceZ"),
        LIGHT_SOURCE_COLOR("lightSourceColor"),
        LIGHT_SOURCE_DIAMETER("lightSourceDiameter"),
        ELEVATION("elevation"),
        MODEL_ROTATION("modelRotation"),
        CREATOR("creator"),
        RESIZABLE("resizable"),
        DEFORMABLE("deformable"),
        TEXTURABLE("texturable"),
        PRICE("price"),
        VALUE_ADDED_TAX_PERCENTAGE("valueAddedTaxPercentage");

        private String keyPrefix;

        private PropertyKey(String string2) {
            this.keyPrefix = string2;
        }

        public String getKey(int n) {
            return this.keyPrefix + "#" + n;
        }
    }
}

