/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.io.DefaultTexturesCatalog;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.PatternsCatalog;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import java.util.ArrayList;

public class DefaultUserPreferences
extends UserPreferences {
    public DefaultUserPreferences() {
        this.setFurnitureCatalog(new DefaultFurnitureCatalog());
        this.setTexturesCatalog(new DefaultTexturesCatalog());
        ArrayList<TextureImage> arrayList = new ArrayList<TextureImage>();
        arrayList.add(new PatternTexture("foreground"));
        arrayList.add(new PatternTexture("hatchUp"));
        arrayList.add(new PatternTexture("hatchDown"));
        arrayList.add(new PatternTexture("crossHatch"));
        arrayList.add(new PatternTexture("background"));
        PatternsCatalog patternsCatalog = new PatternsCatalog(arrayList);
        this.setPatternsCatalog(patternsCatalog);
        this.setFurnitureCatalogViewedInTree(Boolean.parseBoolean(this.getLocalizedString(DefaultUserPreferences.class, "furnitureCatalogViewedInTree", new Object[0])));
        this.setNavigationPanelVisible(Boolean.parseBoolean(this.getLocalizedString(DefaultUserPreferences.class, "navigationPanelVisible", new Object[0])));
        this.setUnit(LengthUnit.valueOf(this.getLocalizedString(DefaultUserPreferences.class, "unit", new Object[0]).toUpperCase()));
        this.setRulersVisible(Boolean.parseBoolean(this.getLocalizedString(DefaultUserPreferences.class, "rulersVisible", new Object[0])));
        this.setGridVisible(Boolean.parseBoolean(this.getLocalizedString(DefaultUserPreferences.class, "gridVisible", new Object[0])));
        this.setFurnitureViewedFromTop(Boolean.parseBoolean(this.getLocalizedString(DefaultUserPreferences.class, "furnitureViewedFromTop", new Object[0])));
        this.setFloorColoredOrTextured(Boolean.parseBoolean(this.getLocalizedString(DefaultUserPreferences.class, "roomFloorColoredOrTextured", new Object[0])));
        this.setWallPattern(patternsCatalog.getPattern(this.getLocalizedString(DefaultUserPreferences.class, "wallPattern", new Object[0])));
        this.setNewWallThickness(Float.parseFloat(this.getLocalizedString(DefaultUserPreferences.class, "newWallThickness", new Object[0])));
        this.setNewWallHeight(Float.parseFloat(this.getLocalizedString(DefaultUserPreferences.class, "newHomeWallHeight", new Object[0])));
        try {
            this.setAutoSaveDelayForRecovery(Integer.parseInt(this.getLocalizedString(DefaultUserPreferences.class, "autoSaveDelayForRecovery", new Object[0])));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setAutoSaveDelayForRecovery(0);
        }
        this.setRecentHomes(new ArrayList<String>());
        try {
            this.setCurrency(this.getLocalizedString(DefaultUserPreferences.class, "currency", new Object[0]));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void write() throws RecorderException {
        throw new RecorderException("Default user preferences can't be written");
    }

    public boolean languageLibraryExists(String string) throws RecorderException {
        throw new RecorderException("Default user preferences can't manage language libraries");
    }

    public void addLanguageLibrary(String string) throws RecorderException {
        throw new RecorderException("Default user preferences can't manage language libraries");
    }

    public boolean furnitureLibraryExists(String string) throws RecorderException {
        throw new RecorderException("Default user preferences can't manage furniture libraries");
    }

    public void addFurnitureLibrary(String string) throws RecorderException {
        throw new RecorderException("Default user preferences can't manage furniture libraries");
    }

    public boolean texturesLibraryExists(String string) throws RecorderException {
        throw new RecorderException("Default user preferences can't manage textures libraries");
    }

    public void addTexturesLibrary(String string) throws RecorderException {
        throw new RecorderException("Default user preferences can't manage textures libraries");
    }

    private static class PatternTexture
    implements TextureImage {
        private final String name;
        private final Content image;

        public PatternTexture(String string) {
            this.name = string;
            this.image = new ResourceURLContent(PatternTexture.class, "resources/patterns/" + string + ".png");
        }

        public String getName() {
            return this.name;
        }

        public Content getImage() {
            return this.image;
        }

        public float getWidth() {
            return 10.0f;
        }

        public float getHeight() {
            return 10.0f;
        }
    }
}

