/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.io.DefaultTexturesCatalog;
import com.eteks.sweethome3d.io.DefaultUserPreferences;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.IllegalHomonymException;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.PatternsCatalog;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUserPreferences
extends UserPreferences {
    private static final String LANGUAGE = "language";
    private static final String UNIT = "unit";
    private static final String FURNITURE_CATALOG_VIEWED_IN_TREE = "furnitureCatalogViewedInTree";
    private static final String NAVIGATION_PANEL_VISIBLE = "navigationPanelVisible";
    private static final String MAGNETISM_ENABLED = "magnetismEnabled";
    private static final String RULERS_VISIBLE = "rulersVisible";
    private static final String GRID_VISIBLE = "gridVisible";
    private static final String FURNITURE_VIEWED_FROM_TOP = "furnitureViewedFromTop";
    private static final String ROOM_FLOOR_COLORED_OR_TEXTURED = "roomFloorColoredOrTextured";
    private static final String WALL_PATTERN = "wallPattern";
    private static final String NEW_WALL_HEIGHT = "newHomeWallHeight";
    private static final String NEW_WALL_THICKNESS = "newWallThickness";
    private static final String AUTO_SAVE_DELAY_FOR_RECOVERY = "autoSaveDelayForRecovery";
    private static final String RECENT_HOMES = "recentHomes#";
    private static final String IGNORED_ACTION_TIP = "ignoredActionTip#";
    private static final String FURNITURE_NAME = "furnitureName#";
    private static final String FURNITURE_CATEGORY = "furnitureCategory#";
    private static final String FURNITURE_ICON = "furnitureIcon#";
    private static final String FURNITURE_MODEL = "furnitureModel#";
    private static final String FURNITURE_WIDTH = "furnitureWidth#";
    private static final String FURNITURE_DEPTH = "furnitureDepth#";
    private static final String FURNITURE_HEIGHT = "furnitureHeight#";
    private static final String FURNITURE_MOVABLE = "furnitureMovable#";
    private static final String FURNITURE_DOOR_OR_WINDOW = "furnitureDoorOrWindow#";
    private static final String FURNITURE_ELEVATION = "furnitureElevation#";
    private static final String FURNITURE_COLOR = "furnitureColor#";
    private static final String FURNITURE_MODEL_ROTATION = "furnitureModelRotation#";
    private static final String FURNITURE_BACK_FACE_SHOWN = "furnitureBackFaceShown#";
    private static final String FURNITURE_ICON_YAW = "furnitureIconYaw#";
    private static final String FURNITURE_PROPORTIONAL = "furnitureProportional#";
    private static final String TEXTURE_NAME = "textureName#";
    private static final String TEXTURE_CATEGORY = "textureCategory#";
    private static final String TEXTURE_IMAGE = "textureImage#";
    private static final String TEXTURE_WIDTH = "textureWidth#";
    private static final String TEXTURE_HEIGHT = "textureHeight#";
    private static final String FURNITURE_CONTENT_PREFIX = "Furniture-3-";
    private static final String TEXTURE_CONTENT_PREFIX = "Texture-3-";
    private static final String LANGUAGE_LIBRARIES_PLUGIN_SUB_FOLDER = "languages";
    private static final String FURNITURE_LIBRARIES_PLUGIN_SUB_FOLDER = "furniture";
    private static final String TEXTURES_LIBRARIES_PLUGIN_SUB_FOLDER = "textures";
    private static final Content DUMMY_CONTENT;
    private final Map<String, Boolean> ignoredActionTips = new HashMap<String, Boolean>();
    private List<ClassLoader> resourceClassLoaders;
    private String[] supportedLanguages;
    private final File preferencesFolder;
    private final File[] applicationFolders;
    private Preferences preferences;

    public FileUserPreferences() {
        this(null, null);
    }

    public FileUserPreferences(File file, File[] fileArray) {
        String string;
        int n;
        this.preferencesFolder = file;
        this.applicationFolders = fileArray;
        this.updateSupportedLanguages();
        PortablePreferences portablePreferences = new PortablePreferences();
        Preferences preferences = !portablePreferences.exist() && file == null ? this.getPreferences() : portablePreferences;
        this.setLanguage(preferences.get(LANGUAGE, this.getLanguage()));
        this.setFurnitureCatalog(new DefaultFurnitureCatalog((UserPreferences)this, this.getFurnitureLibrariesPluginFolders()));
        this.readFurnitureCatalog(preferences);
        this.setTexturesCatalog(new DefaultTexturesCatalog((UserPreferences)this, this.getTexturesLibrariesPluginFolders()));
        this.readTexturesCatalog(preferences);
        DefaultUserPreferences defaultUserPreferences = new DefaultUserPreferences();
        defaultUserPreferences.setLanguage(this.getLanguage());
        PatternsCatalog patternsCatalog = defaultUserPreferences.getPatternsCatalog();
        this.setPatternsCatalog(patternsCatalog);
        this.setUnit(LengthUnit.valueOf(preferences.get(UNIT, defaultUserPreferences.getLengthUnit().name())));
        this.setFurnitureCatalogViewedInTree(preferences.getBoolean(FURNITURE_CATALOG_VIEWED_IN_TREE, defaultUserPreferences.isFurnitureCatalogViewedInTree()));
        this.setNavigationPanelVisible(preferences.getBoolean(NAVIGATION_PANEL_VISIBLE, defaultUserPreferences.isNavigationPanelVisible()));
        this.setMagnetismEnabled(preferences.getBoolean(MAGNETISM_ENABLED, true));
        this.setRulersVisible(preferences.getBoolean(RULERS_VISIBLE, defaultUserPreferences.isRulersVisible()));
        this.setGridVisible(preferences.getBoolean(GRID_VISIBLE, defaultUserPreferences.isGridVisible()));
        this.setFurnitureViewedFromTop(preferences.getBoolean(FURNITURE_VIEWED_FROM_TOP, defaultUserPreferences.isFurnitureViewedFromTop()));
        this.setFloorColoredOrTextured(preferences.getBoolean(ROOM_FLOOR_COLORED_OR_TEXTURED, defaultUserPreferences.isRoomFloorColoredOrTextured()));
        try {
            this.setWallPattern(patternsCatalog.getPattern(preferences.get(WALL_PATTERN, defaultUserPreferences.getWallPattern().getName())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setWallPattern(defaultUserPreferences.getWallPattern());
        }
        this.setNewWallThickness(preferences.getFloat(NEW_WALL_THICKNESS, defaultUserPreferences.getNewWallThickness()));
        this.setNewWallHeight(preferences.getFloat(NEW_WALL_HEIGHT, defaultUserPreferences.getNewWallHeight()));
        this.setAutoSaveDelayForRecovery(preferences.getInt(AUTO_SAVE_DELAY_FOR_RECOVERY, defaultUserPreferences.getAutoSaveDelayForRecovery()));
        this.setCurrency(defaultUserPreferences.getCurrency());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 1; n <= this.getRecentHomesMaxCount(); ++n) {
            string = preferences.get(RECENT_HOMES + n, null);
            if (string == null) continue;
            arrayList.add(string);
        }
        this.setRecentHomes(arrayList);
        n = 1;
        while ((string = preferences.get(IGNORED_ACTION_TIP + n, "")).length() != 0) {
            this.ignoredActionTips.put(string, true);
            ++n;
        }
        this.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileUserPreferences.this.updateFurnitureDefaultCatalog();
                FileUserPreferences.this.updateTexturesDefaultCatalog();
            }
        });
        if (preferences != portablePreferences) {
            preferences = portablePreferences;
        }
        this.preferences = preferences;
    }

    private void updateSupportedLanguages() {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        String[] stringArray = super.getSupportedLanguages();
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
        File[] fileArray = this.getLanguageLibrariesPluginFolders();
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder());
                for (File file2 : fileArray2) {
                    try {
                        Set<String> set = this.getLanguages(file2);
                        if (set.isEmpty()) continue;
                        treeSet.addAll(set);
                        URL uRL = file2.toURI().toURL();
                        arrayList.add(new URLClassLoader(new URL[]{uRL}));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        arrayList.addAll(super.getResourceClassLoaders());
        this.resourceClassLoaders = Collections.unmodifiableList(arrayList);
        this.supportedLanguages = stringArray.length < treeSet.size() ? treeSet.toArray(new String[treeSet.size()]) : stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getLanguages(File file) throws IOException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ZipInputStream zipInputStream = null;
        try {
            Cloneable cloneable;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((cloneable = zipInputStream.getNextEntry()) != null) {
                int n;
                String string = cloneable.getName();
                int n2 = string.indexOf(95);
                if (n2 == -1 || (n = string.lastIndexOf(".properties")) == -1 || n2 >= n - 2) continue;
                String string2 = string.substring(n2 + 1, n);
                int n3 = string2.indexOf(95);
                if (n3 == 2 && string2.length() == 5) {
                    linkedHashSet.add(string2);
                    continue;
                }
                if (string2.length() != 2) continue;
                linkedHashSet.add(string2);
            }
            cloneable = linkedHashSet;
            return cloneable;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    @Override
    public String[] getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @Override
    public List<ClassLoader> getResourceClassLoaders() {
        return this.resourceClassLoaders;
    }

    private void updateFurnitureDefaultCatalog() {
        FurnitureCatalog furnitureCatalog = this.getFurnitureCatalog();
        for (FurnitureCategory object : furnitureCatalog.getCategories()) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : object.getFurniture()) {
                if (catalogPieceOfFurniture.isModifiable()) continue;
                furnitureCatalog.delete(catalogPieceOfFurniture);
            }
        }
        DefaultFurnitureCatalog defaultFurnitureCatalog = new DefaultFurnitureCatalog((UserPreferences)this, this.getFurnitureLibrariesPluginFolders());
        for (FurnitureCategory furnitureCategory : defaultFurnitureCatalog.getCategories()) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                try {
                    furnitureCatalog.add(furnitureCategory, catalogPieceOfFurniture);
                }
                catch (IllegalHomonymException illegalHomonymException) {}
            }
        }
    }

    private void updateTexturesDefaultCatalog() {
        TexturesCatalog texturesCatalog = this.getTexturesCatalog();
        for (TexturesCategory object : texturesCatalog.getCategories()) {
            for (CatalogTexture catalogTexture : object.getTextures()) {
                if (catalogTexture.isModifiable()) continue;
                texturesCatalog.delete(catalogTexture);
            }
        }
        DefaultTexturesCatalog defaultTexturesCatalog = new DefaultTexturesCatalog((UserPreferences)this, this.getTexturesLibrariesPluginFolders());
        for (TexturesCategory texturesCategory : defaultTexturesCatalog.getCategories()) {
            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                try {
                    texturesCatalog.add(texturesCategory, catalogTexture);
                }
                catch (IllegalHomonymException illegalHomonymException) {}
            }
        }
    }

    private void readFurnitureCatalog(Preferences preferences) {
        String string;
        int n = 1;
        while ((string = preferences.get(FURNITURE_NAME + n, null)) != null) {
            String string2 = preferences.get(FURNITURE_CATEGORY + n, "");
            Content content = this.getContent(preferences, FURNITURE_ICON + n);
            Content content2 = this.getContent(preferences, FURNITURE_MODEL + n);
            float f = preferences.getFloat(FURNITURE_WIDTH + n, 0.1f);
            float f2 = preferences.getFloat(FURNITURE_DEPTH + n, 0.1f);
            float f3 = preferences.getFloat(FURNITURE_HEIGHT + n, 0.1f);
            boolean bl = preferences.getBoolean(FURNITURE_MOVABLE + n, false);
            boolean bl2 = preferences.getBoolean(FURNITURE_DOOR_OR_WINDOW + n, false);
            float f4 = preferences.getFloat(FURNITURE_ELEVATION + n, 0.0f);
            String string3 = preferences.get(FURNITURE_COLOR + n, null);
            Integer n2 = string3 != null ? Integer.valueOf(string3) : null;
            float[][] fArray = this.getModelRotation(preferences, FURNITURE_MODEL_ROTATION + n);
            boolean bl3 = preferences.getBoolean(FURNITURE_BACK_FACE_SHOWN + n, false);
            float f5 = preferences.getFloat(FURNITURE_ICON_YAW + n, 0.0f);
            boolean bl4 = preferences.getBoolean(FURNITURE_PROPORTIONAL + n, true);
            FurnitureCategory furnitureCategory = new FurnitureCategory(string2);
            CatalogPieceOfFurniture catalogPieceOfFurniture = bl2 ? new CatalogDoorOrWindow(string, content, content2, f, f2, f3, f4, bl, 1.0f, 0.0f, new Sash[0], n2, fArray, bl3, f5, bl4) : new CatalogPieceOfFurniture(string, content, content2, f, f2, f3, f4, bl, n2, fArray, bl3, f5, bl4);
            try {
                this.getFurnitureCatalog().add(furnitureCategory, catalogPieceOfFurniture);
            }
            catch (IllegalHomonymException illegalHomonymException) {
                List<FurnitureCategory> list = this.getFurnitureCatalog().getCategories();
                int n3 = Collections.binarySearch(list, furnitureCategory);
                List<CatalogPieceOfFurniture> list2 = list.get(n3).getFurniture();
                int n4 = Collections.binarySearch(list2, catalogPieceOfFurniture);
                this.getFurnitureCatalog().delete(list2.get(n4));
                this.getFurnitureCatalog().add(furnitureCategory, catalogPieceOfFurniture);
            }
            ++n;
        }
    }

    private float[][] getModelRotation(Preferences preferences, String string) {
        String string2 = preferences.get(string, null);
        if (string2 == null) {
            return new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
        String[] stringArray = string2.split(" ", 9);
        if (stringArray.length != 9) {
            return new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
        try {
            return new float[][]{{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])}, {Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5])}, {Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7]), Float.parseFloat(stringArray[8])}};
        }
        catch (NumberFormatException numberFormatException) {
            return new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
    }

    private Content getContent(Preferences preferences, String string) {
        String string2 = preferences.get(string, null);
        if (string2 != null) {
            try {
                String string3 = this.getPreferencesFolder().toURI().toURL().toString();
                if (string2.startsWith(string3) || string2.startsWith("jar:" + string3)) {
                    return new URLContent(new URL(string2));
                }
                return new URLContent(new URL(string2.replace("file:", string3)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DUMMY_CONTENT;
    }

    private void readTexturesCatalog(Preferences preferences) {
        String string;
        int n = 1;
        while ((string = preferences.get(TEXTURE_NAME + n, null)) != null) {
            String string2 = preferences.get(TEXTURE_CATEGORY + n, "");
            Content content = this.getContent(preferences, TEXTURE_IMAGE + n);
            float f = preferences.getFloat(TEXTURE_WIDTH + n, 0.1f);
            float f2 = preferences.getFloat(TEXTURE_HEIGHT + n, 0.1f);
            TexturesCategory texturesCategory = new TexturesCategory(string2);
            CatalogTexture catalogTexture = new CatalogTexture(string, content, f, f2, true);
            try {
                this.getTexturesCatalog().add(texturesCategory, catalogTexture);
            }
            catch (IllegalHomonymException illegalHomonymException) {
                List<TexturesCategory> list = this.getTexturesCatalog().getCategories();
                int n2 = Collections.binarySearch(list, texturesCategory);
                List<CatalogTexture> list2 = list.get(n2).getTextures();
                int n3 = Collections.binarySearch(list2, catalogTexture);
                this.getTexturesCatalog().delete(list2.get(n3));
                this.getTexturesCatalog().add(texturesCategory, catalogTexture);
            }
            ++n;
        }
    }

    @Override
    public void write() throws RecorderException {
        int n;
        Preferences preferences = this.getPreferences();
        this.writeFurnitureCatalog(preferences);
        this.writeTexturesCatalog(preferences);
        preferences.put(LANGUAGE, this.getLanguage());
        preferences.put(UNIT, this.getLengthUnit().name());
        preferences.putBoolean(FURNITURE_CATALOG_VIEWED_IN_TREE, this.isFurnitureCatalogViewedInTree());
        preferences.putBoolean(NAVIGATION_PANEL_VISIBLE, this.isNavigationPanelVisible());
        preferences.putBoolean(MAGNETISM_ENABLED, this.isMagnetismEnabled());
        preferences.putBoolean(RULERS_VISIBLE, this.isRulersVisible());
        preferences.putBoolean(GRID_VISIBLE, this.isGridVisible());
        preferences.putBoolean(FURNITURE_VIEWED_FROM_TOP, this.isFurnitureViewedFromTop());
        preferences.putBoolean(ROOM_FLOOR_COLORED_OR_TEXTURED, this.isRoomFloorColoredOrTextured());
        preferences.put(WALL_PATTERN, this.getWallPattern().getName());
        preferences.putFloat(NEW_WALL_THICKNESS, this.getNewWallThickness());
        preferences.putFloat(NEW_WALL_HEIGHT, this.getNewWallHeight());
        preferences.putInt(AUTO_SAVE_DELAY_FOR_RECOVERY, this.getAutoSaveDelayForRecovery());
        Iterator<Object> iterator = this.getRecentHomes().iterator();
        for (n = 1; iterator.hasNext() && n <= this.getRecentHomesMaxCount(); ++n) {
            preferences.put(RECENT_HOMES + n, (String)iterator.next());
        }
        while (n <= this.getRecentHomesMaxCount()) {
            preferences.remove(RECENT_HOMES + n);
            ++n;
        }
        n = 1;
        for (Map.Entry entry : this.ignoredActionTips.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            preferences.put(IGNORED_ACTION_TIP + n++, (String)entry.getKey());
        }
        while (n <= this.ignoredActionTips.size()) {
            preferences.remove(IGNORED_ACTION_TIP + n);
            ++n;
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RecorderException("Couldn't write preferences", backingStoreException);
        }
    }

    private void writeFurnitureCatalog(Preferences preferences) throws RecorderException {
        HashSet<URL> hashSet = new HashSet<URL>();
        int n = 1;
        for (FurnitureCategory furnitureCategory : this.getFurnitureCatalog().getCategories()) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                if (!catalogPieceOfFurniture.isModifiable()) continue;
                preferences.put(FURNITURE_NAME + n, catalogPieceOfFurniture.getName());
                preferences.put(FURNITURE_CATEGORY + n, furnitureCategory.getName());
                this.putContent(preferences, FURNITURE_ICON + n, catalogPieceOfFurniture.getIcon(), FURNITURE_CONTENT_PREFIX, hashSet);
                this.putContent(preferences, FURNITURE_MODEL + n, catalogPieceOfFurniture.getModel(), FURNITURE_CONTENT_PREFIX, hashSet);
                preferences.putFloat(FURNITURE_WIDTH + n, catalogPieceOfFurniture.getWidth());
                preferences.putFloat(FURNITURE_DEPTH + n, catalogPieceOfFurniture.getDepth());
                preferences.putFloat(FURNITURE_HEIGHT + n, catalogPieceOfFurniture.getHeight());
                preferences.putBoolean(FURNITURE_MOVABLE + n, catalogPieceOfFurniture.isMovable());
                preferences.putBoolean(FURNITURE_DOOR_OR_WINDOW + n, catalogPieceOfFurniture.isDoorOrWindow());
                preferences.putFloat(FURNITURE_ELEVATION + n, catalogPieceOfFurniture.getElevation());
                if (catalogPieceOfFurniture.getColor() == null) {
                    preferences.remove(FURNITURE_COLOR + n);
                } else {
                    preferences.put(FURNITURE_COLOR + n, String.valueOf(catalogPieceOfFurniture.getColor()));
                }
                float[][] fArray = catalogPieceOfFurniture.getModelRotation();
                preferences.put(FURNITURE_MODEL_ROTATION + n, fArray[0][0] + " " + fArray[0][1] + " " + fArray[0][2] + " " + fArray[1][0] + " " + fArray[1][1] + " " + fArray[1][2] + " " + fArray[2][0] + " " + fArray[2][1] + " " + fArray[2][2]);
                preferences.putBoolean(FURNITURE_BACK_FACE_SHOWN + n, catalogPieceOfFurniture.isBackFaceShown());
                preferences.putFloat(FURNITURE_ICON_YAW + n, catalogPieceOfFurniture.getIconYaw());
                preferences.putBoolean(FURNITURE_PROPORTIONAL + n, catalogPieceOfFurniture.isProportional());
                ++n;
            }
        }
        while (preferences.get(FURNITURE_NAME + n, null) != null) {
            preferences.remove(FURNITURE_NAME + n);
            preferences.remove(FURNITURE_CATEGORY + n);
            preferences.remove(FURNITURE_ICON + n);
            preferences.remove(FURNITURE_MODEL + n);
            preferences.remove(FURNITURE_WIDTH + n);
            preferences.remove(FURNITURE_DEPTH + n);
            preferences.remove(FURNITURE_HEIGHT + n);
            preferences.remove(FURNITURE_MOVABLE + n);
            preferences.remove(FURNITURE_DOOR_OR_WINDOW + n);
            preferences.remove(FURNITURE_ELEVATION + n);
            preferences.remove(FURNITURE_COLOR + n);
            preferences.remove(FURNITURE_MODEL_ROTATION + n);
            preferences.remove(FURNITURE_BACK_FACE_SHOWN + n);
            preferences.remove(FURNITURE_ICON_YAW + n);
            preferences.remove(FURNITURE_PROPORTIONAL + n);
            ++n;
        }
        this.deleteObsoleteContent(hashSet, FURNITURE_CONTENT_PREFIX);
    }

    private void writeTexturesCatalog(Preferences preferences) throws RecorderException {
        HashSet<URL> hashSet = new HashSet<URL>();
        int n = 1;
        for (TexturesCategory texturesCategory : this.getTexturesCatalog().getCategories()) {
            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                if (!catalogTexture.isModifiable()) continue;
                preferences.put(TEXTURE_NAME + n, catalogTexture.getName());
                preferences.put(TEXTURE_CATEGORY + n, texturesCategory.getName());
                this.putContent(preferences, TEXTURE_IMAGE + n, catalogTexture.getImage(), TEXTURE_CONTENT_PREFIX, hashSet);
                preferences.putFloat(TEXTURE_WIDTH + n, catalogTexture.getWidth());
                preferences.putFloat(TEXTURE_HEIGHT + n, catalogTexture.getHeight());
                ++n;
            }
        }
        while (preferences.get(TEXTURE_NAME + n, null) != null) {
            preferences.remove(TEXTURE_NAME + n);
            preferences.remove(TEXTURE_CATEGORY + n);
            preferences.remove(TEXTURE_IMAGE + n);
            preferences.remove(TEXTURE_WIDTH + n);
            preferences.remove(TEXTURE_HEIGHT + n);
            ++n;
        }
        this.deleteObsoleteContent(hashSet, TEXTURE_CONTENT_PREFIX);
    }

    private void putContent(Preferences preferences, String string, Content content, String string2, Set<URL> set) throws RecorderException {
        if (content instanceof TemporaryURLContent) {
            URLContent uRLContent;
            URLContent uRLContent2 = (URLContent)content;
            if (uRLContent2.isJAREntry()) {
                try {
                    uRLContent = this.copyToPreferencesURLContent(new URLContent(uRLContent2.getJAREntryURL()), string2);
                    uRLContent = new URLContent(new URL("jar:" + uRLContent.getURL() + "!/" + uRLContent2.getJAREntryName()));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RecorderException("Can't build URL", malformedURLException);
                }
            } else {
                uRLContent = this.copyToPreferencesURLContent(uRLContent2, string2);
            }
            this.putContent(preferences, string, uRLContent, string2, set);
        } else if (content instanceof URLContent) {
            URLContent uRLContent = (URLContent)content;
            try {
                preferences.put(string, uRLContent.getURL().toString().replace(this.getPreferencesFolder().toURI().toURL().toString(), "file:"));
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't save content", iOException);
            }
            if (uRLContent.isJAREntry()) {
                set.add(uRLContent.getJAREntryURL());
            } else {
                set.add(uRLContent.getURL());
            }
        } else {
            this.putContent(preferences, string, this.copyToPreferencesURLContent(content, string2), string2, set);
        }
    }

    private URLContent copyToPreferencesURLContent(Content content, String string) throws RecorderException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            File file = this.createPreferencesFile(string);
            inputStream = content.openStream();
            outputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            URLContent uRLContent = new URLContent(file.toURI().toURL());
            return uRLContent;
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't save content", iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close files", iOException);
            }
        }
    }

    private File[] getLanguageLibrariesPluginFolders() {
        try {
            return this.getApplicationSubfolders(LANGUAGE_LIBRARIES_PLUGIN_SUB_FOLDER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File[] getFurnitureLibrariesPluginFolders() {
        try {
            return this.getApplicationSubfolders(FURNITURE_LIBRARIES_PLUGIN_SUB_FOLDER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File[] getTexturesLibrariesPluginFolders() {
        try {
            return this.getApplicationSubfolders(TEXTURES_LIBRARIES_PLUGIN_SUB_FOLDER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public File getApplicationFolder() throws IOException {
        File[] fileArray = this.getApplicationFolders();
        if (fileArray.length == 0) {
            throw new IOException("No application folder defined");
        }
        return fileArray[0];
    }

    public File[] getApplicationFolders() throws IOException {
        if (this.applicationFolders != null) {
            return this.applicationFolders;
        }
        return new File[]{OperatingSystem.getDefaultApplicationFolder()};
    }

    public File[] getApplicationSubfolders(String string) throws IOException {
        File[] fileArray = this.getApplicationFolders();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new File(fileArray[i], string);
        }
        return fileArray2;
    }

    private File createPreferencesFile(String string) throws IOException {
        File file = this.getPreferencesFolder();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Couldn't create " + file);
        }
        return File.createTempFile(string, ".pref", file);
    }

    private void deleteObsoleteContent(final Set<URL> set, final String string) throws RecorderException {
        File file;
        try {
            file = this.getPreferencesFolder();
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't access to application folder");
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                try {
                    URL uRL = file.toURI().toURL();
                    return file.getName().startsWith(string) && !set.contains(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                file2.deleteOnExit();
            }
        }
    }

    private File getPreferencesFolder() throws IOException {
        if (this.preferencesFolder != null) {
            return this.preferencesFolder;
        }
        return OperatingSystem.getDefaultApplicationFolder();
    }

    protected Preferences getPreferences() {
        if (this.preferences != null) {
            return this.preferences;
        }
        return Preferences.userNodeForPackage(FileUserPreferences.class);
    }

    @Override
    public void setActionTipIgnored(String string) {
        this.ignoredActionTips.put(string, true);
        super.setActionTipIgnored(string);
    }

    @Override
    public boolean isActionTipIgnored(String string) {
        Boolean bl = this.ignoredActionTips.get(string);
        return bl != null && bl != false;
    }

    @Override
    public void resetIgnoredActionTips() {
        for (Map.Entry<String, Boolean> entry : this.ignoredActionTips.entrySet()) {
            entry.setValue(false);
        }
        super.resetIgnoredActionTips();
    }

    @Override
    public boolean languageLibraryExists(String string) throws RecorderException {
        File[] fileArray = this.getLanguageLibrariesPluginFolders();
        if (fileArray == null || fileArray.length == 0) {
            throw new RecorderException("Can't access to language libraries plugin folder");
        }
        String string2 = new File(string).getName();
        return new File(fileArray[0], string2).exists();
    }

    @Override
    public void addLanguageLibrary(String string) throws RecorderException {
        try {
            File[] fileArray = this.getLanguageLibrariesPluginFolders();
            if (fileArray == null || fileArray.length == 0) {
                throw new RecorderException("Can't access to language libraries plugin folder");
            }
            File file = new File(string);
            this.copyToLibraryFolder(file, fileArray[0]);
            this.updateSupportedLanguages();
            Set<String> set = this.getLanguages(file);
            if (!set.isEmpty()) {
                this.setLanguage(set.iterator().next());
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in language libraries plugin folder", iOException);
        }
    }

    @Override
    public boolean furnitureLibraryExists(String string) throws RecorderException {
        File[] fileArray = this.getFurnitureLibrariesPluginFolders();
        if (fileArray == null || fileArray.length == 0) {
            throw new RecorderException("Can't access to furniture libraries plugin folder");
        }
        String string2 = new File(string).getName();
        return new File(fileArray[0], string2).exists();
    }

    @Override
    public void addFurnitureLibrary(String string) throws RecorderException {
        try {
            File[] fileArray = this.getFurnitureLibrariesPluginFolders();
            if (fileArray == null || fileArray.length == 0) {
                throw new RecorderException("Can't access to furniture libraries plugin folder");
            }
            this.copyToLibraryFolder(new File(string), fileArray[0]);
            this.updateFurnitureDefaultCatalog();
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in furniture libraries plugin folder", iOException);
        }
    }

    @Override
    public boolean texturesLibraryExists(String string) throws RecorderException {
        File[] fileArray = this.getTexturesLibrariesPluginFolders();
        if (fileArray == null || fileArray.length == 0) {
            throw new RecorderException("Can't access to textures libraries plugin folder");
        }
        String string2 = new File(string).getName();
        return new File(fileArray[0], string2).exists();
    }

    @Override
    public void addTexturesLibrary(String string) throws RecorderException {
        try {
            File[] fileArray = this.getTexturesLibrariesPluginFolders();
            if (fileArray == null || fileArray.length == 0) {
                throw new RecorderException("Can't access to textures libraries plugin folder");
            }
            this.copyToLibraryFolder(new File(string), fileArray[0]);
            this.updateTexturesDefaultCatalog();
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in textures libraries plugin folder", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToLibraryFolder(File file, File file2) throws IOException {
        String string = file.getName();
        File file3 = new File(file2, string);
        if (file3.exists()) {
            file3.delete();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            file2.mkdirs();
            outputStream = new FileOutputStream(file3);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    static {
        URLContent uRLContent = null;
        try {
            uRLContent = new URLContent(new URL("file:/dummySweetHome3DContent"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        DUMMY_CONTENT = uRLContent;
    }

    private class PortablePreferences
    extends AbstractPreferences {
        private static final String PREFERENCES_FILE = "preferences.xml";
        private Properties preferencesProperties;
        private boolean exist;

        private PortablePreferences() {
            super(null, "");
            this.preferencesProperties = new Properties();
            this.exist = this.readPreferences();
        }

        public boolean exist() {
            return this.exist;
        }

        protected void syncSpi() throws BackingStoreException {
            this.preferencesProperties.clear();
            this.exist = this.readPreferences();
        }

        protected void removeSpi(String string) {
            this.preferencesProperties.remove(string);
        }

        protected void putSpi(String string, String string2) {
            this.preferencesProperties.put(string, string2);
        }

        protected String[] keysSpi() throws BackingStoreException {
            return this.preferencesProperties.keySet().toArray(new String[0]);
        }

        protected String getSpi(String string) {
            return (String)this.preferencesProperties.get(string);
        }

        protected void flushSpi() throws BackingStoreException {
            try {
                this.writePreferences();
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readPreferences() {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(FileUserPreferences.this.getPreferencesFolder(), PREFERENCES_FILE));
                this.preferencesProperties.loadFromXML(inputStream);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePreferences() throws IOException {
            OutputStream outputStream = null;
            try {
                FileUserPreferences.this.getPreferencesFolder().mkdirs();
                outputStream = new FileOutputStream(new File(FileUserPreferences.this.getPreferencesFolder(), PREFERENCES_FILE));
                this.preferencesProperties.storeToXML(outputStream, "Portable user preferences 3.0");
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                    this.exist = true;
                }
            }
        }
    }
}

