/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.OBJMaterial;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.j3d.Room3D;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import java.awt.AlphaComposite;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.sunflow.PluginRegistry;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Display;
import org.sunflow.core.Instance;
import org.sunflow.core.ParameterList;
import org.sunflow.core.light.SphereLight;
import org.sunflow.core.light.SunSkyLight;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;
import org.sunflow.system.UserInterface;
import org.sunflow.system.ui.SilentInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoRenderer {
    private final Quality quality;
    private final Compass compass;
    private final int homeLightColor;
    private final SunflowAPI sunflow;
    private boolean useSunSky;
    private boolean useAmbientOcclusion;
    private String sunSkyLightName;
    private String sunLightName;
    private final Map<TransparentTextureKey, String> textureImagesCache = new HashMap<TransparentTextureKey, String>();
    private Thread renderingThread;

    public PhotoRenderer(Home home, Quality quality) throws IOException {
        this(home, new Object3DBranchFactory(){

            public Object createObject3D(Home home, Selectable selectable, boolean bl) {
                if (selectable instanceof Room) {
                    return new Room3D((Room)selectable, home, home.getCamera() == home.getTopCamera(), true, bl);
                }
                return super.createObject3D(home, selectable, bl);
            }
        }, quality);
    }

    public PhotoRenderer(Home home, Object3DFactory object3DFactory, Quality quality) throws IOException {
        this.compass = home.getCompass();
        this.quality = quality;
        this.sunflow = new SunflowAPI();
        this.useAmbientOcclusion = home.getCamera() instanceof ObserverCamera;
        boolean bl = this.useAmbientOcclusion && quality == Quality.HIGH;
        for (Wall object2 : home.getWalls()) {
            this.exportNode((Node)object3DFactory.createObject3D(home, object2, true), true, false, bl);
        }
        for (HomePieceOfFurniture homePieceOfFurniture : home.getFurniture()) {
            this.exportNode((Node)object3DFactory.createObject3D(home, homePieceOfFurniture, true), false, false, bl);
        }
        for (Room room : home.getRooms()) {
            this.exportNode((Node)object3DFactory.createObject3D(home, room, true), true, false, bl);
        }
        Home home2 = new Home();
        home2.getEnvironment().setGroundColor(home.getEnvironment().getGroundColor());
        home2.getEnvironment().setGroundTexture(home.getEnvironment().getGroundTexture());
        Ground3D ground3D = new Ground3D(home2, -5000000.0f, -5000000.0f, 1.0E7f, 1.0E7f, true);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, -0.1f, 0.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)ground3D);
        this.exportNode((Node)transformGroup, true, true, bl);
        HomeTexture homeTexture = home.getEnvironment().getSkyTexture();
        boolean bl2 = this.useSunSky = homeTexture == null || !(home.getCamera() instanceof ObserverCamera);
        if (!this.useSunSky) {
            InputStream inputStream = homeTexture.getImage().openStream();
            Iterator<HomeLight> iterator = ImageIO.read(inputStream);
            inputStream.close();
            BufferedImage bufferedImage = new BufferedImage(((BufferedImage)((Object)iterator)).getWidth(), ((BufferedImage)((Object)iterator)).getHeight() * 2, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawRenderedImage((RenderedImage)((Object)iterator), null);
            graphics2D.dispose();
            File file = OperatingSystem.createTemporaryFile("ibl", ".png");
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            this.sunflow.parameter("texture", file.getAbsolutePath());
            this.sunflow.parameter("center", new Vector3(-1.0f, 0.0f, 0.0f));
            this.sunflow.parameter("up", new Vector3(0.0f, 1.0f, 0.0f));
            this.sunflow.parameter("fixed", true);
            this.sunflow.parameter("samples", 0);
            this.sunflow.light(UUID.randomUUID().toString(), "ibl");
        }
        int n = home.getEnvironment().getCeillingLightColor();
        this.homeLightColor = home.getEnvironment().getLightColor();
        if (n > 0) {
            for (Room room : home.getRooms()) {
                if (!room.isCeilingVisible()) continue;
                float f = room.getXCenter();
                float f2 = room.getYCenter();
                double d = Double.POSITIVE_INFINITY;
                float f3 = home.getWallHeight();
                for (Wall wall : home.getWalls()) {
                    Float f4 = wall.getHeight();
                    float[][] fArray = wall.getPoints();
                    for (int i = 0; i < fArray.length; ++i) {
                        double d2 = Point2D.distanceSq(fArray[i][0], fArray[i][1], f, f2);
                        if (!(d2 < d)) continue;
                        d = d2;
                        f3 = i == 0 || i == 3 ? (f4 != null ? f4.floatValue() : home.getWallHeight()) : (wall.isTrapezoidal() ? wall.getHeightAtEnd().floatValue() : (f4 != null ? f4.floatValue() : home.getWallHeight()));
                    }
                }
                float f5 = (float)Math.sqrt(room.getArea()) / 3.0f;
                this.sunflow.parameter("radiance", null, new float[]{f5 * (float)(n >> 16) / 208.0f * (float)(this.homeLightColor >> 16) / 255.0f, f5 * (float)(n >> 8 & 0xFF) / 208.0f * (float)(this.homeLightColor >> 8 & 0xFF) / 255.0f, f5 * (float)(n & 0xFF) / 208.0f * (float)(this.homeLightColor & 0xFF) / 255.0f});
                this.sunflow.parameter("center", new Point3(f, f3 - 25.0f, f2));
                this.sunflow.parameter("radius", 20.0f);
                this.sunflow.parameter("samples", 4);
                this.sunflow.light(UUID.randomUUID().toString(), "sphere");
            }
        }
        for (HomeLight homeLight : this.getLights(home.getFurniture())) {
            float f = homeLight.getPower();
            if (!homeLight.isVisible() || !(f > 0.0f)) continue;
            float f6 = homeLight.getAngle();
            float f7 = (float)Math.cos(f6);
            float f8 = (float)Math.sin(f6);
            for (LightSource lightSource : homeLight.getLightSources()) {
                float f9 = lightSource.getDiameter() != null ? lightSource.getDiameter().floatValue() * homeLight.getWidth() / 2.0f : 3.25f;
                float f10 = 5.0f * f * f / (f9 * f9);
                int n2 = lightSource.getColor();
                this.sunflow.parameter("radiance", null, new float[]{f10 * (float)(n2 >> 16) * (float)(this.homeLightColor >> 16), f10 * (float)(n2 >> 8 & 0xFF) * (float)(this.homeLightColor >> 8 & 0xFF), f10 * (float)(n2 & 0xFF) * (float)(this.homeLightColor & 0xFF)});
                float f11 = -homeLight.getWidth() / 2.0f + lightSource.getX() * homeLight.getWidth();
                float f12 = homeLight.getDepth() / 2.0f - lightSource.getY() * homeLight.getDepth();
                this.sunflow.parameter("center", new Point3(homeLight.getX() + f11 * f7 - f12 * f8, homeLight.getElevation() + lightSource.getZ() * homeLight.getHeight(), homeLight.getY() + f11 * f8 + f12 * f7));
                this.sunflow.parameter("radius", f9);
                this.sunflow.parameter("samples", 4);
                this.sunflow.light(UUID.randomUUID().toString(), "sphere");
            }
        }
        this.sunflow.parameter("depths.diffuse", 1);
        this.sunflow.parameter("depths.reflection", 4);
        this.sunflow.parameter("depths.refraction", 16);
        this.sunflow.options("::options");
        this.sunflow.parameter("bucket.size", 32);
        this.sunflow.parameter("bucket.order", "spiral");
        this.sunflow.options("::options");
    }

    public void render(BufferedImage bufferedImage, Camera camera, ImageObserver imageObserver) {
        Object object;
        ParameterList parameterList;
        float[] fArray;
        this.renderingThread = Thread.currentThread();
        if (this.sunSkyLightName != null) {
            this.sunflow.remove(this.sunSkyLightName);
        }
        if (this.sunLightName != null) {
            this.sunflow.remove(this.sunLightName);
        }
        if ((fArray = this.getSunDirection(this.compass, Camera.convertTimeToTimeZone(camera.getTime(), this.compass.getTimeZone())))[1] > -0.075f) {
            if (this.useSunSky) {
                this.sunflow.parameter("up", new Vector3(0.0f, 1.0f, 0.0f));
                this.sunflow.parameter("east", new Vector3((float)Math.sin(this.compass.getNorthDirection()), 0.0f, (float)Math.cos(this.compass.getNorthDirection())));
                this.sunflow.parameter("sundir", new Vector3(fArray[0], fArray[1], fArray[2]));
                this.sunflow.parameter("turbidity", 6.0f);
                this.sunflow.parameter("samples", this.useAmbientOcclusion ? 0 : 12);
                this.sunSkyLightName = UUID.randomUUID().toString();
                this.sunflow.light(this.sunSkyLightName, "sunsky");
            }
            SunSkyLight sunSkyLight = new SunSkyLight();
            parameterList = new ParameterList();
            parameterList.addVectors("up", ParameterList.InterpolationType.NONE, new float[]{0.0f, 1.0f, 0.0f});
            parameterList.addVectors("east", ParameterList.InterpolationType.NONE, new float[]{(float)Math.sin(this.compass.getNorthDirection()), 0.0f, (float)Math.cos(this.compass.getNorthDirection())});
            parameterList.addVectors("sundir", ParameterList.InterpolationType.NONE, new float[]{fArray[0], fArray[1], fArray[2]});
            sunSkyLight.update(parameterList, this.sunflow);
            object = sunSkyLight.getSunColor().getRGB();
            int n = this.useAmbientOcclusion ? 40 : 10;
            this.sunflow.parameter("radiance", null, new float[]{(float)((this.homeLightColor >> 16) * n) * (float)Math.sqrt((double)object[0]), (float)((this.homeLightColor >> 8 & 0xFF) * n) * (float)Math.sqrt((double)object[1]), (float)((this.homeLightColor & 0xFF) * n) * (float)Math.sqrt((double)object[2])});
            this.sunflow.parameter("center", new Point3(1000000.0f * fArray[0], 1000000.0f * fArray[1], 1000000.0f * fArray[2]));
            this.sunflow.parameter("radius", 10000.0f);
            this.sunflow.parameter("samples", 4);
            this.sunLightName = UUID.randomUUID().toString();
            this.sunflow.light(this.sunLightName, "sphere");
            if (this.useAmbientOcclusion) {
                this.sunflow.parameter("gi.engine", "ambocc");
                this.sunflow.parameter("gi.ambocc.bright", null, new float[]{1.0f, 1.0f, 1.0f});
                this.sunflow.parameter("gi.ambocc.dark", null, new float[]{(float)((object[1] + object[2]) / 200.0f), (float)((object[0] + object[2]) / 200.0f), (float)((object[0] + object[1]) / 200.0f)});
                this.sunflow.parameter("gi.ambocc.samples", 1);
                this.sunflow.options("::options");
            }
        }
        switch (camera.getLens()) {
            case SPHERICAL: {
                this.sunflow.camera("camera", "spherical");
                break;
            }
            case FISHEYE: {
                this.sunflow.camera("camera", "fisheye");
                break;
            }
            case NORMAL: {
                this.sunflow.parameter("focus.distance", 250.0f);
                this.sunflow.parameter("lens.radius", 1.0f);
                this.sunflow.camera("camera", "thinlens");
                break;
            }
            default: {
                this.sunflow.camera("camera", "pinhole");
            }
        }
        parameterList = new Point3(camera.getX(), camera.getZ(), camera.getY());
        float f = camera.getYaw();
        float f2 = camera.getLens() == Camera.Lens.SPHERICAL ? 0.0f : camera.getPitch();
        double d = Math.cos(f2);
        if (Math.abs(d) > 1.0E-6) {
            Point3 point3 = new Point3(camera.getX() - (float)(Math.sin(f) * d), camera.getZ() - (float)Math.sin(f2), camera.getY() + (float)(Math.cos(f) * d));
            Vector3 vector3 = new Vector3(0.0f, 1.0f, 0.0f);
            object = Matrix4.lookAt((Point3)parameterList, (Point3)point3, (Vector3)vector3);
        } else {
            object = new Matrix4((float)(-Math.cos(f)), (float)(-Math.sin(f)), 0.0f, camera.getX(), 0.0f, 0.0f, 1.0f, camera.getZ(), (float)(-Math.sin(f)), (float)Math.cos(f), 0.0f, camera.getY());
        }
        this.sunflow.parameter("transform", object);
        this.sunflow.parameter("fov", (float)Math.toDegrees(camera.getFieldOfView()));
        this.sunflow.parameter("aspect", (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight());
        this.sunflow.camera("camera", null);
        this.sunflow.parameter("resolutionX", bufferedImage.getWidth());
        this.sunflow.parameter("resolutionY", bufferedImage.getHeight());
        if (this.quality == Quality.HIGH) {
            this.sunflow.parameter("filter", "blackman-harris");
            this.sunflow.parameter("aa.min", 1);
            this.sunflow.parameter("aa.max", 2);
        } else {
            this.sunflow.parameter("filter", "box");
            this.sunflow.parameter("aa.min", 0);
            this.sunflow.parameter("aa.max", 0);
        }
        this.sunflow.parameter("sampler", "bucket");
        this.sunflow.parameter("camera", "camera");
        this.sunflow.options("::options");
        this.sunflow.render("::options", (Display)new BufferedImageDisplay(bufferedImage, imageObserver));
    }

    public void stop() {
        if (this.renderingThread != null) {
            if (!this.renderingThread.isInterrupted()) {
                this.renderingThread.interrupt();
            }
            this.renderingThread = null;
        }
    }

    private List<HomeLight> getLights(List<HomePieceOfFurniture> list) {
        ArrayList<HomeLight> arrayList = new ArrayList<HomeLight>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeLight) {
                arrayList.add((HomeLight)homePieceOfFurniture);
                continue;
            }
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            arrayList.addAll(this.getLights(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
        }
        return arrayList;
    }

    private float[] getSunDirection(Compass compass, long l) {
        float f = compass.getSunElevation(l);
        float f2 = compass.getSunAzimuth(l);
        f2 = (float)((double)f2 + ((double)compass.getNorthDirection() - 1.5707963267948966));
        return new float[]{(float)(Math.cos(f2) * Math.cos(f)), (float)Math.sin(f), (float)(Math.sin(f2) * Math.cos(f))};
    }

    private void exportNode(Node node, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.exportNode(node, bl, bl2, bl3, new Transform3D());
    }

    private void exportNode(Node node, boolean bl, boolean bl2, boolean bl3, Transform3D transform3D) throws IOException {
        block8: {
            TransparencyAttributes transparencyAttributes;
            block9: {
                block7: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block7;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.exportNode((Node)enumeration.nextElement(), bl, bl2, bl3, transform3D);
                    }
                    break block8;
                }
                if (!(node instanceof Link)) break block9;
                this.exportNode((Node)((Link)node).getSharedGroup(), bl, bl2, bl3, transform3D);
                break block8;
            }
            if (!(node instanceof Shape3D)) break block8;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes2 = transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            if (!(renderingAttributes != null && !renderingAttributes.getVisible() || transparencyAttributes != null && transparencyAttributes.getTransparency() == 1.0f)) {
                int n;
                String string = (String)shape3D.getUserData();
                String string2 = UUID.randomUUID().toString();
                String string3 = null;
                TexCoordGeneration texCoordGeneration = null;
                if (appearance != null) {
                    texCoordGeneration = appearance.getTexCoordGeneration();
                    string3 = "shader" + string2;
                    n = string != null && string.startsWith("sweethome3d_window_mirror") ? 1 : 0;
                    this.exportAppearance(appearance, string3, n != 0, bl, bl2, bl3);
                }
                int n2 = shape3D.numGeometries();
                for (n = 0; n < n2; ++n) {
                    String string4 = "object" + string2 + "-" + n;
                    String[] stringArray = this.exportNodeGeometry(shape3D.getGeometry(n), transform3D, texCoordGeneration, string4);
                    if (stringArray == null) continue;
                    for (String string5 : stringArray) {
                        if (string3 != null) {
                            this.sunflow.parameter("shaders", new String[]{string3});
                        }
                        this.sunflow.instance(string5 + ".instance", string5);
                    }
                }
            }
        }
    }

    private String[] exportNodeGeometry(Geometry geometry, Transform3D transform3D, TexCoordGeneration texCoordGeneration, String string) {
        if (geometry instanceof GeometryArray) {
            IndexedTriangleStripArray indexedTriangleStripArray;
            GeometryArray geometryArray = (GeometryArray)geometry;
            int[] nArray = null;
            int[] nArray2 = null;
            if (geometryArray instanceof IndexedGeometryArray) {
                if (geometryArray instanceof IndexedLineArray) {
                    nArray = new int[((IndexedGeometryArray)geometryArray).getIndexCount()];
                } else if (geometryArray instanceof IndexedTriangleArray) {
                    nArray = new int[((IndexedGeometryArray)geometryArray).getIndexCount()];
                } else if (geometryArray instanceof IndexedQuadArray) {
                    nArray = new int[((IndexedQuadArray)geometryArray).getIndexCount() * 3 / 2];
                } else if (geometryArray instanceof IndexedGeometryStripArray) {
                    indexedTriangleStripArray = (IndexedTriangleStripArray)geometryArray;
                    nArray2 = new int[indexedTriangleStripArray.getNumStrips()];
                    indexedTriangleStripArray.getStripIndexCounts(nArray2);
                    nArray = geometryArray instanceof IndexedLineStripArray ? new int[this.getLineCount(nArray2) * 2] : new int[this.getTriangleCount(nArray2) * 3];
                }
            } else if (geometryArray instanceof LineArray) {
                nArray = new int[geometryArray.getVertexCount()];
            } else if (geometryArray instanceof TriangleArray) {
                nArray = new int[geometryArray.getVertexCount()];
            } else if (geometryArray instanceof QuadArray) {
                nArray = new int[((QuadArray)geometryArray).getVertexCount() * 3 / 2];
            } else if (geometryArray instanceof GeometryStripArray) {
                indexedTriangleStripArray = (GeometryStripArray)geometryArray;
                nArray2 = new int[indexedTriangleStripArray.getNumStrips()];
                indexedTriangleStripArray.getStripVertexCounts(nArray2);
                nArray = geometryArray instanceof LineStripArray ? new int[this.getLineCount(nArray2) * 2] : new int[this.getTriangleCount(nArray2) * 3];
            }
            if (nArray != null) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                boolean bl = geometryArray instanceof IndexedLineArray || geometryArray instanceof IndexedLineStripArray || geometryArray instanceof LineArray || geometryArray instanceof LineStripArray;
                float[] fArray = new float[geometryArray.getVertexCount() * 3];
                float[] fArray2 = !bl && (geometryArray.getVertexFormat() & 2) != 0 ? new float[geometryArray.getVertexCount() * 3] : null;
                HashSet<Triangle> hashSet = bl ? null : new HashSet<Triangle>(geometryArray.getVertexCount());
                boolean bl2 = false;
                Vector4f vector4f = null;
                Vector4f vector4f2 = null;
                if (!bl && texCoordGeneration != null) {
                    boolean bl3 = bl2 = texCoordGeneration.getGenMode() == 0 && texCoordGeneration.getEnable();
                    if (bl2) {
                        vector4f = new Vector4f();
                        vector4f2 = new Vector4f();
                        texCoordGeneration.getPlaneS(vector4f);
                        texCoordGeneration.getPlaneT(vector4f2);
                    }
                }
                Object object = bl2 || (geometryArray.getVertexFormat() & 0x20) != 0 ? new float[geometryArray.getVertexCount() * 2] : null;
                if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                    Point3f point3f;
                    if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                        float[] fArray3 = geometryArray.getInterleavedVertices();
                        n5 = fArray3.length / geometryArray.getVertexCount();
                        n4 = 0;
                        n3 = n5 - 3;
                        n2 = geometryArray.getVertexCount();
                        while (n4 < n2) {
                            point3f = new Point3f(fArray3[n3], fArray3[n3 + 1], fArray3[n3 + 2]);
                            this.exportVertex(transform3D, point3f, n4, fArray);
                            ++n4;
                            n3 += n5;
                        }
                        if (fArray2 != null) {
                            n4 = 0;
                            n3 = n5 - 6;
                            n2 = geometryArray.getVertexCount();
                            while (n4 < n2) {
                                point3f = new Vector3f(fArray3[n3], fArray3[n3 + 1], fArray3[n3 + 2]);
                                this.exportNormal(transform3D, (Vector3f)point3f, n4, fArray2);
                                ++n4;
                                n3 += n5;
                            }
                        }
                        if (texCoordGeneration != null) {
                            if (bl2) {
                                n4 = 0;
                                n3 = n5 - 3;
                                n2 = geometryArray.getVertexCount();
                                while (n4 < n2) {
                                    point3f = this.generateTextureCoordinates(fArray3[n3], fArray3[n3 + 1], fArray3[n3 + 2], vector4f, vector4f2);
                                    this.exportTextureCoordinates((TexCoord2f)point3f, n4, (float[])object);
                                    ++n4;
                                    n3 += n5;
                                }
                            }
                        } else if (object != null) {
                            n4 = 0;
                            n3 = 0;
                            n2 = geometryArray.getVertexCount();
                            while (n4 < n2) {
                                point3f = new TexCoord2f(fArray3[n3], fArray3[n3 + 1]);
                                this.exportTextureCoordinates((TexCoord2f)point3f, n4, (float[])object);
                                ++n4;
                                n3 += n5;
                            }
                        }
                    } else {
                        float[] fArray4 = geometryArray.getCoordRefFloat();
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = geometryArray.getVertexCount();
                        while (n6 < n8) {
                            Point3f point3f2 = new Point3f(fArray4[n7], fArray4[n7 + 1], fArray4[n7 + 2]);
                            this.exportVertex(transform3D, point3f2, n6, fArray);
                            ++n6;
                            n7 += 3;
                        }
                        if (fArray2 != null) {
                            float[] fArray5 = geometryArray.getNormalRefFloat();
                            n7 = 0;
                            n8 = 0;
                            int n9 = geometryArray.getVertexCount();
                            while (n7 < n9) {
                                point3f = new Vector3f(fArray5[n8], fArray5[n8 + 1], fArray5[n8 + 2]);
                                this.exportNormal(transform3D, (Vector3f)point3f, n7, fArray2);
                                ++n7;
                                n8 += 3;
                            }
                        }
                        if (texCoordGeneration != null) {
                            if (bl2) {
                                int n10 = 0;
                                n7 = 0;
                                n8 = geometryArray.getVertexCount();
                                while (n10 < n8) {
                                    TexCoord2f texCoord2f = this.generateTextureCoordinates(fArray4[n7], fArray4[n7 + 1], fArray4[n7 + 2], vector4f, vector4f2);
                                    this.exportTextureCoordinates(texCoord2f, n10, (float[])object);
                                    ++n10;
                                    n7 += 3;
                                }
                            }
                        } else if (object != null) {
                            float[] fArray6 = geometryArray.getTexCoordRefFloat(0);
                            n7 = 0;
                            n8 = 0;
                            int n11 = geometryArray.getVertexCount();
                            while (n7 < n11) {
                                point3f = new TexCoord2f(fArray6[n8], fArray6[n8 + 1]);
                                this.exportTextureCoordinates((TexCoord2f)point3f, n7, (float[])object);
                                ++n7;
                                n8 += 2;
                            }
                        }
                    }
                } else {
                    Point3f point3f;
                    int n12;
                    int n13 = geometryArray.getVertexCount();
                    for (n12 = 0; n12 < n13; ++n12) {
                        point3f = new Point3f();
                        geometryArray.getCoordinate(n12, point3f);
                        this.exportVertex(transform3D, point3f, n12, fArray);
                    }
                    if (fArray2 != null) {
                        n13 = geometryArray.getVertexCount();
                        for (n12 = 0; n12 < n13; ++n12) {
                            point3f = new Vector3f();
                            geometryArray.getNormal(n12, (Vector3f)point3f);
                            this.exportNormal(transform3D, (Vector3f)point3f, n12, fArray2);
                        }
                    }
                    if (texCoordGeneration != null) {
                        if (bl2) {
                            n13 = geometryArray.getVertexCount();
                            for (n12 = 0; n12 < n13; ++n12) {
                                point3f = new Point3f();
                                geometryArray.getCoordinate(n12, point3f);
                                TexCoord2f texCoord2f = this.generateTextureCoordinates(point3f.x, point3f.y, point3f.z, vector4f, vector4f2);
                                this.exportTextureCoordinates(texCoord2f, n12, (float[])object);
                            }
                        }
                    } else if (object != null) {
                        n13 = geometryArray.getVertexCount();
                        for (n12 = 0; n12 < n13; ++n12) {
                            point3f = new TexCoord2f();
                            geometryArray.getTextureCoordinate(0, n12, (TexCoord2f)point3f);
                            this.exportTextureCoordinates((TexCoord2f)point3f, n12, (float[])object);
                        }
                    }
                }
                if (geometryArray instanceof IndexedGeometryArray) {
                    int n14;
                    int n15;
                    int[] nArray3;
                    int[] nArray4 = fArray2 != null ? new int[nArray.length] : null;
                    int[] nArray5 = nArray3 = object != null ? new int[nArray.length] : null;
                    if (geometryArray instanceof IndexedLineArray) {
                        IndexedLineArray indexedLineArray = (IndexedLineArray)geometryArray;
                        n2 = indexedLineArray.getIndexCount();
                        for (n3 = 0; n3 < n2; n3 += 2) {
                            this.exportIndexedLine((IndexedGeometryArray)indexedLineArray, n3, n3 + 1, nArray, n3);
                        }
                    } else if (geometryArray instanceof IndexedTriangleArray) {
                        IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)geometryArray;
                        n2 = indexedTriangleArray.getIndexCount();
                        int n16 = 0;
                        for (n3 = 0; n3 < n2; n3 += 3) {
                            n16 = this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleArray, n3, n3 + 1, n3 + 2, nArray, nArray4, nArray3, n16, fArray, hashSet);
                        }
                    } else if (geometryArray instanceof IndexedQuadArray) {
                        IndexedQuadArray indexedQuadArray = (IndexedQuadArray)geometryArray;
                        n2 = indexedQuadArray.getIndexCount();
                        int n17 = 0;
                        for (n3 = 0; n3 < n2; n3 += 4) {
                            n17 = this.exportIndexedTriangle((IndexedGeometryArray)indexedQuadArray, n3, n3 + 1, n3 + 2, nArray, nArray4, nArray3, n17, fArray, hashSet);
                            n17 = this.exportIndexedTriangle((IndexedGeometryArray)indexedQuadArray, n3, n3 + 2, n3 + 3, nArray, nArray4, nArray3, n17, fArray, hashSet);
                        }
                    } else if (geometryArray instanceof IndexedLineStripArray) {
                        IndexedLineStripArray indexedLineStripArray = (IndexedLineStripArray)geometryArray;
                        n3 = 0;
                        n2 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n = n3;
                            n15 = n3 + nArray2[i] - 1;
                            while (n < n15) {
                                this.exportIndexedLine((IndexedGeometryArray)indexedLineStripArray, n, n + 1, nArray, n2);
                                ++n;
                                n2 += 2;
                            }
                            n3 += nArray2[i];
                        }
                    } else if (geometryArray instanceof IndexedTriangleStripArray) {
                        IndexedTriangleStripArray indexedTriangleStripArray2 = (IndexedTriangleStripArray)geometryArray;
                        n3 = 0;
                        n2 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n = n3;
                            n15 = n3 + nArray2[i] - 2;
                            n14 = 0;
                            while (n < n15) {
                                n2 = n14 % 2 == 0 ? this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleStripArray2, n, n + 1, n + 2, nArray, nArray4, nArray3, n2, fArray, hashSet) : this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleStripArray2, n, n + 2, n + 1, nArray, nArray4, nArray3, n2, fArray, hashSet);
                                ++n;
                                ++n14;
                            }
                            n3 += nArray2[i];
                        }
                    } else if (geometryArray instanceof IndexedTriangleFanArray) {
                        IndexedTriangleFanArray indexedTriangleFanArray = (IndexedTriangleFanArray)geometryArray;
                        n3 = 0;
                        n2 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n15 = n3 + nArray2[i] - 2;
                            for (n = n3; n < n15; ++n) {
                                n2 = this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleFanArray, n3, n + 1, n + 2, nArray, nArray4, nArray3, n2, fArray, hashSet);
                            }
                            n3 += nArray2[i];
                        }
                    }
                    if (nArray4 != null && !Arrays.equals(nArray, nArray4) || nArray3 != null && !Arrays.equals(nArray, nArray3)) {
                        float[] fArray7 = new float[nArray.length * 3];
                        float[] fArray8 = nArray4 != null ? new float[nArray.length * 3] : null;
                        float[] fArray9 = nArray3 != null ? new float[nArray.length * 2] : null;
                        int n18 = 0;
                        n = 0;
                        n15 = 0;
                        for (n14 = 0; n14 < nArray.length; ++n14) {
                            int n19 = nArray[n14] * 3;
                            fArray7[n18++] = fArray[n19++];
                            fArray7[n18++] = fArray[n19++];
                            fArray7[n18++] = fArray[n19++];
                            if (nArray4 != null) {
                                n19 = nArray4[n14] * 3;
                                fArray8[n++] = fArray2[n19++];
                                fArray8[n++] = fArray2[n19++];
                                fArray8[n++] = fArray2[n19++];
                            }
                            if (nArray3 != null) {
                                n19 = nArray3[n14] * 2;
                                fArray9[n15++] = object[n19++];
                                fArray9[n15++] = object[n19++];
                            }
                            nArray[n14] = n14;
                        }
                        fArray = fArray7;
                        fArray2 = fArray8;
                        object = fArray9;
                    }
                } else if (geometryArray instanceof LineArray) {
                    LineArray lineArray = (LineArray)geometryArray;
                    n4 = lineArray.getVertexCount();
                    for (n5 = 0; n5 < n4; n5 += 2) {
                        this.exportLine((GeometryArray)lineArray, n5, n5 + 1, nArray, n5);
                    }
                } else if (geometryArray instanceof TriangleArray) {
                    TriangleArray triangleArray = (TriangleArray)geometryArray;
                    n4 = triangleArray.getVertexCount();
                    n3 = 0;
                    for (n5 = 0; n5 < n4; n5 += 3) {
                        n3 = this.exportTriangle((GeometryArray)triangleArray, n5, n5 + 1, n5 + 2, nArray, n3, fArray, hashSet);
                    }
                } else if (geometryArray instanceof QuadArray) {
                    QuadArray quadArray = (QuadArray)geometryArray;
                    n4 = quadArray.getVertexCount();
                    n3 = 0;
                    for (n5 = 0; n5 < n4; n5 += 4) {
                        n3 = this.exportTriangle((GeometryArray)quadArray, n5, n5 + 1, n5 + 2, nArray, n3, fArray, hashSet);
                        n3 = this.exportTriangle((GeometryArray)quadArray, n5 + 2, n5 + 3, n5, nArray, n3, fArray, hashSet);
                    }
                } else if (geometryArray instanceof LineStripArray) {
                    LineStripArray lineStripArray = (LineStripArray)geometryArray;
                    n5 = 0;
                    n4 = 0;
                    for (n3 = 0; n3 < nArray2.length; ++n3) {
                        n2 = n5;
                        int n20 = n5 + nArray2[n3] - 1;
                        while (n2 < n20) {
                            this.exportLine((GeometryArray)lineStripArray, n2, n2 + 1, nArray, n4);
                            ++n2;
                            n4 += 2;
                        }
                        n5 += nArray2[n3];
                    }
                } else if (geometryArray instanceof TriangleStripArray) {
                    TriangleStripArray triangleStripArray = (TriangleStripArray)geometryArray;
                    n5 = 0;
                    n4 = 0;
                    for (n3 = 0; n3 < nArray2.length; ++n3) {
                        n2 = n5;
                        int n21 = n5 + nArray2[n3] - 2;
                        n = 0;
                        while (n2 < n21) {
                            n4 = n % 2 == 0 ? this.exportTriangle((GeometryArray)triangleStripArray, n2, n2 + 1, n2 + 2, nArray, n4, fArray, hashSet) : this.exportTriangle((GeometryArray)triangleStripArray, n2, n2 + 2, n2 + 1, nArray, n4, fArray, hashSet);
                            ++n2;
                            ++n;
                        }
                        n5 += nArray2[n3];
                    }
                } else if (geometryArray instanceof TriangleFanArray) {
                    TriangleFanArray triangleFanArray = (TriangleFanArray)geometryArray;
                    n5 = 0;
                    n4 = 0;
                    for (n3 = 0; n3 < nArray2.length; ++n3) {
                        int n22 = n5 + nArray2[n3] - 2;
                        for (n2 = n5; n2 < n22; ++n2) {
                            n4 = this.exportTriangle((GeometryArray)triangleFanArray, n5, n2 + 1, n2 + 2, nArray, n4, fArray, hashSet);
                        }
                        n5 += nArray2[n3];
                    }
                }
                if (bl) {
                    String[] stringArray = new String[nArray.length / 2];
                    for (int i = 0; i < nArray.length; i += 2) {
                        String string2;
                        stringArray[i / 2] = string2 = string + "-" + i;
                        float[] fArray10 = new float[6];
                        int n23 = 0;
                        for (int j = i; j <= i + 1; ++j) {
                            n = nArray[j] * 3;
                            fArray10[n23++] = fArray[n++];
                            fArray10[n23++] = fArray[n++];
                            fArray10[n23++] = fArray[n];
                        }
                        this.sunflow.parameter("segments", 1);
                        this.sunflow.parameter("widths", 0.15f);
                        this.sunflow.parameter("points", "point", "vertex", fArray10);
                        this.sunflow.geometry(string2, "hair");
                    }
                    return stringArray;
                }
                int n24 = hashSet.size() * 3;
                if (n24 < nArray.length) {
                    int[] nArray6 = new int[n24];
                    System.arraycopy(nArray, 0, nArray6, 0, nArray6.length);
                    nArray = nArray6;
                }
                this.sunflow.parameter("triangles", nArray);
                this.sunflow.parameter("points", "point", "vertex", fArray);
                if (fArray2 != null) {
                    boolean bl4 = true;
                    for (float f : fArray2) {
                        if (!Float.isNaN(f)) continue;
                        bl4 = false;
                        break;
                    }
                    if (bl4) {
                        this.sunflow.parameter("normals", "vector", "vertex", fArray2);
                    }
                }
                if (object != null) {
                    boolean bl5 = true;
                    for (float f : object) {
                        if (!((double)Math.abs(f) > 1.0E9)) continue;
                        bl5 = false;
                        break;
                    }
                    if (bl5) {
                        this.sunflow.parameter("uvs", "texcoord", "vertex", object);
                    }
                }
                this.sunflow.geometry(string, "triangle_mesh");
                return new String[]{string};
            }
        }
        return null;
    }

    private TexCoord2f generateTextureCoordinates(float f, float f2, float f3, Vector4f vector4f, Vector4f vector4f2) {
        return new TexCoord2f(f * vector4f.x + f2 * vector4f.y + f3 * vector4f.z, f * vector4f2.x + f2 * vector4f2.y + f3 * vector4f2.z);
    }

    private int getLineCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - 1;
        }
        return n;
    }

    private int getTriangleCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - 2;
        }
        return n;
    }

    private void exportVertex(Transform3D transform3D, Point3f point3f, int n, float[] fArray) {
        transform3D.transform(point3f);
        n *= 3;
        fArray[n++] = point3f.x;
        fArray[n++] = point3f.y;
        fArray[n] = point3f.z;
    }

    private void exportNormal(Transform3D transform3D, Vector3f vector3f, int n, float[] fArray) {
        transform3D.transform(vector3f);
        int n2 = n * 3;
        fArray[n2++] = vector3f.x;
        fArray[n2++] = vector3f.y;
        fArray[n2] = vector3f.z;
    }

    private void exportTextureCoordinates(TexCoord2f texCoord2f, int n, float[] fArray) {
        n *= 2;
        fArray[n++] = texCoord2f.x;
        fArray[n] = texCoord2f.y;
    }

    private void exportIndexedLine(IndexedGeometryArray indexedGeometryArray, int n, int n2, int[] nArray, int n3) {
        nArray[n3++] = indexedGeometryArray.getCoordinateIndex(n);
        nArray[n3] = indexedGeometryArray.getCoordinateIndex(n2);
    }

    private int exportIndexedTriangle(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int n4, float[] fArray, Set<Triangle> set) {
        int n5;
        int n6;
        int n7 = indexedGeometryArray.getCoordinateIndex(n);
        Triangle triangle = new Triangle(fArray, n7, n6 = indexedGeometryArray.getCoordinateIndex(n2), n5 = indexedGeometryArray.getCoordinateIndex(n3));
        if (!set.contains(triangle)) {
            set.add(triangle);
            nArray[n4] = n7;
            nArray[n4 + 1] = n6;
            nArray[n4 + 2] = n5;
            if (nArray2 != null) {
                nArray2[n4] = indexedGeometryArray.getNormalIndex(n);
                nArray2[n4 + 1] = indexedGeometryArray.getNormalIndex(n2);
                nArray2[n4 + 2] = indexedGeometryArray.getNormalIndex(n3);
            }
            if (nArray3 != null) {
                nArray3[n4] = indexedGeometryArray.getTextureCoordinateIndex(0, n);
                nArray3[n4 + 1] = indexedGeometryArray.getTextureCoordinateIndex(0, n2);
                nArray3[n4 + 2] = indexedGeometryArray.getTextureCoordinateIndex(0, n3);
            }
            return n4 + 3;
        }
        return n4;
    }

    private void exportLine(GeometryArray geometryArray, int n, int n2, int[] nArray, int n3) {
        nArray[n3++] = n;
        nArray[n3] = n2;
    }

    private int exportTriangle(GeometryArray geometryArray, int n, int n2, int n3, int[] nArray, int n4, float[] fArray, Set<Triangle> set) {
        Triangle triangle = new Triangle(fArray, n, n2, n3);
        if (!set.contains(triangle)) {
            set.add(triangle);
            nArray[n4++] = n;
            nArray[n4++] = n2;
            nArray[n4++] = n3;
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void exportAppearance(Appearance appearance, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        Texture texture = appearance.getTexture();
        if (bl) {
            Material material = appearance.getMaterial();
            if (material != null) {
                Color3f color3f = new Color3f();
                material.getDiffuseColor(color3f);
                this.sunflow.parameter("color", null, new float[]{color3f.x, color3f.y, color3f.z});
            }
            this.sunflow.shader(string, "mirror");
            return;
        }
        if (texture != null) {
            Object object;
            Object object2;
            Material material;
            TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
            float f = transparencyAttributes != null && transparencyAttributes.getTransparency() > 0.0f && !bl2 ? 1.0f - transparencyAttributes.getTransparency() : 1.0f;
            TransparentTextureKey transparentTextureKey = new TransparentTextureKey(texture, f);
            String string2 = this.textureImagesCache.get(transparentTextureKey);
            if (string2 == null) {
                if (texture.getUserData() instanceof URL && f == 1.0f) {
                    string2 = texture.getUserData().toString();
                } else {
                    material = (ImageComponent2D)texture.getImage(0);
                    Object object3 = material.getRenderedImage();
                    if (f < 1.0f) {
                        object2 = new BufferedImage(object3.getWidth(), object3.getHeight(), 2);
                        object = (Graphics2D)((BufferedImage)object2).getGraphics();
                        ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, f));
                        ((Graphics2D)object).drawRenderedImage((RenderedImage)object3, null);
                        ((Graphics)object).dispose();
                        object3 = object2;
                    }
                    object2 = OperatingSystem.createTemporaryFile("texture", ".png");
                    ImageIO.write((RenderedImage)object3, "png", (File)object2);
                    string2 = ((File)object2).getAbsolutePath();
                }
                this.textureImagesCache.put(transparentTextureKey, string2);
            }
            if ((material = appearance.getMaterial()) != null) {
                float f2;
                float f3 = material.getShininess();
                if (f2 > 1.0f) {
                    if (bl4) {
                        this.sunflow.parameter("diffuse.texture", string2);
                        object2 = new Color3f();
                        material.getSpecularColor((Color3f)object2);
                        object = new float[]{(float)Math.sqrt(((Color3f)object2).x) / 2.0f, (float)Math.sqrt(((Color3f)object2).y) / 2.0f, (float)Math.sqrt(((Color3f)object2).z) / 2.0f};
                        this.sunflow.parameter("specular", null, (float[])object);
                        this.sunflow.parameter("glossyness", (float)Math.pow(10.0, -Math.log(f3) / Math.log(5.0)));
                        this.sunflow.parameter("samples", 1);
                        this.sunflow.shader(string, "uber");
                        return;
                    }
                    this.sunflow.parameter("texture", string2);
                    this.sunflow.parameter("shiny", f3 / 512.0f);
                    this.sunflow.shader(string, "textured_shiny_diffuse");
                    return;
                }
            }
            this.sunflow.parameter("texture", string2);
            this.sunflow.shader(string, "textured_diffuse");
            return;
        }
        Material material = appearance.getMaterial();
        if (material != null) {
            Color3f color3f = new Color3f();
            material.getDiffuseColor(color3f);
            float[] fArray = new float[]{color3f.x, color3f.y, color3f.z};
            TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
            if (transparencyAttributes != null && transparencyAttributes.getTransparency() > 0.0f && !bl2) {
                if (material instanceof OBJMaterial && ((OBJMaterial)material).isOpticalDensitySet()) {
                    this.sunflow.parameter("eta", ((OBJMaterial)material).getOpticalDensity());
                } else {
                    this.sunflow.parameter("eta", 1.55f);
                }
                float f = 1.0f - transparencyAttributes.getTransparency();
                this.sunflow.parameter("color", null, new float[]{1.0f - f + f * fArray[0], 1.0f - f + f * fArray[1], 1.0f - f + f * fArray[2]});
                this.sunflow.parameter("absorption.color", null, new float[]{f * (1.0f - fArray[0]), f * (1.0f - fArray[1]), f * (1.0f - fArray[2])});
                this.sunflow.shader(string, "glass");
                return;
            }
            if (!material.getLightingEnable() && !bl3) {
                this.sunflow.parameter("color", null, fArray);
                this.sunflow.shader(string, "constant");
                return;
            }
            this.sunflow.parameter("diffuse", null, fArray);
            float f = material.getShininess();
            if (!(f > 1.0f)) {
                this.sunflow.shader(string, "diffuse");
                return;
            }
            if (bl4) {
                material.getSpecularColor(color3f);
                float[] fArray2 = new float[]{(float)Math.sqrt(color3f.x) / 2.0f, (float)Math.sqrt(color3f.y) / 2.0f, (float)Math.sqrt(color3f.z) / 2.0f};
                this.sunflow.parameter("specular", null, fArray2);
                this.sunflow.parameter("glossyness", (float)Math.pow(10.0, -Math.log(f) / Math.log(5.0)));
                this.sunflow.parameter("samples", 1);
                this.sunflow.shader(string, "uber");
                return;
            }
            this.sunflow.parameter("shiny", f / 512.0f);
            this.sunflow.shader(string, "shiny_diffuse");
            return;
        }
        ColoringAttributes coloringAttributes = appearance.getColoringAttributes();
        if (coloringAttributes == null) return;
        Color3f color3f = new Color3f();
        coloringAttributes.getColor(color3f);
        if (bl3) {
            this.sunflow.parameter("diffuse", null, new float[]{color3f.x, color3f.y, color3f.z});
            this.sunflow.shader(string, "diffuse");
            return;
        }
        this.sunflow.parameter("color", null, new float[]{color3f.x, color3f.y, color3f.z});
        this.sunflow.shader(string, "constant");
    }

    static {
        UI.set((UserInterface)new SilentInterface());
        TriangleMesh.setSmallTriangles((boolean)true);
        PluginRegistry.lightSourcePlugins.registerPlugin("sphere", SphereLightWithNoRepresentation.class);
    }

    private static class TransparentTextureKey {
        private Texture texture;
        private float transparency;

        public TransparentTextureKey(Texture texture, float f) {
            this.texture = texture;
            this.transparency = f;
        }

        public boolean equals(Object object) {
            return ((TransparentTextureKey)object).texture.equals(this.texture) && ((TransparentTextureKey)object).transparency == this.transparency;
        }

        public int hashCode() {
            return this.texture.hashCode() + Float.floatToIntBits(this.transparency);
        }
    }

    private static class Triangle {
        private float[] point1;
        private float[] point2;
        private float[] point3;
        private int hashCode;
        private boolean hashCodeSet;

        public Triangle(float[] fArray, int n, int n2, int n3) {
            this.point1 = new float[]{fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]};
            this.point2 = new float[]{fArray[n2 * 3], fArray[n2 * 3 + 1], fArray[n2 * 3 + 2]};
            this.point3 = new float[]{fArray[n3 * 3], fArray[n3 * 3 + 1], fArray[n3 * 3 + 2]};
        }

        public int hashCode() {
            if (!this.hashCodeSet) {
                this.hashCode = 31 * Arrays.hashCode(this.point1) + 31 * Arrays.hashCode(this.point2) + 31 * Arrays.hashCode(this.point3);
                this.hashCodeSet = true;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Triangle) {
                Triangle triangle = (Triangle)object;
                return Arrays.equals(this.point1, triangle.point3) && Arrays.equals(this.point2, triangle.point2) && Arrays.equals(this.point3, triangle.point1) || Arrays.equals(this.point1, triangle.point2) && Arrays.equals(this.point2, triangle.point1) && Arrays.equals(this.point3, triangle.point3) || Arrays.equals(this.point1, triangle.point1) && Arrays.equals(this.point2, triangle.point3) && Arrays.equals(this.point3, triangle.point2) || Arrays.equals(this.point1, triangle.point1) && Arrays.equals(this.point2, triangle.point2) && Arrays.equals(this.point3, triangle.point3);
            }
            return false;
        }
    }

    public static class SphereLightWithNoRepresentation
    extends SphereLight {
        public Instance createInstance() {
            return null;
        }
    }

    private static final class BufferedImageDisplay
    implements Display {
        private static final int BASE_INFO_FLAGS = 7;
        private static final int[] BORDERS = new int[]{Color.RED.toRGB(), Color.GREEN.toRGB(), Color.BLUE.toRGB(), Color.YELLOW.toRGB(), Color.CYAN.toRGB(), Color.MAGENTA.toRGB(), new Color(1.0f, 0.5f, 0.0f).toRGB(), new Color(0.5f, 1.0f, 0.0f).toRGB()};
        private final ImageObserver observer;
        private final BufferedImage image;

        private BufferedImageDisplay(BufferedImage bufferedImage, ImageObserver imageObserver) {
            this.observer = imageObserver;
            this.image = bufferedImage;
        }

        public synchronized void imageBegin(int n, int n2, int n3) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n4 = this.image.getRGB(j, i);
                    this.image.setRGB(j, i, ((n4 & 0xFEFEFEFE) >>> 1) + ((n4 & 0xFCFCFCFC) >>> 2));
                }
            }
            this.notifyObserver(23, 0, 0, n, n2);
        }

        public synchronized void imagePrepare(int n, int n2, int n3, int n4, int n5) {
            int n6 = BORDERS[n5 % BORDERS.length] | 0xFF000000;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (j < 2 || j > n3 - 3) {
                        if (5 * i >= n4 && 5 * (n4 - i - 1) >= n4) continue;
                        this.image.setRGB(n + j, n2 + i, n6);
                        continue;
                    }
                    if (i >= 2 && i <= n4 - 3 || 5 * j >= n3 && 5 * (n3 - j - 1) >= n3) continue;
                    this.image.setRGB(n + j, n2 + i, n6);
                }
            }
            this.notifyObserver(15, n, n2, n3, n4);
        }

        public synchronized void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) {
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                int n6 = 0;
                while (n6 < n3) {
                    this.image.setRGB(n + n6, n2 + i, colorArray[n5].copy().mul(1.0f / fArray[n5]).toNonLinear().toRGBA(fArray[n5]));
                    ++n6;
                    ++n5;
                }
            }
            this.notifyObserver(15, n, n2, n3, n4);
        }

        public synchronized void imageFill(int n, int n2, int n3, int n4, Color color, float f) {
            int n5 = color.copy().mul(1.0f / f).toNonLinear().toRGBA(f);
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                int n7 = 0;
                while (n7 < n3) {
                    this.image.setRGB(n + n7, n2 + i, n5);
                    ++n7;
                    ++n6;
                }
            }
            this.notifyObserver(15, n, n2, n3, n4);
        }

        public void imageEnd() {
            this.notifyObserver(23, 0, 0, this.image.getWidth(), this.image.getHeight());
        }

        private void notifyObserver(final int n, final int n2, final int n3, final int n4, final int n5) {
            if (this.observer != null) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BufferedImageDisplay.this.observer.imageUpdate(BufferedImageDisplay.this.image, n, n2, n3, n4, n5);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quality {
        LOW,
        HIGH;

    }
}

