/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wall3D
extends Object3DBranch {
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private static final int LEFT_WALL_SIDE = 0;
    private static final int RIGHT_WALL_SIDE = 1;
    private final Home home;

    public Wall3D(Wall wall, Home home) {
        this(wall, home, false, false);
    }

    public Wall3D(Wall wall, Home home, boolean bl, boolean bl2) {
        this.setUserData(wall);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        this.addChild(this.createWallPartShape(false));
        this.addChild(this.createWallPartShape(false));
        if (!bl) {
            this.addChild(this.createWallPartShape(true));
            this.addChild(this.createWallPartShape(true));
        }
        this.updateWallGeometry();
        this.updateWallAppearance(bl2);
    }

    private Node createWallPartShape(boolean bl) {
        Shape3D shape3D = new Shape3D();
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        Appearance appearance = new Appearance();
        shape3D.setAppearance(appearance);
        appearance.setCapability(10);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setCapability(12);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        appearance.setRenderingAttributes(renderingAttributes);
        if (bl) {
            appearance.setColoringAttributes(Object3DBranch.OUTLINE_COLORING_ATTRIBUTES);
            appearance.setPolygonAttributes(Object3DBranch.OUTLINE_POLYGON_ATTRIBUTES);
            appearance.setLineAttributes(Object3DBranch.OUTLINE_LINE_ATTRIBUTES);
        } else {
            appearance.setCapability(1);
            appearance.setMaterial(DEFAULT_MATERIAL);
            appearance.setCapability(3);
            appearance.setCapability(2);
            appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
        }
        return shape3D;
    }

    @Override
    public void update() {
        this.updateWallGeometry();
        this.updateWallAppearance(false);
    }

    private void updateWallGeometry() {
        this.updateWallSideGeometry(0, ((Wall)this.getUserData()).getLeftSideTexture());
        this.updateWallSideGeometry(1, ((Wall)this.getUserData()).getRightSideTexture());
    }

    private void updateWallSideGeometry(int n, HomeTexture homeTexture) {
        Shape3D shape3D = (Shape3D)this.getChild(n);
        Shape3D shape3D2 = this.numChildren() > 2 ? (Shape3D)this.getChild(n + 2) : null;
        int n2 = shape3D.numGeometries();
        for (Geometry geometry : this.createWallGeometries(n, homeTexture)) {
            if (geometry == null) continue;
            shape3D.addGeometry(geometry);
            if (shape3D2 == null) continue;
            shape3D2.addGeometry(geometry);
        }
        for (int i = n2 - 1; i >= 0; --i) {
            shape3D.removeGeometry(i);
            if (shape3D2 == null) continue;
            shape3D2.removeGeometry(i);
        }
    }

    private Geometry[] createWallGeometries(int n, HomeTexture homeTexture) {
        Object object;
        Object object2;
        Object object3;
        double d;
        double d2;
        boolean bl;
        float[][] fArray = this.getWallSidePoints(n);
        float[] fArray2 = n == 0 ? fArray[0] : fArray[fArray.length - 1];
        Shape shape = this.getShape(fArray);
        Area area = new Area(shape);
        float f = this.getWallHeightAtStart();
        float f2 = this.getWallHeightAtEnd();
        float f3 = Math.max(f, f2);
        Wall wall = (Wall)this.getUserData();
        double d3 = Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = d4 * (double)wall.getXStart() + d5 * (double)wall.getYStart();
        double d7 = d4 * (double)wall.getXEnd() + d5 * (double)wall.getYEnd();
        boolean bl2 = bl = wall.getArcExtent() != null && wall.getArcExtent().floatValue() != 0.0f;
        if (f == f2) {
            d2 = 0.0;
            d = f;
        } else {
            d2 = (double)(f2 - f) / (d7 - d6);
            d = (double)f - d2 * d6;
        }
        ArrayList<DoorOrWindowArea> arrayList = new ArrayList<DoorOrWindowArea>();
        for (HomePieceOfFurniture object62 : this.getVisibleDoorsAndWindows(this.home.getFurniture())) {
            if (!(object62.getElevation() < f3)) continue;
            object3 = this.getShape(object62.getPoints());
            Area area2 = new Area((Shape)object3);
            Area area3 = new Area(shape);
            area3.intersect(area2);
            if (area3.isEmpty()) continue;
            arrayList.add(new DoorOrWindowArea(area3, Arrays.asList(object62)));
            area.subtract(area2);
        }
        if (arrayList.size() > 1) {
            for (int i = 0; i < arrayList.size(); ++i) {
                DoorOrWindowArea doorOrWindowArea = (DoorOrWindowArea)arrayList.get(i);
                object3 = new ArrayList();
                int n2 = 0;
                for (DoorOrWindowArea doorOrWindowArea2 : arrayList) {
                    if (doorOrWindowArea.getArea().isEmpty()) break;
                    if (n2 > i) {
                        object2 = new Area(doorOrWindowArea2.getArea());
                        ((Area)object2).intersect(doorOrWindowArea.getArea());
                        if (!((Area)object2).isEmpty()) {
                            doorOrWindowArea2.getArea().subtract((Area)object2);
                            doorOrWindowArea.getArea().subtract((Area)object2);
                            object = new ArrayList<HomePieceOfFurniture>(doorOrWindowArea.getDoorsOrWindows());
                            object.addAll(doorOrWindowArea2.getDoorsOrWindows());
                            object3.add(new DoorOrWindowArea((Area)object2, (List<HomePieceOfFurniture>)object));
                        }
                    }
                    ++n2;
                }
                arrayList.addAll((Collection<DoorOrWindowArea>)object3);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Object> arrayList3 = new ArrayList<Object>(4);
        object3 = null;
        PathIterator pathIterator = area.getPathIterator(null, 0.1f);
        while (!pathIterator.isDone()) {
            float[] fArray3 = new float[2];
            if (pathIterator.currentSegment(fArray3) == 4) {
                if (arrayList3.size() > 2) {
                    if (Arrays.equals((float[])arrayList3.get(0), (float[])arrayList3.get(arrayList3.size() - 1))) {
                        arrayList3.remove(arrayList3.size() - 1);
                    }
                    if (arrayList3.size() > 2) {
                        float[][] fArray4 = (float[][])arrayList3.toArray((T[])new float[arrayList3.size()][]);
                        arrayList2.add(this.createWallVerticalPartGeometry(wall, fArray4, 0.0f, d4, d5, d2, d, homeTexture, fArray2, n));
                        arrayList2.add(this.createWallHorizontalPartGeometry(fArray4, 0.0f, true, bl));
                        arrayList2.add(this.createWallTopPartGeometry(fArray4, d4, d5, d2, d, bl));
                    }
                }
                arrayList3.clear();
                object3 = null;
            } else if (object3 == null || !Arrays.equals(fArray3, (float[])object3)) {
                arrayList3.add(fArray3);
                object3 = fArray3;
            }
            pathIterator.next();
        }
        object3 = null;
        for (DoorOrWindowArea doorOrWindowArea : arrayList) {
            if (doorOrWindowArea.getArea().isEmpty()) continue;
            PathIterator pathIterator2 = doorOrWindowArea.getArea().getPathIterator(null, 0.1f);
            while (!pathIterator2.isDone()) {
                object2 = new float[2];
                if (pathIterator2.currentSegment((float[])object2) == 4) {
                    if (Arrays.equals((float[])arrayList3.get(0), (float[])arrayList3.get(arrayList3.size() - 1))) {
                        arrayList3.remove(arrayList3.size() - 1);
                    }
                    if (arrayList3.size() > 2) {
                        HomePieceOfFurniture homePieceOfFurniture;
                        HomePieceOfFurniture homePieceOfFurniture2;
                        object = (float[][])arrayList3.toArray((T[])new float[arrayList3.size()][]);
                        List<HomePieceOfFurniture> list = doorOrWindowArea.getDoorsOrWindows();
                        if (list.size() > 1) {
                            Collections.sort(list, new Comparator<HomePieceOfFurniture>(){

                                @Override
                                public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                                    if (homePieceOfFurniture.getElevation() < homePieceOfFurniture2.getElevation()) {
                                        return -1;
                                    }
                                    if (homePieceOfFurniture.getElevation() > homePieceOfFurniture2.getElevation()) {
                                        return 1;
                                    }
                                    return 0;
                                }
                            });
                        }
                        if ((homePieceOfFurniture2 = list.get(0)).getElevation() > 0.0f) {
                            arrayList2.add(this.createWallVerticalPartGeometry(wall, (float[][])object, 0.0f, d4, d5, 0.0, homePieceOfFurniture2.getElevation(), homeTexture, fArray2, n));
                            arrayList2.add(this.createWallHorizontalPartGeometry((float[][])object, 0.0f, true, bl));
                            arrayList2.add(this.createWallHorizontalPartGeometry((float[][])object, homePieceOfFurniture2.getElevation(), false, bl));
                        }
                        int n3 = 0;
                        while (n3 < list.size() - 1) {
                            HomePieceOfFurniture homePieceOfFurniture3 = list.get(n3);
                            homePieceOfFurniture = list.get(++n3);
                            while (homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeight() >= homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeight() && ++n3 < list.size()) {
                                homePieceOfFurniture = list.get(n3);
                            }
                            if (n3 >= list.size() || !(homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeight() < homePieceOfFurniture.getElevation())) continue;
                            arrayList2.add(this.createWallVerticalPartGeometry(wall, (float[][])object, homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeight(), d4, d5, 0.0, homePieceOfFurniture.getElevation(), homeTexture, fArray2, n));
                            arrayList2.add(this.createWallHorizontalPartGeometry((float[][])object, homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeight(), true, bl));
                            arrayList2.add(this.createWallHorizontalPartGeometry((float[][])object, homePieceOfFurniture.getElevation(), false, bl));
                        }
                        HomePieceOfFurniture homePieceOfFurniture4 = list.get(list.size() - 1);
                        for (int i = list.size() - 2; i >= 0; --i) {
                            homePieceOfFurniture = list.get(i);
                            if (!(homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeight() > homePieceOfFurniture4.getElevation() + homePieceOfFurniture4.getHeight())) continue;
                            homePieceOfFurniture4 = homePieceOfFurniture;
                        }
                        float f4 = homePieceOfFurniture4.getElevation() + homePieceOfFurniture4.getHeight();
                        double d8 = f3;
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            double d9 = d4 * (double)object[i][0] + d5 * (double)object[i][1];
                            d8 = Math.min(d8, d2 * d9 + d);
                        }
                        if ((double)f4 < d8) {
                            arrayList2.add(this.createWallVerticalPartGeometry(wall, (float[][])object, f4, d4, d5, d2, d, homeTexture, fArray2, n));
                            arrayList2.add(this.createWallHorizontalPartGeometry((float[][])object, f4, true, bl));
                            arrayList2.add(this.createWallTopPartGeometry((float[][])object, d4, d5, d2, d, bl));
                        }
                    }
                    arrayList3.clear();
                    object3 = null;
                } else if (object3 == null || !Arrays.equals((float[])object2, (float[])object3)) {
                    arrayList3.add(object2);
                    object3 = object2;
                }
                pathIterator2.next();
            }
        }
        return arrayList2.toArray(new Geometry[arrayList2.size()]);
    }

    private List<HomePieceOfFurniture> getVisibleDoorsAndWindows(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!homePieceOfFurniture.isVisible()) continue;
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getVisibleDoorsAndWindows(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            if (!homePieceOfFurniture.isDoorOrWindow()) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private float[][] getWallSidePoints(int n) {
        Wall wall = (Wall)this.getUserData();
        float[][] fArray = wall.getPoints();
        if (n == 0) {
            for (int i = fArray.length / 2; i < fArray.length; ++i) {
                fArray[i][0] = (fArray[i][0] + fArray[fArray.length - i - 1][0]) / 2.0f;
                fArray[i][1] = (fArray[i][1] + fArray[fArray.length - i - 1][1]) / 2.0f;
            }
        } else {
            int n2 = fArray.length / 2;
            for (int i = 0; i < n2; ++i) {
                fArray[i][0] = (fArray[i][0] + fArray[fArray.length - i - 1][0]) / 2.0f;
                fArray[i][1] = (fArray[i][1] + fArray[fArray.length - i - 1][1]) / 2.0f;
            }
        }
        return fArray;
    }

    private Geometry createWallVerticalPartGeometry(Wall wall, float[][] fArray, float f, double d, double d2, double d3, double d4, HomeTexture homeTexture, float[] fArray2, int n) {
        int n2;
        Point3f[] point3fArray = new Point3f[fArray.length];
        Point3f[] point3fArray2 = new Point3f[fArray.length];
        double[] dArray = new double[fArray.length];
        Float[] floatArray = new Float[fArray.length];
        float f2 = wall.getXStart();
        float f3 = wall.getYStart();
        float f4 = wall.getXEnd();
        float f5 = wall.getYEnd();
        Float f6 = wall.getArcExtent();
        float[] fArray3 = null;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (f6 != null && f6.floatValue() != 0.0f) {
            fArray3 = new float[]{wall.getXArcCircleCenter(), wall.getYArcCircleCenter()};
            f7 = (float)Point2D.distance(fArray3[0], fArray3[1], f2, f3);
            f8 = (float)Math.atan2(fArray2[1] - fArray3[1], fArray2[0] - fArray3[0]);
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            point3fArray[n2] = new Point3f(fArray[n2][0], f, fArray[n2][1]);
            if (fArray3 == null) {
                dArray[n2] = Line2D.ptLineDistSq(f2, f3, f4, f5, point3fArray[n2].x, point3fArray[n2].z);
            } else {
                dArray[n2] = (double)f7 - Point2D.distance(fArray3[0], fArray3[1], point3fArray[n2].x, point3fArray[n2].z);
                int n3 = n2;
                dArray[n3] = dArray[n3] * dArray[n2];
            }
            double d5 = d * (double)fArray[n2][0] + d2 * (double)fArray[n2][1];
            float f9 = (float)(d3 * d5 + d4);
            point3fArray2[n2] = new Point3f(fArray[n2][0], f9, fArray[n2][1]);
        }
        n2 = 0;
        boolean[] blArray = new boolean[fArray.length];
        for (int i = 0; i < fArray.length - 1; ++i) {
            boolean bl = blArray[i] = dArray[i] > (double)0.001f || dArray[i + 1] > (double)0.001f;
            if (!blArray[i]) continue;
            ++n2;
        }
        boolean bl = blArray[blArray.length - 1] = dArray[0] > (double)0.001f || dArray[fArray.length - 1] > (double)0.001f;
        if (blArray[blArray.length - 1]) {
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Point3f[] point3fArray3 = new Point3f[n2 * 4];
        int n4 = 0;
        for (int i = 0; i < fArray.length - 1; ++i) {
            if (!blArray[i]) continue;
            point3fArray3[n4++] = point3fArray[i];
            point3fArray3[n4++] = point3fArray[i + 1];
            point3fArray3[n4++] = point3fArray2[i + 1];
            point3fArray3[n4++] = point3fArray2[i];
        }
        if (blArray[blArray.length - 1]) {
            point3fArray3[n4++] = point3fArray[fArray.length - 1];
            point3fArray3[n4++] = point3fArray[0];
            point3fArray3[n4++] = point3fArray2[0];
            point3fArray3[n4++] = point3fArray2[fArray.length - 1];
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3fArray3);
        if (homeTexture != null) {
            float f10 = wall.getThickness() * wall.getThickness() / 4.0f;
            TexCoord2f[] texCoord2fArray = new TexCoord2f[n2 * 4];
            float f11 = f / homeTexture.getHeight();
            TexCoord2f texCoord2f = new TexCoord2f(0.0f, f11);
            n4 = 0;
            float f12 = fArray3 == null ? 1.0E-4f : f10 / 4.0f;
            for (int i = 0; i < fArray.length; ++i) {
                float f13;
                int n5 = (i + 1) % fArray.length;
                if (!blArray[i]) continue;
                if (Math.abs(dArray[i] - (double)f10) < (double)f12 && Math.abs(dArray[n5] - (double)f10) < (double)f12) {
                    float f14;
                    if (fArray3 == null) {
                        f13 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[i][0], fArray[i][1]) / homeTexture.getWidth();
                        f14 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[n5][0], fArray[n5][1]) / homeTexture.getWidth();
                    } else {
                        float f15;
                        if (floatArray[i] == null) {
                            f15 = (float)Math.atan2(fArray[i][1] - fArray3[1], fArray[i][0] - fArray3[0]);
                            f15 = this.adjustAngleOnReferencePointAngle(f15, f8, f6.floatValue());
                            floatArray[i] = Float.valueOf((f15 - f8) * f7 / homeTexture.getWidth());
                        }
                        if (floatArray[n5] == null) {
                            f15 = (float)Math.atan2(fArray[n5][1] - fArray3[1], fArray[n5][0] - fArray3[0]);
                            f15 = this.adjustAngleOnReferencePointAngle(f15, f8, f6.floatValue());
                            floatArray[n5] = Float.valueOf((f15 - f8) * f7 / homeTexture.getWidth());
                        }
                        f13 = floatArray[i].floatValue();
                        f14 = floatArray[n5].floatValue();
                    }
                    texCoord2fArray[n4++] = new TexCoord2f(f13, f11);
                    texCoord2fArray[n4++] = new TexCoord2f(f14, f11);
                    texCoord2fArray[n4++] = new TexCoord2f(f14, point3fArray2[n5].y / homeTexture.getHeight());
                    texCoord2fArray[n4++] = new TexCoord2f(f13, point3fArray2[i].y / homeTexture.getHeight());
                    continue;
                }
                f13 = (float)Point2D.distance(fArray[i][0], fArray[i][1], fArray[n5][0], fArray[n5][1]) / homeTexture.getWidth();
                texCoord2fArray[n4++] = texCoord2f;
                texCoord2fArray[n4++] = new TexCoord2f(f13, f11);
                texCoord2fArray[n4++] = new TexCoord2f(f13, point3fArray2[n5].y / homeTexture.getHeight());
                texCoord2fArray[n4++] = new TexCoord2f(0.0f, point3fArray2[i].y / homeTexture.getHeight());
            }
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        NormalGenerator normalGenerator = new NormalGenerator();
        if (fArray3 == null) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private float adjustAngleOnReferencePointAngle(float f, float f2, float f3) {
        if (f3 > 0.0f) {
            if (f2 > 0.0f && (f < 0.0f || f2 > f) || f2 < 0.0f && f < 0.0f && f2 > f) {
                f += (float)Math.PI * 2;
            }
        } else if (f2 < 0.0f && (f > 0.0f || f2 < f) || f2 > 0.0f && f > 0.0f && f2 < f) {
            f -= (float)Math.PI * 2;
        }
        return f;
    }

    private Geometry createWallHorizontalPartGeometry(float[][] fArray, float f, boolean bl, boolean bl2) {
        Point3f[] point3fArray = new Point3f[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            point3fArray[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(new int[]{point3fArray.length});
        if (bl) {
            geometryInfo.reverse();
        }
        NormalGenerator normalGenerator = new NormalGenerator();
        if (bl2) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private Geometry createWallTopPartGeometry(float[][] fArray, double d, double d2, double d3, double d4, boolean bl) {
        Point3f[] point3fArray = new Point3f[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            double d5 = d * (double)fArray[i][0] + d2 * (double)fArray[i][1];
            float f = (float)(d3 * d5 + d4);
            point3fArray[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(new int[]{point3fArray.length});
        NormalGenerator normalGenerator = new NormalGenerator();
        if (bl) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private float getWallHeightAtStart() {
        Float f = ((Wall)this.getUserData()).getHeight();
        if (f != null) {
            return f.floatValue();
        }
        return this.home.getWallHeight();
    }

    private float getWallHeightAtEnd() {
        Wall wall = (Wall)this.getUserData();
        if (wall.isTrapezoidal()) {
            return wall.getHeightAtEnd().floatValue();
        }
        return this.getWallHeightAtStart();
    }

    private void updateWallAppearance(boolean bl) {
        Wall wall = (Wall)this.getUserData();
        this.updateFilledWallSideAppearance(((Shape3D)this.getChild(0)).getAppearance(), wall.getLeftSideTexture(), bl, wall.getLeftSideColor(), wall.getLeftSideShininess());
        this.updateFilledWallSideAppearance(((Shape3D)this.getChild(1)).getAppearance(), wall.getRightSideTexture(), bl, wall.getRightSideColor(), wall.getRightSideShininess());
        if (this.numChildren() > 2) {
            this.updateOutlineWallSideAppearance(((Shape3D)this.getChild(2)).getAppearance());
            this.updateOutlineWallSideAppearance(((Shape3D)this.getChild(3)).getAppearance());
        }
    }

    private void updateFilledWallSideAppearance(final Appearance appearance, HomeTexture homeTexture, boolean bl, Integer n, float f) {
        if (homeTexture == null) {
            appearance.setMaterial(this.getMaterial(n, n, f));
            appearance.setTexture(null);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f));
            TextureManager textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                public void textureUpdated(Texture texture) {
                    appearance.setTexture(texture);
                }
            });
        }
        float f2 = this.home.getEnvironment().getWallsAlpha();
        TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
        transparencyAttributes.setTransparency(f2);
        transparencyAttributes.setTransparencyMode(f2 == 0.0f ? 4 : 1);
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        HomeEnvironment.DrawingMode drawingMode = this.home.getEnvironment().getDrawingMode();
        renderingAttributes.setVisible(drawingMode == null || drawingMode == HomeEnvironment.DrawingMode.FILL || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE);
    }

    private void updateOutlineWallSideAppearance(Appearance appearance) {
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        HomeEnvironment.DrawingMode drawingMode = this.home.getEnvironment().getDrawingMode();
        renderingAttributes.setVisible(drawingMode == HomeEnvironment.DrawingMode.OUTLINE || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE);
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoorOrWindowArea {
        private final Area area;
        private final List<HomePieceOfFurniture> doorsOrWindows;

        public DoorOrWindowArea(Area area, List<HomePieceOfFurniture> list) {
            this.area = area;
            this.doorsOrWindows = list;
        }

        public Area getArea() {
            return this.area;
        }

        public List<HomePieceOfFurniture> getDoorsOrWindows() {
            return this.doorsOrWindows;
        }
    }
}

