/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Selectable;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class ObserverCamera
extends Camera
implements Selectable {
    private static final long serialVersionUID = 1L;
    private transient Shape shapeCache;
    private transient Shape rectangleShapeCache;

    public ObserverCamera(float f, float f2, float f3, float f4, float f5, float f6) {
        super(f, f2, f3, f4, f5, f6);
    }

    public void setYaw(float f) {
        super.setYaw(f);
        this.shapeCache = null;
        this.rectangleShapeCache = null;
    }

    public void setX(float f) {
        super.setX(f);
        this.shapeCache = null;
        this.rectangleShapeCache = null;
    }

    public void setY(float f) {
        super.setY(f);
        this.shapeCache = null;
        this.rectangleShapeCache = null;
    }

    public void setZ(float f) {
        super.setZ(f);
        this.shapeCache = null;
        this.rectangleShapeCache = null;
    }

    public float getWidth() {
        float f = this.getZ() * 4.0f / 14.0f;
        return Math.min(Math.max(f, 20.0f), 62.5f);
    }

    public float getDepth() {
        float f = this.getZ() * 8.0f / 70.0f;
        return Math.min(Math.max(f, 8.0f), 25.0f);
    }

    public float getHeight() {
        return this.getZ() * 15.0f / 14.0f;
    }

    public float[][] getPoints() {
        float[][] fArray = new float[4][2];
        PathIterator pathIterator = this.getRectangleShape().getPathIterator(null);
        for (int i = 0; i < fArray.length; ++i) {
            pathIterator.currentSegment(fArray[i]);
            pathIterator.next();
        }
        return fArray;
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return this.getShape().contains(f, f2);
        }
        return this.getShape().intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    private Shape getShape() {
        if (this.shapeCache == null) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(this.getX() - this.getWidth() / 2.0f, this.getY() - this.getDepth() / 2.0f, this.getWidth(), this.getDepth());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(this.getYaw(), this.getX(), this.getY());
            PathIterator pathIterator = float_.getPathIterator(affineTransform);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(pathIterator, false);
            this.shapeCache = generalPath;
        }
        return this.shapeCache;
    }

    private Shape getRectangleShape() {
        if (this.rectangleShapeCache == null) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(this.getX() - this.getWidth() / 2.0f, this.getY() - this.getDepth() / 2.0f, this.getWidth(), this.getDepth());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(this.getYaw(), this.getX(), this.getY());
            PathIterator pathIterator = float_.getPathIterator(affineTransform);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(pathIterator, false);
            this.rectangleShapeCache = generalPath;
        }
        return this.rectangleShapeCache;
    }

    public void move(float f, float f2) {
        this.setX(this.getX() + f);
        this.setY(this.getY() + f2);
    }

    public ObserverCamera clone() {
        return (ObserverCamera)super.clone();
    }
}

