/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class Room
implements Serializable,
Selectable {
    private static final long serialVersionUID = 1L;
    private String name;
    private float nameXOffset;
    private float nameYOffset;
    private TextStyle nameStyle;
    private float[][] points;
    private boolean areaVisible;
    private float areaXOffset;
    private float areaYOffset;
    private TextStyle areaStyle;
    private boolean floorVisible;
    private Integer floorColor;
    private HomeTexture floorTexture;
    private float floorShininess;
    private boolean ceilingVisible;
    private Integer ceilingColor;
    private HomeTexture ceilingTexture;
    private float ceilingShininess;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient Shape shapeCache;
    private transient Float areaCache;

    public Room(float[][] fArray) {
        this.points = this.deepCopy(fArray);
        this.areaVisible = true;
        this.nameYOffset = -40.0f;
        this.floorVisible = true;
        this.ceilingVisible = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != this.name || string != null && !string.equals(this.name)) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public float getNameXOffset() {
        return this.nameXOffset;
    }

    public void setNameXOffset(float f) {
        if (f != this.nameXOffset) {
            float f2 = this.nameXOffset;
            this.nameXOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_X_OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNameYOffset() {
        return this.nameYOffset;
    }

    public void setNameYOffset(float f) {
        if (f != this.nameYOffset) {
            float f2 = this.nameYOffset;
            this.nameYOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_Y_OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public TextStyle getNameStyle() {
        return this.nameStyle;
    }

    public void setNameStyle(TextStyle textStyle) {
        if (textStyle != this.nameStyle) {
            TextStyle textStyle2 = this.nameStyle;
            this.nameStyle = textStyle;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_STYLE.name(), textStyle2, textStyle);
        }
    }

    public float[][] getPoints() {
        return this.deepCopy(this.points);
    }

    public int getPointCount() {
        return this.points.length;
    }

    private float[][] deepCopy(float[][] fArray) {
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            fArrayArray[i] = (float[])fArray[i].clone();
        }
        return fArrayArray;
    }

    public void setPoints(float[][] fArray) {
        if (!Arrays.deepEquals((Object[])this.points, (Object[])fArray)) {
            this.updatePoints(fArray);
        }
    }

    private void updatePoints(float[][] fArray) {
        float[][] fArray2 = this.points;
        this.points = this.deepCopy(fArray);
        this.shapeCache = null;
        this.areaCache = null;
        this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray2, fArray);
    }

    public void addPoint(float f, float f2) {
        this.addPoint(f, f2, this.points.length);
    }

    public void addPoint(float f, float f2, int n) {
        if (n < 0 || n > this.points.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        float[][] fArrayArray = new float[this.points.length + 1][];
        System.arraycopy(this.points, 0, fArrayArray, 0, n);
        fArrayArray[n] = new float[]{f, f2};
        System.arraycopy(this.points, n, fArrayArray, n + 1, this.points.length - n);
        float[][] fArray = this.points;
        this.points = fArrayArray;
        this.shapeCache = null;
        this.areaCache = null;
        this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray, this.deepCopy(this.points));
    }

    public void setPoint(float f, float f2, int n) {
        if (n < 0 || n >= this.points.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        if (this.points[n][0] != f || this.points[n][1] != f2) {
            float[][] fArray = this.points;
            this.points = this.deepCopy(this.points);
            this.points[n][0] = f;
            this.points[n][1] = f2;
            this.shapeCache = null;
            this.areaCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray, this.deepCopy(this.points));
        }
    }

    public void removePoint(int n) {
        if (n < 0 || n >= this.points.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        float[][] fArrayArray = new float[this.points.length - 1][];
        System.arraycopy(this.points, 0, fArrayArray, 0, n);
        System.arraycopy(this.points, n + 1, fArrayArray, n, this.points.length - n - 1);
        float[][] fArray = this.points;
        this.points = fArrayArray;
        this.shapeCache = null;
        this.areaCache = null;
        this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray, this.deepCopy(this.points));
    }

    public boolean isAreaVisible() {
        return this.areaVisible;
    }

    public void setAreaVisible(boolean bl) {
        if (bl != this.areaVisible) {
            this.areaVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.AREA_VISIBLE.name(), !bl, bl);
        }
    }

    public float getAreaXOffset() {
        return this.areaXOffset;
    }

    public void setAreaXOffset(float f) {
        if (f != this.areaXOffset) {
            float f2 = this.areaXOffset;
            this.areaXOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.AREA_X_OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getAreaYOffset() {
        return this.areaYOffset;
    }

    public void setAreaYOffset(float f) {
        if (f != this.areaYOffset) {
            float f2 = this.areaYOffset;
            this.areaYOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.AREA_Y_OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public TextStyle getAreaStyle() {
        return this.areaStyle;
    }

    public void setAreaStyle(TextStyle textStyle) {
        if (textStyle != this.areaStyle) {
            TextStyle textStyle2 = this.areaStyle;
            this.areaStyle = textStyle;
            this.propertyChangeSupport.firePropertyChange(Property.AREA_STYLE.name(), textStyle2, textStyle);
        }
    }

    public float getXCenter() {
        float f = this.points[0][0];
        float f2 = this.points[0][0];
        for (int i = 1; i < this.points.length; ++i) {
            f = Math.min(f, this.points[i][0]);
            f2 = Math.max(f2, this.points[i][0]);
        }
        return (f + f2) / 2.0f;
    }

    public float getYCenter() {
        float f = this.points[0][1];
        float f2 = this.points[0][1];
        for (int i = 1; i < this.points.length; ++i) {
            f = Math.min(f, this.points[i][1]);
            f2 = Math.max(f2, this.points[i][1]);
        }
        return (f + f2) / 2.0f;
    }

    public Integer getFloorColor() {
        return this.floorColor;
    }

    public void setFloorColor(Integer n) {
        if (n != this.floorColor || n != null && !n.equals(this.floorColor)) {
            Integer n2 = this.floorColor;
            this.floorColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_COLOR.name(), n2, n);
        }
    }

    public HomeTexture getFloorTexture() {
        return this.floorTexture;
    }

    public void setFloorTexture(HomeTexture homeTexture) {
        if (homeTexture != this.floorTexture || homeTexture != null && !homeTexture.equals(this.floorTexture)) {
            HomeTexture homeTexture2 = this.floorTexture;
            this.floorTexture = homeTexture;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public boolean isFloorVisible() {
        return this.floorVisible;
    }

    public void setFloorVisible(boolean bl) {
        if (bl != this.floorVisible) {
            this.floorVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_VISIBLE.name(), !bl, bl);
        }
    }

    public float getFloorShininess() {
        return this.floorShininess;
    }

    public void setFloorShininess(float f) {
        if (f != this.floorShininess) {
            float f2 = this.floorShininess;
            this.floorShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_SHININESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public Integer getCeilingColor() {
        return this.ceilingColor;
    }

    public void setCeilingColor(Integer n) {
        if (n != this.ceilingColor || n != null && !n.equals(this.ceilingColor)) {
            Integer n2 = this.ceilingColor;
            this.ceilingColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_COLOR.name(), n2, n);
        }
    }

    public HomeTexture getCeilingTexture() {
        return this.ceilingTexture;
    }

    public void setCeilingTexture(HomeTexture homeTexture) {
        if (homeTexture != this.ceilingTexture || homeTexture != null && !homeTexture.equals(this.ceilingTexture)) {
            HomeTexture homeTexture2 = this.ceilingTexture;
            this.ceilingTexture = homeTexture;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public boolean isCeilingVisible() {
        return this.ceilingVisible;
    }

    public void setCeilingVisible(boolean bl) {
        if (bl != this.ceilingVisible) {
            this.ceilingVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_VISIBLE.name(), !bl, bl);
        }
    }

    public float getCeilingShininess() {
        return this.ceilingShininess;
    }

    public void setCeilingShininess(float f) {
        if (f != this.ceilingShininess) {
            float f2 = this.ceilingShininess;
            this.ceilingShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_SHININESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getArea() {
        if (this.areaCache == null) {
            Area area = new Area(this.getShape());
            if (area.isSingular()) {
                this.areaCache = Float.valueOf(Math.abs(this.getSignedArea(this.getPoints())));
            } else {
                float f = 0.0f;
                ArrayList<float[]> arrayList = new ArrayList<float[]>();
                PathIterator pathIterator = area.getPathIterator(null);
                while (!pathIterator.isDone()) {
                    float[] fArray = new float[2];
                    switch (pathIterator.currentSegment(fArray)) {
                        case 0: {
                            arrayList.add(fArray);
                            break;
                        }
                        case 1: {
                            arrayList.add(fArray);
                            break;
                        }
                        case 4: {
                            float[][] fArray2 = (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
                            f += Math.abs(this.getSignedArea(fArray2));
                            arrayList.clear();
                        }
                    }
                    pathIterator.next();
                }
                this.areaCache = Float.valueOf(f);
            }
        }
        return this.areaCache.floatValue();
    }

    private float getSignedArea(float[][] fArray) {
        float f = 0.0f;
        for (int i = 1; i < fArray.length; ++i) {
            f += fArray[i][0] * fArray[i - 1][1];
            f -= fArray[i][1] * fArray[i - 1][0];
        }
        f += fArray[0][0] * fArray[fArray.length - 1][1];
        return (f -= fArray[0][1] * fArray[fArray.length - 1][0]) / 2.0f;
    }

    public boolean isClockwise() {
        return this.getSignedArea(this.getPoints()) < 0.0f;
    }

    public boolean isSingular() {
        return new Area(this.getShape()).isSingular();
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        return this.containsShapeAtWithMargin(this.getShape(), f, f2, f3);
    }

    public int getPointIndexAt(float f, float f2, float f3) {
        for (int i = 0; i < this.points.length; ++i) {
            if (!(Math.abs(f - this.points[i][0]) <= f3) || !(Math.abs(f2 - this.points[i][1]) <= f3)) continue;
            return i;
        }
        return -1;
    }

    public boolean isNameCenterPointAt(float f, float f2, float f3) {
        return Math.abs(f - this.getXCenter() - this.getNameXOffset()) <= f3 && Math.abs(f2 - this.getYCenter() - this.getNameYOffset()) <= f3;
    }

    public boolean isAreaCenterPointAt(float f, float f2, float f3) {
        return Math.abs(f - this.getXCenter() - this.getAreaXOffset()) <= f3 && Math.abs(f2 - this.getYCenter() - this.getAreaYOffset()) <= f3;
    }

    private boolean containsShapeAtWithMargin(Shape shape, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return shape.contains(f, f2);
        }
        return shape.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    private Shape getShape() {
        if (this.shapeCache == null) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(this.points[0][0], this.points[0][1]);
            for (int i = 1; i < this.points.length; ++i) {
                generalPath.lineTo(this.points[i][0], this.points[i][1]);
            }
            generalPath.closePath();
            this.shapeCache = generalPath;
        }
        return this.shapeCache;
    }

    public void move(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            float[][] fArray = this.getPoints();
            for (int i = 0; i < fArray.length; ++i) {
                float[] fArray2 = fArray[i];
                fArray2[0] = fArray2[0] + f;
                float[] fArray3 = fArray[i];
                fArray3[1] = fArray3[1] + f2;
            }
            this.updatePoints(fArray);
        }
    }

    public Room clone() {
        try {
            Room room = (Room)super.clone();
            room.propertyChangeSupport = new PropertyChangeSupport(room);
            return room;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        NAME_X_OFFSET,
        NAME_Y_OFFSET,
        NAME_STYLE,
        POINTS,
        AREA_VISIBLE,
        AREA_X_OFFSET,
        AREA_Y_OFFSET,
        AREA_STYLE,
        FLOOR_COLOR,
        FLOOR_TEXTURE,
        FLOOR_VISIBLE,
        FLOOR_SHININESS,
        CEILING_COLOR,
        CEILING_TEXTURE,
        CEILING_VISIBLE,
        CEILING_SHININESS;

    }
}

