/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ProportionalLayout;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.viewcontroller.BackgroundImageWizardController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class BackgroundImageWizardStepsPanel
extends JPanel
implements View {
    private final BackgroundImageWizardController controller;
    private final Executor imageLoader;
    private CardLayout cardLayout;
    private JLabel imageChoiceOrChangeLabel;
    private JButton imageChoiceOrChangeButton;
    private JLabel imageChoiceErrorLabel;
    private ScaledImageComponent imageChoicePreviewComponent;
    private JLabel scaleLabel;
    private JLabel scaleDistanceLabel;
    private JSpinner scaleDistanceSpinner;
    private ScaledImageComponent scalePreviewComponent;
    private JLabel originLabel;
    private JLabel xOriginLabel;
    private JSpinner xOriginSpinner;
    private JLabel yOriginLabel;
    private JSpinner yOriginSpinner;
    private ScaledImageComponent originPreviewComponent;
    private static BufferedImage waitImage;

    public BackgroundImageWizardStepsPanel(BackgroundImage backgroundImage, UserPreferences userPreferences, final BackgroundImageWizardController backgroundImageWizardController) {
        this.controller = backgroundImageWizardController;
        this.imageLoader = Executors.newSingleThreadExecutor();
        this.createComponents(userPreferences, backgroundImageWizardController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        this.updateController(backgroundImage, userPreferences);
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.STEP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BackgroundImageWizardStepsPanel.this.updateStep(backgroundImageWizardController);
            }
        });
    }

    private void createComponents(final UserPreferences userPreferences, final BackgroundImageWizardController backgroundImageWizardController) {
        String string = userPreferences.getLengthUnit().getName();
        this.imageChoiceOrChangeLabel = new JLabel();
        this.imageChoiceOrChangeButton = new JButton();
        this.imageChoiceOrChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = BackgroundImageWizardStepsPanel.this.showImageChoiceDialog(userPreferences, backgroundImageWizardController.getContentManager());
                if (string != null) {
                    BackgroundImageWizardStepsPanel.this.updateController(string, userPreferences, backgroundImageWizardController.getContentManager());
                }
            }
        });
        this.imageChoiceErrorLabel = new JLabel(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceErrorLabel.text", new Object[0]));
        this.imageChoiceErrorLabel.setVisible(false);
        this.imageChoicePreviewComponent = new ScaledImageComponent();
        this.imageChoicePreviewComponent.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                boolean bl = true;
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    final String string = ((File)list.get(0)).getAbsolutePath();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            BackgroundImageWizardStepsPanel.this.updateController(string, userPreferences, backgroundImageWizardController.getContentManager());
                        }
                    });
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceError", new Object[0]));
                        }
                    });
                }
                return bl;
            }
        });
        this.imageChoicePreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
        this.scaleLabel = new JLabel(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "scaleLabel.text", new Object[0]));
        this.scaleDistanceLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "scaleDistanceLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.99f, 1000000.0f);
        this.scaleDistanceSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        this.scaleDistanceSpinner.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                backgroundImageWizardController.setScaleDistance(((NullableSpinner.NullableSpinnerLengthModel)BackgroundImageWizardStepsPanel.this.scaleDistanceSpinner.getModel()).getLength());
            }
        });
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.SCALE_DISTANCE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setNullable(backgroundImageWizardController.getScaleDistance() == null);
                nullableSpinnerLengthModel.setLength(backgroundImageWizardController.getScaleDistance());
            }
        });
        this.scalePreviewComponent = new ScaleImagePreviewComponent(backgroundImageWizardController);
        this.originLabel = new JLabel(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "originLabel.text", new Object[0]));
        this.xOriginLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "xOriginLabel.text", string));
        this.yOriginLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "yOriginLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, 1000000.0f);
        this.xOriginSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, 1000000.0f);
        this.yOriginSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                backgroundImageWizardController.setOrigin(nullableSpinnerLengthModel2.getLength().floatValue(), nullableSpinnerLengthModel3.getLength().floatValue());
            }
        };
        nullableSpinnerLengthModel2.addChangeListener(changeListener);
        nullableSpinnerLengthModel3.addChangeListener(changeListener);
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.X_ORIGIN, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength(Float.valueOf(backgroundImageWizardController.getXOrigin()));
            }
        });
        backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.Y_ORIGIN, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setLength(Float.valueOf(backgroundImageWizardController.getYOrigin()));
            }
        });
        this.originPreviewComponent = new OriginImagePreviewComponent(backgroundImageWizardController);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.scaleDistanceLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "scaleDistanceLabel.mnemonic", new Object[0])).getKeyCode());
            this.scaleDistanceLabel.setLabelFor(this.scaleDistanceSpinner);
            this.xOriginLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "xOriginLabel.mnemonic", new Object[0])).getKeyCode());
            this.xOriginLabel.setLabelFor(this.xOriginSpinner);
            this.yOriginLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "yOriginLabel.mnemonic", new Object[0])).getKeyCode());
            this.yOriginLabel.setLabelFor(this.yOriginSpinner);
        }
    }

    private void layoutComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.imageChoiceOrChangeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.imageChoiceOrChangeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.imageChoiceErrorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new ProportionalLayout());
        jPanel2.add((Component)jPanel, (Object)ProportionalLayout.Constraints.TOP);
        jPanel2.add((Component)this.imageChoicePreviewComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.scaleLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.scaleDistanceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel3.add((Component)this.scaleDistanceSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new ProportionalLayout());
        jPanel4.add((Component)jPanel3, (Object)ProportionalLayout.Constraints.TOP);
        jPanel4.add((Component)this.scalePreviewComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)this.originLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel5.add((Component)this.xOriginLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel5.add((Component)this.xOriginSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 10), -10, 0));
        jPanel5.add((Component)this.yOriginLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel5.add((Component)this.yOriginSpinner, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), -10, 0));
        JPanel jPanel6 = new JPanel(new ProportionalLayout());
        jPanel6.add((Component)jPanel5, (Object)ProportionalLayout.Constraints.TOP);
        jPanel6.add((Component)this.originPreviewComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
        this.add((Component)jPanel2, BackgroundImageWizardController.Step.CHOICE.name());
        this.add((Component)jPanel4, BackgroundImageWizardController.Step.SCALE.name());
        this.add((Component)jPanel6, BackgroundImageWizardController.Step.ORIGIN.name());
    }

    public void updateStep(BackgroundImageWizardController backgroundImageWizardController) {
        BackgroundImageWizardController.Step step = backgroundImageWizardController.getStep();
        this.cardLayout.show(this, step.name());
        switch (step) {
            case CHOICE: {
                this.imageChoiceOrChangeButton.requestFocusInWindow();
                break;
            }
            case SCALE: {
                ((JSpinner.DefaultEditor)this.scaleDistanceSpinner.getEditor()).getTextField().requestFocusInWindow();
                break;
            }
            case ORIGIN: {
                ((JSpinner.DefaultEditor)this.xOriginSpinner.getEditor()).getTextField().requestFocusInWindow();
            }
        }
    }

    private void updateController(final BackgroundImage backgroundImage, final UserPreferences userPreferences) {
        if (backgroundImage == null) {
            this.setImageChoiceTexts(userPreferences);
            this.updatePreviewComponentsImage(null);
        } else {
            this.setImageChangeTexts(userPreferences);
            this.imageLoader.execute(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = BackgroundImageWizardStepsPanel.this.readImage(backgroundImage.getImage(), userPreferences);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    final BufferedImage bufferedImage2 = bufferedImage;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (bufferedImage2 != null) {
                                BackgroundImageWizardStepsPanel.this.controller.setImage(backgroundImage.getImage());
                                BackgroundImageWizardStepsPanel.this.controller.setScaleDistance(Float.valueOf(backgroundImage.getScaleDistance()));
                                BackgroundImageWizardStepsPanel.this.controller.setScaleDistancePoints(backgroundImage.getScaleDistanceXStart(), backgroundImage.getScaleDistanceYStart(), backgroundImage.getScaleDistanceXEnd(), backgroundImage.getScaleDistanceYEnd());
                                BackgroundImageWizardStepsPanel.this.controller.setOrigin(backgroundImage.getXOrigin(), backgroundImage.getYOrigin());
                            } else {
                                BackgroundImageWizardStepsPanel.this.controller.setImage(null);
                                BackgroundImageWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                                BackgroundImageWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(true);
                            }
                        }
                    });
                }
            });
        }
    }

    private void updateController(final String string, final UserPreferences userPreferences, final ContentManager contentManager) {
        this.imageLoader.execute(new Runnable(){

            public void run() {
                TemporaryURLContent temporaryURLContent = null;
                try {
                    temporaryURLContent = TemporaryURLContent.copyToTemporaryURLContent(contentManager.getContent(string));
                }
                catch (RecorderException recorderException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (temporaryURLContent == null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceError", string));
                        }
                    });
                    return;
                }
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = BackgroundImageWizardStepsPanel.this.readImage(temporaryURLContent, userPreferences);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                final BufferedImage bufferedImage2 = bufferedImage;
                final TemporaryURLContent temporaryURLContent2 = temporaryURLContent;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (bufferedImage2 != null) {
                            BackgroundImageWizardStepsPanel.this.controller.setImage(temporaryURLContent2);
                            BackgroundImageWizardStepsPanel.this.setImageChangeTexts(userPreferences);
                            BackgroundImageWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(false);
                            BackgroundImageWizardStepsPanel.this.controller.setScaleDistance(null);
                            float f = (float)bufferedImage2.getWidth() * 0.1f;
                            float f2 = (float)bufferedImage2.getHeight() / 2.0f;
                            float f3 = (float)bufferedImage2.getWidth() * 0.9f;
                            BackgroundImageWizardStepsPanel.this.controller.setScaleDistancePoints(f, f2, f3, f2);
                            BackgroundImageWizardStepsPanel.this.controller.setOrigin(0.0f, 0.0f);
                        } else if (BackgroundImageWizardStepsPanel.this.isShowing()) {
                            BackgroundImageWizardStepsPanel.this.controller.setImage(null);
                            BackgroundImageWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(BackgroundImageWizardStepsPanel.this), userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceFormatError", new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private BufferedImage readImage(Content content, UserPreferences userPreferences) throws IOException {
        try {
            if (waitImage == null) {
                waitImage = ImageIO.read(BackgroundImageWizardStepsPanel.class.getResource(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "waitIcon", new Object[0])));
            }
            this.updatePreviewComponentsImage(waitImage);
            InputStream inputStream = content.openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            if (bufferedImage != null) {
                this.updatePreviewComponentsImage(bufferedImage);
                return bufferedImage;
            }
            throw new IOException();
        }
        catch (IOException iOException) {
            this.updatePreviewComponentsImage(null);
            throw iOException;
        }
    }

    private void updatePreviewComponentsImage(BufferedImage bufferedImage) {
        this.imageChoicePreviewComponent.setImage(bufferedImage);
        this.scalePreviewComponent.setImage(bufferedImage);
        this.originPreviewComponent.setImage(bufferedImage);
    }

    private void setImageChangeTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChangeLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "imageChangeButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChangeButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void setImageChoiceTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, BackgroundImageWizardStepsPanel.class, "imageChoiceButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private String showImageChoiceDialog(UserPreferences userPreferences, ContentManager contentManager) {
        return contentManager.showOpenDialog(this, userPreferences.getLocalizedString(BackgroundImageWizardStepsPanel.class, "imageChoiceDialog.title", new Object[0]), ContentManager.ContentType.IMAGE);
    }

    private static class OriginImagePreviewComponent
    extends ScaledImageComponent {
        private final BackgroundImageWizardController controller;

        public OriginImagePreviewComponent(BackgroundImageWizardController backgroundImageWizardController) {
            this.controller = backgroundImageWizardController;
            this.addChangeListeners(backgroundImageWizardController);
            this.addMouseListener(backgroundImageWizardController);
        }

        private void addChangeListeners(BackgroundImageWizardController backgroundImageWizardController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    OriginImagePreviewComponent.this.repaint();
                }
            };
            backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.X_ORIGIN, propertyChangeListener);
            backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.Y_ORIGIN, propertyChangeListener);
        }

        public void addMouseListener(final BackgroundImageWizardController backgroundImageWizardController) {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger() && OriginImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        Point point = OriginImagePreviewComponent.this.getImageTranslation();
                        float[][] fArray = backgroundImageWizardController.getScaleDistancePoints();
                        float f = OriginImagePreviewComponent.this.getImageScale() / BackgroundImage.getScale(backgroundImageWizardController.getScaleDistance().floatValue(), fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                        float f2 = (float)Math.round((float)(mouseEvent.getX() - point.x) / f * 10.0f) / 10.0f;
                        float f3 = (float)Math.round((float)(mouseEvent.getY() - point.y) / f * 10.0f) / 10.0f;
                        backgroundImageWizardController.setOrigin(f2, f3);
                    }
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                    this.mousePressed(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (OriginImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        OriginImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(1));
                    } else {
                        OriginImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }

        protected void paintComponent(Graphics graphics) {
            if (this.getImage() != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Point point = this.getImageTranslation();
                graphics2D.setColor(UIManager.getColor("window"));
                graphics2D.fillRect(point.x, point.y, (int)((float)this.getImage().getWidth() * this.getImageScale()), (int)((float)this.getImage().getHeight() * this.getImageScale()));
                this.paintImage(graphics, AlphaComposite.getInstance(3, 0.5f));
                Color color = OperatingSystem.isMacOSXLeopardOrSuperior() ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("textHighlight");
                graphics2D.setPaint(color);
                AffineTransform affineTransform = graphics2D.getTransform();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.translate(point.x, point.y);
                float[][] fArray = this.controller.getScaleDistancePoints();
                float f = this.getImageScale() / BackgroundImage.getScale(this.controller.getScaleDistance().floatValue(), fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                graphics2D.scale(f, f);
                graphics2D.translate(this.controller.getXOrigin(), this.controller.getYOrigin());
                float f2 = 4.0f / f;
                graphics2D.fill(new Ellipse2D.Float(-f2, -f2, f2 * 2.0f, f2 * 2.0f));
                graphics2D.setStroke(new BasicStroke(1.0f / f, 0, 2));
                graphics2D.draw(new Line2D.Double(8.0f / f, 0.0, -8.0f / f, 0.0));
                graphics2D.draw(new Line2D.Double(0.0, 8.0f / f, 0.0, -8.0f / f));
                graphics2D.setTransform(affineTransform);
                graphics2D.setStroke(stroke);
            }
        }
    }

    private static class ScaleImagePreviewComponent
    extends ScaledImageComponent {
        private final BackgroundImageWizardController controller;

        public ScaleImagePreviewComponent(BackgroundImageWizardController backgroundImageWizardController) {
            this.controller = backgroundImageWizardController;
            this.addChangeListeners(backgroundImageWizardController);
            this.addMouseListeners(backgroundImageWizardController);
        }

        private void addChangeListeners(BackgroundImageWizardController backgroundImageWizardController) {
            backgroundImageWizardController.addPropertyChangeListener(BackgroundImageWizardController.Property.SCALE_DISTANCE_POINTS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ScaleImagePreviewComponent.this.repaint();
                }
            });
        }

        public void addMouseListeners(final BackgroundImageWizardController backgroundImageWizardController) {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
                private int lastX;
                private int lastY;
                private boolean distanceStartPoint;
                private boolean distanceEndPoint;

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger()) {
                        this.mouseMoved(mouseEvent);
                        if (this.distanceStartPoint || this.distanceEndPoint) {
                            this.lastX = mouseEvent.getX();
                            this.lastY = mouseEvent.getY();
                        }
                    }
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (ScaleImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        float[][] fArray = backgroundImageWizardController.getScaleDistancePoints();
                        float f = ScaleImagePreviewComponent.this.getImageScale();
                        if (this.distanceStartPoint) {
                            float[] fArray2 = fArray[0];
                            fArray2[0] = fArray2[0] + (float)(mouseEvent.getX() - this.lastX) / f;
                            float[] fArray3 = fArray[0];
                            fArray3[1] = fArray3[1] + (float)(mouseEvent.getY() - this.lastY) / f;
                        } else if (this.distanceEndPoint) {
                            float[] fArray4 = fArray[1];
                            fArray4[0] = fArray4[0] + (float)(mouseEvent.getX() - this.lastX) / f;
                            float[] fArray5 = fArray[1];
                            fArray5[1] = fArray5[1] + (float)(mouseEvent.getY() - this.lastY) / f;
                        }
                        if ((this.distanceStartPoint || this.distanceEndPoint) && Point2D.distanceSq(fArray[0][0] * f, fArray[0][1] * f, fArray[1][0] * f, fArray[1][1] * f) >= 4.0) {
                            backgroundImageWizardController.setScaleDistancePoints(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                            ScaleImagePreviewComponent.this.repaint();
                        }
                        this.lastX = mouseEvent.getX();
                        this.lastY = mouseEvent.getY();
                    }
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.distanceEndPoint = false;
                    this.distanceStartPoint = false;
                    if (ScaleImagePreviewComponent.this.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        float[][] fArray = backgroundImageWizardController.getScaleDistancePoints();
                        Point point = ScaleImagePreviewComponent.this.getImageTranslation();
                        float f = ScaleImagePreviewComponent.this.getImageScale();
                        if (Math.abs(fArray[0][0] * f - (float)mouseEvent.getX() + (float)point.x) < 2.0f && Math.abs(fArray[0][1] * f - (float)mouseEvent.getY() + (float)point.y) < 2.0f) {
                            this.distanceStartPoint = true;
                        } else if (Math.abs(fArray[1][0] * f - (float)mouseEvent.getX() + (float)point.x) < 2.0f && Math.abs(fArray[1][1] * f - (float)mouseEvent.getY() + (float)point.y) < 2.0f) {
                            this.distanceEndPoint = true;
                        }
                    }
                    if (this.distanceStartPoint || this.distanceEndPoint) {
                        ScaleImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(1));
                    } else {
                        ScaleImagePreviewComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }

        protected void paintComponent(Graphics graphics) {
            if (this.getImage() != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Point point = this.getImageTranslation();
                float f = this.getImageScale();
                graphics2D.setColor(UIManager.getColor("window"));
                graphics2D.fillRect(point.x, point.y, (int)((float)this.getImage().getWidth() * f), (int)((float)this.getImage().getHeight() * f));
                this.paintImage(graphics2D, AlphaComposite.getInstance(3, 0.5f));
                Color color = OperatingSystem.isMacOSXLeopardOrSuperior() ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("textHighlight");
                graphics2D.setPaint(color);
                AffineTransform affineTransform = graphics2D.getTransform();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.translate(point.x, point.y);
                graphics2D.scale(f, f);
                graphics2D.setStroke(new BasicStroke(5.0f / f, 0, 2));
                float[][] fArray = this.controller.getScaleDistancePoints();
                graphics2D.draw(new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]));
                graphics2D.setStroke(new BasicStroke(1.0f / f, 0, 2));
                double d = Math.atan2(fArray[1][1] - fArray[0][1], fArray[1][0] - fArray[0][0]);
                AffineTransform affineTransform2 = graphics2D.getTransform();
                graphics2D.translate(fArray[0][0], fArray[0][1]);
                graphics2D.rotate(d);
                Line2D.Double double_ = new Line2D.Double(0.0, 5.0f / f, 0.0, -5.0f / f);
                graphics2D.draw(double_);
                graphics2D.setTransform(affineTransform2);
                graphics2D.translate(fArray[1][0], fArray[1][1]);
                graphics2D.rotate(d);
                graphics2D.draw(double_);
                graphics2D.setTransform(affineTransform);
                graphics2D.setStroke(stroke);
            }
        }
    }
}

