/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.swing.SwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class ColorButton
extends JButton {
    public static final String COLOR_PROPERTY = "color";
    public static final String COLOR_DIALOG_TITLE_PROPERTY = "colorDialogTitle";
    private static JColorChooser colorChooser;
    private static Locale colorChooserLocale;
    private Integer color;
    private String colorDialogTitle;

    public ColorButton() {
        JLabel jLabel = new JLabel("Color");
        Dimension dimension = jLabel.getPreferredSize();
        final int n = dimension.width;
        final int n2 = dimension.height;
        this.setIcon(new Icon(){

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n3 + 2, n22 + 2, n - 5, n2 - 5);
                if (ColorButton.this.color != null) {
                    graphics.setColor(new Color(ColorButton.this.color));
                    graphics.fillRect(n3 + 3, n22 + 3, n - 6, n2 - 6);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (colorChooser == null || !Locale.getDefault().equals(colorChooserLocale)) {
                    try {
                        object = ResourceBundle.getBundle("com.sun.swing.internal.plaf.basic.resources.basic");
                        Enumeration<String> enumeration = ((ResourceBundle)object).getKeys();
                        while (enumeration.hasMoreElements()) {
                            String string = enumeration.nextElement();
                            UIManager.put(string, ((ResourceBundle)object).getString(string));
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    colorChooser = new JColorChooser();
                    this.addAutoSelectionOnTextFields(colorChooser);
                    colorChooser.getActionMap().put("close", new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ((Window)SwingUtilities.getRoot(colorChooser)).dispose();
                        }
                    });
                    colorChooser.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
                    colorChooserLocale = Locale.getDefault();
                }
                colorChooser.setColor(ColorButton.this.color != null ? new Color(ColorButton.this.color) : null);
                object = JColorChooser.createDialog(ColorButton.this.getParent(), ColorButton.this.colorDialogTitle, true, colorChooser, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColorButton.this.setColor(colorChooser.getColor().getRGB());
                    }
                }, null);
                ((Dialog)object).setVisible(true);
            }

            private void addAutoSelectionOnTextFields(JComponent jComponent) {
                JComponent jComponent2;
                if (jComponent instanceof JTextComponent) {
                    SwingTools.addAutoSelectionOnFocusGain((JTextComponent)jComponent);
                } else if (jComponent instanceof JSpinner && (jComponent2 = ((JSpinner)jComponent).getEditor()) instanceof JSpinner.DefaultEditor) {
                    SwingTools.addAutoSelectionOnFocusGain(((JSpinner.DefaultEditor)jComponent2).getTextField());
                }
                int n = jComponent.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = jComponent.getComponent(i);
                    if (!(component instanceof JComponent)) continue;
                    this.addAutoSelectionOnTextFields((JComponent)component);
                }
            }
        });
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer n) {
        if (n != this.color || n != null && !n.equals(this.color)) {
            Integer n2 = this.color;
            this.color = n;
            this.firePropertyChange(COLOR_PROPERTY, n2, n);
            this.repaint();
        }
    }

    public String getColorDialogTitle() {
        return this.colorDialogTitle;
    }

    public void setColorDialogTitle(String string) {
        if (string != this.colorDialogTitle || string != null && !string.equals(this.colorDialogTitle)) {
            String string2 = this.colorDialogTitle;
            this.colorDialogTitle = string;
            this.firePropertyChange(COLOR_DIALOG_TITLE_PROPERTY, string2, string);
            this.repaint();
        }
    }
}

