/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.HomeController3D;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import com.sun.j3d.exp.swing.JCanvas3D;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.IllegalRenderingStateException;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeComponent3D
extends JComponent
implements com.eteks.sweethome3d.viewcontroller.View,
Printable {
    private final Home home;
    private final boolean displayShadowOnFloor;
    private final Object3DFactory object3dFactory;
    private final Map<Selectable, Object3DBranch> homeObjects = new HashMap<Selectable, Object3DBranch>();
    private Collection<Selectable> homeObjectsToUpdate;
    private Component component3D;
    private SimpleUniverse onscreenUniverse;
    private Camera camera;
    private PropertyChangeListener cameraChangeListener;
    private PropertyChangeListener homeCameraListener;
    private PropertyChangeListener skyColorListener;
    private PropertyChangeListener groundColorAndTextureListener;
    private PropertyChangeListener lightColorListener;
    private PropertyChangeListener wallsAlphaListener;
    private PropertyChangeListener drawingModeListener;
    private CollectionListener<Wall> wallListener;
    private PropertyChangeListener wallChangeListener;
    private CollectionListener<HomePieceOfFurniture> furnitureListener;
    private PropertyChangeListener furnitureChangeListener;
    private CollectionListener<Room> roomListener;
    private PropertyChangeListener roomChangeListener;
    private BufferedImage printedImage;
    private SimpleUniverse offscreenUniverse;
    private JComponent navigationPanel;
    private ComponentListener navigationPanelListener;
    private BufferedImage navigationPanelImage;

    public HomeComponent3D(Home home) {
        this(home, null);
    }

    public HomeComponent3D(Home home, HomeController3D homeController3D) {
        this(home, null, homeController3D);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, boolean bl) {
        this(home, userPreferences, new Object3DBranchFactory(), bl, null);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, HomeController3D homeController3D) {
        this(home, userPreferences, new Object3DBranchFactory(), false, homeController3D);
    }

    public HomeComponent3D(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, HomeController3D homeController3D) {
        this(home, userPreferences, object3DFactory, false, homeController3D);
    }

    private HomeComponent3D(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, boolean bl, HomeController3D homeController3D) {
        Object object;
        this.home = home;
        this.displayShadowOnFloor = bl;
        this.object3dFactory = object3DFactory;
        if (Boolean.valueOf(System.getProperty("com.eteks.sweethome3d.j3d.useOffScreen3DView", "false")).booleanValue()) {
            object = new GraphicsConfigTemplate3D();
            object.setSceneAntialiasing(2);
            this.component3D = new JCanvas3D((GraphicsConfigTemplate3D)object){

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.drawImage(HomeComponent3D.this.navigationPanelImage, 0, 0, (ImageObserver)((Object)this));
                }
            };
            this.component3D.setSize(1, 1);
        } else {
            this.component3D = Component3DManager.getInstance().getOnscreenCanvas3D(new Component3DManager.RenderingObserver(){

                public void canvas3DSwapped(Canvas3D canvas3D) {
                }

                public void canvas3DPreRendered(Canvas3D canvas3D) {
                }

                public void canvas3DPostRendered(Canvas3D canvas3D) {
                    BufferedImage bufferedImage = HomeComponent3D.this.navigationPanelImage;
                    if (bufferedImage != null) {
                        J3DGraphics2D j3DGraphics2D = canvas3D.getGraphics2D();
                        j3DGraphics2D.drawImage(bufferedImage, null, 0, 0);
                        j3DGraphics2D.flush(true);
                    }
                }
            });
        }
        object = new JPanel(new LayoutManager(){

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                return HomeComponent3D.this.component3D.getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container container) {
                return HomeComponent3D.this.component3D.getMinimumSize();
            }

            public void layoutContainer(Container container) {
                HomeComponent3D.this.component3D.setBounds(0, 0, Math.max(1, container.getWidth()), Math.max(1, container.getHeight()));
                if (HomeComponent3D.this.navigationPanel != null && HomeComponent3D.this.navigationPanel.isVisible()) {
                    Dimension dimension = HomeComponent3D.this.navigationPanel.getPreferredSize();
                    HomeComponent3D.this.navigationPanel.setBounds(0, 0, dimension.width, dimension.height);
                }
            }
        });
        ((Container)object).add(this.component3D);
        this.setLayout(new GridLayout());
        this.add((Component)object);
        if (homeController3D != null) {
            this.addMouseListeners(homeController3D, this.component3D);
            if (userPreferences != null && (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior())) {
                this.navigationPanel = this.createNavigationPanel(home, userPreferences, homeController3D);
                this.setNavigationPanelVisible(userPreferences.isNavigationPanelVisible() && this.isVisible());
                userPreferences.addPropertyChangeListener(UserPreferences.Property.NAVIGATION_PANEL_VISIBLE, new NavigationPanelChangeListener(this, homeController3D));
            }
            this.createActions(homeController3D);
            this.installKeyboardActions();
            this.setFocusable(true);
            SwingTools.installFocusBorder(this);
        }
        this.addAncestorListener(this.component3D, bl);
    }

    private void addAncestorListener(final Component component, final boolean bl) {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (HomeComponent3D.this.offscreenUniverse != null) {
                    throw new IllegalStateException("Can't listen to home changes offscreen and onscreen at the same time");
                }
                HomeComponent3D.this.onscreenUniverse = HomeComponent3D.this.createUniverse(bl, true, false);
                HomeComponent3D.this.onscreenUniverse.getViewer().getView().addCanvas3D(component instanceof Canvas3D ? (Canvas3D)component : ((JCanvas3D)component).getOffscreenCanvas3D());
                component.setFocusable(false);
                HomeComponent3D.this.updateNavigationPanelImage();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (HomeComponent3D.this.onscreenUniverse != null) {
                    HomeComponent3D.this.onscreenUniverse.cleanup();
                    HomeComponent3D.this.removeHomeListeners();
                    HomeComponent3D.this.onscreenUniverse = null;
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.component3D.setVisible(bl);
    }

    private JComponent createNavigationPanel(Home home, UserPreferences userPreferences, HomeController3D homeController3D) {
        JPanel jPanel = new JPanel(new GridBagLayout()){

            public void applyComponentOrientation(ComponentOrientation componentOrientation) {
            }
        };
        String string = userPreferences.getLocalizedString(HomeComponent3D.class, "navigationPanel.icon", new Object[0]);
        final ImageIcon imageIcon = string.length() > 0 ? new ImageIcon(HomeComponent3D.class.getResource(string)) : null;
        jPanel.setBorder(new Border(){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                if (imageIcon != null) {
                    imageIcon.paintIcon(component, graphics, n, n2);
                } else {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.drawOval(n + 3, n2 + 3, n3 - 6, n4 - 6);
                }
            }

            public Insets getBorderInsets(Component component) {
                return new Insets(2, 2, 2, 2);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        });
        jPanel.setOpaque(false);
        jPanel.add((Component)new NavigationButton(0.0f, -0.08726647f, 0.0f, "TURN_LEFT", userPreferences, homeController3D), new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        jPanel.add((Component)new NavigationButton(12.5f, 0.0f, 0.0f, "GO_FORWARD", userPreferences, homeController3D), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
        jPanel.add((Component)new NavigationButton(0.0f, 0.08726647f, 0.0f, "TURN_RIGHT", userPreferences, homeController3D), new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        jPanel.add((Component)new NavigationButton(-12.5f, 0.0f, 0.0f, "GO_BACKWARD", userPreferences, homeController3D), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)new NavigationButton(0.0f, 0.0f, -0.03141593f, "TURN_UP", userPreferences, homeController3D), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        jPanel.add((Component)new NavigationButton(0.0f, 0.0f, 0.03141593f, "TURN_DOWN", userPreferences, homeController3D), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 1, 0), 0, 0));
        return jPanel;
    }

    private void setNavigationPanelVisible(boolean bl) {
        if (this.navigationPanel != null) {
            this.navigationPanel.setVisible(bl);
            if (bl) {
                this.navigationPanelListener = new ComponentAdapter(){

                    public void componentResized(ComponentEvent componentEvent) {
                        HomeComponent3D.this.updateNavigationPanelImage();
                    }

                    public void componentMoved(ComponentEvent componentEvent) {
                        HomeComponent3D.this.updateNavigationPanelImage();
                    }
                };
                this.navigationPanel.addComponentListener(this.navigationPanelListener);
                this.component3D.getParent().add(this.navigationPanel);
            } else {
                this.navigationPanel.removeComponentListener(this.navigationPanelListener);
                if (this.navigationPanel.getParent() != null) {
                    this.navigationPanel.getParent().remove(this.navigationPanel);
                }
            }
            this.revalidate();
            this.updateNavigationPanelImage();
            this.component3D.repaint();
        }
    }

    private void updateNavigationPanelImage() {
        if (this.navigationPanel != null && this.navigationPanel.isVisible()) {
            Rectangle rectangle = this.navigationPanel.getBounds();
            Rectangle rectangle2 = new Rectangle(this.component3D.getX(), this.component3D.getY());
            rectangle2.add(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            if (!rectangle2.isEmpty()) {
                Graphics2D graphics2D;
                BufferedImage bufferedImage = this.navigationPanelImage;
                this.navigationPanelImage = null;
                if (bufferedImage == null || bufferedImage.getWidth() != rectangle2.width || bufferedImage.getHeight() != rectangle2.height) {
                    bufferedImage = new BufferedImage(rectangle2.width, rectangle2.height, 2);
                    graphics2D = (Graphics2D)bufferedImage.getGraphics();
                } else {
                    graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                    graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, rectangle2.width, rectangle2.height));
                    graphics2D.setComposite(composite);
                }
                this.navigationPanel.paintAll(graphics2D);
                graphics2D.dispose();
                this.navigationPanelImage = bufferedImage;
                return;
            }
        }
        this.navigationPanelImage = null;
    }

    private SimpleUniverse createUniverse(boolean bl, boolean bl2, boolean bl3) {
        ViewingPlatform viewingPlatform = new ViewingPlatform();
        TransformGroup transformGroup = viewingPlatform.getViewPlatformTransform();
        CameraInterpolator cameraInterpolator = new CameraInterpolator(transformGroup);
        cameraInterpolator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1.0E7));
        transformGroup.addChild((Node)cameraInterpolator);
        transformGroup.setCapability(12);
        Viewer viewer = new Viewer(new Canvas3D[0]);
        SimpleUniverse simpleUniverse = new SimpleUniverse(viewingPlatform, viewer);
        View view = viewer.getView();
        this.updateView(view, this.home.getCamera(), this.home.getTopCamera() == this.home.getCamera());
        this.updateViewPlatformTransform(transformGroup, this.home.getCamera(), false);
        if (bl2) {
            this.addCameraListeners(view, transformGroup);
        }
        simpleUniverse.addBranchGraph(this.createSceneTree(bl, bl2, bl3));
        return simpleUniverse;
    }

    private void removeHomeListeners() {
        this.home.removePropertyChangeListener(Home.Property.CAMERA, this.homeCameraListener);
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.SKY_COLOR, this.skyColorListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.SKY_TEXTURE, this.skyColorListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.GROUND_COLOR, this.groundColorAndTextureListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.GROUND_TEXTURE, this.groundColorAndTextureListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.LIGHT_COLOR, this.lightColorListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.WALLS_ALPHA, this.wallsAlphaListener);
        homeEnvironment.removePropertyChangeListener(HomeEnvironment.Property.DRAWING_MODE, this.drawingModeListener);
        this.home.getCamera().removePropertyChangeListener(this.cameraChangeListener);
        this.home.removeWallsListener(this.wallListener);
        for (Wall selectable : this.home.getWalls()) {
            selectable.removePropertyChangeListener(this.wallChangeListener);
        }
        this.home.removeFurnitureListener(this.furnitureListener);
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.removePropertyChangeListener(this.furnitureChangeListener);
        }
        this.home.removeRoomsListener(this.roomListener);
        for (Room room : this.home.getRooms()) {
            room.removePropertyChangeListener(this.roomChangeListener);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            double d = Math.min(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
            int n2 = (int)(d / 72.0 * 150.0);
            if (this.printedImage == null || this.printedImage.getWidth() != n2) {
                try {
                    this.printedImage = this.getOffScreenImage(n2, n2);
                }
                catch (IllegalRenderingStateException illegalRenderingStateException) {
                    return 1;
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(pageFormat.getImageableX() + (pageFormat.getImageableWidth() - d) / 2.0, pageFormat.getImageableY() + (pageFormat.getImageableHeight() - d) / 2.0);
            double d2 = d / (double)n2;
            graphics2D.scale(d2, d2);
            graphics2D.drawImage((Image)this.printedImage, 0, 0, this);
            graphics2D.dispose();
            return 0;
        }
        return 1;
    }

    void startOffscreenImagesCreation() {
        if (this.offscreenUniverse == null) {
            if (this.onscreenUniverse != null) {
                throw new IllegalStateException("Can't listen to home changes offscreen and onscreen at the same time");
            }
            this.offscreenUniverse = this.createUniverse(this.displayShadowOnFloor, true, true);
            HashMap<Texture, Texture> hashMap = new HashMap<Texture, Texture>();
            Enumeration enumeration = this.offscreenUniverse.getLocale().getAllBranchGraphs();
            while (enumeration.hasMoreElements()) {
                this.cloneTexture((Node)enumeration.nextElement(), hashMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getOffScreenImage(int n, int n2) {
        List<Selectable> list = this.home.getSelectedItems();
        SimpleUniverse simpleUniverse = null;
        try {
            Object object;
            Object object2;
            View view;
            if (this.offscreenUniverse == null) {
                simpleUniverse = this.createUniverse(this.displayShadowOnFloor, false, true);
                view = simpleUniverse.getViewer().getView();
                object2 = new HashMap();
                object = simpleUniverse.getLocale().getAllBranchGraphs();
                while (object.hasMoreElements()) {
                    this.cloneTexture((Node)object.nextElement(), (Map<Texture, Texture>)object2);
                }
            } else {
                view = this.offscreenUniverse.getViewer().getView();
            }
            object2 = Collections.emptyList();
            this.home.setSelectedItems((List<? extends Selectable>)object2);
            object = Component3DManager.getInstance().getOffScreenImage(view, n, n2);
            return object;
        }
        finally {
            this.home.setSelectedItems(list);
            if (simpleUniverse != null) {
                simpleUniverse.cleanup();
            }
        }
    }

    private void cloneTexture(Node node, Map<Texture, Texture> map) {
        Texture texture;
        Appearance appearance;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.cloneTexture((Node)enumeration.nextElement(), map);
            }
        } else if (node instanceof Link) {
            this.cloneTexture((Node)((Link)node).getSharedGroup(), map);
        } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
            Texture texture2 = map.get(texture);
            if (texture2 == null) {
                texture2 = (Texture)texture.cloneNodeComponent(false);
                map.put(texture, texture2);
            }
            appearance.setTexture(texture2);
        }
    }

    void endOffscreenImagesCreation() {
        if (this.offscreenUniverse != null) {
            this.offscreenUniverse.cleanup();
            this.removeHomeListeners();
            this.offscreenUniverse = null;
        }
    }

    private void addCameraListeners(final View view, final TransformGroup transformGroup) {
        this.cameraChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        HomeComponent3D.this.updateView(view, HomeComponent3D.this.home.getCamera(), HomeComponent3D.this.home.getTopCamera() == HomeComponent3D.this.home.getCamera());
                        HomeComponent3D.this.updateViewPlatformTransform(transformGroup, HomeComponent3D.this.home.getCamera(), true);
                    }
                });
            }
        };
        this.home.getCamera().addPropertyChangeListener(this.cameraChangeListener);
        this.homeCameraListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateView(view, HomeComponent3D.this.home.getCamera(), HomeComponent3D.this.home.getTopCamera() == HomeComponent3D.this.home.getCamera());
                HomeComponent3D.this.updateViewPlatformTransform(transformGroup, HomeComponent3D.this.home.getCamera(), false);
                ((Camera)propertyChangeEvent.getOldValue()).removePropertyChangeListener(HomeComponent3D.this.cameraChangeListener);
                HomeComponent3D.this.home.getCamera().addPropertyChangeListener(HomeComponent3D.this.cameraChangeListener);
            }
        };
        this.home.addPropertyChangeListener(Home.Property.CAMERA, this.homeCameraListener);
    }

    private void updateView(View view, Camera camera, boolean bl) {
        double d;
        float f = camera.getFieldOfView();
        if (f == 0.0f) {
            f = 1.0995574f;
        }
        view.setFieldOfView((double)f);
        if (bl) {
            d = 1.0 + Math.abs((double)camera.getZ() / Math.sin(camera.getPitch())) / 50.0;
        } else {
            d = 2.5;
            if (camera.getZ() > 200.0f) {
                d += (double)((camera.getZ() - 200.0f) / 50.0f);
            }
        }
        view.setFrontClipDistance(d);
        view.setBackClipDistance(d * 3000.0);
        this.clearPrintedImageCache();
    }

    private void clearPrintedImageCache() {
        this.printedImage = null;
    }

    private void updateViewPlatformTransform(TransformGroup transformGroup, Camera camera, boolean bl) {
        if (bl) {
            CameraInterpolator cameraInterpolator = (CameraInterpolator)transformGroup.getChild(transformGroup.numChildren() - 1);
            cameraInterpolator.moveCamera(camera);
        } else {
            Transform3D transform3D = new Transform3D();
            this.updateViewPlatformTransform(transform3D, camera.getX(), camera.getY(), camera.getZ(), camera.getYaw(), camera.getPitch());
            transformGroup.setTransform(transform3D);
        }
        this.clearPrintedImageCache();
    }

    private void updateViewPlatformTransform(Transform3D transform3D, float f, float f2, float f3, float f4, float f5) {
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY((double)(-f4) + Math.PI);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX((double)(-f5));
        transform3D2.mul(transform3D3);
        transform3D.setIdentity();
        transform3D.setTranslation(new Vector3f(f, f3, f2));
        transform3D.mul(transform3D2);
        this.camera = new Camera(f, f2, f3, f4, f5, 0.0f);
    }

    private void addMouseListeners(final HomeController3D homeController3D, final Component component) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private int xLastMouseMove;
            private int yLastMouseMove;
            private Component grabComponent;
            private Component previousMouseEventTarget;

            public void mousePressed(MouseEvent mouseEvent) {
                if (!this.retargetMouseEventToNavigationPanelChildren(mouseEvent)) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.mouseReleased(mouseEvent);
                    } else if (HomeComponent3D.this.isEnabled()) {
                        HomeComponent3D.this.requestFocusInWindow();
                        this.xLastMouseMove = mouseEvent.getX();
                        this.yLastMouseMove = mouseEvent.getY();
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                if (!this.retargetMouseEventToNavigationPanelChildren(mouseEvent) && mouseEvent.isPopupTrigger() && (jPopupMenu = HomeComponent3D.this.getComponentPopupMenu()) != null) {
                    jPopupMenu.show(HomeComponent3D.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.retargetMouseEventToNavigationPanelChildren(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.retargetMouseEventToNavigationPanelChildren(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.retargetMouseEventToNavigationPanelChildren(mouseEvent) && HomeComponent3D.this.isEnabled()) {
                    if (mouseEvent.isAltDown()) {
                        float f = 1.25f * (float)(this.yLastMouseMove - mouseEvent.getY());
                        if (mouseEvent.isShiftDown()) {
                            f *= 5.0f;
                        }
                        homeController3D.moveCamera(f);
                    } else {
                        float f = 0.005f * (float)(mouseEvent.getX() - this.xLastMouseMove);
                        if (mouseEvent.isShiftDown()) {
                            f *= 5.0f;
                        }
                        homeController3D.rotateCameraYaw(f);
                        float f2 = 0.005f * (float)(mouseEvent.getY() - this.yLastMouseMove);
                        homeController3D.rotateCameraPitch(f2);
                    }
                    this.xLastMouseMove = mouseEvent.getX();
                    this.yLastMouseMove = mouseEvent.getY();
                }
            }

            private boolean retargetMouseEventToNavigationPanelChildren(MouseEvent mouseEvent) {
                if (HomeComponent3D.this.navigationPanel != null && HomeComponent3D.this.navigationPanel.isVisible()) {
                    if (this.grabComponent != null && (mouseEvent.getID() == 502 || mouseEvent.getID() == 506)) {
                        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.grabComponent);
                        this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, this.grabComponent, mouseEvent.getID(), point.x, point.y));
                        if (mouseEvent.getID() == 502) {
                            this.grabComponent = null;
                        } else if (this.previousMouseEventTarget == null && this.grabComponent.contains(point)) {
                            this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, this.grabComponent, 504, point.x, point.y));
                            this.previousMouseEventTarget = this.grabComponent;
                        } else if (this.previousMouseEventTarget != null && !this.grabComponent.contains(point)) {
                            this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, this.grabComponent, 505, point.x, point.y));
                            this.previousMouseEventTarget = null;
                        }
                        return true;
                    }
                    Component component2 = this.retargetMouseEvent(HomeComponent3D.this.navigationPanel, mouseEvent);
                    if (component2 != null) {
                        this.previousMouseEventTarget = component2;
                        return true;
                    }
                }
                return false;
            }

            private Component retargetMouseEvent(Component component4, MouseEvent mouseEvent) {
                if (component4.getBounds().contains(mouseEvent.getPoint())) {
                    int n;
                    if (component4 instanceof Container) {
                        Container container = (Container)component4;
                        for (n = container.getComponentCount() - 1; n >= 0; --n) {
                            MouseEvent mouseEvent2;
                            Component component2 = container.getComponent(n);
                            Component component3 = this.retargetMouseEvent(component2, mouseEvent2 = this.deriveEvent(mouseEvent, component4, mouseEvent.getID(), mouseEvent.getX() - component4.getX(), mouseEvent.getY() - component4.getY()));
                            if (component3 == null) continue;
                            return component3;
                        }
                    }
                    int n2 = mouseEvent.getX() - component4.getX();
                    n = mouseEvent.getY() - component4.getY();
                    if (this.dispatchRetargetedEvent(this.deriveEvent(mouseEvent, component4, mouseEvent.getID(), n2, n))) {
                        if (mouseEvent.getID() == 501) {
                            this.grabComponent = component4;
                        }
                        return component4;
                    }
                }
                return null;
            }

            private boolean dispatchRetargetedEvent(MouseEvent mouseEvent) {
                mouseEvent.getComponent().dispatchEvent(mouseEvent);
                if (!RepaintManager.currentManager(mouseEvent.getComponent()).getDirtyRegion((JComponent)mouseEvent.getComponent()).isEmpty()) {
                    HomeComponent3D.this.updateNavigationPanelImage();
                    component.repaint();
                    return true;
                }
                return false;
            }

            private MouseEvent deriveEvent(MouseEvent mouseEvent, Component component2, int n, int n2, int n3) {
                return new MouseEvent(component2, n, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
        };
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (HomeComponent3D.this.isEnabled()) {
                    float f = -2.5f * (float)mouseWheelEvent.getWheelRotation();
                    if (mouseWheelEvent.isShiftDown()) {
                        f *= 5.0f;
                    }
                    homeController3D.moveCamera(f);
                }
            }
        };
        component.addMouseListener(mouseInputAdapter);
        component.addMouseMotionListener(mouseInputAdapter);
        component.addMouseWheelListener(mouseWheelListener);
        this.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                HomeComponent3D.this.requestFocusInWindow();
            }
        });
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), (Object)ActionType.MOVE_CAMERA_FAST_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift W"), (Object)ActionType.MOVE_CAMERA_FAST_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("UP"), (Object)ActionType.MOVE_CAMERA_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("W"), (Object)ActionType.MOVE_CAMERA_FORWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), (Object)ActionType.MOVE_CAMERA_FAST_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift S"), (Object)ActionType.MOVE_CAMERA_FAST_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), (Object)ActionType.MOVE_CAMERA_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("S"), (Object)ActionType.MOVE_CAMERA_BACKWARD);
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift A"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), (Object)ActionType.ROTATE_CAMERA_YAW_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("A"), (Object)ActionType.ROTATE_CAMERA_YAW_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift D"), (Object)ActionType.ROTATE_CAMERA_YAW_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), (Object)ActionType.ROTATE_CAMERA_YAW_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("D"), (Object)ActionType.ROTATE_CAMERA_YAW_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), (Object)ActionType.ROTATE_CAMERA_PITCH_UP);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), (Object)ActionType.ROTATE_CAMERA_PITCH_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("shift HOME"), (Object)ActionType.ELEVATE_CAMERA_FAST_UP);
        inputMap.put(KeyStroke.getKeyStroke("HOME"), (Object)ActionType.ELEVATE_CAMERA_UP);
        inputMap.put(KeyStroke.getKeyStroke("shift END"), (Object)ActionType.ELEVATE_CAMERA_FAST_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("END"), (Object)ActionType.ELEVATE_CAMERA_DOWN);
    }

    private void createActions(final HomeController3D homeController3D) {
        ActionMap actionMap = this.getActionMap();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MoveCameraAction
        extends AbstractAction {
            private final float delta;

            public MoveCameraAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.moveCamera(this.delta);
            }
        }
        actionMap.put((Object)ActionType.MOVE_CAMERA_FORWARD, new MoveCameraAction(6.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_FAST_FORWARD, new MoveCameraAction(32.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_BACKWARD, new MoveCameraAction(-6.5f));
        actionMap.put((Object)ActionType.MOVE_CAMERA_FAST_BACKWARD, new MoveCameraAction(-32.5f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElevateCameraAction
        extends AbstractAction {
            private final float delta;

            public ElevateCameraAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.elevateCamera(this.delta);
            }
        }
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_DOWN, new ElevateCameraAction(-2.5f));
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_FAST_DOWN, new ElevateCameraAction(-10.0f));
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_UP, new ElevateCameraAction(2.5f));
        actionMap.put((Object)ActionType.ELEVATE_CAMERA_FAST_UP, new ElevateCameraAction(10.0f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RotateCameraYawAction
        extends AbstractAction {
            private final float delta;

            public RotateCameraYawAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.rotateCameraYaw(this.delta);
            }
        }
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_LEFT, new RotateCameraYawAction(-0.05235988f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_FAST_LEFT, new RotateCameraYawAction(-0.2617994f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_RIGHT, new RotateCameraYawAction(0.05235988f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_YAW_FAST_RIGHT, new RotateCameraYawAction(0.2617994f));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RotateCameraPitchAction
        extends AbstractAction {
            private final float delta;

            public RotateCameraPitchAction(float f) {
                this.delta = f;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                homeController3D.rotateCameraPitch(this.delta);
            }
        }
        actionMap.put((Object)ActionType.ROTATE_CAMERA_PITCH_UP, new RotateCameraPitchAction(-0.02617994f));
        actionMap.put((Object)ActionType.ROTATE_CAMERA_PITCH_DOWN, new RotateCameraPitchAction(0.02617994f));
    }

    private BranchGroup createSceneTree(boolean bl, boolean bl2, boolean bl3) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild(this.createHomeTree(bl, bl2, bl3));
        branchGroup.addChild(this.createBackgroundNode(bl2, bl3));
        branchGroup.addChild(this.createGroundNode(-50000.0f, -50000.0f, 100000.0f, 100000.0f, bl2, bl3));
        for (Light light : this.createLights(bl2)) {
            branchGroup.addChild((Node)light);
        }
        return branchGroup;
    }

    private Node createBackgroundNode(boolean bl, final boolean bl2) {
        final Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        appearance.setColoringAttributes(coloringAttributes);
        appearance.setCapability(3);
        appearance.setCapability(8);
        coloringAttributes.setCapability(1);
        Geometry geometry = this.createHalfSphereGeometry();
        Shape3D shape3D = new Shape3D(geometry, appearance);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)shape3D);
        Background background = new Background(branchGroup);
        this.updateBackgroundColorAndTexture(appearance, this.home, bl2);
        background.setImageScaleMode(3);
        background.setApplicationBounds((Bounds)new BoundingBox(new Point3d(-1000000.0, -1000000.0, -1000000.0), new Point3d(1000000.0, 1000000.0, 1000000.0)));
        if (bl) {
            this.skyColorListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeComponent3D.this.updateBackgroundColorAndTexture(appearance, HomeComponent3D.this.home, bl2);
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.SKY_COLOR, this.skyColorListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.SKY_TEXTURE, this.skyColorListener);
        }
        return background;
    }

    private Geometry createHalfSphereGeometry() {
        Point3f[] point3fArray = new Point3f[2304];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[2304];
        int n = 0;
        for (int i = 0; i < 48; ++i) {
            double d = (double)(i * 2) * Math.PI / 48.0;
            float f = (float)Math.cos(d);
            float f2 = (float)Math.sin(d);
            double d2 = (double)((i + 1) * 2) * Math.PI / 48.0;
            float f3 = (float)Math.cos(d2);
            float f4 = (float)Math.sin(d2);
            for (int j = 0; j < 12; ++j) {
                double d3 = (double)(2 * j) * Math.PI / 48.0;
                float f5 = (float)Math.cos(d3);
                float f6 = (float)Math.sin(d3);
                float f7 = j != 0 ? f6 : -0.05f;
                double d4 = (double)(2 * (j + 1)) * Math.PI / 48.0;
                float f8 = (float)Math.cos(d4);
                float f9 = (float)Math.sin(d4);
                point3fArray[n] = new Point3f(f * f5, f7, f2 * f5);
                texCoord2fArray[n++] = new TexCoord2f((float)i / 48.0f, f6);
                point3fArray[n] = new Point3f(f3 * f5, f7, f4 * f5);
                texCoord2fArray[n++] = new TexCoord2f((float)(i + 1) / 48.0f, f6);
                point3fArray[n] = new Point3f(f3 * f8, f9, f4 * f8);
                texCoord2fArray[n++] = new TexCoord2f((float)(i + 1) / 48.0f, f9);
                point3fArray[n] = new Point3f(f * f8, f9, f2 * f8);
                texCoord2fArray[n++] = new TexCoord2f((float)i / 48.0f, f9);
            }
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setTextureCoordinateParams(1, 2);
        geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        geometryInfo.indexify();
        geometryInfo.compact();
        IndexedGeometryArray indexedGeometryArray = geometryInfo.getIndexedGeometryArray();
        return indexedGeometryArray;
    }

    private void updateBackgroundColorAndTexture(final Appearance appearance, Home home, boolean bl) {
        Color3f color3f = new Color3f(new Color(home.getEnvironment().getSkyColor()));
        appearance.getColoringAttributes().setColor(color3f);
        HomeTexture homeTexture = home.getEnvironment().getSkyTexture();
        if (homeTexture != null) {
            TextureManager textureManager = TextureManager.getInstance();
            if (bl) {
                appearance.setTexture(textureManager.loadTexture(homeTexture.getImage()));
            } else {
                textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                    public void textureUpdated(Texture texture) {
                        appearance.setTexture(texture);
                    }
                });
            }
        } else {
            appearance.setTexture(null);
        }
        this.clearPrintedImageCache();
    }

    private Node createGroundNode(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        final Ground3D ground3D = new Ground3D(this.home, f, f2, f3, f4, bl2);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, -0.2f, 0.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)ground3D);
        if (bl) {
            this.groundColorAndTextureListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ground3D.update();
                    HomeComponent3D.this.clearPrintedImageCache();
                }
            };
            HomeEnvironment homeEnvironment = this.home.getEnvironment();
            homeEnvironment.addPropertyChangeListener(HomeEnvironment.Property.GROUND_COLOR, this.groundColorAndTextureListener);
            homeEnvironment.addPropertyChangeListener(HomeEnvironment.Property.GROUND_TEXTURE, this.groundColorAndTextureListener);
        }
        return transformGroup;
    }

    private Light[] createLights(boolean bl) {
        final Light[] lightArray = new Light[]{new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, -0.8f, 1.0f)), new DirectionalLight(new Color3f(0.7f, 0.7f, 0.7f), new Vector3f(0.0f, 1.0f, 0.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))};
        for (int i = 0; i < lightArray.length - 1; ++i) {
            lightArray[i].setCapability(15);
            Color3f color3f = new Color3f();
            lightArray[i].getColor(color3f);
            lightArray[i].setUserData((Object)color3f);
            this.updateLightColor(lightArray[i]);
        }
        for (Light light : lightArray) {
            light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(), 1.0E7));
        }
        if (bl) {
            this.lightColorListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    for (int i = 0; i < lightArray.length - 1; ++i) {
                        HomeComponent3D.this.updateLightColor(lightArray[i]);
                    }
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.LIGHT_COLOR, this.lightColorListener);
        }
        return lightArray;
    }

    private void updateLightColor(Light light) {
        Color3f color3f = (Color3f)light.getUserData();
        int n = this.home.getEnvironment().getLightColor();
        light.setColor(new Color3f((float)(n >>> 16 & 0xFF) / 255.0f * color3f.x, (float)(n >>> 8 & 0xFF) / 255.0f * color3f.y, (float)(n & 0xFF) / 255.0f * color3f.z));
        this.clearPrintedImageCache();
    }

    private Node createHomeTree(boolean bl, boolean bl2, boolean bl3) {
        Group group = this.createHomeRoot();
        for (Room object : this.home.getRooms()) {
            this.addObject(group, object, bl2, bl3);
        }
        for (Wall wall : this.home.getWalls()) {
            this.addObject(group, wall, bl2, bl3);
        }
        HashMap hashMap = new HashMap();
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            hashMap.put(homePieceOfFurniture, this.addObject(group, homePieceOfFurniture, bl2, bl3));
        }
        if (bl) {
            this.addShadowOnFloor(group, hashMap);
        }
        if (bl2) {
            this.addWallListener(group);
            this.addFurnitureListener(group);
            this.addRoomListener(group);
            this.addEnvironmentListeners();
        }
        return group;
    }

    private Group createHomeRoot() {
        Group group = new Group();
        group.setCapability(13);
        group.setCapability(14);
        return group;
    }

    private void addWallListener(final Group group) {
        this.wallChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateWall((Wall)propertyChangeEvent.getSource());
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
            }
        };
        for (Wall wall : this.home.getWalls()) {
            wall.addPropertyChangeListener(this.wallChangeListener);
        }
        this.wallListener = new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                Wall wall = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeComponent3D.this.addObject(group, wall, true, false);
                        wall.addPropertyChangeListener(HomeComponent3D.this.wallChangeListener);
                        break;
                    }
                    case DELETE: {
                        HomeComponent3D.this.deleteObject(wall);
                        wall.removePropertyChangeListener(HomeComponent3D.this.wallChangeListener);
                    }
                }
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
            }
        };
        this.home.addWallsListener(this.wallListener);
    }

    private void addFurnitureListener(final Group group) {
        this.furnitureChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HomePieceOfFurniture.Property.X.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.X.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.Y.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.ANGLE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.WIDTH.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.DEPTH.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.HEIGHT.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.COLOR.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.TEXTURE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.SHININESS.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.MODEL_MIRRORED.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.VISIBLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                    HomeComponent3D.this.updateObjects(Arrays.asList(homePieceOfFurniture));
                    if (HomeComponent3D.this.containsDoorsAndWindows(homePieceOfFurniture)) {
                        HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                    }
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(this.furnitureChangeListener);
        }
        this.furnitureListener = new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeComponent3D.this.addObject(group, homePieceOfFurniture, true, false);
                        homePieceOfFurniture.addPropertyChangeListener(HomeComponent3D.this.furnitureChangeListener);
                        break;
                    }
                    case DELETE: {
                        HomeComponent3D.this.deleteObject(homePieceOfFurniture);
                        homePieceOfFurniture.removePropertyChangeListener(HomeComponent3D.this.furnitureChangeListener);
                    }
                }
                if (HomeComponent3D.this.containsDoorsAndWindows(homePieceOfFurniture)) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                }
            }
        };
        this.home.addFurnitureListener(this.furnitureListener);
    }

    private boolean containsDoorsAndWindows(HomePieceOfFurniture homePieceOfFurniture) {
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                if (!this.containsDoorsAndWindows(homePieceOfFurniture2)) continue;
                return true;
            }
            return false;
        }
        return homePieceOfFurniture.isDoorOrWindow();
    }

    private void addRoomListener(final Group group) {
        this.roomChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Room.Property.FLOOR_COLOR.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.FLOOR_TEXTURE.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.FLOOR_SHININESS.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.CEILING_COLOR.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.CEILING_TEXTURE.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.CEILING_SHININESS.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomeComponent3D.this.updateObjects(Arrays.asList((Room)propertyChangeEvent.getSource()));
                } else if (Room.Property.FLOOR_VISIBLE.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.CEILING_VISIBLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                    HomeComponent3D.this.groundColorAndTextureListener.propertyChange(null);
                } else if (Room.Property.POINTS.name().equals(propertyChangeEvent.getPropertyName())) {
                    if (HomeComponent3D.this.homeObjectsToUpdate != null) {
                        HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                    } else {
                        HomeComponent3D.this.updateObjects(Arrays.asList((Room)propertyChangeEvent.getSource()));
                        Area area = this.getArea((float[][])propertyChangeEvent.getOldValue());
                        Area area2 = this.getArea((float[][])propertyChangeEvent.getNewValue());
                        for (Room room : HomeComponent3D.this.home.getRooms()) {
                            if (room == propertyChangeEvent.getSource()) continue;
                            Area area3 = this.getArea(room.getPoints());
                            Area area4 = new Area(area3);
                            area4.intersect(area2);
                            if (!area4.isEmpty()) {
                                HomeComponent3D.this.updateObjects(Arrays.asList(room));
                                continue;
                            }
                            area3.intersect(area);
                            if (area3.isEmpty()) continue;
                            HomeComponent3D.this.updateObjects(Arrays.asList(room));
                        }
                    }
                    HomeComponent3D.this.groundColorAndTextureListener.propertyChange(null);
                }
            }

            private Area getArea(float[][] fArray) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(fArray[0][0], fArray[0][1]);
                for (int i = 1; i < fArray.length; ++i) {
                    generalPath.lineTo(fArray[i][0], fArray[i][1]);
                }
                generalPath.closePath();
                return new Area(generalPath);
            }
        };
        for (Room room : this.home.getRooms()) {
            room.addPropertyChangeListener(this.roomChangeListener);
        }
        this.roomListener = new CollectionListener<Room>(){

            @Override
            public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                Room room = collectionEvent.getItem();
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeComponent3D.this.addObject(group, room, collectionEvent.getIndex(), true, false);
                        room.addPropertyChangeListener(HomeComponent3D.this.roomChangeListener);
                        break;
                    }
                    case DELETE: {
                        HomeComponent3D.this.deleteObject(room);
                        room.removePropertyChangeListener(HomeComponent3D.this.roomChangeListener);
                    }
                }
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getRooms());
                HomeComponent3D.this.groundColorAndTextureListener.propertyChange(null);
            }
        };
        this.home.addRoomsListener(this.roomListener);
    }

    private void addEnvironmentListeners() {
        this.wallsAlphaListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
            }
        };
        this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.WALLS_ALPHA, this.wallsAlphaListener);
        this.drawingModeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getWalls());
                HomeComponent3D.this.updateObjects(HomeComponent3D.this.home.getFurniture());
            }
        };
        this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.DRAWING_MODE, this.drawingModeListener);
    }

    private Node addObject(Group group, Selectable selectable, boolean bl, boolean bl2) {
        return this.addObject(group, selectable, -1, bl, bl2);
    }

    private Node addObject(Group group, Selectable selectable, int n, boolean bl, boolean bl2) {
        Object3DBranch object3DBranch = this.createObject3D(selectable, bl2);
        if (bl) {
            this.homeObjects.put(selectable, object3DBranch);
        }
        if (n == -1) {
            group.addChild((Node)object3DBranch);
        } else {
            group.insertChild((Node)object3DBranch, n);
        }
        this.clearPrintedImageCache();
        return object3DBranch;
    }

    private Object3DBranch createObject3D(Selectable selectable, boolean bl) {
        return (Object3DBranch)((Object)this.object3dFactory.createObject3D(this.home, selectable, bl));
    }

    private void deleteObject(Selectable selectable) {
        this.homeObjects.get(selectable).detach();
        this.homeObjects.remove(selectable);
        this.clearPrintedImageCache();
    }

    private void updateObjects(Collection<? extends Selectable> collection) {
        if (this.homeObjectsToUpdate != null) {
            this.homeObjectsToUpdate.addAll(collection);
        } else {
            this.homeObjectsToUpdate = new HashSet<Selectable>(collection);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    for (Selectable selectable : HomeComponent3D.this.homeObjectsToUpdate) {
                        Object3DBranch object3DBranch = (Object3DBranch)((Object)HomeComponent3D.this.homeObjects.get(selectable));
                        if (object3DBranch == null) continue;
                        ((Object3DBranch)((Object)HomeComponent3D.this.homeObjects.get(selectable))).update();
                    }
                    HomeComponent3D.this.homeObjectsToUpdate = null;
                }
            });
        }
        this.clearPrintedImageCache();
    }

    private void updateWall(Wall wall) {
        ArrayList<Wall> arrayList = new ArrayList<Wall>(3);
        arrayList.add(wall);
        if (wall.getWallAtStart() != null) {
            arrayList.add(wall.getWallAtStart());
        }
        if (wall.getWallAtEnd() != null) {
            arrayList.add(wall.getWallAtEnd());
        }
        this.updateObjects(arrayList);
    }

    private void addShadowOnFloor(Group group, Map<HomePieceOfFurniture, Node> map) {
        Object object;
        Map.Entry<HomePieceOfFurniture, Node> entry2;
        Area area = new Area();
        for (Map.Entry<HomePieceOfFurniture, Node> entry2 : map.entrySet()) {
            if (!(entry2.getKey() instanceof HomePieceOfFurniture)) continue;
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)entry2.getKey();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (homePieceOfFurniture.getElevation() != 0.0f || homePieceOfFurniture.isDoorOrWindow() || homePieceOfFurniture instanceof com.eteks.sweethome3d.model.Light) continue;
            object = ModelManager.getInstance().getAreaOnFloor((Node)entry2.getValue());
            area.add((Area)object);
        }
        ArrayList arrayList = new ArrayList();
        entry2 = new ArrayList();
        int n = 0;
        object = new float[2];
        PathIterator pathIterator = area.getPathIterator(null);
        while (!pathIterator.isDone()) {
            if (pathIterator.currentSegment((float[])object) == 4) {
                entry2.add(n);
                n = 0;
            } else {
                arrayList.add(new Point3f(object[0], 0.49f, object[1]));
                ++n;
            }
            pathIterator.next();
        }
        if (arrayList.size() > 0) {
            pathIterator = new GeometryInfo(5);
            pathIterator.setCoordinates(arrayList.toArray(new Point3f[arrayList.size()]));
            int[] nArray = new int[entry2.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)entry2.get(i);
            }
            pathIterator.setStripCounts(nArray);
            Shape3D shape3D = new Shape3D((Geometry)pathIterator.getIndexedGeometryArray());
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(new Color3f(), 2));
            appearance.setTransparencyAttributes(new TransparencyAttributes(1, 0.7f));
            shape3D.setAppearance(appearance);
            group.addChild((Node)shape3D);
        }
    }

    private class CameraInterpolator
    extends TransformInterpolator {
        private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        private Camera initialCamera;
        private Camera finalCamera;

        public CameraInterpolator(TransformGroup transformGroup) {
            this.setTarget(transformGroup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveCamera(Camera camera) {
            if (this.finalCamera == null || this.finalCamera.getX() != camera.getX() || this.finalCamera.getY() != camera.getY() || this.finalCamera.getZ() != camera.getZ() || this.finalCamera.getYaw() != camera.getYaw() || this.finalCamera.getPitch() != camera.getPitch()) {
                CameraInterpolator cameraInterpolator = this;
                synchronized (cameraInterpolator) {
                    Alpha alpha = this.getAlpha();
                    if (alpha == null || alpha.finished()) {
                        this.initialCamera = new Camera(HomeComponent3D.this.camera.getX(), HomeComponent3D.this.camera.getY(), HomeComponent3D.this.camera.getZ(), HomeComponent3D.this.camera.getYaw(), HomeComponent3D.this.camera.getPitch(), HomeComponent3D.this.camera.getFieldOfView());
                    } else if ((double)alpha.value() < 0.3) {
                        Transform3D transform3D = new Transform3D();
                        HomeComponent3D.this.updateViewPlatformTransform(transform3D, this.finalCamera.getX(), this.finalCamera.getY(), this.finalCamera.getZ(), this.finalCamera.getYaw(), this.finalCamera.getPitch());
                        this.getTarget().setTransform(transform3D);
                        this.initialCamera = this.finalCamera;
                    } else {
                        this.initialCamera = new Camera(this.initialCamera.getX() + (this.finalCamera.getX() - this.initialCamera.getX()) * alpha.value(), this.initialCamera.getY() + (this.finalCamera.getY() - this.initialCamera.getY()) * alpha.value(), this.initialCamera.getZ() + (this.finalCamera.getZ() - this.initialCamera.getZ()) * alpha.value(), this.initialCamera.getYaw() + (this.finalCamera.getYaw() - this.initialCamera.getYaw()) * alpha.value(), this.initialCamera.getPitch() + (this.finalCamera.getPitch() - this.initialCamera.getPitch()) * alpha.value(), camera.getFieldOfView());
                    }
                    this.finalCamera = new Camera(camera.getX(), camera.getY(), camera.getZ(), camera.getYaw(), camera.getPitch(), camera.getFieldOfView());
                    if (alpha == null) {
                        alpha = new Alpha(1, 150L);
                        this.setAlpha(alpha);
                    }
                    alpha.setStartTime(System.currentTimeMillis());
                    this.scheduledExecutor.schedule(new Runnable(){

                        public void run() {
                            if (CameraInterpolator.this.getAlpha().value() == 1.0f) {
                                Transform3D transform3D = new Transform3D();
                                CameraInterpolator.this.computeTransform(1.0f, transform3D);
                                CameraInterpolator.this.getTarget().setTransform(transform3D);
                            }
                        }
                    }, 150L, TimeUnit.MILLISECONDS);
                }
            }
        }

        public synchronized void computeTransform(float f, Transform3D transform3D) {
            HomeComponent3D.this.updateViewPlatformTransform(transform3D, this.initialCamera.getX() + (this.finalCamera.getX() - this.initialCamera.getX()) * f, this.initialCamera.getY() + (this.finalCamera.getY() - this.initialCamera.getY()) * f, this.initialCamera.getZ() + (this.finalCamera.getZ() - this.initialCamera.getZ()) * f, this.initialCamera.getYaw() + (this.finalCamera.getYaw() - this.initialCamera.getYaw()) * f, this.initialCamera.getPitch() + (this.finalCamera.getPitch() - this.initialCamera.getPitch()) * f);
        }
    }

    private static class NavigationButton
    extends JButton {
        private boolean shiftDown;

        public NavigationButton(final float f, final float f2, final float f3, String string, UserPreferences userPreferences, final HomeController3D homeController3D) {
            super(new ResourceAction(userPreferences, (Class)HomeComponent3D.class, string, true){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.setPressedIcon(new ImageIcon(this.createImage(new FilteredImageSource(((ImageIcon)this.getIcon()).getImage().getSource(), new RGBImageFilter(){
                {
                    this.canFilterIndexColorModel = true;
                }

                public int filterRGB(int n, int n2, int n3) {
                    int n4 = n3 & 0xFF000000;
                    int n5 = (n3 & 0xFF0000) >> 1 & 0xFF0000;
                    int n6 = (n3 & 0xFF00) >> 1 & 0xFF00;
                    int n7 = (n3 & 0xFF) >> 1;
                    return n4 | n5 | n6 | n7;
                }
            }))));
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    NavigationButton.this.shiftDown = mouseEvent.isShiftDown();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    NavigationButton.this.shiftDown = mouseEvent.isShiftDown();
                    SwingUtilities.getAncestorOfClass(HomeComponent3D.class, NavigationButton.this).requestFocusInWindow();
                }
            });
            final Timer timer = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    homeController3D.moveCamera(NavigationButton.this.shiftDown ? f : f / 5.0f);
                    homeController3D.rotateCameraYaw(NavigationButton.this.shiftDown ? f2 : f2 / 5.0f);
                    homeController3D.rotateCameraPitch(f3);
                }
            });
            timer.setInitialDelay(0);
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (NavigationButton.this.getModel().isArmed() && !timer.isRunning()) {
                        timer.restart();
                    } else if (!NavigationButton.this.getModel().isArmed() && timer.isRunning()) {
                        timer.stop();
                    }
                }
            });
            this.setFocusable(false);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            this.addPropertyChangeListener("icon", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    NavigationButton.this.setBorder(null);
                }
            });
        }
    }

    private static class NavigationPanelChangeListener
    implements PropertyChangeListener {
        private final WeakReference<HomeComponent3D> homeComponent3D;

        public NavigationPanelChangeListener(HomeComponent3D homeComponent3D, HomeController3D homeController3D) {
            this.homeComponent3D = new WeakReference<HomeComponent3D>(homeComponent3D);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeComponent3D homeComponent3D = (HomeComponent3D)this.homeComponent3D.get();
            if (homeComponent3D == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.NAVIGATION_PANEL_VISIBLE, this);
            } else {
                homeComponent3D.setNavigationPanelVisible((Boolean)propertyChangeEvent.getNewValue() != false && homeComponent3D.isVisible());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        MOVE_CAMERA_FORWARD,
        MOVE_CAMERA_FAST_FORWARD,
        MOVE_CAMERA_BACKWARD,
        MOVE_CAMERA_FAST_BACKWARD,
        ROTATE_CAMERA_YAW_LEFT,
        ROTATE_CAMERA_YAW_FAST_LEFT,
        ROTATE_CAMERA_YAW_RIGHT,
        ROTATE_CAMERA_YAW_FAST_RIGHT,
        ROTATE_CAMERA_PITCH_UP,
        ROTATE_CAMERA_PITCH_DOWN,
        ELEVATE_CAMERA_UP,
        ELEVATE_CAMERA_FAST_UP,
        ELEVATE_CAMERA_DOWN,
        ELEVATE_CAMERA_FAST_DOWN;

    }
}

