/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.HomePieceOfFurniture3D;
import com.eteks.sweethome3d.j3d.OBJWriter;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.Room3D;
import com.eteks.sweethome3d.j3d.Wall3D;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.plugin.Plugin;
import com.eteks.sweethome3d.plugin.PluginAction;
import com.eteks.sweethome3d.swing.ControllerAction;
import com.eteks.sweethome3d.swing.FurnitureCatalogTransferHandler;
import com.eteks.sweethome3d.swing.FurnitureTransferHandler;
import com.eteks.sweethome3d.swing.HomePDFPrinter;
import com.eteks.sweethome3d.swing.HomePrintableComponent;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.swing.PlanComponent;
import com.eteks.sweethome3d.swing.PlanTransferHandler;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.swing.UnfocusableToolBar;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.media.j3d.Node;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePane
extends JRootPane
implements HomeView {
    private static final String MAIN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.MainPaneDividerLocation";
    private static final String CATALOG_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.CatalogPaneDividerLocation";
    private static final String PLAN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanPaneDividerLocation";
    private static final String PLAN_VIEWPORT_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanViewportX";
    private static final String PLAN_VIEWPORT_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanViewportY";
    private static final String FURNITURE_VIEWPORT_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FurnitureViewportY";
    private static final String DETACHED_VIEW_VISUAL_PROPERTY = ".detachedView";
    private static final String DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY = ".detachedViewDividerLocation";
    private static final String DETACHED_VIEW_X_VISUAL_PROPERTY = ".detachedViewX";
    private static final String DETACHED_VIEW_Y_VISUAL_PROPERTY = ".detachedViewY";
    private static final String DETACHED_VIEW_WIDTH_VISUAL_PROPERTY = ".detachedViewWidth";
    private static final String DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY = ".detachedViewHeight";
    private static final int DEFAULT_SMALL_ICON_HEIGHT = 16;
    private final Home home;
    private final UserPreferences preferences;
    private final HomeController controller;
    private final JToggleButton.ToggleButtonModel selectToggleModel;
    private final JToggleButton.ToggleButtonModel panToggleModel;
    private final JToggleButton.ToggleButtonModel createWallsToggleModel;
    private final JToggleButton.ToggleButtonModel createRoomsToggleModel;
    private final JToggleButton.ToggleButtonModel createDimensionLinesToggleModel;
    private final JToggleButton.ToggleButtonModel createLabelsToggleModel;
    private final JToggleButton.ToggleButtonModel boldStyleToggleModel;
    private final JToggleButton.ToggleButtonModel italicStyleToggleModel;
    private final JToggleButton.ToggleButtonModel viewFromTopToggleModel;
    private final JToggleButton.ToggleButtonModel viewFromObserverToggleModel;
    private JComponent lastFocusedComponent;
    private PlanController.Mode previousPlanControllerMode;
    private TransferHandler catalogTransferHandler;
    private TransferHandler furnitureTransferHandler;
    private TransferHandler planTransferHandler;
    private ActionMap menuActionMap;
    private List<Action> pluginActions;
    private KeyListener specialKeysListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            PlanController planController = HomePane.this.controller.getPlanController();
            if (keyEvent.getKeyCode() == 32 && (keyEvent.getModifiers() & 0xE) == 0 && HomePane.this.getActionMap().get((Object)HomeView.ActionType.PAN).getValue("Name") != null && planController.getMode() != PlanController.Mode.PANNING && !planController.isModificationState() && SwingUtilities.isDescendingFrom(HomePane.this.lastFocusedComponent, HomePane.this) && !this.isSpaceUsedByComponent(HomePane.this.lastFocusedComponent)) {
                HomePane.this.previousPlanControllerMode = planController.getMode();
                planController.setMode(PlanController.Mode.PANNING);
                keyEvent.consume();
            }
        }

        private boolean isSpaceUsedByComponent(JComponent jComponent) {
            return jComponent instanceof JTextComponent || jComponent instanceof JComboBox;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 && HomePane.this.previousPlanControllerMode != null) {
                HomePane.this.controller.getPlanController().setMode(HomePane.this.previousPlanControllerMode);
                HomePane.this.previousPlanControllerMode = null;
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            ActionMap actionMap = HomePane.this.getActionMap();
            Action[] actionArray = new Action[]{actionMap.get((Object)HomeView.ActionType.ZOOM_IN), actionMap.get((Object)HomeView.ActionType.ZOOM_OUT), actionMap.get((Object)HomeView.ActionType.INCREASE_TEXT_SIZE), actionMap.get((Object)HomeView.ActionType.DECREASE_TEXT_SIZE), actionMap.get((Object)HomeView.ActionType.HELP)};
            int n = 14;
            for (Action action : actionArray) {
                KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                if (keyEvent.getKeyChar() != keyStroke.getKeyChar() || (keyEvent.getModifiers() & n) != (keyStroke.getModifiers() & n) || !action.isEnabled()) continue;
                action.actionPerformed(new ActionEvent(HomePane.this, 1001, (String)action.getValue("ActionCommandKey")));
                keyEvent.consume();
            }
        }
    };

    public HomePane(Home home, UserPreferences userPreferences, HomeController homeController) {
        this.home = home;
        this.preferences = userPreferences;
        this.controller = homeController;
        this.selectToggleModel = new JToggleButton.ToggleButtonModel();
        this.selectToggleModel.setSelected(homeController.getPlanController().getMode() == PlanController.Mode.SELECTION);
        this.panToggleModel = new JToggleButton.ToggleButtonModel();
        this.panToggleModel.setSelected(homeController.getPlanController().getMode() == PlanController.Mode.PANNING);
        this.createWallsToggleModel = new JToggleButton.ToggleButtonModel();
        this.createWallsToggleModel.setSelected(homeController.getPlanController().getMode() == PlanController.Mode.WALL_CREATION);
        this.createRoomsToggleModel = new JToggleButton.ToggleButtonModel();
        this.createRoomsToggleModel.setSelected(homeController.getPlanController().getMode() == PlanController.Mode.ROOM_CREATION);
        this.createDimensionLinesToggleModel = new JToggleButton.ToggleButtonModel();
        this.createDimensionLinesToggleModel.setSelected(homeController.getPlanController().getMode() == PlanController.Mode.DIMENSION_LINE_CREATION);
        this.createLabelsToggleModel = new JToggleButton.ToggleButtonModel();
        this.createLabelsToggleModel.setSelected(homeController.getPlanController().getMode() == PlanController.Mode.LABEL_CREATION);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.selectToggleModel.setGroup(buttonGroup);
        this.panToggleModel.setGroup(buttonGroup);
        this.createWallsToggleModel.setGroup(buttonGroup);
        this.createRoomsToggleModel.setGroup(buttonGroup);
        this.createDimensionLinesToggleModel.setGroup(buttonGroup);
        this.createLabelsToggleModel.setGroup(buttonGroup);
        this.boldStyleToggleModel = this.createBoldStyleToggleModel(home, userPreferences);
        this.italicStyleToggleModel = this.createItalicStyleToggleModel(home, userPreferences);
        this.viewFromTopToggleModel = new JToggleButton.ToggleButtonModel();
        this.viewFromTopToggleModel.setSelected(home.getCamera() == home.getTopCamera());
        this.viewFromObserverToggleModel = new JToggleButton.ToggleButtonModel();
        this.viewFromObserverToggleModel.setSelected(home.getCamera() == home.getObserverCamera());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.viewFromTopToggleModel.setGroup(buttonGroup2);
        this.viewFromObserverToggleModel.setGroup(buttonGroup2);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.createActions(userPreferences, homeController);
        this.createMenuActions(userPreferences, homeController);
        this.createPluginActions(homeController.getPlugins());
        this.createTransferHandlers(home, homeController);
        this.addHomeListener(home);
        this.addLanguageListener(userPreferences);
        this.addPlanControllerListener(homeController.getPlanController());
        this.addFocusListener();
        this.updateFocusTraversalPolicy();
        JMenuBar jMenuBar = this.createMenuBar(home, userPreferences, homeController);
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        container.add((Component)this.createToolBar(home), "North");
        container.add(this.createMainPane(home, userPreferences, homeController));
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            container.add((Component)new JLabel(), "West");
            container.add((Component)new JLabel(), "East");
        }
        this.disableMenuItemsDuringDragAndDrop(homeController.getPlanController().getView(), jMenuBar);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void createActions(UserPreferences userPreferences, final HomeController homeController) {
        this.createAction(HomeView.ActionType.NEW_HOME, userPreferences, homeController, "newHome", new Object[0]);
        this.createAction(HomeView.ActionType.OPEN, userPreferences, homeController, "open", new Object[0]);
        this.createAction(HomeView.ActionType.DELETE_RECENT_HOMES, userPreferences, homeController, "deleteRecentHomes", new Object[0]);
        this.createAction(HomeView.ActionType.CLOSE, userPreferences, homeController, "close", new Object[0]);
        this.createAction(HomeView.ActionType.SAVE, userPreferences, homeController, "save", new Object[0]);
        this.createAction(HomeView.ActionType.SAVE_AS, userPreferences, homeController, "saveAs", new Object[0]);
        this.createAction(HomeView.ActionType.SAVE_AND_COMPRESS, userPreferences, homeController, "saveAndCompress", new Object[0]);
        this.createAction(HomeView.ActionType.PAGE_SETUP, userPreferences, homeController, "setupPage", new Object[0]);
        this.createAction(HomeView.ActionType.PRINT_PREVIEW, userPreferences, homeController, "previewPrint", new Object[0]);
        this.createAction(HomeView.ActionType.PRINT, userPreferences, homeController, "print", new Object[0]);
        this.createAction(HomeView.ActionType.PRINT_TO_PDF, userPreferences, homeController, "printToPDF", new Object[0]);
        this.createAction(HomeView.ActionType.PREFERENCES, userPreferences, homeController, "editPreferences", new Object[0]);
        this.createAction(HomeView.ActionType.EXIT, userPreferences, homeController, "exit", new Object[0]);
        this.createAction(HomeView.ActionType.UNDO, userPreferences, homeController, "undo", new Object[0]);
        this.createAction(HomeView.ActionType.REDO, userPreferences, homeController, "redo", new Object[0]);
        this.createClipboardAction(HomeView.ActionType.CUT, userPreferences, TransferHandler.getCutAction());
        this.createClipboardAction(HomeView.ActionType.COPY, userPreferences, TransferHandler.getCopyAction());
        this.createClipboardAction(HomeView.ActionType.PASTE, userPreferences, TransferHandler.getPasteAction());
        this.createAction(HomeView.ActionType.DELETE, userPreferences, homeController, "delete", new Object[0]);
        this.createAction(HomeView.ActionType.SELECT_ALL, userPreferences, homeController, "selectAll", new Object[0]);
        this.createAction(HomeView.ActionType.ADD_HOME_FURNITURE, userPreferences, homeController, "addHomeFurniture", new Object[0]);
        FurnitureController furnitureController = homeController.getFurnitureController();
        this.createAction(HomeView.ActionType.DELETE_HOME_FURNITURE, userPreferences, furnitureController, "deleteSelection", new Object[0]);
        this.createAction(HomeView.ActionType.MODIFY_FURNITURE, userPreferences, homeController, "modifySelectedFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.GROUP_FURNITURE, userPreferences, furnitureController, "groupSelectedFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.UNGROUP_FURNITURE, userPreferences, furnitureController, "ungroupSelectedFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, userPreferences, furnitureController, "alignSelectedFurnitureOnTop", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, userPreferences, furnitureController, "alignSelectedFurnitureOnBottom", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, userPreferences, furnitureController, "alignSelectedFurnitureOnLeft", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, userPreferences, furnitureController, "alignSelectedFurnitureOnRight", new Object[0]);
        if (homeController.getHomeController3D().getView() != null) {
            this.createAction(HomeView.ActionType.IMPORT_FURNITURE, userPreferences, homeController, "importFurniture", new Object[0]);
        }
        this.createAction(HomeView.ActionType.IMPORT_FURNITURE_LIBRARY, userPreferences, homeController, "importFurnitureLibrary", new Object[0]);
        this.createAction(HomeView.ActionType.IMPORT_TEXTURES_LIBRARY, userPreferences, homeController, "importTexturesLibrary", new Object[0]);
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.CATALOG_ID});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_NAME, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.NAME});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_WIDTH, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.WIDTH});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DEPTH, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.DEPTH});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_HEIGHT, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.HEIGHT});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_X, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.X});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_Y, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.Y});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ELEVATION, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.ELEVATION});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ANGLE, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.ANGLE});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_COLOR, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.COLOR});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TEXTURE, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.TEXTURE});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MOVABILITY, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.MOVABLE});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TYPE, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VISIBILITY, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.VISIBLE});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.PRICE});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences, furnitureController, "toggleFurnitureSort", new Object[]{HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED});
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER, userPreferences, furnitureController, "toggleFurnitureSortOrder", new Object[0]);
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.CATALOG_ID});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_NAME, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.NAME});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_WIDTH, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.WIDTH});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DEPTH, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.DEPTH});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_HEIGHT, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.HEIGHT});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_X, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.X});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_Y, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.Y});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ELEVATION, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.ELEVATION});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ANGLE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.ANGLE});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_COLOR, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.COLOR});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_TEXTURE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.TEXTURE});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MOVABLE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.MOVABLE});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DOOR_OR_WINDOW, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VISIBLE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.VISIBLE});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.PRICE});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX});
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", new Object[]{HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED});
        if (homeController.getPlanController().getView() != null) {
            this.createAction(HomeView.ActionType.SELECT, userPreferences, homeController, "setMode", PlanController.Mode.SELECTION);
            this.createAction(HomeView.ActionType.PAN, userPreferences, homeController, "setMode", PlanController.Mode.PANNING);
            this.createAction(HomeView.ActionType.CREATE_WALLS, userPreferences, homeController, "setMode", PlanController.Mode.WALL_CREATION);
            this.createAction(HomeView.ActionType.CREATE_ROOMS, userPreferences, homeController, "setMode", PlanController.Mode.ROOM_CREATION);
            this.createAction(HomeView.ActionType.CREATE_DIMENSION_LINES, userPreferences, homeController, "setMode", PlanController.Mode.DIMENSION_LINE_CREATION);
            this.createAction(HomeView.ActionType.CREATE_LABELS, userPreferences, homeController, "setMode", PlanController.Mode.LABEL_CREATION);
            this.createAction(HomeView.ActionType.DELETE_SELECTION, userPreferences, homeController.getPlanController(), "deleteSelection", new Object[0]);
            this.createAction(HomeView.ActionType.LOCK_BASE_PLAN, userPreferences, homeController.getPlanController(), "lockBasePlan", new Object[0]);
            this.createAction(HomeView.ActionType.UNLOCK_BASE_PLAN, userPreferences, homeController.getPlanController(), "unlockBasePlan", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_COMPASS, userPreferences, homeController.getPlanController(), "modifyCompass", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_WALL, userPreferences, homeController.getPlanController(), "modifySelectedWalls", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_ROOM, userPreferences, homeController.getPlanController(), "modifySelectedRooms", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_LABEL, userPreferences, homeController.getPlanController(), "modifySelectedLabels", new Object[0]);
            this.createAction(HomeView.ActionType.INCREASE_TEXT_SIZE, userPreferences, homeController.getPlanController(), "increaseTextSize", new Object[0]);
            this.createAction(HomeView.ActionType.DECREASE_TEXT_SIZE, userPreferences, homeController.getPlanController(), "decreaseTextSize", new Object[0]);
            this.createAction(HomeView.ActionType.TOGGLE_BOLD_STYLE, userPreferences, homeController.getPlanController(), "toggleBoldStyle", new Object[0]);
            this.createAction(HomeView.ActionType.TOGGLE_ITALIC_STYLE, userPreferences, homeController.getPlanController(), "toggleItalicStyle", new Object[0]);
            this.createAction(HomeView.ActionType.REVERSE_WALL_DIRECTION, userPreferences, homeController.getPlanController(), "reverseSelectedWallsDirection", new Object[0]);
            this.createAction(HomeView.ActionType.SPLIT_WALL, userPreferences, homeController.getPlanController(), "splitSelectedWall", new Object[0]);
            this.createAction(HomeView.ActionType.IMPORT_BACKGROUND_IMAGE, userPreferences, homeController, "importBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_BACKGROUND_IMAGE, userPreferences, homeController, "modifyBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.HIDE_BACKGROUND_IMAGE, userPreferences, homeController, "hideBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.SHOW_BACKGROUND_IMAGE, userPreferences, homeController, "showBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, userPreferences, homeController, "deleteBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.ZOOM_IN, userPreferences, homeController, "zoomIn", new Object[0]);
            this.createAction(HomeView.ActionType.ZOOM_OUT, userPreferences, homeController, "zoomOut", new Object[0]);
            this.createAction(HomeView.ActionType.EXPORT_TO_SVG, userPreferences, homeController, "exportToSVG", new Object[0]);
        }
        if (homeController.getHomeController3D().getView() != null) {
            this.createAction(HomeView.ActionType.VIEW_FROM_TOP, userPreferences, homeController.getHomeController3D(), "viewFromTop", new Object[0]);
            this.createAction(HomeView.ActionType.VIEW_FROM_OBSERVER, userPreferences, homeController.getHomeController3D(), "viewFromObserver", new Object[0]);
            this.createAction(HomeView.ActionType.STORE_POINT_OF_VIEW, userPreferences, homeController, "storeCamera", new Object[0]);
            this.getActionMap().put((Object)HomeView.ActionType.DETACH_3D_VIEW, new ResourceAction(userPreferences, HomePane.class, HomeView.ActionType.DETACH_3D_VIEW.name()){

                public void actionPerformed(ActionEvent actionEvent) {
                    homeController.detachView(homeController.getHomeController3D().getView());
                }
            });
            this.getActionMap().put((Object)HomeView.ActionType.ATTACH_3D_VIEW, new ResourceAction(userPreferences, HomePane.class, HomeView.ActionType.ATTACH_3D_VIEW.name()){

                public void actionPerformed(ActionEvent actionEvent) {
                    homeController.attachView(homeController.getHomeController3D().getView());
                }
            });
            this.createAction(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, userPreferences, homeController.getHomeController3D(), "modifyAttributes", new Object[0]);
            this.createAction(HomeView.ActionType.CREATE_PHOTO, userPreferences, homeController, "createPhoto", new Object[0]);
            this.createAction(HomeView.ActionType.CREATE_VIDEO, userPreferences, homeController, "createVideo", new Object[0]);
            this.createAction(HomeView.ActionType.EXPORT_TO_OBJ, userPreferences, homeController, "exportToOBJ", new Object[0]);
        }
        this.createAction(HomeView.ActionType.HELP, userPreferences, homeController, "help", new Object[0]);
        this.createAction(HomeView.ActionType.ABOUT, userPreferences, homeController, "about", new Object[0]);
    }

    private void createAction(HomeView.ActionType actionType, UserPreferences userPreferences, Object object, String string, Object ... objectArray) {
        try {
            this.getActionMap().put((Object)actionType, new ControllerAction(userPreferences, HomePane.class, actionType.name(), object, string, objectArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    private void createClipboardAction(HomeView.ActionType actionType, UserPreferences userPreferences, final Action action) {
        this.getActionMap().put((Object)actionType, new ResourceAction(userPreferences, HomePane.class, actionType.name()){

            public void actionPerformed(ActionEvent actionEvent) {
                actionEvent = new ActionEvent(HomePane.this.lastFocusedComponent, 1001, null);
                action.actionPerformed(actionEvent);
            }
        });
    }

    private void createMenuActions(UserPreferences userPreferences, HomeController homeController) {
        this.menuActionMap = new ActionMap();
        this.createMenuAction(userPreferences, MenuActionType.FILE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.EDIT_MENU);
        this.createMenuAction(userPreferences, MenuActionType.FURNITURE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.PLAN_MENU);
        this.createMenuAction(userPreferences, MenuActionType.VIEW_3D_MENU);
        this.createMenuAction(userPreferences, MenuActionType.HELP_MENU);
        this.createMenuAction(userPreferences, MenuActionType.OPEN_RECENT_HOME_MENU);
        this.createMenuAction(userPreferences, MenuActionType.SORT_HOME_FURNITURE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.DISPLAY_HOME_FURNITURE_PROPERTY_MENU);
        this.createMenuAction(userPreferences, MenuActionType.MODIFY_TEXT_STYLE);
        this.createMenuAction(userPreferences, MenuActionType.GO_TO_POINT_OF_VIEW);
    }

    private void createMenuAction(UserPreferences userPreferences, MenuActionType menuActionType) {
        this.menuActionMap.put((Object)menuActionType, new ResourceAction(userPreferences, HomePane.class, menuActionType.name(), true));
    }

    private void createPluginActions(List<Plugin> list) {
        this.pluginActions = new ArrayList<Action>();
        if (list != null) {
            for (Plugin plugin : list) {
                for (PluginAction pluginAction : plugin.getActions()) {
                    this.pluginActions.add(new ActionAdapter(pluginAction));
                }
            }
        }
    }

    private void createTransferHandlers(Home home, HomeController homeController) {
        this.catalogTransferHandler = new FurnitureCatalogTransferHandler(homeController.getContentManager(), homeController.getFurnitureCatalogController());
        this.furnitureTransferHandler = new FurnitureTransferHandler(home, homeController.getContentManager(), homeController);
        this.planTransferHandler = new PlanTransferHandler(home, homeController.getContentManager(), homeController);
    }

    private void addHomeListener(final Home home) {
        home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomePane.this.viewFromTopToggleModel.setSelected(home.getCamera() == home.getTopCamera());
                HomePane.this.viewFromObserverToggleModel.setSelected(home.getCamera() == home.getObserverCamera());
            }
        });
    }

    private void addLanguageListener(UserPreferences userPreferences) {
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void addPlanControllerListener(final PlanController planController) {
        planController.addPropertyChangeListener(PlanController.Property.MODE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomePane.this.selectToggleModel.setSelected(planController.getMode() == PlanController.Mode.SELECTION);
                HomePane.this.panToggleModel.setSelected(planController.getMode() == PlanController.Mode.PANNING);
                HomePane.this.createWallsToggleModel.setSelected(planController.getMode() == PlanController.Mode.WALL_CREATION);
                HomePane.this.createRoomsToggleModel.setSelected(planController.getMode() == PlanController.Mode.ROOM_CREATION);
                HomePane.this.createDimensionLinesToggleModel.setSelected(planController.getMode() == PlanController.Mode.DIMENSION_LINE_CREATION);
                HomePane.this.createLabelsToggleModel.setSelected(planController.getMode() == PlanController.Mode.LABEL_CREATION);
            }
        });
    }

    private void addFocusListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("currentFocusCycleRoot", new FocusCycleRootChangeListener(this));
    }

    private void updateFocusTraversalPolicy() {
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            protected boolean accept(Component component) {
                if (super.accept(component)) {
                    JSplitPane jSplitPane;
                    while ((jSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, component)) != null) {
                        if (HomePane.this.isChildComponentInvisible(jSplitPane, component)) {
                            return false;
                        }
                        component = jSplitPane;
                    }
                    return true;
                }
                return false;
            }
        });
        this.setFocusTraversalPolicyProvider(true);
    }

    private boolean isChildComponentInvisible(JSplitPane jSplitPane, Component component) {
        return SwingUtilities.isDescendingFrom(component, jSplitPane.getTopComponent()) && (jSplitPane.getTopComponent().getWidth() == 0 || jSplitPane.getTopComponent().getHeight() == 0) || SwingUtilities.isDescendingFrom(component, jSplitPane.getBottomComponent()) && (jSplitPane.getBottomComponent().getWidth() == 0 || jSplitPane.getBottomComponent().getHeight() == 0);
    }

    private JMenuBar createMenuBar(Home home, UserPreferences userPreferences, final HomeController homeController) {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.FILE_MENU));
        this.addActionToMenu(HomeView.ActionType.NEW_HOME, jMenu);
        this.addActionToMenu(HomeView.ActionType.OPEN, jMenu);
        final JMenu jMenu2 = new JMenu(this.menuActionMap.get((Object)MenuActionType.OPEN_RECENT_HOME_MENU));
        this.addActionToMenu(HomeView.ActionType.DELETE_RECENT_HOMES, jMenu2);
        jMenu2.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                HomePane.this.updateOpenRecentHomeMenu(jMenu2, homeController);
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        });
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.addActionToMenu(HomeView.ActionType.CLOSE, jMenu);
        this.addActionToMenu(HomeView.ActionType.SAVE, jMenu);
        this.addActionToMenu(HomeView.ActionType.SAVE_AS, jMenu);
        this.addActionToMenu(HomeView.ActionType.SAVE_AND_COMPRESS, jMenu);
        jMenu.addSeparator();
        this.addActionToMenu(HomeView.ActionType.PAGE_SETUP, jMenu);
        this.addActionToMenu(HomeView.ActionType.PRINT_PREVIEW, jMenu);
        this.addActionToMenu(HomeView.ActionType.PRINT, jMenu);
        if (!OperatingSystem.isMacOSX()) {
            this.addActionToMenu(HomeView.ActionType.PRINT_TO_PDF, jMenu);
            jMenu.addSeparator();
            this.addActionToMenu(HomeView.ActionType.PREFERENCES, jMenu);
        }
        JMenu jMenu3 = new JMenu(this.menuActionMap.get((Object)MenuActionType.EDIT_MENU));
        this.addActionToMenu(HomeView.ActionType.UNDO, jMenu3);
        this.addActionToMenu(HomeView.ActionType.REDO, jMenu3);
        jMenu3.addSeparator();
        this.addActionToMenu(HomeView.ActionType.CUT, jMenu3);
        this.addActionToMenu(HomeView.ActionType.COPY, jMenu3);
        this.addActionToMenu(HomeView.ActionType.PASTE, jMenu3);
        jMenu3.addSeparator();
        this.addActionToMenu(HomeView.ActionType.DELETE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.SELECT_ALL, jMenu3);
        JMenu jMenu4 = new JMenu(this.menuActionMap.get((Object)MenuActionType.FURNITURE_MENU));
        this.addActionToMenu(HomeView.ActionType.ADD_HOME_FURNITURE, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_FURNITURE, jMenu4);
        this.addActionToMenu(HomeView.ActionType.GROUP_FURNITURE, jMenu4);
        this.addActionToMenu(HomeView.ActionType.UNGROUP_FURNITURE, jMenu4);
        jMenu4.addSeparator();
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, jMenu4);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, jMenu4);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, jMenu4);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, jMenu4);
        jMenu4.addSeparator();
        this.addActionToMenu(HomeView.ActionType.IMPORT_FURNITURE, jMenu4);
        this.addActionToMenu(HomeView.ActionType.IMPORT_FURNITURE_LIBRARY, jMenu4);
        this.addActionToMenu(HomeView.ActionType.IMPORT_TEXTURES_LIBRARY, jMenu4);
        jMenu4.addSeparator();
        jMenu4.add(this.createFurnitureSortMenu(home, userPreferences));
        jMenu4.add(this.createFurnitureDisplayPropertyMenu(home, userPreferences));
        JMenu jMenu5 = new JMenu(this.menuActionMap.get((Object)MenuActionType.PLAN_MENU));
        this.addToggleActionToMenu(HomeView.ActionType.SELECT, this.selectToggleModel, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.PAN, this.panToggleModel, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_WALLS, this.createWallsToggleModel, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_ROOMS, this.createRoomsToggleModel, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_DIMENSION_LINES, this.createDimensionLinesToggleModel, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_LABELS, this.createLabelsToggleModel, true, jMenu5);
        jMenu5.addSeparator();
        JMenuItem jMenuItem2 = this.createLockUnlockBasePlanMenuItem(home, false);
        if (jMenuItem2 != null) {
            jMenu5.add(jMenuItem2);
        }
        this.addActionToMenu(HomeView.ActionType.MODIFY_COMPASS, jMenu5);
        this.addActionToMenu(HomeView.ActionType.MODIFY_WALL, jMenu5);
        this.addActionToMenu(HomeView.ActionType.REVERSE_WALL_DIRECTION, jMenu5);
        this.addActionToMenu(HomeView.ActionType.SPLIT_WALL, jMenu5);
        this.addActionToMenu(HomeView.ActionType.MODIFY_ROOM, jMenu5);
        this.addActionToMenu(HomeView.ActionType.MODIFY_LABEL, jMenu5);
        jMenu5.add(this.createTextStyleMenu(home, userPreferences, false));
        jMenu5.addSeparator();
        JMenuItem jMenuItem3 = this.createImportModifyBackgroundImageMenuItem(home, false);
        if (jMenuItem3 != null) {
            jMenu5.add(jMenuItem3);
        }
        if ((jMenuItem = this.createHideShowBackgroundImageMenuItem(home, false)) != null) {
            jMenu5.add(jMenuItem);
        }
        this.addActionToMenu(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, jMenu5);
        jMenu5.addSeparator();
        this.addActionToMenu(HomeView.ActionType.ZOOM_IN, jMenu5);
        this.addActionToMenu(HomeView.ActionType.ZOOM_OUT, jMenu5);
        jMenu5.addSeparator();
        this.addActionToMenu(HomeView.ActionType.EXPORT_TO_SVG, jMenu5);
        JMenu jMenu6 = new JMenu(this.menuActionMap.get((Object)MenuActionType.VIEW_3D_MENU));
        this.addToggleActionToMenu(HomeView.ActionType.VIEW_FROM_TOP, this.viewFromTopToggleModel, true, jMenu6);
        this.addToggleActionToMenu(HomeView.ActionType.VIEW_FROM_OBSERVER, this.viewFromObserverToggleModel, true, jMenu6);
        this.addActionToMenu(HomeView.ActionType.STORE_POINT_OF_VIEW, jMenu6);
        jMenu6.add(this.createGoToPointOfViewMenu(home, userPreferences, homeController));
        jMenu6.addSeparator();
        JMenuItem jMenuItem4 = this.createAttachDetach3DViewMenuItem(homeController, false);
        if (jMenuItem4 != null) {
            jMenu6.add(jMenuItem4);
        }
        this.addActionToMenu(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, jMenu6);
        jMenu6.addSeparator();
        this.addActionToMenu(HomeView.ActionType.CREATE_PHOTO, jMenu6);
        this.addActionToMenu(HomeView.ActionType.CREATE_VIDEO, jMenu6);
        jMenu6.addSeparator();
        this.addActionToMenu(HomeView.ActionType.EXPORT_TO_OBJ, jMenu6);
        JMenu jMenu7 = new JMenu(this.menuActionMap.get((Object)MenuActionType.HELP_MENU));
        this.addActionToMenu(HomeView.ActionType.HELP, jMenu7);
        if (!OperatingSystem.isMacOSX()) {
            this.addActionToMenu(HomeView.ActionType.ABOUT, jMenu7);
        }
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        if (homeController.getPlanController().getView() != null) {
            jMenuBar.add(jMenu5);
        }
        if (homeController.getHomeController3D().getView() != null) {
            jMenuBar.add(jMenu6);
        }
        jMenuBar.add(jMenu7);
        for (Action action : this.pluginActions) {
            String string = (String)action.getValue(PluginAction.Property.MENU.name());
            if (string == null) continue;
            boolean bl = false;
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                JMenu jMenu8 = jMenuBar.getMenu(i);
                if (!jMenu8.getText().equals(string)) continue;
                jMenu8.addSeparator();
                jMenu8.add(new ResourceAction.MenuItemAction(action));
                bl = true;
                break;
            }
            if (bl) continue;
            JMenu jMenu9 = new JMenu(string);
            jMenu9.add(new ResourceAction.MenuItemAction(action));
            jMenuBar.add((Component)jMenu9, jMenuBar.getMenuCount() - 1);
        }
        if (!OperatingSystem.isMacOSX()) {
            jMenu.addSeparator();
            this.addActionToMenu(HomeView.ActionType.EXIT, jMenu);
        }
        this.removeUselessSeparatorsAndEmptyMenus(jMenuBar);
        return jMenuBar;
    }

    private void addActionToMenu(HomeView.ActionType actionType, JMenu jMenu) {
        this.addActionToMenu(actionType, false, jMenu);
    }

    private void addActionToMenu(HomeView.ActionType actionType, boolean bl, JMenu jMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jMenu.add(bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action));
        }
    }

    private void addToggleActionToMenu(HomeView.ActionType actionType, JToggleButton.ToggleButtonModel toggleButtonModel, boolean bl, JMenu jMenu) {
        this.addToggleActionToMenu(actionType, false, toggleButtonModel, bl, jMenu);
    }

    private void addToggleActionToMenu(HomeView.ActionType actionType, boolean bl, JToggleButton.ToggleButtonModel toggleButtonModel, boolean bl2, JMenu jMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jMenu.add(this.createToggleMenuItem(action, bl, toggleButtonModel, bl2));
        }
    }

    private JMenuItem createToggleMenuItem(Action action, boolean bl, JToggleButton.ToggleButtonModel toggleButtonModel, boolean bl2) {
        JMenuItem jMenuItem = bl2 ? new JRadioButtonMenuItem() : new JCheckBoxMenuItem();
        jMenuItem.setModel(toggleButtonModel);
        jMenuItem.setAction(bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action));
        return jMenuItem;
    }

    private void addActionToPopupMenu(HomeView.ActionType actionType, JPopupMenu jPopupMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jPopupMenu.add(new ResourceAction.PopupMenuItemAction(action));
        }
    }

    private void addToggleActionToPopupMenu(HomeView.ActionType actionType, JToggleButton.ToggleButtonModel toggleButtonModel, boolean bl, JPopupMenu jPopupMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jPopupMenu.add(this.createToggleMenuItem(action, true, toggleButtonModel, bl));
        }
    }

    private void removeUselessSeparatorsAndEmptyMenus(JComponent jComponent) {
        for (int i = jComponent.getComponentCount() - 1; i >= 0; --i) {
            Component component = jComponent.getComponent(i);
            if (component instanceof JSeparator && (i == jComponent.getComponentCount() - 1 || jComponent.getComponent(i - 1) instanceof JSeparator)) {
                jComponent.remove(i);
            } else if (component instanceof JMenu) {
                this.removeUselessSeparatorsAndEmptyMenus(((JMenu)component).getPopupMenu());
            }
            if (!(component instanceof JMenu) || ((JMenu)component).getMenuComponentCount() != 0 && (((JMenu)component).getMenuComponentCount() != 1 || !(((JMenu)component).getMenuComponent(0) instanceof JSeparator))) continue;
            jComponent.remove(i);
        }
        if (jComponent.getComponentCount() > 0 && jComponent.getComponent(0) instanceof JSeparator) {
            jComponent.remove(0);
        }
    }

    private JMenu createFurnitureSortMenu(final Home home, UserPreferences userPreferences) {
        JMenu jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.SORT_HOME_FURNITURE_MENU));
        LinkedHashMap<HomePieceOfFurniture.SortableProperty, Action> linkedHashMap = new LinkedHashMap<HomePieceOfFurniture.SortableProperty, Action>();
        if (userPreferences.getCurrency() != null) {
            this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID, linkedHashMap, HomePieceOfFurniture.SortableProperty.CATALOG_ID);
        }
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_NAME, linkedHashMap, HomePieceOfFurniture.SortableProperty.NAME);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_WIDTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.WIDTH);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DEPTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.DEPTH);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_HEIGHT, linkedHashMap, HomePieceOfFurniture.SortableProperty.HEIGHT);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_X, linkedHashMap, HomePieceOfFurniture.SortableProperty.X);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_Y, linkedHashMap, HomePieceOfFurniture.SortableProperty.Y);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ELEVATION, linkedHashMap, HomePieceOfFurniture.SortableProperty.ELEVATION);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ANGLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.ANGLE);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_COLOR, linkedHashMap, HomePieceOfFurniture.SortableProperty.COLOR);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TEXTURE, linkedHashMap, HomePieceOfFurniture.SortableProperty.TEXTURE);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MOVABILITY, linkedHashMap, HomePieceOfFurniture.SortableProperty.MOVABLE);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TYPE, linkedHashMap, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW);
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VISIBILITY, linkedHashMap, HomePieceOfFurniture.SortableProperty.VISIBLE);
        if (userPreferences.getCurrency() != null) {
            this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE);
            this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE);
            this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX);
            this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Map.Entry object : linkedHashMap.entrySet()) {
            final HomePieceOfFurniture.SortableProperty sortableProperty = (HomePieceOfFurniture.SortableProperty)((Object)object.getKey());
            Action action = (Action)object.getValue();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jRadioButtonMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                public boolean isSelected() {
                    return sortableProperty == home.getFurnitureSortedProperty();
                }
            });
            jRadioButtonMenuItem.setAction(new ResourceAction.MenuItemAction(action));
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        Action action = this.getActionMap().get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER);
        if (action.getValue("Name") != null) {
            jMenu.addSeparator();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            jCheckBoxMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                public boolean isSelected() {
                    return home.isFurnitureDescendingSorted();
                }
            });
            jCheckBoxMenuItem.setAction(new ResourceAction.MenuItemAction(action));
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    private void addActionToMap(HomeView.ActionType actionType, Map<HomePieceOfFurniture.SortableProperty, Action> map, HomePieceOfFurniture.SortableProperty sortableProperty) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            map.put(sortableProperty, action);
        }
    }

    private JMenu createFurnitureDisplayPropertyMenu(final Home home, UserPreferences userPreferences) {
        JMenu jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.DISPLAY_HOME_FURNITURE_PROPERTY_MENU));
        LinkedHashMap<HomePieceOfFurniture.SortableProperty, Action> linkedHashMap = new LinkedHashMap<HomePieceOfFurniture.SortableProperty, Action>();
        if (userPreferences.getCurrency() != null) {
            this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID, linkedHashMap, HomePieceOfFurniture.SortableProperty.CATALOG_ID);
        }
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_NAME, linkedHashMap, HomePieceOfFurniture.SortableProperty.NAME);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_WIDTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.WIDTH);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DEPTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.DEPTH);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_HEIGHT, linkedHashMap, HomePieceOfFurniture.SortableProperty.HEIGHT);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_X, linkedHashMap, HomePieceOfFurniture.SortableProperty.X);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_Y, linkedHashMap, HomePieceOfFurniture.SortableProperty.Y);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ELEVATION, linkedHashMap, HomePieceOfFurniture.SortableProperty.ELEVATION);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ANGLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.ANGLE);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_COLOR, linkedHashMap, HomePieceOfFurniture.SortableProperty.COLOR);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_TEXTURE, linkedHashMap, HomePieceOfFurniture.SortableProperty.TEXTURE);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MOVABLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.MOVABLE);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DOOR_OR_WINDOW, linkedHashMap, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW);
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VISIBLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.VISIBLE);
        if (userPreferences.getCurrency() != null) {
            this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE);
            this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE);
            this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX);
            this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            final HomePieceOfFurniture.SortableProperty sortableProperty = (HomePieceOfFurniture.SortableProperty)((Object)entry.getKey());
            Action action = (Action)entry.getValue();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            jCheckBoxMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                public boolean isSelected() {
                    return home.getFurnitureVisibleProperties().contains((Object)sortableProperty);
                }
            });
            jCheckBoxMenuItem.setAction(action);
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    private JMenuItem createLockUnlockBasePlanMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.UNLOCK_BASE_PLAN);
        Action action2 = actionMap.get((Object)HomeView.ActionType.LOCK_BASE_PLAN);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createLockUnlockBasePlanAction(home, bl));
            home.addPropertyChangeListener(Home.Property.BASE_PLAN_LOCKED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createLockUnlockBasePlanAction(home, bl));
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createLockUnlockBasePlanAction(Home home, boolean bl) {
        HomeView.ActionType actionType = home.isBasePlanLocked() ? HomeView.ActionType.UNLOCK_BASE_PLAN : HomeView.ActionType.LOCK_BASE_PLAN;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JComponent createLockUnlockBasePlanButton(final Home home) {
        ActionMap actionMap = this.getActionMap();
        final Action action = actionMap.get((Object)HomeView.ActionType.UNLOCK_BASE_PLAN);
        final Action action2 = actionMap.get((Object)HomeView.ActionType.LOCK_BASE_PLAN);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JButton jButton = new JButton(new ResourceAction.ToolBarAction(home.isBasePlanLocked() ? action : action2));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setFocusable(false);
            home.addPropertyChangeListener(Home.Property.BASE_PLAN_LOCKED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jButton.setAction(new ResourceAction.ToolBarAction(home.isBasePlanLocked() ? action : action2));
                }
            });
            return jButton;
        }
        return null;
    }

    private JMenu createTextStyleMenu(Home home, UserPreferences userPreferences, boolean bl) {
        JMenu jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.MODIFY_TEXT_STYLE));
        this.addActionToMenu(HomeView.ActionType.INCREASE_TEXT_SIZE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.DECREASE_TEXT_SIZE, bl, jMenu);
        jMenu.addSeparator();
        this.addToggleActionToMenu(HomeView.ActionType.TOGGLE_BOLD_STYLE, bl, this.boldStyleToggleModel, false, jMenu);
        this.addToggleActionToMenu(HomeView.ActionType.TOGGLE_ITALIC_STYLE, bl, this.italicStyleToggleModel, false, jMenu);
        return jMenu;
    }

    private JToggleButton.ToggleButtonModel createBoldStyleToggleModel(final Home home, final UserPreferences userPreferences) {
        return new JToggleButton.ToggleButtonModel(){
            {
                home.addSelectionListener(new SelectionListener(){

                    public void selectionChanged(SelectionEvent selectionEvent) {
                        this.fireStateChanged();
                    }
                });
            }

            public boolean isSelected() {
                Boolean bl = null;
                for (Selectable selectable : home.getSelectedItems()) {
                    Boolean bl2;
                    if (selectable instanceof Label) {
                        bl2 = this.isItemTextBold(selectable, ((Label)selectable).getStyle());
                    } else if (selectable instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)selectable).isVisible()) {
                        bl2 = this.isItemTextBold(selectable, ((HomePieceOfFurniture)selectable).getNameStyle());
                    } else if (selectable instanceof Room) {
                        Room room = (Room)selectable;
                        bl2 = this.isItemTextBold(room, room.getNameStyle());
                        if (bl2.booleanValue() != this.isItemTextBold(room, room.getAreaStyle())) {
                            bl2 = null;
                        }
                    } else {
                        if (!(selectable instanceof DimensionLine)) continue;
                        bl2 = this.isItemTextBold(selectable, ((DimensionLine)selectable).getLengthStyle());
                    }
                    if (bl == null) {
                        bl = bl2;
                        continue;
                    }
                    if (bl2 != null && bl.equals(bl2)) continue;
                    bl = null;
                    break;
                }
                return bl != null && bl != false;
            }

            private boolean isItemTextBold(Selectable selectable, TextStyle textStyle) {
                if (textStyle == null) {
                    textStyle = userPreferences.getDefaultTextStyle(selectable.getClass());
                }
                return textStyle.isBold();
            }
        };
    }

    private JToggleButton.ToggleButtonModel createItalicStyleToggleModel(final Home home, final UserPreferences userPreferences) {
        return new JToggleButton.ToggleButtonModel(){
            {
                home.addSelectionListener(new SelectionListener(){

                    public void selectionChanged(SelectionEvent selectionEvent) {
                        this.fireStateChanged();
                    }
                });
            }

            public boolean isSelected() {
                Boolean bl = null;
                for (Selectable selectable : home.getSelectedItems()) {
                    Boolean bl2;
                    if (selectable instanceof Label) {
                        bl2 = this.isItemTextItalic(selectable, ((Label)selectable).getStyle());
                    } else if (selectable instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)selectable).isVisible()) {
                        bl2 = this.isItemTextItalic(selectable, ((HomePieceOfFurniture)selectable).getNameStyle());
                    } else if (selectable instanceof Room) {
                        Room room = (Room)selectable;
                        bl2 = this.isItemTextItalic(room, room.getNameStyle());
                        if (bl2.booleanValue() != this.isItemTextItalic(room, room.getAreaStyle())) {
                            bl2 = null;
                        }
                    } else {
                        if (!(selectable instanceof DimensionLine)) continue;
                        bl2 = this.isItemTextItalic(selectable, ((DimensionLine)selectable).getLengthStyle());
                    }
                    if (bl == null) {
                        bl = bl2;
                        continue;
                    }
                    if (bl2 != null && bl.equals(bl2)) continue;
                    bl = null;
                    break;
                }
                return bl != null && bl != false;
            }

            private boolean isItemTextItalic(Selectable selectable, TextStyle textStyle) {
                if (textStyle == null) {
                    textStyle = userPreferences.getDefaultTextStyle(selectable.getClass());
                }
                return textStyle.isItalic();
            }
        };
    }

    private JMenuItem createImportModifyBackgroundImageMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.IMPORT_BACKGROUND_IMAGE);
        Action action2 = actionMap.get((Object)HomeView.ActionType.MODIFY_BACKGROUND_IMAGE);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createImportModifyBackgroundImageAction(home, bl));
            home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createImportModifyBackgroundImageAction(home, bl));
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createImportModifyBackgroundImageAction(Home home, boolean bl) {
        HomeView.ActionType actionType = home.getBackgroundImage() == null ? HomeView.ActionType.IMPORT_BACKGROUND_IMAGE : HomeView.ActionType.MODIFY_BACKGROUND_IMAGE;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JMenuItem createHideShowBackgroundImageMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.HIDE_BACKGROUND_IMAGE);
        Action action2 = actionMap.get((Object)HomeView.ActionType.SHOW_BACKGROUND_IMAGE);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createHideShowBackgroundImageAction(home, bl));
            home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createHideShowBackgroundImageAction(home, bl));
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createHideShowBackgroundImageAction(Home home, boolean bl) {
        BackgroundImage backgroundImage = home.getBackgroundImage();
        HomeView.ActionType actionType = backgroundImage == null || backgroundImage.isVisible() ? HomeView.ActionType.HIDE_BACKGROUND_IMAGE : HomeView.ActionType.SHOW_BACKGROUND_IMAGE;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JMenu createGoToPointOfViewMenu(final Home home, UserPreferences userPreferences, final HomeController homeController) {
        final JMenu jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.GO_TO_POINT_OF_VIEW));
        this.updateGoToPointOfViewMenu(jMenu, home, homeController);
        home.addPropertyChangeListener(Home.Property.STORED_CAMERAS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomePane.this.updateGoToPointOfViewMenu(jMenu, home, homeController);
            }
        });
        return jMenu;
    }

    private void updateGoToPointOfViewMenu(JMenu jMenu, Home home, final HomeController homeController) {
        List<Camera> list = home.getStoredCameras();
        jMenu.removeAll();
        if (list.isEmpty()) {
            jMenu.setEnabled(false);
            jMenu.add(new ResourceAction(this.preferences, HomePane.class, "NoStoredPointOfView", false));
        } else {
            jMenu.setEnabled(true);
            for (final Camera camera : list) {
                jMenu.add(new AbstractAction(camera.getName()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        homeController.getHomeController3D().goToCamera(camera);
                    }
                });
            }
        }
    }

    private JMenuItem createAttachDetach3DViewMenuItem(final HomeController homeController, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.DETACH_3D_VIEW);
        Action action2 = actionMap.get((Object)HomeView.ActionType.ATTACH_3D_VIEW);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createAttachDetach3DViewAction(homeController, bl));
            JComponent jComponent = (JComponent)((Object)homeController.getHomeController3D().getView());
            jComponent.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    jMenuItem.setAction(HomePane.this.createAttachDetach3DViewAction(homeController, bl));
                }

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createAttachDetach3DViewAction(HomeController homeController, boolean bl) {
        JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)homeController.getHomeController3D().getView()));
        HomeView.ActionType actionType = jRootPane == this ? HomeView.ActionType.DETACH_3D_VIEW : HomeView.ActionType.ATTACH_3D_VIEW;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    protected void updateOpenRecentHomeMenu(JMenu jMenu, final HomeController homeController) {
        jMenu.removeAll();
        for (final String string : homeController.getRecentHomes()) {
            jMenu.add(new AbstractAction(homeController.getContentManager().getPresentationName(string, ContentManager.ContentType.SWEET_HOME_3D)){

                public void actionPerformed(ActionEvent actionEvent) {
                    homeController.open(string);
                }
            });
        }
        if (jMenu.getMenuComponentCount() > 0) {
            jMenu.addSeparator();
        }
        this.addActionToMenu(HomeView.ActionType.DELETE_RECENT_HOMES, jMenu);
    }

    private JToolBar createToolBar(Home home) {
        UnfocusableToolBar unfocusableToolBar = new UnfocusableToolBar();
        this.addActionToToolBar(HomeView.ActionType.NEW_HOME, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.OPEN, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.SAVE, unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(HomeView.ActionType.UNDO, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.REDO, unfocusableToolBar);
        unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        this.addActionToToolBar(HomeView.ActionType.CUT, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.COPY, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.PASTE, unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(HomeView.ActionType.ADD_HOME_FURNITURE, unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        this.addToggleActionToToolBar(HomeView.ActionType.SELECT, this.selectToggleModel, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.PAN, this.panToggleModel, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_WALLS, this.createWallsToggleModel, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_ROOMS, this.createRoomsToggleModel, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_DIMENSION_LINES, this.createDimensionLinesToggleModel, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_LABELS, this.createLabelsToggleModel, unfocusableToolBar);
        unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        this.addActionToToolBar(HomeView.ActionType.INCREASE_TEXT_SIZE, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.DECREASE_TEXT_SIZE, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.TOGGLE_BOLD_STYLE, this.boldStyleToggleModel, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.TOGGLE_ITALIC_STYLE, this.italicStyleToggleModel, unfocusableToolBar);
        unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        this.addActionToToolBar(HomeView.ActionType.ZOOM_IN, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.ZOOM_OUT, unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(HomeView.ActionType.CREATE_PHOTO, unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.CREATE_VIDEO, unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        boolean bl = false;
        for (Action object : this.pluginActions) {
            if (!Boolean.TRUE.equals(object.getValue(PluginAction.Property.TOOL_BAR.name()))) continue;
            unfocusableToolBar.add(new ResourceAction.ToolBarAction(object));
            bl = true;
        }
        if (bl) {
            unfocusableToolBar.addSeparator();
        }
        this.addActionToToolBar(HomeView.ActionType.HELP, unfocusableToolBar);
        for (int i = unfocusableToolBar.getComponentCount() - 1; i > 0; --i) {
            Component component = unfocusableToolBar.getComponent(i);
            if (!(component instanceof JSeparator) || i != unfocusableToolBar.getComponentCount() - 1 && !(unfocusableToolBar.getComponent(i - 1) instanceof JSeparator)) continue;
            unfocusableToolBar.remove(i);
        }
        return unfocusableToolBar;
    }

    private void addToggleActionToToolBar(HomeView.ActionType actionType, JToggleButton.ToggleButtonModel toggleButtonModel, JToolBar jToolBar) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            ResourceAction.ToolBarAction toolBarAction = new ResourceAction.ToolBarAction(action);
            JToggleButton jToggleButton = new JToggleButton(toolBarAction);
            jToggleButton.setModel(toggleButtonModel);
            jToolBar.add(jToggleButton);
        }
    }

    private void addActionToToolBar(HomeView.ActionType actionType, JToolBar jToolBar) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jToolBar.add(new ResourceAction.ToolBarAction(action));
        }
    }

    @Override
    public void setEnabled(HomeView.ActionType actionType, boolean bl) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    @Override
    public void setUndoRedoName(String string, String string2) {
        this.setNameAndShortDescription(HomeView.ActionType.UNDO, string);
        this.setNameAndShortDescription(HomeView.ActionType.REDO, string2);
    }

    private void setNameAndShortDescription(HomeView.ActionType actionType, String string) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null) {
            if (string == null) {
                string = (String)action.getValue("Default");
            }
            action.putValue("Name", string);
            action.putValue("ShortDescription", string);
        }
    }

    @Override
    public void setTransferEnabled(boolean bl) {
        JComponent jComponent = (JComponent)((Object)this.controller.getFurnitureCatalogController().getView());
        JComponent jComponent2 = (JComponent)((Object)this.controller.getFurnitureController().getView());
        JComponent jComponent3 = (JComponent)((Object)this.controller.getPlanController().getView());
        if (bl) {
            if (jComponent != null) {
                jComponent.setTransferHandler(this.catalogTransferHandler);
            }
            if (jComponent2 != null) {
                jComponent2.setTransferHandler(this.furnitureTransferHandler);
                if (jComponent2 instanceof Scrollable) {
                    ((JViewport)jComponent2.getParent()).setTransferHandler(this.furnitureTransferHandler);
                }
            }
            if (jComponent3 != null) {
                jComponent3.setTransferHandler(this.planTransferHandler);
            }
        } else {
            if (jComponent != null) {
                jComponent.setTransferHandler(null);
            }
            if (jComponent2 != null) {
                jComponent2.setTransferHandler(null);
                if (jComponent2 instanceof Scrollable) {
                    ((JViewport)jComponent2.getParent()).setTransferHandler(null);
                }
            }
            if (jComponent3 != null) {
                jComponent3.setTransferHandler(null);
            }
        }
    }

    private JComponent createMainPane(Home home, UserPreferences userPreferences, HomeController homeController) {
        JComponent jComponent = this.createCatalogFurniturePane(home, userPreferences, homeController);
        JComponent jComponent2 = this.createPlanView3DPane(home, userPreferences, homeController);
        if (jComponent == null) {
            return jComponent2;
        }
        if (jComponent2 == null) {
            return jComponent;
        }
        JSplitPane jSplitPane = new JSplitPane(1, jComponent, jComponent2);
        jSplitPane.setDividerLocation(360);
        this.configureSplitPane(jSplitPane, home, MAIN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY, 0.3, true, homeController);
        return jSplitPane;
    }

    private void configureSplitPane(final JSplitPane jSplitPane, Home home, final String string, double d, boolean bl, final HomeController homeController) {
        Integer n;
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(d);
        if (!bl) {
            jSplitPane.setBorder(null);
        }
        if ((n = (Integer)home.getVisualProperty(string)) != null) {
            jSplitPane.setDividerLocation(n);
        }
        jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        if (component != null && HomePane.this.isChildComponentInvisible(jSplitPane, component)) {
                            FocusTraversalPolicy focusTraversalPolicy = HomePane.this.getFocusTraversalPolicy();
                            Component component2 = focusTraversalPolicy.getComponentAfter(HomePane.this, component);
                            if (component2 == null) {
                                component2 = focusTraversalPolicy.getComponentBefore(HomePane.this, component);
                            }
                            component2.requestFocusInWindow();
                        }
                        homeController.setVisualProperty(string, propertyChangeEvent.getNewValue());
                    }
                });
            }
        });
    }

    private JComponent createCatalogFurniturePane(Home home, UserPreferences userPreferences, final HomeController homeController) {
        Object object;
        JComponent jComponent;
        JComponent jComponent2 = (JComponent)((Object)homeController.getFurnitureCatalogController().getView());
        if (jComponent2 != null) {
            jComponent = new JPopupMenu();
            this.addActionToPopupMenu(HomeView.ActionType.COPY, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.DELETE, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.ADD_HOME_FURNITURE, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_FURNITURE, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.IMPORT_FURNITURE, (JPopupMenu)jComponent);
            SwingTools.hideDisabledMenuItems((JPopupMenu)jComponent);
            jComponent2.setComponentPopupMenu((JPopupMenu)jComponent);
            userPreferences.addPropertyChangeListener(UserPreferences.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, new FurnitureCatalogViewChangeListener(this, jComponent2));
            if (jComponent2 instanceof Scrollable) {
                jComponent2 = new HomeScrollPane(jComponent2);
            }
        }
        if ((jComponent = (JComponent)((Object)homeController.getFurnitureController().getView())) != null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            jComponent.setFocusTraversalKeys(0, ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(0));
            jComponent.setFocusTraversalKeys(1, ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(1));
            JPopupMenu jPopupMenu = new JPopupMenu();
            this.addActionToPopupMenu(HomeView.ActionType.UNDO, jPopupMenu);
            this.addActionToPopupMenu(HomeView.ActionType.REDO, jPopupMenu);
            jPopupMenu.addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.CUT, jPopupMenu);
            this.addActionToPopupMenu(HomeView.ActionType.COPY, jPopupMenu);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE, jPopupMenu);
            jPopupMenu.addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.DELETE, jPopupMenu);
            this.addActionToPopupMenu(HomeView.ActionType.SELECT_ALL, jPopupMenu);
            jPopupMenu.addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_FURNITURE, jPopupMenu);
            this.addActionToPopupMenu(HomeView.ActionType.GROUP_FURNITURE, jPopupMenu);
            this.addActionToPopupMenu(HomeView.ActionType.UNGROUP_FURNITURE, jPopupMenu);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createFurnitureSortMenu(home, userPreferences));
            jPopupMenu.add(this.createFurnitureDisplayPropertyMenu(home, userPreferences));
            SwingTools.hideDisabledMenuItems(jPopupMenu);
            jComponent.setComponentPopupMenu(jPopupMenu);
            if (jComponent instanceof Scrollable) {
                HomeScrollPane homeScrollPane = new HomeScrollPane(jComponent);
                final JViewport jViewport = homeScrollPane.getViewport();
                jViewport.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        jViewport.getView().requestFocusInWindow();
                    }
                });
                Integer n = (Integer)home.getVisualProperty(FURNITURE_VIEWPORT_Y_VISUAL_PROPERTY);
                if (n != null) {
                    jViewport.setViewPosition(new Point(0, n));
                }
                jViewport.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        homeController.setVisualProperty(HomePane.FURNITURE_VIEWPORT_Y_VISUAL_PROPERTY, jViewport.getViewPosition().y);
                    }
                });
                ((JViewport)jComponent.getParent()).setComponentPopupMenu(jPopupMenu);
                jComponent = homeScrollPane;
            }
        }
        if (jComponent2 == null) {
            return jComponent;
        }
        if (jComponent == null) {
            return jComponent2;
        }
        object = new JSplitPane(0, jComponent2, jComponent);
        ((JComponent)object).setBorder(null);
        ((JComponent)object).setMinimumSize(new Dimension());
        this.configureSplitPane((JSplitPane)object, home, CATALOG_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY, 0.5, false, homeController);
        return object;
    }

    private JComponent createPlanView3DPane(Home home, UserPreferences userPreferences, final HomeController homeController) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        JComponent jComponent;
        JMenuItem jMenuItem;
        JComponent jComponent2;
        JComponent jComponent3;
        Serializable serializable4 = (JComponent)((Object)homeController.getPlanController().getView());
        if (serializable4 != null) {
            jComponent3 = new JPopupMenu();
            this.addActionToPopupMenu(HomeView.ActionType.UNDO, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.REDO, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.CUT, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.COPY, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.DELETE, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.SELECT_ALL, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).addSeparator();
            this.addToggleActionToPopupMenu(HomeView.ActionType.SELECT, this.selectToggleModel, true, (JPopupMenu)jComponent3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.PAN, this.panToggleModel, true, (JPopupMenu)jComponent3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_WALLS, this.createWallsToggleModel, true, (JPopupMenu)jComponent3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_ROOMS, this.createRoomsToggleModel, true, (JPopupMenu)jComponent3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_DIMENSION_LINES, this.createDimensionLinesToggleModel, true, (JPopupMenu)jComponent3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_LABELS, this.createLabelsToggleModel, true, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).addSeparator();
            jComponent2 = this.createLockUnlockBasePlanMenuItem(home, true);
            if (jComponent2 != null) {
                ((JPopupMenu)jComponent3).add((JMenuItem)jComponent2);
            }
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_FURNITURE, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.GROUP_FURNITURE, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.UNGROUP_FURNITURE, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_COMPASS, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_WALL, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.REVERSE_WALL_DIRECTION, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.SPLIT_WALL, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_ROOM, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_LABEL, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).add(this.createTextStyleMenu(home, userPreferences, true));
            ((JPopupMenu)jComponent3).addSeparator();
            jMenuItem = this.createImportModifyBackgroundImageMenuItem(home, true);
            if (jMenuItem != null) {
                ((JPopupMenu)jComponent3).add(jMenuItem);
            }
            if ((jComponent = this.createHideShowBackgroundImageMenuItem(home, true)) != null) {
                ((JPopupMenu)jComponent3).add((JMenuItem)jComponent);
            }
            this.addActionToPopupMenu(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.ZOOM_OUT, (JPopupMenu)jComponent3);
            this.addActionToPopupMenu(HomeView.ActionType.ZOOM_IN, (JPopupMenu)jComponent3);
            ((JPopupMenu)jComponent3).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.EXPORT_TO_SVG, (JPopupMenu)jComponent3);
            SwingTools.hideDisabledMenuItems((JPopupMenu)jComponent3);
            serializable4.setComponentPopupMenu((JPopupMenu)jComponent3);
            if (serializable4 instanceof Scrollable) {
                serializable3 = new HomeScrollPane((JComponent)serializable4);
                this.setPlanRulersVisible((JScrollPane)serializable3, homeController, userPreferences.isRulersVisible());
                serializable2 = this.createLockUnlockBasePlanButton(home);
                if (serializable2 != null) {
                    ((JScrollPane)serializable3).setCorner("UPPER_LEADING_CORNER", (Component)serializable2);
                    ((Container)serializable3).addPropertyChangeListener("componentOrientation", new PropertyChangeListener((JComponent)serializable2, (JScrollPane)serializable3){
                        final /* synthetic */ JComponent val$lockUnlockBasePlanButton;
                        final /* synthetic */ JScrollPane val$planScrollPane;
                        {
                            this.val$lockUnlockBasePlanButton = jComponent;
                            this.val$planScrollPane = jScrollPane;
                        }

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (this.val$lockUnlockBasePlanButton.getParent() != null) {
                                this.val$planScrollPane.setCorner("UPPER_LEADING_CORNER", this.val$lockUnlockBasePlanButton);
                            }
                        }
                    });
                }
                userPreferences.addPropertyChangeListener(UserPreferences.Property.RULERS_VISIBLE, new RulersVisibilityChangeListener(this, (JScrollPane)serializable3, homeController));
                serializable = ((JScrollPane)serializable3).getViewport();
                Integer n = (Integer)home.getVisualProperty(PLAN_VIEWPORT_X_VISUAL_PROPERTY);
                Integer n2 = (Integer)home.getVisualProperty(PLAN_VIEWPORT_Y_VISUAL_PROPERTY);
                if (n != null && n2 != null) {
                    ((JViewport)serializable).setViewPosition(new Point(n, n2));
                }
                ((JViewport)serializable).addChangeListener(new ChangeListener((JViewport)serializable, homeController){
                    final /* synthetic */ JViewport val$viewport;
                    final /* synthetic */ HomeController val$controller;
                    {
                        this.val$viewport = jViewport;
                        this.val$controller = homeController;
                    }

                    public void stateChanged(ChangeEvent changeEvent) {
                        Point point = this.val$viewport.getViewPosition();
                        this.val$controller.setVisualProperty(HomePane.PLAN_VIEWPORT_X_VISUAL_PROPERTY, point.x);
                        this.val$controller.setVisualProperty(HomePane.PLAN_VIEWPORT_Y_VISUAL_PROPERTY, point.y);
                    }
                });
                serializable4 = serializable3;
            }
        }
        if ((jComponent3 = (JComponent)((Object)homeController.getHomeController3D().getView())) != null) {
            jComponent3.setPreferredSize(serializable4 != null ? serializable4.getPreferredSize() : new Dimension(400, 400));
            jComponent3.setMinimumSize(new Dimension(0, 0));
            jComponent2 = new JPopupMenu();
            this.addToggleActionToPopupMenu(HomeView.ActionType.VIEW_FROM_TOP, this.viewFromTopToggleModel, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.VIEW_FROM_OBSERVER, this.viewFromObserverToggleModel, true, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.STORE_POINT_OF_VIEW, (JPopupMenu)jComponent2);
            jComponent2.add(this.createGoToPointOfViewMenu(home, userPreferences, homeController));
            jComponent2.addSeparator();
            jMenuItem = this.createAttachDetach3DViewMenuItem(homeController, true);
            if (jMenuItem != null) {
                jComponent2.add(jMenuItem);
            }
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, (JPopupMenu)jComponent2);
            jComponent2.addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.CREATE_PHOTO, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.CREATE_VIDEO, (JPopupMenu)jComponent2);
            jComponent2.addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.EXPORT_TO_OBJ, (JPopupMenu)jComponent2);
            SwingTools.hideDisabledMenuItems(jComponent2);
            jComponent3.setComponentPopupMenu((JPopupMenu)jComponent2);
            if (jComponent3 instanceof Scrollable) {
                jComponent3 = new HomeScrollPane(jComponent3);
            }
            if (serializable4 != null) {
                jComponent = new JSplitPane(0, (Component)serializable4, jComponent3);
                jComponent.setMinimumSize(new Dimension());
                this.configureSplitPane((JSplitPane)jComponent, home, PLAN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY, 0.5, false, homeController);
            } else {
                jComponent = jComponent3;
            }
            serializable3 = (Boolean)home.getVisualProperty(jComponent3.getClass().getName() + DETACHED_VIEW_VISUAL_PROPERTY);
            if (serializable3 != null && ((Boolean)serializable3).booleanValue()) {
                serializable2 = (Integer)this.home.getVisualProperty(jComponent3.getClass().getName() + DETACHED_VIEW_X_VISUAL_PROPERTY);
                serializable = (Integer)this.home.getVisualProperty(jComponent3.getClass().getName() + DETACHED_VIEW_Y_VISUAL_PROPERTY);
                if (serializable2 != null) {
                    for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                        for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                            if (!graphicsConfiguration.getBounds().contains((int)serializable2, (Integer)serializable)) continue;
                            EventQueue.invokeLater(new Runnable((Integer)serializable2, (Integer)serializable, home){
                                final /* synthetic */ Integer val$dialogX;
                                final /* synthetic */ Integer val$dialogY;
                                final /* synthetic */ Home val$home;
                                {
                                    this.val$dialogX = n;
                                    this.val$dialogY = n2;
                                    this.val$home = home;
                                }

                                public void run() {
                                    View view = homeController.getHomeController3D().getView();
                                    HomePane.this.detachView(view, this.val$dialogX, this.val$dialogY, (Integer)this.val$home.getVisualProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_WIDTH_VISUAL_PROPERTY), (Integer)this.val$home.getVisualProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY));
                                }
                            });
                            return jComponent;
                        }
                    }
                }
                if (jComponent instanceof JSplitPane) {
                    ((JSplitPane)jComponent).setDividerLocation(0.5);
                }
                homeController.setVisualProperty(jComponent3.getClass().getName() + DETACHED_VIEW_X_VISUAL_PROPERTY, null);
            }
            return jComponent;
        }
        return serializable4;
    }

    private void setPlanRulersVisible(JScrollPane jScrollPane, HomeController homeController, boolean bl) {
        if (bl) {
            jScrollPane.setColumnHeaderView((JComponent)((Object)homeController.getPlanController().getHorizontalRulerView()));
            jScrollPane.setRowHeaderView((JComponent)((Object)homeController.getPlanController().getVerticalRulerView()));
        } else {
            jScrollPane.setColumnHeaderView(null);
            jScrollPane.setRowHeaderView(null);
        }
    }

    private void disableMenuItemsDuringDragAndDrop(View view, final JMenuBar jMenuBar) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MouseAndFocusListener
        extends MouseAdapter
        implements FocusListener {
            MouseAndFocusListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = jMenuBar.getMenuCount();
                        for (int i = 0; i < n; ++i) {
                            this.setMenuItemsEnabled(jMenuBar.getMenu(i), false);
                        }
                    }
                });
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.enableMenuItems(jMenuBar);
            }

            private void enableMenuItems(final JMenuBar jMenuBar2) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = jMenuBar2.getMenuCount();
                        for (int i = 0; i < n; ++i) {
                            this.setMenuItemsEnabled(jMenuBar2.getMenu(i), true);
                        }
                    }
                });
            }

            private void setMenuItemsEnabled(JMenu jMenu, boolean bl) {
                int n = jMenu.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = jMenu.getItem(i);
                    if (jMenuItem instanceof JMenu) {
                        this.setMenuItemsEnabled((JMenu)jMenuItem, bl);
                        continue;
                    }
                    if (jMenuItem == null) continue;
                    jMenuItem.setEnabled(bl ? jMenuItem.getAction().isEnabled() : false);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.enableMenuItems(jMenuBar);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                this.enableMenuItems(jMenuBar);
            }
        }
        MouseAndFocusListener mouseAndFocusListener = new MouseAndFocusListener();
        if (view != null) {
            ((JComponent)((Object)view)).addMouseListener(mouseAndFocusListener);
            ((JComponent)((Object)view)).addFocusListener(mouseAndFocusListener);
        }
    }

    @Override
    public void detachView(View view) {
        Serializable serializable;
        JComponent jComponent = (JComponent)((Object)view);
        Container container = jComponent.getParent();
        if (container instanceof JViewport) {
            jComponent = (JComponent)container.getParent();
            container = jComponent.getParent();
        }
        float f = container instanceof JSplitPane ? (((JSplitPane)(serializable = (JSplitPane)container)).getOrientation() == 0 ? (float)((JSplitPane)serializable).getDividerLocation() / (float)(((JComponent)serializable).getHeight() - ((JSplitPane)serializable).getDividerSize()) : (float)((JSplitPane)serializable).getDividerLocation() / (float)(((JComponent)serializable).getWidth() - ((JSplitPane)serializable).getDividerSize())) : -1.0f;
        serializable = (Integer)this.home.getVisualProperty(view.getClass().getName() + DETACHED_VIEW_X_VISUAL_PROPERTY);
        Integer n = (Integer)this.home.getVisualProperty(view.getClass().getName() + DETACHED_VIEW_WIDTH_VISUAL_PROPERTY);
        if (serializable != null && n != null) {
            this.detachView(view, (Integer)serializable, (Integer)this.home.getVisualProperty(view.getClass().getName() + DETACHED_VIEW_Y_VISUAL_PROPERTY), n, (Integer)this.home.getVisualProperty(view.getClass().getName() + DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY));
        } else {
            Point point = new Point();
            Dimension dimension = jComponent.getSize();
            SwingUtilities.convertPointToScreen(point, jComponent);
            Insets insets = new JDialog().getInsets();
            this.detachView(view, point.x - insets.left, point.y - insets.top, dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        this.controller.setVisualProperty(view.getClass().getName() + DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY, Float.valueOf(f));
    }

    private void detachView(final View view, int n, int n2, int n3, int n4) {
        Container container;
        JComponent jComponent = (JComponent)((Object)view);
        Container container2 = jComponent.getParent();
        if (container2 instanceof JViewport) {
            jComponent = (JComponent)container2.getParent();
            container2 = jComponent.getParent();
        }
        JLabel jLabel = new JLabel();
        jLabel.setMaximumSize(new Dimension());
        jLabel.setName(view.getClass().getName());
        jLabel.setBorder(jComponent.getBorder());
        if (container2 instanceof JSplitPane) {
            container = (JSplitPane)container2;
            container.setDividerSize(0);
            if (container.getLeftComponent() == jComponent) {
                container.setLeftComponent(jLabel);
                container.setDividerLocation(0.0);
            } else {
                container.setRightComponent(jLabel);
                container.setDividerLocation(1.0);
            }
        } else {
            int n5 = container2.getComponentZOrder(jComponent);
            container2.remove(n5);
            container2.add((Component)jLabel, n5);
        }
        container = SwingUtilities.getWindowAncestor(this);
        if (!(container instanceof JFrame)) {
            container = JOptionPane.getRootFrame();
        }
        JFrame jFrame = (JFrame)container;
        final JDialog jDialog = new JDialog(jFrame, jFrame.getTitle(), false, jComponent.getGraphicsConfiguration());
        jDialog.setResizable(true);
        jFrame.addPropertyChangeListener("title", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jDialog.setTitle((String)propertyChangeEvent.getNewValue());
            }
        });
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            jFrame.getRootPane().addPropertyChangeListener("Window.documentModified", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jDialog.getRootPane().putClientProperty("Window.documentModified", propertyChangeEvent.getNewValue());
                }
            });
        } else if (OperatingSystem.isMacOSX()) {
            jFrame.getRootPane().addPropertyChangeListener("windowModified", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jDialog.getRootPane().putClientProperty("windowModified", propertyChangeEvent.getNewValue());
                }
            });
        }
        jDialog.setContentPane(jComponent);
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HomePane.this.controller.attachView(view);
            }
        });
        jDialog.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                HomePane.this.controller.setVisualProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_WIDTH_VISUAL_PROPERTY, jDialog.getWidth());
                HomePane.this.controller.setVisualProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY, jDialog.getHeight());
            }

            public void componentMoved(ComponentEvent componentEvent) {
                HomePane.this.controller.setVisualProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_X_VISUAL_PROPERTY, jDialog.getX());
                HomePane.this.controller.setVisualProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_Y_VISUAL_PROPERTY, jDialog.getY());
            }
        });
        jDialog.setBounds(n, n2, n3, n4);
        jDialog.setVisible(true);
        this.controller.setVisualProperty(view.getClass().getName() + DETACHED_VIEW_VISUAL_PROPERTY, true);
    }

    @Override
    public void attachView(View view) {
        this.controller.setVisualProperty(view.getClass().getName() + DETACHED_VIEW_VISUAL_PROPERTY, false);
        JComponent jComponent = (JComponent)this.findChild(this, view.getClass().getName());
        if (jComponent != null) {
            JComponent jComponent2 = (JComponent)((Object)view);
            Window window = SwingUtilities.getWindowAncestor(jComponent2);
            jComponent2.setBorder(jComponent.getBorder());
            Container container = jComponent.getParent();
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                float f = ((Float)this.home.getVisualProperty(view.getClass().getName() + DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY)).floatValue();
                jSplitPane.setDividerSize(UIManager.getInt("SplitPane.dividerSize"));
                jSplitPane.setDividerLocation(f);
                if (jSplitPane.getLeftComponent() == jComponent) {
                    jSplitPane.setLeftComponent(jComponent2);
                } else {
                    jSplitPane.setRightComponent(jComponent2);
                }
            } else {
                int n = container.getComponentZOrder(jComponent);
                container.remove(n);
                container.add((Component)jComponent2, n);
            }
            window.dispose();
        }
    }

    private Component findChild(Container container, String string) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (string.equals(component.getName())) {
                return component;
            }
            if (!(component instanceof Container) || (component = this.findChild((Container)component, string)) == null) continue;
            return component;
        }
        return null;
    }

    @Override
    public String showOpenDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "openHomeDialog.title", new Object[0]), ContentManager.ContentType.SWEET_HOME_3D);
    }

    @Override
    public boolean confirmReplaceLanguageLibrary(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.message", new File(string).getName());
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.doNotReplace", new Object[0]);
        return JOptionPane.showOptionDialog(this, string2, string3, 2, 3, null, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public String showImportFurnitureLibraryDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "importFurnitureLibraryDialog.title", new Object[0]), ContentManager.ContentType.FURNITURE_LIBRARY);
    }

    @Override
    public boolean confirmReplaceFurnitureLibrary(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.message", new File(string).getName());
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.doNotReplace", new Object[0]);
        return JOptionPane.showOptionDialog(this, string2, string3, 2, 3, null, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public String showImportTexturesLibraryDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "importTexturesLibraryDialog.title", new Object[0]), ContentManager.ContentType.TEXTURES_LIBRARY);
    }

    @Override
    public boolean confirmReplaceTexturesLibrary(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.message", new File(string).getName());
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.doNotReplace", new Object[0]);
        return JOptionPane.showOptionDialog(this, string2, string3, 2, 3, null, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public boolean confirmReplacePlugin(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.message", new File(string).getName());
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.doNotReplace", new Object[0]);
        return JOptionPane.showOptionDialog(this, string2, string3, 2, 3, null, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public String showSaveDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "saveHomeDialog.title", new Object[0]), ContentManager.ContentType.SWEET_HOME_3D, string);
    }

    @Override
    public void showError(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "error.title", new Object[0]);
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    @Override
    public void showMessage(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "message.title", new Object[0]);
        JOptionPane.showMessageDialog(this, string, string2, 1);
    }

    @Override
    public boolean showActionTipMessage(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, string + ".tipTitle", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, string + ".tipMessage", new Object[0]);
        if (string3.length() > 0) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            JLabel jLabel = new JLabel(string3);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 10, 0), 0, 0));
            JCheckBox jCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(this.preferences, HomePane.class, "doNotDisplayTipCheckBox.text", new Object[0]));
            if (!OperatingSystem.isMacOSX()) {
                jCheckBox.setMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(HomePane.class, "doNotDisplayTipCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            SwingTools.showMessageDialog(this, jPanel, string2, 1, jCheckBox);
            return jCheckBox.isSelected();
        }
        return true;
    }

    @Override
    public HomeView.SaveAnswer confirmSave(String string) {
        String string2 = string != null ? this.preferences.getLocalizedString(HomePane.class, "confirmSave.message", "\"" + this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.SWEET_HOME_3D) + "\"") : this.preferences.getLocalizedString(HomePane.class, "confirmSave.message", "");
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.save", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.doNotSave", new Object[0]);
        String string6 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.cancel", new Object[0]);
        switch (JOptionPane.showOptionDialog(this, string2, string3, 1, 3, null, new Object[]{string4, string5, string6}, string4)) {
            case 0: {
                return HomeView.SaveAnswer.SAVE;
            }
            case 1: {
                return HomeView.SaveAnswer.DO_NOT_SAVE;
            }
        }
        return HomeView.SaveAnswer.CANCEL;
    }

    @Override
    public boolean confirmSaveNewerHome(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.message", this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.SWEET_HOME_3D));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.save", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.doNotSave", new Object[0]);
        return JOptionPane.showOptionDialog(this, string2, string3, 0, 3, null, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public boolean confirmExit() {
        String string = this.preferences.getLocalizedString(HomePane.class, "confirmExit.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmExit.title", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmExit.quit", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmExit.doNotQuit", new Object[0]);
        return JOptionPane.showOptionDialog(this, string, string2, 0, 3, null, new Object[]{string3, string4}, string4) == 0;
    }

    @Override
    public void showAboutDialog() {
        Object object;
        String string = this.preferences.getLocalizedString(HomePane.class, "about.message", new Object[0]);
        String string2 = this.controller.getVersion();
        String string3 = String.format(string, string2, System.getProperty("java.version"));
        JEditorPane jEditorPane = new JEditorPane("text/html", string3);
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        try {
            object = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            if (object.isWebBrowserSupported()) {
                jEditorPane.addHyperlinkListener(new HyperlinkListener((BasicService)object){
                    final /* synthetic */ BasicService val$service;
                    {
                        this.val$service = basicService;
                    }

                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            this.val$service.showDocument(hyperlinkEvent.getURL());
                        }
                    }
                });
            }
        }
        catch (UnavailableServiceException unavailableServiceException) {
            // empty catch block
        }
        object = this.preferences.getLocalizedString(HomePane.class, "about.title", new Object[0]);
        ImageIcon imageIcon = new ImageIcon(HomePane.class.getResource(this.preferences.getLocalizedString(HomePane.class, "about.icon", new Object[0])));
        JOptionPane.showMessageDialog(this, jEditorPane, (String)object, 1, imageIcon);
    }

    @Override
    public Callable<Void> showPrintDialog() {
        PageFormat pageFormat = HomePrintableComponent.getPageFormat(this.home.getPrint());
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new HomePrintableComponent(this.home, this.controller, this.getFont()), pageFormat);
        String string = this.preferences.getLocalizedString(HomePane.class, "print.jobName", new Object[0]);
        if (this.home.getName() != null) {
            string = string + " - " + this.controller.getContentManager().getPresentationName(this.home.getName(), ContentManager.ContentType.SWEET_HOME_3D);
        }
        printerJob.setJobName(string);
        if (printerJob.printDialog()) {
            return new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    try {
                        printerJob.print();
                        return null;
                    }
                    catch (InterruptedPrinterException interruptedPrinterException) {
                        throw new InterruptedRecorderException("Print interrupted");
                    }
                    catch (PrinterException printerException) {
                        throw new RecorderException("Couldn't print", printerException);
                    }
                }
            };
        }
        return null;
    }

    @Override
    public String showPrintToPDFDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "printToPDFDialog.title", new Object[0]), ContentManager.ContentType.PDF, string);
    }

    @Override
    public void printToPDF(String string) throws RecorderException {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(string);
            new HomePDFPrinter(this.home, this.preferences, this.controller, this.getFont()).write(fileOutputStream);
        }
        catch (InterruptedIOException interruptedIOException) {
            bl = true;
            throw new InterruptedRecorderException("Print interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't export to PDF", iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                if (bl) {
                    new File(string).delete();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Couldn't export to PDF", iOException);
            }
        }
    }

    @Override
    public String showExportToSVGDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "exportToSVGDialog.title", new Object[0]), ContentManager.ContentType.SVG, string);
    }

    @Override
    public void exportToSVG(String string) throws RecorderException {
        PlanView planView = this.controller.getPlanController().getView();
        PlanComponent planComponent = planView instanceof PlanComponent ? (PlanComponent)planView : new PlanComponent(this.home, this.preferences, null);
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string));
            planComponent.exportToSVG(outputStream);
        }
        catch (InterruptedIOException interruptedIOException) {
            bl = true;
            throw new InterruptedRecorderException("Export to " + string + " interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't export to SVG in " + string, iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    if (bl) {
                        new File(string).delete();
                    }
                }
                catch (IOException iOException) {
                    throw new RecorderException("Couldn't export to SVG in " + string, iOException);
                }
            }
        }
    }

    @Override
    public String showExportToOBJDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "exportToOBJDialog.title", new Object[0]), ContentManager.ContentType.OBJ, string);
    }

    @Override
    public void exportToOBJ(String string) throws RecorderException {
        String string2 = this.preferences != null ? this.preferences.getLocalizedString(HomePane.class, "exportToOBJ.header", new Date()) : "";
        OBJExporter.exportHomeToFile(this.home.clone(), string, string2);
    }

    @Override
    public boolean confirmDeleteCatalogSelection() {
        String string = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.title", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.delete", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.cancel", new Object[0]);
        return JOptionPane.showOptionDialog(this, string, string2, 2, 3, null, new Object[]{string3, string4}, string4) == 0;
    }

    @Override
    public String showStoreCameraDialog(String string) {
        Object object;
        JComponent jComponent;
        JTextComponent jTextComponent;
        String string2 = this.preferences.getLocalizedString(HomePane.class, "showStoreCameraDialog.message", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, "showStoreCameraDialog.title", new Object[0]);
        List<Camera> list = this.home.getStoredCameras();
        if (list.isEmpty()) {
            jTextComponent = new JTextField(string, 20);
            jComponent = jTextComponent;
        } else {
            object = new String[list.size()];
            for (int i = 0; i < ((String[])object).length; ++i) {
                object[i] = list.get(i).getName();
            }
            JComboBox<String> jComboBox = new JComboBox<String>((E[])object);
            jComboBox.setEditable(true);
            jComboBox.getEditor().setItem(string);
            Component component = jComboBox.getEditor().getEditorComponent();
            if (component instanceof JTextComponent) {
                jTextComponent = (JTextComponent)component;
                jComponent = jComboBox;
            } else {
                jTextComponent = new JTextField(string, 20);
                jComponent = jTextComponent;
            }
        }
        object = new JPanel(new BorderLayout(2, 2));
        ((Container)object).add((Component)new JLabel(string2), "North");
        ((Container)object).add((Component)jComponent, "South");
        if (SwingTools.showConfirmDialog(this, (JComponent)object, string3, jTextComponent) == 0) {
            return jTextComponent.getText();
        }
        return null;
    }

    @Override
    public boolean isClipboardEmpty() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        return !clipboard.isDataFlavorAvailable(HomeTransferableList.HOME_FLAVOR) && !this.getToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.javaFileListFlavor);
    }

    @Override
    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    private static class HomeScrollPane
    extends JScrollPane {
        public HomeScrollPane(JComponent jComponent) {
            super(jComponent);
            if (OperatingSystem.isMacOSX()) {
                this.setHorizontalScrollBarPolicy(32);
                this.setVerticalScrollBarPolicy(22);
            }
            SwingTools.installFocusBorder(jComponent);
            this.setMinimumSize(new Dimension());
        }
    }

    private class ActionAdapter
    implements Action {
        private PluginAction pluginAction;
        private SwingPropertyChangeSupport propertyChangeSupport;

        private ActionAdapter(PluginAction pluginAction) {
            this.pluginAction = pluginAction;
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
            this.pluginAction.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = ActionAdapter.this.getValue(string);
                    if (PluginAction.Property.ENABLED.name().equals(string)) {
                        ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "enabled", object, object2));
                    } else if (object2 != null) {
                        if (PluginAction.Property.NAME.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "Name", object, object2));
                        } else if (PluginAction.Property.SHORT_DESCRIPTION.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "Name", object, object2));
                        } else if (PluginAction.Property.MNEMONIC.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "MnemonicKey", object != null ? new Integer(((Character)object).charValue()) : null, object2));
                        } else if (PluginAction.Property.SMALL_ICON.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "SmallIcon", object != null ? IconManager.getInstance().getIcon((Content)object, 16, HomePane.this) : null, object2));
                        } else {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), string, object, object2));
                        }
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pluginAction.execute();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.NAME);
            }
            if ("ShortDescription".equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.SHORT_DESCRIPTION);
            }
            if ("SmallIcon".equals(string)) {
                Content content = (Content)this.pluginAction.getPropertyValue(PluginAction.Property.SMALL_ICON);
                return content != null ? IconManager.getInstance().getIcon(content, 16, HomePane.this) : null;
            }
            if ("MnemonicKey".equals(string)) {
                Character c = (Character)this.pluginAction.getPropertyValue(PluginAction.Property.MNEMONIC);
                return c != null ? new Integer(c.charValue()) : null;
            }
            if (PluginAction.Property.TOOL_BAR.name().equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.TOOL_BAR);
            }
            if (PluginAction.Property.MENU.name().equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.MENU);
            }
            return null;
        }

        public void putValue(String string, Object object) {
            if ("Name".equals(string)) {
                this.pluginAction.putPropertyValue(PluginAction.Property.NAME, object);
            } else if ("ShortDescription".equals(string)) {
                this.pluginAction.putPropertyValue(PluginAction.Property.SHORT_DESCRIPTION, object);
            } else if (!"SmallIcon".equals(string)) {
                if ("MnemonicKey".equals(string)) {
                    this.pluginAction.putPropertyValue(PluginAction.Property.MNEMONIC, new Character((char)((Integer)object).intValue()));
                } else if (PluginAction.Property.TOOL_BAR.name().equals(string)) {
                    this.pluginAction.putPropertyValue(PluginAction.Property.TOOL_BAR, object);
                } else if (PluginAction.Property.MENU.name().equals(string)) {
                    this.pluginAction.putPropertyValue(PluginAction.Property.MENU, object);
                }
            }
        }

        public boolean isEnabled() {
            return this.pluginAction.isEnabled();
        }

        public void setEnabled(boolean bl) {
            this.pluginAction.setEnabled(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OBJExporter {
        private OBJExporter() {
        }

        public static void exportHomeToFile(Home home, String string, String string2) throws RecorderException {
            OBJWriter oBJWriter = null;
            boolean bl = false;
            try {
                Object3DBranch object3DBranch;
                oBJWriter = new OBJWriter(string, string2, -1);
                List list = Collections.emptyList();
                home.setSelectedItems(list);
                if (home.getWalls().size() > 0) {
                    Rectangle2D rectangle2D = OBJExporter.getExportedHomeBounds(home);
                    Ground3D ground3D = new Ground3D(home, (float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight(), true);
                    oBJWriter.writeNode((Node)ground3D, "ground");
                }
                int n = 0;
                for (Wall selectable : home.getWalls()) {
                    object3DBranch = new Wall3D(selectable, home, true, true);
                    oBJWriter.writeNode((Node)object3DBranch, "wall_" + ++n);
                }
                n = 0;
                for (HomePieceOfFurniture homePieceOfFurniture : home.getFurniture()) {
                    if (!homePieceOfFurniture.isVisible()) continue;
                    object3DBranch = new HomePieceOfFurniture3D(homePieceOfFurniture, home, true, true);
                    oBJWriter.writeNode((Node)object3DBranch);
                }
                n = 0;
                for (Room room : home.getRooms()) {
                    object3DBranch = new Room3D(room, home, false, true, true);
                    oBJWriter.writeNode((Node)object3DBranch, "room_" + ++n);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                bl = true;
                throw new InterruptedRecorderException("Export to " + string + " interrupted");
            }
            catch (IOException iOException) {
                throw new RecorderException("Couldn't export to OBJ in " + string, iOException);
            }
            finally {
                if (oBJWriter != null) {
                    try {
                        oBJWriter.close();
                        if (bl) {
                            new File(string).delete();
                        }
                    }
                    catch (IOException iOException) {
                        throw new RecorderException("Couldn't export to OBJ in " + string, iOException);
                    }
                }
            }
        }

        private static Rectangle2D getExportedHomeBounds(Home home) {
            Rectangle2D rectangle2D = OBJExporter.updateObjectsBounds(null, home.getWalls());
            for (HomePieceOfFurniture homePieceOfFurniture : OBJExporter.getVisibleFurniture(home.getFurniture())) {
                if (!homePieceOfFurniture.isVisible()) continue;
                for (float[] fArray : homePieceOfFurniture.getPoints()) {
                    if (rectangle2D == null) {
                        rectangle2D = new Rectangle2D.Float(fArray[0], fArray[1], 0.0f, 0.0f);
                        continue;
                    }
                    rectangle2D.add(fArray[0], fArray[1]);
                }
            }
            return OBJExporter.updateObjectsBounds(rectangle2D, home.getRooms());
        }

        private static List<HomePieceOfFurniture> getVisibleFurniture(List<HomePieceOfFurniture> list) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!homePieceOfFurniture.isVisible()) continue;
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    arrayList.addAll(OBJExporter.getVisibleFurniture(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                    continue;
                }
                arrayList.add(homePieceOfFurniture);
            }
            return arrayList;
        }

        private static Rectangle2D updateObjectsBounds(Rectangle2D rectangle2D, Collection<? extends Selectable> collection) {
            for (Selectable selectable : collection) {
                for (float[] fArray : selectable.getPoints()) {
                    if (rectangle2D == null) {
                        rectangle2D = new Rectangle2D.Float(fArray[0], fArray[1], 0.0f, 0.0f);
                        continue;
                    }
                    rectangle2D.add(fArray[0], fArray[1]);
                }
            }
            return rectangle2D;
        }
    }

    private static class RulersVisibilityChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private WeakReference<JScrollPane> planScrollPane;
        private WeakReference<HomeController> controller;

        public RulersVisibilityChangeListener(HomePane homePane, JScrollPane jScrollPane, HomeController homeController) {
            this.homePane = new WeakReference<HomePane>(homePane);
            this.planScrollPane = new WeakReference<JScrollPane>(jScrollPane);
            this.controller = new WeakReference<HomeController>(homeController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            JScrollPane jScrollPane = (JScrollPane)this.planScrollPane.get();
            HomeController homeController = (HomeController)this.controller.get();
            if (homePane == null || jScrollPane == null || homeController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.RULERS_VISIBLE, this);
            } else {
                homePane.setPlanRulersVisible(jScrollPane, homeController, (Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class FurnitureCatalogViewChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private WeakReference<JComponent> furnitureCatalogView;

        public FurnitureCatalogViewChangeListener(HomePane homePane, JComponent jComponent) {
            this.homePane = new WeakReference<HomePane>(homePane);
            this.furnitureCatalogView = new WeakReference<JComponent>(jComponent);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            if (homePane == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, this);
            } else {
                JComponent jComponent = (JComponent)this.furnitureCatalogView.get();
                if (jComponent != null) {
                    JComponent jComponent2 = (JComponent)((Object)homePane.controller.getFurnitureCatalogController().getView());
                    jComponent2.setComponentPopupMenu(jComponent.getComponentPopupMenu());
                    TransferHandler transferHandler = jComponent.getTransferHandler();
                    jComponent2.setTransferHandler(transferHandler);
                    JComponent jComponent3 = jComponent2;
                    jComponent3 = jComponent2 instanceof Scrollable ? new HomeScrollPane(jComponent2) : jComponent2;
                    ((JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, jComponent)).setTopComponent(jComponent3);
                    this.furnitureCatalogView = new WeakReference<JComponent>(jComponent2);
                }
            }
        }
    }

    private static class FocusCycleRootChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private PropertyChangeListener focusChangeListener;

        public FocusCycleRootChangeListener(HomePane homePane) {
            this.homePane = new WeakReference<HomePane>(homePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            final HomePane homePane = (HomePane)this.homePane.get();
            if (homePane == null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("currentFocusCycleRoot", this);
            } else if (SwingUtilities.isDescendingFrom(homePane, (Component)propertyChangeEvent.getOldValue())) {
                this.focusChangeListener = null;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusChangeListener);
            } else if (SwingUtilities.isDescendingFrom(homePane, (Component)propertyChangeEvent.getNewValue())) {
                this.focusChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Component component;
                        if (homePane.lastFocusedComponent != null && SwingUtilities.isDescendingFrom(component = homePane.lastFocusedComponent, SwingUtilities.getWindowAncestor(homePane))) {
                            component.removeKeyListener(homePane.specialKeysListener);
                            if (homePane.previousPlanControllerMode != null && (component == homePane.controller.getPlanController().getView() || propertyChangeEvent.getNewValue() == null)) {
                                homePane.controller.getPlanController().setMode(homePane.previousPlanControllerMode);
                                homePane.previousPlanControllerMode = null;
                            }
                        }
                        if (propertyChangeEvent.getNewValue() != null && SwingUtilities.isDescendingFrom(component = (Component)propertyChangeEvent.getNewValue(), SwingUtilities.getWindowAncestor(homePane)) && component instanceof JComponent) {
                            View[] viewArray;
                            for (View view : viewArray = new View[]{homePane.controller.getFurnitureCatalogController().getView(), homePane.controller.getFurnitureController().getView(), homePane.controller.getPlanController().getView(), homePane.controller.getHomeController3D().getView()}) {
                                if (view == null || !SwingUtilities.isDescendingFrom(component, (JComponent)((Object)view))) continue;
                                homePane.controller.focusedViewChanged(view);
                                component.addKeyListener(homePane.specialKeysListener);
                                homePane.lastFocusedComponent = (JComponent)component;
                                break;
                            }
                        }
                    }
                };
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusChangeListener);
            }
        }
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;

        public LanguageChangeListener(HomePane homePane) {
            this.homePane = new WeakReference<HomePane>(homePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            if (homePane == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                SwingTools.updateSwingResourceLanguage();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MenuActionType {
        FILE_MENU,
        EDIT_MENU,
        FURNITURE_MENU,
        PLAN_MENU,
        VIEW_3D_MENU,
        HELP_MENU,
        OPEN_RECENT_HOME_MENU,
        SORT_HOME_FURNITURE_MENU,
        DISPLAY_HOME_FURNITURE_PROPERTY_MENU,
        MODIFY_TEXT_STYLE,
        GO_TO_POINT_OF_VIEW;

    }
}

