/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.OBJWriter;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardStepsView;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class ImportedFurnitureWizardStepsPanel
extends JPanel
implements ImportedFurnitureWizardStepsView {
    private final ImportedFurnitureWizardController controller;
    private CardLayout cardLayout;
    private JLabel modelChoiceOrChangeLabel;
    private JButton modelChoiceOrChangeButton;
    private JButton findModelsButton;
    private JLabel modelChoiceErrorLabel;
    private ModelPreviewComponent modelPreviewComponent;
    private JLabel orientationLabel;
    private JButton turnLeftButton;
    private JButton turnRightButton;
    private JButton turnUpButton;
    private JButton turnDownButton;
    private RotationPreviewComponent rotationPreviewComponent;
    private JLabel backFaceShownLabel;
    private JCheckBox backFaceShownCheckBox;
    private JLabel attributesLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JCheckBox addToCatalogCheckBox;
    private JLabel categoryLabel;
    private JComboBox categoryComboBox;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel depthLabel;
    private JSpinner depthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox keepProportionsCheckBox;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private AttributesPreviewComponent attributesPreviewComponent;
    private JCheckBox movableCheckBox;
    private JCheckBox doorOrWindowCheckBox;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private JButton clearColorButton;
    private JLabel iconLabel;
    private IconPreviewComponent iconPreviewComponent;
    private Cursor defaultCursor;
    private Executor modelLoader;

    public ImportedFurnitureWizardStepsPanel(CatalogPieceOfFurniture catalogPieceOfFurniture, String string, boolean bl, UserPreferences userPreferences, final ImportedFurnitureWizardController importedFurnitureWizardController) {
        this.controller = importedFurnitureWizardController;
        this.modelLoader = Executors.newSingleThreadExecutor();
        this.createComponents(bl, userPreferences, importedFurnitureWizardController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        this.updateController(catalogPieceOfFurniture, userPreferences);
        if (string != null) {
            this.updateController(string, userPreferences, importedFurnitureWizardController.getContentManager(), bl ? null : userPreferences.getFurnitureCatalog().getCategories().get(0), true);
        }
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.STEP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.updateStep(importedFurnitureWizardController);
            }
        });
    }

    private void createComponents(boolean bl, final UserPreferences userPreferences, final ImportedFurnitureWizardController importedFurnitureWizardController) {
        String string = userPreferences.getLengthUnit().getName();
        this.modelChoiceOrChangeLabel = new JLabel();
        this.modelChoiceOrChangeButton = new JButton();
        final FurnitureCategory furnitureCategory = bl || userPreferences.getFurnitureCatalog().getCategories().size() == 0 ? null : userPreferences.getFurnitureCatalog().getCategories().get(0);
        this.modelChoiceOrChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImportedFurnitureWizardStepsPanel.this.showModelChoiceDialog(userPreferences, importedFurnitureWizardController.getContentManager());
                if (string != null) {
                    ImportedFurnitureWizardStepsPanel.this.updateController(string, userPreferences, importedFurnitureWizardController.getContentManager(), furnitureCategory, false);
                }
            }
        });
        this.findModelsButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "findModelsButton.text", new Object[0]));
        BasicService basicService = null;
        try {
            basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            if (!basicService.isWebBrowserSupported()) {
                basicService = null;
            }
        }
        catch (UnavailableServiceException unavailableServiceException) {
            // empty catch block
        }
        final BasicService basicService2 = basicService;
        this.findModelsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                boolean bl = false;
                if (basicService2 != null) {
                    try {
                        serializable = new URL(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsButton.url", new Object[0]));
                        bl = basicService2.showDocument((URL)serializable);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    serializable = new JTextArea(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsMessage.text", new Object[0]));
                    String string = userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsMessage.title", new Object[0]);
                    ((JTextComponent)serializable).setEditable(false);
                    ((JComponent)serializable).setOpaque(false);
                    JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), serializable, string, 1);
                }
            }
        });
        this.modelChoiceErrorLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceErrorLabel.text", new Object[0]));
        this.modelChoiceErrorLabel.setVisible(false);
        this.modelPreviewComponent = new ModelPreviewComponent();
        this.modelPreviewComponent.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                boolean bl = true;
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    final String string = ((File)list.get(0)).getAbsolutePath();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ImportedFurnitureWizardStepsPanel.this.updateController(string, userPreferences, importedFurnitureWizardController.getContentManager(), furnitureCategory, false);
                        }
                    });
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceError", new Object[0]));
                        }
                    });
                }
                return bl;
            }
        });
        this.modelPreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
        this.orientationLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "orientationLabel.text", new Object[0]));
        this.turnLeftButton = new JButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_LEFT", true){

            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                transform3D2.rotY(-1.5707963267948966);
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
            }
        });
        this.turnRightButton = new JButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_RIGHT", true){

            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                transform3D2.rotY(1.5707963267948966);
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
            }
        });
        this.turnUpButton = new JButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_UP", true){

            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                transform3D2.rotX(-1.5707963267948966);
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
            }
        });
        this.turnDownButton = new JButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_DOWN", true){

            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                transform3D2.rotX(1.5707963267948966);
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
            }
        });
        this.backFaceShownLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "backFaceShownLabel.text", new Object[0]));
        this.backFaceShownCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "backFaceShownCheckBox.text", new Object[0]));
        this.backFaceShownCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setBackFaceShown(ImportedFurnitureWizardStepsPanel.this.backFaceShownCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.backFaceShownCheckBox.setSelected(importedFurnitureWizardController.isBackFaceShown());
            }
        });
        this.rotationPreviewComponent = new RotationPreviewComponent(userPreferences, importedFurnitureWizardController);
        this.attributesLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "attributesLabel.text", new Object[0]));
        this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "nameLabel.text", new Object[0]));
        this.nameTextField = new JTextField(10);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
        }
        final Color color = this.nameTextField.getForeground();
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ImportedFurnitureWizardStepsPanel.this.nameTextField.getDocument().removeDocumentListener(this);
                importedFurnitureWizardController.setName(ImportedFurnitureWizardStepsPanel.this.nameTextField.getText().trim());
                ImportedFurnitureWizardStepsPanel.this.nameTextField.getDocument().addDocumentListener(this);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.NAME, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ImportedFurnitureWizardStepsPanel.this.nameTextField.getText().trim().equals(importedFurnitureWizardController.getName())) {
                    ImportedFurnitureWizardStepsPanel.this.nameTextField.setText(importedFurnitureWizardController.getName());
                }
                ImportedFurnitureWizardStepsPanel.this.updateNameTextFieldForeground(color);
            }
        });
        this.addToCatalogCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "addToCatalogCheckBox.text", new Object[0]));
        this.addToCatalogCheckBox.setVisible(bl);
        this.addToCatalogCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (ImportedFurnitureWizardStepsPanel.this.addToCatalogCheckBox.isSelected()) {
                    ImportedFurnitureWizardStepsPanel.this.categoryComboBox.setEnabled(true);
                    importedFurnitureWizardController.setCategory((FurnitureCategory)ImportedFurnitureWizardStepsPanel.this.categoryComboBox.getSelectedItem());
                } else {
                    ImportedFurnitureWizardStepsPanel.this.categoryComboBox.setEnabled(false);
                    importedFurnitureWizardController.setCategory(null);
                }
            }
        });
        this.categoryLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "categoryLabel.text", new Object[0]));
        this.categoryComboBox = new JComboBox<Object>(userPreferences.getFurnitureCatalog().getCategories().toArray());
        this.categoryComboBox.setEnabled(!bl);
        this.categoryComboBox.setEditable(true);
        final ComboBoxEditor comboBoxEditor = this.categoryComboBox.getEditor();
        this.categoryComboBox.setEditor(new ComboBoxEditor(){

            public Object getItem() {
                String string = (String)comboBoxEditor.getItem();
                if ((string = string.trim()).length() == 0) {
                    this.setItem(ImportedFurnitureWizardStepsPanel.this.categoryComboBox.getSelectedItem());
                }
                FurnitureCategory furnitureCategory = new FurnitureCategory(string);
                List<FurnitureCategory> list = userPreferences.getFurnitureCatalog().getCategories();
                int n = Collections.binarySearch(list, furnitureCategory);
                if (n >= 0) {
                    return list.get(n);
                }
                return furnitureCategory;
            }

            public void setItem(Object object) {
                if (object != null) {
                    FurnitureCategory furnitureCategory = (FurnitureCategory)object;
                    comboBoxEditor.setItem(furnitureCategory.getName());
                }
            }

            public void addActionListener(ActionListener actionListener) {
                comboBoxEditor.addActionListener(actionListener);
            }

            public Component getEditorComponent() {
                return comboBoxEditor.getEditorComponent();
            }

            public void removeActionListener(ActionListener actionListener) {
                comboBoxEditor.removeActionListener(actionListener);
            }

            public void selectAll() {
                comboBoxEditor.selectAll();
            }
        });
        this.categoryComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                FurnitureCategory furnitureCategory = (FurnitureCategory)object;
                return super.getListCellRendererComponent((JList<?>)jList, furnitureCategory.getName(), n, bl, bl2);
            }
        });
        this.categoryComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setCategory((FurnitureCategory)itemEvent.getItem());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.CATEGORY, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureCategory furnitureCategory = importedFurnitureWizardController.getCategory();
                if (furnitureCategory != null) {
                    ImportedFurnitureWizardStepsPanel.this.categoryComboBox.setSelectedItem(furnitureCategory);
                }
                ImportedFurnitureWizardStepsPanel.this.updateNameTextFieldForeground(color);
            }
        });
        if (this.categoryComboBox.getItemCount() > 0) {
            this.categoryComboBox.setSelectedIndex(0);
        }
        this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "widthLabel.text", string));
        final float f = userPreferences.getLengthUnit().getMinimumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, Math.min(importedFurnitureWizardController.getWidth(), f), 100000.0f);
        this.widthSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel.removeChangeListener(this);
                importedFurnitureWizardController.setWidth(nullableSpinnerLengthModel.getLength().floatValue());
                nullableSpinnerLengthModel.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.WIDTH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength(Float.valueOf(importedFurnitureWizardController.getWidth()));
                nullableSpinnerLengthModel.setMinimum(Float.valueOf(Math.min(importedFurnitureWizardController.getWidth(), f)));
            }
        });
        this.depthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "depthLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, Math.min(importedFurnitureWizardController.getDepth(), f), 100000.0f);
        this.depthSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel2.removeChangeListener(this);
                importedFurnitureWizardController.setDepth(nullableSpinnerLengthModel2.getLength().floatValue());
                nullableSpinnerLengthModel2.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.DEPTH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength(Float.valueOf(importedFurnitureWizardController.getDepth()));
                nullableSpinnerLengthModel2.setMinimum(Float.valueOf(Math.min(importedFurnitureWizardController.getDepth(), f)));
            }
        });
        this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "heightLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, Math.min(importedFurnitureWizardController.getHeight(), f), 100000.0f);
        this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel3.removeChangeListener(this);
                importedFurnitureWizardController.setHeight(nullableSpinnerLengthModel3.getLength().floatValue());
                nullableSpinnerLengthModel3.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.HEIGHT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setLength(Float.valueOf(importedFurnitureWizardController.getHeight()));
                nullableSpinnerLengthModel3.setMinimum(Float.valueOf(Math.min(importedFurnitureWizardController.getHeight(), f)));
            }
        });
        this.keepProportionsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.text", new Object[0]));
        this.keepProportionsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setProportional(ImportedFurnitureWizardStepsPanel.this.keepProportionsCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.PROPORTIONAL, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.keepProportionsCheckBox.setSelected(importedFurnitureWizardController.isProportional());
            }
        });
        this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "elevationLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, 2500.0f);
        this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel4);
        nullableSpinnerLengthModel4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel.removeChangeListener(this);
                importedFurnitureWizardController.setElevation(nullableSpinnerLengthModel4.getLength().floatValue());
                nullableSpinnerLengthModel.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.ELEVATION, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel4.setLength(Float.valueOf(importedFurnitureWizardController.getElevation()));
            }
        });
        this.movableCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "movableCheckBox.text", new Object[0]));
        this.movableCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setMovable(ImportedFurnitureWizardStepsPanel.this.movableCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MOVABLE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.movableCheckBox.setSelected(importedFurnitureWizardController.isMovable());
            }
        });
        this.doorOrWindowCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "doorOrWindowCheckBox.text", new Object[0]));
        this.doorOrWindowCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setDoorOrWindow(ImportedFurnitureWizardStepsPanel.this.doorOrWindowCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.DOOR_OR_WINDOW, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = importedFurnitureWizardController.isDoorOrWindow();
                ImportedFurnitureWizardStepsPanel.this.doorOrWindowCheckBox.setSelected(bl);
                ImportedFurnitureWizardStepsPanel.this.movableCheckBox.setEnabled(!bl);
            }
        });
        this.colorLabel = new JLabel(String.format(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "colorLabel.text", new Object[0]), string));
        this.colorButton = new ColorButton();
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                importedFurnitureWizardController.setColor(ImportedFurnitureWizardStepsPanel.this.colorButton.getColor());
            }
        });
        this.clearColorButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "clearColorButton.text", new Object[0]));
        this.clearColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                importedFurnitureWizardController.setColor(null);
            }
        });
        this.clearColorButton.setEnabled(false);
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.colorButton.setColor(importedFurnitureWizardController.getColor());
                ImportedFurnitureWizardStepsPanel.this.clearColorButton.setEnabled(importedFurnitureWizardController.getColor() != null);
            }
        });
        this.attributesPreviewComponent = new AttributesPreviewComponent(importedFurnitureWizardController);
        this.iconLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "iconLabel.text", new Object[0]));
        this.iconPreviewComponent = new IconPreviewComponent(this.controller);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.findModelsButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsButton.mnemonic", new Object[0])).getKeyCode());
            this.backFaceShownCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "backFaceShownCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setLabelFor(this.nameTextField);
            this.categoryLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "categoryLabel.mnemonic", new Object[0])).getKeyCode());
            this.categoryLabel.setLabelFor(this.categoryComboBox);
            this.addToCatalogCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "addToCatalogCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.depthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "depthLabel.mnemonic", new Object[0])).getKeyCode());
            this.depthLabel.setLabelFor(this.depthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
            this.keepProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setLabelFor(this.elevationSpinner);
            this.movableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "movableCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.doorOrWindowCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "doorOrWindowCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.colorLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "colorLabel.mnemonic", new Object[0])).getKeyCode());
            this.colorLabel.setLabelFor(this.colorButton);
            this.clearColorButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "clearColorButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.modelChoiceOrChangeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.modelChoiceOrChangeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 22, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.findModelsButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.modelChoiceErrorLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.modelPreviewComponent, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.orientationLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.rotationPreviewComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 22, 0, new Insets(0, 0, 5, 15), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout()){

            public void applyComponentOrientation(ComponentOrientation componentOrientation) {
            }
        };
        jPanel3.add((Component)this.turnUpButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.turnLeftButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel3.add((Component)this.turnRightButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel3.add((Component)this.turnDownButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)jPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.backFaceShownLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.backFaceShownCheckBox, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.attributesLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
        jPanel4.add((Component)this.attributesPreviewComponent, new GridBagConstraints(0, 1, 1, 13, 1.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel4.add((Component)this.nameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel4.add((Component)this.nameTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.addToCatalogCheckBox, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.categoryLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel4.add((Component)this.categoryComboBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.widthLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel4.add((Component)this.widthSpinner, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.depthLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel4.add((Component)this.depthSpinner, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.heightLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel4.add((Component)this.heightSpinner, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.keepProportionsCheckBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 15, 0), 0, 0));
        jPanel4.add((Component)this.elevationLabel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel4.add((Component)this.elevationSpinner, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.movableCheckBox, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.doorOrWindowCheckBox, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this.colorLabel, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel4.add((Component)this.colorButton, new GridBagConstraints(2, 11, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel4.add((Component)this.clearColorButton, new GridBagConstraints(2, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel4.add((Component)new JLabel(), new GridBagConstraints(1, 13, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
        jPanel5.add((Component)this.iconPreviewComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)jPanel, ImportedFurnitureWizardController.Step.MODEL.name());
        this.add((Component)jPanel2, ImportedFurnitureWizardController.Step.ROTATION.name());
        this.add((Component)jPanel4, ImportedFurnitureWizardController.Step.ATTRIBUTES.name());
        this.add((Component)jPanel5, ImportedFurnitureWizardController.Step.ICON.name());
    }

    public void updateStep(ImportedFurnitureWizardController importedFurnitureWizardController) {
        ImportedFurnitureWizardController.Step step = importedFurnitureWizardController.getStep();
        this.cardLayout.show(this, step.name());
        switch (step) {
            case MODEL: {
                this.modelChoiceOrChangeButton.requestFocusInWindow();
                break;
            }
            case ATTRIBUTES: {
                this.nameTextField.requestFocusInWindow();
            }
        }
    }

    private void updateNameTextFieldForeground(Color color) {
        this.nameTextField.setForeground(this.controller.isPieceOfFurnitureNameValid() ? color : Color.RED);
    }

    private Transform3D getModelRotationTransform() {
        float[][] fArray = this.controller.getModelRotation();
        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
        Transform3D transform3D = new Transform3D();
        transform3D.setRotation(matrix3f);
        return transform3D;
    }

    private void updateModelRotation(Transform3D transform3D) {
        Matrix3f matrix3f = new Matrix3f();
        transform3D.getRotationScale(matrix3f);
        this.controller.setModelRotation(new float[][]{{matrix3f.m00, matrix3f.m01, matrix3f.m02}, {matrix3f.m10, matrix3f.m11, matrix3f.m12}, {matrix3f.m20, matrix3f.m21, matrix3f.m22}});
    }

    private void updateController(final CatalogPieceOfFurniture catalogPieceOfFurniture, final UserPreferences userPreferences) {
        if (catalogPieceOfFurniture == null) {
            this.setModelChoiceTexts(userPreferences);
            this.updatePreviewComponentsModel(null);
        } else {
            this.setModelChangeTexts(userPreferences);
            this.modelLoader.execute(new Runnable(){

                public void run() {
                    BranchGroup branchGroup = null;
                    try {
                        branchGroup = ImportedFurnitureWizardStepsPanel.this.readModel(catalogPieceOfFurniture.getModel());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    final BranchGroup branchGroup2 = branchGroup;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (branchGroup2 != null) {
                                ImportedFurnitureWizardStepsPanel.this.controller.setModel(catalogPieceOfFurniture.getModel());
                                ImportedFurnitureWizardStepsPanel.this.controller.setModelRotation(catalogPieceOfFurniture.getModelRotation());
                                ImportedFurnitureWizardStepsPanel.this.controller.setBackFaceShown(catalogPieceOfFurniture.isBackFaceShown());
                                ImportedFurnitureWizardStepsPanel.this.controller.setName(catalogPieceOfFurniture.getName());
                                ImportedFurnitureWizardStepsPanel.this.controller.setCategory(catalogPieceOfFurniture.getCategory());
                                ImportedFurnitureWizardStepsPanel.this.controller.setWidth(catalogPieceOfFurniture.getWidth());
                                ImportedFurnitureWizardStepsPanel.this.controller.setDepth(catalogPieceOfFurniture.getDepth());
                                ImportedFurnitureWizardStepsPanel.this.controller.setHeight(catalogPieceOfFurniture.getHeight());
                                ImportedFurnitureWizardStepsPanel.this.controller.setMovable(catalogPieceOfFurniture.isMovable());
                                ImportedFurnitureWizardStepsPanel.this.controller.setDoorOrWindow(catalogPieceOfFurniture.isDoorOrWindow());
                                ImportedFurnitureWizardStepsPanel.this.controller.setElevation(catalogPieceOfFurniture.getElevation());
                                ImportedFurnitureWizardStepsPanel.this.controller.setColor(catalogPieceOfFurniture.getColor());
                                ImportedFurnitureWizardStepsPanel.this.controller.setIconYaw(catalogPieceOfFurniture.getIconYaw());
                                ImportedFurnitureWizardStepsPanel.this.controller.setProportional(catalogPieceOfFurniture.isProportional());
                            } else {
                                ImportedFurnitureWizardStepsPanel.this.controller.setModel(null);
                                ImportedFurnitureWizardStepsPanel.this.setModelChoiceTexts(userPreferences);
                                ImportedFurnitureWizardStepsPanel.this.modelChoiceErrorLabel.setVisible(true);
                            }
                        }
                    });
                }
            });
        }
    }

    private void updateController(final String string, final UserPreferences userPreferences, final ContentManager contentManager, final FurnitureCategory furnitureCategory, final boolean bl) {
        this.controller.setModel(null);
        this.modelLoader.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Object object;
                Object object2;
                Object object3;
                Vector3f vector3f;
                BranchGroup branchGroup;
                Content content;
                block25: {
                    content = null;
                    try {
                        content = contentManager.getContent(string);
                    }
                    catch (RecorderException recorderException) {
                        if (!bl) {
                            ImportedFurnitureWizardStepsPanel.this.showModelChoiceError(string, userPreferences);
                        }
                        return;
                    }
                    branchGroup = null;
                    vector3f = null;
                    try {
                        branchGroup = ImportedFurnitureWizardStepsPanel.this.readModel(content);
                        vector3f = ModelManager.getInstance().getSize((Node)branchGroup);
                        content = ImportedFurnitureWizardStepsPanel.this.copyToTemporaryOBJContent(branchGroup, string);
                    }
                    catch (IOException iOException) {
                        branchGroup = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        branchGroup = null;
                    }
                    if (branchGroup == null) {
                        try {
                            content = TemporaryURLContent.copyToTemporaryURLContent(content);
                        }
                        catch (IOException iOException) {
                            if (!bl) {
                                ImportedFurnitureWizardStepsPanel.this.showModelChoiceError(string, userPreferences);
                            }
                            return;
                        }
                        object3 = null;
                        object2 = (URLContent)content;
                        object3 = new ZipInputStream(((URLContent)object2).openStream());
                        while ((object = ((ZipInputStream)object3).getNextEntry()) != null) {
                            try {
                                String string3;
                                String string2 = ((ZipEntry)object).getName();
                                if (string2.endsWith("/")) continue;
                                int n = string2.lastIndexOf(47);
                                if ((string3 = string2.substring(++n)).startsWith(".")) continue;
                                URL uRL = new URL("jar:" + ((URLContent)object2).getURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20").replace("%2F", "/"));
                                content = new TemporaryURLContent(uRL);
                                branchGroup = ImportedFurnitureWizardStepsPanel.this.readModel(content);
                                vector3f = ModelManager.getInstance().getSize((Node)branchGroup);
                                break;
                            }
                            catch (IOException iOException) {
                                branchGroup = null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                branchGroup = null;
                            }
                        }
                        Object var12_18 = null;
                        try {
                            if (object3 != null) {
                                ((ZipInputStream)object3).close();
                            }
                            break block25;
                        }
                        catch (IOException iOException) {}
                        break block25;
                        {
                            catch (IOException iOException) {
                                branchGroup = null;
                                Object var12_19 = null;
                                try {
                                    if (object3 != null) {
                                        ((ZipInputStream)object3).close();
                                    }
                                    break block25;
                                }
                                catch (IOException iOException2) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_20 = null;
                            try {
                                if (object3 != null) {
                                    ((ZipInputStream)object3).close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                object3 = branchGroup;
                object2 = vector3f;
                object = content;
                EventQueue.invokeLater(new Runnable((BranchGroup)object3, (Content)object, (Vector3f)object2){
                    final /* synthetic */ BranchGroup val$readModel;
                    final /* synthetic */ Content val$readContent;
                    final /* synthetic */ Vector3f val$readModelSize;
                    {
                        this.val$readModel = branchGroup;
                        this.val$readContent = content;
                        this.val$readModelSize = vector3f;
                    }

                    public void run() {
                        if (this.val$readModel != null) {
                            ImportedFurnitureWizardStepsPanel.this.controller.setModel(this.val$readContent);
                            ImportedFurnitureWizardStepsPanel.this.setModelChangeTexts(userPreferences);
                            ImportedFurnitureWizardStepsPanel.this.modelChoiceErrorLabel.setVisible(false);
                            ImportedFurnitureWizardStepsPanel.this.controller.setModelRotation(new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                            ImportedFurnitureWizardStepsPanel.this.controller.setBackFaceShown(false);
                            ImportedFurnitureWizardStepsPanel.this.controller.setName(contentManager.getPresentationName(string, ContentManager.ContentType.MODEL));
                            ImportedFurnitureWizardStepsPanel.this.controller.setCategory(furnitureCategory);
                            ImportedFurnitureWizardStepsPanel.this.controller.setWidth(this.val$readModelSize.x);
                            ImportedFurnitureWizardStepsPanel.this.controller.setDepth(this.val$readModelSize.z);
                            ImportedFurnitureWizardStepsPanel.this.controller.setHeight(this.val$readModelSize.y);
                            ImportedFurnitureWizardStepsPanel.this.controller.setMovable(true);
                            ImportedFurnitureWizardStepsPanel.this.controller.setDoorOrWindow(false);
                            ImportedFurnitureWizardStepsPanel.this.controller.setColor(null);
                            ImportedFurnitureWizardStepsPanel.this.controller.setIconYaw(0.3926991f);
                            ImportedFurnitureWizardStepsPanel.this.controller.setProportional(true);
                        } else if (ImportedFurnitureWizardStepsPanel.this.isShowing()) {
                            ImportedFurnitureWizardStepsPanel.this.controller.setModel(null);
                            ImportedFurnitureWizardStepsPanel.this.setModelChoiceTexts(userPreferences);
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceFormatError", new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private void showModelChoiceError(final String string, final UserPreferences userPreferences) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceError", string));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content copyToTemporaryOBJContent(BranchGroup branchGroup, String string) throws IOException {
        try {
            this.setReadingState();
            String string2 = new File(string).getName();
            if (!string2.toLowerCase().endsWith(".obj")) {
                string2 = string2 + ".obj";
            }
            File file = OperatingSystem.createTemporaryFile("import", ".zip");
            OBJWriter.writeNodeInZIPFile((Node)branchGroup, file, 0, string2, "3D model import " + string);
            TemporaryURLContent temporaryURLContent = new TemporaryURLContent(new URL("jar:" + file.toURI().toURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20")));
            Object var7_6 = null;
            this.setDefaultState();
            return temporaryURLContent;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setDefaultState();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BranchGroup readModel(Content content) throws IOException {
        try {
            this.setReadingState();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ImportedFurnitureWizardStepsPanel.this.updatePreviewComponentsModel(null);
                }
            });
            final BranchGroup branchGroup = ModelManager.getInstance().loadModel(content);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ImportedFurnitureWizardStepsPanel.this.updatePreviewComponentsModel(branchGroup);
                }
            });
            BranchGroup branchGroup2 = branchGroup;
            Object var5_4 = null;
            this.setDefaultState();
            return branchGroup2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setDefaultState();
            throw throwable;
        }
    }

    private void setReadingState() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ImportedFurnitureWizardStepsPanel.this.modelChoiceOrChangeButton.setEnabled(false);
                Component component = SwingUtilities.getRoot(ImportedFurnitureWizardStepsPanel.this);
                if (ImportedFurnitureWizardStepsPanel.this.defaultCursor == null) {
                    ImportedFurnitureWizardStepsPanel.this.defaultCursor = component.getCursor();
                }
                component.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    private void setDefaultState() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ImportedFurnitureWizardStepsPanel.this.modelChoiceOrChangeButton.setEnabled(true);
                SwingUtilities.getRoot(ImportedFurnitureWizardStepsPanel.this).setCursor(ImportedFurnitureWizardStepsPanel.this.defaultCursor);
            }
        });
    }

    private void updatePreviewComponentsModel(BranchGroup branchGroup) {
        this.modelPreviewComponent.setModel(branchGroup);
        this.rotationPreviewComponent.setModel(branchGroup);
        this.attributesPreviewComponent.setModel(branchGroup);
        this.iconPreviewComponent.setModel(branchGroup);
    }

    private void setModelChangeTexts(UserPreferences userPreferences) {
        this.modelChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChangeLabel.text", new Object[0]));
        this.modelChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "modelChangeButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.modelChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChangeButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void setModelChoiceTexts(UserPreferences userPreferences) {
        this.modelChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceLabel.text", new Object[0]));
        this.modelChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "modelChoiceButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.modelChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private String showModelChoiceDialog(UserPreferences userPreferences, ContentManager contentManager) {
        return contentManager.showOpenDialog(this, userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceDialog.title", new Object[0]), ContentManager.ContentType.MODEL);
    }

    public Content getIcon() {
        try {
            return this.iconPreviewComponent.getIcon(400);
        }
        catch (IOException iOException) {
            try {
                return new URLContent(new URL("file:/dummySweetHome3DContent"));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    private static class IconPreviewComponent
    extends AbstractModelPreviewComponent {
        private ImportedFurnitureWizardController controller;

        public IconPreviewComponent(ImportedFurnitureWizardController importedFurnitureWizardController) {
            this.controller = importedFurnitureWizardController;
            this.addSizeListeners(importedFurnitureWizardController);
            this.addColorListener(importedFurnitureWizardController);
            this.addIconYawListener(importedFurnitureWizardController);
            this.setBackground(UIManager.getColor("window"));
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(128 + insets.left + insets.right, 128 + insets.top + insets.bottom);
        }

        protected void setViewYaw(float f) {
            super.setViewYaw(f);
            this.controller.setIconYaw(f);
        }
    }

    private static class AttributesPreviewComponent
    extends AbstractModelPreviewComponent {
        public AttributesPreviewComponent(ImportedFurnitureWizardController importedFurnitureWizardController) {
            this.addSizeListeners(importedFurnitureWizardController);
            this.addColorListener(importedFurnitureWizardController);
        }
    }

    private static class RotationPreviewComponent
    extends AbstractModelPreviewComponent {
        private JLabel frontViewLabel;
        private Canvas3D frontViewCanvas;
        private JLabel sideViewLabel;
        private Canvas3D sideViewCanvas;
        private JLabel topViewLabel;
        private Canvas3D topViewCanvas;
        private JLabel perspectiveViewLabel;

        public RotationPreviewComponent(UserPreferences userPreferences, ImportedFurnitureWizardController importedFurnitureWizardController) {
            this.addRotationListener(importedFurnitureWizardController);
            this.createComponents(userPreferences);
            this.layoutComponents();
        }

        private void createComponents(UserPreferences userPreferences) {
            this.frontViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "frontViewLabel.text", new Object[0]));
            Component3DManager component3DManager = Component3DManager.getInstance();
            this.frontViewCanvas = component3DManager.getOnscreenCanvas3D();
            this.sideViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "sideViewLabel.text", new Object[0]));
            this.sideViewCanvas = component3DManager.getOnscreenCanvas3D();
            this.topViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "topViewLabel.text", new Object[0]));
            this.topViewCanvas = component3DManager.getOnscreenCanvas3D();
            this.perspectiveViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "perspectiveViewLabel.text", new Object[0]));
            this.setBorder(null);
            this.addHierarchyListener();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 204 + this.frontViewLabel.getPreferredSize().height * 2);
        }

        private void addHierarchyListener() {
            this.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    RotationPreviewComponent.this.createView(0.0f, 0.0f, 1.0f, 0).addCanvas3D(RotationPreviewComponent.this.frontViewCanvas);
                    RotationPreviewComponent.this.createView(Locale.getDefault().equals(Locale.US) ? -1.5707964f : 1.5707964f, 0.0f, 1.0f, 0).addCanvas3D(RotationPreviewComponent.this.sideViewCanvas);
                    RotationPreviewComponent.this.createView(0.0f, -1.5707964f, 1.0f, 0).addCanvas3D(RotationPreviewComponent.this.topViewCanvas);
                }

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    RotationPreviewComponent.this.frontViewCanvas.getView().removeCanvas3D(RotationPreviewComponent.this.frontViewCanvas);
                    RotationPreviewComponent.this.sideViewCanvas.getView().removeCanvas3D(RotationPreviewComponent.this.sideViewCanvas);
                    RotationPreviewComponent.this.topViewCanvas.getView().removeCanvas3D(RotationPreviewComponent.this.topViewCanvas);
                }

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        }

        private JPanel getCanvas3DBorderedPanel(Canvas3D canvas3D) {
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.add((Component)canvas3D);
            canvas3D.setFocusable(false);
            jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            return jPanel;
        }

        private void layoutComponents() {
            Canvas3D canvas3D = this.getCanvas3D();
            this.remove((Component)canvas3D);
            this.setLayout(new GridBagLayout());
            if (Locale.getDefault().equals(Locale.US)) {
                this.add((Component)this.perspectiveViewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(canvas3D), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.topViewLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(this.topViewCanvas), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
                this.add((Component)this.sideViewLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(this.sideViewCanvas), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                this.add((Component)this.frontViewLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(this.frontViewCanvas), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)this.sideViewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(this.sideViewCanvas), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.frontViewLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(this.frontViewCanvas), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
                this.add((Component)this.perspectiveViewLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(canvas3D), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                this.add((Component)this.topViewLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.getCanvas3DBorderedPanel(this.topViewCanvas), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }

    private static abstract class AbstractModelPreviewComponent
    extends ModelPreviewComponent {
        private AbstractModelPreviewComponent() {
        }

        protected void addRotationListener(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractModelPreviewComponent.this.setBackFaceShown(importedFurnitureWizardController.isBackFaceShown());
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractModelPreviewComponent.this.setModelRotation(importedFurnitureWizardController.getModelRotation());
                    if (propertyChangeEvent.getOldValue() != null) {
                        float f = importedFurnitureWizardController.getWidth();
                        float f2 = importedFurnitureWizardController.getDepth();
                        float f3 = importedFurnitureWizardController.getHeight();
                        float[][] fArray = (float[][])propertyChangeEvent.getOldValue();
                        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                        matrix3f.invert();
                        float f4 = matrix3f.m00 * f + matrix3f.m01 * f3 + matrix3f.m02 * f2;
                        float f5 = matrix3f.m10 * f + matrix3f.m11 * f3 + matrix3f.m12 * f2;
                        float f6 = matrix3f.m20 * f + matrix3f.m21 * f3 + matrix3f.m22 * f2;
                        float[][] fArray2 = (float[][])propertyChangeEvent.getNewValue();
                        importedFurnitureWizardController.setWidth(Math.abs(fArray2[0][0] * f4 + fArray2[0][1] * f5 + fArray2[0][2] * f6));
                        importedFurnitureWizardController.setHeight(Math.abs(fArray2[1][0] * f4 + fArray2[1][1] * f5 + fArray2[1][2] * f6));
                        importedFurnitureWizardController.setDepth(Math.abs(fArray2[2][0] * f4 + fArray2[2][1] * f5 + fArray2[2][2] * f6));
                    }
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MODEL_ROTATION, propertyChangeListener);
        }

        protected void addSizeListeners(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractModelPreviewComponent.this.setBackFaceShown(importedFurnitureWizardController.isBackFaceShown());
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractModelPreviewComponent.this.setModelRotationAndSize(importedFurnitureWizardController.getModelRotation(), importedFurnitureWizardController.getWidth(), importedFurnitureWizardController.getDepth(), importedFurnitureWizardController.getHeight());
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MODEL_ROTATION, propertyChangeListener);
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.WIDTH, propertyChangeListener);
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.DEPTH, propertyChangeListener);
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.HEIGHT, propertyChangeListener);
        }

        protected void addColorListener(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractModelPreviewComponent.this.setModelColor(importedFurnitureWizardController.getColor());
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.COLOR, propertyChangeListener);
        }

        protected void addIconYawListener(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractModelPreviewComponent.this.setViewYaw(importedFurnitureWizardController.getIconYaw());
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.ICON_YAW, propertyChangeListener);
        }
    }
}

