/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ProportionalLayout;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.ImportedTextureWizardController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportedTextureWizardStepsPanel
extends JPanel
implements View {
    private final ImportedTextureWizardController controller;
    private CardLayout cardLayout;
    private JLabel imageChoiceOrChangeLabel;
    private JButton imageChoiceOrChangeButton;
    private JLabel imageChoiceErrorLabel;
    private ScaledImageComponent imageChoicePreviewComponent;
    private JLabel attributesLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel categoryLabel;
    private JComboBox categoryComboBox;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private ScaledImageComponent attributesPreviewComponent;
    private Executor imageLoader;
    private static BufferedImage waitImage;

    public ImportedTextureWizardStepsPanel(CatalogTexture catalogTexture, String string, UserPreferences userPreferences, final ImportedTextureWizardController importedTextureWizardController) {
        this.controller = importedTextureWizardController;
        this.imageLoader = Executors.newSingleThreadExecutor();
        this.createComponents(userPreferences, importedTextureWizardController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        this.updateController(catalogTexture, userPreferences);
        if (string != null) {
            this.updateController(string, importedTextureWizardController.getContentManager(), userPreferences, true);
        }
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.STEP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedTextureWizardStepsPanel.this.updateStep(importedTextureWizardController);
            }
        });
    }

    private void createComponents(final UserPreferences userPreferences, final ImportedTextureWizardController importedTextureWizardController) {
        String string = userPreferences.getLengthUnit().getName();
        this.imageChoiceOrChangeLabel = new JLabel();
        this.imageChoiceOrChangeButton = new JButton();
        this.imageChoiceOrChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImportedTextureWizardStepsPanel.this.showImageChoiceDialog(userPreferences, importedTextureWizardController.getContentManager());
                if (string != null) {
                    ImportedTextureWizardStepsPanel.this.updateController(string, importedTextureWizardController.getContentManager(), userPreferences, false);
                }
            }
        });
        this.imageChoiceErrorLabel = new JLabel(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceErrorLabel.text", new Object[0]));
        this.imageChoiceErrorLabel.setVisible(false);
        this.imageChoicePreviewComponent = new ScaledImageComponent();
        this.imageChoicePreviewComponent.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                boolean bl = true;
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    final String string = ((File)list.get(0)).getAbsolutePath();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ImportedTextureWizardStepsPanel.this.updateController(string, importedTextureWizardController.getContentManager(), userPreferences, false);
                        }
                    });
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedTextureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceError", new Object[0]));
                        }
                    });
                }
                return bl;
            }
        });
        this.imageChoicePreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
        this.attributesLabel = new JLabel(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "attributesLabel.text", new Object[0]));
        this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "nameLabel.text", new Object[0]));
        this.nameTextField = new JTextField(10);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
        }
        final Color color = this.nameTextField.getForeground();
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ImportedTextureWizardStepsPanel.this.nameTextField.getDocument().removeDocumentListener(this);
                importedTextureWizardController.setName(ImportedTextureWizardStepsPanel.this.nameTextField.getText().trim());
                ImportedTextureWizardStepsPanel.this.nameTextField.getDocument().addDocumentListener(this);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.NAME, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ImportedTextureWizardStepsPanel.this.nameTextField.getText().trim().equals(importedTextureWizardController.getName())) {
                    ImportedTextureWizardStepsPanel.this.nameTextField.setText(importedTextureWizardController.getName());
                }
                ImportedTextureWizardStepsPanel.this.updateNameTextFieldForeground(color);
            }
        });
        this.categoryLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "categoryLabel.text", new Object[0]));
        this.categoryComboBox = new JComboBox<Object>(userPreferences.getTexturesCatalog().getCategories().toArray());
        this.categoryComboBox.setEditable(true);
        final ComboBoxEditor comboBoxEditor = this.categoryComboBox.getEditor();
        this.categoryComboBox.setEditor(new ComboBoxEditor(){

            public Object getItem() {
                String string = (String)comboBoxEditor.getItem();
                if ((string = string.trim()).length() == 0) {
                    this.setItem(ImportedTextureWizardStepsPanel.this.categoryComboBox.getSelectedItem());
                }
                TexturesCategory texturesCategory = new TexturesCategory(string);
                List<TexturesCategory> list = userPreferences.getTexturesCatalog().getCategories();
                int n = Collections.binarySearch(list, texturesCategory);
                if (n >= 0) {
                    return list.get(n);
                }
                return texturesCategory;
            }

            public void setItem(Object object) {
                if (object != null) {
                    TexturesCategory texturesCategory = (TexturesCategory)object;
                    comboBoxEditor.setItem(texturesCategory.getName());
                }
            }

            public void addActionListener(ActionListener actionListener) {
                comboBoxEditor.addActionListener(actionListener);
            }

            public Component getEditorComponent() {
                return comboBoxEditor.getEditorComponent();
            }

            public void removeActionListener(ActionListener actionListener) {
                comboBoxEditor.removeActionListener(actionListener);
            }

            public void selectAll() {
                comboBoxEditor.selectAll();
            }
        });
        this.categoryComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                TexturesCategory texturesCategory = (TexturesCategory)object;
                return super.getListCellRendererComponent((JList<?>)jList, texturesCategory.getName(), n, bl, bl2);
            }
        });
        this.categoryComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedTextureWizardController.setCategory((TexturesCategory)itemEvent.getItem());
            }
        });
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.CATEGORY, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TexturesCategory texturesCategory = importedTextureWizardController.getCategory();
                if (texturesCategory != null) {
                    ImportedTextureWizardStepsPanel.this.categoryComboBox.setSelectedItem(texturesCategory);
                }
                ImportedTextureWizardStepsPanel.this.updateNameTextFieldForeground(color);
            }
        });
        this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "widthLabel.text", string));
        float f = userPreferences.getLengthUnit().getMinimumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, 100000.0f);
        this.widthSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel.removeChangeListener(this);
                importedTextureWizardController.setWidth(nullableSpinnerLengthModel.getLength().floatValue());
                nullableSpinnerLengthModel.addChangeListener(this);
            }
        });
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.WIDTH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength(Float.valueOf(importedTextureWizardController.getWidth()));
            }
        });
        this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "heightLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, 100000.0f);
        this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel2.removeChangeListener(this);
                importedTextureWizardController.setHeight(nullableSpinnerLengthModel2.getLength().floatValue());
                nullableSpinnerLengthModel2.addChangeListener(this);
            }
        });
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.HEIGHT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength(Float.valueOf(importedTextureWizardController.getHeight()));
            }
        });
        this.attributesPreviewComponent = new ScaledImageComponent();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedTextureWizardStepsPanel.this.updateAttributesPreviewImage();
            }
        };
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.IMAGE, propertyChangeListener);
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.WIDTH, propertyChangeListener);
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.HEIGHT, propertyChangeListener);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setLabelFor(this.nameTextField);
            this.categoryLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "categoryLabel.mnemonic", new Object[0])).getKeyCode());
            this.categoryLabel.setLabelFor(this.categoryComboBox);
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
        }
    }

    private void layoutComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.imageChoiceOrChangeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.imageChoicePreviewComponent.setPreferredSize(new Dimension(150, 150));
        jPanel.add((Component)this.imageChoiceOrChangeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.imageChoiceErrorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new ProportionalLayout());
        jPanel2.add((Component)jPanel, (Object)ProportionalLayout.Constraints.TOP);
        jPanel2.add((Component)this.imageChoicePreviewComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.attributesLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 10, 0), 0, 0));
        this.attributesPreviewComponent.setPreferredSize(new Dimension(150, 150));
        jPanel3.add((Component)this.attributesPreviewComponent, new GridBagConstraints(0, 1, 1, 5, 1.0, 0.0, 11, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel3.add((Component)this.nameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.nameTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.categoryLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.categoryComboBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.widthLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.widthSpinner, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.heightLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel3.add((Component)this.heightSpinner, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)new JLabel(), new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, ImportedTextureWizardController.Step.IMAGE.name());
        this.add((Component)jPanel3, ImportedTextureWizardController.Step.ATTRIBUTES.name());
    }

    public void updateStep(ImportedTextureWizardController importedTextureWizardController) {
        ImportedTextureWizardController.Step step = importedTextureWizardController.getStep();
        this.cardLayout.show(this, step.name());
        switch (step) {
            case IMAGE: {
                this.imageChoiceOrChangeButton.requestFocusInWindow();
                break;
            }
            case ATTRIBUTES: {
                this.nameTextField.requestFocusInWindow();
            }
        }
    }

    private void updateNameTextFieldForeground(Color color) {
        this.nameTextField.setForeground(this.controller.isTextureNameValid() ? color : Color.RED);
    }

    private void updateController(final CatalogTexture catalogTexture, final UserPreferences userPreferences) {
        if (catalogTexture == null) {
            this.setImageChoiceTexts(userPreferences);
            this.updatePreviewComponentsImage(null);
        } else {
            this.setImageChangeTexts(userPreferences);
            this.imageLoader.execute(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImportedTextureWizardStepsPanel.this.readImage(userPreferences, catalogTexture.getImage());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    final BufferedImage bufferedImage2 = bufferedImage;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (bufferedImage2 != null) {
                                ImportedTextureWizardStepsPanel.this.controller.setImage(catalogTexture.getImage());
                                ImportedTextureWizardStepsPanel.this.controller.setName(catalogTexture.getName());
                                ImportedTextureWizardStepsPanel.this.controller.setCategory(catalogTexture.getCategory());
                                ImportedTextureWizardStepsPanel.this.controller.setWidth(catalogTexture.getWidth());
                                ImportedTextureWizardStepsPanel.this.controller.setHeight(catalogTexture.getHeight());
                            } else {
                                ImportedTextureWizardStepsPanel.this.controller.setImage(null);
                                ImportedTextureWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                                ImportedTextureWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(true);
                            }
                        }
                    });
                }
            });
        }
    }

    private void updateController(final String string, final ContentManager contentManager, final UserPreferences userPreferences, final boolean bl) {
        this.imageLoader.execute(new Runnable(){

            public void run() {
                TemporaryURLContent temporaryURLContent = null;
                try {
                    temporaryURLContent = TemporaryURLContent.copyToTemporaryURLContent(contentManager.getContent(string));
                }
                catch (RecorderException recorderException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (temporaryURLContent == null) {
                    if (!bl) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedTextureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceError", string));
                            }
                        });
                    }
                    return;
                }
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImportedTextureWizardStepsPanel.this.readImage(userPreferences, temporaryURLContent);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                final BufferedImage bufferedImage2 = bufferedImage;
                final TemporaryURLContent temporaryURLContent2 = temporaryURLContent;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (bufferedImage2 != null) {
                            ImportedTextureWizardStepsPanel.this.controller.setImage(temporaryURLContent2);
                            ImportedTextureWizardStepsPanel.this.setImageChangeTexts(userPreferences);
                            ImportedTextureWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(false);
                            ImportedTextureWizardStepsPanel.this.controller.setName(contentManager.getPresentationName(string, ContentManager.ContentType.IMAGE));
                            TexturesCategory texturesCategory = new TexturesCategory(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "userCategory", new Object[0]));
                            for (TexturesCategory texturesCategory2 : userPreferences.getTexturesCatalog().getCategories()) {
                                if (!texturesCategory2.equals(texturesCategory)) continue;
                                texturesCategory = texturesCategory2;
                                break;
                            }
                            ImportedTextureWizardStepsPanel.this.controller.setCategory(texturesCategory);
                            float f = 20.0f;
                            if (userPreferences.getLengthUnit() == LengthUnit.INCH) {
                                f = LengthUnit.inchToCentimeter(8.0f);
                            }
                            ImportedTextureWizardStepsPanel.this.controller.setWidth(f);
                            ImportedTextureWizardStepsPanel.this.controller.setHeight(f / (float)bufferedImage2.getWidth() * (float)bufferedImage2.getHeight());
                        } else if (ImportedTextureWizardStepsPanel.this.isShowing()) {
                            ImportedTextureWizardStepsPanel.this.controller.setImage(null);
                            ImportedTextureWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                            JOptionPane.showMessageDialog(ImportedTextureWizardStepsPanel.this, userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceFormatError", new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private BufferedImage readImage(UserPreferences userPreferences, Content content) throws IOException {
        try {
            if (waitImage == null) {
                waitImage = ImageIO.read(ImportedTextureWizardStepsPanel.class.getResource(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "waitIcon", new Object[0])));
            }
            this.updatePreviewComponentsImage(waitImage);
            InputStream inputStream = content.openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            if (bufferedImage != null) {
                this.updatePreviewComponentsImage(bufferedImage);
                return bufferedImage;
            }
            throw new IOException();
        }
        catch (IOException iOException) {
            this.updatePreviewComponentsImage(null);
            throw iOException;
        }
    }

    private void updatePreviewComponentsImage(BufferedImage bufferedImage) {
        this.imageChoicePreviewComponent.setImage(bufferedImage);
        this.attributesPreviewComponent.setImage(bufferedImage);
    }

    private void setImageChangeTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChangeLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "imageChangeButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChangeButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void setImageChoiceTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "imageChoiceButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private String showImageChoiceDialog(UserPreferences userPreferences, ContentManager contentManager) {
        return contentManager.showOpenDialog(this, userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceDialog.title", new Object[0]), ContentManager.ContentType.IMAGE);
    }

    private void updateAttributesPreviewImage() {
        BufferedImage bufferedImage = this.attributesPreviewComponent.getImage();
        if (bufferedImage == null || bufferedImage == this.imageChoicePreviewComponent.getImage()) {
            bufferedImage = new BufferedImage(150, 150, 1);
            this.attributesPreviewComponent.setImage(bufferedImage);
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(0, 0, 150, 150);
        BufferedImage bufferedImage2 = this.imageChoicePreviewComponent.getImage();
        if (bufferedImage2 != null) {
            graphics2D.setPaint(new TexturePaint(bufferedImage2, new Rectangle2D.Float(0.0f, 0.0f, this.controller.getWidth() / 250.0f * 150.0f, this.controller.getHeight() / 250.0f * 150.0f)));
            graphics2D.fillRect(0, 0, 150, 150);
        }
        graphics2D.dispose();
        this.attributesPreviewComponent.repaint();
    }
}

