/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LabelController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelPanel
extends JPanel
implements DialogView {
    private final boolean labelModification;
    private final LabelController controller;
    private JLabel textLabel;
    private JTextField textTextField;
    private String dialogTitle;

    public LabelPanel(boolean bl, UserPreferences userPreferences, LabelController labelController) {
        super(new GridBagLayout());
        this.labelModification = bl;
        this.controller = labelController;
        this.createComponents(bl, userPreferences, labelController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(labelController);
    }

    private void createComponents(boolean bl, UserPreferences userPreferences, final LabelController labelController) {
        this.textLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "textLabel.text", new Object[0]));
        this.textTextField = new JTextField(labelController.getText(), 20);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.textTextField);
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.textTextField.setText(labelController.getText());
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
        this.textTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
                String string = LabelPanel.this.textTextField.getText();
                if (string == null || string.trim().length() == 0) {
                    labelController.setText("");
                } else {
                    labelController.setText(string);
                }
                labelController.addPropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(LabelPanel.class, bl ? "labelModification.title" : "labelCreation.title", new Object[0]);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.textLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "textLabel.mnemonic", new Object[0])).getKeyCode());
            this.textLabel.setLabelFor(this.textTextField);
        }
    }

    private void layoutComponents(LabelController labelController) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        this.add((Component)this.textLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.textTextField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.textTextField) == 0 && this.controller != null) {
            if (this.labelModification) {
                this.controller.modifyLabels();
            } else {
                this.controller.createLabel();
            }
        }
    }
}

