/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ModelPreviewComponent
extends JComponent {
    private SimpleUniverse universe;
    private Canvas3D canvas3D = Component3DManager.getInstance().getOnscreenCanvas3D(new Component3DManager.RenderingObserver(){

        public void canvas3DPreRendered(Canvas3D canvas3D) {
        }

        public void canvas3DPostRendered(Canvas3D canvas3D) {
        }

        public void canvas3DSwapped(Canvas3D canvas3D) {
            ModelPreviewComponent.this.canvas3DSwapped();
        }
    });
    private BranchGroup sceneTree;
    private float viewYaw = 0.3926991f;
    private float viewPitch = -0.19634955f;
    private float viewScale = 1.0f;
    private Object iconImageLock;

    public ModelPreviewComponent() {
        this(false);
    }

    public ModelPreviewComponent(boolean bl) {
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.canvas3D);
        this.canvas3D.setFocusable(false);
        this.addMouseListeners(this.canvas3D, bl);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.sceneTree = this.createSceneTree();
        this.addAncestorListener();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(200, 200);
    }

    protected Canvas3D getCanvas3D() {
        return this.canvas3D;
    }

    private void addMouseListeners(Canvas3D canvas3D, final boolean bl) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private int xLastMouseMove;
            private int yLastMouseMove;

            public void mousePressed(MouseEvent mouseEvent) {
                this.xLastMouseMove = mouseEvent.getX();
                this.yLastMouseMove = mouseEvent.getY();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ModelPreviewComponent.this.getModel() != null) {
                    ModelPreviewComponent.this.setViewYaw(ModelPreviewComponent.this.getViewYaw() - 0.02f * (float)(mouseEvent.getX() - this.xLastMouseMove));
                    this.xLastMouseMove = mouseEvent.getX();
                    if (bl) {
                        if (mouseEvent.isAltDown()) {
                            ModelPreviewComponent.this.setViewScale(Math.max(0.5f, Math.min(1.3f, ModelPreviewComponent.this.getViewScale() * (float)Math.exp((float)(mouseEvent.getY() - this.yLastMouseMove) * 0.02f))));
                        } else {
                            ModelPreviewComponent.this.setViewPitch(Math.max(-0.7853982f, Math.min(0.0f, ModelPreviewComponent.this.getViewPitch() - 0.02f * (float)(mouseEvent.getY() - this.yLastMouseMove))));
                        }
                        this.yLastMouseMove = mouseEvent.getY();
                    }
                }
            }
        };
        canvas3D.addMouseListener((MouseListener)mouseInputAdapter);
        canvas3D.addMouseMotionListener((MouseMotionListener)mouseInputAdapter);
        if (bl) {
            canvas3D.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    ModelPreviewComponent.this.setViewScale(Math.max(0.5f, Math.min(1.3f, ModelPreviewComponent.this.getViewScale() * (float)Math.exp((float)mouseWheelEvent.getWheelRotation() * 0.02f))));
                }
            });
        }
    }

    private void addAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (ModelPreviewComponent.this.universe == null) {
                    ModelPreviewComponent.this.createUniverse();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (ModelPreviewComponent.this.universe != null) {
                    ModelPreviewComponent.this.disposeUniverse();
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void createUniverse() {
        this.universe = new SimpleUniverse(this.canvas3D);
        this.canvas3D.setFocusable(false);
        this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        this.universe.addBranchGraph(this.sceneTree);
        if (OperatingSystem.isMacOSX()) {
            final Component component = SwingUtilities.getRoot(this);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Dimension dimension = component.getSize();
                    component.setSize(new Dimension(dimension.width + 1, dimension.height));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    component.setSize(new Dimension(dimension.width, dimension.height));
                    if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != component) {
                        component.requestFocus();
                    }
                }
            });
        }
    }

    private void disposeUniverse() {
        this.universe.getLocale().removeBranchGraph(this.sceneTree);
        this.universe.cleanup();
        this.universe = null;
    }

    protected View createView(float f, float f2, float f3, int n) {
        if (this.universe == null) {
            this.createUniverse();
        }
        PhysicalBody physicalBody = this.universe.getViewer().getPhysicalBody();
        PhysicalEnvironment physicalEnvironment = this.universe.getViewer().getPhysicalEnvironment();
        View view = new View();
        view.setPhysicalBody(physicalBody);
        view.setPhysicalEnvironment(physicalEnvironment);
        view.setProjectionPolicy(n);
        ViewingPlatform viewingPlatform = new ViewingPlatform();
        viewingPlatform.setUniverse(this.universe);
        this.universe.getLocale().addBranchGraph((BranchGroup)viewingPlatform.getViewPlatformTransform().getParent());
        view.attachViewPlatform(viewingPlatform.getViewPlatform());
        this.updateViewPlatformTransform(viewingPlatform.getViewPlatformTransform(), f, f2, f3);
        return view;
    }

    protected float getViewYaw() {
        return this.viewYaw;
    }

    protected void setViewYaw(float f) {
        this.viewYaw = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected float getViewScale() {
        return this.viewScale;
    }

    protected void setViewScale(float f) {
        this.viewScale = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected float getViewPitch() {
        return this.viewPitch;
    }

    protected void setViewPitch(float f) {
        this.viewPitch = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    private void updateViewPlatformTransform(TransformGroup transformGroup, float f, float f2, float f3) {
        double d = 1.4 / Math.tan(0.39269908169872414);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX((double)f2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY((double)f);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3d(Math.sin(f) * d * Math.cos(f2), d * Math.sin(-f2), Math.cos(f) * d * Math.cos(f2)));
        Transform3D transform3D4 = new Transform3D();
        transform3D4.setScale((double)f3);
        transform3D2.mul(transform3D);
        transform3D3.mul(transform3D2);
        transform3D4.mul(transform3D3);
        transformGroup.setTransform(transform3D4);
    }

    private BranchGroup createSceneTree() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.addChild(this.getModelTree());
        branchGroup.addChild(this.getBackgroundNode());
        for (Light light : this.getLights()) {
            branchGroup.addChild((Node)light);
        }
        return branchGroup;
    }

    private Node getBackgroundNode() {
        Background background = new Background(new Color3f(0.9f, 0.9f, 0.9f));
        background.setCapability(17);
        background.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        return background;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        ((Background)this.sceneTree.getChild(1)).setColor(new Color3f(color));
    }

    private Light[] getLights() {
        Light[] lightArray;
        for (Light light : lightArray = new Light[]{new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(1.732f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(-1.732f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(0.0f, -0.8f, 1.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))}) {
            light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        }
        return lightArray;
    }

    private Node getModelTree() {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        transformGroup.setCapability(18);
        return transformGroup;
    }

    public BranchGroup getModel() {
        TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
        if (transformGroup.numChildren() > 0) {
            return (BranchGroup)transformGroup.getChild(0);
        }
        return null;
    }

    public void setModel(BranchGroup branchGroup) {
        TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
        transformGroup.removeAllChildren();
        if (branchGroup != null) {
            branchGroup = (BranchGroup)ModelManager.getInstance().cloneNode((Node)branchGroup);
            branchGroup.setCapability(17);
            this.setNodeCapabilities((Node)branchGroup);
            if (branchGroup.numChildren() > 0) {
                BoundingBox boundingBox = null;
                try {
                    boundingBox = ModelManager.getInstance().getBounds((Node)branchGroup);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (boundingBox != null) {
                    Point3d point3d = new Point3d();
                    boundingBox.getLower(point3d);
                    Point3d point3d2 = new Point3d();
                    boundingBox.getUpper(point3d2);
                    Transform3D transform3D = new Transform3D();
                    transform3D.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
                    Transform3D transform3D2 = new Transform3D();
                    transform3D2.setScale(1.8 / Math.max(Math.max(point3d2.x - point3d.x, point3d2.y - point3d.y), point3d2.z - point3d.z));
                    transform3D2.mul(transform3D);
                    transformGroup.setTransform(transform3D2);
                    transformGroup.addChild((Node)branchGroup);
                }
            }
        }
    }

    private void setNodeCapabilities(Node node) {
        block6: {
            block7: {
                block5: {
                    if (!(node instanceof Group)) break block5;
                    node.setCapability(12);
                    if (node instanceof TransformGroup) {
                        node.setCapability(17);
                    }
                    Enumeration enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.setNodeCapabilities((Node)enumeration.nextElement());
                    }
                    break block6;
                }
                if (!(node instanceof Link)) break block7;
                node.setCapability(12);
                this.setNodeCapabilities((Node)((Link)node).getSharedGroup());
                break block6;
            }
            if (!(node instanceof Shape3D)) break block6;
            Shape3D shape3D = (Shape3D)node;
            node.setCapability(3);
            Appearance appearance = ((Shape3D)node).getAppearance();
            if (appearance == null) {
                appearance = new Appearance();
                shape3D.setAppearance(appearance);
            }
            appearance.setCapability(14);
            appearance.setCapability(0);
            appearance.setCapability(1);
            node.setCapability(14);
            PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
            if (polygonAttributes == null) {
                polygonAttributes = new PolygonAttributes();
                appearance.setPolygonAttributes(polygonAttributes);
            }
            polygonAttributes.setCapability(1);
            polygonAttributes.setCapability(7);
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements()) {
                Geometry geometry = (Geometry)enumeration.nextElement();
                if (geometry.isLive() || !(geometry instanceof GeometryArray)) continue;
                geometry.setCapability(17);
                geometry.setCapability(8);
                geometry.setCapability(0);
                geometry.setCapability(4);
                geometry.setCapability(6);
                geometry.setCapability(21);
            }
        }
    }

    protected void setBackFaceShown(boolean bl) {
        this.setBackFaceShown(this.sceneTree.getChild(0), bl);
    }

    private void setBackFaceShown(Node node, boolean bl) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setBackFaceShown((Node)enumeration.nextElement(), bl);
            }
        } else if (node instanceof Link) {
            this.setBackFaceShown((Node)((Link)node).getSharedGroup(), bl);
        } else if (node instanceof Shape3D) {
            Appearance appearance = ((Shape3D)node).getAppearance();
            PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
            polygonAttributes.setCullFace(bl ? 2 : 1);
            polygonAttributes.setBackFaceNormalFlip(bl);
        }
    }

    protected void setModelRotation(float[][] fArray) {
        BranchGroup branchGroup = this.getModel();
        if (branchGroup != null && branchGroup.numChildren() > 0) {
            Transform3D transform3D;
            BoundingBox boundingBox = ModelManager.getInstance().getBounds((Node)branchGroup);
            Point3d point3d = new Point3d();
            boundingBox.getLower(point3d);
            Point3d point3d2 = new Point3d();
            boundingBox.getUpper(point3d2);
            Transform3D transform3D2 = new Transform3D();
            transform3D2.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
            Transform3D transform3D3 = new Transform3D();
            if (fArray != null) {
                transform3D = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                transform3D3.setRotation((Matrix3f)transform3D);
            }
            transform3D3.mul(transform3D2);
            transform3D = new Transform3D();
            transform3D.setScale(1.8 / Math.max(Math.max(point3d2.x - point3d.x, point3d2.z - point3d.z), point3d2.y - point3d.y));
            transform3D.mul(transform3D3);
            TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
            transformGroup.setTransform(transform3D);
        }
    }

    protected void setModelRotationAndSize(float[][] fArray, float f, float f2, float f3) {
        BranchGroup branchGroup = this.getModel();
        if (branchGroup != null && branchGroup.numChildren() > 0) {
            Transform3D transform3D;
            BoundingBox boundingBox = ModelManager.getInstance().getBounds((Node)branchGroup);
            Point3d point3d = new Point3d();
            boundingBox.getLower(point3d);
            Point3d point3d2 = new Point3d();
            boundingBox.getUpper(point3d2);
            Transform3D transform3D2 = new Transform3D();
            transform3D2.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
            Transform3D transform3D3 = new Transform3D();
            transform3D3.setScale(new Vector3d(1.0 / Math.max(1.0E-4, point3d2.x - point3d.x), 1.0 / Math.max(1.0E-4, point3d2.y - point3d.y), 1.0 / Math.max(1.0E-4, point3d2.z - point3d.z)));
            transform3D3.mul(transform3D2);
            Transform3D transform3D4 = new Transform3D();
            if (fArray != null) {
                transform3D = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                transform3D4.setRotation((Matrix3f)transform3D);
            }
            transform3D4.mul(transform3D3);
            transform3D = new Transform3D();
            if (f != 0.0f && f2 != 0.0f && f3 != 0.0f) {
                transform3D.setScale(new Vector3d((double)f, (double)f3, (double)f2));
            }
            transform3D.mul(transform3D4);
            Transform3D transform3D5 = new Transform3D();
            if (f != 0.0f && f2 != 0.0f && f3 != 0.0f) {
                transform3D5.setScale(1.8 / (double)Math.max(Math.max(f, f3), f2));
            } else {
                transform3D5.setScale(1.8 / Math.max(Math.max(point3d2.x - point3d.x, point3d2.z - point3d.z), point3d2.y - point3d.y));
            }
            transform3D5.mul(transform3D);
            TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
            transformGroup.setTransform(transform3D5);
        }
    }

    protected void setModelColor(Integer n) {
        if (n != null) {
            Color3f color3f = new Color3f((float)(n >>> 16 & 0xFF) / 255.0f, (float)(n >>> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
            this.setMaterial(this.sceneTree.getChild(0), new Material(color3f, new Color3f(), color3f, color3f, 64.0f));
        } else {
            this.setMaterial(this.sceneTree.getChild(0), null);
        }
    }

    private void setMaterial(Node node, Material material) {
        Shape3D shape3D;
        String string;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setMaterial((Node)enumeration.nextElement(), material);
            }
        } else if (node instanceof Link) {
            this.setMaterial((Node)((Link)node).getSharedGroup(), material);
        } else if (node instanceof Shape3D && ((string = (String)(shape3D = (Shape3D)node).getUserData()) == null || !string.startsWith("sweethome3d_window_pane"))) {
            Appearance appearance = shape3D.getAppearance();
            Material material2 = (Material)appearance.getUserData();
            if (material2 == null) {
                material2 = appearance.getMaterial();
                appearance.setUserData((Object)material2);
            }
            if (material != null) {
                appearance.setMaterial(material);
            } else {
                appearance.setMaterial(material2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getIconImage(int n) {
        Object object;
        Object object2;
        Color color = this.getBackground();
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        this.iconImageLock = new Object();
        try {
            Object object3;
            object2 = new Point();
            SwingUtilities.convertPointToScreen((Point)object2, (Component)this.canvas3D);
            object = new Robot();
            if (this.iconImageLock != null) {
                object3 = this.iconImageLock;
                synchronized (object3) {
                    this.setBackground(Color.WHITE);
                    try {
                        this.iconImageLock.wait(n / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            bufferedImage = ((Robot)object).createScreenCapture(new Rectangle((Point)object2, this.canvas3D.getSize()));
            if (this.iconImageLock != null) {
                object3 = this.iconImageLock;
                synchronized (object3) {
                    this.setBackground(Color.BLACK);
                    try {
                        this.iconImageLock.wait(n / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            bufferedImage2 = ((Robot)object).createScreenCapture(new Rectangle((Point)object2, this.canvas3D.getSize()));
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        finally {
            this.iconImageLock = null;
            this.setBackground(color);
        }
        object2 = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        object = bufferedImage2.getRGB(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null, 0, bufferedImage2.getWidth());
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] == object2[i] || object[i] != -16777216 || object2[i] != -1) continue;
            object2[i] = false;
        }
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics();
        graphics2D.drawImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])object2, 0, bufferedImage.getWidth())), null, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public Content getIcon(int n) throws IOException {
        File file = OperatingSystem.createTemporaryFile("icon", ".png");
        ImageIO.write((RenderedImage)this.getIconImage(n), "png", file);
        return new TemporaryURLContent(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvas3DSwapped() {
        if (this.iconImageLock != null) {
            Object object = this.iconImageLock;
            synchronized (object) {
                this.iconImageLock.notify();
            }
        }
    }
}

