/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.swing.VisualTransferHandler;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.PhotoController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotoPanel
extends JPanel
implements DialogView {
    private static final String PHOTO_DIALOG_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.PhotoPanel.PhotoDialogX";
    private static final String PHOTO_DIALOG_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.PhotoPanel.PhotoDialogY";
    private static final int MINIMUM_DELAY_BEFORE_DISCARDING_WITHOUT_WARNING = 30000;
    private static final String WAIT_CARD = "wait";
    private static final String PHOTO_CARD = "photo";
    private final Home home;
    private final UserPreferences preferences;
    private final PhotoController controller;
    private ScaledImageComponent photoComponent;
    private JLabel animatedWaitLabel;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox applyProportionsCheckBox;
    private JComboBox aspectRatioComboBox;
    private JLabel qualityLabel;
    private JSlider qualitySlider;
    private Component advancedComponentsSeparator;
    private JLabel dateLabel;
    private JSpinner dateSpinner;
    private JLabel timeLabel;
    private JSpinner timeSpinner;
    private JLabel dayNightLabel;
    private JLabel lensLabel;
    private JComboBox lensComboBox;
    private JCheckBox ceilingLightEnabledCheckBox;
    private String dialogTitle;
    private JPanel photoPanel;
    private CardLayout photoCardLayout;
    private ExecutorService photoCreationExecutor;
    private long photoCreationStartTime;
    private JButton createButton;
    private JButton saveButton;
    private JButton closeButton;
    private static PhotoPanel currentPhotoPanel;

    public PhotoPanel(Home home, UserPreferences userPreferences, PhotoController photoController) {
        super(new GridBagLayout());
        this.home = home;
        this.preferences = userPreferences;
        this.controller = photoController;
        this.createActions(userPreferences);
        this.createComponents(home, userPreferences, photoController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void createActions(UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        actionMap.put((Object)ActionType.START_PHOTO_CREATION, new ResourceAction(userPreferences, PhotoPanel.class, ActionType.START_PHOTO_CREATION.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoPanel.this.startPhotoCreation();
            }
        });
        actionMap.put((Object)ActionType.STOP_PHOTO_CREATION, new ResourceAction(userPreferences, PhotoPanel.class, ActionType.STOP_PHOTO_CREATION.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoPanel.this.stopPhotoCreation(true);
            }
        });
        actionMap.put((Object)ActionType.SAVE_PHOTO, new ResourceAction(userPreferences, PhotoPanel.class, ActionType.SAVE_PHOTO.name(), false){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoPanel.this.savePhoto();
            }
        });
        actionMap.put((Object)ActionType.CLOSE, new ResourceAction(userPreferences, PhotoPanel.class, ActionType.CLOSE.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoPanel.this.close();
            }
        });
    }

    private void createComponents(final Home home, final UserPreferences userPreferences, final PhotoController photoController) {
        this.photoComponent = new ScaledImageComponent();
        this.photoComponent.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width <= 1024 ? 320 : 400, 400));
        if (OperatingSystem.isMacOSX()) {
            this.photoComponent.setTransferHandler(new VisualTransferHandler(){

                public int getSourceActions(JComponent jComponent) {
                    return 3;
                }

                protected Transferable createTransferable(JComponent jComponent) {
                    return new Transferable(){

                        public Object getTransferData(DataFlavor dataFlavor) {
                            return PhotoPanel.this.photoComponent.getImage();
                        }

                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{DataFlavor.imageFlavor};
                        }

                        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                            return dataFlavor.equals(DataFlavor.imageFlavor);
                        }
                    };
                }

                public Icon getVisualRepresentation(Transferable transferable) {
                    try {
                        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                            BufferedImage bufferedImage = (BufferedImage)transferable.getTransferData(DataFlavor.imageFlavor);
                            float f = Math.min(1.0f, 128.0f / (float)Math.max(bufferedImage.getWidth(), bufferedImage.getHeight()));
                            BufferedImage bufferedImage2 = new BufferedImage(128, 128, 2);
                            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                            graphics2D.scale(f, f);
                            graphics2D.drawRenderedImage(bufferedImage, null);
                            graphics2D.dispose();
                            return new ImageIcon(bufferedImage2);
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return super.getVisualRepresentation(transferable);
                }
            });
            this.photoComponent.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && PhotoPanel.this.photoComponent.getImage() != null && PhotoPanel.this.photoComponent.isPointInImage(mouseEvent.getX(), mouseEvent.getY())) {
                        PhotoPanel.this.photoComponent.getTransferHandler().exportAsDrag(PhotoPanel.this.photoComponent, mouseEvent, 1);
                    }
                }
            });
        }
        this.animatedWaitLabel = new JLabel(new ImageIcon(PhotoPanel.class.getResource("resources/animatedWait.gif")));
        this.widthLabel = new JLabel();
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(480, 10, 10000, 10);
        this.widthSpinner = new AutoCommitSpinner(spinnerNumberModel);
        spinnerNumberModel.setValue(photoController.getWidth());
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                photoController.setWidth(((Number)spinnerNumberModel.getValue()).intValue());
            }
        });
        photoController.addPropertyChangeListener(PhotoController.Property.WIDTH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel.setValue(photoController.getWidth());
            }
        });
        this.heightLabel = new JLabel();
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(480, 10, 10000, 10);
        this.heightSpinner = new AutoCommitSpinner(spinnerNumberModel2);
        spinnerNumberModel2.setValue(photoController.getHeight());
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                photoController.setHeight(((Number)spinnerNumberModel2.getValue()).intValue());
            }
        });
        photoController.addPropertyChangeListener(PhotoController.Property.HEIGHT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel2.setValue(photoController.getHeight());
            }
        });
        boolean bl = photoController.getAspectRatio() != AspectRatio.FREE_RATIO;
        this.applyProportionsCheckBox = new JCheckBox();
        this.applyProportionsCheckBox.setSelected(bl);
        this.applyProportionsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                photoController.setAspectRatio(PhotoPanel.this.applyProportionsCheckBox.isSelected() ? (AspectRatio)((Object)PhotoPanel.this.aspectRatioComboBox.getSelectedItem()) : AspectRatio.FREE_RATIO);
            }
        });
        this.aspectRatioComboBox = new JComboBox<Object>(new Object[]{AspectRatio.VIEW_3D_RATIO, AspectRatio.SQUARE_RATIO, AspectRatio.RATIO_4_3, AspectRatio.RATIO_3_2, AspectRatio.RATIO_16_9, AspectRatio.RATIO_2_1});
        this.aspectRatioComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                AspectRatio aspectRatio = (AspectRatio)((Object)object);
                String string = "";
                if (aspectRatio != AspectRatio.FREE_RATIO) {
                    switch (aspectRatio) {
                        case VIEW_3D_RATIO: {
                            string = userPreferences.getLocalizedString(PhotoPanel.class, "aspectRatioComboBox.view3DRatio.text", new Object[0]);
                            break;
                        }
                        case SQUARE_RATIO: {
                            string = userPreferences.getLocalizedString(PhotoPanel.class, "aspectRatioComboBox.squareRatio.text", new Object[0]);
                            break;
                        }
                        case RATIO_4_3: {
                            string = "4/3";
                            break;
                        }
                        case RATIO_3_2: {
                            string = "3/2";
                            break;
                        }
                        case RATIO_16_9: {
                            string = "16/9";
                            break;
                        }
                        case RATIO_2_1: {
                            string = "2/1";
                        }
                    }
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.aspectRatioComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                photoController.setAspectRatio((AspectRatio)((Object)PhotoPanel.this.aspectRatioComboBox.getSelectedItem()));
            }
        });
        this.aspectRatioComboBox.setEnabled(bl);
        this.aspectRatioComboBox.setSelectedItem((Object)photoController.getAspectRatio());
        photoController.addPropertyChangeListener(PhotoController.Property.ASPECT_RATIO, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = photoController.getAspectRatio() != AspectRatio.FREE_RATIO;
                PhotoPanel.this.applyProportionsCheckBox.setSelected(bl);
                PhotoPanel.this.aspectRatioComboBox.setEnabled(bl);
                PhotoPanel.this.aspectRatioComboBox.setSelectedItem((Object)photoController.getAspectRatio());
            }
        });
        this.qualityLabel = new JLabel();
        this.qualitySlider = new JSlider(1, photoController.getQualityLevelCount()){

            public String getToolTipText(MouseEvent mouseEvent) {
                float f = PhotoPanel.this.getSliderValueAt(this, mouseEvent.getX(), userPreferences);
                float f2 = f - (float)Math.floor(f);
                if (f2 < 0.25f || f2 > 0.75f) {
                    return "<html><table><tr valign='middle'><td><img border='1' src='" + new ResourceURLContent(PhotoPanel.class, "resources/quality" + Math.round(f - (float)PhotoPanel.this.qualitySlider.getMinimum()) + ".jpg").getURL() + "'></td>" + "<td>" + userPreferences.getLocalizedString(PhotoPanel.class, "quality" + Math.round(f - (float)PhotoPanel.this.qualitySlider.getMinimum()) + "DescriptionLabel.text", new Object[0]) + "</td>" + "</tr></table>";
                }
                return null;
            }
        };
        this.qualitySlider.addMouseListener(new MouseAdapter(){

            public void mousePressed(final MouseEvent mouseEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        float f = PhotoPanel.this.getSliderValueAt(PhotoPanel.this.qualitySlider, mouseEvent.getX(), userPreferences);
                        if (PhotoPanel.this.qualitySlider.getValue() == Math.round(f)) {
                            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                            int n = toolTipManager.getInitialDelay();
                            toolTipManager.setInitialDelay(Math.min(n, 150));
                            toolTipManager.mouseMoved(mouseEvent);
                            toolTipManager.setInitialDelay(n);
                        }
                    }
                });
            }
        });
        this.qualitySlider.setPaintLabels(true);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setMajorTickSpacing(1);
        this.qualitySlider.setSnapToTicks(true);
        final boolean bl2 = Component3DManager.getInstance().isOffScreenImageSupported();
        this.qualitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!bl2) {
                    PhotoPanel.this.qualitySlider.setValue(Math.max(PhotoPanel.this.qualitySlider.getMinimum() + 2, PhotoPanel.this.qualitySlider.getValue()));
                }
                photoController.setQuality(PhotoPanel.this.qualitySlider.getValue() - PhotoPanel.this.qualitySlider.getMinimum());
            }
        });
        photoController.addPropertyChangeListener(PhotoController.Property.QUALITY, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotoPanel.this.qualitySlider.setValue(PhotoPanel.this.qualitySlider.getMinimum() + photoController.getQuality());
                PhotoPanel.this.updateAdvancedComponents();
            }
        });
        this.qualitySlider.setValue(this.qualitySlider.getMinimum() + photoController.getQuality());
        this.advancedComponentsSeparator = new JSeparator();
        Date date = new Date(Camera.convertTimeToTimeZone(photoController.getTime(), TimeZone.getDefault().getID()));
        this.dateLabel = new JLabel();
        final SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setValue(date);
        this.dateSpinner = new JSpinner(spinnerDateModel);
        String string = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
        if (string.indexOf("yyyy") == -1) {
            string = string.replace("yy", "yyyy");
        }
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.dateSpinner, string);
        this.dateSpinner.setEditor(dateEditor);
        SwingTools.addAutoSelectionOnFocusGain(dateEditor.getTextField());
        this.timeLabel = new JLabel();
        final SpinnerDateModel spinnerDateModel2 = new SpinnerDateModel();
        spinnerDateModel2.setValue(date);
        this.timeSpinner = new JSpinner(spinnerDateModel2);
        Object[] objectArray = new String[]{"AU", "BD", "CA", "CO", "EG", "HN", "JO", "MX", "MY", "NI", "NZ", "PH", "PK", "SA", "SV", "US", "VE"};
        SimpleDateFormat simpleDateFormat = "en".equals(Locale.getDefault().getLanguage()) ? (Arrays.binarySearch(objectArray, Locale.getDefault().getCountry()) >= 0 ? (SimpleDateFormat)DateFormat.getTimeInstance(3, Locale.US) : (SimpleDateFormat)DateFormat.getTimeInstance(3, Locale.UK)) : (SimpleDateFormat)DateFormat.getTimeInstance(3);
        JSpinner.DateEditor dateEditor2 = new JSpinner.DateEditor(this.timeSpinner, simpleDateFormat.toPattern());
        this.timeSpinner.setEditor(dateEditor2);
        SwingTools.addAutoSelectionOnFocusGain(dateEditor2.getTextField());
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Date date = new Date(Camera.convertTimeToTimeZone(photoController.getTime(), TimeZone.getDefault().getID()));
                spinnerDateModel.setValue(date);
                spinnerDateModel2.setValue(date);
            }
        };
        photoController.addPropertyChangeListener(PhotoController.Property.TIME, propertyChangeListener);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                photoController.removePropertyChangeListener(PhotoController.Property.TIME, propertyChangeListener);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime((Date)spinnerDateModel.getValue());
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                gregorianCalendar2.setTime((Date)spinnerDateModel2.getValue());
                GregorianCalendar gregorianCalendar3 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                gregorianCalendar3.set(1, gregorianCalendar.get(1));
                gregorianCalendar3.set(2, gregorianCalendar.get(2));
                gregorianCalendar3.set(5, gregorianCalendar.get(5));
                gregorianCalendar3.set(11, gregorianCalendar2.get(11));
                gregorianCalendar3.set(12, gregorianCalendar2.get(12));
                gregorianCalendar3.set(13, gregorianCalendar2.get(13));
                photoController.setTime(gregorianCalendar3.getTimeInMillis());
                photoController.addPropertyChangeListener(PhotoController.Property.TIME, propertyChangeListener);
            }
        };
        spinnerDateModel.addChangeListener(changeListener);
        spinnerDateModel2.addChangeListener(changeListener);
        this.dayNightLabel = new JLabel();
        final ImageIcon imageIcon = new ImageIcon(PhotoPanel.class.getResource("resources/day.png"));
        final ImageIcon imageIcon2 = new ImageIcon(PhotoPanel.class.getResource("resources/night.png"));
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (home.getCompass().getSunElevation(Camera.convertTimeToTimeZone(photoController.getTime(), home.getCompass().getTimeZone())) > 0.0f) {
                    PhotoPanel.this.dayNightLabel.setIcon(imageIcon);
                } else {
                    PhotoPanel.this.dayNightLabel.setIcon(imageIcon2);
                }
            }
        };
        photoController.addPropertyChangeListener(PhotoController.Property.TIME, propertyChangeListener2);
        home.getCompass().addPropertyChangeListener(propertyChangeListener2);
        propertyChangeListener2.propertyChange(null);
        this.lensLabel = new JLabel();
        this.lensComboBox = new JComboBox<Camera.Lens>(Camera.Lens.values());
        this.lensComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                switch ((Camera.Lens)((Object)object)) {
                    case NORMAL: {
                        string = userPreferences.getLocalizedString(PhotoPanel.class, "lensComboBox.normalLens.text", new Object[0]);
                        break;
                    }
                    case SPHERICAL: {
                        string = userPreferences.getLocalizedString(PhotoPanel.class, "lensComboBox.sphericalLens.text", new Object[0]);
                        break;
                    }
                    case FISHEYE: {
                        string = userPreferences.getLocalizedString(PhotoPanel.class, "lensComboBox.fisheyeLens.text", new Object[0]);
                        break;
                    }
                    default: {
                        string = userPreferences.getLocalizedString(PhotoPanel.class, "lensComboBox.pinholeLens.text", new Object[0]);
                    }
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.lensComboBox.setSelectedItem((Object)photoController.getLens());
        photoController.addPropertyChangeListener(PhotoController.Property.LENS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotoPanel.this.lensComboBox.setSelectedItem((Object)photoController.getLens());
            }
        });
        this.lensComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Camera.Lens lens = (Camera.Lens)((Object)PhotoPanel.this.lensComboBox.getSelectedItem());
                photoController.setLens(lens);
                if (lens == Camera.Lens.SPHERICAL) {
                    PhotoPanel.this.applyProportionsCheckBox.setSelected(true);
                    PhotoPanel.this.aspectRatioComboBox.setSelectedItem((Object)AspectRatio.RATIO_2_1);
                } else if (lens == Camera.Lens.FISHEYE) {
                    PhotoPanel.this.applyProportionsCheckBox.setSelected(true);
                    PhotoPanel.this.aspectRatioComboBox.setSelectedItem((Object)AspectRatio.SQUARE_RATIO);
                }
                PhotoPanel.this.updateRatioComponents();
            }
        });
        this.ceilingLightEnabledCheckBox = new JCheckBox();
        this.ceilingLightEnabledCheckBox.setSelected(photoController.getCeilingLightColor() > 0);
        photoController.addPropertyChangeListener(PhotoController.Property.CEILING_LIGHT_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotoPanel.this.ceilingLightEnabledCheckBox.setSelected(photoController.getCeilingLightColor() > 0);
            }
        });
        this.ceilingLightEnabledCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                photoController.setCeilingLightColor(PhotoPanel.this.ceilingLightEnabledCheckBox.isSelected() ? 0xD0D0D0 : 0);
            }
        });
        JComponent jComponent = (JComponent)((Object)photoController.get3DView());
        photoController.set3DViewAspectRatio((float)jComponent.getWidth() / (float)jComponent.getHeight());
        ActionMap actionMap = this.getActionMap();
        this.createButton = new JButton(actionMap.get((Object)ActionType.START_PHOTO_CREATION));
        this.saveButton = new JButton(actionMap.get((Object)ActionType.SAVE_PHOTO));
        this.closeButton = new JButton(actionMap.get((Object)ActionType.CLOSE));
        this.setComponentTexts(userPreferences);
        this.updateRatioComponents();
    }

    private float getSliderValueAt(JSlider jSlider, int n, UserPreferences userPreferences) {
        int n2 = OperatingSystem.isLinux() ? 0 : new JLabel((String)SwingTools.getLocalizedLabelText((UserPreferences)userPreferences, PhotoPanel.class, (String)"fastLabel.text", (Object[])new Object[0])).getPreferredSize().width / 2;
        int n3 = OperatingSystem.isLinux() ? 0 : new JLabel((String)SwingTools.getLocalizedLabelText((UserPreferences)userPreferences, PhotoPanel.class, (String)"bestLabel.text", (Object[])new Object[0])).getPreferredSize().width / 2;
        int n4 = jSlider.getWidth() - n2 - n3;
        return (float)jSlider.getMinimum() + (float)(n - (jSlider.getComponentOrientation().isLeftToRight() ? n2 : n3)) / (float)n4 * (float)(jSlider.getMaximum() - jSlider.getMinimum());
    }

    private void setComponentTexts(UserPreferences userPreferences) {
        this.widthLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "widthLabel.text", new Object[0]));
        this.heightLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "heightLabel.text", new Object[0]));
        this.applyProportionsCheckBox.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "applyProportionsCheckBox.text", new Object[0]));
        this.qualityLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "qualityLabel.text", new Object[0]));
        this.dateLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "dateLabel.text", new Object[0]));
        this.timeLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "timeLabel.text", new Object[0]));
        this.lensLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "lensLabel.text", new Object[0]));
        this.ceilingLightEnabledCheckBox.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "ceilingLightEnabledCheckBox.text", new Object[0]));
        JLabel jLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "fastLabel.text", new Object[0]));
        if (!Component3DManager.getInstance().isOffScreenImageSupported()) {
            jLabel.setEnabled(false);
        }
        JLabel jLabel2 = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PhotoPanel.class, "bestLabel.text", new Object[0]));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(this.qualitySlider.getMinimum(), jLabel);
        ((Dictionary)hashtable).put(this.qualitySlider.getMaximum(), jLabel2);
        this.qualitySlider.setLabelTable(hashtable);
        this.dialogTitle = userPreferences.getLocalizedString(PhotoPanel.class, "createPhoto.title", new Object[0]);
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            ((JDialog)window).setTitle(this.dialogTitle);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
            this.applyProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "applyProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.qualityLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "qualityLabel.mnemonic", new Object[0])).getKeyCode());
            this.qualityLabel.setLabelFor(this.qualitySlider);
            this.dateLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "dateLabel.mnemonic", new Object[0])).getKeyCode());
            this.dateLabel.setLabelFor(this.dateSpinner);
            this.timeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "timeLabel.mnemonic", new Object[0])).getKeyCode());
            this.timeLabel.setLabelFor(this.timeSpinner);
            this.lensLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "lensLabel.mnemonic", new Object[0])).getKeyCode());
            this.lensLabel.setLabelFor(this.lensComboBox);
            this.ceilingLightEnabledCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotoPanel.class, "ceilingLightEnabledCheckBox.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 11 : 10;
        this.photoCardLayout = new CardLayout();
        this.photoPanel = new JPanel(this.photoCardLayout);
        this.photoPanel.add((Component)this.photoComponent, PHOTO_CARD);
        this.photoPanel.add((Component)this.animatedWaitLabel, WAIT_CARD);
        this.add((Component)this.photoPanel, new GridBagConstraints(0, 0, 7, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 7, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(6, 1, 1, 7, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Insets insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.widthLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.widthLabel.setHorizontalAlignment(n);
        Insets insets2 = new Insets(0, 0, 0, 10);
        this.add((Component)this.widthSpinner, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.heightLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.heightLabel.setHorizontalAlignment(n);
        this.add((Component)this.heightSpinner, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.add(this.applyProportionsCheckBox);
        jPanel.add(this.aspectRatioComboBox);
        this.add((Component)jPanel, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.qualityLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 5), 0, 0));
        this.qualityLabel.setHorizontalAlignment(n);
        this.add((Component)this.qualitySlider, new GridBagConstraints(2, 3, 4, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.advancedComponentsSeparator, new GridBagConstraints(1, 5, 5, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)this.dateLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.dateLabel.setHorizontalAlignment(n);
        this.add((Component)this.dateSpinner, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 10), 8, 0));
        this.add((Component)this.timeLabel, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.timeLabel.setHorizontalAlignment(n);
        this.add((Component)this.timeSpinner, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.dayNightLabel, new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.lensLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.lensLabel.setHorizontalAlignment(n);
        this.add((Component)this.lensComboBox, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.lensComboBox.setPreferredSize(new Dimension(this.widthSpinner.getPreferredSize().width, this.lensComboBox.getPreferredSize().height));
        this.add((Component)this.ceilingLightEnabledCheckBox, new GridBagConstraints(3, 7, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateAdvancedComponents() {
        Component component = SwingUtilities.getRoot(this);
        if (component != null) {
            boolean bl = this.controller.getQuality() >= 2;
            boolean bl2 = this.advancedComponentsSeparator.isVisible();
            if (bl2 != bl) {
                int n = this.advancedComponentsSeparator.getPreferredSize().height + 6 + this.dateSpinner.getPreferredSize().height + 5 + this.lensComboBox.getPreferredSize().height;
                this.advancedComponentsSeparator.setVisible(bl);
                this.dateLabel.setVisible(bl);
                this.dateSpinner.setVisible(bl);
                this.timeLabel.setVisible(bl);
                this.timeSpinner.setVisible(bl);
                this.dayNightLabel.setVisible(bl);
                this.lensLabel.setVisible(bl);
                this.lensComboBox.setVisible(bl);
                this.ceilingLightEnabledCheckBox.setVisible(bl);
                component.setSize(component.getWidth(), component.getHeight() + (bl2 ? -n : n));
            }
        }
    }

    private void updateRatioComponents() {
        Camera.Lens lens = this.controller.getLens();
        boolean bl = lens == Camera.Lens.FISHEYE || lens == Camera.Lens.SPHERICAL;
        this.applyProportionsCheckBox.setEnabled(!bl);
        this.aspectRatioComboBox.setEnabled(!bl && this.applyProportionsCheckBox.isSelected());
    }

    public void displayView(View view) {
        if (currentPhotoPanel == this) {
            SwingUtilities.getWindowAncestor(this).toFront();
        } else {
            Object object;
            Serializable serializable;
            if (currentPhotoPanel != null) {
                currentPhotoPanel.close();
            }
            final JOptionPane jOptionPane = new JOptionPane(this, -1, 2, null, new Object[]{this.createButton, this.saveButton, this.closeButton}, this.createButton);
            if (view != null) {
                jOptionPane.setComponentOrientation(((JComponent)((Object)view)).getComponentOrientation());
            }
            final JDialog jDialog = jOptionPane.createDialog(SwingUtilities.getRootPane((Component)((Object)view)), this.dialogTitle);
            jDialog.setModal(false);
            Component component = SwingUtilities.getRoot((Component)((Object)view));
            if (component != null) {
                serializable = (Integer)this.home.getVisualProperty(PHOTO_DIALOG_X_VISUAL_PROPERTY);
                object = (Integer)this.home.getVisualProperty(PHOTO_DIALOG_Y_VISUAL_PROPERTY);
                int n = component.getX() + component.getWidth();
                Dimension dimension = this.getToolkit().getScreenSize();
                Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
                int n2 = dimension.width - insets.right;
                int n3 = dimension.height - insets.top - insets.bottom;
                if (OperatingSystem.isLinux() && n3 == dimension.height) {
                    n3 -= 30;
                }
                int n4 = dimension.height - insets.bottom;
                int n5 = jDialog.getWidth();
                if (jDialog.getHeight() > n3) {
                    jDialog.setSize(n5, n3);
                }
                int n6 = jDialog.getHeight();
                if (serializable != null && object != null && (Integer)serializable + n5 <= n2 && (Integer)object + n6 <= n4) {
                    jDialog.setLocation((Integer)serializable, (Integer)object);
                } else if (n2 - n > n5 / 2 || n6 == n3) {
                    jDialog.setLocation(Math.min(n + 5, n2 - n5), Math.max(Math.min(component.getY(), dimension.height - n6 - insets.bottom), insets.top));
                } else {
                    jDialog.setLocationByPlatform(true);
                }
            } else {
                jDialog.setLocationByPlatform(true);
            }
            serializable = (JComponent)((Object)this.controller.get3DView());
            object = new ComponentAdapter((JComponent)serializable){
                final /* synthetic */ JComponent val$view3D;
                {
                    this.val$view3D = jComponent;
                }

                public void componentResized(ComponentEvent componentEvent) {
                    PhotoPanel.this.controller.set3DViewAspectRatio((float)this.val$view3D.getWidth() / (float)this.val$view3D.getHeight());
                }
            };
            ((Component)serializable).addComponentListener((ComponentListener)object);
            jDialog.addWindowListener(new WindowAdapter((ComponentAdapter)object){
                final /* synthetic */ ComponentAdapter val$view3DSizeListener;
                {
                    this.val$view3DSizeListener = componentAdapter;
                }

                public void windowClosed(WindowEvent windowEvent) {
                    ((JComponent)((Object)PhotoPanel.this.controller.get3DView())).removeComponentListener(this.val$view3DSizeListener);
                    PhotoPanel.this.stopPhotoCreation(false);
                    currentPhotoPanel = null;
                }
            });
            this.updateAdvancedComponents();
            ToolTipManager.sharedInstance().registerComponent(this.qualitySlider);
            jDialog.setDefaultCloseOperation(2);
            jDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                    if (jOptionPane.getValue() != null && jOptionPane.getValue() != JOptionPane.UNINITIALIZED_VALUE) {
                        PhotoPanel.this.close();
                    }
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    PhotoPanel.this.controller.setVisualProperty(PhotoPanel.PHOTO_DIALOG_X_VISUAL_PROPERTY, jDialog.getX());
                    PhotoPanel.this.controller.setVisualProperty(PhotoPanel.PHOTO_DIALOG_Y_VISUAL_PROPERTY, jDialog.getY());
                }
            });
            jDialog.setVisible(true);
            currentPhotoPanel = this;
        }
    }

    private void startPhotoCreation() {
        this.photoComponent.setImage(null);
        this.widthSpinner.setEnabled(false);
        this.heightSpinner.setEnabled(false);
        this.applyProportionsCheckBox.setEnabled(false);
        this.aspectRatioComboBox.setEnabled(false);
        this.qualitySlider.setEnabled(false);
        this.dateSpinner.setEnabled(false);
        this.timeSpinner.setEnabled(false);
        this.lensComboBox.setEnabled(false);
        this.ceilingLightEnabledCheckBox.setEnabled(false);
        this.getActionMap().get((Object)ActionType.SAVE_PHOTO).setEnabled(false);
        this.getRootPane().setDefaultButton(this.createButton);
        this.createButton.setAction(this.getActionMap().get((Object)ActionType.STOP_PHOTO_CREATION));
        this.photoCardLayout.show(this.photoPanel, WAIT_CARD);
        final Home home = this.home.clone();
        List list = Collections.emptyList();
        home.setSelectedItems(list);
        this.photoCreationExecutor = Executors.newSingleThreadExecutor();
        this.photoCreationExecutor.execute(new Runnable(){

            public void run() {
                PhotoPanel.this.computePhoto(home);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void computePhoto(Home var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BufferedImage getErrorImage() {
        Icon icon = IconManager.getInstance().getErrorIcon(16);
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        icon.paintIcon(this, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void stopPhotoCreation(boolean bl) {
        if (!(this.photoCreationExecutor == null || bl && System.currentTimeMillis() - this.photoCreationStartTime >= 30000L && JOptionPane.showConfirmDialog(this.getRootPane(), this.preferences.getLocalizedString(PhotoPanel.class, "confirmStopCreation.message", new Object[0]), this.preferences.getLocalizedString(PhotoPanel.class, "confirmStopCreation.title", new Object[0]), 0, 2) != 0 || this.photoCreationExecutor == null)) {
            this.photoCreationExecutor.shutdownNow();
            this.photoCreationExecutor = null;
            this.createButton.setAction(this.getActionMap().get((Object)ActionType.START_PHOTO_CREATION));
        }
    }

    private void savePhoto() {
        String string = this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(PhotoPanel.class, "savePhotoDialog.title", new Object[0]), ContentManager.ContentType.PNG, this.home.getName());
        try {
            if (string != null) {
                ImageIO.write((RenderedImage)this.photoComponent.getImage(), "PNG", new File(string));
            }
        }
        catch (IOException iOException) {
            String string2 = this.preferences.getLocalizedString(PhotoPanel.class, "savePhotoError.message", new Object[0]);
            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this), String.format(string2, iOException.getMessage()), this.preferences.getLocalizedString(PhotoPanel.class, "savePhotoError.title", new Object[0]), 0);
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window.isDisplayable()) {
            ToolTipManager.sharedInstance().unregisterComponent(this.qualitySlider);
            window.dispose();
        }
    }

    public static class LanguageChangeListener
    implements PropertyChangeListener {
        private final WeakReference<PhotoPanel> photoPanel;

        public LanguageChangeListener(PhotoPanel photoPanel) {
            this.photoPanel = new WeakReference<PhotoPanel>(photoPanel);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotoPanel photoPanel = (PhotoPanel)this.photoPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (photoPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                photoPanel.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                photoPanel.setComponentTexts(userPreferences);
                photoPanel.setMnemonics(userPreferences);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        START_PHOTO_CREATION,
        STOP_PHOTO_CREATION,
        SAVE_PHOTO,
        CLOSE;

    }
}

