/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.HomePieceOfFurniture3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTKeyStroke;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.util.UserProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanComponent
extends JComponent
implements PlanView,
Scrollable,
Printable {
    private static final float MARGIN = 40.0f;
    private final Home home;
    private final UserPreferences preferences;
    private float scale = 0.5f;
    private boolean selectedItemsOutlinePainted = true;
    private boolean backgroundPainted = true;
    private PlanRulerComponent horizontalRuler;
    private PlanRulerComponent verticalRuler;
    private final Cursor rotationCursor;
    private final Cursor elevationCursor;
    private final Cursor heightCursor;
    private final Cursor powerCursor;
    private final Cursor resizeCursor;
    private final Cursor panningCursor;
    private final Cursor duplicationCursor;
    private Rectangle2D rectangleFeedback;
    private Class<? extends Selectable> alignedObjectClass;
    private Selectable alignedObjectFeedback;
    private Point2D locationFeeback;
    private boolean showPointFeedback;
    private Point2D centerAngleFeedback;
    private Point2D point1AngleFeedback;
    private Point2D point2AngleFeedback;
    private List<Selectable> draggedItemsFeedback;
    private List<DimensionLine> dimensionLinesFeedback;
    private boolean selectionScrollUpdated;
    private JToolTip toolTip;
    private JWindow toolTipWindow;
    private boolean resizeIndicatorVisible;
    private Map<PlanController.EditableProperty, JFormattedTextField> toolTipEditableTextFields;
    private KeyListener toolTipKeyListener;
    private List<HomePieceOfFurniture> sortedHomeFurniture;
    private List<Room> sortedHomeRooms;
    private Map<TextStyle, Font> fonts;
    private Map<TextStyle, FontMetrics> fontsMetrics;
    private Rectangle2D planBoundsCache;
    private boolean planBoundsCacheValid = false;
    private BufferedImage backgroundImageCache;
    private BufferedImage wallsPatternImageCache;
    private Color wallsPatternBackgroundCache;
    private Color wallsPatternForegroundCache;
    private Area wallsAreaCache;
    private Map<Content, BufferedImage> floorTextureImagesCache;
    private Map<HomePieceOfFurniture, PieceOfFurnitureTopViewIcon> furnitureTopViewIconsCache;
    private static final Shape POINT_INDICATOR;
    private static final GeneralPath FURNITURE_ROTATION_INDICATOR;
    private static final GeneralPath FURNITURE_RESIZE_INDICATOR;
    private static final GeneralPath FURNITURE_ELEVATION_INDICATOR;
    private static final Shape FURNITURE_ELEVATION_POINT_INDICATOR;
    private static final GeneralPath FURNITURE_HEIGHT_INDICATOR;
    private static final Shape FURNITURE_HEIGHT_POINT_INDICATOR;
    private static final GeneralPath LIGHT_POWER_INDICATOR;
    private static final Shape LIGHT_POWER_POINT_INDICATOR;
    private static final GeneralPath WALL_ORIENTATION_INDICATOR;
    private static final Shape WALL_POINT;
    private static final GeneralPath WALL_AND_LINE_RESIZE_INDICATOR;
    private static final Shape CAMERA_YAW_ROTATION_INDICATOR;
    private static final GeneralPath CAMERA_PITCH_ROTATION_INDICATOR;
    private static final GeneralPath CAMERA_ELEVATION_INDICATOR;
    private static final Shape CAMERA_BODY;
    private static final Shape CAMERA_HEAD;
    private static final GeneralPath DIMENSION_LINE_END;
    private static final GeneralPath TEXT_LOCATION_INDICATOR;
    private static final Shape COMPASS_DISC;
    private static final GeneralPath COMPASS;
    private static final GeneralPath COMPASS_ROTATION_INDICATOR;
    private static final GeneralPath COMPASS_RESIZE_INDICATOR;
    private static final Stroke INDICATOR_STROKE;
    private static final Stroke POINT_STROKE;
    private static final float WALL_STROKE_WIDTH = 1.5f;
    private static final float BORDER_STROKE_WIDTH = 1.0f;
    private static final BufferedImage ERROR_TEXTURE_IMAGE;
    private static final BufferedImage WAIT_TEXTURE_IMAGE;

    public PlanComponent(Home home, UserPreferences userPreferences, PlanController planController) {
        this.home = home;
        this.preferences = userPreferences;
        this.setOpaque(true);
        this.addModelListeners(home, userPreferences, planController);
        this.createToolTipTextFields(userPreferences, planController);
        if (planController != null) {
            this.addMouseListeners(planController);
            this.addFocusListener(planController);
            this.createActions(planController);
            this.installDefaultKeyboardActions();
            this.setFocusable(true);
            this.setAutoscrolls(true);
        }
        this.rotationCursor = this.createCustomCursor("resources/cursors/rotation16x16.png", "resources/cursors/rotation32x32.png", "Rotation cursor", 13);
        this.elevationCursor = this.createCustomCursor("resources/cursors/elevation16x16.png", "resources/cursors/elevation32x32.png", "Elevation cursor", 13);
        this.heightCursor = this.createCustomCursor("resources/cursors/height16x16.png", "resources/cursors/height32x32.png", "Height cursor", 13);
        this.powerCursor = this.createCustomCursor("resources/cursors/power16x16.png", "resources/cursors/power32x32.png", "Power cursor", 13);
        this.resizeCursor = this.createCustomCursor("resources/cursors/resize16x16.png", "resources/cursors/resize32x32.png", "Resize cursor", 13);
        this.panningCursor = this.createCustomCursor("resources/cursors/panning16x16.png", "resources/cursors/panning32x32.png", "Panning cursor", 12);
        this.duplicationCursor = DragSource.DefaultCopyDrop;
        super.setForeground(UIManager.getColor("textText"));
        super.setBackground(UIManager.getColor("window"));
    }

    private void addModelListeners(Home home, final UserPreferences userPreferences, PlanController planController) {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PlanComponent.this.furnitureTopViewIconsCache != null && (HomePieceOfFurniture.Property.COLOR.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.TEXTURE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.SHININESS.name().equals(propertyChangeEvent.getPropertyName()) || (HomePieceOfFurniture.Property.WIDTH.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.DEPTH.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.HEIGHT.name().equals(propertyChangeEvent.getPropertyName())) && ((HomePieceOfFurniture)propertyChangeEvent.getSource()).getTexture() != null)) {
                    for (HomePieceOfFurniture homePieceOfFurniture : PlanComponent.this.getFurnitureWithoutGroups((HomePieceOfFurniture)propertyChangeEvent.getSource())) {
                        PlanComponent.this.furnitureTopViewIconsCache.remove(homePieceOfFurniture);
                    }
                    PlanComponent.this.repaint();
                } else if (HomePieceOfFurniture.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName())) {
                    PlanComponent.this.sortedHomeFurniture = null;
                    PlanComponent.this.repaint();
                } else if (!HomePieceOfFurniture.Property.HEIGHT.name().equals(propertyChangeEvent.getPropertyName())) {
                    PlanComponent.this.revalidate();
                }
            }
        };
        for (HomePieceOfFurniture object32 : home.getFurniture()) {
            object32.addPropertyChangeListener(propertyChangeListener);
        }
        home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                }
                PlanComponent.this.sortedHomeFurniture = null;
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Wall.Property.X_START.name().equals(string) || Wall.Property.X_END.name().equals(string) || Wall.Property.Y_START.name().equals(string) || Wall.Property.Y_END.name().equals(string) || Wall.Property.WALL_AT_START.name().equals(string) || Wall.Property.WALL_AT_END.name().equals(string) || Wall.Property.THICKNESS.name().equals(string) || Wall.Property.ARC_EXTENT.name().equals(string)) {
                    PlanComponent.this.wallsAreaCache = null;
                    PlanComponent.this.revalidate();
                }
            }
        };
        for (Wall wall : home.getWalls()) {
            wall.addPropertyChangeListener(propertyChangeListener2);
        }
        home.addWallsListener(new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                }
                PlanComponent.this.wallsAreaCache = null;
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Room.Property.POINTS.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.NAME.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.NAME_X_OFFSET.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.NAME_Y_OFFSET.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.NAME_STYLE.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.AREA_VISIBLE.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.AREA_X_OFFSET.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.AREA_Y_OFFSET.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.AREA_STYLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    PlanComponent.this.sortedHomeRooms = null;
                    PlanComponent.this.revalidate();
                } else if (userPreferences.isRoomFloorColoredOrTextured() && (Room.Property.FLOOR_COLOR.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.FLOOR_TEXTURE.name().equals(propertyChangeEvent.getPropertyName()) || Room.Property.FLOOR_VISIBLE.name().equals(propertyChangeEvent.getPropertyName()))) {
                    PlanComponent.this.repaint();
                }
            }
        };
        for (Room room : home.getRooms()) {
            room.addPropertyChangeListener(propertyChangeListener3);
        }
        home.addRoomsListener(new CollectionListener<Room>(){

            @Override
            public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener3);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener3);
                }
                PlanComponent.this.sortedHomeRooms = null;
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.revalidate();
            }
        };
        for (DimensionLine dimensionLine : home.getDimensionLines()) {
            dimensionLine.addPropertyChangeListener(propertyChangeListener4);
        }
        home.addDimensionLinesListener(new CollectionListener<DimensionLine>(){

            @Override
            public void collectionChanged(CollectionEvent<DimensionLine> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener4);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener4);
                }
                PlanComponent.this.revalidate();
            }
        });
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.revalidate();
            }
        };
        for (Label label : home.getLabels()) {
            label.addPropertyChangeListener(propertyChangeListener5);
        }
        home.addLabelsListener(new CollectionListener<Label>(){

            @Override
            public void collectionChanged(CollectionEvent<Label> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener5);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener5);
                }
                PlanComponent.this.revalidate();
            }
        });
        home.getObserverCamera().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Camera.Property.X.name().equals(string) || Camera.Property.Y.name().equals(string) || Camera.Property.Z.name().equals(string) || Camera.Property.FIELD_OF_VIEW.name().equals(string) || Camera.Property.YAW.name().equals(string)) {
                    PlanComponent.this.revalidate();
                }
            }
        });
        home.getCompass().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Compass.Property.X.name().equals(string) || Compass.Property.Y.name().equals(string) || Compass.Property.NORTH_DIRECTION.name().equals(string) || Compass.Property.DIAMETER.name().equals(string) || Compass.Property.VISIBLE.name().equals(string)) {
                    PlanComponent.this.revalidate();
                }
            }
        });
        home.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                PlanComponent.this.repaint();
            }
        });
        home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanComponent.this.backgroundImageCache = null;
                PlanComponent.this.repaint();
            }
        });
        userPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.GRID_VISIBLE, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.FURNITURE_VIEWED_FROM_TOP, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.ROOM_FLOOR_COLORED_OR_TEXTURED, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.WALL_PATTERN, new UserPreferencesChangeListener(this));
    }

    private List<HomePieceOfFurniture> getFurnitureWithoutGroups(HomePieceOfFurniture homePieceOfFurniture) {
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                arrayList.addAll(this.getFurnitureWithoutGroups(homePieceOfFurniture2));
            }
            return arrayList;
        }
        return Arrays.asList(homePieceOfFurniture);
    }

    @Override
    public void revalidate() {
        this.revalidate(true);
    }

    private void revalidate(boolean bl) {
        boolean bl2 = this.planBoundsCacheValid;
        float f = (float)this.getPlanBounds().getMinX();
        float f2 = (float)this.getPlanBounds().getMinY();
        if (bl && bl2) {
            this.planBoundsCacheValid = false;
        }
        super.revalidate();
        this.repaint();
        if (bl && this.getParent() instanceof JViewport) {
            float f3 = (float)this.getPlanBounds().getMinX();
            float f4 = (float)this.getPlanBounds().getMinY();
            if (f3 < f || f4 < f2) {
                JViewport jViewport = (JViewport)this.getParent();
                Point point = jViewport.getViewPosition();
                Dimension dimension = jViewport.getExtentSize();
                Dimension dimension2 = jViewport.getViewSize();
                if (dimension.width < dimension2.width || dimension.height < dimension2.height) {
                    int n = Math.round((f - f3) * this.getScale());
                    int n2 = Math.round((f2 - f4) * this.getScale());
                    jViewport.setViewPosition(new Point(point.x + n, point.y + n2));
                }
            }
        }
        if (this.horizontalRuler != null) {
            this.horizontalRuler.revalidate();
            this.horizontalRuler.repaint();
        }
        if (this.verticalRuler != null) {
            this.verticalRuler.revalidate();
            this.verticalRuler.repaint();
        }
    }

    private void addMouseListeners(final PlanController planController) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private Point lastMousePressedLocation;

            public void mousePressed(MouseEvent mouseEvent) {
                this.lastMousePressedLocation = mouseEvent.getPoint();
                if (PlanComponent.this.isEnabled() && !mouseEvent.isPopupTrigger()) {
                    PlanComponent.this.requestFocusInWindow();
                    if (mouseEvent.getButton() == 1) {
                        planController.pressMouse(PlanComponent.this.convertXPixelToModel(mouseEvent.getX()), PlanComponent.this.convertYPixelToModel(mouseEvent.getY()), mouseEvent.getClickCount(), mouseEvent.isShiftDown(), OperatingSystem.isMacOSX() ? mouseEvent.isAltDown() : mouseEvent.isControlDown());
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (PlanComponent.this.isEnabled() && !mouseEvent.isPopupTrigger() && mouseEvent.getButton() == 1) {
                    planController.releaseMouse(PlanComponent.this.convertXPixelToModel(mouseEvent.getX()), PlanComponent.this.convertYPixelToModel(mouseEvent.getY()));
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (this.lastMousePressedLocation != null && !this.lastMousePressedLocation.equals(mouseEvent.getPoint())) {
                    this.lastMousePressedLocation = null;
                }
                if (this.lastMousePressedLocation == null && PlanComponent.this.isEnabled()) {
                    planController.moveMouse(PlanComponent.this.convertXPixelToModel(mouseEvent.getX()), PlanComponent.this.convertYPixelToModel(mouseEvent.getY()));
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (PlanComponent.this.isEnabled()) {
                    this.mouseMoved(mouseEvent);
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getModifiers() == PlanComponent.this.getToolkit().getMenuShortcutKeyMask()) {
                    planController.zoom((float)(mouseWheelEvent.getWheelRotation() < 0 ? Math.pow(1.05, -mouseWheelEvent.getWheelRotation()) : Math.pow(0.95, mouseWheelEvent.getWheelRotation())));
                } else if (PlanComponent.this.getMouseWheelListeners().length == 1) {
                    PlanComponent.this.getParent().dispatchEvent(new MouseWheelEvent((Component)PlanComponent.this.getParent(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx() | mouseWheelEvent.getModifiers(), mouseWheelEvent.getX() - PlanComponent.this.getX(), mouseWheelEvent.getY() - PlanComponent.this.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
                }
            }
        });
    }

    private void addFocusListener(final PlanController planController) {
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                planController.escape();
            }
        });
    }

    private void installDefaultKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.clear();
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), (Object)ActionType.DELETE_SELECTION);
        inputMap.put(KeyStroke.getKeyStroke("BACK_SPACE"), (Object)ActionType.DELETE_SELECTION);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), (Object)ActionType.MOVE_SELECTION_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), (Object)ActionType.MOVE_SELECTION_FAST_LEFT);
        inputMap.put(KeyStroke.getKeyStroke("UP"), (Object)ActionType.MOVE_SELECTION_UP);
        inputMap.put(KeyStroke.getKeyStroke("shift UP"), (Object)ActionType.MOVE_SELECTION_FAST_UP);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), (Object)ActionType.MOVE_SELECTION_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("shift DOWN"), (Object)ActionType.MOVE_SELECTION_FAST_DOWN);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), (Object)ActionType.MOVE_SELECTION_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), (Object)ActionType.MOVE_SELECTION_FAST_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke("shift pressed SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
        inputMap.put(KeyStroke.getKeyStroke("released SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
        inputMap.put(KeyStroke.getKeyStroke("shift ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), (Object)ActionType.ACTIVATE_EDITIION);
        if (OperatingSystem.isMacOSX()) {
            inputMap.put(KeyStroke.getKeyStroke("alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("alt shift pressed SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("alt released SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
        } else {
            inputMap.put(KeyStroke.getKeyStroke("control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("control ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("control shift pressed SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_ON);
            inputMap.put(KeyStroke.getKeyStroke("control released SHIFT"), (Object)ActionType.TOGGLE_MAGNETISM_OFF);
        }
    }

    private void installEditionKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.clear();
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("shift ESCAPE"), (Object)ActionType.ESCAPE);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
        if (OperatingSystem.isMacOSX()) {
            inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("alt ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("alt shift ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift alt pressed ALT"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released ALT"), (Object)ActionType.DEACTIVATE_DUPLICATION);
        } else {
            inputMap.put(KeyStroke.getKeyStroke("control ESCAPE"), (Object)ActionType.ESCAPE);
            inputMap.put(KeyStroke.getKeyStroke("control ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("control shift ENTER"), (Object)ActionType.DEACTIVATE_EDITIION);
            inputMap.put(KeyStroke.getKeyStroke("control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift control pressed CONTROL"), (Object)ActionType.ACTIVATE_DUPLICATION);
            inputMap.put(KeyStroke.getKeyStroke("shift released CONTROL"), (Object)ActionType.DEACTIVATE_DUPLICATION);
        }
    }

    private void createActions(final PlanController planController) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                planController.deleteSelection();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                planController.escape();
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put((Object)ActionType.DELETE_SELECTION, abstractAction);
        actionMap.put((Object)ActionType.ESCAPE, abstractAction2);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MoveSelectionAction
        extends AbstractAction {
            private final int dx;
            private final int dy;

            public MoveSelectionAction(int n, int n2) {
                this.dx = n;
                this.dy = n2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.moveSelection((float)this.dx / PlanComponent.this.getScale(), (float)this.dy / PlanComponent.this.getScale());
            }
        }
        actionMap.put((Object)ActionType.MOVE_SELECTION_LEFT, new MoveSelectionAction(-1, 0));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_LEFT, new MoveSelectionAction(-10, 0));
        actionMap.put((Object)ActionType.MOVE_SELECTION_UP, new MoveSelectionAction(0, -1));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_UP, new MoveSelectionAction(0, -10));
        actionMap.put((Object)ActionType.MOVE_SELECTION_DOWN, new MoveSelectionAction(0, 1));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_DOWN, new MoveSelectionAction(0, 10));
        actionMap.put((Object)ActionType.MOVE_SELECTION_RIGHT, new MoveSelectionAction(1, 0));
        actionMap.put((Object)ActionType.MOVE_SELECTION_FAST_RIGHT, new MoveSelectionAction(10, 0));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ToggleMagnetismAction
        extends AbstractAction {
            private final boolean toggle;

            public ToggleMagnetismAction(boolean bl) {
                this.toggle = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.toggleMagnetism(this.toggle);
            }
        }
        actionMap.put((Object)ActionType.TOGGLE_MAGNETISM_ON, new ToggleMagnetismAction(true));
        actionMap.put((Object)ActionType.TOGGLE_MAGNETISM_OFF, new ToggleMagnetismAction(false));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SetDuplicationActivatedAction
        extends AbstractAction {
            private final boolean duplicationActivated;

            public SetDuplicationActivatedAction(boolean bl) {
                this.duplicationActivated = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.setDuplicationActivated(this.duplicationActivated);
            }
        }
        actionMap.put((Object)ActionType.ACTIVATE_DUPLICATION, new SetDuplicationActivatedAction(true));
        actionMap.put((Object)ActionType.DEACTIVATE_DUPLICATION, new SetDuplicationActivatedAction(false));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SetEditionActivatedAction
        extends AbstractAction {
            private final boolean editionActivated;

            public SetEditionActivatedAction(boolean bl) {
                this.editionActivated = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                planController.setEditionActivated(this.editionActivated);
            }
        }
        actionMap.put((Object)ActionType.ACTIVATE_EDITIION, new SetEditionActivatedAction(true));
        actionMap.put((Object)ActionType.DEACTIVATE_EDITIION, new SetEditionActivatedAction(false));
    }

    private void createToolTipTextFields(UserPreferences userPreferences, final PlanController planController) {
        this.toolTipEditableTextFields = new HashMap<PlanController.EditableProperty, JFormattedTextField>();
        Font font = UIManager.getFont("ToolTip.font");
        for (final PlanController.EditableProperty editableProperty : PlanController.EditableProperty.values()) {
            final JFormattedTextField jFormattedTextField = new JFormattedTextField(){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(dimension.width + 1, dimension.height);
                }
            };
            PlanComponent.updateToolTipTextFieldFormatterFactory(jFormattedTextField, editableProperty, userPreferences);
            jFormattedTextField.setFont(font);
            jFormattedTextField.setOpaque(false);
            jFormattedTextField.setBorder(null);
            if (planController != null) {
                jFormattedTextField.getDocument().addDocumentListener(new DocumentListener(){

                    public void changedUpdate(DocumentEvent documentEvent) {
                        try {
                            jFormattedTextField.commitEdit();
                            planController.updateEditableProperty(editableProperty, jFormattedTextField.getValue());
                        }
                        catch (ParseException parseException) {
                            planController.updateEditableProperty(editableProperty, null);
                        }
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }
                });
            }
            this.toolTipEditableTextFields.put(editableProperty, jFormattedTextField);
        }
    }

    private static void updateToolTipTextFieldFormatterFactory(JFormattedTextField jFormattedTextField, PlanController.EditableProperty editableProperty, UserPreferences userPreferences) {
        Format format;
        InternationalFormatter internationalFormatter = editableProperty == PlanController.EditableProperty.ANGLE ? new NumberFormatter(NumberFormat.getNumberInstance()) : ((format = userPreferences.getLengthUnit().getFormat()) instanceof NumberFormat ? new NumberFormatter((NumberFormat)format) : new InternationalFormatter(format));
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(internationalFormatter));
    }

    private Cursor createCustomCursor(String string, String string2, String string3, int n) {
        return this.createCustomCursor(PlanComponent.class.getResource(string), PlanComponent.class.getResource(string2), 0.5f, 0.5f, string3, Cursor.getPredefinedCursor(n));
    }

    protected Cursor createCustomCursor(URL uRL, URL uRL2, float f, float f2, String string, Cursor cursor) {
        if (GraphicsEnvironment.isHeadless()) {
            return cursor;
        }
        Dimension dimension = this.getToolkit().getBestCursorSize(16, 16);
        if (dimension.width == 0) {
            return cursor;
        }
        URL uRL3 = dimension.width > 16 ? uRL2 : uRL;
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL3);
            return this.getToolkit().createCustomCursor(bufferedImage, new Point(Math.round((float)dimension.width * f2), Math.round((float)dimension.height * f)), string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unknown resource " + uRL3);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return new Dimension(Math.round(((float)rectangle2D.getWidth() + 80.0f) * this.getScale()) + insets.left + insets.right, Math.round(((float)rectangle2D.getHeight() + 80.0f) * this.getScale()) + insets.top + insets.bottom);
    }

    private Rectangle2D getPlanBounds() {
        if (!this.planBoundsCacheValid) {
            Object object;
            if (this.planBoundsCache == null || !(this.getParent() instanceof JViewport)) {
                this.planBoundsCache = new Rectangle2D.Float(0.0f, 0.0f, 1000.0f, 1000.0f);
            }
            if (this.backgroundImageCache != null) {
                object = this.home.getBackgroundImage();
                this.planBoundsCache.add((float)this.backgroundImageCache.getWidth() * ((BackgroundImage)object).getScale() - ((BackgroundImage)object).getXOrigin(), (float)this.backgroundImageCache.getHeight() * ((BackgroundImage)object).getScale() - ((BackgroundImage)object).getYOrigin());
            }
            if ((object = this.getItemsBounds(this.getGraphics(), this.getPaintedItems())) != null) {
                this.planBoundsCache.add((Rectangle2D)object);
            }
            for (float[] fArray : this.home.getObserverCamera().getPoints()) {
                this.planBoundsCache.add(fArray[0], fArray[1]);
            }
            this.planBoundsCacheValid = true;
        }
        return this.planBoundsCache;
    }

    protected List<Selectable> getPaintedItems() {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.home.getWalls());
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            if (!homePieceOfFurniture.isVisible()) continue;
            arrayList.add((Wall)((Object)homePieceOfFurniture));
        }
        arrayList.addAll(this.home.getRooms());
        arrayList.addAll(this.home.getDimensionLines());
        arrayList.addAll(this.home.getLabels());
        Compass compass = this.home.getCompass();
        if (compass.isVisible()) {
            arrayList.add(compass);
        }
        return arrayList;
    }

    private Rectangle2D getItemsBounds(Graphics graphics, Collection<? extends Selectable> collection) {
        Rectangle2D rectangle2D = null;
        for (Selectable selectable : collection) {
            if (rectangle2D == null) {
                rectangle2D = this.getItemBounds(graphics, selectable);
                continue;
            }
            rectangle2D.add(this.getItemBounds(graphics, selectable));
        }
        return rectangle2D;
    }

    protected Rectangle2D getItemBounds(Graphics graphics, Selectable selectable) {
        float[][] fArray = selectable.getPoints();
        Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0][0], fArray[0][1], 0.0f, 0.0f);
        for (int i = 1; i < fArray.length; ++i) {
            float_.add(fArray[i][0], fArray[i][1]);
        }
        Font font = graphics != null ? graphics.getFont() : this.getFont();
        if (selectable instanceof Room) {
            Object object;
            Object object2;
            float f;
            float f2;
            Room room = (Room)selectable;
            float f3 = room.getXCenter();
            float f4 = room.getYCenter();
            String string = room.getName();
            if (string != null && string.length() > 0) {
                f2 = f3 + room.getNameXOffset();
                f = f4 + room.getNameYOffset();
                TextStyle textStyle = room.getNameStyle();
                if (textStyle == null) {
                    textStyle = this.preferences.getDefaultTextStyle(room.getClass());
                }
                object2 = this.getFontMetrics(font, textStyle);
                object = ((FontMetrics)object2).getStringBounds(string, graphics);
                float_.add((double)f2 - ((RectangularShape)object).getWidth() / 2.0, f - (float)((FontMetrics)object2).getAscent());
                float_.add((double)f2 + ((RectangularShape)object).getWidth() / 2.0, f + (float)((FontMetrics)object2).getDescent());
            }
            if (room.isAreaVisible() && (f2 = room.getArea()) > 0.01f) {
                f = f3 + room.getAreaXOffset();
                float f5 = f4 + room.getAreaYOffset();
                object2 = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(f2));
                object = room.getAreaStyle();
                if (object == null) {
                    object = this.preferences.getDefaultTextStyle(room.getClass());
                }
                FontMetrics fontMetrics = this.getFontMetrics(font, (TextStyle)object);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object2, graphics);
                float_.add((double)f - rectangle2D.getWidth() / 2.0, f5 - (float)fontMetrics.getAscent());
                float_.add((double)f + rectangle2D.getWidth() / 2.0, f5 + (float)fontMetrics.getDescent());
            }
        } else if (selectable instanceof HomePieceOfFurniture) {
            HomePieceOfFurniture homePieceOfFurniture;
            if (selectable instanceof HomeDoorOrWindow) {
                homePieceOfFurniture = (HomeDoorOrWindow)selectable;
                for (Sash sash : ((HomeDoorOrWindow)homePieceOfFurniture).getSashes()) {
                    float_.add(this.getDoorOrWindowSashShape((HomeDoorOrWindow)homePieceOfFurniture, sash).getBounds2D());
                }
            } else if (selectable instanceof HomeFurnitureGroup) {
                float_.add(this.getItemsBounds(graphics, ((HomeFurnitureGroup)selectable).getFurniture()));
            }
            homePieceOfFurniture = (HomePieceOfFurniture)selectable;
            float f = homePieceOfFurniture.getX();
            float f6 = homePieceOfFurniture.getY();
            String string = homePieceOfFurniture.getName();
            if (homePieceOfFurniture.isVisible() && homePieceOfFurniture.isNameVisible() && string.length() > 0) {
                float f7 = f + homePieceOfFurniture.getNameXOffset();
                float f8 = f6 + homePieceOfFurniture.getNameYOffset();
                TextStyle textStyle = homePieceOfFurniture.getNameStyle();
                if (textStyle == null) {
                    textStyle = this.preferences.getDefaultTextStyle(homePieceOfFurniture.getClass());
                }
                FontMetrics fontMetrics = this.getFontMetrics(font, textStyle);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                float_.add((double)f7 - rectangle2D.getWidth() / 2.0, f8 - (float)fontMetrics.getAscent());
                float_.add((double)f7 + rectangle2D.getWidth() / 2.0, f8 + (float)fontMetrics.getDescent());
            }
        } else if (selectable instanceof DimensionLine) {
            float[] fArray2;
            DimensionLine dimensionLine = (DimensionLine)selectable;
            float f = dimensionLine.getLength();
            String string = this.preferences.getLengthUnit().getFormat().format(Float.valueOf(f));
            TextStyle textStyle = dimensionLine.getLengthStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(dimensionLine.getClass());
            }
            FontMetrics fontMetrics = this.getFontMetrics(font, textStyle);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            double d = Math.atan2(dimensionLine.getYEnd() - dimensionLine.getYStart(), dimensionLine.getXEnd() - dimensionLine.getXStart());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(dimensionLine.getXStart(), dimensionLine.getYStart());
            affineTransform.rotate(d);
            affineTransform.translate(0.0, dimensionLine.getOffset());
            affineTransform.translate(((double)f - rectangle2D.getWidth()) / 2.0, dimensionLine.getOffset() <= 0.0f ? (double)(-fontMetrics.getDescent() - 1) : (double)(fontMetrics.getAscent() + 1));
            GeneralPath generalPath = new GeneralPath(rectangle2D);
            PathIterator pathIterator = generalPath.getPathIterator(affineTransform);
            while (!pathIterator.isDone()) {
                fArray2 = new float[2];
                if (pathIterator.currentSegment(fArray2) != 4) {
                    float_.add(fArray2[0], fArray2[1]);
                }
                pathIterator.next();
            }
            affineTransform = new AffineTransform();
            affineTransform.translate(dimensionLine.getXStart(), dimensionLine.getYStart());
            affineTransform.rotate(d);
            affineTransform.translate(0.0, dimensionLine.getOffset());
            pathIterator = DIMENSION_LINE_END.getPathIterator(affineTransform);
            while (!pathIterator.isDone()) {
                fArray2 = new float[2];
                if (pathIterator.currentSegment(fArray2) != 4) {
                    float_.add(fArray2[0], fArray2[1]);
                }
                pathIterator.next();
            }
            affineTransform.translate(f, 0.0);
            pathIterator = DIMENSION_LINE_END.getPathIterator(affineTransform);
            while (!pathIterator.isDone()) {
                fArray2 = new float[2];
                if (pathIterator.currentSegment(fArray2) != 4) {
                    float_.add(fArray2[0], fArray2[1]);
                }
                pathIterator.next();
            }
        } else if (selectable instanceof Label) {
            Label label = (Label)selectable;
            float f = label.getX();
            float f9 = label.getY();
            String string = label.getText();
            TextStyle textStyle = label.getStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(label.getClass());
            }
            FontMetrics fontMetrics = this.getFontMetrics(font, textStyle);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            float_.add((double)f - rectangle2D.getWidth() / 2.0, f9 - (float)fontMetrics.getAscent());
            float_.add((double)f + rectangle2D.getWidth() / 2.0, f9 + (float)fontMetrics.getDescent());
        } else if (selectable instanceof Compass) {
            Compass compass = (Compass)selectable;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(compass.getX(), compass.getY());
            affineTransform.scale(compass.getDiameter(), compass.getDiameter());
            affineTransform.rotate(compass.getNorthDirection());
            return COMPASS.createTransformedShape(affineTransform).getBounds2D();
        }
        return float_;
    }

    @Override
    public float[][] getTextBounds(String string, TextStyle textStyle, float f, float f2, float f3) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont(), textStyle);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, null);
        float f4 = (float)rectangle2D.getWidth() / 2.0f;
        float f5 = fontMetrics.getAscent();
        if (f3 == 0.0f) {
            return new float[][]{{f - f4, f2 - f5}, {f + f4, f2 - f5}, {f + f4, f2 + (float)rectangle2D.getHeight() - f5}, {f - f4, f2 + (float)rectangle2D.getHeight() - f5}};
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f - f4, f2 + (float)rectangle2D.getHeight() - f5);
        affineTransform.rotate(f3);
        GeneralPath generalPath = new GeneralPath(rectangle2D);
        ArrayList<float[]> arrayList = new ArrayList<float[]>(4);
        PathIterator pathIterator = generalPath.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            float[] fArray = new float[2];
            if (pathIterator.currentSegment(fArray) != 4) {
                arrayList.add(fArray);
            }
            pathIterator.next();
        }
        return (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
    }

    protected Font getFont(Font font, TextStyle textStyle) {
        Font font2;
        if (this.fonts == null) {
            this.fonts = new WeakHashMap<TextStyle, Font>();
        }
        if ((font2 = this.fonts.get(textStyle)) == null) {
            int n = 0;
            if (textStyle.isBold()) {
                n = 1;
            }
            if (textStyle.isItalic()) {
                n |= 2;
            }
            String string = null;
            string = font != null ? font.getName() : null;
            font2 = new Font(string, n, 1);
            font2 = font2.deriveFont(textStyle.getFontSize());
            this.fonts.put(textStyle, font2);
        }
        return font2;
    }

    protected FontMetrics getFontMetrics(Font font, TextStyle textStyle) {
        FontMetrics fontMetrics;
        if (this.fontsMetrics == null) {
            this.fontsMetrics = new WeakHashMap<TextStyle, FontMetrics>();
        }
        if ((fontMetrics = this.fontsMetrics.get(textStyle)) == null) {
            fontMetrics = this.getFontMetrics(this.getFont(font, textStyle));
            this.fontsMetrics.put(textStyle, fontMetrics);
        }
        return fontMetrics;
    }

    public void setBackgroundPainted(boolean bl) {
        if (this.backgroundPainted != bl) {
            this.backgroundPainted = bl;
            this.repaint();
        }
    }

    public boolean isBackgroundPainted() {
        return this.backgroundPainted;
    }

    public void setSelectedItemsOutlinePainted(boolean bl) {
        if (this.selectedItemsOutlinePainted != bl) {
            this.selectedItemsOutlinePainted = bl;
            this.repaint();
        }
    }

    public boolean isSelectedItemsOutlinePainted() {
        return this.selectedItemsOutlinePainted;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (this.backgroundPainted) {
            this.paintBackground(graphics2D, color);
        }
        Insets insets = this.getInsets();
        graphics2D.clipRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        Rectangle2D rectangle2D = this.getPlanBounds();
        float f = this.getScale();
        graphics2D.translate((double)insets.left + (40.0 - rectangle2D.getMinX()) * (double)f, (double)insets.top + (40.0 - rectangle2D.getMinY()) * (double)f);
        graphics2D.scale(f, f);
        this.setRenderingHints(graphics2D);
        try {
            this.paintContent(graphics2D, f, color, color2, PaintMode.PAINT);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        graphics2D.dispose();
    }

    public float getPrintPreferredScale(Graphics graphics, PageFormat pageFormat) {
        List<Selectable> list = this.getPaintedItems();
        Rectangle2D rectangle2D = this.getItemsBounds(graphics, list);
        if (rectangle2D != null) {
            float f = LengthUnit.inchToCentimeter((float)pageFormat.getImageableWidth() / 72.0f);
            float f2 = LengthUnit.inchToCentimeter((float)pageFormat.getImageableHeight() / 72.0f);
            float f3 = this.getStrokeWidthExtraMargin(list);
            int n = (int)Math.ceil(Math.max((rectangle2D.getWidth() + (double)(2.0f * f3)) / (double)f, (rectangle2D.getHeight() + (double)(2.0f * f3)) / (double)f2));
            return 1.0f / (float)n;
        }
        return 0.0f;
    }

    private float getStrokeWidthExtraMargin(List<Selectable> list) {
        float f = 0.5f;
        if (Home.getWallsSubList(list).size() > 0 || Home.getRoomsSubList(list).size() > 0) {
            f = 0.75f;
        }
        return f;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        List<Selectable> list = this.getPaintedItems();
        Rectangle2D rectangle2D = this.getItemsBounds(graphics, list);
        if (rectangle2D != null) {
            float f;
            float f2;
            int n2;
            int n3;
            float f3;
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            double d3 = pageFormat.getImageableWidth();
            double d4 = pageFormat.getImageableHeight();
            if (this.home.getPrint() == null || this.home.getPrint().getPlanScale() == null) {
                f3 = this.getPrintPreferredScale(graphics, pageFormat) * LengthUnit.centimeterToInch(72.0f);
                if (n > 0) {
                    return 1;
                }
                n3 = 1;
                n2 = 1;
                f2 = 0.0f;
                f = 0.0f;
            } else {
                f3 = this.home.getPrint().getPlanScale().floatValue() * LengthUnit.centimeterToInch(72.0f);
                n3 = (int)(rectangle2D.getWidth() * (double)f3 / d3);
                if (rectangle2D.getWidth() * (double)f3 != d3) {
                    ++n3;
                }
                n2 = (int)(rectangle2D.getHeight() * (double)f3 / d4);
                if (rectangle2D.getHeight() * (double)f3 != d4) {
                    ++n2;
                }
                if (n >= n3 * n2) {
                    return 1;
                }
                f2 = n / n3;
                f = (float)n - f2 * (float)n3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.clip(new Rectangle2D.Double(d, d2, d3, d4));
            graphics2D.translate(d - (double)f * d3, d2 - (double)f2 * d4);
            graphics2D.scale(f3, f3);
            float f4 = this.getStrokeWidthExtraMargin(list);
            graphics2D.translate(-rectangle2D.getMinX() + (double)f4, -rectangle2D.getMinY() + (double)f4);
            graphics2D.translate(Math.max(0.0, (d3 * (double)n3 / (double)f3 - rectangle2D.getWidth() - (double)(2.0f * f4)) / 2.0), Math.max(0.0, (d4 * (double)n2 / (double)f3 - rectangle2D.getHeight() - (double)(2.0f * f4)) / 2.0));
            this.setRenderingHints(graphics2D);
            try {
                this.paintContent(graphics2D, f3, Color.WHITE, Color.BLACK, PaintMode.PRINT);
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
            graphics2D.dispose();
            return 0;
        }
        return 1;
    }

    public BufferedImage getClipboardImage() {
        Rectangle2D rectangle2D = this.getSelectionBounds(false);
        if (rectangle2D == null) {
            return null;
        }
        float f = 1.0f;
        float f2 = this.getStrokeWidthExtraMargin(this.home.getSelectedItems());
        BufferedImage bufferedImage = new BufferedImage((int)Math.ceil(rectangle2D.getWidth() * (double)f + (double)(2.0f * f2)), (int)Math.ceil(rectangle2D.getHeight() * (double)f + (double)(2.0f * f2)), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.scale(f, f);
        graphics2D.translate(-rectangle2D.getMinX() + (double)f2, -rectangle2D.getMinY() + (double)f2);
        this.setRenderingHints(graphics2D);
        try {
            this.paintContent(graphics2D, f, Color.WHITE, Color.BLACK, PaintMode.CLIPBOARD);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public void exportToSVG(OutputStream outputStream) throws IOException {
        SVGSupport.exportToSVG(outputStream, this);
    }

    private void checkCurrentThreadIsntInterrupted(PaintMode paintMode) throws InterruptedIOException {
        if (paintMode == PaintMode.EXPORT && Thread.interrupted()) {
            throw new InterruptedIOException("Current thread interrupted");
        }
    }

    private void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    private void paintBackground(Graphics2D graphics2D, Color color) {
        if (this.isOpaque()) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void paintBackgroundImage(Graphics2D graphics2D, PaintMode paintMode) {
        final BackgroundImage backgroundImage = this.home.getBackgroundImage();
        if (backgroundImage != null && backgroundImage.isVisible()) {
            if (this.backgroundImageCache == null && paintMode == PaintMode.PAINT) {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    public void run() {
                        PlanComponent.this.backgroundImageCache = PlanComponent.this.readImage(backgroundImage.getImage());
                        PlanComponent.this.revalidate();
                    }
                });
            } else {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(-backgroundImage.getXOrigin(), -backgroundImage.getYOrigin());
                graphics2D.scale(backgroundImage.getScale(), backgroundImage.getScale());
                Composite composite = graphics2D.getComposite();
                if (composite instanceof AlphaComposite) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, ((AlphaComposite)composite).getAlpha() * 0.7f));
                } else {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                }
                graphics2D.drawImage((Image)(this.backgroundImageCache != null ? this.backgroundImageCache : this.readImage(backgroundImage.getImage())), 0, 0, this);
                graphics2D.setComposite(composite);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImage(Content content) {
        BufferedImage bufferedImage;
        InputStream inputStream = null;
        try {
            inputStream = content.openStream();
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return new BufferedImage(1, 1, 2);
            }
        }
        inputStream.close();
        return bufferedImage;
    }

    private void paintGrid(Graphics2D graphics2D, float f) {
        float f2 = this.getGridSize(f);
        float f3 = this.getMainGridSize(f);
        Rectangle2D rectangle2D = this.getPlanBounds();
        float f4 = (float)rectangle2D.getMinX() - 40.0f;
        float f5 = (float)rectangle2D.getMinY() - 40.0f;
        float f6 = this.convertXPixelToModel(this.getWidth());
        float f7 = this.convertYPixelToModel(this.getHeight());
        if (OperatingSystem.isMacOSX() && System.getProperty("apple.awt.graphics.UseQuartz", "false").equals("false")) {
            int n = Math.round(f3 * f);
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            this.setRenderingHints(graphics2D2);
            graphics2D2.scale(f, f);
            this.paintGridLines(graphics2D2, f, 0.0f, f3, 0.0f, f3, f2, f3);
            graphics2D2.dispose();
            graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, f3, f3)));
            graphics2D.fill(new Rectangle2D.Float(f4, f5, f6 - f4, f7 - f5));
        } else {
            this.paintGridLines(graphics2D, f, f4, f6, f5, f7, f2, f3);
        }
    }

    private void paintGridLines(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        graphics2D.setColor(UIManager.getColor("controlShadow"));
        graphics2D.setStroke(new BasicStroke(0.5f / f));
        for (f8 = (float)((int)(f2 / f6)) * f6; f8 < f3; f8 += f6) {
            graphics2D.draw(new Line2D.Float(f8, f4, f8, f5));
        }
        for (f8 = (float)((int)(f4 / f6)) * f6; f8 < f5; f8 += f6) {
            graphics2D.draw(new Line2D.Float(f2, f8, f3, f8));
        }
        if (f7 != f6) {
            graphics2D.setStroke(new BasicStroke(1.5f / f, 0, 2));
            for (f8 = (float)((int)(f2 / f7)) * f7; f8 < f3; f8 += f7) {
                graphics2D.draw(new Line2D.Float(f8, f4, f8, f5));
            }
            for (f8 = (float)((int)(f4 / f7)) * f7; f8 < f5; f8 += f7) {
                graphics2D.draw(new Line2D.Float(f2, f8, f3, f8));
            }
        }
    }

    private float getMainGridSize(float f) {
        float[] fArray;
        float f2;
        if (this.preferences.getLengthUnit() == LengthUnit.INCH) {
            f2 = 30.48f;
            fArray = new float[]{f2, 3.0f * f2, 6.0f * f2, 12.0f * f2, 24.0f * f2, 48.0f * f2, 96.0f * f2, 192.0f * f2, 384.0f * f2};
        } else {
            fArray = new float[]{100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5000.0f, 10000.0f};
        }
        f2 = fArray[0];
        for (int i = 1; i < fArray.length && f2 * f < 50.0f; ++i) {
            f2 = fArray[i];
        }
        return f2;
    }

    private float getGridSize(float f) {
        float[] fArray;
        float f2;
        if (this.preferences.getLengthUnit() == LengthUnit.INCH) {
            f2 = 30.48f;
            fArray = new float[]{2.54f, 5.08f, 7.62f, 15.24f, f2, 3.0f * f2, 6.0f * f2, 12.0f * f2, 24.0f * f2, 48.0f * f2, 96.0f * f2, 192.0f * f2, 384.0f * f2};
        } else {
            fArray = new float[]{1.0f, 2.0f, 5.0f, 10.0f, 20.0f, 50.0f, 100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5000.0f, 10000.0f};
        }
        f2 = fArray[0];
        for (int i = 1; i < fArray.length && f2 * f < 10.0f; ++i) {
            f2 = fArray[i];
        }
        return f2;
    }

    private void paintContent(Graphics2D graphics2D, float f, Color color, Color color2, PaintMode paintMode) throws InterruptedIOException {
        if (this.backgroundPainted) {
            this.paintBackgroundImage(graphics2D, paintMode);
            if (paintMode == PaintMode.PAINT && this.preferences.isGridVisible()) {
                this.paintGrid(graphics2D, f);
            }
        }
        this.paintHomeItems(graphics2D, f, color, color2, paintMode);
        if (paintMode == PaintMode.PAINT) {
            List<Selectable> list = this.home.getSelectedItems();
            Color color3 = this.getSelectionColor();
            Color color4 = this.getFurnitureOutlineColor();
            Color color5 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 128);
            BasicStroke basicStroke = new BasicStroke(6.0f / f, 1, 1);
            BasicStroke basicStroke2 = new BasicStroke(4.0f / f, 1, 1);
            BasicStroke basicStroke3 = new BasicStroke(1.0f / f, 2, 2, 0.0f, new float[]{20.0f / f, 5.0f / f, 5.0f / f, 5.0f / f}, 4.0f / f);
            this.paintCamera(graphics2D, list, color5, basicStroke, color3, f, color, color2);
            if (this.alignedObjectClass != null) {
                if (Wall.class.isAssignableFrom(this.alignedObjectClass)) {
                    this.paintWallAlignmentFeedback(graphics2D, (Wall)this.alignedObjectFeedback, this.locationFeeback, this.showPointFeedback, color3, basicStroke3, f, color5, basicStroke);
                } else if (Room.class.isAssignableFrom(this.alignedObjectClass)) {
                    this.paintRoomAlignmentFeedback(graphics2D, (Room)this.alignedObjectFeedback, this.locationFeeback, this.showPointFeedback, color3, basicStroke3, f, color5, basicStroke);
                } else if (DimensionLine.class.isAssignableFrom(this.alignedObjectClass)) {
                    this.paintDimensionLineAlignmentFeedback(graphics2D, (DimensionLine)this.alignedObjectFeedback, this.locationFeeback, this.showPointFeedback, color3, basicStroke3, f, color5, basicStroke);
                }
            }
            if (this.centerAngleFeedback != null) {
                this.paintAngleFeedback(graphics2D, this.centerAngleFeedback, this.point1AngleFeedback, this.point2AngleFeedback, f, color3);
            }
            if (this.dimensionLinesFeedback != null) {
                List<Selectable> list2 = Collections.emptyList();
                this.paintDimensionLines(graphics2D, this.dimensionLinesFeedback, list2, null, null, null, basicStroke3, f, color, color3, paintMode, true);
            }
            if (this.draggedItemsFeedback != null) {
                this.paintDimensionLines(graphics2D, Home.getDimensionLinesSubList(this.draggedItemsFeedback), this.draggedItemsFeedback, color5, basicStroke2, null, basicStroke3, f, color, color2, paintMode, false);
                this.paintLabels(graphics2D, Home.getLabelsSubList(this.draggedItemsFeedback), this.draggedItemsFeedback, color5, basicStroke2, f, color2, paintMode);
                this.paintRoomsOutline(graphics2D, this.draggedItemsFeedback, color5, basicStroke, null, f, color2);
                this.paintWallsOutline(graphics2D, this.draggedItemsFeedback, color5, basicStroke, null, f, color2);
                this.paintFurniture(graphics2D, Home.getFurnitureSubList(this.draggedItemsFeedback), list, f, null, color2, color4, paintMode, false);
                this.paintFurnitureOutline(graphics2D, this.draggedItemsFeedback, color5, basicStroke, null, f, color2);
            }
            this.paintRectangleFeedback(graphics2D, color3, f);
        }
    }

    protected void paintHomeItems(Graphics graphics, float f, Color color, Color color2, PaintMode paintMode) throws InterruptedIOException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<Selectable> list = this.home.getSelectedItems();
        if (this.sortedHomeFurniture == null) {
            this.sortedHomeFurniture = new ArrayList<HomePieceOfFurniture>(this.home.getFurniture());
            Collections.sort(this.sortedHomeFurniture, new Comparator<HomePieceOfFurniture>(){

                @Override
                public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                    float f = homePieceOfFurniture.getElevation() - homePieceOfFurniture2.getElevation();
                    if (f < 0.0f) {
                        return -1;
                    }
                    if (f > 0.0f) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        Color color3 = this.getSelectionColor();
        Color color4 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 128);
        BasicStroke basicStroke = new BasicStroke(6.0f / f, 1, 1);
        BasicStroke basicStroke2 = new BasicStroke(4.0f / f, 1, 1);
        BasicStroke basicStroke3 = new BasicStroke(1.0f / f, 2, 2, 0.0f, new float[]{20.0f / f, 5.0f / f, 5.0f / f, 5.0f / f}, 4.0f / f);
        this.paintCompass(graphics2D, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintRooms(graphics2D, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintWalls(graphics2D, list, f, color, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintFurniture(graphics2D, this.sortedHomeFurniture, list, f, color, color2, this.getFurnitureOutlineColor(), paintMode, true);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintDimensionLines(graphics2D, this.home.getDimensionLines(), list, color4, basicStroke2, color3, basicStroke3, f, color, color2, paintMode, false);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintRoomsNameAndArea(graphics2D, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintFurnitureName(graphics2D, this.sortedHomeFurniture, list, f, color2, paintMode);
        this.checkCurrentThreadIsntInterrupted(paintMode);
        this.paintLabels(graphics2D, this.home.getLabels(), list, color4, basicStroke2, f, color2, paintMode);
        if (paintMode == PaintMode.PAINT && this.selectedItemsOutlinePainted) {
            this.paintCompassOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
            this.paintRoomsOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
            this.paintWallsOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
            this.paintFurnitureOutline(graphics2D, list, color4, basicStroke, color3, f, color2);
        }
    }

    protected Color getSelectionColor() {
        if (OperatingSystem.isMacOSX()) {
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                Color color = UIManager.getColor("Focus.color");
                if (color != null) {
                    return color.darker();
                }
                return UIManager.getColor("List.selectionBackground").darker();
            }
            return UIManager.getColor("textHighlight");
        }
        return UIManager.getColor("textHighlight").darker();
    }

    protected Color getFurnitureOutlineColor() {
        return new Color(this.getForeground().getRGB() & 0xFFFFFF | 0x55000000, true);
    }

    private void paintRooms(Graphics2D graphics2D, List<Selectable> list, float f, Color color, PaintMode paintMode) {
        if (this.sortedHomeRooms == null) {
            this.sortedHomeRooms = new ArrayList<Room>(this.home.getRooms());
            Collections.sort(this.sortedHomeRooms, new Comparator<Room>(){

                @Override
                public int compare(Room room, Room room2) {
                    if (room.isFloorVisible() == room2.isFloorVisible() && room.isCeilingVisible() == room2.isCeilingVisible()) {
                        return 0;
                    }
                    if (!room2.isFloorVisible() || room2.isCeilingVisible()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        Color color2 = paintMode == PaintMode.PRINT ? Color.WHITE : Color.GRAY;
        Composite composite = graphics2D.getComposite();
        graphics2D.setStroke(new BasicStroke(1.5f / f));
        for (Room room : this.sortedHomeRooms) {
            boolean bl = list.contains(room);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            graphics2D.setPaint(color2);
            if (this.preferences.isRoomFloorColoredOrTextured() && room.isFloorVisible()) {
                if (room.getFloorColor() != null) {
                    graphics2D.setPaint(new Color(room.getFloorColor()));
                } else {
                    final HomeTexture homeTexture = room.getFloorTexture();
                    if (homeTexture != null) {
                        BufferedImage bufferedImage;
                        if (this.floorTextureImagesCache == null) {
                            this.floorTextureImagesCache = new WeakHashMap<Content, BufferedImage>();
                        }
                        if ((bufferedImage = this.floorTextureImagesCache.get(homeTexture.getImage())) == null || bufferedImage == WAIT_TEXTURE_IMAGE) {
                            boolean bl2;
                            boolean bl3 = bl2 = paintMode != PaintMode.PAINT;
                            if ("true".equalsIgnoreCase(System.getProperty("com.eteks.sweethome3d.no3D"))) {
                                Icon icon = IconManager.getInstance().getIcon(homeTexture.getImage(), bl2 ? null : this);
                                if (IconManager.getInstance().isWaitIcon(icon)) {
                                    this.floorTextureImagesCache.put(homeTexture.getImage(), WAIT_TEXTURE_IMAGE);
                                } else if (IconManager.getInstance().isErrorIcon(icon)) {
                                    this.floorTextureImagesCache.put(homeTexture.getImage(), ERROR_TEXTURE_IMAGE);
                                } else {
                                    BufferedImage bufferedImage2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage2.getGraphics();
                                    icon.paintIcon(this, graphics2D2, 0, 0);
                                    graphics2D2.dispose();
                                    this.floorTextureImagesCache.put(homeTexture.getImage(), bufferedImage2);
                                }
                            } else {
                                TextureManager.getInstance().loadTexture(homeTexture.getImage(), bl2, new TextureManager.TextureObserver(){

                                    public void textureUpdated(Texture texture) {
                                        PlanComponent.this.floorTextureImagesCache.put(homeTexture.getImage(), ((ImageComponent2D)texture.getImage(0)).getImage());
                                        if (!bl2) {
                                            PlanComponent.this.repaint();
                                        }
                                    }
                                });
                            }
                            bufferedImage = this.floorTextureImagesCache.get(homeTexture.getImage());
                        }
                        graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, homeTexture.getWidth(), homeTexture.getHeight())));
                    }
                }
            }
            if (composite instanceof AlphaComposite) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, ((AlphaComposite)composite).getAlpha() * 0.75f));
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.75f));
            }
            graphics2D.fill(this.getShape(room.getPoints()));
            graphics2D.setComposite(composite);
            graphics2D.setPaint(color);
            graphics2D.draw(this.getShape(room.getPoints()));
        }
    }

    private void paintRoomsNameAndArea(Graphics2D graphics2D, List<Selectable> list, float f, Color color, PaintMode paintMode) {
        graphics2D.setPaint(color);
        Font font = graphics2D.getFont();
        for (Room room : this.sortedHomeRooms) {
            Object object;
            Serializable serializable;
            float f2;
            float f3;
            boolean bl = list.contains(room);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            float f4 = room.getXCenter();
            float f5 = room.getYCenter();
            String string = room.getName();
            if (string != null && (string = string.trim()).length() > 0) {
                f3 = f4 + room.getNameXOffset();
                f2 = f5 + room.getNameYOffset();
                TextStyle textStyle = room.getNameStyle();
                if (textStyle == null) {
                    textStyle = this.preferences.getDefaultTextStyle(room.getClass());
                }
                serializable = this.getFontMetrics(font, textStyle);
                object = ((FontMetrics)serializable).getStringBounds(string, graphics2D);
                graphics2D.setFont(this.getFont(font, textStyle));
                graphics2D.drawString(string, f3 - (float)((RectangularShape)object).getWidth() / 2.0f, f2);
            }
            if (!room.isAreaVisible() || !((f3 = room.getArea()) > 0.01f)) continue;
            f2 = f4 + room.getAreaXOffset();
            float f6 = f5 + room.getAreaYOffset();
            serializable = room.getAreaStyle();
            if (serializable == null) {
                serializable = this.preferences.getDefaultTextStyle(room.getClass());
            }
            object = this.getFontMetrics(font, (TextStyle)serializable);
            String string2 = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(f3));
            Rectangle2D rectangle2D = ((FontMetrics)object).getStringBounds(string2, graphics2D);
            graphics2D.setFont(this.getFont(font, (TextStyle)serializable));
            graphics2D.drawString(string2, f2 - (float)rectangle2D.getWidth() / 2.0f, f6);
        }
        graphics2D.setFont(font);
    }

    private void paintRoomsOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        List<Room> list2 = Home.getRoomsSubList(list);
        AffineTransform affineTransform = graphics2D.getTransform();
        float f2 = 1.0f / f;
        for (Room room : list2) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(this.getShape(room.getPoints()));
            if (paint2 == null) continue;
            graphics2D.setPaint(paint2);
            for (float[] fArray : room.getPoints()) {
                graphics2D.translate(fArray[0], fArray[1]);
                graphics2D.scale(f2, f2);
                graphics2D.setStroke(POINT_STROKE);
                graphics2D.fill(WALL_POINT);
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(1.5f / f));
        for (Room room : list2) {
            graphics2D.draw(this.getShape(room.getPoints()));
        }
        if (list.size() == 1 && list2.size() == 1 && paint2 != null) {
            Room room = (Room)list2.iterator().next();
            graphics2D.setPaint(paint2);
            this.paintRoomResizeIndicators(graphics2D, room, paint2, f);
            this.paintRoomNameOffsetIndicator(graphics2D, room, paint2, f);
            this.paintRoomAreaOffsetIndicator(graphics2D, room, paint2, f);
        }
    }

    private void paintRoomResizeIndicators(Graphics2D graphics2D, Room room, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float f2 = 1.0f / f;
            float[][] fArray = room.getPoints();
            for (int i = 0; i < fArray.length; ++i) {
                float[] fArray2 = fArray[i];
                graphics2D.translate(fArray2[0], fArray2[1]);
                graphics2D.scale(f2, f2);
                float[] fArray3 = i == 0 ? fArray[fArray.length - 1] : fArray[i - 1];
                float[] fArray4 = i == fArray.length - 1 ? fArray[0] : fArray[i + 1];
                float f3 = (float)Point2D.distance(fArray3[0], fArray3[1], fArray2[0], fArray2[1]);
                float f4 = (fArray2[1] - fArray3[1]) / f3;
                float f5 = (fArray3[0] - fArray2[0]) / f3;
                float f6 = (float)Point2D.distance(fArray4[0], fArray4[1], fArray2[0], fArray2[1]);
                float f7 = (fArray4[1] - fArray2[1]) / f6;
                float f8 = (fArray2[0] - fArray4[0]) / f6;
                double d = Math.atan2(f5 + f8, f4 + f7);
                if (room.containsPoint(fArray2[0] + (float)Math.cos(d), fArray2[1] + (float)Math.sin(d), 0.001f)) {
                    d += Math.PI;
                }
                graphics2D.rotate(d);
                graphics2D.draw(WALL_AND_LINE_RESIZE_INDICATOR);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    private void paintRoomNameOffsetIndicator(Graphics2D graphics2D, Room room, Paint paint, float f) {
        if (this.resizeIndicatorVisible && room.getName() != null && room.getName().trim().length() > 0) {
            float f2 = room.getXCenter() + room.getNameXOffset();
            float f3 = room.getYCenter() + room.getNameYOffset();
            this.paintTextLocationIndicator(graphics2D, f2, f3, paint, f);
        }
    }

    private void paintRoomAreaOffsetIndicator(Graphics2D graphics2D, Room room, Paint paint, float f) {
        if (this.resizeIndicatorVisible && room.isAreaVisible() && room.getArea() > 0.01f) {
            float f2 = room.getXCenter() + room.getAreaXOffset();
            float f3 = room.getYCenter() + room.getAreaYOffset();
            this.paintTextLocationIndicator(graphics2D, f2, f3, paint, f);
        }
    }

    private void paintTextLocationIndicator(Graphics2D graphics2D, float f, float f2, Paint paint, float f3) {
        graphics2D.setPaint(paint);
        graphics2D.setStroke(INDICATOR_STROKE);
        AffineTransform affineTransform = graphics2D.getTransform();
        float f4 = 1.0f / f3;
        graphics2D.translate(f, f2);
        graphics2D.scale(f4, f4);
        graphics2D.draw(TEXT_LOCATION_INDICATOR);
        graphics2D.setTransform(affineTransform);
    }

    private void paintWalls(Graphics2D graphics2D, List<Selectable> list, float f, Color color, Color color2, PaintMode paintMode) {
        Area area;
        if (paintMode != PaintMode.CLIPBOARD) {
            area = this.getWallsArea();
        } else {
            List<Wall> list2 = Home.getWallsSubList(list);
            area = this.getWallsArea(list2);
        }
        float f2 = paintMode == PaintMode.PRINT ? f / 72.0f * 150.0f : f;
        graphics2D.setPaint(this.getWallPaint(f2, color, color2));
        graphics2D.fill(area);
        graphics2D.setPaint(color2);
        graphics2D.setStroke(new BasicStroke(1.5f / f));
        graphics2D.draw(area);
    }

    private void paintWallsOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        float f2 = 1.0f / f;
        List<Wall> list2 = Home.getWallsSubList(list);
        Area area = this.getWallsArea(list2);
        AffineTransform affineTransform = graphics2D.getTransform();
        for (Wall wall : list2) {
            double d;
            double d2;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(this.getShape(wall.getPoints()));
            if (paint2 == null) continue;
            graphics2D.translate(wall.getXStart(), wall.getYStart());
            graphics2D.scale(f2, f2);
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(POINT_STROKE);
            graphics2D.fill(WALL_POINT);
            Float f3 = wall.getArcExtent();
            float f4 = 0.0f;
            float f5 = 0.0f;
            double d3 = 0.0;
            double d4 = wall.getStartPointToEndPointDistance();
            double d5 = Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
            if (f3 != null) {
                f4 = wall.getXArcCircleCenter();
                f5 = wall.getYArcCircleCenter();
                d3 = Point2D.distance(wall.getXStart(), wall.getYStart(), f4, f5);
                d2 = d3 * (double)Math.abs(f3.floatValue()) * (double)f;
                d = Math.atan2(f5 - wall.getYStart(), f4 - wall.getXStart()) + (f3.floatValue() > 0.0f ? -1.5707963267948966 : 1.5707963267948966);
            } else {
                d2 = d4 * (double)f;
                d = d5;
            }
            if (d2 < 30.0) {
                graphics2D.rotate(d5);
                if (f3 != null) {
                    double d6 = (double)Math.abs(f3.floatValue()) > Math.PI ? -(Math.PI + (double)f3.floatValue()) / 2.0 : (Math.PI - (double)f3.floatValue()) / 2.0;
                    float f6 = (float)(Math.tan(d6) * d4 / 2.0);
                    graphics2D.translate(d4 * (double)f / 2.0, ((double)f6 - d3 * (double)(Math.abs(d5) > 1.5707963267948966 ? -1 : 1)) * (double)f);
                } else {
                    graphics2D.translate(d2 / 2.0, 0.0);
                }
            } else {
                graphics2D.rotate(d);
                graphics2D.translate(8, 0);
            }
            graphics2D.draw(WALL_ORIENTATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(wall.getXEnd(), wall.getYEnd());
            graphics2D.scale(f2, f2);
            graphics2D.fill(WALL_POINT);
            if (d2 >= 30.0) {
                if (f3 != null) {
                    d += (double)f3.floatValue();
                }
                graphics2D.rotate(d);
                graphics2D.translate(-10, 0);
                graphics2D.draw(WALL_ORIENTATION_INDICATOR);
            }
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(1.5f / f));
        graphics2D.draw(area);
        if (list.size() == 1 && list2.size() == 1 && paint2 != null) {
            this.paintWallResizeIndicator(graphics2D, (Wall)list2.iterator().next(), paint2, f);
        }
    }

    private void paintWallResizeIndicator(Graphics2D graphics2D, Wall wall, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            Float f2 = wall.getArcExtent();
            double d = f2 != null ? Math.atan2(wall.getYArcCircleCenter() - wall.getYEnd(), wall.getXArcCircleCenter() - wall.getXEnd()) + (f2.floatValue() > 0.0f ? -1.5707963267948966 : 1.5707963267948966) : Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
            AffineTransform affineTransform = graphics2D.getTransform();
            float f3 = 1.0f / f;
            graphics2D.translate(wall.getXEnd(), wall.getYEnd());
            graphics2D.scale(f3, f3);
            graphics2D.rotate(d);
            graphics2D.draw(WALL_AND_LINE_RESIZE_INDICATOR);
            graphics2D.setTransform(affineTransform);
            d = f2 != null ? (d += Math.PI - (double)f2.floatValue()) : (d += Math.PI);
            graphics2D.translate(wall.getXStart(), wall.getYStart());
            graphics2D.scale(f3, f3);
            graphics2D.rotate(d);
            graphics2D.draw(WALL_AND_LINE_RESIZE_INDICATOR);
            graphics2D.setTransform(affineTransform);
        }
    }

    private Area getWallsArea() {
        if (this.wallsAreaCache == null) {
            this.wallsAreaCache = this.getWallsArea(this.home.getWalls());
        }
        return this.wallsAreaCache;
    }

    private Area getWallsArea(Collection<Wall> collection) {
        Area area = new Area();
        for (Wall wall : collection) {
            area.add(new Area(this.getShape(wall.getPoints())));
        }
        return area;
    }

    private Paint getWallPaint(float f, Color color, Color color2) {
        if (this.wallsPatternImageCache == null || !color.equals(this.wallsPatternBackgroundCache) || !color2.equals(this.wallsPatternForegroundCache)) {
            this.wallsPatternImageCache = SwingTools.getPatternImage(this.preferences.getWallPattern(), color, color2);
            this.wallsPatternBackgroundCache = color;
            this.wallsPatternForegroundCache = color2;
        }
        return new TexturePaint(this.wallsPatternImageCache, new Rectangle2D.Float(0.0f, 0.0f, 10.0f / f, 10.0f / f));
    }

    private void paintFurniture(Graphics2D graphics2D, List<HomePieceOfFurniture> list, List<? extends Selectable> list2, float f, Color color, Color color2, Color color3, PaintMode paintMode, boolean bl) {
        if (!list.isEmpty()) {
            BasicStroke basicStroke = new BasicStroke(1.0f / f);
            boolean bl2 = !"true".equalsIgnoreCase(System.getProperty("com.eteks.sweethome3d.no3D")) && this.preferences.isFurnitureViewedFromTop() && Component3DManager.getInstance().isOffScreenImageSupported();
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                Object object;
                List<HomePieceOfFurniture> list3;
                if (!homePieceOfFurniture.isVisible()) continue;
                boolean bl3 = list2.contains(homePieceOfFurniture);
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    list3 = ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture();
                    object = Collections.emptyList();
                    this.paintFurniture(graphics2D, list3, (List<? extends Selectable>)(bl3 ? list3 : object), f, color, color2, color3, paintMode, bl);
                    continue;
                }
                if (paintMode == PaintMode.CLIPBOARD && !bl3) continue;
                list3 = this.getShape(homePieceOfFurniture.getPoints());
                if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                    HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)homePieceOfFurniture;
                    object = this.getDoorOrWindowShapeAtWallIntersection(homeDoorOrWindow);
                    this.paintDoorOrWindowSashes(graphics2D, homeDoorOrWindow, f, color2);
                } else {
                    object = list3;
                }
                if (bl && (bl2 || this.preferences.isFurnitureViewedFromTop() && (homePieceOfFurniture.getPlanIcon() != null || homePieceOfFurniture instanceof HomeDoorOrWindow))) {
                    if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                        graphics2D.setPaint(color);
                        graphics2D.fill((Shape)object);
                        graphics2D.setPaint(color2);
                        graphics2D.setStroke(basicStroke);
                        graphics2D.draw((Shape)object);
                    } else {
                        this.paintPieceOfFurnitureTop(graphics2D, homePieceOfFurniture, (Shape)object, basicStroke, f, color, color2, paintMode);
                    }
                    if (paintMode != PaintMode.PAINT) continue;
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setPaint(color3);
                    graphics2D.draw((Shape)((Object)list3));
                    continue;
                }
                if (bl) {
                    this.paintPieceOfFurnitureIcon(graphics2D, homePieceOfFurniture, (Shape)object, f, color, paintMode);
                }
                graphics2D.setPaint(color2);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw((Shape)object);
                if (!(homePieceOfFurniture instanceof HomeDoorOrWindow) || paintMode != PaintMode.PAINT) continue;
                graphics2D.setPaint(color3);
                graphics2D.draw((Shape)((Object)list3));
            }
        }
    }

    private Shape getDoorOrWindowShapeAtWallIntersection(HomeDoorOrWindow homeDoorOrWindow) {
        float f = homeDoorOrWindow.getDepth() * homeDoorOrWindow.getWallThickness();
        float f2 = homeDoorOrWindow.getDepth() * homeDoorOrWindow.getWallDistance();
        Rectangle2D.Float float_ = new Rectangle2D.Float(homeDoorOrWindow.getX() - homeDoorOrWindow.getWidth() / 2.0f, homeDoorOrWindow.getY() - homeDoorOrWindow.getDepth() / 2.0f + f2, homeDoorOrWindow.getWidth(), f);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(homeDoorOrWindow.getAngle(), homeDoorOrWindow.getX(), homeDoorOrWindow.getY());
        PathIterator pathIterator = float_.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    private void paintDoorOrWindowSashes(Graphics2D graphics2D, HomeDoorOrWindow homeDoorOrWindow, float f, Color color) {
        BasicStroke basicStroke = new BasicStroke(1.0f / f);
        graphics2D.setPaint(color);
        graphics2D.setStroke(basicStroke);
        for (Sash sash : homeDoorOrWindow.getSashes()) {
            graphics2D.draw(this.getDoorOrWindowSashShape(homeDoorOrWindow, sash));
        }
    }

    private GeneralPath getDoorOrWindowSashShape(HomeDoorOrWindow homeDoorOrWindow, Sash sash) {
        float f = homeDoorOrWindow.isModelMirrored() ? -1.0f : 1.0f;
        float f2 = f * sash.getXAxis() * homeDoorOrWindow.getWidth();
        float f3 = sash.getYAxis() * homeDoorOrWindow.getDepth();
        float f4 = sash.getWidth() * homeDoorOrWindow.getWidth();
        float f5 = (float)Math.toDegrees(sash.getStartAngle());
        if (homeDoorOrWindow.isModelMirrored()) {
            f5 = 180.0f - f5;
        }
        float f6 = f * (float)Math.toDegrees(sash.getEndAngle() - sash.getStartAngle());
        Arc2D.Float float_ = new Arc2D.Float(f2 - f4, f3 - f4, 2.0f * f4, 2.0f * f4, f5, f6, 2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(homeDoorOrWindow.getX(), homeDoorOrWindow.getY());
        affineTransform.rotate(homeDoorOrWindow.getAngle());
        affineTransform.translate(f * -homeDoorOrWindow.getWidth() / 2.0f, -homeDoorOrWindow.getDepth() / 2.0f);
        PathIterator pathIterator = float_.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    private void paintFurnitureName(Graphics2D graphics2D, List<HomePieceOfFurniture> list, List<? extends Selectable> list2, float f, Color color, PaintMode paintMode) {
        Font font = graphics2D.getFont();
        graphics2D.setPaint(color);
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            List list3;
            if (!homePieceOfFurniture.isVisible()) continue;
            boolean bl = list2.contains(homePieceOfFurniture);
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                list3 = ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture();
                List list4 = Collections.emptyList();
                this.paintFurnitureName(graphics2D, list3, bl ? list3 : list4, f, color, paintMode);
            }
            if (!homePieceOfFurniture.isNameVisible() || paintMode == PaintMode.CLIPBOARD && !bl || ((String)((Object)(list3 = homePieceOfFurniture.getName().trim()))).length() <= 0) continue;
            float f2 = homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset();
            float f3 = homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset();
            TextStyle textStyle = homePieceOfFurniture.getNameStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(homePieceOfFurniture.getClass());
            }
            FontMetrics fontMetrics = this.getFontMetrics(font, textStyle);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)((Object)list3), graphics2D);
            graphics2D.setFont(this.getFont(font, textStyle));
            graphics2D.drawString((String)((Object)list3), f2 - (float)rectangle2D.getWidth() / 2.0f, f3);
        }
        graphics2D.setFont(font);
    }

    private void paintFurnitureOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        BasicStroke basicStroke = new BasicStroke(1.0f / f);
        BasicStroke basicStroke2 = new BasicStroke(4.0f / f, 0, 0);
        for (HomePieceOfFurniture homePieceOfFurniture : Home.getFurnitureSubList(list)) {
            if (!homePieceOfFurniture.isVisible()) continue;
            float[][] fArray = homePieceOfFurniture.getPoints();
            Shape shape = this.getShape(fArray);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(shape);
            graphics2D.setPaint(color);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
            graphics2D.setStroke(basicStroke2);
            graphics2D.draw(new Line2D.Float(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1]));
            if (list.size() != 1 || paint2 == null) continue;
            this.paintPieceOFFurnitureIndicators(graphics2D, homePieceOfFurniture, paint2, f);
        }
    }

    private void paintPieceOfFurnitureIcon(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Shape shape, float f, Color color, PaintMode paintMode) {
        Icon icon = IconManager.getInstance().getIcon(homePieceOfFurniture.getIcon(), 128, paintMode == PaintMode.PAINT ? this : null);
        this.paintPieceOfFurnitureIcon(graphics2D, homePieceOfFurniture, icon, shape, f, color);
    }

    private void paintPieceOfFurnitureIcon(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Icon icon, Shape shape, float f, Color color) {
        graphics2D.setPaint(color);
        graphics2D.fill(shape);
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle rectangle = shape.getBounds();
        graphics2D.translate(rectangle.getCenterX(), rectangle.getCenterY());
        float f2 = homePieceOfFurniture.getDepth();
        if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
            f2 *= ((HomeDoorOrWindow)homePieceOfFurniture).getWallThickness();
        }
        float f3 = Math.min(homePieceOfFurniture.getWidth(), f2);
        float f4 = Math.min(1.0f / f, f3 / (float)icon.getIconHeight());
        if (homePieceOfFurniture.isModelMirrored()) {
            graphics2D.scale(-f4, f4);
        } else {
            graphics2D.scale(f4, f4);
        }
        icon.paintIcon(this, graphics2D, -icon.getIconWidth() / 2, -icon.getIconHeight() / 2);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape2);
    }

    private void paintPieceOfFurnitureTop(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Shape shape, BasicStroke basicStroke, float f, Color color, Color color2, PaintMode paintMode) {
        Serializable serializable;
        PieceOfFurnitureTopViewIcon pieceOfFurnitureTopViewIcon;
        if (this.furnitureTopViewIconsCache == null) {
            this.furnitureTopViewIconsCache = new WeakHashMap<HomePieceOfFurniture, PieceOfFurnitureTopViewIcon>();
        }
        if ((pieceOfFurnitureTopViewIcon = this.furnitureTopViewIconsCache.get(homePieceOfFurniture)) == null || pieceOfFurnitureTopViewIcon.isWaitIcon() && paintMode != PaintMode.PAINT) {
            serializable = paintMode == PaintMode.PAINT ? this : null;
            pieceOfFurnitureTopViewIcon = homePieceOfFurniture.getPlanIcon() != null ? new PieceOfFurniturePlanIcon(homePieceOfFurniture, (Component)serializable) : new PieceOfFurnitureModelIcon(homePieceOfFurniture, (Component)serializable);
            this.furnitureTopViewIconsCache.put(homePieceOfFurniture, pieceOfFurnitureTopViewIcon);
        }
        if (pieceOfFurnitureTopViewIcon.isWaitIcon() || pieceOfFurnitureTopViewIcon.isErrorIcon()) {
            this.paintPieceOfFurnitureIcon(graphics2D, homePieceOfFurniture, pieceOfFurnitureTopViewIcon, shape, f, color);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
        } else {
            serializable = graphics2D.getTransform();
            Rectangle rectangle = shape.getBounds();
            graphics2D.translate(rectangle.getCenterX(), rectangle.getCenterY());
            graphics2D.rotate(homePieceOfFurniture.getAngle());
            float f2 = homePieceOfFurniture.getDepth();
            if (homePieceOfFurniture.isModelMirrored()) {
                graphics2D.scale(-homePieceOfFurniture.getWidth() / (float)pieceOfFurnitureTopViewIcon.getIconWidth(), f2 / (float)pieceOfFurnitureTopViewIcon.getIconHeight());
            } else {
                graphics2D.scale(homePieceOfFurniture.getWidth() / (float)pieceOfFurnitureTopViewIcon.getIconWidth(), f2 / (float)pieceOfFurnitureTopViewIcon.getIconHeight());
            }
            pieceOfFurnitureTopViewIcon.paintIcon(this, graphics2D, -pieceOfFurnitureTopViewIcon.getIconWidth() / 2, -pieceOfFurnitureTopViewIcon.getIconHeight() / 2);
            graphics2D.setTransform((AffineTransform)serializable);
        }
    }

    private void paintPieceOFFurnitureIndicators(Graphics2D graphics2D, HomePieceOfFurniture homePieceOfFurniture, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float[][] fArray = homePieceOfFurniture.getPoints();
            float f2 = 1.0f / f;
            float f3 = homePieceOfFurniture.getAngle();
            graphics2D.translate(fArray[0][0], fArray[0][1]);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(f3);
            graphics2D.draw(FURNITURE_ROTATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(fArray[1][0], fArray[1][1]);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(f3);
            graphics2D.draw(FURNITURE_ELEVATION_POINT_INDICATOR);
            graphics2D.translate(6.5, -6.5);
            graphics2D.rotate(-f3);
            graphics2D.draw(FURNITURE_ELEVATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            if (homePieceOfFurniture.isResizable()) {
                graphics2D.translate(fArray[3][0], fArray[3][1]);
                graphics2D.scale(f2, f2);
                graphics2D.rotate(f3);
                if (homePieceOfFurniture instanceof HomeLight) {
                    graphics2D.draw(LIGHT_POWER_POINT_INDICATOR);
                    graphics2D.translate(-7.5, 7.5);
                    graphics2D.rotate(-f3);
                    graphics2D.draw(LIGHT_POWER_INDICATOR);
                } else {
                    graphics2D.draw(FURNITURE_HEIGHT_POINT_INDICATOR);
                    graphics2D.translate(-7.5, 7.5);
                    graphics2D.rotate(-f3);
                    graphics2D.draw(FURNITURE_HEIGHT_INDICATOR);
                }
                graphics2D.setTransform(affineTransform);
                graphics2D.translate(fArray[2][0], fArray[2][1]);
                graphics2D.scale(f2, f2);
                graphics2D.rotate(f3);
                graphics2D.draw(FURNITURE_RESIZE_INDICATOR);
                graphics2D.setTransform(affineTransform);
            }
            if (homePieceOfFurniture.isNameVisible() && homePieceOfFurniture.getName().trim().length() > 0) {
                float f4 = homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset();
                float f5 = homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset();
                this.paintTextLocationIndicator(graphics2D, f4, f5, paint, f);
            }
        }
    }

    private void paintDimensionLines(Graphics2D graphics2D, Collection<DimensionLine> collection, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, Stroke stroke2, float f, Color color, Color color2, PaintMode paintMode, boolean bl) {
        if (paintMode == PaintMode.CLIPBOARD) {
            collection = Home.getDimensionLinesSubList(list);
        }
        graphics2D.setPaint(color2);
        BasicStroke basicStroke = new BasicStroke(1.0f / f);
        Font font = graphics2D.getFont();
        Composite composite = graphics2D.getComposite();
        for (DimensionLine dimensionLine : collection) {
            AffineTransform affineTransform = graphics2D.getTransform();
            double d = Math.atan2(dimensionLine.getYEnd() - dimensionLine.getYStart(), dimensionLine.getXEnd() - dimensionLine.getXStart());
            float f2 = dimensionLine.getLength();
            graphics2D.translate(dimensionLine.getXStart(), dimensionLine.getYStart());
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            if (paintMode == PaintMode.PAINT && this.selectedItemsOutlinePainted && list.contains(dimensionLine)) {
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.draw(new Line2D.Float(0.0f, 0.0f, f2, 0.0f));
                graphics2D.draw(DIMENSION_LINE_END);
                graphics2D.translate(f2, 0.0);
                graphics2D.draw(DIMENSION_LINE_END);
                graphics2D.translate(-f2, 0.0);
                graphics2D.draw(new Line2D.Float(0.0f, -dimensionLine.getOffset(), 0.0f, -5.0f));
                graphics2D.draw(new Line2D.Float(f2, -dimensionLine.getOffset(), f2, -5.0f));
                graphics2D.setPaint(color2);
            }
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(new Line2D.Float(0.0f, 0.0f, f2, 0.0f));
            graphics2D.draw(DIMENSION_LINE_END);
            graphics2D.translate(f2, 0.0);
            graphics2D.draw(DIMENSION_LINE_END);
            graphics2D.translate(-f2, 0.0);
            graphics2D.setStroke(stroke2);
            graphics2D.draw(new Line2D.Float(0.0f, -dimensionLine.getOffset(), 0.0f, -5.0f));
            graphics2D.draw(new Line2D.Float(f2, -dimensionLine.getOffset(), f2, -5.0f));
            float f3 = bl ? this.preferences.getLengthUnit().getMagnetizedLength(f2, this.getPixelLength()) : f2;
            String string = this.preferences.getLengthUnit().getFormat().format(Float.valueOf(f3));
            TextStyle textStyle = dimensionLine.getLengthStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(dimensionLine.getClass());
            }
            if (bl) {
                textStyle = textStyle.deriveStyle((float)this.getFont().getSize() / this.getScale());
            }
            Font font2 = this.getFont(font, textStyle);
            FontMetrics fontMetrics = this.getFontMetrics(font2, textStyle);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            int n = fontMetrics.getAscent();
            graphics2D.translate((f2 - (float)rectangle2D.getWidth()) / 2.0f, dimensionLine.getOffset() <= 0.0f ? (double)(-fontMetrics.getDescent() - 1) : (double)(n + 1));
            if (bl) {
                graphics2D.setPaint(color);
                if (composite instanceof AlphaComposite) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, ((AlphaComposite)composite).getAlpha() * 0.7f));
                } else {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                }
                graphics2D.setStroke(new BasicStroke(3.0f / f));
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                TextLayout textLayout = new TextLayout(string, font2, fontRenderContext);
                graphics2D.draw(textLayout.getOutline(new AffineTransform()));
                graphics2D.setComposite(composite);
                graphics2D.setPaint(color2);
            }
            graphics2D.setFont(font2);
            graphics2D.drawString(string, 0, 0);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setFont(font);
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && paintMode == PaintMode.PAINT && paint2 != null) {
            this.paintDimensionLineResizeIndicator(graphics2D, (DimensionLine)list.get(0), paint2, f);
        }
    }

    private void paintDimensionLineResizeIndicator(Graphics2D graphics2D, DimensionLine dimensionLine, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            double d = Math.atan2(dimensionLine.getYEnd() - dimensionLine.getYStart(), dimensionLine.getXEnd() - dimensionLine.getXStart());
            AffineTransform affineTransform = graphics2D.getTransform();
            float f2 = 1.0f / f;
            graphics2D.translate(dimensionLine.getXStart(), dimensionLine.getYStart());
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            graphics2D.rotate(Math.PI);
            graphics2D.scale(f2, f2);
            graphics2D.draw(WALL_AND_LINE_RESIZE_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(dimensionLine.getXEnd(), dimensionLine.getYEnd());
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            graphics2D.scale(f2, f2);
            graphics2D.draw(WALL_AND_LINE_RESIZE_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((dimensionLine.getXStart() + dimensionLine.getXEnd()) / 2.0f, (dimensionLine.getYStart() + dimensionLine.getYEnd()) / 2.0f);
            graphics2D.rotate(d);
            graphics2D.translate(0.0, dimensionLine.getOffset());
            graphics2D.rotate(dimensionLine.getOffset() <= 0.0f ? 1.5707963267948966 : -1.5707963267948966);
            graphics2D.scale(f2, f2);
            graphics2D.draw(WALL_AND_LINE_RESIZE_INDICATOR);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintLabels(Graphics2D graphics2D, Collection<Label> collection, List<Selectable> list, Paint paint, Stroke stroke, float f, Color color, PaintMode paintMode) {
        Font font = graphics2D.getFont();
        graphics2D.setPaint(color);
        for (Label label : collection) {
            boolean bl = list.contains(label);
            if (paintMode == PaintMode.CLIPBOARD && !bl) continue;
            String string = label.getText();
            float f2 = label.getX();
            float f3 = label.getY();
            TextStyle textStyle = label.getStyle();
            if (textStyle == null) {
                textStyle = this.preferences.getDefaultTextStyle(label.getClass());
            }
            float[][] fArray = this.getTextBounds(string, textStyle, f2, f3, 0.0f);
            float f4 = fArray[2][0] - fArray[0][0];
            graphics2D.setFont(this.getFont(font, textStyle));
            graphics2D.drawString(string, f2 - f4 / 2.0f, f3);
            if (paintMode != PaintMode.PAINT || !this.selectedItemsOutlinePainted || !bl) continue;
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(this.getShape(fArray));
            graphics2D.setPaint(color);
        }
        graphics2D.setFont(font);
    }

    private void paintCompass(Graphics2D graphics2D, List<Selectable> list, float f, Color color, PaintMode paintMode) {
        Compass compass = this.home.getCompass();
        if (compass.isVisible() && (paintMode != PaintMode.CLIPBOARD || list.contains(compass))) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(compass.getX(), compass.getY());
            graphics2D.rotate(compass.getNorthDirection());
            float f2 = compass.getDiameter();
            graphics2D.scale(f2, f2);
            graphics2D.setColor(color);
            graphics2D.fill(COMPASS);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintCompassOutline(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color) {
        Compass compass = this.home.getCompass();
        if (list.contains(compass) && compass.isVisible()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(compass.getX(), compass.getY());
            graphics2D.rotate(compass.getNorthDirection());
            float f2 = compass.getDiameter();
            graphics2D.scale(f2, f2);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(new BasicStroke((5.5f + f) / f2 / f));
            graphics2D.draw(COMPASS_DISC);
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(1.0f / f2 / f));
            graphics2D.draw(COMPASS_DISC);
            graphics2D.setTransform(affineTransform);
            if (list.size() == 1 && list.get(0) == compass) {
                graphics2D.setPaint(paint2);
                this.paintCompassIndicators(graphics2D, compass, paint2, f);
            }
        }
    }

    private void paintCompassIndicators(Graphics2D graphics2D, Compass compass, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float[][] fArray = compass.getPoints();
            float f2 = 1.0f / f;
            graphics2D.translate((fArray[2][0] + fArray[3][0]) / 2.0f, (fArray[2][1] + fArray[3][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(compass.getNorthDirection());
            graphics2D.draw(COMPASS_ROTATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((fArray[1][0] + fArray[2][0]) / 2.0f, (fArray[1][1] + fArray[2][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(compass.getNorthDirection());
            graphics2D.draw(COMPASS_RESIZE_INDICATOR);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintWallAlignmentFeedback(Graphics2D graphics2D, Wall wall, Point2D point2D, boolean bl, Paint paint, Stroke stroke, float f, Paint paint2, Stroke stroke2) {
        if (point2D != null) {
            float f2 = 0.5f / f;
            float f3 = (float)point2D.getX();
            float f4 = (float)point2D.getY();
            float f5 = Float.POSITIVE_INFINITY;
            float f6 = Float.POSITIVE_INFINITY;
            for (Wall wall2 : this.home.getWalls()) {
                if (wall2 == wall) continue;
                if (Math.abs(f3 - wall2.getXStart()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXStart(), wall2.getYStart(), wall))) {
                    if (Math.abs(f6) > Math.abs(f4 - wall2.getYStart())) {
                        f6 = f4 - wall2.getYStart();
                    }
                } else if (Math.abs(f3 - wall2.getXEnd()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXEnd(), wall2.getYEnd(), wall)) && Math.abs(f6) > Math.abs(f4 - wall2.getYEnd())) {
                    f6 = f4 - wall2.getYEnd();
                }
                if (Math.abs(f4 - wall2.getYStart()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXStart(), wall2.getYStart(), wall))) {
                    if (Math.abs(f5) > Math.abs(f3 - wall2.getXStart())) {
                        f5 = f3 - wall2.getXStart();
                    }
                } else if (Math.abs(f4 - wall2.getYEnd()) < f2 && (wall == null || !this.equalsWallPoint(wall2.getXEnd(), wall2.getYEnd(), wall)) && Math.abs(f5) > Math.abs(f3 - wall2.getXEnd())) {
                    f5 = f3 - wall2.getXEnd();
                }
                Object object = wall2.getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (int i = 0; i < ((float[][])object).length; ++i) {
                    if (Math.abs(f3 - object[i][0]) < f2 && (wall == null || !this.equalsWallPoint(object[i][0], object[i][1], wall)) && Math.abs(f6) > Math.abs(f4 - object[i][1])) {
                        f6 = f4 - object[i][1];
                    }
                    if (!(Math.abs(f4 - object[i][1]) < f2) || wall != null && this.equalsWallPoint(object[i][0], object[i][1], wall) || !(Math.abs(f5) > Math.abs(f3 - object[i][0]))) continue;
                    f5 = f3 - object[i][0];
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            if (f5 != Float.POSITIVE_INFINITY) {
                if (f5 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3 + 25.0f / f, f4, f3 - f5 - 25.0f / f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 - 25.0f / f, f4, f3 - f5 + 25.0f / f, f4));
                }
            }
            if (f6 != Float.POSITIVE_INFINITY) {
                if (f6 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3, f4 + 25.0f / f, f3, f4 - f6 - 25.0f / f));
                } else {
                    graphics2D.draw(new Line2D.Float(f3, f4 - 25.0f / f, f3, f4 - f6 + 25.0f / f));
                }
            }
            if (bl) {
                this.paintPointFeedback(graphics2D, point2D, paint, f, paint2, stroke2);
            }
        }
    }

    private void paintPointFeedback(Graphics2D graphics2D, Point2D point2D, Paint paint, float f, Paint paint2, Stroke stroke) {
        graphics2D.setPaint(paint2);
        graphics2D.setStroke(stroke);
        graphics2D.draw(new Ellipse2D.Float((float)point2D.getX() - 5.0f / f, (float)point2D.getY() - 5.0f / f, 10.0f / f, 10.0f / f));
        graphics2D.setPaint(paint);
        graphics2D.setStroke(new BasicStroke(1.0f / f));
        graphics2D.draw(new Line2D.Float((float)point2D.getX(), (float)point2D.getY() - 5.0f / f, (float)point2D.getX(), (float)point2D.getY() + 5.0f / f));
        graphics2D.draw(new Line2D.Float((float)point2D.getX() - 5.0f / f, (float)point2D.getY(), (float)point2D.getX() + 5.0f / f, (float)point2D.getY()));
    }

    private boolean equalsWallPoint(float f, float f2, Wall wall) {
        return f == wall.getXStart() && f2 == wall.getYStart() || f == wall.getXEnd() && f2 == wall.getYEnd();
    }

    private void paintRoomAlignmentFeedback(Graphics2D graphics2D, Room room, Point2D point2D, boolean bl, Paint paint, Stroke stroke, float f, Paint paint2, Stroke stroke2) {
        if (point2D != null) {
            int n;
            Object object;
            float f2 = 0.5f / f;
            float f3 = (float)point2D.getX();
            float f4 = (float)point2D.getY();
            float f5 = Float.POSITIVE_INFINITY;
            float f6 = Float.POSITIVE_INFINITY;
            for (Room selectable : this.home.getRooms()) {
                int n2;
                object = selectable.getPoints();
                n = -1;
                if (selectable == room) {
                    for (n2 = 0; n2 < ((float[][])object).length; ++n2) {
                        if (object[n2][0] != f3 || object[n2][1] != f4) continue;
                        n = n2;
                        break;
                    }
                }
                for (n2 = 0; n2 < ((float[][])object).length; ++n2) {
                    if (n != -1 && (n2 == n || ((float[][])object).length <= 2)) continue;
                    if (Math.abs(f3 - object[n2][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n2][1])) {
                        f6 = f4 - object[n2][1];
                    }
                    if (!(Math.abs(f4 - object[n2][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n2][0]))) continue;
                    f5 = f3 - object[n2][0];
                }
            }
            for (Wall wall : this.home.getWalls()) {
                object = wall.getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            if (f5 != Float.POSITIVE_INFINITY) {
                if (f5 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3 + 25.0f / f, f4, f3 - f5 - 25.0f / f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 - 25.0f / f, f4, f3 - f5 + 25.0f / f, f4));
                }
            }
            if (f6 != Float.POSITIVE_INFINITY) {
                if (f6 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3, f4 + 25.0f / f, f3, f4 - f6 - 25.0f / f));
                } else {
                    graphics2D.draw(new Line2D.Float(f3, f4 - 25.0f / f, f3, f4 - f6 + 25.0f / f));
                }
            }
            if (bl) {
                this.paintPointFeedback(graphics2D, point2D, paint, f, paint2, stroke2);
            }
        }
    }

    private void paintDimensionLineAlignmentFeedback(Graphics2D graphics2D, DimensionLine dimensionLine, Point2D point2D, boolean bl, Paint paint, Stroke stroke, float f, Paint paint2, Stroke stroke2) {
        if (point2D != null) {
            int n;
            Object object;
            float f2 = 0.5f / f;
            float f3 = (float)point2D.getX();
            float f4 = (float)point2D.getY();
            float f5 = Float.POSITIVE_INFINITY;
            float f6 = Float.POSITIVE_INFINITY;
            for (Room selectable : this.home.getRooms()) {
                object = selectable.getPoints();
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            for (DimensionLine dimensionLine2 : this.home.getDimensionLines()) {
                if (dimensionLine2 == dimensionLine) continue;
                if (Math.abs(f3 - dimensionLine2.getXStart()) < f2 && (dimensionLine == null || !this.equalsDimensionLinePoint(dimensionLine2.getXStart(), dimensionLine2.getYStart(), dimensionLine))) {
                    if (Math.abs(f6) > Math.abs(f4 - dimensionLine2.getYStart())) {
                        f6 = f4 - dimensionLine2.getYStart();
                    }
                } else if (Math.abs(f3 - dimensionLine2.getXEnd()) < f2 && (dimensionLine == null || !this.equalsDimensionLinePoint(dimensionLine2.getXEnd(), dimensionLine2.getYEnd(), dimensionLine)) && Math.abs(f6) > Math.abs(f4 - dimensionLine2.getYEnd())) {
                    f6 = f4 - dimensionLine2.getYEnd();
                }
                if (Math.abs(f4 - dimensionLine2.getYStart()) < f2 && (dimensionLine == null || !this.equalsDimensionLinePoint(dimensionLine2.getXStart(), dimensionLine2.getYStart(), dimensionLine))) {
                    if (!(Math.abs(f5) > Math.abs(f3 - dimensionLine2.getXStart()))) continue;
                    f5 = f3 - dimensionLine2.getXStart();
                    continue;
                }
                if (!(Math.abs(f4 - dimensionLine2.getYEnd()) < f2) || dimensionLine != null && this.equalsDimensionLinePoint(dimensionLine2.getXEnd(), dimensionLine2.getYEnd(), dimensionLine) || !(Math.abs(f5) > Math.abs(f3 - dimensionLine2.getXEnd()))) continue;
                f5 = f3 - dimensionLine2.getXEnd();
            }
            for (Wall wall : this.home.getWalls()) {
                object = wall.getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
                object = homePieceOfFurniture.getPoints();
                for (n = 0; n < ((float[][])object).length; ++n) {
                    if (Math.abs(f3 - object[n][0]) < f2 && Math.abs(f6) > Math.abs(f4 - object[n][1])) {
                        f6 = f4 - object[n][1];
                    }
                    if (!(Math.abs(f4 - object[n][1]) < f2) || !(Math.abs(f5) > Math.abs(f3 - object[n][0]))) continue;
                    f5 = f3 - object[n][0];
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            if (f5 != Float.POSITIVE_INFINITY) {
                if (f5 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3 + 25.0f / f, f4, f3 - f5 - 25.0f / f, f4));
                } else {
                    graphics2D.draw(new Line2D.Float(f3 - 25.0f / f, f4, f3 - f5 + 25.0f / f, f4));
                }
            }
            if (f6 != Float.POSITIVE_INFINITY) {
                if (f6 > 0.0f) {
                    graphics2D.draw(new Line2D.Float(f3, f4 + 25.0f / f, f3, f4 - f6 - 25.0f / f));
                } else {
                    graphics2D.draw(new Line2D.Float(f3, f4 - 25.0f / f, f3, f4 - f6 + 25.0f / f));
                }
            }
            if (bl) {
                this.paintPointFeedback(graphics2D, point2D, paint, f, paint2, stroke2);
            }
        }
    }

    private boolean equalsDimensionLinePoint(float f, float f2, DimensionLine dimensionLine) {
        return f == dimensionLine.getXStart() && f2 == dimensionLine.getYStart() || f == dimensionLine.getXEnd() && f2 == dimensionLine.getYEnd();
    }

    private void paintAngleFeedback(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, Point2D point2D3, float f, Color color) {
        double d;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f / f));
        double d2 = Math.atan2(point2D.getY() - point2D2.getY(), point2D2.getX() - point2D.getX());
        if (d2 < 0.0) {
            d2 = Math.PI * 2 + d2;
        }
        if ((d = Math.atan2(point2D.getY() - point2D3.getY(), point2D3.getX() - point2D.getX())) < 0.0) {
            d = Math.PI * 2 + d;
        }
        double d3 = d - d2;
        if (d2 > d) {
            d3 = Math.PI * 2 + d3;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(point2D.getX(), point2D.getY());
        float f2 = 20.0f / f;
        graphics2D.draw(new Arc2D.Double(-f2, -f2, f2 * 2.0f, f2 * 2.0f, Math.toDegrees(d2), Math.toDegrees(d3), 0));
        graphics2D.draw(new Line2D.Double(0.0, 0.0, (double)(f2 += 5.0f / f) * Math.cos(d2), (double)(-f2) * Math.sin(d2)));
        graphics2D.draw(new Line2D.Double(0.0, 0.0, (double)f2 * Math.cos(d2 + d3), (double)(-f2) * Math.sin(d2 + d3)));
        graphics2D.setTransform(affineTransform);
    }

    private void paintCamera(Graphics2D graphics2D, List<Selectable> list, Paint paint, Stroke stroke, Paint paint2, float f, Color color, Color color2) {
        ObserverCamera observerCamera = this.home.getObserverCamera();
        if (observerCamera == this.home.getCamera()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(observerCamera.getX(), observerCamera.getY());
            graphics2D.rotate(observerCamera.getYaw());
            AffineTransform affineTransform2 = new AffineTransform();
            float[][] fArray = observerCamera.getPoints();
            double d = Point2D.distance(fArray[0][0], fArray[0][1], fArray[3][0], fArray[3][1]);
            double d2 = Point2D.distance(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
            affineTransform2.scale(d2, d);
            Area area = new Area(CAMERA_BODY).createTransformedArea(affineTransform2);
            Area area2 = new Area(CAMERA_HEAD).createTransformedArea(affineTransform2);
            graphics2D.setPaint(color);
            graphics2D.fill(area);
            graphics2D.setPaint(color2);
            BasicStroke basicStroke = new BasicStroke(1.0f / f);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(area);
            if (list.contains(observerCamera) && this.selectedItemsOutlinePainted) {
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                Area area3 = new Area(area);
                area3.add(new Area(area2));
                graphics2D.draw(area3);
            }
            graphics2D.setPaint(color);
            graphics2D.fill(area2);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(area2);
            double d3 = (float)Math.sin(observerCamera.getFieldOfView() / 2.0f);
            double d4 = (float)Math.cos(observerCamera.getFieldOfView() / 2.0f);
            float f2 = (float)((double)0.9f * d * d3);
            float f3 = (float)((double)0.9f * d * d4);
            float f4 = (float)((double)2.2f * d * d3);
            float f5 = (float)((double)2.2f * d * d4);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f2, f3);
            generalPath.lineTo(f4, f5);
            generalPath.moveTo(-f2, f3);
            generalPath.lineTo(-f4, f5);
            graphics2D.draw(generalPath);
            graphics2D.setTransform(affineTransform);
            if (list.size() == 1 && list.get(0) == observerCamera) {
                this.paintCameraRotationIndicators(graphics2D, observerCamera, paint2, f);
            }
        }
    }

    private void paintCameraRotationIndicators(Graphics2D graphics2D, ObserverCamera observerCamera, Paint paint, float f) {
        if (this.resizeIndicatorVisible) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(INDICATOR_STROKE);
            AffineTransform affineTransform = graphics2D.getTransform();
            float[][] fArray = observerCamera.getPoints();
            float f2 = 1.0f / f;
            graphics2D.translate((fArray[0][0] + fArray[3][0]) / 2.0f, (fArray[0][1] + fArray[3][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(observerCamera.getYaw());
            graphics2D.draw(CAMERA_YAW_ROTATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((fArray[1][0] + fArray[2][0]) / 2.0f, (fArray[1][1] + fArray[2][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.rotate(observerCamera.getYaw());
            graphics2D.draw(CAMERA_PITCH_ROTATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate((fArray[0][0] + fArray[1][0]) / 2.0f, (fArray[0][1] + fArray[1][1]) / 2.0f);
            graphics2D.scale(f2, f2);
            graphics2D.draw(POINT_INDICATOR);
            graphics2D.translate(Math.sin(observerCamera.getYaw()) * 8.0, -Math.cos(observerCamera.getYaw()) * 8.0);
            graphics2D.draw(CAMERA_ELEVATION_INDICATOR);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void paintRectangleFeedback(Graphics2D graphics2D, Color color, float f) {
        if (this.rectangleFeedback != null) {
            graphics2D.setPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), 32));
            graphics2D.fill(this.rectangleFeedback);
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f / f));
            graphics2D.draw(this.rectangleFeedback);
        }
    }

    private Shape getShape(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public void setRectangleFeedback(float f, float f2, float f3, float f4) {
        this.rectangleFeedback = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        this.rectangleFeedback.add(f3, f4);
        this.repaint();
    }

    @Override
    public void makeSelectionVisible() {
        if (!this.selectionScrollUpdated) {
            this.selectionScrollUpdated = true;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    PlanComponent.this.selectionScrollUpdated = false;
                    Rectangle2D rectangle2D = PlanComponent.this.getSelectionBounds(true);
                    if (rectangle2D != null) {
                        Rectangle rectangle = PlanComponent.this.getShapePixelBounds(rectangle2D);
                        rectangle.grow(5, 5);
                        PlanComponent.this.scrollRectToVisible(rectangle);
                    }
                }
            });
        }
    }

    private Rectangle2D getSelectionBounds(boolean bl) {
        if (bl) {
            return this.getItemsBounds(this.getGraphics(), this.home.getSelectedItems());
        }
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.home.getSelectedItems());
        arrayList.remove(this.home.getCamera());
        return this.getItemsBounds(this.getGraphics(), arrayList);
    }

    @Override
    public void makePointVisible(float f, float f2) {
        this.scrollRectToVisible(this.getShapePixelBounds(new Rectangle2D.Float(f, f2, 1.0f / this.getScale(), 1.0f / this.getScale())));
    }

    @Override
    public void moveView(float f, float f2) {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = jViewport.getViewRect();
            rectangle.translate(Math.round(f * this.getScale()), Math.round(f2 * this.getScale()));
            rectangle.x = Math.min(Math.max(0, rectangle.x), this.getWidth() - rectangle.width);
            rectangle.y = Math.min(Math.max(0, rectangle.y), this.getHeight() - rectangle.height);
            jViewport.setViewPosition(rectangle.getLocation());
        }
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float f) {
        if (this.scale != f) {
            JViewport jViewport = null;
            Rectangle rectangle = null;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.getParent() instanceof JViewport) {
                jViewport = (JViewport)this.getParent();
                rectangle = jViewport.getViewRect();
                f2 = (this.convertXPixelToModel(rectangle.x) + this.convertXPixelToModel(rectangle.x + rectangle.width)) / 2.0f;
                f3 = (this.convertYPixelToModel(rectangle.y) + this.convertYPixelToModel(rectangle.y + rectangle.height)) / 2.0f;
            }
            this.scale = f;
            this.revalidate(false);
            if (jViewport instanceof JViewport) {
                Dimension dimension = jViewport.getViewSize();
                float f4 = this.convertXPixelToModel(rectangle.x + rectangle.width) - this.convertXPixelToModel(rectangle.x);
                int n = Math.max(0, Math.min(this.convertXModelToPixel(f2 - f4 / 2.0f), dimension.width - rectangle.x));
                float f5 = this.convertYPixelToModel(rectangle.y + rectangle.height) - this.convertYPixelToModel(rectangle.y);
                int n2 = Math.max(0, Math.min(this.convertYModelToPixel(f3 - f5 / 2.0f), dimension.height - rectangle.y));
                jViewport.setViewPosition(new Point(n, n2));
            }
        }
    }

    @Override
    public float convertXPixelToModel(int n) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (float)(n - insets.left) / this.getScale() - 40.0f + (float)rectangle2D.getMinX();
    }

    @Override
    public float convertYPixelToModel(int n) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (float)(n - insets.top) / this.getScale() - 40.0f + (float)rectangle2D.getMinY();
    }

    private int convertXModelToPixel(float f) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (int)Math.round(((double)f - rectangle2D.getMinX() + 40.0) * (double)this.getScale()) + insets.left;
    }

    private int convertYModelToPixel(float f) {
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = this.getPlanBounds();
        return (int)Math.round(((double)f - rectangle2D.getMinY() + 40.0) * (double)this.getScale()) + insets.top;
    }

    @Override
    public int convertXModelToScreen(float f) {
        Point point = new Point(this.convertXModelToPixel(f), 0);
        SwingUtilities.convertPointToScreen(point, this);
        return point.x;
    }

    @Override
    public int convertYModelToScreen(float f) {
        Point point = new Point(0, this.convertYModelToPixel(f));
        SwingUtilities.convertPointToScreen(point, this);
        return point.y;
    }

    @Override
    public float getPixelLength() {
        return 1.0f / this.getScale();
    }

    private Rectangle getShapePixelBounds(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        return new Rectangle(this.convertXModelToPixel((float)rectangle2D.getMinX()), this.convertYModelToPixel((float)rectangle2D.getMinY()), (int)Math.round(rectangle2D.getWidth() * (double)this.getScale()), (int)Math.round(rectangle2D.getHeight() * (double)this.getScale()));
    }

    @Override
    public void setCursor(PlanView.CursorType cursorType) {
        switch (cursorType) {
            case SELECTION: {
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case DRAW: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case ROTATION: {
                this.setCursor(this.rotationCursor);
                break;
            }
            case HEIGHT: {
                this.setCursor(this.heightCursor);
                break;
            }
            case POWER: {
                this.setCursor(this.powerCursor);
                break;
            }
            case ELEVATION: {
                this.setCursor(this.elevationCursor);
                break;
            }
            case RESIZE: {
                this.setCursor(this.resizeCursor);
                break;
            }
            case PANNING: {
                this.setCursor(this.panningCursor);
                break;
            }
            case DUPLICATION: {
                this.setCursor(this.duplicationCursor);
            }
        }
    }

    @Override
    public void setToolTipFeedback(String string, float f, float f2) {
        this.stopToolTipPropertiesEdition();
        JToolTip jToolTip = this.getToolTip();
        jToolTip.setTipText(string);
        this.showToolTipComponentAt(jToolTip, f, f2);
    }

    private JToolTip getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new JToolTip();
            this.toolTip.setComponent(this);
        }
        return this.toolTip;
    }

    private void showToolTipComponentAt(JComponent jComponent, float f, float f2) {
        Object object;
        if (this.toolTipWindow == null) {
            this.toolTipWindow = new JWindow(JOptionPane.getFrameForComponent(this));
            this.toolTipWindow.setFocusableWindowState(false);
            this.toolTipWindow.add(jComponent);
            object = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    Point point = SwingUtilities.convertPoint(PlanComponent.this.toolTipWindow, mouseEvent.getX(), mouseEvent.getY(), PlanComponent.this);
                    PlanComponent.this.dispatchEvent(new MouseEvent(PlanComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }
            };
            this.toolTipWindow.addMouseListener((MouseListener)object);
            this.toolTipWindow.addMouseMotionListener((MouseMotionListener)object);
        } else {
            object = this.toolTipWindow.getContentPane();
            if (((Container)object).getComponent(0) != jComponent) {
                ((Container)object).removeAll();
                ((Container)object).add(jComponent);
            }
            jComponent.revalidate();
        }
        object = new Point(this.convertXModelToPixel(f), this.convertYModelToPixel(f2));
        SwingUtilities.convertPointToScreen((Point)object, this);
        Dimension dimension = this.getToolkit().getBestCursorSize(16, 16);
        if (dimension.width != 0) {
            ((Point)object).x += dimension.width / 2 + 3;
            ((Point)object).y += dimension.height / 2 + 3;
        } else {
            ((Point)object).x += 11;
            ((Point)object).y += 11;
        }
        this.toolTipWindow.setLocation((Point)object);
        this.toolTipWindow.pack();
        this.toolTipWindow.setVisible(true);
        jComponent.paintImmediately(jComponent.getBounds());
    }

    @Override
    public void setToolTipEditedProperties(final PlanController.EditableProperty[] editablePropertyArray, Object[] objectArray, float f, float f2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = UIManager.getBorder("ToolTip.border");
        if (!OperatingSystem.isMacOSX()) {
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 3, 0, 2));
        }
        jPanel.setBorder(border);
        JToolTip jToolTip = this.getToolTip();
        jPanel.setBackground(jToolTip.getBackground());
        jPanel.setForeground(jToolTip.getForeground());
        for (int i = 0; i < editablePropertyArray.length; ++i) {
            JFormattedTextField jFormattedTextField = this.toolTipEditableTextFields.get((Object)editablePropertyArray[i]);
            jFormattedTextField.setValue(objectArray[i]);
            JLabel jLabel = new JLabel(this.preferences.getLocalizedString(PlanComponent.class, editablePropertyArray[i].name() + ".editablePropertyLabel.text", new Object[0]) + " ");
            jLabel.setFont(jFormattedTextField.getFont());
            JLabel jLabel2 = null;
            if (editablePropertyArray[i] == PlanController.EditableProperty.ANGLE || editablePropertyArray[i] == PlanController.EditableProperty.ARC_EXTENT) {
                jLabel2 = new JLabel(this.preferences.getLocalizedString(PlanComponent.class, "degreeLabel.text", new Object[0]));
            } else if (this.preferences.getLengthUnit() != LengthUnit.INCH) {
                jLabel2 = new JLabel(" " + this.preferences.getLengthUnit().getName());
            }
            JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
            jPanel2.setOpaque(false);
            jPanel2.add(jLabel);
            jPanel2.add(jFormattedTextField);
            if (jLabel2 != null) {
                jLabel2.setFont(jFormattedTextField.getFont());
                jPanel2.add(jLabel2);
            }
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.showToolTipComponentAt(jPanel, f, f2);
        this.toolTipKeyListener = new KeyListener(){
            private int focusedTextFieldIndex;
            private JTextComponent focusedTextField;
            {
                this.setFocusedTextFieldIndex(0);
            }

            private void setFocusedTextFieldIndex(int n) {
                if (this.focusedTextField != null) {
                    this.focusedTextField.getCaret().setVisible(false);
                    this.focusedTextField.getCaret().setSelectionVisible(false);
                }
                this.focusedTextFieldIndex = n;
                this.focusedTextField = (JTextComponent)PlanComponent.this.toolTipEditableTextFields.get((Object)editablePropertyArray[n]);
                if (this.focusedTextField.getText().length() == 0) {
                    this.focusedTextField.getCaret().setVisible(false);
                } else {
                    this.focusedTextField.selectAll();
                }
                this.focusedTextField.getCaret().setSelectionVisible(true);
            }

            public void keyPressed(KeyEvent keyEvent) {
                this.keyTyped(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(this.focusedTextField, keyEvent);
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                Set<AWTKeyStroke> set = this.focusedTextField.getFocusTraversalKeys(0);
                if (set.contains(AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent)) || keyEvent.getKeyCode() == 40) {
                    this.setFocusedTextFieldIndex((this.focusedTextFieldIndex + 1) % editablePropertyArray.length);
                    keyEvent.consume();
                } else {
                    Set<AWTKeyStroke> set2 = this.focusedTextField.getFocusTraversalKeys(1);
                    if (set2.contains(AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent)) || keyEvent.getKeyCode() == 38) {
                        this.setFocusedTextFieldIndex((this.focusedTextFieldIndex - 1 + editablePropertyArray.length) % editablePropertyArray.length);
                        keyEvent.consume();
                    } else if ((keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35) && OperatingSystem.isMacOSX() && !OperatingSystem.isMacOSXLeopardOrSuperior()) {
                        if (keyEvent.getKeyCode() == 36) {
                            this.focusedTextField.setCaretPosition(0);
                        } else if (keyEvent.getKeyCode() == 35) {
                            this.focusedTextField.setCaretPosition(this.focusedTextField.getText().length());
                        }
                        keyEvent.consume();
                    } else if (keyEvent.getKeyCode() != 27 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(this.focusedTextField, keyEvent);
                        this.focusedTextField.getCaret().setVisible(true);
                        PlanComponent.this.toolTipWindow.pack();
                    }
                }
            }
        };
        this.addKeyListener(this.toolTipKeyListener);
        this.setFocusTraversalKeysEnabled(false);
        this.installEditionKeyboardActions();
    }

    @Override
    public void deleteToolTipFeedback() {
        this.stopToolTipPropertiesEdition();
        if (this.toolTip != null) {
            this.toolTip.setTipText(null);
        }
        if (this.toolTipWindow != null) {
            this.toolTipWindow.setVisible(false);
        }
    }

    private void stopToolTipPropertiesEdition() {
        if (this.toolTipKeyListener != null) {
            this.installDefaultKeyboardActions();
            this.setFocusTraversalKeysEnabled(true);
            this.removeKeyListener(this.toolTipKeyListener);
            this.toolTipKeyListener = null;
            for (JFormattedTextField jFormattedTextField : this.toolTipEditableTextFields.values()) {
                jFormattedTextField.getCaret().setVisible(false);
                jFormattedTextField.getCaret().setSelectionVisible(false);
            }
        }
    }

    @Override
    public void setResizeIndicatorVisible(boolean bl) {
        this.resizeIndicatorVisible = bl;
        this.repaint();
    }

    @Override
    public void setAlignmentFeedback(Class<? extends Selectable> clazz, Selectable selectable, float f, float f2, boolean bl) {
        this.alignedObjectClass = clazz;
        this.alignedObjectFeedback = selectable;
        this.locationFeeback = new Point2D.Float(f, f2);
        this.showPointFeedback = bl;
        this.repaint();
    }

    @Override
    public void setAngleFeedback(float f, float f2, float f3, float f4, float f5, float f6) {
        this.centerAngleFeedback = new Point2D.Float(f, f2);
        this.point1AngleFeedback = new Point2D.Float(f3, f4);
        this.point2AngleFeedback = new Point2D.Float(f5, f6);
    }

    @Override
    public void setDraggedItemsFeedback(List<Selectable> list) {
        this.draggedItemsFeedback = list;
        this.repaint();
    }

    @Override
    public void setDimensionLinesFeedback(List<DimensionLine> list) {
        this.dimensionLinesFeedback = list;
        this.repaint();
    }

    @Override
    public void deleteFeedback() {
        this.deleteToolTipFeedback();
        this.rectangleFeedback = null;
        this.alignedObjectClass = null;
        this.alignedObjectFeedback = null;
        this.locationFeeback = null;
        this.centerAngleFeedback = null;
        this.point1AngleFeedback = null;
        this.point2AngleFeedback = null;
        this.draggedItemsFeedback = null;
        this.dimensionLinesFeedback = null;
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width / 2;
        }
        return rectangle.height / 2;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getPreferredSize().height < ((JViewport)this.getParent()).getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getPreferredSize().width < ((JViewport)this.getParent()).getWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width / 10;
        }
        return rectangle.height / 10;
    }

    @Override
    public View getHorizontalRuler() {
        if (this.horizontalRuler == null) {
            this.horizontalRuler = new PlanRulerComponent(0);
        }
        return this.horizontalRuler;
    }

    @Override
    public View getVerticalRuler() {
        if (this.verticalRuler == null) {
            this.verticalRuler = new PlanRulerComponent(1);
        }
        return this.verticalRuler;
    }

    static {
        INDICATOR_STROKE = new BasicStroke(1.5f);
        POINT_STROKE = new BasicStroke(2.0f);
        POINT_INDICATOR = new Ellipse2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        FURNITURE_ROTATION_INDICATOR = new GeneralPath();
        FURNITURE_ROTATION_INDICATOR.append(POINT_INDICATOR, false);
        FURNITURE_ROTATION_INDICATOR.append(new Arc2D.Float(-8.0f, -8.0f, 16.0f, 16.0f, 45.0f, 180.0f, 0), false);
        FURNITURE_ROTATION_INDICATOR.moveTo(2.66f, -5.66f);
        FURNITURE_ROTATION_INDICATOR.lineTo(5.66f, -5.66f);
        FURNITURE_ROTATION_INDICATOR.lineTo(4.0f, -8.3f);
        FURNITURE_ELEVATION_POINT_INDICATOR = new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        FURNITURE_ELEVATION_INDICATOR = new GeneralPath();
        FURNITURE_ELEVATION_INDICATOR.moveTo(0.0f, -5.0f);
        FURNITURE_ELEVATION_INDICATOR.lineTo(0.0f, 5.0f);
        FURNITURE_ELEVATION_INDICATOR.moveTo(-2.5f, 5.0f);
        FURNITURE_ELEVATION_INDICATOR.lineTo(2.5f, 5.0f);
        FURNITURE_ELEVATION_INDICATOR.moveTo(-1.2f, 1.5f);
        FURNITURE_ELEVATION_INDICATOR.lineTo(0.0f, 4.5f);
        FURNITURE_ELEVATION_INDICATOR.lineTo(1.2f, 1.5f);
        FURNITURE_HEIGHT_POINT_INDICATOR = new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        FURNITURE_HEIGHT_INDICATOR = new GeneralPath();
        FURNITURE_HEIGHT_INDICATOR.moveTo(0.0f, -6.0f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(0.0f, 6.0f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-2.5f, -6.0f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(2.5f, -6.0f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-2.5f, 6.0f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(2.5f, 6.0f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-1.2f, -2.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(0.0f, -5.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(1.2f, -2.5f);
        FURNITURE_HEIGHT_INDICATOR.moveTo(-1.2f, 2.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(0.0f, 5.5f);
        FURNITURE_HEIGHT_INDICATOR.lineTo(1.2f, 2.5f);
        LIGHT_POWER_POINT_INDICATOR = new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f);
        LIGHT_POWER_INDICATOR = new GeneralPath();
        LIGHT_POWER_INDICATOR.moveTo(-8.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-6.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-6.0f, -1.0f);
        LIGHT_POWER_INDICATOR.closePath();
        LIGHT_POWER_INDICATOR.moveTo(-3.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-1.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(-1.0f, -2.5f);
        LIGHT_POWER_INDICATOR.lineTo(-3.0f, -1.8f);
        LIGHT_POWER_INDICATOR.closePath();
        LIGHT_POWER_INDICATOR.moveTo(2.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(4.0f, 0.0f);
        LIGHT_POWER_INDICATOR.lineTo(4.0f, -3.5f);
        LIGHT_POWER_INDICATOR.lineTo(2.0f, -2.8f);
        LIGHT_POWER_INDICATOR.closePath();
        FURNITURE_RESIZE_INDICATOR = new GeneralPath();
        FURNITURE_RESIZE_INDICATOR.append(new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f), false);
        FURNITURE_RESIZE_INDICATOR.moveTo(5.0f, -4.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(7.0f, -4.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(7.0f, 7.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(-4.0f, 7.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(-4.0f, 5.0f);
        FURNITURE_RESIZE_INDICATOR.moveTo(3.5f, 3.5f);
        FURNITURE_RESIZE_INDICATOR.lineTo(9.0f, 9.0f);
        FURNITURE_RESIZE_INDICATOR.moveTo(7.0f, 9.5f);
        FURNITURE_RESIZE_INDICATOR.lineTo(10.0f, 10.0f);
        FURNITURE_RESIZE_INDICATOR.lineTo(9.5f, 7.0f);
        WALL_ORIENTATION_INDICATOR = new GeneralPath();
        WALL_ORIENTATION_INDICATOR.moveTo(-4.0f, -4.0f);
        WALL_ORIENTATION_INDICATOR.lineTo(4.0f, 0.0f);
        WALL_ORIENTATION_INDICATOR.lineTo(-4.0f, 4.0f);
        WALL_POINT = new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);
        WALL_AND_LINE_RESIZE_INDICATOR = new GeneralPath();
        WALL_AND_LINE_RESIZE_INDICATOR.moveTo(5.0f, -2.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(5.0f, 2.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.moveTo(6.0f, 0.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(11.0f, 0.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.moveTo(8.7f, -1.8f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(12.0f, 0.0f);
        WALL_AND_LINE_RESIZE_INDICATOR.lineTo(8.7f, 1.8f);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(-0.7853981633974483);
        CAMERA_YAW_ROTATION_INDICATOR = FURNITURE_ROTATION_INDICATOR.createTransformedShape(affineTransform);
        CAMERA_PITCH_ROTATION_INDICATOR = new GeneralPath();
        CAMERA_PITCH_ROTATION_INDICATOR.append(POINT_INDICATOR, false);
        CAMERA_PITCH_ROTATION_INDICATOR.moveTo(4.5f, 0.0f);
        CAMERA_PITCH_ROTATION_INDICATOR.lineTo(5.2f, 0.0f);
        CAMERA_PITCH_ROTATION_INDICATOR.moveTo(9.0f, 0.0f);
        CAMERA_PITCH_ROTATION_INDICATOR.lineTo(10.0f, 0.0f);
        CAMERA_PITCH_ROTATION_INDICATOR.append(new Arc2D.Float(7.0f, -8.0f, 5.0f, 16.0f, 20.0f, 320.0f, 0), false);
        CAMERA_PITCH_ROTATION_INDICATOR.moveTo(10.0f, 4.5f);
        CAMERA_PITCH_ROTATION_INDICATOR.lineTo(12.3f, 2.0f);
        CAMERA_PITCH_ROTATION_INDICATOR.lineTo(12.8f, 5.8f);
        CAMERA_ELEVATION_INDICATOR = new GeneralPath();
        CAMERA_ELEVATION_INDICATOR.moveTo(0.0f, -4.0f);
        CAMERA_ELEVATION_INDICATOR.lineTo(0.0f, 4.0f);
        CAMERA_ELEVATION_INDICATOR.moveTo(-2.5f, 4.0f);
        CAMERA_ELEVATION_INDICATOR.lineTo(2.5f, 4.0f);
        CAMERA_ELEVATION_INDICATOR.moveTo(-1.2f, 0.5f);
        CAMERA_ELEVATION_INDICATOR.lineTo(0.0f, 3.5f);
        CAMERA_ELEVATION_INDICATOR.lineTo(1.2f, 0.5f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Ellipse2D.Float(-0.5f, -0.425f, 1.0f, 0.85f), false);
        generalPath.append(new Ellipse2D.Float(-0.5f, -0.3f, 0.24f, 0.6f), false);
        generalPath.append(new Ellipse2D.Float(0.26f, -0.3f, 0.24f, 0.6f), false);
        CAMERA_BODY = new Area(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.append(new Ellipse2D.Float(-0.18f, -0.45f, 0.36f, 1.0f), false);
        generalPath2.moveTo(-0.04f, 0.55f);
        generalPath2.lineTo(0.0f, 0.65f);
        generalPath2.lineTo(0.04f, 0.55f);
        generalPath2.closePath();
        CAMERA_HEAD = new Area(generalPath2);
        DIMENSION_LINE_END = new GeneralPath();
        DIMENSION_LINE_END.moveTo(-5.0f, 5.0f);
        DIMENSION_LINE_END.lineTo(5.0f, -5.0f);
        DIMENSION_LINE_END.moveTo(0.0f, 5.0f);
        DIMENSION_LINE_END.lineTo(0.0f, -5.0f);
        TEXT_LOCATION_INDICATOR = new GeneralPath();
        TEXT_LOCATION_INDICATOR.append(new Arc2D.Float(-2.0f, 0.0f, 4.0f, 4.0f, 190.0f, 160.0f, 1), false);
        TEXT_LOCATION_INDICATOR.moveTo(0.0f, 4.0f);
        TEXT_LOCATION_INDICATOR.lineTo(0.0f, 12.0f);
        TEXT_LOCATION_INDICATOR.moveTo(-1.2f, 8.5f);
        TEXT_LOCATION_INDICATOR.lineTo(0.0f, 11.5f);
        TEXT_LOCATION_INDICATOR.lineTo(1.2f, 8.5f);
        TEXT_LOCATION_INDICATOR.moveTo(2.0f, 3.0f);
        TEXT_LOCATION_INDICATOR.lineTo(9.0f, 6.0f);
        TEXT_LOCATION_INDICATOR.moveTo(6.0f, 6.5f);
        TEXT_LOCATION_INDICATOR.lineTo(10.0f, 7.0f);
        TEXT_LOCATION_INDICATOR.lineTo(7.5f, 3.5f);
        TEXT_LOCATION_INDICATOR.moveTo(-2.0f, 3.0f);
        TEXT_LOCATION_INDICATOR.lineTo(-9.0f, 6.0f);
        TEXT_LOCATION_INDICATOR.moveTo(-6.0f, 6.5f);
        TEXT_LOCATION_INDICATOR.lineTo(-10.0f, 7.0f);
        TEXT_LOCATION_INDICATOR.lineTo(-7.5f, 3.5f);
        COMPASS_DISC = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);
        BasicStroke basicStroke = new BasicStroke(0.01f);
        COMPASS = new GeneralPath(basicStroke.createStrokedShape(COMPASS_DISC));
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(-0.6f, 0.0f, -0.5f, 0.0f)), false);
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(0.6f, 0.0f, 0.5f, 0.0f)), false);
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(0.0f, 0.6f, 0.0f, 0.5f)), false);
        basicStroke = new BasicStroke(0.04f, 1, 1);
        COMPASS.append(basicStroke.createStrokedShape(new Line2D.Float(0.0f, 0.0f, 0.0f, 0.0f)), false);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(0.0f, -0.47f);
        generalPath3.lineTo(0.15f, 0.46f);
        generalPath3.lineTo(0.0f, 0.32f);
        generalPath3.lineTo(-0.15f, 0.46f);
        generalPath3.closePath();
        basicStroke = new BasicStroke(0.03f);
        COMPASS.append(basicStroke.createStrokedShape(generalPath3), false);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo(-0.07f, -0.55f);
        generalPath4.lineTo(-0.07f, -0.69f);
        generalPath4.lineTo(0.07f, -0.56f);
        generalPath4.lineTo(0.07f, -0.7f);
        COMPASS.append(basicStroke.createStrokedShape(generalPath4), false);
        COMPASS_ROTATION_INDICATOR = new GeneralPath();
        COMPASS_ROTATION_INDICATOR.append(POINT_INDICATOR, false);
        COMPASS_ROTATION_INDICATOR.append(new Arc2D.Float(-8.0f, -7.0f, 16.0f, 16.0f, 210.0f, 120.0f, 0), false);
        COMPASS_ROTATION_INDICATOR.moveTo(4.0f, 5.66f);
        COMPASS_ROTATION_INDICATOR.lineTo(7.0f, 5.66f);
        COMPASS_ROTATION_INDICATOR.lineTo(5.6f, 8.3f);
        COMPASS_RESIZE_INDICATOR = new GeneralPath();
        COMPASS_RESIZE_INDICATOR.append(new Rectangle2D.Float(-1.5f, -1.5f, 3.0f, 3.0f), false);
        COMPASS_RESIZE_INDICATOR.moveTo(4.0f, -6.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(6.0f, -6.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(6.0f, 6.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(4.0f, 6.0f);
        COMPASS_RESIZE_INDICATOR.moveTo(5.0f, 0.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(9.0f, 0.0f);
        COMPASS_RESIZE_INDICATOR.moveTo(9.0f, -1.5f);
        COMPASS_RESIZE_INDICATOR.lineTo(12.0f, 0.0f);
        COMPASS_RESIZE_INDICATOR.lineTo(9.0f, 1.5f);
        ERROR_TEXTURE_IMAGE = new BufferedImage(1, 1, 1);
        Graphics graphics = ERROR_TEXTURE_IMAGE.getGraphics();
        graphics.setColor(Color.RED);
        graphics.drawLine(0, 0, 0, 0);
        graphics.dispose();
        WAIT_TEXTURE_IMAGE = new BufferedImage(1, 1, 1);
        graphics = WAIT_TEXTURE_IMAGE.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.drawLine(0, 0, 0, 0);
        graphics.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PieceOfFurnitureModelIcon
    extends PieceOfFurnitureTopViewIcon {
        private static Canvas3D canvas3D;
        private static BranchGroup sceneRoot;
        private static ExecutorService iconsCreationExecutor;

        public PieceOfFurnitureModelIcon(final HomePieceOfFurniture homePieceOfFurniture, final Component component) {
            super(IconManager.getInstance().getWaitIcon());
            ModelManager.getInstance().loadModel(homePieceOfFurniture.getModel(), component == null, new ModelManager.ModelObserver(){

                public void modelUpdated(BranchGroup branchGroup) {
                    final HomePieceOfFurniture homePieceOfFurniture2 = homePieceOfFurniture.clone();
                    if (homePieceOfFurniture2.isResizable()) {
                        homePieceOfFurniture2.setModelMirrored(false);
                    }
                    homePieceOfFurniture2.setX(0.0f);
                    homePieceOfFurniture2.setY(0.0f);
                    homePieceOfFurniture2.setElevation(-homePieceOfFurniture2.getHeight() / 2.0f);
                    homePieceOfFurniture2.setAngle(0.0f);
                    final float f = homePieceOfFurniture2.getWidth();
                    final float f2 = homePieceOfFurniture2.getDepth();
                    final float f3 = homePieceOfFurniture2.getHeight();
                    if (component != null) {
                        iconsCreationExecutor.execute(new Runnable(){

                            public void run() {
                                PieceOfFurnitureModelIcon.this.setIcon(PieceOfFurnitureModelIcon.this.createIcon(new HomePieceOfFurniture3D(homePieceOfFurniture2, null, true, true), f, f2, f3));
                                component.repaint();
                            }
                        });
                    } else {
                        PieceOfFurnitureModelIcon.this.setIcon(PieceOfFurnitureModelIcon.this.createIcon(new HomePieceOfFurniture3D(homePieceOfFurniture2, null, true, true), f, f2, f3));
                    }
                }

                public void modelError(Exception exception) {
                    PieceOfFurnitureModelIcon.this.setIcon(IconManager.getInstance().getErrorIcon());
                    if (component != null) {
                        component.repaint();
                    }
                }
            });
        }

        private Icon createIcon(BranchGroup branchGroup, float f, float f2, float f3) {
            Transform3D transform3D = new Transform3D();
            transform3D.setScale(new Vector3d((double)(2.0f / f), (double)(2.0f / f3), (double)(2.0f / f2)));
            TransformGroup transformGroup = new TransformGroup();
            transformGroup.setTransform(transform3D);
            transformGroup.addChild((Node)branchGroup);
            this.cloneTexture((Node)branchGroup, new HashMap<Texture, Texture>());
            BranchGroup branchGroup2 = new BranchGroup();
            branchGroup2.setCapability(17);
            branchGroup2.addChild((Node)transformGroup);
            sceneRoot.addChild((Node)branchGroup2);
            Background background = (Background)sceneRoot.getChild(0);
            background.setColor(1.0f, 1.0f, 1.0f);
            canvas3D.renderOffScreenBuffer();
            canvas3D.waitForOffScreenRendering();
            BufferedImage bufferedImage = canvas3D.getOffScreenBuffer().getImage();
            int[] nArray = this.getImagePixels(bufferedImage);
            background.setColor(0.0f, 0.0f, 0.0f);
            canvas3D.renderOffScreenBuffer();
            canvas3D.waitForOffScreenRendering();
            BufferedImage bufferedImage2 = canvas3D.getOffScreenBuffer().getImage();
            int[] nArray2 = this.getImagePixels(bufferedImage2);
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == nArray[i] || nArray2[i] != -16777216 || nArray[i] != -1) continue;
                nArray[i] = 0;
            }
            sceneRoot.removeChild((Node)branchGroup2);
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth())));
        }

        private void cloneTexture(Node node, Map<Texture, Texture> map) {
            Texture texture;
            Appearance appearance;
            if (node instanceof Group) {
                Enumeration enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.cloneTexture((Node)enumeration.nextElement(), map);
                }
            } else if (node instanceof Link) {
                this.cloneTexture((Node)((Link)node).getSharedGroup(), map);
            } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
                Texture texture2 = map.get(texture);
                if (texture2 == null) {
                    texture2 = (Texture)texture.cloneNodeComponent(false);
                    map.put(texture, texture2);
                }
                appearance.setTexture(texture2);
            }
        }

        private int[] getImagePixels(BufferedImage bufferedImage) {
            if (bufferedImage.getType() == 1 || bufferedImage.getType() == 2) {
                return (int[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            }
            return bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        }

        static {
            Light[] lightArray;
            canvas3D = Component3DManager.getInstance().getOffScreenCanvas3D(128, 128);
            SimpleUniverse simpleUniverse = new SimpleUniverse(canvas3D);
            ViewingPlatform viewingPlatform = simpleUniverse.getViewingPlatform();
            TransformGroup transformGroup = viewingPlatform.getViewPlatformTransform();
            Transform3D transform3D = new Transform3D();
            transform3D.rotX(-1.5707963267948966);
            Transform3D transform3D2 = new Transform3D();
            transform3D2.setTranslation(new Vector3f(0.0f, 5.0f, 0.0f));
            transform3D2.mul(transform3D);
            transformGroup.setTransform(transform3D2);
            Viewer viewer = viewingPlatform.getViewers()[0];
            javax.media.j3d.View view = viewer.getView();
            view.setProjectionPolicy(0);
            sceneRoot = new BranchGroup();
            sceneRoot.setCapability(12);
            sceneRoot.setCapability(13);
            sceneRoot.setCapability(14);
            Background background = new Background(1.1f, 1.1f, 1.1f);
            background.setCapability(17);
            background.setApplicationBounds((Bounds)new BoundingBox(new Point3d(-1.1, -1.1, -1.1), new Point3d(1.1, 1.1, 1.1)));
            sceneRoot.addChild((Node)background);
            for (Light light : lightArray = new Light[]{new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(-1.5f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.6f, 0.6f, 0.6f), new Vector3f(0.0f, -0.8f, 1.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))}) {
                light.setInfluencingBounds((Bounds)new BoundingBox(new Point3d(-1.1, -1.1, -1.1), new Point3d(1.1, 1.1, 1.1)));
                sceneRoot.addChild((Node)light);
            }
            simpleUniverse.addBranchGraph(sceneRoot);
            iconsCreationExecutor = Executors.newSingleThreadExecutor();
        }
    }

    private static class PieceOfFurniturePlanIcon
    extends PieceOfFurnitureTopViewIcon {
        private final float pieceWidth;
        private final float pieceDepth;
        private Integer pieceColor;
        private HomeTexture pieceTexture;

        public PieceOfFurniturePlanIcon(HomePieceOfFurniture homePieceOfFurniture, Component component) {
            super(IconManager.getInstance().getIcon(homePieceOfFurniture.getPlanIcon(), component));
            this.pieceWidth = homePieceOfFurniture.getWidth();
            this.pieceDepth = homePieceOfFurniture.getDepth();
            this.pieceColor = homePieceOfFurniture.getColor();
            this.pieceTexture = homePieceOfFurniture.getTexture();
        }

        public void paintIcon(final Component component, Graphics graphics, int n, int n2) {
            if (!this.isWaitIcon() && !this.isErrorIcon()) {
                if (this.pieceColor != null) {
                    BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                    Graphics graphics2 = bufferedImage.getGraphics();
                    super.paintIcon(component, graphics2, 0, 0);
                    graphics2.dispose();
                    final int n3 = this.pieceColor & 0xFF0000;
                    final int n4 = this.pieceColor & 0xFF00;
                    final int n5 = this.pieceColor & 0xFF;
                    this.setIcon(new ImageIcon(component.createImage(new FilteredImageSource(bufferedImage.getSource(), new RGBImageFilter(){
                        {
                            this.canFilterIndexColorModel = true;
                        }

                        public int filterRGB(int n, int n2, int n32) {
                            int n42 = n32 & 0xFF000000;
                            int n52 = (n32 & 0xFF0000) >> 16;
                            int n6 = (n32 & 0xFF00) >> 8;
                            int n7 = n32 & 0xFF;
                            int n8 = n52 + n52 + n52 + n6 + n6 + n6 + n6 + n7 >> 3;
                            n52 = n3 * n8 / 255 & 0xFF0000;
                            n6 = n4 * n8 / 255 & 0xFF00;
                            n7 = n5 * n8 / 255 & 0xFF;
                            return n42 | n52 | n6 | n7;
                        }
                    }))));
                    this.pieceColor = null;
                } else if (this.pieceTexture != null) {
                    if ("true".equalsIgnoreCase(System.getProperty("com.eteks.sweethome3d.no3D"))) {
                        Icon icon = IconManager.getInstance().getIcon(this.pieceTexture.getImage(), null);
                        if (IconManager.getInstance().isErrorIcon(icon)) {
                            this.setTexturedIcon(component, ERROR_TEXTURE_IMAGE);
                        } else {
                            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                            icon.paintIcon(component, graphics2D, 0, 0);
                            graphics2D.dispose();
                            this.setTexturedIcon(component, bufferedImage);
                        }
                    } else {
                        TextureManager.getInstance().loadTexture(this.pieceTexture.getImage(), true, new TextureManager.TextureObserver(){

                            public void textureUpdated(Texture texture) {
                                PieceOfFurniturePlanIcon.this.setTexturedIcon(component, ((ImageComponent2D)texture.getImage(0)).getImage());
                            }
                        });
                    }
                    this.pieceTexture = null;
                }
            }
            super.paintIcon(component, graphics, n, n2);
        }

        private void setTexturedIcon(Component component, BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            PieceOfFurniturePlanIcon.super.paintIcon(component, graphics2D, 0, 0);
            graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, (float)(-this.getIconWidth()) / this.pieceWidth * this.pieceTexture.getWidth(), (float)(-this.getIconHeight()) / this.pieceDepth * this.pieceTexture.getHeight())));
            graphics2D.setComposite(AlphaComposite.getInstance(5));
            graphics2D.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics2D.dispose();
            this.setIcon(new ImageIcon(bufferedImage2));
        }
    }

    private static abstract class PieceOfFurnitureTopViewIcon
    implements Icon {
        private Icon icon;

        public PieceOfFurnitureTopViewIcon(Icon icon) {
            this.icon = icon;
        }

        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
        }

        public boolean isWaitIcon() {
            return IconManager.getInstance().isWaitIcon(this.icon);
        }

        public boolean isErrorIcon() {
            return IconManager.getInstance().isErrorIcon(this.icon);
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }
    }

    public class PlanRulerComponent
    extends JComponent
    implements View {
        private int orientation;
        private Point mouseLocation;

        public PlanRulerComponent(int n) {
            this.orientation = n;
            this.setOpaque(true);
            this.setFont(UIManager.getFont("ToolTip.font"));
            this.addMouseListeners();
        }

        private void addMouseListeners() {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = mouseEvent.getPoint();
                    PlanRulerComponent.this.repaint();
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = mouseEvent.getPoint();
                    PlanRulerComponent.this.repaint();
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = mouseEvent.getPoint();
                    PlanRulerComponent.this.repaint();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    PlanRulerComponent.this.mouseLocation = null;
                    PlanRulerComponent.this.repaint();
                }
            };
            PlanComponent.this.addMouseListener(mouseInputAdapter);
            PlanComponent.this.addMouseMotionListener(mouseInputAdapter);
        }

        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            Rectangle2D rectangle2D = PlanComponent.this.getPlanBounds();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getAscent() + 6;
            if (this.orientation == 0) {
                return new Dimension(Math.round(((float)rectangle2D.getWidth() + 80.0f) * PlanComponent.this.getScale()) + insets.left + insets.right, n);
            }
            return new Dimension(n, Math.round(((float)rectangle2D.getHeight() + 80.0f) * PlanComponent.this.getScale()) + insets.top + insets.bottom);
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            this.paintBackground(graphics2D);
            Insets insets = this.getInsets();
            graphics2D.clipRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            Rectangle2D rectangle2D = PlanComponent.this.getPlanBounds();
            float f = PlanComponent.this.getScale();
            graphics2D.translate((double)insets.left + (40.0 - rectangle2D.getMinX()) * (double)f, (double)insets.top + (40.0 - rectangle2D.getMinY()) * (double)f);
            graphics2D.scale(f, f);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.paintRuler(graphics2D, f);
            graphics2D.dispose();
        }

        private void paintBackground(Graphics2D graphics2D) {
            if (this.isOpaque()) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        private void paintRuler(Graphics2D graphics2D, float f) {
            float f2;
            float f3 = PlanComponent.this.getGridSize(f);
            float f4 = PlanComponent.this.getMainGridSize(f);
            Rectangle2D rectangle2D = PlanComponent.this.getPlanBounds();
            float f5 = (float)rectangle2D.getMinX() - 40.0f;
            float f6 = (float)rectangle2D.getMinY() - 40.0f;
            float f7 = PlanComponent.this.convertXPixelToModel(this.getWidth());
            float f8 = PlanComponent.this.convertYPixelToModel(this.getHeight());
            boolean bl = this.getComponentOrientation().isLeftToRight();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getAscent();
            float f9 = 5.0f / f;
            float f10 = (float)(n + 6) / f;
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            graphics2D.setColor(this.getForeground());
            float f11 = 0.5f / f;
            graphics2D.setStroke(new BasicStroke(f11));
            if (this.orientation == 0) {
                graphics2D.draw(new Line2D.Float(f5, f8 - f11, f7, f8 - f11));
                for (f2 = (float)((int)(f5 / f3)) * f3; f2 < f7; f2 += f3) {
                    graphics2D.draw(new Line2D.Float(f2, f8 - f9, f2, f8));
                }
            } else {
                if (bl) {
                    graphics2D.draw(new Line2D.Float(f7 - f11, f6, f7 - f11, f8));
                } else {
                    graphics2D.draw(new Line2D.Float(f5 + f11, f6, f5 + f11, f8));
                }
                for (f2 = (float)((int)(f6 / f3)) * f3; f2 < f8; f2 += f3) {
                    if (bl) {
                        graphics2D.draw(new Line2D.Float(f7 - f9, f2, f7, f2));
                        continue;
                    }
                    graphics2D.draw(new Line2D.Float(f5, f2, f5 + f9, f2));
                }
            }
            if (f4 != f3) {
                graphics2D.setStroke(new BasicStroke(1.5f / f, 0, 2));
                AffineTransform affineTransform = graphics2D.getTransform();
                if (this.orientation == 0) {
                    for (float f12 = (float)((int)(f5 / f4)) * f4; f12 < f7; f12 += f4) {
                        graphics2D.draw(new Line2D.Float(f12, f8 - f10, f12, f8));
                        graphics2D.translate(f12, f8 - f10);
                        graphics2D.scale(1.0f / f, 1.0f / f);
                        graphics2D.drawString(this.getFormattedTickText(numberFormat, f12), 3, n - 1);
                        graphics2D.setTransform(affineTransform);
                    }
                } else {
                    for (float f13 = (float)((int)(f6 / f4)) * f4; f13 < f8; f13 += f4) {
                        String string = this.getFormattedTickText(numberFormat, f13);
                        if (bl) {
                            graphics2D.draw(new Line2D.Float(f7 - f10, f13, f7, f13));
                            graphics2D.translate(f7 - f10, f13);
                            graphics2D.scale(1.0f / f, 1.0f / f);
                            graphics2D.rotate(-1.5707963267948966);
                            graphics2D.drawString(string, -fontMetrics.stringWidth(string) - 3, n - 1);
                        } else {
                            graphics2D.draw(new Line2D.Float(f5, f13, f5 + f10, f13));
                            graphics2D.translate(f5 + f10, f13);
                            graphics2D.scale(1.0f / f, 1.0f / f);
                            graphics2D.rotate(1.5707963267948966);
                            graphics2D.drawString(string, 3, n - 1);
                        }
                        graphics2D.setTransform(affineTransform);
                    }
                }
            }
            if (this.mouseLocation != null) {
                graphics2D.setColor(PlanComponent.this.getSelectionColor());
                graphics2D.setStroke(new BasicStroke(1.0f / f));
                if (this.orientation == 0) {
                    float f14 = PlanComponent.this.convertXPixelToModel(this.mouseLocation.x);
                    graphics2D.draw(new Line2D.Float(f14, f8 - f10, f14, f8));
                } else {
                    float f15 = PlanComponent.this.convertYPixelToModel(this.mouseLocation.y);
                    if (bl) {
                        graphics2D.draw(new Line2D.Float(f7 - f10, f15, f7, f15));
                    } else {
                        graphics2D.draw(new Line2D.Float(f5, f15, f5 + f10, f15));
                    }
                }
            }
        }

        private String getFormattedTickText(NumberFormat numberFormat, float f) {
            String string;
            if ((double)Math.abs(f) < 1.0E-5) {
                f = 0.0f;
            }
            if (PlanComponent.this.preferences.getLengthUnit() == LengthUnit.INCH) {
                string = numberFormat.format(LengthUnit.centimeterToFoot(f)) + "'";
            } else {
                string = numberFormat.format(f / 100.0f);
                if (f == 0.0f) {
                    string = string + LengthUnit.METER.getName();
                }
            }
            return string;
        }
    }

    private static class SVGSupport {
        private SVGSupport() {
        }

        public static void exportToSVG(OutputStream outputStream, PlanComponent planComponent) throws IOException {
            List<Selectable> list = planComponent.getPaintedItems();
            Rectangle2D rectangle2D = planComponent.getItemsBounds(null, list);
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Float();
            }
            float f = 1.0f;
            float f2 = planComponent.getStrokeWidthExtraMargin(list);
            Dimension dimension = new Dimension((int)Math.ceil(rectangle2D.getWidth() * (double)f + (double)(2.0f * f2)), (int)Math.ceil(rectangle2D.getHeight() * (double)f + (double)(2.0f * f2)));
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(outputStream, dimension){

                public void writeHeader() throws IOException {
                    Locale locale = Locale.getDefault();
                    Locale.setDefault(Locale.ENGLISH);
                    super.writeHeader();
                    Locale.setDefault(locale);
                }
            };
            UserProperties userProperties = new UserProperties();
            userProperties.setProperty(SVGGraphics2D.STYLABLE, true);
            userProperties.setProperty(SVGGraphics2D.WRITE_IMAGES_AS, "PNG");
            userProperties.setProperty(SVGGraphics2D.TITLE, planComponent.home.getName() != null ? planComponent.home.getName() : "");
            userProperties.setProperty(SVGGraphics2D.FOR, System.getProperty("user.name", ""));
            sVGGraphics2D.setProperties((Properties)userProperties);
            sVGGraphics2D.startExport();
            sVGGraphics2D.translate(-rectangle2D.getMinX() + (double)f2, -rectangle2D.getMinY() + (double)f2);
            planComponent.checkCurrentThreadIsntInterrupted(PaintMode.EXPORT);
            planComponent.paintContent((Graphics2D)sVGGraphics2D, f, Color.WHITE, Color.BLACK, PaintMode.EXPORT);
            sVGGraphics2D.endExport();
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<PlanComponent> planComponent;

        public UserPreferencesChangeListener(PlanComponent planComponent) {
            this.planComponent = new WeakReference<PlanComponent>(planComponent);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PlanComponent planComponent = (PlanComponent)this.planComponent.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            UserPreferences.Property property = UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName());
            if (planComponent == null) {
                userPreferences.removePropertyChangeListener(property, this);
            } else {
                switch (property) {
                    case LANGUAGE: 
                    case UNIT: {
                        for (Map.Entry entry : planComponent.toolTipEditableTextFields.entrySet()) {
                            PlanComponent.updateToolTipTextFieldFormatterFactory((JFormattedTextField)entry.getValue(), (PlanController.EditableProperty)((Object)entry.getKey()), userPreferences);
                        }
                        if (planComponent.horizontalRuler != null) {
                            planComponent.horizontalRuler.repaint();
                        }
                        if (planComponent.verticalRuler == null) break;
                        planComponent.verticalRuler.repaint();
                        break;
                    }
                    case WALL_PATTERN: {
                        planComponent.wallsPatternImageCache = null;
                        break;
                    }
                    case FURNITURE_VIEWED_FROM_TOP: {
                        if (planComponent.furnitureTopViewIconsCache == null || userPreferences.isFurnitureViewedFromTop()) break;
                        planComponent.furnitureTopViewIconsCache = null;
                    }
                }
                planComponent.repaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        DELETE_SELECTION,
        ESCAPE,
        MOVE_SELECTION_LEFT,
        MOVE_SELECTION_UP,
        MOVE_SELECTION_DOWN,
        MOVE_SELECTION_RIGHT,
        MOVE_SELECTION_FAST_LEFT,
        MOVE_SELECTION_FAST_UP,
        MOVE_SELECTION_FAST_DOWN,
        MOVE_SELECTION_FAST_RIGHT,
        TOGGLE_MAGNETISM_ON,
        TOGGLE_MAGNETISM_OFF,
        ACTIVATE_DUPLICATION,
        DEACTIVATE_DUPLICATION,
        ACTIVATE_EDITIION,
        DEACTIVATE_EDITIION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PaintMode {
        PAINT,
        PRINT,
        CLIPBOARD,
        EXPORT;

    }
}

